/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
export var euiSelectableMessageStyles = function euiSelectableMessageStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiSelectableMessage: /*#__PURE__*/css("display:flex;flex-direction:column;justify-content:center;align-items:center;padding:", euiTheme.size.s, ";text-align:center;word-wrap:break-word;;label:euiSelectableMessage;"),
    // Match border from selectable_list
    bordered: /*#__PURE__*/css("overflow:hidden;border:", euiTheme.border.thin, ";border-radius:", euiTheme.border.radius.medium, ";;label:bordered;")
  };
};