function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["children", "className", "options", "popoverProps", "popoverTitle", "popoverFooter", "searchProps", "listProps", "isLoading", "popoverButton", "popoverButtonBreakpoints"],
  _excluded2 = ["closePopover", "panelRef", "width"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useMemo, useCallback } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useCombinedRefs, useCurrentEuiBreakpoint, useEuiMemoizedStyles } from '../../../services';
import { ENTER } from '../../../services/keys';
import { useEuiI18n, EuiI18n } from '../../i18n';
import { EuiPopoverTitle, EuiPopoverFooter } from '../../popover';
import { EuiPopover } from '../../popover/popover';
import { EuiLoadingSpinner } from '../../loading';
import { EuiSpacer } from '../../spacer';
import { EuiSelectable } from '../selectable';
import { EuiSelectableMessage } from '../selectable_message';
import { euiSelectableTemplateSitewideFormatOptions, euiSelectableTemplateSitewideRenderOptions } from './selectable_template_sitewide_option';
import { euiSelectableTemplateSitewideStyles } from './selectable_template_sitewide.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSelectableTemplateSitewide = function EuiSelectableTemplateSitewide(_ref) {
  var children = _ref.children,
    className = _ref.className,
    options = _ref.options,
    popoverProps = _ref.popoverProps,
    popoverTitle = _ref.popoverTitle,
    popoverFooter = _ref.popoverFooter,
    searchProps = _ref.searchProps,
    listProps = _ref.listProps,
    isLoading = _ref.isLoading,
    popoverButton = _ref.popoverButton,
    popoverButtonBreakpoints = _ref.popoverButtonBreakpoints,
    rest = _objectWithoutProperties(_ref, _excluded);
  /**
   * i18n text
   */
  var _useEuiI18n = useEuiI18n(['euiSelectableTemplateSitewide.searchPlaceholder'], ['Search for anything...']),
    _useEuiI18n2 = _slicedToArray(_useEuiI18n, 1),
    searchPlaceholder = _useEuiI18n2[0];

  /**
   * Popover helpers
   */
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    popoverRef = _useState2[0],
    setPopoverRef = _useState2[1];
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    popoverIsOpen = _useState4[0],
    setPopoverIsOpen = _useState4[1];
  var _popoverProps = _objectSpread({}, popoverProps),
    _closePopover = _popoverProps.closePopover,
    panelRef = _popoverProps.panelRef,
    width = _popoverProps.width,
    popoverRest = _objectWithoutProperties(_popoverProps, _excluded2);
  var closePopover = function closePopover() {
    setPopoverIsOpen(false);
    _closePopover && _closePopover();
  };
  var togglePopover = useCallback(function () {
    setPopoverIsOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);

  // Width applied to the internal div
  var popoverWidth = width || 600;
  var setPanelRef = useCombinedRefs([setPopoverRef, panelRef]);

  /**
   * Search helpers
   */
  var searchOnFocus = function searchOnFocus(e) {
    var _searchProps$onFocus;
    searchProps === null || searchProps === void 0 || (_searchProps$onFocus = searchProps.onFocus) === null || _searchProps$onFocus === void 0 || _searchProps$onFocus.call(searchProps, e);
    setPopoverIsOpen(true);
  };
  var onSearchInput = function onSearchInput(e) {
    var _searchProps$onInput;
    searchProps === null || searchProps === void 0 || (_searchProps$onInput = searchProps.onInput) === null || _searchProps$onInput === void 0 || _searchProps$onInput.call(searchProps, e);
    setPopoverIsOpen(true);
  };
  var onSearchKeydown = function onSearchKeydown(e) {
    var _searchProps$onKeyDow;
    searchProps === null || searchProps === void 0 || (_searchProps$onKeyDow = searchProps.onKeyDown) === null || _searchProps$onKeyDow === void 0 || _searchProps$onKeyDow.call(searchProps, e);
    if (e.key === ENTER) {
      setPopoverIsOpen(true);
    }
  };
  var searchOnBlur = function searchOnBlur(e) {
    var _searchProps$onBlur;
    searchProps === null || searchProps === void 0 || (_searchProps$onBlur = searchProps.onBlur) === null || _searchProps$onBlur === void 0 || _searchProps$onBlur.call(searchProps, e);
    if (!(popoverRef !== null && popoverRef !== void 0 && popoverRef.contains(e.relatedTarget))) {
      setPopoverIsOpen(false);
    }
  };

  /**
   * Classes & styles
   */
  var styles = useEuiMemoizedStyles(euiSelectableTemplateSitewideStyles);
  var classes = classNames('euiSelectableTemplateSitewide', className);
  var searchClasses = classNames('euiSelectableTemplateSitewide__search', searchProps && searchProps.className);
  var listClasses = classNames('euiSelectableTemplateSitewide__list', listProps && listProps.className);

  /**
   * List options
   */
  var formattedOptions = euiSelectableTemplateSitewideFormatOptions(options, styles);
  var loadingMessage = ___EmotionJSX(EuiSelectableMessage, {
    style: {
      minHeight: 300
    }
  }, ___EmotionJSX(EuiLoadingSpinner, {
    size: "l"
  }), ___EmotionJSX("br", null), ___EmotionJSX("p", null, ___EmotionJSX(EuiI18n, {
    token: "euiSelectableTemplateSitewide.loadingResults",
    default: "Loading results"
  })));
  var emptyMessage = ___EmotionJSX(EuiSelectableMessage, {
    style: {
      minHeight: 300
    }
  }, ___EmotionJSX("p", null, ___EmotionJSX(EuiI18n, {
    token: "euiSelectableTemplateSitewide.noResults",
    default: "No results available"
  })));

  /**
   * Changes based on showing the `popoverButton` if provided.
   * This will move the search input into the popover
   * and use the passed `popoverButton` as the popover trigger.
   */
  var currentBreakpoint = useCurrentEuiBreakpoint();
  var canShowPopoverButton = useMemo(function () {
    if (!popoverButtonBreakpoints) return true;
    if (!currentBreakpoint) return false;
    return popoverButtonBreakpoints.includes(currentBreakpoint);
  }, [currentBreakpoint, popoverButtonBreakpoints]);
  var popoverTrigger = useMemo(function () {
    if (!popoverButton || !canShowPopoverButton) return;
    return ___EmotionJSX("span", {
      className: "euiSelectableTemplateSitewide__popoverTrigger",
      onClick: togglePopover,
      onKeyDown: function onKeyDown(e) {
        return e.stopPropagation();
      }
    }, popoverButton);
  }, [popoverButton, canShowPopoverButton, togglePopover]);
  return ___EmotionJSX(EuiSelectable, _extends({
    css: styles.euiSelectableTemplateSitewide,
    className: classes,
    isLoading: isLoading,
    options: formattedOptions,
    renderOption: euiSelectableTemplateSitewideRenderOptions,
    singleSelection: true,
    searchProps: _objectSpread(_objectSpread({
      placeholder: searchPlaceholder,
      isClearable: true
    }, searchProps), {}, {
      onFocus: searchOnFocus,
      onBlur: searchOnBlur,
      onInput: onSearchInput,
      onKeyDown: onSearchKeydown,
      className: searchClasses
    }),
    listProps: _objectSpread(_objectSpread({
      rowHeight: 68,
      showIcons: false,
      onFocusBadge: {
        iconSide: 'right',
        children: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableTemplateSitewide.onFocusBadgeGoTo",
          default: "Go to"
        })
      }
    }, listProps), {}, {
      className: listClasses
    }),
    loadingMessage: loadingMessage,
    emptyMessage: emptyMessage,
    noMatchesMessage: emptyMessage
  }, rest, {
    searchable: true
  }), function (list, search) {
    return ___EmotionJSX(EuiPopover, _extends({
      panelPaddingSize: "none",
      isOpen: popoverIsOpen,
      ownFocus: !!popoverTrigger,
      display: popoverTrigger ? 'inline-block' : 'block'
    }, popoverRest, {
      panelRef: setPanelRef,
      button: popoverTrigger ? popoverTrigger : search,
      closePopover: closePopover
    }), ___EmotionJSX("div", {
      style: {
        width: popoverWidth,
        maxWidth: '100%'
      }
    }, popoverTitle || popoverTrigger ? ___EmotionJSX(EuiPopoverTitle, {
      paddingSize: "s"
    }, popoverTitle, popoverTitle && search && ___EmotionJSX(EuiSpacer, null), search) : undefined, list, popoverFooter && ___EmotionJSX(EuiPopoverFooter, {
      paddingSize: "s"
    }, popoverFooter)));
  });
};
EuiSelectableTemplateSitewide.propTypes = {
  /**
     * Extends the typical EuiSelectable #Options with the addition of pre-composed elements
     * such as `icon`, `avatar`and `meta`
     */
  options: PropTypes.arrayOf(PropTypes.shape({
    /**
       * Displayed on the left (`prepend`).
       * Object of `EuiIconProps` for display of the solution/application's logo
       */
    icon: PropTypes.shape({
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      css: PropTypes.any,
      /**
           * One of EUI's color palette or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value.
           * Note that coloring only works if your SVG is removed of fill attributes.
           */
      color: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.any.isRequired]),
      /**
           * Descriptive title for naming the icon based on its use
           */
      title: PropTypes.string,
      /**
           * A unique identifier for the title element
           */
      titleId: PropTypes.string,
      /**
           * Its value should be one or more element IDs
           */
      "aria-labelledby": PropTypes.string,
      /**
           * Callback when the icon has been loaded & rendered
           */
      onIconLoad: PropTypes.func
    }),
    /**
       * Displayed on the right (`append`).
       * Object of `EuiAvatarProps` for display of the space (default) or user
       */
    avatar: PropTypes.shape({
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      css: PropTypes.any,
      /**
             * Custom initials (max 2 characters).
             * By default will take the first character (of each word).
             */
      initials: PropTypes.string,
      /**
             * Specify how many characters to show (1 or 2).
             * By default, will show based on number of words (max first 2).
             */
      initialsLength: PropTypes.oneOf([1, 2]),
      /**
             * Path to an image to display instead of initials
             */
      imageUrl: PropTypes.string,
      /**
           * Any EUI glyph, logo or custom icon to display instead of initials
           */
      iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]),
      /**
           * Manually change icon size
           */
      iconSize: PropTypes.any,
      /**
           * Manually change icon color
           */
      iconColor: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.any.isRequired]).isRequired, PropTypes.oneOf([null])]),
      /**
           * Full name of avatar for title attribute and calculating initial if not provided
           */
      name: PropTypes.string.isRequired,
      /**
           * Accepts hex values like `#FFFFFF`, `#000` otherwise a viz palette color will be assigned.
           * Or pass `'plain'` for an empty shade, `'subdued'` for a light gray shade or `null` to remove entirely and the text/icon color will `inherit`
           */
      color: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.oneOf(["plain", "subdued", null])]),
      /**
           * The type of avatar mainly controlling the shape.
           * `user` = circle
           * `space` = rounded square
           */
      type: PropTypes.any,
      size: PropTypes.any,
      /**
           * Sets the letter casing of the displayed initials.
           * Defaults to `uppercase` for `type="user"` avatars.
           * Defaults to `none` (uses the existing casing of the passed `name` or `initials`) for `type="space"` avatars.
           * @default uppercase
           */
      casing: PropTypes.any,
      /**
           * Grays out the avatar to simulate being disabled
           */
      isDisabled: PropTypes.bool
    }),
    /**
       * An array of inline #MetaData displayed beneath the label and separated by bullets.
       */
    meta: PropTypes.arrayOf(PropTypes.shape({
      /**
         * Required to display the metadata
         */
      text: PropTypes.string.isRequired,
      /**
         * Styles the metadata according to Elastic's schema.
         * Can be one of 'application', 'deployment', 'article', 'case', 'platform',
         * or a custom string to associate with your own schema.
         * Appends the string to the class name as `euiSelectableTemplateSitewide__optionMeta--[type]`
         */
      type: PropTypes.oneOfType([PropTypes.oneOf(["application", "deployment", "article", "case", "platform"]), PropTypes.string.isRequired]),
      /**
         * Will wrap the meta tag in EuiHighlight to mark the portions that match the search text
         */
      highlightSearchString: PropTypes.bool,
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      css: PropTypes.any
    }).isRequired),
    /**
       * Optional `boolean`.
       * Set to `true` to indicate object is just a grouping label, not a selectable item
       */
    isGroupLabel: PropTypes.oneOfType([PropTypes.oneOf([true]).isRequired, PropTypes.oneOf([false])]),
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any,
    /**
       * Visible label of option.
       * Must be unique across items if `key` is not supplied
       */
    label: PropTypes.string,
    /**
       * Optionally change the searchable term by passing a different string other than the `label`.
       * Best used when creating a custom `optionRender` to separate the label from metadata but allowing to search on both
       */
    searchableLabel: PropTypes.string,
    /**
       * Must be unique across items.
       * Will be used to match options instead of `label`
       */
    key: PropTypes.string,
    /**
       * Leave `undefined` to indicate not selected. Pass a string of
       * 'on' to indicate inclusion, 'off' to indicate exclusion,
       * or 'mixed' to indicate inclusion for some.
       */
    checked: PropTypes.any,
    disabled: PropTypes.bool,
    /**
       * Node to add between the selection icon and the label
       */
    prepend: PropTypes.node,
    /**
       * Node to add to the far right of the item
       */
    append: PropTypes.node,
    ref: PropTypes.func,
    /**
       * Option data to pass through to the `renderOptions` element.
       * Bypass `EuiSelectableItem` and avoid DOM attribute warnings.
       */
    data: PropTypes.shape({}),
    /**
       * How to handle long text within the item.
       * Wrapping only works if `isVirtualization` is false.
       * @default 'truncate'
       */
    textWrap: PropTypes.oneOf(["truncate", "wrap"]),
    /**
       * If textWrap is set to `truncate`, you can pass a custom truncation configuration
       * that accepts any [EuiTextTruncate](/#/utilities/text-truncation) prop except for
       * `text` and `children`.
       *
       * Note: when searching, custom truncation props are ignored. The highlighted search
       * text will always take precedence.
       */
    truncationProps: PropTypes.any,
    /**
       * Optional custom tooltip content for the button
       */
    toolTipContent: PropTypes.node,
    /**
       * Optional props to pass to the underlying **[EuiToolTip](/#/display/tooltip)**
       */
    toolTipProps: PropTypes.any
  }).isRequired).isRequired,
  /**
     * Override some of the EuiPopover props housing the list.
     * The default width is `600`
     */
  popoverProps: PropTypes.shape({
    width: PropTypes.any
  }),
  /**
     * Optionally provide a title for the popover
     */
  popoverTitle: PropTypes.node,
  /**
     * Optionally provide a footer for the popover
     */
  popoverFooter: PropTypes.node,
  /**
     * Optionally provide a separate button for toggling the display of the popover.
     */
  popoverButton: PropTypes.element,
  /**
     * Pass an array of named breakpoints for which to show the `popoverButton`.
     * If `undefined`, the `popoverButton` will always show (if provided)
     */
  popoverButtonBreakpoints: PropTypes.arrayOf(PropTypes.any.isRequired)
};