function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiPaletteColorBlind, makeHighContrastColor } from '../../../services';
import { euiFontSize, logicalCSS } from '../../../global_styling';
var visColors = euiPaletteColorBlind();
var _ref = process.env.NODE_ENV === "production" ? {
  name: "q12130-euiSelectableTemplateSitewide__listItem",
  styles: "&:hover,&.euiSelectableListItem-isFocused{&:not([aria-disabled='true']){.euiSelectableListItem__text{text-decoration:none;}.euiSelectableTemplateSitewide__listItemTitle{text-decoration:underline;}}};label:euiSelectableTemplateSitewide__listItem;"
} : {
  name: "q12130-euiSelectableTemplateSitewide__listItem",
  styles: "&:hover,&.euiSelectableListItem-isFocused{&:not([aria-disabled='true']){.euiSelectableListItem__text{text-decoration:none;}.euiSelectableTemplateSitewide__listItemTitle{text-decoration:underline;}}};label:euiSelectableTemplateSitewide__listItem;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "rsb9r7-euiSelectableTemplateSitewide",
  styles: "display:block;label:euiSelectableTemplateSitewide;"
} : {
  name: "rsb9r7-euiSelectableTemplateSitewide",
  styles: "display:block;label:euiSelectableTemplateSitewide;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiSelectableTemplateSitewideStyles = function euiSelectableTemplateSitewideStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiSelectableTemplateSitewide: _ref2,
    // Override EuiSelectable's default item underline
    euiSelectableTemplateSitewide__listItem: _ref,
    euiSelectableTemplateSitewide__optionMetasList: /*#__PURE__*/css("display:block;", logicalCSS('margin-top', euiTheme.size.xs), " ", euiFontSize(euiThemeContext, 'xs'), " color:", euiTheme.colors.subduedText, ";;label:euiSelectableTemplateSitewide__optionMetasList;"),
    euiSelectableTemplateSitewide__optionMeta: /*#__PURE__*/css("&:not(:last-of-type)::after{content:'\u2022';", logicalCSS('margin-horizontal', euiTheme.size.xs), " color:", euiTheme.colors.subduedText, ";};label:euiSelectableTemplateSitewide__optionMeta;"),
    metaTypes: {
      fontWeight: "\n        font-weight: ".concat(euiTheme.font.weight.medium, ";\n      "),
      application: /*#__PURE__*/css("color:", makeHighContrastColor(visColors[1])(euiTheme), ";;label:application;"),
      deployment: /*#__PURE__*/css("color:", makeHighContrastColor(visColors[0])(euiTheme), ";;label:deployment;"),
      article: /*#__PURE__*/css("color:", makeHighContrastColor(visColors[3])(euiTheme), ";;label:article;"),
      case: /*#__PURE__*/css("color:", makeHighContrastColor(visColors[9])(euiTheme), ";;label:case;"),
      platform: /*#__PURE__*/css("color:", makeHighContrastColor(visColors[5])(euiTheme), ";;label:platform;")
    }
  };
};