function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiSideNav } from './side_nav';
import { EuiIcon } from '../icon';
import { htmlIdGenerator } from '../../services';
import { jsx as ___EmotionJSX } from "@emotion/react";
describe('EuiSideNav', function () {
  describe('Mobile EuiSideNav', function () {
    var MobileSideNav = function MobileSideNav() {
      var _useState = useState(false),
        _useState2 = _slicedToArray(_useState, 2),
        isSideNavOpenOnMobile = _useState2[0],
        setisSideNavOpenOnMobile = _useState2[1];
      var _toggleOpenOnMobile = function toggleOpenOnMobile() {
        setisSideNavOpenOnMobile(!isSideNavOpenOnMobile);
      };
      var basicSideNav = [{
        name: 'Root item',
        id: htmlIdGenerator('basicExample')(),
        items: [{
          name: 'Item with onClick',
          id: htmlIdGenerator('basicExample')()
        }, {
          name: 'Item with href',
          id: htmlIdGenerator('basicExample')(),
          href: '/#/navigation/side-nav'
        }, {
          name: 'Selected item',
          id: htmlIdGenerator('basicExample')(),
          isSelected: true
        }, {
          name: 'Disabled item',
          id: htmlIdGenerator('basicExample')(),
          disabled: true
        }]
      }];
      return ___EmotionJSX(EuiSideNav, {
        "aria-label": "Basic example",
        mobileTitle: "Basic example",
        toggleOpenOnMobile: function toggleOpenOnMobile() {
          return _toggleOpenOnMobile();
        },
        isOpenOnMobile: isSideNavOpenOnMobile,
        style: {
          width: 192
        },
        items: basicSideNav
      });
    };
    beforeEach(function () {
      cy.viewport(375, 667); // small breakpoint
      cy.mount(___EmotionJSX(MobileSideNav, null));
    });
    describe('Automated accessibility check', function () {
      it('has zero violations when mobile side nav is rendered', function () {
        cy.checkAxe();
      });
      it('has zero violations when mobile side nav is expanded', function () {
        cy.get('button').contains('Basic example').realClick();
        cy.get('div.euiSideNav__content').should('exist');
        cy.checkAxe();
      });
    });
  });
  describe('Simple EuiSideNav', function () {
    var SimpleSideNav = function SimpleSideNav() {
      var basicSideNav = [{
        name: 'Root item',
        id: htmlIdGenerator('basicExample')(),
        items: [{
          name: 'Item with onClick',
          id: htmlIdGenerator('basicExample')()
        }, {
          name: 'Item with href',
          id: htmlIdGenerator('basicExample')(),
          href: '/#/navigation/side-nav'
        }, {
          name: 'Selected item',
          id: htmlIdGenerator('basicExample')(),
          isSelected: true
        }, {
          name: 'Disabled item',
          id: htmlIdGenerator('basicExample')(),
          disabled: true
        }]
      }];
      return ___EmotionJSX(EuiSideNav, {
        "aria-label": "Basic example",
        style: {
          width: 192
        },
        items: basicSideNav
      });
    };
    beforeEach(function () {
      cy.viewport(768, 1024); // medium breakpoint
      cy.mount(___EmotionJSX(SimpleSideNav, null));
      cy.get('nav.euiSideNav').should('exist');
    });
    describe('Automated accessibility check', function () {
      it('has zero violations when rendered using non-mobile breakpoint', function () {
        cy.get('nav.euiSideNav').should('exist');
        cy.checkAxe();
      });
    });
  });
  describe('Nested EuiSideNav', function () {
    var NestedSideNav = function NestedSideNav() {
      var nestedSideNav = [{
        name: 'Kibana',
        id: 'kibana-1',
        icon: ___EmotionJSX(EuiIcon, {
          type: "logoKibana"
        }),
        isSelected: false,
        items: [{
          name: 'Has normal children',
          id: 'has-normal-children-1',
          isSelected: false
        }, {
          name: 'Normally not open',
          id: 'normally-not-open-1',
          isSelected: false,
          items: [{
            name: 'Open by override',
            id: 'open-by-override-1',
            isSelected: false,
            forceOpen: true,
            items: [{
              name: 'Child 3',
              id: 'child-3-1',
              isSelected: true
            }, {
              name: 'Child 4',
              id: 'child-4-1',
              isSelected: false
            }, {
              name: 'Child 5',
              id: 'child-5-1',
              isSelected: false
            }, {
              name: 'Child 6',
              id: 'child-6-1',
              isSelected: false,
              disabled: true
            }]
          }]
        }, {
          name: 'Has expanded children',
          id: 'has-expanded-children-1',
          isSelected: false,
          forceOpen: true,
          items: [{
            name: 'Child 7',
            id: 'child-7-1',
            isSelected: false
          }]
        }]
      }];
      return ___EmotionJSX(EuiSideNav, {
        "aria-label": "Force-open example",
        items: nestedSideNav,
        style: {
          width: 192
        }
      });
    };
    beforeEach(function () {
      cy.viewport(768, 1024); // medium breakpoint
      cy.mount(___EmotionJSX(NestedSideNav, null));
      cy.get('nav.euiSideNav').should('exist');
    });
    describe('Automated accessibility check', function () {
      it('has zero violations when complex side nav is rendered', function () {
        cy.checkAxe();
      });
    });
  });
  describe('Complex EuiSideNav', function () {
    var ComplexSideNav = function ComplexSideNav() {
      var complexSideNav = [{
        name: 'Elasticsearch',
        id: 'elasticsearch-1',
        icon: ___EmotionJSX(EuiIcon, {
          type: "logoElasticsearch"
        }),
        isSelected: false,
        items: [{
          name: 'Data sources',
          id: 'data-sources-1',
          isSelected: false
        }, {
          name: 'Users',
          id: 'users-1',
          isSelected: false
        }, {
          name: 'Roles',
          id: 'roles-1',
          isSelected: false
        }, {
          name: 'Watches',
          id: 'watches-1',
          isSelected: false
        }, {
          name: 'Extremely long title will become truncated when the browser is narrow enough',
          id: 'extremely-long-title-1',
          isSelected: false
        }]
      }, {
        name: 'Kibana',
        id: 'kibana-1',
        icon: ___EmotionJSX(EuiIcon, {
          type: "logoKibana"
        }),
        isSelected: false,
        items: [{
          name: 'Advanced settings',
          id: 'advanced-settings-1',
          isSelected: false,
          items: [{
            name: 'General',
            id: 'general-1',
            isSelected: false,
            disabled: true
          }, {
            name: 'Timelion',
            id: 'timelino-1',
            isSelected: false,
            items: [{
              name: 'Time stuff',
              id: 'time-stuff-1',
              icon: ___EmotionJSX(EuiIcon, {
                type: "clock"
              }),
              isSelected: true
            }, {
              name: 'Lion stuff',
              id: 'lion-stuff-1',
              icon: ___EmotionJSX(EuiIcon, {
                type: "stats"
              }),
              isSelected: false
            }]
          }, {
            name: 'Visualizations',
            id: 'visualizations-1',
            isSelected: false
          }]
        }, {
          name: 'Index patterns',
          id: 'index-patterns-1',
          isSelected: false
        }, {
          name: 'Saved objects',
          id: 'saved-objects-1',
          isSelected: false
        }, {
          name: 'Reporting',
          id: 'reporting-1',
          isSelected: false
        }]
      }, {
        name: 'Logstash',
        id: 'logstash-1',
        icon: ___EmotionJSX(EuiIcon, {
          type: "logoLogstash"
        }),
        isSelected: false,
        items: [{
          name: 'Pipeline viewer',
          id: 'data-sources-1',
          isSelected: false
        }]
      }];
      return ___EmotionJSX(EuiSideNav, {
        "aria-label": "Complex example",
        items: complexSideNav,
        style: {
          width: 192
        }
      });
    };
    beforeEach(function () {
      cy.viewport(768, 1024); // medium breakpoint
      cy.mount(___EmotionJSX(ComplexSideNav, null));
      cy.get('nav.euiSideNav').should('exist');
    });
    describe('Automated accessibility check', function () {
      it('has zero violations when complex side nav is rendered', function () {
        cy.checkAxe();
      });
    });
  });
});