var _excluded = ["id", "name", "isSelected", "items", "icon", "onClick", "href", "forceOpen"],
  _excluded2 = ["className", "items", "toggleOpenOnMobile", "isOpenOnMobile", "mobileTitle", "mobileBreakpoints", "renderItem", "truncate", "heading", "headingProps", "theme"];
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiButtonEmpty } from '../button';
import { EuiI18n } from '../i18n';
import { htmlIdGenerator, withEuiTheme } from '../../services';
import { EuiHideFor, EuiShowFor } from '../responsive';
import { EuiSideNavHeading } from './_side_nav_heading';
import { EuiSideNavItem } from './side_nav_item';
import { euiSideNavMobileStyles } from './side_nav.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSideNavClass = /*#__PURE__*/function (_Component) {
  function EuiSideNavClass() {
    var _this;
    _classCallCheck(this, EuiSideNavClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiSideNavClass, [].concat(args));
    _defineProperty(_this, "generateId", htmlIdGenerator('euiSideNav'));
    _defineProperty(_this, "isItemOpen", function (item) {
      // The developer can force the item to be open.
      if (item.forceOpen) {
        return true;
      }

      // Of course a selected item is open.
      if (item.isSelected) {
        return true;
      }

      // The item has to be open if it has a child that's open.
      if (item.items) {
        return item.items.some(_this.isItemOpen);
      }
      return false;
    });
    _defineProperty(_this, "renderTree", function (items) {
      var depth = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var _this$props = _this.props,
        renderItem = _this$props.renderItem,
        truncate = _this$props.truncate;
      return items.map(function (item) {
        var id = item.id,
          name = item.name,
          isSelected = item.isSelected,
          childItems = item.items,
          icon = item.icon,
          onClick = item.onClick,
          href = item.href,
          forceOpen = item.forceOpen,
          rest = _objectWithoutProperties(item, _excluded);

        // Root items are always open.
        var isOpen = depth === 0 ? true : _this.isItemOpen(item);
        var renderedItems;
        if (childItems) {
          renderedItems = _this.renderTree(childItems, depth + 1);
        }

        // Act as an accordion only if item is not linked but has children (and not the root)
        var childrenOnly = depth > 0 && !onClick && !href && !!childItems;
        return ___EmotionJSX(EuiSideNavItem, _extends({
          isOpen: isOpen,
          isSelected: !childrenOnly && isSelected,
          isParent: !!childItems,
          icon: icon,
          onClick: onClick,
          href: href,
          items: renderedItems,
          key: id,
          depth: depth,
          renderItem: renderItem,
          truncate: truncate,
          childrenOnly: childrenOnly
        }, rest), name);
      });
    });
    return _this;
  }
  _inherits(EuiSideNavClass, _Component);
  return _createClass(EuiSideNavClass, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        className = _this$props2.className,
        items = _this$props2.items,
        toggleOpenOnMobile = _this$props2.toggleOpenOnMobile,
        isOpenOnMobile = _this$props2.isOpenOnMobile,
        mobileTitle = _this$props2.mobileTitle,
        mobileBreakpoints = _this$props2.mobileBreakpoints,
        renderItem = _this$props2.renderItem,
        truncate = _this$props2.truncate,
        heading = _this$props2.heading,
        headingProps = _this$props2.headingProps,
        theme = _this$props2.theme,
        rest = _objectWithoutProperties(_this$props2, _excluded2);
      var classes = classNames('euiSideNav', className, {
        'euiSideNav-isOpenMobile': isOpenOnMobile
      });
      var styles = euiSideNavMobileStyles(theme);
      var contentClasses = classNames('euiSideNav__content');
      var sideNavContentId = this.generateId('content');
      var mobileContentStyles = [styles.content.euiSideNav__mobileContent, isOpenOnMobile ? styles.content.open : styles.content.hidden];
      var hasMobileVersion = mobileBreakpoints && mobileBreakpoints.length > 0;
      var mobileToggleText = mobileTitle || heading;
      var mobileHeadingUnset = {
        marginBlockEnd: 0,
        label: 'mobile'
      };
      var headingId = (headingProps === null || headingProps === void 0 ? void 0 : headingProps.id) || this.generateId('heading');
      var headingScreenReaderOnly = !!(headingProps !== null && headingProps !== void 0 && headingProps.screenReaderOnly);
      return ___EmotionJSX(React.Fragment, null, hasMobileVersion && ___EmotionJSX(EuiShowFor, {
        sizes: mobileBreakpoints || 'none'
      }, ___EmotionJSX("nav", _extends({
        "aria-labelledby": headingId,
        className: classes
      }, rest), ___EmotionJSX(EuiSideNavHeading, _extends({
        id: headingId
      }, headingProps, {
        screenReaderOnly: false,
        css: mobileHeadingUnset
      }), ___EmotionJSX(EuiI18n, {
        token: "euiSideNav.mobileToggleAriaLabel",
        default: "Toggle navigation"
      }, function (mobileToggleAriaLabel) {
        return ___EmotionJSX(EuiButtonEmpty, {
          className: "euiSideNav__mobileToggle",
          css: styles.euiSideNav__mobileToggle,
          contentProps: {
            className: 'euiSideNav__mobileToggleContent',
            css: styles.euiSideNav__mobileToggleContent
          },
          onClick: toggleOpenOnMobile,
          iconType: "apps",
          iconSide: "right",
          "aria-controls": sideNavContentId,
          "aria-expanded": isOpenOnMobile,
          "aria-label": !mobileToggleText || headingScreenReaderOnly ? mobileToggleAriaLabel : undefined
        }, !headingScreenReaderOnly && mobileToggleText);
      })), ___EmotionJSX("div", {
        id: sideNavContentId,
        className: contentClasses,
        css: mobileContentStyles
      }, this.renderTree(items)))), ___EmotionJSX(EuiHideFor, {
        sizes: mobileBreakpoints || 'none'
      }, ___EmotionJSX("nav", _extends({
        "aria-labelledby": heading ? headingId : undefined,
        className: classes
      }, rest), heading && ___EmotionJSX(EuiSideNavHeading, _extends({
        id: headingId
      }, headingProps), heading), ___EmotionJSX("div", {
        id: sideNavContentId,
        className: contentClasses
      }, this.renderTree(items)))));
    }
  }]);
}(Component);
_defineProperty(EuiSideNavClass, "defaultProps", {
  items: [],
  mobileBreakpoints: ['xs', 's']
});
EuiSideNavClass.propTypes = {
  /**
       * Class names to be merged into the final `className` property.
       */
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * Creates an associated heading element and uses the same node as default for `mobileTitle`
       */
  heading: PropTypes.node,
  /**
       * Adds a couple extra #EuiSideNavHeading props and extends the props of EuiTitle that wraps the `heading`
       */
  headingProps: PropTypes.any,
  /**
       * When called, toggles visibility of the navigation menu at mobile responsive widths. The callback should set the `isOpenOnMobile` prop to actually toggle navigation visibility.
       */
  toggleOpenOnMobile: PropTypes.func,
  /**
       * If `true`, the navigation menu will be open at mobile device widths. Use in conjunction with the `toggleOpenOnMobile` prop.
       */
  isOpenOnMobile: PropTypes.bool,
  /**
       * A React node to render at mobile responsive widths, representing the title of this navigation menu.
       */
  mobileTitle: PropTypes.node,
  /**
       * Array of breakpoint names for when to show the mobile version.
       * Set to `undefined` to remove responsive behavior
       */
  mobileBreakpoints: PropTypes.arrayOf(PropTypes.any.isRequired),
  /**
       *  An array of #EuiSideNavItem objects. Lists navigation menu items.
       */
  items: PropTypes.arrayOf(PropTypes.shape({
    /**
       * A value that is passed to React as the `key` for this item
       */
    id: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired]).isRequired,
    /**
       * If set to true it will force the item to display in an "open" state at all times.
       */
    forceOpen: PropTypes.bool,
    /**
       * Array containing additional item objects, representing nested children of this navigation item.
       */
    items: PropTypes.arrayOf(PropTypes.shape({
      /**
         * A value that is passed to React as the `key` for this item
         */
      id: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired]).isRequired,
      /**
         * If set to true it will force the item to display in an "open" state at all times.
         */
      forceOpen: PropTypes.bool,
      /**
         * Array containing additional item objects, representing nested children of this navigation item.
         */
      items: PropTypes.arrayOf(PropTypes.any.isRequired),
      /**
         * React node representing the text to render for this item (usually a string will suffice).
         */
      name: PropTypes.node.isRequired,
      /**
         * Function overriding default rendering for this navigation item — when called, it should return a React node representing a replacement navigation item.
         */
      renderItem: PropTypes.func
    }).isRequired),
    /**
       * React node representing the text to render for this item (usually a string will suffice).
       */
    name: PropTypes.node.isRequired,
    /**
       * Function overriding default rendering for this navigation item — when called, it should return a React node representing a replacement navigation item.
       */
    renderItem: PropTypes.func
  }).isRequired).isRequired,
  /**
       * Overrides default navigation menu item rendering. When called, it should return a React node representing a replacement navigation item.
       */
  renderItem: PropTypes.func,
  /**
       * Truncates the text of all items to stick to a single line
       */
  truncate: PropTypes.bool
};
export var EuiSideNav = withEuiTheme(EuiSideNavClass);