/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalSizeCSS, mathWithUnits } from '../../global_styling';
import { euiSkeletonGradientAnimation } from './utils';
export var euiSkeletonCircleStyles = function euiSkeletonCircleStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiSkeletonCircle: /*#__PURE__*/css("display:block;border-radius:50%;", euiSkeletonGradientAnimation(euiThemeContext, {
      slideSize: '-70%',
      gradientSize: '280%'
    }), ";;label:euiSkeletonCircle;"),
    // Sizes
    s: /*#__PURE__*/css(logicalSizeCSS(euiTheme.size.l), ";;label:s;"),
    m: /*#__PURE__*/css(logicalSizeCSS(euiTheme.size.xl), ";;label:m;"),
    l: /*#__PURE__*/css(logicalSizeCSS(euiTheme.size.xxl), ";;label:l;"),
    xl: /*#__PURE__*/css(logicalSizeCSS(mathWithUnits(euiTheme.size.base, function (x) {
      return x * 4;
    })), ";;label:xl;")
  };
};