var _excluded = ["isLoading", "contentAriaLabel", "loadingContent", "loadedContent", "announceLoadingStatus", "announceLoadedStatus", "ariaLiveProps"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import { EuiScreenReaderLive } from '../accessibility/screen_reader_live';
import { useEuiI18n } from '../i18n';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSkeletonLoading = function EuiSkeletonLoading(_ref) {
  var _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? true : _ref$isLoading,
    contentAriaLabel = _ref.contentAriaLabel,
    _loadingContent = _ref.loadingContent,
    loadedContent = _ref.loadedContent,
    _ref$announceLoadingS = _ref.announceLoadingStatus,
    announceLoadingStatus = _ref$announceLoadingS === void 0 ? false : _ref$announceLoadingS,
    _ref$announceLoadedSt = _ref.announceLoadedStatus,
    announceLoadedStatus = _ref$announceLoadedSt === void 0 ? true : _ref$announceLoadedSt,
    ariaLiveProps = _ref.ariaLiveProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var loadedAriaLive = useEuiI18n('euiSkeletonLoading.loadedAriaText', 'Loaded {contentAriaLabel}', {
    contentAriaLabel: contentAriaLabel
  });
  var loadingAriaLabel = useEuiI18n('euiSkeletonLoading.loadingAriaText', 'Loading {contentAriaLabel}', {
    contentAriaLabel: contentAriaLabel
  });
  var loadingProps = {
    'aria-label': loadingAriaLabel,
    role: 'progressbar'
  };
  var loadingContent = /*#__PURE__*/React.cloneElement(_loadingContent, loadingProps);
  return ___EmotionJSX("div", _extends({
    "aria-busy": isLoading,
    "data-test-subj": "euiSkeletonLoadingAriaWrapper"
  }, rest), isLoading ? ___EmotionJSX(React.Fragment, null, announceLoadingStatus && ___EmotionJSX(EuiScreenReaderLive, ariaLiveProps, loadingAriaLabel), loadingContent) : ___EmotionJSX(React.Fragment, null, announceLoadedStatus && ___EmotionJSX(EuiScreenReaderLive, ariaLiveProps, loadedAriaLive), loadedContent));
};
EuiSkeletonLoading.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * Content to display when loading
       */
  loadingContent: PropTypes.element.isRequired,
  /**
       * Content to display when loaded
       */
  loadedContent: PropTypes.any.isRequired
};