/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiFontSize, logicalCSS, mathWithUnits } from '../../global_styling';
import { euiSkeletonGradientAnimation } from './utils';
var calculateLineSize = function calculateLineSize(euiThemeContext, size) {
  var _euiFontSize = euiFontSize(euiThemeContext, 'm', {
      customScale: size
    }),
    fontSize = _euiFontSize.fontSize,
    lineHeight = _euiFontSize.lineHeight;
  return "\n    ".concat(logicalCSS('height', fontSize), "\n    ").concat(logicalCSS('margin-top', mathWithUnits([lineHeight, fontSize], function (x, y) {
    return x - y;
  })), "\n  ");
};
export var euiSkeletonTextStyles = function euiSkeletonTextStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiSkeletonText: /*#__PURE__*/css("display:block;", logicalCSS('width', '100%'), " border-radius:", euiTheme.border.radius.small, ";", euiSkeletonGradientAnimation(euiThemeContext), "transform:translateY(-25%);&:last-child:not(:only-child){", logicalCSS('width', '75%'), ";};label:euiSkeletonText;"),
    // Sizes
    m: /*#__PURE__*/css(calculateLineSize(euiThemeContext, 'm'), ";;label:m;"),
    s: /*#__PURE__*/css(calculateLineSize(euiThemeContext, 's'), ";;label:s;"),
    xs: /*#__PURE__*/css(calculateLineSize(euiThemeContext, 'xs'), ";;label:xs;"),
    relative: /*#__PURE__*/css(logicalCSS('height', '1em'), " ", logicalCSS('margin-top', '0.5em'), ";;label:relative;")
  };
};