var _excluded = ["isLoading", "size", "className", "contentAriaLabel", "announceLoadingStatus", "announceLoadedStatus", "ariaLiveProps", "ariaWrapperProps", "children"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiSkeletonLoading } from './skeleton_loading';
import { euiSkeletonTitleStyles } from './skeleton_title.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSkeletonTitle = function EuiSkeletonTitle(_ref) {
  var _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? true : _ref$isLoading,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    className = _ref.className,
    contentAriaLabel = _ref.contentAriaLabel,
    announceLoadingStatus = _ref.announceLoadingStatus,
    announceLoadedStatus = _ref.announceLoadedStatus,
    ariaLiveProps = _ref.ariaLiveProps,
    ariaWrapperProps = _ref.ariaWrapperProps,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = useEuiMemoizedStyles(euiSkeletonTitleStyles);
  var cssStyles = [styles.euiSkeletonTitle, styles[size]];
  return ___EmotionJSX(EuiSkeletonLoading, _extends({
    isLoading: isLoading,
    loadingContent: ___EmotionJSX("span", _extends({
      className: classNames('euiSkeletonTitle', className),
      css: cssStyles
    }, rest)),
    loadedContent: children || '',
    contentAriaLabel: contentAriaLabel,
    announceLoadingStatus: announceLoadingStatus,
    announceLoadedStatus: announceLoadedStatus,
    ariaLiveProps: ariaLiveProps
  }, ariaWrapperProps));
};
EuiSkeletonTitle.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * When true, shows the loading skeleton component.
     * When false, shows any `children` and announces to screen readers that your content has loaded.
     */
  isLoading: PropTypes.bool,
  /**
     * Label your loading sections to provide more helpful context to screen readers.
     * For example, pass "API keys" to have screen readers read "Loading API keys" and "Loaded API keys".
     */
  contentAriaLabel: PropTypes.string,
  /**
     * Makes a live screen reader announcement when `isLoading` is true
     * @default false
     */
  announceLoadingStatus: PropTypes.bool,
  /**
     * Makes a live screen reader announcement when `isLoading` is false
     * @default true
     */
  announceLoadedStatus: PropTypes.bool,
  /**
     * Optional props to pass to the `aria-live` region that announces the loading status to screen readers.
     * Accepts any `EuiScreenReaderLive` props.
     */
  ariaLiveProps: PropTypes.any,
  /**
     * Optional props to pass to the `aria-busy` wrapper around the skeleton content
     */
  ariaWrapperProps: PropTypes.any,
  /**
       * EuiTitle size to render
       */
  size: PropTypes.any
};