/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../global_styling';
import { euiTitle } from '../title/title.styles';
import { euiSkeletonGradientAnimation } from './utils';
export var euiSkeletonTitleStyles = function euiSkeletonTitleStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiSkeletonTitle: /*#__PURE__*/css("display:block;", logicalCSS('width', '45%'), " border-radius:", euiTheme.border.radius.medium, ";", euiSkeletonGradientAnimation(euiThemeContext), ";;label:euiSkeletonTitle;"),
    // Sizes
    l: /*#__PURE__*/css(logicalCSS('height', euiTitle(euiThemeContext, 'l').lineHeight), ";;label:l;"),
    m: /*#__PURE__*/css(logicalCSS('height', euiTitle(euiThemeContext, 'm').lineHeight), ";;label:m;"),
    s: /*#__PURE__*/css(logicalCSS('height', euiTitle(euiThemeContext, 's').lineHeight), ";;label:s;"),
    xs: /*#__PURE__*/css(logicalCSS('height', euiTitle(euiThemeContext, 'xs').lineHeight), ";;label:xs;"),
    xxs: /*#__PURE__*/css(logicalCSS('height', euiTitle(euiThemeContext, 'xxs').lineHeight), ";;label:xxs;"),
    xxxs: /*#__PURE__*/css(logicalCSS('height', euiTitle(euiThemeContext, 'xxxs').lineHeight), " border-radius:", euiTheme.border.radius.small, ";;label:xxxs;")
  };
};