/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { shade, tint } from '../../services';
import { euiCanAnimate, logicalCSS } from '../../global_styling';
import { euiAnimSlideX } from '../../global_styling/utility/animations';
export var euiSkeletonGradientAnimation = function euiSkeletonGradientAnimation(_ref) {
  var euiTheme = _ref.euiTheme,
    colorMode = _ref.colorMode;
  var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    _ref2$slideSize = _ref2.slideSize,
    slideSize = _ref2$slideSize === void 0 ? '-53%' : _ref2$slideSize,
    _ref2$gradientSize = _ref2.gradientSize,
    gradientSize = _ref2$gradientSize === void 0 ? '220%' : _ref2$gradientSize;
  var gradientStartStop = colorMode === 'DARK' ? shade(euiTheme.colors.lightShade, 0.12) : tint(euiTheme.colors.lightShade, 0.65);
  var gradientMiddle = colorMode === 'DARK' ? shade(euiTheme.colors.lightShade, 0.24) : tint(euiTheme.colors.lightShade, 0.8);
  return /*#__PURE__*/css("background-color:", gradientStartStop, ";", euiCanAnimate, "{overflow:hidden;isolation:isolate;&::after{content:'';display:block;", logicalCSS('width', gradientSize), " ", logicalCSS('height', '100%'), " background:linear-gradient(\n          137deg,\n          ", gradientStartStop, " 45%,\n          ", gradientMiddle, " 50%,\n          ", gradientStartStop, " 55%\n        );animation:", euiAnimSlideX(slideSize), " 1.5s ", euiTheme.animation.resistance, " infinite;}};label:euiSkeletonGradientAnimation;");
};