var _excluded = ["className", "children", "headingElement", "step", "title", "titleSize", "status"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import classNames from 'classnames';
import PropTypes from "prop-types";
import React, { createElement } from 'react';
import { EuiTitle } from '../title';
import { EuiStepNumber } from './step_number';
import { useEuiTheme } from '../../services';
import { euiStepStyles, euiStepContentStyles, euiStepTitleStyles } from './step.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiStep = function EuiStep(_ref) {
  var className = _ref.className,
    children = _ref.children,
    _ref$headingElement = _ref.headingElement,
    headingElement = _ref$headingElement === void 0 ? 'p' : _ref$headingElement,
    _ref$step = _ref.step,
    step = _ref$step === void 0 ? 1 : _ref$step,
    title = _ref.title,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 's' : _ref$titleSize,
    status = _ref.status,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiStep', className);
  var euiTheme = useEuiTheme();
  var styles = euiStepStyles(euiTheme);
  var cssStyles = [styles.euiStep, styles[titleSize]];
  var contentStyles = euiStepContentStyles(euiTheme);
  var cssContentStyles = [contentStyles.euiStep__content, contentStyles[titleSize]];
  var titleStyles = euiStepTitleStyles(euiTheme);
  var cssStepTitleStyles = [titleStyles.euiStep__title, status === 'disabled' && titleStyles.isDisabled, titleStyles[titleSize]];
  var cssTitleWrapperStyles = titleStyles.euiStep__titleWrapper;
  return ___EmotionJSX("div", _extends({
    className: classes,
    css: cssStyles
  }, rest), ___EmotionJSX("div", {
    className: "euiStep__titleWrapper",
    css: cssTitleWrapperStyles
  }, ___EmotionJSX(EuiStepNumber, {
    number: step,
    status: status,
    titleSize: titleSize === 'xxs' ? 'none' : titleSize
  }), ___EmotionJSX(EuiTitle, {
    size: titleSize === 'xxs' ? 'xs' : titleSize,
    className: "euiStep__title",
    css: cssStepTitleStyles
  }, /*#__PURE__*/createElement(headingElement, null, title))), ___EmotionJSX("div", {
    className: "euiStep__content",
    css: cssContentStyles
  }, children));
};
EuiStep.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.node.isRequired,
  /**
     * The HTML tag used for the title
     */
  headingElement: PropTypes.string,
  /**
     * The number of the step in the list of steps
     */
  step: PropTypes.number,
  title: PropTypes.string.isRequired,
  /**
     * May replace the number provided in props.step with alternate styling.
     */
  status: PropTypes.any,
  /**
     * Title sizing equivalent to **EuiTitle**, but only `m`, `s`, `xs` font sizes.
     * The `xxs` size reduces the size of the accompanying step indicator, but not the title itself.
     * @default s
     */
  titleSize: PropTypes.any
};