/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { makeHighContrastColor } from '../../services';
import { mathWithUnits, logicalCSS } from '../../global_styling';
export var euiStepVariables = function euiStepVariables(euiTheme) {
  return {
    numberSize: euiTheme.size.xl,
    numberXSSize: euiTheme.size.l,
    numberXXSSize: euiTheme.size.base,
    numberMargin: euiTheme.size.base
  };
};
export var euiStepStyles = function euiStepStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var euiStep = euiStepVariables(euiTheme);

  // the vertical line is centered on the number, so we need to offset the line
  // by half of the number size & half of the line size to center it
  var lineStartPosition = mathWithUnits([euiStep.numberSize, euiTheme.border.width.thick], function (x, y) {
    return x / 2 - y / 2;
  });
  var lineEndPosition = mathWithUnits([euiStep.numberSize, euiTheme.border.width.thick], function (x, y) {
    return x / 2 + y / 2;
  });
  var lineGradient = "linear-gradient(to right,\n    transparent 0,\n    transparent ".concat(lineStartPosition, ",\n    ").concat(euiTheme.border.color, " ").concat(lineStartPosition, ",\n    ").concat(euiTheme.border.color, " ").concat(lineEndPosition, ",\n    transparent ").concat(lineEndPosition, ",\n    transparent 100%)");
  return {
    euiStep: /*#__PURE__*/css("&:not(:last-of-type){background-image:", lineGradient, ";background-repeat:no-repeat;};label:euiStep;"),
    // Sizes
    m: /*#__PURE__*/css("&:not(:last-of-type){background-position:left ", euiStep.numberSize, ";};label:m;"),
    s: /*#__PURE__*/css("&:not(:last-of-type){background-position:left ", euiStep.numberSize, ";};label:s;"),
    xs: /*#__PURE__*/css("&:not(:last-of-type){background-position:-", euiTheme.size.xs, " ", euiStep.numberXSSize, ";};label:xs;"),
    xxs: /*#__PURE__*/css("&:not(:last-of-type){background-position:-", euiTheme.size.s, " ", euiStep.numberXXSSize, ";};label:xxs;")
  };
};
export var euiStepContentStyles = function euiStepContentStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var euiStep = euiStepVariables(euiTheme);
  return {
    euiStep__content: /*#__PURE__*/css(logicalCSS('margin-top', euiTheme.size.s), " ", logicalCSS('padding-top', euiTheme.size.base), " ", logicalCSS('padding-bottom', mathWithUnits([euiTheme.size.xl, euiTheme.size.s], function (x, y) {
      return x + y;
    })), " ", logicalCSS('padding-right', euiTheme.size.base), ";;label:euiStep__content;"),
    // Sizes
    m: /*#__PURE__*/css(logicalCSS('padding-left', mathWithUnits([euiStep.numberSize, euiStep.numberMargin], function (x, y) {
      return x / 2 + y;
    })), logicalCSS('margin-left', mathWithUnits(euiStep.numberSize, function (x) {
      return x / 2;
    })), ";;label:m;"),
    // `s` is the same as `m` - use a getter to duplicate its content
    get s() {
      return this.m;
    },
    xs: /*#__PURE__*/css(logicalCSS('padding-left', mathWithUnits([euiStep.numberXSSize, euiStep.numberMargin], function (x, y) {
      return x / 2 + y;
    })), logicalCSS('margin-left', mathWithUnits(euiStep.numberXSSize, function (x) {
      return x / 2;
    })), ";;label:xs;"),
    xxs: /*#__PURE__*/css(logicalCSS('padding-left', mathWithUnits([euiStep.numberXXSSize, euiStep.numberMargin], function (x, y) {
      return x / 2 + y;
    })), logicalCSS('margin-left', mathWithUnits(euiStep.numberXXSSize, function (x) {
      return x / 2;
    })), ";;label:xxs;")
  };
};
export var euiStepTitleStyles = function euiStepTitleStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var euiStep = euiStepVariables(euiTheme);
  return {
    euiStep__titleWrapper: /*#__PURE__*/css("display:flex;gap:", euiStep.numberMargin, ";;label:euiStep__titleWrapper;"),
    euiStep__title: /*#__PURE__*/css(";label:euiStep__title;"),
    isDisabled: /*#__PURE__*/css("color:", makeHighContrastColor(euiTheme.colors.disabledText)(euiTheme.colors.body), ";;label:isDisabled;"),
    // Sizes
    m: /*#__PURE__*/css(";label:m;"),
    s: /*#__PURE__*/css(logicalCSS('padding-top', euiTheme.size.xs), ";;label:s;"),
    xs: /*#__PURE__*/css(";label:xs;"),
    xxs: /*#__PURE__*/css("line-height:", euiStep.numberXXSSize, ";;label:xxs;")
  };
};