var _excluded = ["className", "status", "number", "titleSize"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import classNames from 'classnames';
import PropTypes from "prop-types";
import React from 'react';
import { EuiScreenReaderOnly } from '../accessibility';
import { EuiIcon } from '../icon';
import { EuiLoadingSpinner } from '../loading';
import { useEuiTheme } from '../../services';
import { useI18nCompleteStep, useI18nDisabledStep, useI18nErrorsStep, useI18nIncompleteStep, useI18nStep, useI18nWarningStep, useI18nLoadingStep, useI18nCurrentStep } from './step_strings';
import { euiStepNumberStyles, euiStepNumberContentStyles } from './step_number.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var STATUS = ['incomplete', 'disabled', 'loading', 'warning', 'danger', 'complete', 'current'];
export var EuiStepNumber = function EuiStepNumber(_ref) {
  var className = _ref.className,
    status = _ref.status,
    number = _ref.number,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 's' : _ref$titleSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var ariaLabelsMap = {
    step: useI18nStep({
      number: number
    }),
    current: useI18nCurrentStep({
      number: number
    }),
    incomplete: useI18nIncompleteStep({
      number: number
    }),
    complete: useI18nCompleteStep({
      number: number
    }),
    disabled: useI18nDisabledStep({
      number: number
    }),
    warning: useI18nWarningStep({
      number: number
    }),
    danger: useI18nErrorsStep({
      number: number
    }),
    loading: useI18nLoadingStep({
      number: number
    })
  };
  var classes = classNames('euiStepNumber', className);
  var euiTheme = useEuiTheme();
  var styles = euiStepNumberStyles(euiTheme);
  var cssStyles = [styles.euiStepNumber, styles[titleSize], status && styles[status]];
  var contentStyles = euiStepNumberContentStyles(euiTheme);
  var content;
  var screenReaderText;
  switch (status) {
    // Loading spinner
    case 'loading':
      {
        var iconSizeMap = {
          none: 'm',
          xs: 'l',
          s: 'xl',
          m: 'xl'
        };
        screenReaderText = ariaLabelsMap.loading;
        content = ___EmotionJSX(EuiLoadingSpinner, {
          className: "euiStepNumber__loader",
          size: iconSizeMap[titleSize]
        });
        break;
      }
    // Statuses with icons
    case 'danger':
    case 'warning':
    case 'complete':
      {
        var cssIconStyles = [contentStyles.euiStepNumber__icon, contentStyles[status],
        // EuiIcon does not support a xxs size so far,
        // we use custom sizing here instead
        titleSize === 'none' && contentStyles[titleSize]];
        var iconTypeMap = {
          danger: 'cross',
          warning: 'warning',
          complete: 'check'
        };
        var _iconSizeMap = {
          xxs: 's',
          xs: 's',
          s: 'm',
          m: 'm'
        };
        content = ___EmotionJSX(EuiIcon, {
          type: iconTypeMap[status],
          "aria-label": ariaLabelsMap[status],
          size: _iconSizeMap[titleSize],
          className: "euiStepNumber__icon",
          css: cssIconStyles
        });
        break;
      }
    // Statuses with numbers
    case 'incomplete':
    case 'current':
    case 'disabled':
    default:
      screenReaderText = ariaLabelsMap[status || 'step'];
      if (titleSize === 'none') {
        break;
      }
      var cssNumberStyles = [contentStyles.euiStepNumber__number, status && contentStyles[status]];
      content = ___EmotionJSX("span", {
        "aria-hidden": "true",
        className: "euiStepNumber__number",
        css: cssNumberStyles
      }, number);
      break;
  }
  return ___EmotionJSX("span", _extends({
    className: classes,
    css: cssStyles
  }, rest), screenReaderText && ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("span", null, screenReaderText)), content);
};
EuiStepNumber.propTypes = {
  /**
     * May replace the number provided in props.number with alternate styling
     */
  status: PropTypes.any,
  number: PropTypes.number,
  /**
     * Title sizing equivalent to EuiTitle, but only `m`, `s`, `xs`.
     * `none` indicates no step number should be rendered.
     * @default s
     */
  titleSize: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.oneOf(["none"])]),
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};