function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { mathWithUnits, logicalCSS, euiFontSizeFromScale, euiCanAnimate, euiAnimScale, logicalSizeCSS } from '../../global_styling';
import { euiStepVariables } from './step.styles';
import { euiButtonFillColor } from '../../themes/amsterdam/global_styling/mixins';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "76s2de-loading",
  styles: "background:transparent;label:loading;"
} : {
  name: "76s2de-loading",
  styles: "background:transparent;label:loading;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "1ru1jeq-euiStepNumber",
  styles: "flex-shrink:0;label:euiStepNumber;"
} : {
  name: "1ru1jeq-euiStepNumber",
  styles: "flex-shrink:0;label:euiStepNumber;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiStepNumberStyles = function euiStepNumberStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var euiStep = euiStepVariables(euiTheme);
  var createStepsNumber = function createStepsNumber(size, fontSize) {
    return "\n      display: inline-block;\n      line-height: ".concat(size, ";\n      border-radius: ").concat(size, ";\n      ").concat(logicalCSS('width', size), ";\n      ").concat(logicalCSS('height', size), ";\n      text-align: center;\n      color: ").concat(euiTheme.colors.emptyShade, ";\n      background-color: ").concat(euiTheme.colors.primary, ";\n      font-size: ").concat(fontSize, ";\n      font-weight: ").concat(euiTheme.font.weight.medium, ";\n    ");
  };
  return {
    euiStepNumber: _ref2,
    // sizes
    m: /*#__PURE__*/css(createStepsNumber(euiStep.numberSize, euiFontSizeFromScale('s', euiTheme)), ";;label:m;"),
    s: /*#__PURE__*/css(createStepsNumber(euiStep.numberSize, euiFontSizeFromScale('s', euiTheme)), ";;label:s;"),
    xs: /*#__PURE__*/css(createStepsNumber(euiStep.numberXSSize, euiFontSizeFromScale('xs', euiTheme)), ";;label:xs;"),
    none: /*#__PURE__*/css(createStepsNumber(euiStep.numberXXSSize, euiFontSizeFromScale('xs', euiTheme)), ";;label:none;"),
    // status
    incomplete: /*#__PURE__*/css("background-color:transparent;color:", euiTheme.colors.text, ";border:", euiTheme.border.thick, ";;label:incomplete;"),
    disabled: /*#__PURE__*/css(euiButtonFillColor(euiThemeContext, 'disabled'), ";;label:disabled;"),
    loading: _ref,
    warning: /*#__PURE__*/css(euiButtonFillColor(euiThemeContext, 'warning'), " ", euiCanAnimate, "{animation:", euiAnimScale, " ", euiTheme.animation.fast, " ", euiTheme.animation.bounce, ";};label:warning;"),
    danger: /*#__PURE__*/css(euiButtonFillColor(euiThemeContext, 'danger'), " ", euiCanAnimate, "{animation:", euiAnimScale, " ", euiTheme.animation.fast, " ", euiTheme.animation.bounce, ";};label:danger;"),
    complete: /*#__PURE__*/css(euiButtonFillColor(euiThemeContext, 'success'), " ", euiCanAnimate, "{animation:", euiAnimScale, " ", euiTheme.animation.fast, " ", euiTheme.animation.bounce, ";};label:complete;"),
    current: /*#__PURE__*/css("border:", euiTheme.border.width.thick, " solid ", euiTheme.colors.body, ";box-shadow:0 0 0 ", euiTheme.border.width.thick, " ", euiTheme.colors.primary, ";;label:current;")
  };
};
export var euiStepNumberContentStyles = function euiStepNumberContentStyles(_ref3) {
  var euiTheme = _ref3.euiTheme;
  return {
    // Statuses with icon content
    euiStepNumber__icon: /*#__PURE__*/css("vertical-align:middle;position:relative;inset-block-start:-", euiTheme.border.width.thin, ";;label:euiStepNumber__icon;"),
    complete: /*#__PURE__*/css("stroke:currentColor;stroke-width:", mathWithUnits(euiTheme.border.width.thin, function (x) {
      return x / 2;
    }), ";;label:complete;"),
    danger: /*#__PURE__*/css("stroke:currentColor;stroke-width:", mathWithUnits(euiTheme.border.width.thin, function (x) {
      return x / 2;
    }), ";;label:danger;"),
    warning: /*#__PURE__*/css("inset-block-start:-", euiTheme.border.width.thick, ";;label:warning;"),
    // Statuses with number content
    euiStepNumber__number: /*#__PURE__*/css(";label:euiStepNumber__number;"),
    incomplete: /*#__PURE__*/css("display:unset;position:relative;inset-block-start:-", euiTheme.border.width.thick, ";;label:incomplete;"),
    loading: /*#__PURE__*/css(";label:loading;"),
    disabled: /*#__PURE__*/css(";label:disabled;"),
    current: /*#__PURE__*/css("display:inline-block;transform:translateY(-", euiTheme.border.width.thick, ");;label:current;"),
    none: /*#__PURE__*/css(logicalSizeCSS(euiTheme.size.s), ";label:none;")
  };
};