var _excluded = ["className", "children", "title", "status"],
  _excluded2 = ["className", "firstStepNumber", "headingElement", "titleSize", "steps"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
import PropTypes from "prop-types";
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { EuiStep } from './step';
import { jsx as ___EmotionJSX } from "@emotion/react";
function renderSteps(steps, firstStepNumber, headingElement, titleSize) {
  return steps.map(function (step, index) {
    var className = step.className,
      children = step.children,
      title = step.title,
      status = step.status,
      rest = _objectWithoutProperties(step, _excluded);
    return ___EmotionJSX(EuiStep, _extends({
      className: className,
      key: index,
      headingElement: headingElement,
      step: firstStepNumber + index,
      title: title,
      titleSize: titleSize,
      status: status
    }, rest), children);
  });
}
export var EuiSteps = function EuiSteps(_ref) {
  var className = _ref.className,
    _ref$firstStepNumber = _ref.firstStepNumber,
    firstStepNumber = _ref$firstStepNumber === void 0 ? 1 : _ref$firstStepNumber,
    _ref$headingElement = _ref.headingElement,
    headingElement = _ref$headingElement === void 0 ? 'p' : _ref$headingElement,
    titleSize = _ref.titleSize,
    steps = _ref.steps,
    rest = _objectWithoutProperties(_ref, _excluded2);
  var classes = classNames('euiSteps', className);
  return ___EmotionJSX("div", _extends({
    className: classes
  }, rest), renderSteps(steps, firstStepNumber, headingElement, titleSize));
};
EuiSteps.propTypes = {
  /**
     * An array of `EuiStep` objects excluding the `step` prop
     */
  steps: PropTypes.arrayOf(PropTypes.any.isRequired).isRequired,
  /**
     * The number the steps should begin from
     */
  firstStepNumber: PropTypes.number,
  /**
     * The HTML tag used for the title
     */
  headingElement: PropTypes.string,
  /**
     * Title sizing equivalent to **EuiTitle**, but only `m`, `s`, `xs` font sizes.
     * The `xxs` size reduces the size of the accompanying step indicator, but not the title itself.
     * @default s
     */
  titleSize: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};