var _excluded = ["className", "steps", "size"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import classNames from 'classnames';
import PropTypes from "prop-types";
import React from 'react';
import { EuiStepHorizontal } from './step_horizontal';
import { euiStepsHorizontalStyles } from './steps_horizontal.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['xs', 's', 'm'];
export var EuiStepsHorizontal = function EuiStepsHorizontal(_ref) {
  var className = _ref.className,
    steps = _ref.steps,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiStepsHorizontal', className);
  var styles = euiStepsHorizontalStyles();
  var cssStyles = styles.euiStepsHorizontal;
  var cssItemStyles = styles.euiStepsHorizontal__item;
  return ___EmotionJSX("ol", _extends({
    className: classes,
    css: cssStyles
  }, rest), steps.map(function (stepProps, index) {
    return ___EmotionJSX("li", {
      key: index,
      className: "euiStepsHorizontal__item",
      css: cssItemStyles,
      "aria-current": stepProps.status === 'current' ? 'step' : undefined
    }, ___EmotionJSX(EuiStepHorizontal, _extends({
      step: index + 1,
      size: size
    }, stepProps)));
  }));
};
EuiStepsHorizontal.propTypes = {
  /**
     * An array of `EuiStepHorizontal` objects excluding the `step` prop
     */
  steps: PropTypes.arrayOf(PropTypes.any.isRequired).isRequired,
  size: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};