var _excluded = ["children", "className", "align", "textOnly", "truncateText", "hasActions"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { LEFT_ALIGNMENT, useEuiMemoizedStyles } from '../../services';
import { isObject } from '../../services/predicate';
import { EuiTextBlockTruncate } from '../text_truncate';
import { useEuiTableIsResponsive } from './mobile/responsive_context';
import { euiTableCellContentStyles } from './_table_cell_content.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTableCellContent = function EuiTableCellContent(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$align = _ref.align,
    align = _ref$align === void 0 ? LEFT_ALIGNMENT : _ref$align,
    textOnly = _ref.textOnly,
    _ref$truncateText = _ref.truncateText,
    truncateText = _ref$truncateText === void 0 ? false : _ref$truncateText,
    hasActions = _ref.hasActions,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isResponsive = useEuiTableIsResponsive();
  var styles = useEuiMemoizedStyles(euiTableCellContentStyles);
  var cssStyles = [styles.euiTableCellContent, styles[align], truncateText === true && styles.truncateText, truncateText === false && styles.wrapText].concat(_toConsumableArray(hasActions ? [styles.hasActions.actions, !isResponsive && styles.hasActions.desktop, isResponsive && hasActions !== 'custom' && styles.hasActions.mobile] : []));
  var classes = classNames('euiTableCellContent', className);
  var renderedChildren = useMemo(function () {
    var textClasses = 'euiTableCellContent__text';
    if (isObject(truncateText) && truncateText.lines) {
      return ___EmotionJSX(EuiTextBlockTruncate, {
        lines: truncateText.lines,
        cloneElement: true
      }, ___EmotionJSX("span", {
        className: textClasses
      }, children));
    }
    if (textOnly === true || truncateText === true) {
      return ___EmotionJSX("span", {
        className: textClasses
      }, children);
    }
    return children;
  }, [children, textOnly, truncateText]);
  return ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), renderedChildren);
};
EuiTableCellContent.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  truncateText: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
    lines: PropTypes.number.isRequired
  }).isRequired]).isRequired, PropTypes.oneOf([null])])
};