var _excluded = ["children", "className", "compressed", "tableLayout", "responsiveBreakpoint"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { useIsEuiTableResponsive, EuiTableIsResponsiveContext } from './mobile/responsive_context';
import { euiTableStyles } from './table.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTable = function EuiTable(_ref) {
  var children = _ref.children,
    className = _ref.className,
    compressed = _ref.compressed,
    _ref$tableLayout = _ref.tableLayout,
    tableLayout = _ref$tableLayout === void 0 ? 'fixed' : _ref$tableLayout,
    responsiveBreakpoint = _ref.responsiveBreakpoint,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isResponsive = useIsEuiTableResponsive(responsiveBreakpoint);
  var classes = classNames('euiTable', className);
  var styles = useEuiMemoizedStyles(euiTableStyles);
  var cssStyles = [styles.euiTable, styles.layout[tableLayout], (!compressed || isResponsive) && styles.uncompressed, compressed && !isResponsive && styles.compressed, isResponsive ? styles.mobile : styles.desktop];
  return ___EmotionJSX("table", _extends({
    tabIndex: -1,
    css: cssStyles,
    className: classes
  }, rest), ___EmotionJSX(EuiTableIsResponsiveContext.Provider, {
    value: isResponsive
  }, children));
};
EuiTable.propTypes = {
  compressed: PropTypes.bool,
  /**
     * Named breakpoint. Below this size, the table will collapse
     * into responsive cards.
     *
     * Pass `false` to never collapse to a mobile view, or inversely,
     * `true` to always render mobile-friendly cards.
     *
     * @default m
     */
  responsiveBreakpoint: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.bool.isRequired]),
  /**
     * Sets the table-layout CSS property
     */
  tableLayout: PropTypes.oneOf(["fixed", "auto"]),
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};