var _excluded = ["children", "align", "className", "width", "style"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles, LEFT_ALIGNMENT } from '../../services';
import { resolveWidthAsStyle } from './utils';
import { EuiTableCellContent } from './_table_cell_content';
import { euiTableHeaderFooterCellStyles } from './table_cells_shared.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTableFooterCell = function EuiTableFooterCell(_ref) {
  var children = _ref.children,
    _ref$align = _ref.align,
    align = _ref$align === void 0 ? LEFT_ALIGNMENT : _ref$align,
    className = _ref.className,
    width = _ref.width,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiTableFooterCell', className);
  var inlineStyles = resolveWidthAsStyle(style, width);
  var styles = useEuiMemoizedStyles(euiTableHeaderFooterCellStyles);
  return ___EmotionJSX("td", _extends({
    css: styles.euiTableFooterCell,
    className: classes,
    style: inlineStyles
  }, rest), ___EmotionJSX(EuiTableCellContent, {
    align: align,
    truncateText: true,
    textOnly: true
  }, children));
};
EuiTableFooterCell.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  align: PropTypes.any,
  width: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired])
};