var _excluded = ["children", "align", "onSort", "isSorted", "isSortAscending", "className", "scope", "mobileOptions", "width", "style", "readOnly", "description", "append"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles, LEFT_ALIGNMENT } from '../../services';
import { EuiI18n } from '../i18n';
import { EuiScreenReaderOnly } from '../accessibility';
import { EuiIcon } from '../icon';
import { EuiInnerText } from '../inner_text';
import { resolveWidthAsStyle } from './utils';
import { useEuiTableIsResponsive } from './mobile/responsive_context';
import { EuiTableCellContent } from './_table_cell_content';
import { euiTableHeaderFooterCellStyles } from './table_cells_shared.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var CellContents = function CellContents(_ref) {
  var className = _ref.className,
    align = _ref.align,
    description = _ref.description,
    children = _ref.children,
    canSort = _ref.canSort,
    isSorted = _ref.isSorted,
    isSortAscending = _ref.isSortAscending;
  return ___EmotionJSX(EuiTableCellContent, {
    className: className,
    align: align,
    textOnly: false,
    truncateText: null
  }, ___EmotionJSX(EuiInnerText, null, function (ref, innerText) {
    return ___EmotionJSX(EuiI18n, {
      token: "euiTableHeaderCell.titleTextWithDesc",
      default: "{innerText}; {description}",
      values: {
        innerText: innerText,
        description: description
      }
    }, function (titleTextWithDesc) {
      return ___EmotionJSX("span", {
        title: description ? titleTextWithDesc : innerText,
        ref: ref,
        className: "eui-textTruncate"
      }, children);
    });
  }), description && ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("span", null, description)), isSorted ? ___EmotionJSX(EuiIcon, {
    className: "euiTableSortIcon",
    type: isSortAscending ? 'sortUp' : 'sortDown',
    size: "m"
  }) : canSort ? ___EmotionJSX(EuiIcon, {
    className: "euiTableSortIcon euiTableSortIcon--sortable",
    type: "sortable",
    size: "m",
    color: "subdued" // Tinted a bit further via CSS
  }) : null);
};
export var EuiTableHeaderCell = function EuiTableHeaderCell(_ref2) {
  var children = _ref2.children,
    _ref2$align = _ref2.align,
    align = _ref2$align === void 0 ? LEFT_ALIGNMENT : _ref2$align,
    onSort = _ref2.onSort,
    isSorted = _ref2.isSorted,
    isSortAscending = _ref2.isSortAscending,
    className = _ref2.className,
    scope = _ref2.scope,
    mobileOptions = _ref2.mobileOptions,
    width = _ref2.width,
    style = _ref2.style,
    readOnly = _ref2.readOnly,
    description = _ref2.description,
    append = _ref2.append,
    rest = _objectWithoutProperties(_ref2, _excluded);
  var styles = useEuiMemoizedStyles(euiTableHeaderFooterCellStyles);
  var isResponsive = useEuiTableIsResponsive();
  var hideForDesktop = !isResponsive && (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.only);
  var hideForMobile = isResponsive && (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.show) === false;
  if (hideForDesktop || hideForMobile) return null;
  var classes = classNames('euiTableHeaderCell', className);
  var inlineStyles = resolveWidthAsStyle(style, width);
  var CellComponent = children ? 'th' : 'td';
  var cellScope = CellComponent === 'th' ? scope !== null && scope !== void 0 ? scope : 'col' : undefined; // `scope` is only valid on `th` elements

  var canSort = !!(onSort && !readOnly);
  var ariaSortValue;
  if (isSorted) {
    ariaSortValue = isSortAscending ? 'ascending' : 'descending';
  } else if (canSort) {
    ariaSortValue = 'none';
  }
  var cellContentsProps = {
    css: styles.euiTableHeaderCell__content,
    align: align,
    description: description,
    canSort: canSort,
    isSorted: isSorted,
    isSortAscending: isSortAscending,
    children: children
  };
  return ___EmotionJSX(CellComponent, _extends({
    css: styles.euiTableHeaderCell,
    className: classes,
    scope: cellScope,
    role: "columnheader",
    "aria-sort": ariaSortValue,
    style: inlineStyles
  }, rest), canSort ? ___EmotionJSX("button", {
    type: "button",
    css: styles.euiTableHeaderCell__button,
    className: classNames('euiTableHeaderButton', {
      'euiTableHeaderButton-isSorted': isSorted
    }),
    onClick: onSort,
    "data-test-subj": "tableHeaderSortButton"
  }, ___EmotionJSX(CellContents, cellContentsProps)) : ___EmotionJSX(CellContents, cellContentsProps), append);
};
EuiTableHeaderCell.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  align: PropTypes.any,
  isSortAscending: PropTypes.bool,
  isSorted: PropTypes.bool,
  mobileOptions: PropTypes.any,
  onSort: PropTypes.func,
  scope: PropTypes.any,
  width: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired]),
  description: PropTypes.string,
  /**
       * Shows the sort indicator but removes the button
       */
  readOnly: PropTypes.bool,
  /**
       * Content rendered outside the visible cell content wrapper. Useful for, e.g. screen reader text.
       *
       * Used by EuiBasicTable to render hidden copy markers
       */
  append: PropTypes.node
};