var _excluded = ["activePage", "itemsPerPage", "itemsPerPageOptions", "showPerPageOptions", "onChangeItemsPerPage", "onChangePage", "pageCount"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useMemo, useCallback } from 'react';
import PropTypes from "prop-types";
import { EuiButtonEmpty } from '../../button';
import { EuiContextMenuItem, EuiContextMenuPanel } from '../../context_menu';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiPagination } from '../../pagination';
import { EuiPopover } from '../../popover';
import { EuiI18n } from '../../i18n';
import { usePropsWithComponentDefaults } from '../../provider/component_defaults';
import { euiTablePaginationDefaults } from './table_pagination_defaults';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTablePagination = function EuiTablePagination(props) {
  var _usePropsWithComponen = usePropsWithComponentDefaults('EuiTablePagination', props),
    activePage = _usePropsWithComponen.activePage,
    _usePropsWithComponen2 = _usePropsWithComponen.itemsPerPage,
    itemsPerPage = _usePropsWithComponen2 === void 0 ? euiTablePaginationDefaults.itemsPerPage : _usePropsWithComponen2,
    _usePropsWithComponen3 = _usePropsWithComponen.itemsPerPageOptions,
    itemsPerPageOptions = _usePropsWithComponen3 === void 0 ? euiTablePaginationDefaults.itemsPerPageOptions : _usePropsWithComponen3,
    _usePropsWithComponen4 = _usePropsWithComponen.showPerPageOptions,
    showPerPageOptions = _usePropsWithComponen4 === void 0 ? euiTablePaginationDefaults.showPerPageOptions : _usePropsWithComponen4,
    onChangeItemsPerPage = _usePropsWithComponen.onChangeItemsPerPage,
    onChangePage = _usePropsWithComponen.onChangePage,
    pageCount = _usePropsWithComponen.pageCount,
    rest = _objectWithoutProperties(_usePropsWithComponen, _excluded);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var togglePopover = useCallback(function () {
    setIsPopoverOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var closePopover = useCallback(function () {
    setIsPopoverOpen(false);
  }, []);
  var button = ___EmotionJSX(EuiButtonEmpty, {
    size: "xs",
    color: "text",
    iconType: "arrowDown",
    iconSide: "right",
    "data-test-subj": "tablePaginationPopoverButton",
    onClick: togglePopover
  }, itemsPerPage === 0 ? ___EmotionJSX(EuiI18n, {
    token: "euiTablePagination.allRows",
    default: "Showing all rows"
  }) : ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiI18n, {
    token: "euiTablePagination.rowsPerPage",
    default: "Rows per page"
  }), ": ", itemsPerPage));
  var items = useMemo(function () {
    return itemsPerPageOptions.map(function (itemsPerPageOption) {
      return ___EmotionJSX(EuiContextMenuItem, {
        key: itemsPerPageOption,
        icon: itemsPerPageOption === itemsPerPage ? 'check' : 'empty',
        "aria-current": itemsPerPageOption === itemsPerPage ? 'true' : undefined,
        onClick: function onClick() {
          closePopover();
          onChangeItemsPerPage === null || onChangeItemsPerPage === void 0 || onChangeItemsPerPage(itemsPerPageOption);
        },
        "data-test-subj": "tablePagination-".concat(itemsPerPageOption, "-rows")
      }, itemsPerPageOption === 0 ? ___EmotionJSX(EuiI18n, {
        token: "euiTablePagination.rowsPerPageOptionShowAllRows",
        default: "Show all rows"
      }) : ___EmotionJSX(EuiI18n, {
        token: "euiTablePagination.rowsPerPageOption",
        values: {
          rowsPerPage: itemsPerPageOption
        },
        default: "{rowsPerPage} rows"
      }));
    });
  }, [itemsPerPageOptions, itemsPerPage, onChangeItemsPerPage, closePopover]);
  var itemsPerPagePopover = ___EmotionJSX(EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "upRight"
  }, ___EmotionJSX(EuiContextMenuPanel, {
    items: items,
    "data-test-subj": "tablePaginationRowOptions"
  }));
  return ___EmotionJSX(EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false,
    wrap: true,
    gutterSize: "s",
    className: "eui-xScroll"
  }, ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, showPerPageOptions && itemsPerPagePopover), ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, itemsPerPage > 0 && ___EmotionJSX(EuiPagination, _extends({
    pageCount: pageCount,
    activePage: activePage,
    onPageClick: onChangePage
  }, rest))));
};
EuiTablePagination.propTypes = {
  /**
     * Option to completely hide the "Rows per page" selector.
     *
     * @default true
     */
  showPerPageOptions: PropTypes.bool,
  /**
     * Current selection for "Rows per page".
     * Pass `0` to display the selected "Show all" option and hide the pagination.
     *
     * @default 10
     */
  itemsPerPage: PropTypes.number,
  /**
     * Custom array of options for "Rows per page".
     * Pass `0` as one of the options to create a "Show all" option.
     *
     * @default [10, 25, 50]
     */
  itemsPerPageOptions: PropTypes.arrayOf(PropTypes.number.isRequired),
  /**
     * Click handler that passes back selected `pageSize` number
     */
  onChangeItemsPerPage: PropTypes.func,
  onChangePage: PropTypes.func,
  /**
     * Requires the `id` of the table being controlled
     */
  "aria-controls": PropTypes.string,
  "aria-label": PropTypes.string
};