var _excluded = ["children", "className", "hasSelection", "isSelected", "isSelectable", "hasActions", "isExpandedRow", "isExpandable", "onClick"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { keys, useEuiMemoizedStyles } from '../../services';
import { useEuiTableIsResponsive } from './mobile/responsive_context';
import { euiTableRowStyles } from './table_row.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTableRow = function EuiTableRow(_ref) {
  var children = _ref.children,
    className = _ref.className,
    hasSelection = _ref.hasSelection,
    isSelected = _ref.isSelected,
    isSelectable = _ref.isSelectable,
    hasActions = _ref.hasActions,
    isExpandedRow = _ref.isExpandedRow,
    isExpandable = _ref.isExpandable,
    onClick = _ref.onClick,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isResponsive = useEuiTableIsResponsive();
  var styles = useEuiMemoizedStyles(euiTableRowStyles);
  var cssStyles = isResponsive ? [styles.euiTableRow, styles.mobile.mobile, isSelected && styles.mobile.selected, isExpandedRow && styles.mobile.expanded, (hasActions === true || isExpandable || isExpandedRow) && styles.mobile.hasRightColumn, hasSelection && styles.mobile.hasLeftColumn] : [styles.euiTableRow, styles.desktop.desktop, isSelected && styles.desktop.selected, isExpandedRow && styles.desktop.expanded, onClick && styles.desktop.clickable, isExpandedRow && hasSelection && styles.desktop.checkboxOffset];
  var classes = classNames('euiTableRow', className, {
    'euiTableRow-isSelectable': isSelectable,
    'euiTableRow-isSelected': isSelected,
    'euiTableRow-hasActions': hasActions,
    'euiTableRow-isExpandedRow': isExpandedRow,
    'euiTableRow-isExpandable': isExpandable,
    'euiTableRow-isClickable': onClick
  });
  if (!onClick) {
    return ___EmotionJSX("tr", _extends({
      css: cssStyles,
      className: classes
    }, rest), children);
  }
  var onKeyDown = function onKeyDown(event) {
    // Prevent a scroll from occurring if the user has hit space.
    if (event.key === keys.SPACE) event.preventDefault();
  };
  var onKeyUp = function onKeyUp(event) {
    // Support keyboard accessibility by emulating mouse click on ENTER or SPACE keypress.
    if (event.key === keys.ENTER || event.key === keys.SPACE) {
      onClick(event);
    }
  };
  return ___EmotionJSX("tr", _extends({
    css: cssStyles,
    className: classes,
    onClick: onClick,
    onKeyDown: onKeyDown,
    onKeyUp: onKeyUp,
    tabIndex: 0
  }, rest), children);
};
EuiTableRow.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * Indicates if the table has a single column of checkboxes for selecting
     * rows (used for mobile styling)
     */
  hasSelection: PropTypes.bool,
  /**
     * Indicates that the current row's checkbox is selectable / not disabled
     */
  isSelectable: PropTypes.bool,
  /**
     * Indicates the current row has been selected
     */
  isSelected: PropTypes.bool,
  /**
     * Indicates if the table has a dedicated column for actions
     * (used for mobile styling and desktop action hover behavior)
     */
  hasActions: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.oneOf(["custom"])]),
  /**
     * Indicates if the row will have an expanded row
     */
  isExpandable: PropTypes.bool,
  /**
     * Indicates if the row will be the expanded row
     */
  isExpandedRow: PropTypes.bool,
  onClick: PropTypes.any
};