var _templateObject;
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css, keyframes } from '@emotion/react';
import { tint, shade, transparentize } from '../../services';
import { euiCanAnimate, euiBackgroundColor, logicalCSS } from '../../global_styling';
import { euiShadow } from '../../themes/amsterdam/global_styling/mixins';
import { euiTableVariables } from './table.styles';
export var euiTableRowStyles = function euiTableRowStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var rowColors = _rowColorVariables(euiThemeContext);
  var expandedAnimationCss = _expandedRowAnimation(euiThemeContext);
  var _euiTableVariables = euiTableVariables(euiThemeContext),
    cellContentPadding = _euiTableVariables.cellContentPadding,
    mobileSizes = _euiTableVariables.mobileSizes,
    checkboxSize = _euiTableVariables.checkboxSize;
  return {
    euiTableRow: /*#__PURE__*/css(";label:euiTableRow;"),
    desktop: {
      desktop: /*#__PURE__*/css("&:hover{background-color:", rowColors.hover, ";};label:desktop;"),
      expanded: /*#__PURE__*/css("background-color:", rowColors.hover, ";", expandedAnimationCss, ";;label:expanded;"),
      clickable: /*#__PURE__*/css("&:hover{background-color:", rowColors.clickable.hover, ";cursor:pointer;}&:focus{background-color:", rowColors.clickable.focus, ";};label:clickable;"),
      selected: /*#__PURE__*/css("&,&+.euiTableRow-isExpandedRow{background-color:", rowColors.selected.color, ";}&:hover,&:hover+.euiTableRow-isExpandedRow{background-color:", rowColors.selected.hover, ";};label:selected;"),
      // Offset expanded & selectable rows by the checkbox width to line up content with the 2nd column
      // Set on the `<td>` because padding can't be applied to `<tr>` elements directly
      checkboxOffset: /*#__PURE__*/css("&>.euiTableRowCell:first-child{", logicalCSS('padding-left', checkboxSize), ";};label:checkboxOffset;")
    },
    mobile: {
      mobile: /*#__PURE__*/css("position:relative;display:flex;flex-wrap:wrap;padding:", cellContentPadding, ";", logicalCSS('margin-bottom', cellContentPadding), euiShadow(euiThemeContext, 's'), " background-color:", euiBackgroundColor(euiThemeContext, 'plain'), ";border-radius:", euiTheme.border.radius.medium, ";;label:mobile;"),
      selected: /*#__PURE__*/css("&,&+.euiTableRow-isExpandedRow{background-color:", rowColors.selected.color, ";};label:selected;"),
      /**
       * Left column offset (no border)
       * Used for selection checkbox, which will be absolutely positioned
       */
      hasLeftColumn: /*#__PURE__*/css(logicalCSS('padding-left', mobileSizes.checkbox.width), ";;label:hasLeftColumn;"),
      /**
       * Right column styles + border
       * Used for cell actions and row expander arrow
       */
      hasRightColumn: /*#__PURE__*/css(logicalCSS('padding-right', mobileSizes.actions.width), " &::after{content:'';position:absolute;", logicalCSS('vertical', 0), " ", logicalCSS('right', mobileSizes.actions.width), " ", logicalCSS('width', euiTheme.border.width.thin), " background-color:", euiTheme.border.color, ";};label:hasRightColumn;"),
      /**
       * Bottom of card - expanded rows
       */
      expanded: /*#__PURE__*/css(logicalCSS('margin-top', "-".concat(mobileSizes.actions.offset)), logicalCSS('padding-left', cellContentPadding), " ", logicalCSS('border-top', euiTheme.border.thin), " ", logicalCSS('border-top-left-radius', 0), " ", logicalCSS('border-top-right-radius', 0), ">.euiTableRowCell{", logicalCSS('width', '100%'), ";}", expandedAnimationCss, ";;label:expanded;")
    }
  };
};
var _expandedRowAnimation = function _expandedRowAnimation(_ref) {
  var euiTheme = _ref.euiTheme;
  // Do not attempt to animate to height auto - down that road dragons lie
  // @see https://github.com/elastic/eui/pull/6826
  var expandRow = keyframes(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n    0% {\n      opacity: 0;\n      transform: translateY(-", ");\n    }\n    100% {\n      opacity: 1;\n      transform: translateY(0);\n    }\n  "])), euiTheme.size.m);

  // Animation must be on the contents div inside, not the row itself
  return /*#__PURE__*/css(euiCanAnimate, "{.euiTableCellContent{animation:", euiTheme.animation.fast, " ", euiTheme.animation.resistance, " 1 normal none ", expandRow, ";}}");
};
var _rowColorVariables = function _rowColorVariables(_ref2) {
  var euiTheme = _ref2.euiTheme,
    colorMode = _ref2.colorMode;
  return {
    hover: colorMode === 'DARK' ? euiTheme.colors.lightestShade : tint(euiTheme.colors.lightestShade, 0.5),
    selected: {
      color: colorMode === 'DARK' ? shade(euiTheme.colors.primary, 0.7) : tint(euiTheme.colors.primary, 0.96),
      hover: colorMode === 'DARK' ? shade(euiTheme.colors.primary, 0.75) : tint(euiTheme.colors.primary, 0.9)
    },
    clickable: {
      hover: transparentize(euiTheme.colors.primary, 0.05),
      focus: transparentize(euiTheme.colors.primary, 0.1)
    }
  };
};