function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiCanAnimate, euiFontSize, euiTextTruncate, logicalCSS, logicalTextAlignCSS } from '../../global_styling';
import { euiTableVariables } from './table.styles';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1amvdy6-bottom",
  styles: "vertical-align:bottom;label:bottom;"
} : {
  name: "1amvdy6-bottom",
  styles: "vertical-align:bottom;label:bottom;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "2f764e-top",
  styles: "vertical-align:top;label:top;"
} : {
  name: "2f764e-top",
  styles: "vertical-align:top;label:top;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "19hexhy-baseline",
  styles: "vertical-align:baseline;label:baseline;"
} : {
  name: "19hexhy-baseline",
  styles: "vertical-align:baseline;label:baseline;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "l1nme7-middle",
  styles: "vertical-align:middle;label:middle;"
} : {
  name: "l1nme7-middle",
  styles: "vertical-align:middle;label:middle;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiTableRowCellStyles = function euiTableRowCellStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiTableVariables = euiTableVariables(euiThemeContext),
    mobileSizes = _euiTableVariables.mobileSizes;

  // Unsets the extra strut caused by inline-block display of buttons/icons/tooltips.
  // Without this, the row height jumps whenever actions are disabled.
  var hasIcons = "line-height: 1;";
  return {
    euiTableRowCell: /*#__PURE__*/css("color:", euiTheme.colors.text, ";;label:euiTableRowCell;"),
    rowHeader: /*#__PURE__*/css("font-weight:", euiTheme.font.weight.regular, ";", logicalTextAlignCSS('left'), ";;label:rowHeader;"),
    isExpander: /*#__PURE__*/css(hasIcons, ";;label:isExpander;"),
    hasActions: /*#__PURE__*/css(hasIcons, ";;label:hasActions;"),
    // valign
    middle: _ref4,
    baseline: _ref3,
    top: _ref2,
    bottom: _ref,
    desktop: {
      desktop: /*#__PURE__*/css(logicalCSS('border-vertical', euiTheme.border.thin), ";;label:desktop;"),
      actions: /*#__PURE__*/css(".euiBasicTableAction-showOnHover{opacity:0;", euiCanAnimate, "{transition:opacity ", euiTheme.animation.normal, " ", euiTheme.animation.resistance, ";}}&:focus-within,.euiTableRow-hasActions:hover &{.euiBasicTableAction-showOnHover{opacity:1;}};label:actions;")
    },
    mobile: {
      mobile: /*#__PURE__*/css(logicalCSS('min-width', '50%'), ";;label:mobile;"),
      enlarge: /*#__PURE__*/css(euiFontSize(euiThemeContext, 'm'), ";;label:enlarge;"),
      rightColumnContent: "\n        position: absolute;\n        ".concat(logicalCSS('right', 0), "\n        ").concat(logicalCSS('min-width', '0'), "\n        ").concat(logicalCSS('width', mobileSizes.actions.width), "\n      "),
      get actions() {
        // Note: Visible-on-hover actions on desktop always show on mobile
        return /*#__PURE__*/css(this.rightColumnContent, " ", logicalCSS('top', mobileSizes.actions.offset), ";;label:actions;");
      },
      get expander() {
        return /*#__PURE__*/css(this.rightColumnContent, " ", logicalCSS('bottom', mobileSizes.actions.offset), ";;label:expander;");
      },
      /**
       * Custom actions may not be icons and therefore may not fit in a column
       * If they're the last cell, we can create a pseudo "row"/"border-top"
       * that mimicks the visual separation that the right column has
       */
      customActions: /*#__PURE__*/css("&:last-child{", logicalCSS('width', '100%'), " &::before{content:'';position:absolute;", logicalCSS('horizontal', 0), " ", logicalCSS('height', euiTheme.border.width.thin), " background-color:", euiTheme.border.color, ";}.euiTableCellContent{position:relative;", logicalCSS('top', euiTheme.size.xs), ";}};label:customActions;")
    },
    euiTableRowCell__mobileHeader: /*#__PURE__*/css(euiTextTruncate(), " font-size:", euiFontSize(euiThemeContext, 's', {
      customScale: 'xxs'
    }).fontSize, ";display:block;color:", euiTheme.colors.darkShade, ";padding:", euiTheme.size.s, ";padding-block-end:0;margin-block-end:-", euiTheme.size.s, ";.euiTableRowCell:not(:only-child) &{", logicalCSS('min-height', euiTheme.size.l), ";};label:euiTableRowCell__mobileHeader;")
  };
};