var _excluded = ["className", "expand", "initialSelectedTab", "onTabClick", "selectedTab", "size", "tabs", "autoFocus"],
  _excluded2 = ["id", "name", "content"];
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component, createRef } from 'react';
import PropTypes from "prop-types";
import { htmlIdGenerator } from '../../../services';
import { EuiTabs } from '../tabs';
import { EuiTab } from '../tab';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * Marked as const so type is `['initial', 'selected']` instead of `string[]`
 */
export var AUTOFOCUS = ['initial', 'selected'];
export var EuiTabbedContent = /*#__PURE__*/function (_Component) {
  function EuiTabbedContent(props) {
    var _this;
    _classCallCheck(this, EuiTabbedContent);
    _this = _callSuper(this, EuiTabbedContent, [props]);
    _defineProperty(_this, "rootId", htmlIdGenerator()());
    _defineProperty(_this, "tabsRef", /*#__PURE__*/createRef());
    _defineProperty(_this, "focusTab", function () {
      var targetTab = _this.tabsRef.current.querySelector("#".concat(_this.state.selectedTabId));
      targetTab.focus();
    });
    _defineProperty(_this, "initializeFocus", function () {
      if (!_this.state.inFocus && _this.props.autoFocus === 'selected') {
        // Must wait for setState to finish before calling `.focus()`
        // as the focus call triggers a blur on the first tab
        _this.setState({
          inFocus: true
        }, function () {
          _this.focusTab();
        });
      }
    });
    _defineProperty(_this, "removeFocus", function (blurEvent) {
      // only set inFocus to false if the wrapping div doesn't contain the now-focusing element
      var currentTarget = blurEvent.currentTarget;
      var relatedTarget = blurEvent.relatedTarget;
      if (currentTarget.contains(relatedTarget) === false) {
        _this.setState({
          inFocus: false
        });
      }
    });
    _defineProperty(_this, "onTabClick", function (selectedTab) {
      var _this$props = _this.props,
        onTabClick = _this$props.onTabClick,
        externalSelectedTab = _this$props.selectedTab;
      if (onTabClick) {
        onTabClick(selectedTab);
      }

      // Only track selection state if it's not controlled externally.
      if (!externalSelectedTab) {
        _this.setState({
          selectedTabId: selectedTab.id
        }, function () {
          _this.focusTab();
        });
      }
    });
    var initialSelectedTab = props.initialSelectedTab,
      _selectedTab = props.selectedTab,
      tabs = props.tabs;

    // Only track selection state if it's not controlled externally.
    var selectedTabId;
    if (!_selectedTab) {
      selectedTabId = (initialSelectedTab === null || initialSelectedTab === void 0 ? void 0 : initialSelectedTab.id) || tabs[0].id;
    }
    _this.state = {
      selectedTabId: selectedTabId,
      inFocus: false
    };
    return _this;
  }
  _inherits(EuiTabbedContent, _Component);
  return _createClass(EuiTabbedContent, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props2 = this.props,
        className = _this$props2.className,
        expand = _this$props2.expand,
        initialSelectedTab = _this$props2.initialSelectedTab,
        onTabClick = _this$props2.onTabClick,
        externalSelectedTab = _this$props2.selectedTab,
        size = _this$props2.size,
        tabs = _this$props2.tabs,
        autoFocus = _this$props2.autoFocus,
        rest = _objectWithoutProperties(_this$props2, _excluded);

      // Allow the consumer to control tab selection.
      var selectedTab = externalSelectedTab || tabs.find(function (tab) {
        return tab.id === _this2.state.selectedTabId;
      }) || tabs[0]; // Fall back to the first tab if a selected tab can't be found

      var selectedTabContent = selectedTab.content,
        selectedTabId = selectedTab.id;
      return ___EmotionJSX("div", _extends({
        className: className
      }, rest), ___EmotionJSX(EuiTabs, {
        ref: this.tabsRef,
        expand: expand,
        size: size,
        onFocus: this.initializeFocus,
        onBlur: this.removeFocus
      }, tabs.map(function (tab) {
        var id = tab.id,
          name = tab.name,
          content = tab.content,
          tabProps = _objectWithoutProperties(tab, _excluded2);
        var props = _objectSpread(_objectSpread({
          key: id,
          id: id
        }, tabProps), {}, {
          onClick: function onClick() {
            return _this2.onTabClick(tab);
          },
          isSelected: tab === selectedTab,
          'aria-controls': "".concat(_this2.rootId)
        });
        return ___EmotionJSX(EuiTab, props, name);
      })), ___EmotionJSX("div", {
        role: "tabpanel",
        id: "".concat(this.rootId),
        "aria-labelledby": selectedTabId
      }, selectedTabContent));
    }
  }]);
}(Component);
_defineProperty(EuiTabbedContent, "defaultProps", {
  autoFocus: 'initial'
});
EuiTabbedContent.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * When tabbing into the tabs, set the focus on `initial` for the first tab,
       * or `selected` for the currently selected tab. Best use case is for inside of
       * overlay content like popovers or flyouts.
       */
  autoFocus: PropTypes.oneOf(["initial", "selected"]),
  /**
       * Evenly stretches each tab to fill the horizontal space
       */
  expand: PropTypes.bool,
  /**
       * Use this prop to set the initially selected tab while letting the tabbed content component
       * control selection state internally
       */
  initialSelectedTab: PropTypes.shape({
    id: PropTypes.string.isRequired,
    name: PropTypes.node.isRequired,
    content: PropTypes.node.isRequired,
    isSelected: PropTypes.bool,
    disabled: PropTypes.bool,
    /**
       * Places content before the tab content/children.
       * Will be excluded from interactive effects.
       */
    prepend: PropTypes.node,
    /**
       * Places content after the tab content/children.
       * Will be excluded from interactive effects.
       */
    append: PropTypes.node,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }),
  onTabClick: PropTypes.func,
  /**
       * Use this prop if you want to control selection state within the owner component
       */
  selectedTab: PropTypes.shape({
    id: PropTypes.string.isRequired,
    name: PropTypes.node.isRequired,
    content: PropTypes.node.isRequired,
    isSelected: PropTypes.bool,
    disabled: PropTypes.bool,
    prepend: PropTypes.node,
    append: PropTypes.node,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }),
  size: PropTypes.any,
  /**
       * Each tab needs id and content properties, so we can associate it with its panel for accessibility.
       * The name property (a node) is also required to display to the user.
       */
  tabs: PropTypes.arrayOf(PropTypes.shape({
    id: PropTypes.string.isRequired,
    name: PropTypes.node.isRequired,
    content: PropTypes.node.isRequired,
    isSelected: PropTypes.bool,
    disabled: PropTypes.bool,
    prepend: PropTypes.node,
    append: PropTypes.node,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }).isRequired).isRequired
};