function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React from 'react';
import { EuiTabbedContent } from './tabbed_content';
import { EuiSpacer } from '../spacer';
import { EuiText } from '../text';
import { jsx as ___EmotionJSX } from "@emotion/react";
var tabs = [{
  id: 'cobalt--id',
  name: 'Cobalt',
  content: ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiSpacer, null), ___EmotionJSX(EuiText, null, ___EmotionJSX("p", null, "Cobalt is a chemical element with symbol Co and atomic number 27. Like nickel, cobalt is found in the Earth\u2019s crust only in chemically combined form, save for small deposits found in alloys of natural meteoric iron. The free element, produced by reductive smelting, is a hard, lustrous, silver-gray metal.")))
}, {
  id: 'dextrose--id',
  name: 'Dextrose',
  content: ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiSpacer, null), ___EmotionJSX(EuiText, null, ___EmotionJSX("p", null, "Intravenous sugar solution, also known as dextrose solution, is a mixture of dextrose (glucose) and water. It is used to treat low blood sugar or water loss without electrolyte loss.")))
}, {
  id: 'hydrogen--id',
  name: 'Hydrogen',
  content: ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiSpacer, null), ___EmotionJSX(EuiText, null, ___EmotionJSX("p", null, "Hydrogen is a chemical element with symbol H and atomic number 1. With a standard atomic weight of 1.008, hydrogen is the lightest element on the periodic table")))
}, {
  id: 'monosodium_glutammate--id',
  name: 'Monosodium Glutamate',
  content: ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiSpacer, null), ___EmotionJSX(EuiText, null, ___EmotionJSX("p", null, "Monosodium glutamate (MSG, also known as sodium glutamate) is the sodium salt of glutamic acid, one of the most abundant naturally occurring non-essential amino acids. Monosodium glutamate is found naturally in tomatoes, cheese and other foods.")))
}];
var defaultTabProps = {
  tabs: tabs,
  initialSelectedTab: tabs[0],
  autoFocus: 'selected',
  onTabClick: function onTabClick() {}
};
describe('EuiTabs', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations with default props', function () {
      cy.mount(___EmotionJSX(EuiTabbedContent, defaultTabProps));
      cy.get('div.euiTabs').should('exist');
      cy.checkAxe();
    });
    it('has zero violations with second tab open on render', function () {
      var secondSelectedTab = _objectSpread(_objectSpread({}, defaultTabProps), {}, {
        initialSelectedTab: tabs[1]
      });
      cy.mount(___EmotionJSX(EuiTabbedContent, secondSelectedTab));
      cy.get('div.euiTabs').should('exist');
      cy.checkAxe();
    });
    it('has zero violations with third tab open on render', function () {
      var thirdSelectedTab = _objectSpread(_objectSpread({}, defaultTabProps), {}, {
        initialSelectedTab: tabs[2]
      });
      cy.mount(___EmotionJSX(EuiTabbedContent, thirdSelectedTab));
      cy.get('div.euiTabs').should('exist');
      cy.checkAxe();
    });
    it('has zero violations with last tab open on render', function () {
      var lastSelectedTab = _objectSpread(_objectSpread({}, defaultTabProps), {}, {
        initialSelectedTab: tabs[3]
      });
      cy.mount(___EmotionJSX(EuiTabbedContent, lastSelectedTab));
      cy.get('div.euiTabs').should('exist');
      cy.checkAxe();
    });
    it('has zero violations with all tabs disabled except first', function () {
      var disabledTabs = tabs.map(function (tab, i) {
        if (i === 0) {
          return tab;
        }
        return _objectSpread(_objectSpread({}, tab), {}, {
          disabled: true
        });
      });
      var disabledTabProps = _objectSpread(_objectSpread({}, defaultTabProps), {}, {
        tabs: disabledTabs
      });
      cy.mount(___EmotionJSX(EuiTabbedContent, disabledTabProps));
      cy.get('div.euiTabs').should('exist');
      cy.checkAxe();
    });
  });
});