var _excluded = ["children", "className", "bottomBorder", "expand", "size"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { keys, useEuiMemoizedStyles } from '../../services';
import { euiTabsStyles } from './tabs.styles';
import { EuiTabsContext } from './tabs_context';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['s', 'm', 'l', 'xl'];
export var EuiTabs = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$bottomBorder = _ref.bottomBorder,
    bottomBorder = _ref$bottomBorder === void 0 ? true : _ref$bottomBorder,
    _ref$expand = _ref.expand,
    expand = _ref$expand === void 0 ? false : _ref$expand,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiTabs', className);
  var styles = useEuiMemoizedStyles(euiTabsStyles);
  var cssStyles = [styles.euiTabs, styles[size], bottomBorder && styles.bottomBorder];
  var handleKeyDown = function handleKeyDown(event) {
    var tablist = event.currentTarget;
    var tabs = tablist === null || tablist === void 0 ? void 0 : tablist.querySelectorAll('[role="tab"]:not(:disabled, [inert])');
    if (!(tabs !== null && tabs !== void 0 && tabs.length)) return;
    var currentIndex = Array.from(tabs).findIndex(function (tab) {
      return tab.matches(':focus');
    });
    if (event.key === keys.ARROW_LEFT) {
      var previousIndex = (currentIndex === 0 ? tabs.length : currentIndex) - 1;
      tabs[previousIndex].focus();
    } else if (event.key === keys.ARROW_RIGHT) {
      var nextIndex = currentIndex === tabs.length - 1 ? 0 : currentIndex + 1;
      tabs[nextIndex].focus();
    }
  };
  return ___EmotionJSX("div", _extends({
    ref: ref,
    className: classes,
    css: cssStyles,
    onKeyDown: handleKeyDown
  }, children && {
    role: 'tablist'
  }, rest), ___EmotionJSX(EuiTabsContext.Provider, {
    value: {
      expand: expand,
      size: size
    }
  }, children));
});
EuiTabs.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * ReactNode to render as this component's content
       */
  children: PropTypes.node,
  /**
       * Evenly stretches each tab to fill the
       * horizontal space
       */
  expand: PropTypes.bool,
  /**
       * Adds a bottom border to separate it from the content after
       */
  bottomBorder: PropTypes.bool,
  /**
       * Sizes affect both font size and overall size.
       * Only use the `xl` size when displayed as page titles.
       */
  size: PropTypes.any
};
EuiTabs.displayName = 'EuiTabs';