/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, logicalShorthandCSS, logicalTextAlignCSS, euiFontSize, euiBackgroundColor, mathWithUnits } from '../../global_styling';
import { euiLinkCSS } from '../link/link.styles';
import { euiTitle } from '../title/title.styles';

/**
 * TODO: Make this a global value so it can be set by theme?
 */
export var euiTextConstrainedMaxWidth = 'max(64ch, 75%)';

/**
 * Mixins
 */
export var euiText = function euiText(euiTheme) {
  var inheritColor = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return {
    color: inheritColor ? 'inherit' : euiTheme.colors.text,
    fontWeight: euiTheme.font.weight.regular
  };
};

// Internal utility for EuiText scales/sizes
var euiScaleText = function euiScaleText(euiThemeContext, options) {
  var _euiFontSize = euiFontSize(euiThemeContext, 'm', options),
    fontSize = _euiFontSize.fontSize,
    lineHeight = _euiFontSize.lineHeight;
  var euiTheme = euiThemeContext.euiTheme;
  var unit = options.unit,
    _customScale = options.customScale;
  var lineHeightSize = unit === 'em' ? "".concat(lineHeight, "em") : lineHeight;
  var headings = {
    h1: euiTitle(euiThemeContext, 'l', options),
    h2: euiTitle(euiThemeContext, 'm', options),
    h3: euiTitle(euiThemeContext, 's', options),
    h4: euiTitle(euiThemeContext, 'xs', options),
    h5: euiTitle(euiThemeContext, 'xxs', options),
    h6: euiTitle(euiThemeContext, 'xxxs', options)
  };
  // Generate margins for headings based on customScale (not on heading level)
  var customScale = _customScale === 'xxxs' ? 'xxs' : _customScale || 'm';
  var marginSize = euiTheme.size[customScale];
  var headingMarginTop = mathWithUnits(marginSize, function (x) {
    return x * 2;
  });
  var headingMarginBottom = marginSize;
  var blockQuoteBorderWidth = mathWithUnits(fontSize, function (x) {
    return x / 4;
  });
  return "\n    font-size: ".concat(fontSize, ";\n    line-height: ").concat(lineHeight, ";\n\n    h1 {\n      font-size: ").concat(headings.h1.fontSize, ";\n      line-height: ").concat(headings.h1.lineHeight, ";\n    }\n    h1:not(:last-child) {\n      ").concat(logicalCSS('margin-bottom', headingMarginBottom), "\n    }\n\n    h2 {\n      font-size: ").concat(headings.h2.fontSize, ";\n      line-height: ").concat(headings.h2.lineHeight, ";\n\n      &:not(:first-child) {\n        ").concat(logicalCSS('margin-top', headingMarginTop), "\n      }\n\n      &:not(:last-child) {\n        ").concat(logicalCSS('margin-bottom', headingMarginBottom), "\n      }\n    }\n\n    h3 {\n      font-size: ").concat(headings.h3.fontSize, ";\n      line-height: ").concat(headings.h3.lineHeight, ";\n\n      &:not(:first-child) {\n        ").concat(logicalCSS('margin-top', headingMarginTop), "\n      }\n\n      &:not(:last-child) {\n        ").concat(logicalCSS('margin-bottom', headingMarginBottom), "\n      }\n    }\n\n    h4 {\n      font-size: ").concat(headings.h4.fontSize, ";\n      line-height: ").concat(headings.h4.lineHeight, ";\n\n      &:not(:first-child) {\n        ").concat(logicalCSS('margin-top', headingMarginTop), "\n      }\n\n      &:not(:last-child) {\n        ").concat(logicalCSS('margin-bottom', headingMarginBottom), "\n      }\n    }\n\n    h5 {\n      font-size: ").concat(headings.h5.fontSize, ";\n      line-height: ").concat(headings.h5.lineHeight, ";\n\n      &:not(:first-child) {\n        ").concat(logicalCSS('margin-top', headingMarginTop), "\n      }\n\n      &:not(:last-child) {\n        ").concat(logicalCSS('margin-bottom', headingMarginBottom), "\n      }\n    }\n\n    h6 {\n      font-size: ").concat(headings.h6.fontSize, ";\n      line-height: ").concat(headings.h6.lineHeight, ";\n\n      &:not(:first-child) {\n        ").concat(logicalCSS('margin-top', headingMarginTop), "\n      }\n\n      &:not(:last-child) {\n        ").concat(logicalCSS('margin-bottom', headingMarginBottom), "\n      }\n    }\n\n    p,\n    dl,\n    blockquote,\n    pre,\n    > ul,\n    > ol {\n      ").concat(logicalCSS('margin-bottom', lineHeightSize), "\n    }\n\n    ul,\n    ol {\n      ").concat(logicalCSS('margin-left', lineHeightSize), "\n    }\n\n    /* The styles of the nested ordered lists follow the style of GitHub\n       which is commonly used in Markdown or MDX formatting. */\n    ol ol,\n    ul ol {\n      list-style-type: lower-roman;\n    }\n\n    ul ul ol,\n    ul ol ol,\n    ol ul ol,\n    ol ol ol {\n      list-style-type: lower-alpha;\n    }\n  \n    blockquote {\n      font-size: ").concat(fontSize, ";\n      ").concat(logicalShorthandCSS('padding', "0 ".concat(fontSize)), "\n      ").concat(logicalCSS('border-left-width', blockQuoteBorderWidth), "\n      ").concat(logicalCSS('margin-bottom', fontSize), "\n    }\n\n    dd + dt {\n      ").concat(logicalCSS('margin-top', fontSize), "\n    }\n\n    dt,\n    .eui-definitionListReverse dd {\n      font-size: ").concat(fontSize, ";\n      line-height: ").concat(lineHeight, ";\n    }\n\n    .eui-definitionListReverse dt {\n      font-size: ").concat(euiFontSize(euiThemeContext, 'xs', options).fontSize, ";\n      color: ").concat(euiTheme.colors.text, ";\n    }\n\n    small {\n      font-size: ").concat(euiFontSize(euiThemeContext, 's', options).fontSize, ";\n    }\n\n    pre:not(.euiCodeBlock__pre) {\n      padding: ").concat(lineHeightSize, ";\n    }\n\n    code:not(.euiCode):not(.euiCodeBlock__code)  {\n      font-size: .9em; /* 90% of parent font size */\n    }\n    ").concat(
  // when textSize is 'm', the 'kbd' element gets a line between the text and the border-bottom
  _customScale === 'm' ? "\n    kbd {\n      ".concat(logicalCSS('padding-bottom', euiTheme.size.xs), "\n      /* Ensures the shape still looks like a square when only one character */\n      ").concat(logicalCSS('min-width', euiTheme.size.l), "\n      ").concat(logicalTextAlignCSS('center'), "\n    }\n    \n    kbd::after {\n      content: '';\n      ").concat(logicalCSS('border-bottom', "".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.colors.text)), "\n      position: absolute;\n      ").concat(logicalCSS('bottom', euiTheme.size.xxs), "\n      ").concat(logicalCSS('left', 0), "\n      ").concat(logicalCSS('width', '100%'), "\n    }") : '', "\n  ");
};

/**
 * Styles
 */
export var euiTextStyles = function euiTextStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiText: /*#__PURE__*/css(euiText(euiTheme, true), "clear:both;a:not([class]){", euiLinkCSS(euiThemeContext), ";}ul{list-style:disc;}ol{list-style:decimal;}blockquote{border-inline-start-color:", euiTheme.border.color, ";border-inline-start-style:solid;}blockquote:not(.euiMarkdownFormat__blockquote){color:", euiTheme.colors.subduedText, ";}h1{", euiTitle(euiThemeContext, 'l'), ";}h2{", euiTitle(euiThemeContext, 'm'), ";}h3{", euiTitle(euiThemeContext, 's'), ";}h4,dt{", euiTitle(euiThemeContext, 'xs'), ";}h5{", euiTitle(euiThemeContext, 'xxs'), ";}h6{", euiTitle(euiThemeContext, 'xxxs'), " text-transform:uppercase;}h1,h2,h3,h4,h5,h6,dt{color:inherit;}pre:not(.euiCodeBlock__pre){white-space:pre-wrap;background:", euiBackgroundColor(euiThemeContext, 'subdued'), ";color:", euiTheme.colors.text, ";}pre:not(.euiCodeBlock__pre),pre:not(.euiCodeBlock__pre) code{display:block;}>:last-child{", logicalCSS('margin-bottom', '0 !important'), ";}kbd{position:relative;display:inline-block;", logicalCSS('padding-vertical', euiTheme.size.xxs), " ", logicalCSS('padding-horizontal', euiTheme.size.xs), " line-height:1;border:", euiTheme.border.width.thin, " solid ", euiTheme.colors.text, ";border-radius:", mathWithUnits(euiTheme.border.radius.small, function (x) {
      return x / 2;
    }), ";};label:euiText;"),
    constrainedWidth: /*#__PURE__*/css(logicalCSS('max-width', euiTextConstrainedMaxWidth), ";;label:constrainedWidth;"),
    // Sizes
    m: /*#__PURE__*/css(euiScaleText(euiThemeContext, {
      customScale: 'm'
    }), ";;label:m;"),
    s: /*#__PURE__*/css(euiScaleText(euiThemeContext, {
      customScale: 's'
    }), ";;label:s;"),
    xs: /*#__PURE__*/css(euiScaleText(euiThemeContext, {
      customScale: 'xs'
    }), ";;label:xs;"),
    relative: /*#__PURE__*/css(euiScaleText(euiThemeContext, {
      unit: 'em'
    }), ";;label:relative;")
  };
};