var _excluded = ["className", "items", "children", "gutterSize"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiTheme } from '../../services';
import { EuiTimelineItem } from './timeline_item';
import { euiTimelineStyles } from './timeline.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var GUTTER_SIZES = ['m', 'l', 'xl'];
export var EuiTimeline = function EuiTimeline(_ref) {
  var className = _ref.className,
    _ref$items = _ref.items,
    items = _ref$items === void 0 ? [] : _ref$items,
    children = _ref.children,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'xl' : _ref$gutterSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiTimeline', className);
  var euiTheme = useEuiTheme();
  var styles = euiTimelineStyles(euiTheme);
  var cssStyles = [styles.euiTimeline, styles[gutterSize]];
  return (
    // eslint-disable-next-line jsx-a11y/no-redundant-roles
    ___EmotionJSX("ol", _extends({
      className: classes,
      css: cssStyles,
      role: "list"
    }, rest), items.map(function (item, index) {
      return ___EmotionJSX(EuiTimelineItem, _extends({
        key: index
      }, item));
    }), children)
  );
};
EuiTimeline.propTypes = {
  /**
     * List of timeline items to render. See #EuiTimelineItem
     */
  items: PropTypes.arrayOf(PropTypes.shape({
    /**
       * Vertical alignment of the event with the icon
       */
    verticalAlign: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }).isRequired),
  /**
     * Sets the size of the vertical space between each timeline item
     */
  gutterSize: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};