var _excluded = ["children", "verticalAlign", "icon", "iconAriaLabel"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import { EuiTimelineItemEvent } from './timeline_item_event';
import { EuiTimelineItemIcon } from './timeline_item_icon';
import { euiTimelineItemStyles } from './timeline_item.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var VERTICAL_ALIGN = ['top', 'center'];
export var EuiTimelineItem = function EuiTimelineItem(_ref) {
  var children = _ref.children,
    _ref$verticalAlign = _ref.verticalAlign,
    verticalAlign = _ref$verticalAlign === void 0 ? 'center' : _ref$verticalAlign,
    icon = _ref.icon,
    iconAriaLabel = _ref.iconAriaLabel,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = euiTimelineItemStyles();
  var cssStyles = [styles.euiTimelineItem, styles[verticalAlign]];
  return ___EmotionJSX("li", _extends({
    css: cssStyles
  }, rest), ___EmotionJSX(EuiTimelineItemIcon, {
    icon: icon,
    iconAriaLabel: iconAriaLabel,
    verticalAlign: verticalAlign
  }), ___EmotionJSX(EuiTimelineItemEvent, {
    verticalAlign: verticalAlign
  }, children));
};
EuiTimelineItem.propTypes = {
  /**
     * Vertical alignment of the event with the icon
     */
  verticalAlign: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};