var _templateObject;
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css, keyframes } from '@emotion/react';
import { euiMaxBreakpoint, euiMinBreakpoint, euiScrollBarStyles, logicalCSS, logicalCSSWithFallback, logicalSizeCSS } from '../../global_styling';
export var euiGlobalToastListStyles = function euiGlobalToastListStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var euiToastWidth = euiTheme.base * 25;
  return {
    /**
     * 1. Allow list to expand as items are added, but cap it at the screen height.
     * 2. Allow some padding for shadow
     */
    // Base
    euiGlobalToastList: /*#__PURE__*/css(euiScrollBarStyles(euiThemeContext), " display:flex;flex-direction:column;align-items:stretch;position:fixed;z-index:", euiTheme.levels.toast, ";", logicalCSS('bottom', 0), " ", logicalCSS('width', "".concat(euiToastWidth, "px")), logicalCSS('max-height', '100vh'), logicalCSSWithFallback('overflow-y', 'auto'), "scrollbar-width:none;&::-webkit-scrollbar{", logicalSizeCSS(0, 0), ";}&:not(:empty){", logicalCSS('padding-left', euiTheme.size.base), " ", logicalCSS('padding-right', euiTheme.size.base), " ", logicalCSS('padding-vertical', euiTheme.size.base), ";}", euiMaxBreakpoint(euiThemeContext, 'm'), "{&:not(:empty){", logicalCSS('left', 0), " ", logicalCSS('width', '100%'), ";}};label:euiGlobalToastList;"),
    // Variants
    right: /*#__PURE__*/css("&:not(:empty){", logicalCSS('right', 0), ";", euiMinBreakpoint(euiThemeContext, 'm'), "{", logicalCSS('padding-left', "".concat(euiTheme.base * 4, "px")), ";}};label:right;"),
    left: /*#__PURE__*/css("&:not(:empty){", logicalCSS('left', 0), ";", euiMinBreakpoint(euiThemeContext, 'm'), "{", logicalCSS('padding-right', "".concat(euiTheme.base * 4, "px")), ";}};label:left;"),
    euiGlobalToastListDismissButton: /*#__PURE__*/css("position:sticky;", logicalCSS('bottom', '0%'), ";;label:euiGlobalToastListDismissButton;")
  };
};
export var euiGlobalToastListItemStyles = function euiGlobalToastListItemStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  var euiShowToast = keyframes(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  from {\n    transform: translateY(", ") scale(.9);\n    opacity: 0;\n  }\n\n  to {\n    transform: translateY(0) scale(1);\n    opacity: 1;\n  }\n"])), euiTheme.size.l);
  return {
    // Base
    euiGlobalToastListItem: /*#__PURE__*/css("flex-shrink:0;", logicalCSS('margin-bottom', euiTheme.size.base), " animation:", euiTheme.animation.normal, " ", euiShowToast, " ", euiTheme.animation.resistance, ";opacity:1;&:first-child{", logicalCSS('margin-top', 'auto'), ";}&:last-child{", logicalCSS('margin-bottom', 0), ";};label:euiGlobalToastListItem;"),
    // States
    dismissed: /*#__PURE__*/css("transition:opacity ", euiTheme.animation.normal, ";opacity:0;;label:dismissed;")
  };
};