var _excluded = ["onBlur", "onFocus", "onMouseOver", "onMouseOut", "id", "className", "children", "display", "isVisible"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { cloneElement, forwardRef } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { euiToolTipAnchorStyles } from './tool_tip.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiToolTipAnchor = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var _onBlur = _ref.onBlur,
    _onFocus = _ref.onFocus,
    onMouseOver = _ref.onMouseOver,
    onMouseOut = _ref.onMouseOut,
    id = _ref.id,
    className = _ref.className,
    children = _ref.children,
    display = _ref.display,
    isVisible = _ref.isVisible,
    rest = _objectWithoutProperties(_ref, _excluded);
  var anchorCss = euiToolTipAnchorStyles();
  var cssStyles = [anchorCss.euiToolTipAnchor, anchorCss[display]];
  var classes = classNames('euiToolTipAnchor', className);
  return (
    // eslint-disable-next-line jsx-a11y/mouse-events-have-key-events
    ___EmotionJSX("span", _extends({
      ref: ref,
      css: cssStyles
    }, rest, {
      className: classes,
      onMouseOver: onMouseOver,
      onMouseOut: onMouseOut
    }), /*#__PURE__*/cloneElement(children, {
      onFocus: function onFocus(e) {
        _onFocus();
        children.props.onFocus && children.props.onFocus(e);
      },
      onBlur: function onBlur(e) {
        _onBlur();
        children.props.onBlur && children.props.onBlur(e);
      },
      'aria-describedby': isVisible ? classNames(id, children.props['aria-describedby']) : children.props['aria-describedby']
    }))
  );
});
EuiToolTipAnchor.propTypes = {
  onBlur: PropTypes.func.isRequired,
  onFocus: PropTypes.func.isRequired,
  isVisible: PropTypes.bool.isRequired
};
EuiToolTipAnchor.displayName = 'EuiToolTipAnchor';