/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { memo } from 'react';
import PropTypes from "prop-types";
import { useEuiMemoizedStyles } from '../../services';
import { EuiPopoverTitle } from '../popover';
import { EuiTitle } from '../title';
import { euiTourHeaderStyles } from './_tour_header.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTourHeader = /*#__PURE__*/memo(function (_ref) {
  var id = _ref.id,
    title = _ref.title,
    subtitle = _ref.subtitle;
  var headerStyles = useEuiMemoizedStyles(euiTourHeaderStyles);
  return ___EmotionJSX(EuiPopoverTitle, {
    css: headerStyles.euiTourHeader,
    className: "euiTourHeader",
    id: id
  }, subtitle && ___EmotionJSX(EuiTitle, {
    css: headerStyles.euiTourHeader__subtitle,
    size: "xxxs"
  }, ___EmotionJSX("h2", null, subtitle)), ___EmotionJSX(EuiTitle, {
    css: headerStyles.euiTourHeader__title,
    size: "xxs"
  }, subtitle ? ___EmotionJSX("h3", null, title) : ___EmotionJSX("h2", null, title)));
});
EuiTourHeader.propTypes = {
  id: PropTypes.string.isRequired
};
EuiTourHeader.displayName = '_EuiTourHeader';