function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["anchorPosition", "anchor", "children", "className", "css", "closePopover", "content", "isStepOpen", "minWidth", "maxWidth", "onFinish", "step", "stepsTotal", "subtitle", "title", "decoration", "footerAction", "panelProps", "panelClassName"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useEffect, useState, useMemo, useCallback } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useGeneratedHtmlId, findElementBySelectorOrRef, useEuiMemoizedStyles } from '../../services';
import { logicalStyles } from '../../global_styling';
import { EuiPopover, EuiWrappingPopover } from '../popover';
import { EuiBeacon } from '../beacon';
import { EuiTourHeader } from './_tour_header';
import { EuiTourFooter } from './_tour_footer';
import { euiTourStyles, euiTourBeaconStyles } from './tour.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTourStep = function EuiTourStep(_ref) {
  var _ref$anchorPosition = _ref.anchorPosition,
    anchorPosition = _ref$anchorPosition === void 0 ? 'leftUp' : _ref$anchorPosition,
    anchor = _ref.anchor,
    children = _ref.children,
    className = _ref.className,
    css = _ref.css,
    _ref$closePopover = _ref.closePopover,
    closePopover = _ref$closePopover === void 0 ? function () {} : _ref$closePopover,
    content = _ref.content,
    _ref$isStepOpen = _ref.isStepOpen,
    isStepOpen = _ref$isStepOpen === void 0 ? false : _ref$isStepOpen,
    _ref$minWidth = _ref.minWidth,
    minWidth = _ref$minWidth === void 0 ? 300 : _ref$minWidth,
    _ref$maxWidth = _ref.maxWidth,
    maxWidth = _ref$maxWidth === void 0 ? 600 : _ref$maxWidth,
    onFinish = _ref.onFinish,
    _ref$step = _ref.step,
    step = _ref$step === void 0 ? 1 : _ref$step,
    stepsTotal = _ref.stepsTotal,
    subtitle = _ref.subtitle,
    title = _ref.title,
    _ref$decoration = _ref.decoration,
    decoration = _ref$decoration === void 0 ? 'beacon' : _ref$decoration,
    footerAction = _ref.footerAction,
    panelProps = _ref.panelProps,
    panelClassName = _ref.panelClassName,
    rest = _objectWithoutProperties(_ref, _excluded);
  var titleId = useGeneratedHtmlId();
  if (step === 0) {
    console.warn('EuiTourStep `step` should use 1-based indexing. Please update to eliminate 0 indexes.');
  }
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    anchorNode = _useState2[0],
    setAnchorNode = _useState2[1];
  var _useState3 = useState(),
    _useState4 = _slicedToArray(_useState3, 2),
    popoverPosition = _useState4[0],
    setPopoverPosition = _useState4[1];
  var onPositionChange = useCallback(function (position) {
    setPopoverPosition(position);
  }, []);
  useEffect(function () {
    if (anchor) {
      // Wait until next tick to find anchor node in case it's not already
      // in DOM requestAnimationFrame isn't used here because we don't need to
      // synchronize with repainting ticks and the updated value still
      // needs to go through a react DOM rerender which may take more than
      // 1 frame (16ms) of time.
      // TODO: It would be ideal to have some kind of intersection observer here instead
      var timeout = window.setTimeout(function () {
        setAnchorNode(findElementBySelectorOrRef(anchor));
      });
      return function () {
        return window.clearTimeout(timeout);
      };
    }
  }, [anchor]);
  var anchorClasses = classNames('euiTourAnchor', className);
  var popoverClasses = classNames('euiTour', panelClassName);
  var tourStyles = useEuiMemoizedStyles(euiTourStyles);
  var beaconStyles = useEuiMemoizedStyles(euiTourBeaconStyles);
  var beaconCss = [beaconStyles.euiTourBeacon, isStepOpen && beaconStyles.isOpen, popoverPosition && beaconStyles[popoverPosition]];
  var hasBeacon = decoration === 'beacon';
  var widthStyles = useMemo(function () {
    return logicalStyles({
      minWidth: minWidth,
      maxWidth: maxWidth
    });
  }, [minWidth, maxWidth]);
  var noAnchor = !anchor && children;
  var PopoverComponent = noAnchor ? EuiPopover : EuiWrappingPopover;
  var button = noAnchor ? children : anchorNode;
  return button ? ___EmotionJSX(PopoverComponent, _extends({
    button: button,
    className: anchorClasses,
    anchorPosition: anchorPosition,
    closePopover: closePopover,
    isOpen: isStepOpen,
    ownFocus: false,
    panelClassName: popoverClasses,
    panelProps: _objectSpread(_objectSpread({}, panelProps), {}, {
      css: [tourStyles.euiTour, css, panelProps === null || panelProps === void 0 ? void 0 : panelProps.css]
    }),
    offset: hasBeacon ? 10 : 0,
    "aria-labelledby": titleId,
    arrowChildren: hasBeacon && ___EmotionJSX(EuiBeacon, {
      css: beaconCss,
      className: "euiTour__beacon"
    }),
    onPositionChange: onPositionChange
  }, rest), ___EmotionJSX("div", {
    style: widthStyles
  }, ___EmotionJSX(EuiTourHeader, {
    id: titleId,
    title: title,
    subtitle: subtitle
  }), ___EmotionJSX("div", {
    className: "euiTour__content"
  }, content), ___EmotionJSX(EuiTourFooter, {
    footerAction: footerAction,
    step: step,
    stepsTotal: stepsTotal,
    onFinish: onFinish
  }))) : null;
};
EuiTourStep.propTypes = {
  className: PropTypes.string,
  /**
     * Provide a name to the popover panel
     */
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * Alignment of the popover and arrow relative to the button
     */
  anchorPosition: PropTypes.any,
  /**
     * Style and position alteration for arrow-less attachment.
     * Intended for use with inputs as anchors, e.g. EuiInputPopover
     */
  attachToAnchor: PropTypes.bool,
  /**
     * Restrict the popover's position within this element
     */
  container: PropTypes.any,
  /**
     * CSS display type for both the popover and anchor
     */
  display: PropTypes.any,
  /**
     * Object of props passed to EuiFocusTrap
     */
  focusTrapProps: PropTypes.any,
  /**
     * Show arrow indicating to originating button
     */
  hasArrow: PropTypes.bool,
  /**
     * Specifies what element should initially have focus; Can be a DOM
     * node, or a selector string (which will be passed to
     * document.querySelector() to find the DOM node), or a function that
     * returns a DOM node.
     *
     * If not passed, initial focus defaults to the popover panel.
     */
  initialFocus: PropTypes.any,
  /**
     * Passed directly to EuiPortal for DOM positioning. Both properties are
     * required if prop is specified
     */
  insert: PropTypes.shape({
    sibling: PropTypes.any.isRequired,
    position: PropTypes.oneOf(["before", "after"]).isRequired
  }),
  /**
     * Traps tab focus within the popover contents
     */
  ownFocus: PropTypes.bool,
  /**
     * Custom class added to the EuiPanel containing the popover contents
     */
  panelClassName: PropTypes.string,
  /**
     * EuiPanel padding on all sides
     */
  panelPaddingSize: PropTypes.any,
  /**
     * Standard DOM `style` attribute. Passed to the EuiPanel
     */
  panelStyle: PropTypes.any,
  /**
     * Object of props passed to EuiPanel. See #EuiPopoverPanelProps
     */
  panelProps: PropTypes.shape({
    element: PropTypes.oneOf(["div"]),
    /**
       * Padding for all four sides
       */
    paddingSize: PropTypes.any,
    /**
       * Corner border radius
       */
    borderRadius: PropTypes.any,
    /**
       * When true the panel will grow in height to match `EuiFlexItem`
       */
    grow: PropTypes.bool,
    panelRef: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }),
  panelRef: PropTypes.any,
  /**
     * Optional screen reader instructions to announce upon popover open,
     * in addition to EUI's default popover instructions for Escape on close.
     * Useful for popovers that may have additional keyboard capabilities such as
     * arrow navigation.
     */
  popoverScreenReaderText: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.node.isRequired]),
  popoverRef: PropTypes.any,
  /**
     * When `true`, the popover's position is re-calculated when the user
     * scrolls, this supports having fixed-position popover anchors. When nesting
     * an `EuiPopover` in a scrollable container, `repositionOnScroll` should be `true`
     */
  repositionOnScroll: PropTypes.bool,
  /**
     * By default, popovers will attempt to position themselves along the initial
     * axis specified. If there is not enough room either vertically or horizontally
     * however, the popover will attempt to reposition itself along the secondary
     * cross axis if there is room there instead.
     *
     * If you do not not want this repositioning to occur (and it is acceptable for
     * the popover to appear offscreen), set this to false to disable this behavior.
     *
     * @default true
     */
  repositionToCrossAxis: PropTypes.bool,
  /**
     * By default, popover content inherits the z-index of the anchor
     * component; pass `zIndex` to override
     */
  zIndex: PropTypes.number,
  /**
     * Distance away from the anchor that the popover will render
     */
  offset: PropTypes.number,
  /**
     * Minimum distance between the popover and the bounding container;
     * Pass an array of 4 values to adjust each side differently: `[top, right, bottom, left]`
     * @default 16
     */
  buffer: PropTypes.oneOfType([PropTypes.number.isRequired, PropTypes.any.isRequired]),
  /**
     * Element to pass as the child element of the arrow;
     * Use case is typically limited to an accompanying `EuiBeacon`
     */
  arrowChildren: PropTypes.node,
  /**
     * Alternative option to `aria-label` that takes an `id`.
     * Usually takes the `id` of the popover title
     */
  "aria-labelledby": PropTypes.string,
  /**
     * Function callback for when the popover positon changes
     */
  onPositionChange: PropTypes.func,
  /**
       * Element to which the tour step popover attaches when open
       */
  children: PropTypes.element,
  anchor: PropTypes.any,
  /**
       * Contents of the tour step popover
       */
  content: PropTypes.node.isRequired,
  /**
       * Step will display if set to `true`
       */
  isStepOpen: PropTypes.bool,
  /**
       * Change the default min width of the popover panel
       */
  minWidth: PropTypes.any,
  /**
       * Change the default max width of the popover panel
       */
  maxWidth: PropTypes.any,
  /**
       * Function to call for 'Skip tour' and 'End tour' actions
       */
  onFinish: PropTypes.func.isRequired,
  /**
       * The number of the step within the parent tour. 1-based indexing.
       */
  step: PropTypes.number.isRequired,
  /**
       * The total number of steps in the tour
       */
  stepsTotal: PropTypes.number.isRequired,
  /**
       * Smaller title text that appears atop each step in the tour. The subtitle gets wrapped in the appropriate heading level.
       */
  subtitle: PropTypes.node,
  /**
       * Larger title text specific to this step. The title gets wrapped in the appropriate heading level.
       */
  title: PropTypes.node.isRequired,
  /**
       * Extra visual indication of step location
       */
  decoration: PropTypes.oneOf(["none", "beacon"]),
  /**
       * Accepts any `ReactNode` to replace the 'Skip tour' link in the footer.
       * Ideally, pass one button or an array of up to 2 buttons.
       */
  footerAction: PropTypes.oneOfType([PropTypes.node.isRequired, PropTypes.arrayOf(PropTypes.node.isRequired).isRequired])
};