function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { useReducer } from 'react';
import { assertNever } from '../common';
export var useEuiTour = function useEuiTour(stepsArray, initialState) {
  function reducer(state, action) {
    switch (action.type) {
      case 'EUI_TOUR_FINISH':
        {
          var currentTourStep = action.payload.resetTour ? 1 : state.currentTourStep;
          return _objectSpread(_objectSpread({}, state), {}, {
            currentTourStep: currentTourStep,
            isTourActive: false
          });
        }
      case 'EUI_TOUR_RESET':
        return _objectSpread(_objectSpread({}, state), {}, {
          currentTourStep: 1,
          isTourActive: true
        });
      case 'EUI_TOUR_NEXT':
        {
          var nextStep = state.currentTourStep === stepsArray.length ? state.currentTourStep : state.currentTourStep + 1;
          return _objectSpread(_objectSpread({}, state), {}, {
            currentTourStep: nextStep
          });
        }
      case 'EUI_TOUR_PREVIOUS':
        {
          var prevStep = state.currentTourStep === 1 ? state.currentTourStep : state.currentTourStep - 1;
          return _objectSpread(_objectSpread({}, state), {}, {
            currentTourStep: prevStep
          });
        }
      case 'EUI_TOUR_GOTO':
        {
          var step = action.payload.step;
          var isTourActive = typeof action.payload.isTourActive !== 'undefined' ? action.payload.isTourActive : state.isTourActive;
          var goTo = step <= stepsArray.length && step > 0 ? step : state.currentTourStep;
          return _objectSpread(_objectSpread({}, state), {}, {
            currentTourStep: goTo,
            isTourActive: isTourActive
          });
        }
      default:
        assertNever(action);
        return state;
    }
  }
  var _useReducer = useReducer(reducer, initialState),
    _useReducer2 = _slicedToArray(_useReducer, 2),
    state = _useReducer2[0],
    dispatch = _useReducer2[1];
  var actions = {
    finishTour: function finishTour() {
      var resetTour = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
      return dispatch({
        type: 'EUI_TOUR_FINISH',
        payload: {
          resetTour: resetTour
        }
      });
    },
    resetTour: function resetTour() {
      return dispatch({
        type: 'EUI_TOUR_RESET'
      });
    },
    decrementStep: function decrementStep() {
      return dispatch({
        type: 'EUI_TOUR_PREVIOUS'
      });
    },
    incrementStep: function incrementStep() {
      return dispatch({
        type: 'EUI_TOUR_NEXT'
      });
    },
    goToStep: function goToStep(step, isTourActive) {
      return dispatch({
        type: 'EUI_TOUR_GOTO',
        payload: {
          step: step,
          isTourActive: isTourActive
        }
      });
    }
  };
  var steps = stepsArray.map(function (step) {
    return _objectSpread(_objectSpread({}, step), {}, {
      isStepOpen: state.currentTourStep === step.step && state.isTourActive,
      minWidth: state.tourPopoverWidth,
      onFinish: actions.finishTour,
      stepsTotal: stepsArray.length,
      subtitle: state.tourSubtitle
    });
  });
  return [steps, actions, state];
};