var _excluded = ["id", "label", "className", "children", "display", "icon", "hasArrow", "isActive", "isExpanded", "buttonRef", "wrapperProps"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { memo } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiIcon } from '../icon';
import { euiTreeViewItemStyles } from './tree_view_item.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTreeViewItem = /*#__PURE__*/memo(function (_ref) {
  var id = _ref.id,
    label = _ref.label,
    className = _ref.className,
    children = _ref.children,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'default' : _ref$display,
    icon = _ref.icon,
    hasArrow = _ref.hasArrow,
    isActive = _ref.isActive,
    isExpanded = _ref.isExpanded,
    buttonRef = _ref.buttonRef,
    wrapperProps = _ref.wrapperProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = useEuiMemoizedStyles(euiTreeViewItemStyles);
  var wrapperClasses = classNames('euiTreeView__node', {
    'euiTreeView__node--expanded': isExpanded
  }, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.className);
  var wrapperStyles = [styles.li.euiTreeView__node, styles.li[display], isExpanded && styles.li.expanded];
  var buttonClasses = classNames('euiTreeView__nodeInner', className, {
    'euiTreeView__node--active': isActive
  });
  var buttonStyles = [styles.button.euiTreeView__nodeInner, styles.button[display]];
  var iconStyles = [styles.icon.euiTreeView__iconWrapper, styles.icon[display]];
  return ___EmotionJSX("li", _extends({}, wrapperProps, {
    css: wrapperStyles,
    className: wrapperClasses
  }), ___EmotionJSX("button", _extends({
    id: id,
    css: buttonStyles,
    className: buttonClasses,
    "aria-expanded": isExpanded,
    ref: buttonRef
  }, rest), hasArrow && (!!children ? ___EmotionJSX(EuiIcon, {
    className: "euiTreeView__expansionArrow",
    size: display === 'compressed' ? 's' : 'm',
    type: isExpanded ? 'arrowDown' : 'arrowRight'
  }) : ___EmotionJSX("span", {
    css: iconStyles,
    className: "euiTreeView__arrowPlaceholder"
  })), icon && ___EmotionJSX("span", {
    css: iconStyles,
    className: "euiTreeView__iconWrapper"
  }, icon), ___EmotionJSX("span", {
    className: "euiTreeView__nodeLabel eui-textTruncate"
  }, label)), children);
});
EuiTreeViewItem.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * Required for `aria-controls` accessibility
       */
  id: PropTypes.string.isRequired,
  /**
       * The main button content
       */
  label: PropTypes.node.isRequired,
  /**
       * Used to render nested `EuiTreeView`s
       */
  children: PropTypes.node,
  /**
       * Optional icon to render. Pass, e.g., `<EuiIcon />` or `<EuiToken />`
       */
  icon: PropTypes.node,
  /**
       * Renders an arrow if `children` exists. Otherwise renders a blank icon
       */
  hasArrow: PropTypes.bool,
  /**
       * Adds a targetable modifier class
       */
  isActive: PropTypes.bool,
  /**
       * Sets the `aria-expanded` attribute
       */
  isExpanded: PropTypes.bool,
  /**
       * Determines default or compressed display
       */
  display: PropTypes.oneOf(["default", "compressed"]),
  buttonRef: PropTypes.any,
  /**
       * Optional extra props to pass to the wrapping `<li>`
       */
  wrapperProps: PropTypes.any
};
EuiTreeViewItem.displayName = 'EuiTreeViewItem';