function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { transparentize } from '../../services';
import { euiFocusRing, logicalCSS, mathWithUnits } from '../../global_styling';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "22lgun-euiTreeView__node",
  styles: "list-style:none;label:euiTreeView__node;"
} : {
  name: "22lgun-euiTreeView__node",
  styles: "list-style:none;label:euiTreeView__node;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiTreeViewItemStyles = function euiTreeViewItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var defaultSize = euiTheme.size.xl;
  var compressedSize = euiTheme.size.l;
  return {
    li: {
      euiTreeView__node: _ref,
      default: /*#__PURE__*/css(logicalCSS('max-height', defaultSize), " line-height:", defaultSize, ";;label:default;"),
      compressed: /*#__PURE__*/css(logicalCSS('max-height', compressedSize), " line-height:", compressedSize, ";;label:compressed;"),
      expanded: /*#__PURE__*/css(logicalCSS('max-height', '100vh'), ";;label:expanded;")
    },
    button: {
      euiTreeView__nodeInner: /*#__PURE__*/css(logicalCSS('width', '100%'), " ", logicalCSS('padding-left', euiTheme.size.s), " ", logicalCSS('padding-right', euiTheme.size.xxs), " display:flex;align-items:center;&:focus{", euiFocusRing(euiThemeContext, 'inset'), ";}&:hover,&:active,&:focus{background-color:", transparentize(euiTheme.colors.text, euiTheme.focus.transparency), ";};label:euiTreeView__nodeInner;"),
      default: /*#__PURE__*/css(logicalCSS('height', defaultSize), " gap:", euiTheme.size.s, ";border-radius:", euiTheme.border.radius.medium, ";;label:default;"),
      compressed: /*#__PURE__*/css(logicalCSS('height', compressedSize), " gap:", euiTheme.size.xs, ";border-radius:", euiTheme.border.radius.small, ";;label:compressed;")
    },
    icon: {
      euiTreeView__iconWrapper: /*#__PURE__*/css("flex-shrink:0;line-height:0;&>*{", logicalCSS('max-width', '100%'), ";}&>.euiToken{", logicalCSS('max-height', '100%'), " ", logicalCSS('height', 'auto'), " svg{", logicalCSS('width', '100%'), ";}};label:euiTreeView__iconWrapper;"),
      default: /*#__PURE__*/css(logicalCSS('width', mathWithUnits(defaultSize, function (x) {
        return x / 2;
      })), ";;label:default;"),
      compressed: /*#__PURE__*/css(logicalCSS('width', mathWithUnits(compressedSize, function (x) {
        return x / 2;
      })), ";;label:compressed;")
    }
  };
};