declare module '@elastic/eui/src/services/keys' {
	export const ENTER = "Enter";
	export const SPACE = " ";
	export const ESCAPE = "Escape";
	export const TAB = "Tab";
	export const BACKSPACE = "Backspace";
	export const F2 = "F2";
	export const ALT = "Alt";
	export const SHIFT = "Shift";
	export const CTRL = "Control";
	export const META = "Meta";
	export const ARROW_DOWN = "ArrowDown";
	export const ARROW_UP = "ArrowUp";
	export const ARROW_LEFT = "ArrowLeft";
	export const ARROW_RIGHT = "ArrowRight";
	export const PAGE_UP = "PageUp";
	export const PAGE_DOWN = "PageDown";
	export const END = "End";
	export const HOME = "Home";
	export enum keys {
	    ENTER = "Enter",
	    SPACE = " ",
	    ESCAPE = "Escape",
	    TAB = "Tab",
	    BACKSPACE = "Backspace",
	    F2 = "F2",
	    ALT = "Alt",
	    SHIFT = "Shift",
	    CTRL = "Control",
	    META = "Meta",
	    ARROW_DOWN = "ArrowDown",
	    ARROW_UP = "ArrowUp",
	    ARROW_LEFT = "ArrowLeft",
	    ARROW_RIGHT = "ArrowRight",
	    PAGE_UP = "PageUp",
	    PAGE_DOWN = "PageDown",
	    END = "End",
	    HOME = "Home"
	}

}
declare module '@elastic/eui/src/services/accessibility/html_id_generator' {
	/**
	 * This function returns a function to generate ids.
	 * This can be used to generate unique, but predictable ids to pair labels
	 * with their inputs. It takes an optional prefix as a parameter. If you don't
	 * specify it, it generates a random id prefix. If you specify a custom prefix
	 * it should begin with an letter to be HTML4 compliant.
	 */
	export function htmlIdGenerator(idPrefix?: string): (idSuffix?: string) => string;
	/**
	 * Generates a memoized ID that remains static until component unmount.
	 * This prevents IDs from being re-randomized on every component update.
	 */
	export type UseGeneratedHtmlIdOptions = {
	    /**
	     * Optional prefix to prepend to the generated ID
	     */
	    prefix?: string;
	    /**
	     * Optional suffix to append to the generated ID
	     */
	    suffix?: string;
	    /**
	     * Optional conditional ID to use instead of a randomly generated ID.
	     * Typically used by EUI components where IDs can be passed in as custom props
	     */
	    conditionalId?: string;
	};
	export const useGeneratedHtmlId: ({ prefix, suffix, conditionalId, }?: UseGeneratedHtmlIdOptions) => string;

}
declare module '@elastic/eui/src/services/accessibility' {
	export { htmlIdGenerator, useGeneratedHtmlId } from '@elastic/eui/src/services/accessibility/html_id_generator';

}
declare module '@elastic/eui/src/services/alignment' {
	export const LEFT_ALIGNMENT = "left";
	export const RIGHT_ALIGNMENT = "right";
	export const CENTER_ALIGNMENT = "center";
	export type HorizontalAlignment = 'left' | 'right' | 'center';

}
declare module '@elastic/eui/src/global_styling/variables/breakpoint' {
	export const EuiThemeBreakpoints: readonly ["xs", "s", "m", "l", "xl"];
	export type _EuiThemeBreakpoint = string;
	export type _EuiThemeBreakpoints = Record<_EuiThemeBreakpoint, number> & {
	    /** - Default value: 0 */
	    xs: number;
	    /** - Default value: 575 */
	    s: number;
	    /** - Default value: 768 */
	    m: number;
	    /** - Default value: 992 */
	    l: number;
	    /** - Default value: 1200 */
	    xl: number;
	};

}
declare module '@elastic/eui/src/components/common' {
	import { AnchorHTMLAttributes, ButtonHTMLAttributes, ComponentProps, Component, FunctionComponent, JSXElementConstructor, MouseEventHandler } from 'react';
	import { Interpolation, Theme } from '@emotion/react';
	export interface CommonProps {
	    className?: string;
	    'aria-label'?: string;
	    'data-test-subj'?: string;
	    css?: Interpolation<Theme>;
	}
	export type NoArgCallback<T> = () => T;
	export const assertNever: (x: never) => never;
	/**
	 * XOR for some properties applied to a type
	 * (XOR is one of these but not both or neither)
	 *
	 * Usage: OneOf<typeToExtend, one | but | not | multiple | of | these | are | required>
	 *
	 * To require aria-label or aria-labelledby but not both
	 * Example: OneOf<Type, 'aria-label' | 'aria-labelledby'>
	 */
	export type OneOf<T, K extends keyof T> = Omit<T, K> & {
	    [k in K]: Pick<Required<T>, k> & {
	        [k1 in Exclude<K, k>]?: never;
	    };
	}[K];
	/**
	 * Wraps Object.keys with proper typescript definition of the resulting array
	 */
	export function keysOf<T extends object, K extends keyof T>(obj: T): K[];
	/**
	 * Like `keyof typeof`, but for getting values instead of keys
	 * ValueOf<typeof {key1: 'value1', key2: 'value2'}>
	 * Results in `'value1' | 'value2'`
	 */
	export type ValueOf<T> = T[keyof T];
	export type PropsOf<C> = C extends FunctionComponent<infer SFCProps> ? SFCProps : C extends FunctionComponent<infer FunctionProps> ? FunctionProps : C extends Component<infer ComponentProps> ? ComponentProps : never;
	export type PropsOfElement<C extends keyof JSX.IntrinsicElements | JSXElementConstructor<any>> = JSX.LibraryManagedAttributes<C, ComponentProps<C>>; type ExtractDefaultProps<T> = T extends {
	    defaultProps: infer D;
	} ? D : never; type ExtractProps<C extends new (...args: any) => any, IT = InstanceType<C>> = IT extends Component<infer P> ? P : never;
	/**
	 * Because of how TypeScript's LibraryManagedAttributes is designed to handle defaultProps (https://www.typescriptlang.org/docs/handbook/release-notes/typescript-3-0.html#support-for-defaultprops-in-jsx)
	 * we can't directly export the props definition as the defaulted values are not made optional,
	 * because it isn't processed by LibraryManagedAttributes. To get around this, we:
	 * - remove the props which have default values applied
	 * - export (Props - Defaults) & Partial<Defaults>
	 */
	export type ApplyClassComponentDefaults<C extends new (...args: any) => any, D = ExtractDefaultProps<C>, P = ExtractProps<C>> = Omit<P, keyof D> & {
	    [K in keyof D]?: K extends keyof P ? P[K] : never;
	}; type UnionKeys<T> = T extends any ? keyof T : never;
	export type DistributivePick<T, K extends UnionKeys<T>> = T extends any ? Pick<T, Extract<keyof T, K>> : never;
	export type DistributiveOmit<T, K extends UnionKeys<T>> = T extends any ? Omit<T, Extract<keyof T, K>> : never; type RecursiveDistributiveOmit<T, K extends PropertyKey> = T extends any ? T extends object ? RecursiveOmit<T, K> : T : never;
	export type RecursiveOmit<T, K extends PropertyKey> = Omit<{
	    [P in keyof T]: RecursiveDistributiveOmit<T[P], K>;
	}, K>;
	/**
	 * Returns member keys in U not present in T set to never
	 * T = { 'one', 'two', 'three' }
	 * U = { 'three', 'four', 'five' }
	 * returns { 'four': never, 'five': never }
	 */
	export type DisambiguateSet<T, U> = {
	    [P in Exclude<keyof T, keyof U>]?: never;
	};
	/**
	 * Allow either T or U, preventing any additional keys of the other type from being present
	 */
	export type ExclusiveUnion<T, U> = T | U extends object ? (DisambiguateSet<T, U> & U) | (DisambiguateSet<U, T> & T) : T | U;
	/**
	 * For components that conditionally render <button> or <a>
	 * Convenience types for extending base props (T) and
	 * element-specific props (P) with standard clickable properties
	 *
	 * These will likely be used together, along with `ExclusiveUnion`:
	 *
	 * type AnchorLike = PropsForAnchor<BaseProps>
	 * type ButtonLike = PropsForButton<BaseProps>
	 * type ComponentProps = ExclusiveUnion<AnchorLike, ButtonLike>
	 * const Component: FunctionComponent<ComponentProps> ...
	 */
	export type PropsForAnchor<T, P = {}> = T & {
	    href?: string;
	    onClick?: MouseEventHandler<HTMLAnchorElement>;
	} & AnchorHTMLAttributes<HTMLAnchorElement> & P;
	export type PropsForButton<T, P = {}> = T & {
	    onClick?: MouseEventHandler<HTMLButtonElement>;
	} & ButtonHTMLAttributes<HTMLButtonElement> & P;
	/**
	 * Replaces all properties on any type as optional, includes nested types
	 *
	 * @example
	 * ```ts
	 * interface Person {
	 *  name: string;
	 *  age?: number;
	 *  spouse: Person;
	 *  children: Person[];
	 * }
	 * type PartialPerson = RecursivePartial<Person>;
	 * // results in
	 * interface PartialPerson {
	 *  name?: string;
	 *  age?: number;
	 *  spouse?: RecursivePartial<Person>;
	 *  children?: RecursivePartial<Person>[]
	 * }
	 * ```
	 */
	export type RecursivePartial<T> = {
	    [P in keyof T]?: T[P] extends NonAny[] ? T[P] : T[P] extends readonly NonAny[] ? T[P] : T[P] extends Array<infer U> ? Array<RecursivePartial<U>> : T[P] extends ReadonlyArray<infer U> ? ReadonlyArray<RecursivePartial<U>> : T[P] extends Set<infer V> ? Set<RecursivePartial<V>> : T[P] extends Map<infer K, infer V> ? Map<K, RecursivePartial<V>> : T[P] extends NonAny ? T[P] : RecursivePartial<T[P]>;
	}; type NonAny = number | boolean | string | symbol | null;
	export {};

}
declare module '@elastic/eui/src/global_styling/variables/animations' {
	import { CSSProperties } from 'react';
	/**
	 * A constant storing the `prefers-reduced-motion` media query
	 * so that when it is turned off, animations are not run.
	 */
	export const euiCanAnimate = "@media screen and (prefers-reduced-motion: no-preference)";
	/**
	 * A constant storing the `prefers-reduced-motion` media query that will
	 * only apply the content if the setting is off (reduce).
	 */
	export const euiCantAnimate = "@media screen and (prefers-reduced-motion: reduce)";
	/**
	 * Speeds / Durations / Delays
	 */
	export const EuiThemeAnimationSpeeds: readonly ["extraFast", "fast", "normal", "slow", "extraSlow"];
	export type _EuiThemeAnimationSpeed = (typeof EuiThemeAnimationSpeeds)[number];
	export type _EuiThemeAnimationSpeeds = {
	    /** - Default value: 90ms */
	    extraFast: CSSProperties['animationDuration'];
	    /** - Default value: 150ms */
	    fast: CSSProperties['animationDuration'];
	    /** - Default value: 250ms */
	    normal: CSSProperties['animationDuration'];
	    /** - Default value: 350ms */
	    slow: CSSProperties['animationDuration'];
	    /** - Default value: 500ms */
	    extraSlow: CSSProperties['animationDuration'];
	};
	/**
	 * Easings / Timing functions
	 */
	export const EuiThemeAnimationEasings: readonly ["bounce", "resistance"];
	export type _EuiThemeAnimationEasing = (typeof EuiThemeAnimationEasings)[number];
	export type _EuiThemeAnimationEasings = Record<_EuiThemeAnimationEasing, CSSProperties['animationTimingFunction']>;
	export type _EuiThemeAnimation = _EuiThemeAnimationEasings & _EuiThemeAnimationSpeeds;

}
declare module '@elastic/eui/src/global_styling/variables/borders' {
	import { CSSProperties } from 'react';
	import { ColorModeSwitch } from '@elastic/eui/src/services/theme/types';
	export interface _EuiThemeBorderWidthValues {
	    /**
	     * Thinnest width for border
	     * - Default value: 1px
	     */
	    thin: CSSProperties['borderWidth'];
	    /**
	     * Thickest width for border
	     * - Default value: 2px
	     */
	    thick: CSSProperties['borderWidth'];
	}
	export interface _EuiThemeBorderRadiusValues {
	    /**
	     * Primary corner radius size
	     * - Default value: 6px
	     */
	    medium: CSSProperties['borderRadius'];
	    /**
	     * Small corner radius size
	     * - Default value: 4px
	     */
	    small: CSSProperties['borderRadius'];
	}
	export interface _EuiThemeBorderColorValues {
	    /**
	     * Color for all borders; Default is `colors.lightShade`
	     */
	    color: ColorModeSwitch;
	}
	export interface _EuiThemeBorderValues extends _EuiThemeBorderColorValues {
	    /**
	     * Varied thicknesses for borders
	     */
	    width: _EuiThemeBorderWidthValues;
	    /**
	     * Varied border radii
	     */
	    radius: _EuiThemeBorderRadiusValues;
	}
	export interface _EuiThemeBorderTypes {
	    /**
	     * Full `border` property string computed using `border.width.thin` and `border.color`
	     * - Default value: 1px solid [colors.lightShade]
	     */
	    thin: CSSProperties['border'];
	    /**
	     * Full `border` property string computed using `border.width.thick` and `border.color`
	     * - Default value: 2px solid [colors.lightShade]
	     */
	    thick: CSSProperties['border'];
	    /**
	     * Full editable style `border` property string computed using `border.width.thick` and `border.color`
	     * - Default value: 2px dotted [colors.lightShade]
	     */
	    editable: CSSProperties['border'];
	}
	export type _EuiThemeBorder = _EuiThemeBorderValues & _EuiThemeBorderTypes;

}
declare module '@elastic/eui/src/global_styling/variables/colors' {
	import { ColorModeSwitch, StrictColorModeSwitch } from '@elastic/eui/src/services/theme/types';
	/**
	 * Top 5 colors
	 */
	export type _EuiThemeBrandColors = {
	    /**
	     * Main brand color and used for most **call to actions** like buttons and links.
	     */
	    primary: ColorModeSwitch;
	    /**
	     * Pulls attention to key indicators like **notifications** or number of selections.
	     */
	    accent: ColorModeSwitch;
	    /**
	     * Used for **positive** messages/graphics and additive actions.
	     */
	    success: ColorModeSwitch;
	    /**
	     * Used for **warnings** and actions that have a potential to be destructive.
	     */
	    warning: ColorModeSwitch;
	    /**
	     * Used for **negative** messages/graphics like errors and destructive actions.
	     */
	    danger: ColorModeSwitch;
	};
	/**
	 * Every brand color must have a contrast computed text equivelant
	 */
	export type _EuiThemeBrandTextColors = {
	    /**
	     * Typically computed against `colors.primary`
	     */
	    primaryText: ColorModeSwitch;
	    /**
	     * Typically computed against `colors.accent`
	     */
	    accentText: ColorModeSwitch;
	    /**
	     * Typically computed against `colors.success`
	     */
	    successText: ColorModeSwitch;
	    /**
	     * Typically computed against `colors.warning`
	     */
	    warningText: ColorModeSwitch;
	    /**
	     * Typically computed against `colors.danger`
	     */
	    dangerText: ColorModeSwitch;
	};
	export type _EuiThemeShadeColors = {
	    /**
	     * Used as the background color of primary **page content and panels** including modals and flyouts.
	     */
	    emptyShade: ColorModeSwitch;
	    /**
	     * Used to lightly shade areas that contain **secondary content** or contain panel-like components.
	     */
	    lightestShade: ColorModeSwitch;
	    /**
	     * Used for most **borders** and dividers (horizontal rules).
	     */
	    lightShade: ColorModeSwitch;
	    /**
	     * The middle gray for all themes; this is the base for `colors.subdued`.
	     */
	    mediumShade: ColorModeSwitch;
	    /**
	     * Slightly subtle graphic color
	     */
	    darkShade: ColorModeSwitch;
	    /**
	     * Used as the **text** color and the background color for **inverted components** like tooltips and the control bar.
	     */
	    darkestShade: ColorModeSwitch;
	    /**
	     * The opposite of `emptyShade`
	     */
	    fullShade: ColorModeSwitch;
	};
	export type _EuiThemeTextColors = {
	    /**
	     * Computed against `colors.darkestShade`
	     */
	    text: ColorModeSwitch;
	    /**
	     * Computed against `colors.text`
	     */
	    title: ColorModeSwitch;
	    /**
	     * Computed against `colors.mediumShade`
	     */
	    subduedText: ColorModeSwitch;
	    /**
	     * Computed against `colors.primaryText`
	     */
	    link: ColorModeSwitch;
	};
	export type _EuiThemeSpecialColors = {
	    /**
	     * The background color for the **whole window (body)** and is a computed value of `colors.lightestShade`.
	     * Provides denominator (background) value for **contrast calculations**.
	     */
	    body: ColorModeSwitch;
	    /**
	     * Used to **highlight text** when matching against search strings
	     */
	    highlight: ColorModeSwitch;
	    /**
	     * Computed against `colors.darkestShade`
	     */
	    disabled: ColorModeSwitch;
	    /**
	     * Computed against `colors.disabled`
	     */
	    disabledText: ColorModeSwitch;
	    /**
	     * The base color for shadows that gets `transparentized`
	     * at a value based on the `colorMode` and then layered.
	     */
	    shadow: ColorModeSwitch;
	};
	export type _EuiThemeConstantColors = {
	    /**
	     * Purest **white**
	     */
	    ghost: string;
	    /**
	     * Purest **black**
	     */
	    ink: string;
	};
	export type _EuiThemeColorsMode = _EuiThemeBrandColors & _EuiThemeBrandTextColors & _EuiThemeShadeColors & _EuiThemeSpecialColors & _EuiThemeTextColors;
	export type _EuiThemeColors = StrictColorModeSwitch<_EuiThemeColorsMode> & _EuiThemeConstantColors;

}
declare module '@elastic/eui/src/global_styling/variables/size' {
	export type _EuiThemeBase = number;
	export const EuiThemeSizes: readonly ["xxs", "xs", "s", "m", "base", "l", "xl", "xxl", "xxxl", "xxxxl"];
	export type _EuiThemeSize = (typeof EuiThemeSizes)[number];
	export type _EuiThemeSizes = {
	    /** - Default value: 2px */
	    xxs: string;
	    /** - Default value: 4px */
	    xs: string;
	    /** - Default value: 8px */
	    s: string;
	    /** - Default value: 12px */
	    m: string;
	    /** - Default value: 16px */
	    base: string;
	    /** - Default value: 24px */
	    l: string;
	    /** - Default value: 32px */
	    xl: string;
	    /** - Default value: 40px */
	    xxl: string;
	    /** - Default value: 48px */
	    xxxl: string;
	    /** - Default value: 64px */
	    xxxxl: string;
	};

}
declare module '@elastic/eui/src/global_styling/variables/typography' {
	import { CSSProperties } from 'react';
	/**
	 * Font units of measure
	 */
	export const EuiThemeFontUnits: readonly ["rem", "px", "em"];
	export type _EuiThemeFontUnit = (typeof EuiThemeFontUnits)[number];
	export const EuiThemeFontScales: readonly ["xxxs", "xxs", "xs", "s", "m", "l", "xl", "xxl"];
	export type _EuiThemeFontScale = (typeof EuiThemeFontScales)[number];
	export type _EuiThemeFontScales = Record<_EuiThemeFontScale, number>;
	export type _EuiThemeFontBase = {
	    /**
	     * The whole font family stack for all parts of the UI.
	     * We encourage only customizing the first font in the stack.
	     */
	    family: string;
	    /**
	     * The font family used for monospace UI elements like EuiCode
	     */
	    familyCode?: string;
	    /**
	     * The font family used for serif UI elements like blockquotes within EuiText
	     */
	    familySerif?: string;
	    /**
	     * Controls advanced features OpenType fonts.
	     * https://developer.mozilla.org/en-US/docs/Web/CSS/font-feature-settings
	     */
	    featureSettings?: string;
	    /**
	     * Sets the default units used for font size & line height set by UI components
	     * like EuiText or EuiTitle. Defaults to `rem`.
	     *
	     * NOTE: This may overridden by some internal usages, e.g.
	     * EuiText's `relative` size which must use `em`.
	     *
	     * @default 'rem'
	     */
	    defaultUnits: _EuiThemeFontUnit;
	    /**
	     * A computed number that is 1/4 of `base`
	     */
	    baseline: number;
	    /**
	     * Establishes the ideal line-height percentage, but it is the `baseline` integer that establishes the final pixel/rem value
	     */
	    lineHeightMultiplier: number;
	};
	export const EuiThemeFontWeights: readonly ["light", "regular", "medium", "semiBold", "bold"];
	export type _EuiThemeFontWeight = (typeof EuiThemeFontWeights)[number];
	export type _EuiThemeFontWeights = {
	    /** - Default value: 300 */
	    light: CSSProperties['fontWeight'];
	    /** - Default value: 400 */
	    regular: CSSProperties['fontWeight'];
	    /** - Default value: 500 */
	    medium: CSSProperties['fontWeight'];
	    /** - Default value: 600 */
	    semiBold: CSSProperties['fontWeight'];
	    /** - Default value: 700 */
	    bold: CSSProperties['fontWeight'];
	};
	/**
	 * Body / Base styles
	 */
	export interface _EuiThemeBody {
	    /**
	     * A sizing key from one of the font scales to set as the base body font-size
	     */
	    scale: _EuiThemeFontScale;
	    /**
	     * A font weight key for setting the base body weight
	     */
	    weight: keyof _EuiThemeFontWeights;
	}
	/**
	 * Title styles
	 */
	export interface _EuiThemeTitle {
	    /**
	     * A font weight key for setting the base weight for titles and headings
	     */
	    weight: keyof _EuiThemeFontWeights;
	}
	export type _EuiThemeFont = _EuiThemeFontBase & {
	    scale: _EuiThemeFontScales;
	    /**
	     * @see {@link https://eui.elastic.co/#/theming/typography/values%23font-weight | Reference} for more information
	     */
	    weight: _EuiThemeFontWeights;
	    body: _EuiThemeBody;
	    title: _EuiThemeTitle;
	};

}
declare module '@elastic/eui/src/global_styling/variables/states' {
	import { ColorModeSwitch } from '@elastic/eui/src/services/theme/types';
	import { CSSProperties } from 'react';
	export interface _EuiThemeFocus {
	    /**
	     * Default color of the focus ring, some components may override this property
	     * - Default value: currentColor
	     */
	    color: ColorModeSwitch;
	    /**
	     * Thickness of the outline
	     * - Default value: 2px
	     */
	    width: CSSProperties['borderWidth'];
	    /**
	     * Used to transparentize the focus background color
	     * - Default value: { LIGHT: 0.1, DARK: 0.2 }
	     */
	    transparency: ColorModeSwitch<number>;
	    /**
	     * Default focus background color. Not all components set a background color on focus
	     * - Default value: `colors.primary` computed with `focus.transparency`
	     */
	    backgroundColor: ColorModeSwitch;
	}

}
declare module '@elastic/eui/src/global_styling/variables/levels' {
	import { CSSProperties } from 'react';
	/**
	 * Z-Index
	 *
	 * Remember that z-index is relative to parent and based on the stacking context.
	 * z-indexes only compete against other z-indexes when they exist as children of
	 * that shared parent.
	 *
	 * That means a popover with a settings of 2, will still show above a modal
	 * with a setting of 100, if it is within that modal and not besides it.
	 *
	 * Generally that means it's a good idea to consider things added to this file
	 * as competitive only as siblings.
	 *
	 * https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Positioning/Understanding_z_index/The_stacking_context
	 */
	export const EuiThemeLevels: readonly ["toast", "modal", "mask", "navigation", "menu", "header", "flyout", "maskBelowHeader", "content"];
	export type _EuiThemeLevel = (typeof EuiThemeLevels)[number];
	export type _EuiThemeLevels = {
	    /** - Default value: 9000 */
	    toast: NonNullable<CSSProperties['zIndex']>;
	    /** - Default value: 8000 */
	    modal: NonNullable<CSSProperties['zIndex']>;
	    /** - Default value: 6000 */
	    mask: NonNullable<CSSProperties['zIndex']>;
	    /** - Default value: 6000 */
	    navigation: NonNullable<CSSProperties['zIndex']>;
	    /** - Default value: 2000 */
	    menu: NonNullable<CSSProperties['zIndex']>;
	    /** - Default value: 1000 */
	    header: NonNullable<CSSProperties['zIndex']>;
	    /** - Default value: 1000 */
	    flyout: NonNullable<CSSProperties['zIndex']>;
	    /** - Default value: 1000 */
	    maskBelowHeader: NonNullable<CSSProperties['zIndex']>;
	    /** - Default value: 0 */
	    content: NonNullable<CSSProperties['zIndex']>;
	};

}
declare module '@elastic/eui/src/services/theme/types' {
	import type { CSSObject } from '@emotion/react';
	import { RecursivePartial, ValueOf } from '@elastic/eui/src/components/common';
	import { _EuiThemeAnimation } from '@elastic/eui/src/global_styling/variables/animations';
	import { _EuiThemeBreakpoints } from '@elastic/eui/src/global_styling/variables/breakpoint';
	import { _EuiThemeBorder } from '@elastic/eui/src/global_styling/variables/borders';
	import { _EuiThemeColors } from '@elastic/eui/src/global_styling/variables/colors';
	import { _EuiThemeBase, _EuiThemeSizes } from '@elastic/eui/src/global_styling/variables/size';
	import { _EuiThemeFont } from '@elastic/eui/src/global_styling/variables/typography';
	import { _EuiThemeFocus } from '@elastic/eui/src/global_styling/variables/states';
	import { _EuiThemeLevels } from '@elastic/eui/src/global_styling/variables/levels';
	export const COLOR_MODES_STANDARD: {
	    readonly light: "LIGHT";
	    readonly dark: "DARK";
	};
	export const COLOR_MODES_INVERSE: "INVERSE";
	export type EuiThemeColorModeInverse = typeof COLOR_MODES_INVERSE;
	export type EuiThemeColorModeStandard = ValueOf<typeof COLOR_MODES_STANDARD>;
	export type EuiThemeColorMode = 'light' | 'dark' | EuiThemeColorModeStandard | 'inverse' | EuiThemeColorModeInverse;
	export type ColorModeSwitch<T = string> = {
	    [key in EuiThemeColorModeStandard]: T;
	} | T;
	export type StrictColorModeSwitch<T = string> = {
	    [key in EuiThemeColorModeStandard]: T;
	};
	export type EuiThemeShape = {
	    colors: _EuiThemeColors;
	    /** - Default value: 16 */
	    base: _EuiThemeBase;
	    /**
	     * @see {@link https://eui.elastic.co/#/theming/sizing | Reference} for more information
	     */
	    size: _EuiThemeSizes;
	    font: _EuiThemeFont;
	    border: _EuiThemeBorder;
	    focus: _EuiThemeFocus;
	    animation: _EuiThemeAnimation;
	    breakpoint: _EuiThemeBreakpoints;
	    levels: _EuiThemeLevels;
	};
	export type EuiThemeSystem<T = {}> = {
	    root: EuiThemeShape & T;
	    model: EuiThemeShape & T;
	    key: string;
	};
	export type EuiThemeModifications<T = {}> = RecursivePartial<EuiThemeShape & T>;
	export type ComputedThemeShape<T, P = string | number | bigint | boolean | null | undefined> = T extends P | ColorModeSwitch<infer X> ? T extends ColorModeSwitch<X> ? X extends P ? X : {
	    [K in keyof (X & Exclude<T, keyof X | keyof StrictColorModeSwitch>)]: ComputedThemeShape<(X & Exclude<T, keyof X | keyof StrictColorModeSwitch>)[K], P>;
	} : T : {
	    [K in keyof T]: ComputedThemeShape<T[K], P>;
	};
	export type EuiThemeComputed<T = {}> = ComputedThemeShape<EuiThemeShape & T> & {
	    themeName: string;
	};
	export type EuiThemeNested = {
	    isGlobalTheme: boolean;
	    hasDifferentColorFromGlobalTheme: boolean;
	    bodyColor: string;
	    colorClassName: string;
	    setGlobalCSSVariables: Function;
	    globalCSSVariables?: CSSObject;
	    setNearestThemeCSSVariables: Function;
	    themeCSSVariables?: CSSObject;
	};

}
declare module '@elastic/eui/src/services/theme/utils' {
	import { EuiThemeColorMode, EuiThemeColorModeStandard, EuiThemeSystem, EuiThemeShape, EuiThemeComputed } from '@elastic/eui/src/services/theme/types';
	export const DEFAULT_COLOR_MODE: "LIGHT";
	/**
	 * Returns whether the provided color mode is `inverse`
	 * @param {string} colorMode - `light`, `dark`, or `inverse`
	 */
	export const isInverseColorMode: (colorMode?: string | undefined) => colorMode is "INVERSE";
	/**
	 * Returns the color mode configured in the current EuiThemeProvider.
	 * Returns the parent color mode if none is explicity set.
	 * @param {string} colorMode - `light`, `dark`, or `inverse`
	 * @param {string} parentColorMode - `LIGHT` or `DARK`; used as the fallback
	 */
	export const getColorMode: (colorMode?: EuiThemeColorMode | undefined, parentColorMode?: EuiThemeColorModeStandard | undefined) => EuiThemeColorModeStandard;
	/**
	 * Returns a value at a given path on an object.
	 * If `colorMode` is provided, will scope the value to the appropriate color mode key (LIGHT\DARK)
	 * @param {object} model - Object
	 * @param {string} _path - Dot-notated string to a path on the object
	 * @param {string} colorMode - `light` or `dark`
	 */
	export const getOn: (model: {
	    [key: string]: any;
	}, _path: string, colorMode?: EuiThemeColorModeStandard | undefined) => {
	    [key: string]: any;
	} | undefined;
	/**
	 * Sets a value at a given path on an object.
	 * @param {object} model - Object
	 * @param {string} _path - Dot-notated string to a path on the object
	 * @param {any} string -  The value to set
	 */
	export const setOn: (model: {
	    [key: string]: any;
	}, _path: string, value: any) => boolean;
	/**
	 * Creates a class to store the `computer` method and its eventual parameters.
	 * Allows for on-demand computation with up-to-date parameters via `getValue` method.
	 * @constructor
	 * @param {function} computer - Function to be computed
	 * @param {string | array} dependencies - Dependencies passed to the `computer` as parameters
	 */
	export class Computed<T> {
	    computer: (...values: any[]) => T;
	    dependencies: string | string[];
	    constructor(computer: (...values: any[]) => T, dependencies?: string | string[]);
	    /**
	     * Executes the `computer` method with the current state of the theme
	     * by taking into account previously computed values and modifications.
	     * @param {Proxy | object} base - Computed or uncomputed theme
	     * @param {Proxy | object} modifications - Theme value overrides
	     * @param {object} working - Partially computed theme
	     * @param {string} colorMode - `light` or `dark`
	     */
	    getValue(base: EuiThemeSystem | EuiThemeShape, modifications: import ("@elastic/eui").RecursivePartial<EuiThemeShape> | undefined, working: EuiThemeComputed, colorMode: EuiThemeColorModeStandard): T;
	}
	/**
	 * Returns a Class (`Computed`) that stores the arbitrary computer method
	 * and references to its optional dependecies.
	 * @param {function} computer - Arbitrary method to be called at compute time.
	 * @param {string | array} dependencies - Values that will be provided to `computer` at compute time.
	 */
	export function computed<T>(computer: (value: EuiThemeComputed) => T): T;
	export function computed<T>(computer: (value: any[]) => T, dependencies: string[]): T;
	export function computed<T>(computer: (value: any) => T, dependencies: string): T;
	/**
	 * Takes an uncomputed theme, and computes and returns all values taking
	 * into consideration value overrides and configured color mode.
	 * Overrides take precedence, and only values in the current color mode
	 * are computed and returned.
	 * @param {Proxy} base - Object to transform into Proxy
	 * @param {Proxy | object} over - Unique identifier or name
	 * @param {string} colorMode - `light` or `dark`
	 */
	export const getComputed: <T = EuiThemeShape>(base: EuiThemeSystem<T>, over: Partial<EuiThemeSystem<T>>, colorMode: EuiThemeColorModeStandard) => EuiThemeComputed<T>;
	/**
	 * Builds a Proxy with a custom `handler` designed to self-reference values
	 * and prevent arbitrary value overrides.
	 * @param {object} model - Object to transform into Proxy
	 * @param {string} key - Unique identifier or name
	 */
	export const buildTheme: <T extends {}>(model: T, key: string) => {
	    model: T;
	    root: T;
	    key: string;
	};
	/**
	 * Deeply merges two objects, using `source` values whenever possible.
	 * @param {object} _target - Object with fallback values
	 * @param {object} source - Object with desired values
	 */
	export const mergeDeep: (_target: {
	    [key: string]: any;
	}, source?: {
	    [key: string]: any;
	}) => {
	    [key: string]: any;
	};

}
declare module '@elastic/eui/src/services/color/is_color_dark' {
	/**
	 * This function calculates if the specified color is "dark", which usually means
	 * you need light text if you use it as a background color to fulfill WCAG contrast
	 * requirement.
	 * The color must be specified via its red, green and blue value in the range of
	 * 0 to 255.
	 * The formula is based on this Stackoverflow answer: https://stackoverflow.com/a/3943023
	 * which itself is based upon the WCAG recommendation for color contrast.
	 *
	 * @param {number} red The red component in the range 0 to 255
	 * @param {number} green The green component in the range 0 to 255
	 * @param {number} blue The blue component in the range 0 to 255
	 * @returns {boolean} True if the color is dark, false otherwise.
	 */
	export function isColorDark(red: number, green: number, blue: number): boolean;

}
declare module '@elastic/eui/src/services/color/is_valid_hex' {
	export function isValidHex(hex: string): boolean;

}
declare module '@elastic/eui/src/services/color/color_types' {
	export type rgbDef = [number, number, number];
	export interface HSV {
	    h: number;
	    s: number;
	    v: number;
	}
	export interface RGB {
	    r: number;
	    g: number;
	    b: number;
	}
	export type HEX = string;

}
declare module '@elastic/eui/src/services/color/hex_to_rgb' {
	import { rgbDef } from '@elastic/eui/src/services/color/color_types';
	export function hexToRgb(hex: string): rgbDef;

}
declare module '@elastic/eui/src/services/color/rgb_to_hsv' {
	import { HSV, RGB } from '@elastic/eui/src/services/color/color_types';
	export function rgbToHsv({ r, g, b }: RGB): HSV;

}
declare module '@elastic/eui/src/services/color/hex_to_hsv' {
	import { HEX, HSV } from '@elastic/eui/src/services/color/color_types';
	export function hexToHsv(hex: HEX): HSV;

}
declare module '@elastic/eui/src/services/color/hsv_to_rgb' {
	import { HSV, RGB } from '@elastic/eui/src/services/color/color_types';
	export function hsvToRgb({ h, s, v }: HSV): RGB;

}
declare module '@elastic/eui/src/services/color/rgb_to_hex' {
	export function rgbToHex(rgb: string): string;

}
declare module '@elastic/eui/src/services/color/hsv_to_hex' {
	import { HEX, HSV } from '@elastic/eui/src/services/color/color_types';
	export function hsvToHex({ h, s, v }: HSV): HEX;

}
declare module '@elastic/eui/src/services/color/luminance_and_contrast' {
	import { rgbDef } from '@elastic/eui/src/services/color/color_types';
	export function calculateLuminance(r: number, g: number, b: number): number;
	export function calculateContrast(rgb1: rgbDef, rgb2: rgbDef): number;

}
declare module '@elastic/eui/src/services/color/color_palette' {
	export const MID_COLOR_STOP = "#EBEFF5";
	/**
	 * This function takes an array of colors and returns an array of interpolated
	 * colors based on the number of steps/len needed for use in UI elements such as charts.
	 * Derived from https://github.com/gka/palettes (Unlicensed)
	 */
	export function colorPalette(
	/**
	 * The main color code or array of codes
	 */
	colors: string[], 
	/**
	 * The number of colors in the resulting array (default 10)
	 */
	len?: number, 
	/**
	 * Forces color interpolation to be calculated separately for each half (default false)
	 */
	diverging?: boolean, 
	/**
	 * Uses a more static interpolation for non-continuous spectrums
	 */
	categorical?: boolean): string[];

}
declare module '@elastic/eui/src/services/color/eui_palettes' {
	export type EuiPalette = string[];
	export interface EuiPaletteColorBlindProps {
	    /**
	     * How many variations of the series is needed
	     */
	    rotations?: number;
	    /**
	     * Order similar colors as `group`s or just `append` each variation
	     */
	    order?: 'append' | 'group';
	    /**
	     * Specifies if the direction of the color variations
	     */
	    direction?: 'lighter' | 'darker' | 'both';
	    /**
	     * Use the default sort order, or re-sort them based on the color wheel (natural)
	     */
	    sortBy?: 'default' | 'natural';
	    /**
	     * Shift the sorting order by a certain number when used in conjunction with `'natural'` `sortBy`.
	     * Defaults to a number close to green.
	     */
	    sortShift?: string;
	}
	export const euiPaletteColorBlind: ({ rotations, order, direction, sortBy, sortShift, }?: EuiPaletteColorBlindProps) => EuiPalette;
	/**
	 * Color blind palette with text is meant for use when text is applied on top of the color.
	 * It increases the brightness of the color to give the text more contrast.
	 */
	export const euiPaletteColorBlindBehindText: (paletteProps?: EuiPaletteColorBlindProps) => string[];
	export const euiPaletteForLightBackground: () => EuiPalette;
	export const euiPaletteForDarkBackground: () => EuiPalette;
	export const euiPaletteForStatus: (steps: number) => EuiPalette;
	export const euiPaletteForTemperature: (steps: number) => EuiPalette;
	export const euiPaletteComplementary: (steps: number) => EuiPalette;
	export const euiPaletteRed: (steps: number) => EuiPalette;
	export const euiPaletteGreen: (steps: number) => EuiPalette;
	export const euiPaletteCool: (steps: number) => EuiPalette;
	export const euiPaletteWarm: (steps: number) => EuiPalette;
	export const euiPaletteGray: (steps: number) => EuiPalette;

}
declare module '@elastic/eui/src/services/color/visualization_colors' {
	export const VISUALIZATION_COLORS: import ("@elastic/eui/src/services/color/eui_palettes").EuiPalette;
	export const DEFAULT_VISUALIZATION_COLOR: string;

}
declare module '@elastic/eui/src/global_styling/mixins/_color' {
	import { SerializedStyles } from '@emotion/react';
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const BACKGROUND_COLORS: readonly ["transparent", "plain", "subdued", "accent", "primary", "success", "warning", "danger"];
	export type _EuiBackgroundColor = (typeof BACKGROUND_COLORS)[number];
	export interface _EuiBackgroundColorOptions {
	    /**
	     * Use `opaque` for containers of unknown content.
	     * Use `transparent` for interactive states like hover and focus.
	     */
	    method?: 'opaque' | 'transparent';
	}
	/**
	 * @returns A single background color with optional alpha transparency
	 */
	export const euiBackgroundColor: ({ euiTheme, colorMode }: UseEuiTheme, color: _EuiBackgroundColor, { method }?: _EuiBackgroundColorOptions) => string;
	export const useEuiBackgroundColor: (color: _EuiBackgroundColor, { method }?: _EuiBackgroundColorOptions) => string;
	export const useEuiBackgroundColorCSS: () => Record<"transparent" | "plain" | "subdued" | "accent" | "primary" | "success" | "warning" | "danger", SerializedStyles>;
	/**
	 * Border colors
	 */
	export const euiBorderColor: ({ euiTheme, colorMode }: UseEuiTheme, color: _EuiBackgroundColor) => string;
	export const useEuiBorderColorCSS: () => Record<"transparent" | "plain" | "subdued" | "accent" | "primary" | "success" | "warning" | "danger", SerializedStyles>;

}
declare module '@elastic/eui/src/services/emotion/clone_element' {
	import React from 'react';
	/**
	 * React.cloneElement does not work if the cloned element does not already have the
	 * `css` prop - as a result, we need to use `jsx()` to manually clone the element
	 * See https://github.com/emotion-js/emotion/issues/1404
	 */
	export const cloneElementWithCss: (element: any, props: any, cssOrder?: 'before' | 'after') => React.ReactElement;

}
declare module '@elastic/eui/src/services/emotion/prefixer' {
	import { type Element } from 'stylis';
	/**
	 * This is a stylis plugin which handles auto-prefixing CSS output by Emotion.
	 *
	 * *Please note*: EUI/Elastic targets latest evergreen browsers for support only.
	 * @see https://www.elastic.co/support/matrix#matrix_browsers
	 */
	export const euiStylisPrefixer: (element: Element) => void;

}
declare module '@elastic/eui/src/services/emotion' {
	export * from '@elastic/eui/src/services/emotion/clone_element';
	export * from '@elastic/eui/src/services/emotion/prefixer';

}
declare module '@elastic/eui/src/services/emotion/css' {
	/**
	 * This custom instance is needed for internal EUI components to call
	 * `@emotion/css` with EUI's custom prefixer plugin
	 * @see https://emotion.sh/docs/@emotion/css#custom-instances
	 *
	 * NOTE: Usage is currently being beta tested internally,
	 * and is not yet intended to be a public export
	 */
	export const css: {
	    (template: TemplateStringsArray, ...args: import("@emotion/serialize").CSSInterpolation[]): string;
	    (...args: import("@emotion/serialize").CSSInterpolation[]): string;
	}, cx: (...classNames: import("@emotion/css/create-instance").ClassNamesArg[]) => string, cache: import("@emotion/utils").EmotionCache;

}
declare module '@elastic/eui/src/services/theme/emotion' {
	import { FunctionComponent, PropsWithChildren } from 'react';
	/**
	 * @see https://emotion.sh/docs/theming
	 * This Emotion theme provider is added for *consumer usage* & convenience only.
	 *
	 * EUI should stick to using our own context/`useEuiTheme` internally
	 * instead of Emotion's shorthand `css={theme => {}}` API. If consumers
	 * set their own theme via <ThemeProvider>; EUI's styles should continue
	 * working as-is.
	 */
	export const EuiEmotionThemeProvider: FunctionComponent<PropsWithChildren<{}>>;

}
declare module '@elastic/eui/src/services/hooks/useUpdateEffect' {
	export const useUpdateEffect: (effect: Function, deps: unknown[]) => void;

}
declare module '@elastic/eui/src/services/hooks/useDependentState' {
	export function useDependentState<T>(valueFn: (previousState: undefined | T) => T, deps: unknown[]): readonly [T, import("react").Dispatch<import("react").SetStateAction<T>>];

}
declare module '@elastic/eui/src/services/hooks/useCombinedRefs' {
	import { MutableRefObject, Ref } from 'react'; type Refs<T> = Array<Ref<T> | MutableRefObject<T | undefined> | undefined>;
	export const useCombinedRefs: <T>(refs: Refs<T>) => (node: T) => void;
	/**
	 * Non-hook util for setting multiple refs/ref types.
	 * Useful for non-functional components
	 */
	export const setMultipleRefs: <T>(refs: Refs<T>, node: T) => void;
	export {};

}
declare module '@elastic/eui/src/services/hooks/useForceRender' {
	export const useForceRender: () => () => void;

}
declare module '@elastic/eui/src/services/hooks/useLatest' {
	import { MutableRefObject } from 'react';
	/**
	 * Wraps the given `value` into a `MutableRefObject` and keeps the `current`
	 * value up-to-date on every render cycle.
	 */
	export function useLatest<Value>(value: Value): MutableRefObject<Value | null>;

}
declare module '@elastic/eui/src/services/hooks/useDeepEqual' {
	/**
	 * This hook is mostly a performance concern for third-party objs/arrays that EUI
	 * has no control over and may not be correctly memoized (i.e., will create a new
	 * reference on every rerender unless passed through this hook).
	 */
	export const useDeepEqual: <T = any[] | Record<string, any> | undefined>(object: T) => T;

}
declare module '@elastic/eui/src/services/throttle' {
	export const throttle: (fn: (...args: any[]) => void, wait?: number) => (...args: any[]) => void;

}
declare module '@elastic/eui/src/services/hooks/useMouseMove' {
	import { MouseEvent, TouchEvent } from 'react';
	export function isMouseEvent<T = HTMLDivElement>(event: MouseEvent<T> | TouchEvent<T>): event is MouseEvent<T>;
	export function useMouseMove<T = HTMLDivElement>(handleChange: (location: {
	    x: number;
	    y: number;
	}, isFirstInteraction?: boolean) => void, interactionConditional?: any): [
	    (e: MouseEvent<T>) => void,
	    (e: MouseEvent<T> | TouchEvent<T>, isFirstInteraction?: boolean) => void
	];

}
declare module '@elastic/eui/src/services/hooks' {
	export * from '@elastic/eui/src/services/hooks/useDependentState';
	export * from '@elastic/eui/src/services/hooks/useCombinedRefs';
	export * from '@elastic/eui/src/services/hooks/useForceRender';
	export * from '@elastic/eui/src/services/hooks/useLatest';
	export * from '@elastic/eui/src/services/hooks/useDeepEqual';
	export * from '@elastic/eui/src/services/hooks/useMouseMove';
	export * from '@elastic/eui/src/services/hooks/useUpdateEffect';

}
declare module '@elastic/eui/src/services/theme/warning' {
	 type LEVELS = 'log' | 'warn' | 'error'; type ProviderCallback = (message: string | Error) => void; let providerWarning: LEVELS | ProviderCallback | undefined;
	export const setEuiDevProviderWarning: (warningType: typeof providerWarning) => LEVELS | ProviderCallback | undefined;
	export const getEuiDevProviderWarning: () => LEVELS | ProviderCallback | undefined;
	export const emitEuiProviderWarning: (providerMessage: string) => void;
	export {};

}
declare module '@elastic/eui/src/services/theme/style_memoization' {
	import React, { FunctionComponent, PropsWithChildren } from 'react';
	import { UseEuiTheme } from '@elastic/eui/src/services/theme/hooks'; type StylesMap = Record<string, any>; type MemoizedStylesMap = WeakMap<Function, StylesMap>;
	export const EuiThemeMemoizedStylesContext: React.Context<MemoizedStylesMap>;
	export const EuiThemeMemoizedStylesProvider: FunctionComponent<PropsWithChildren>;
	/**
	 * Hook that memoizes the returned values of components style fns/generators
	 * per-theme
	 */
	export const useEuiMemoizedStyles: <T extends (theme: UseEuiTheme) => StylesMap>(stylesGenerator: T) => ReturnType<T>;
	/**
	 * HOC for class components
	 * Syntax is mostly copied from withEuiTheme HOC
	 */
	export interface WithEuiStylesMemoizerProps {
	    stylesMemoizer: typeof useEuiMemoizedStyles;
	}
	export const withEuiStylesMemoizer: <T extends {} = {}>(Component: React.ComponentType<T & WithEuiStylesMemoizerProps>) => React.ForwardRefExoticComponent<React.PropsWithoutRef<Omit<T, "stylesMemoizer">> & React.RefAttributes<Omit<T, "stylesMemoizer">>>;
	/**
	 * Render prop alternative for complex class components
	 * Most useful for scenarios where a HOC may interfere with typing
	 */
	export const RenderWithEuiStylesMemoizer: ({ children, }: {
	    children: (stylesMemoizer: typeof useEuiMemoizedStyles) => React.ReactElement;
	}) => React.ReactElement<any, string | React.JSXElementConstructor<any>>;
	export {};

}
declare module '@elastic/eui/src/services/theme/provider' {
	import React, { PropsWithChildren, HTMLAttributes } from 'react';
	import type { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiThemeColorMode, EuiThemeSystem, EuiThemeModifications } from '@elastic/eui/src/services/theme/types';
	export interface EuiThemeProviderProps<T> extends PropsWithChildren {
	    theme?: EuiThemeSystem<T>;
	    colorMode?: EuiThemeColorMode;
	    modify?: EuiThemeModifications<T>;
	    children: any;
	    /**
	     * Nested theme providers will receive a wrapping `span` tag in order to correctly
	     * set the default text `color` that all nested children will inherit.
	     *
	     * If an extra wrapper is not desired, pass `{ cloneElement: true }`.
	     * This requires a **single** child component that the correct color class can be passed to.
	     *
	     * The parent level `EuiProvider`/`EuiThemeProvider` will **not** render a wrapper element, as
	     * the default inherited text color will be set on the page `body`.
	     */
	    wrapperProps?: HTMLAttributes<HTMLElement> & CommonProps & {
	        cloneElement?: boolean;
	    };
	}
	export const EuiThemeProvider: <T extends {} = {}>({ theme: _system, colorMode: _colorMode, modify: _modifications, children, wrapperProps, }: EuiThemeProviderProps<T>) => React.JSX.Element;

}
declare module '@elastic/eui/src/services/theme' {
	export { EuiSystemContext, EuiThemeContext, EuiNestedThemeContext, EuiModificationsContext, EuiColorModeContext, } from '@elastic/eui/src/services/theme/context';
	export type { UseEuiTheme, WithEuiThemeProps } from '@elastic/eui/src/services/theme/hooks';
	export { useEuiTheme, withEuiTheme, RenderWithEuiTheme, useEuiThemeCSSVariables, } from '@elastic/eui/src/services/theme/hooks';
	export type { EuiThemeProviderProps } from '@elastic/eui/src/services/theme/provider';
	export { EuiThemeProvider } from '@elastic/eui/src/services/theme/provider';
	export { useEuiMemoizedStyles, withEuiStylesMemoizer, type WithEuiStylesMemoizerProps, RenderWithEuiStylesMemoizer, } from '@elastic/eui/src/services/theme/style_memoization';
	export { getEuiDevProviderWarning, setEuiDevProviderWarning } from '@elastic/eui/src/services/theme/warning';
	export { buildTheme, computed, isInverseColorMode, getColorMode, getComputed, getOn, mergeDeep, setOn, Computed, } from '@elastic/eui/src/services/theme/utils';
	export type { ComputedThemeShape, EuiThemeColorMode, EuiThemeColorModeStandard, EuiThemeComputed, EuiThemeModifications, EuiThemeShape, EuiThemeSystem, } from '@elastic/eui/src/services/theme/types';
	export { COLOR_MODES_STANDARD } from '@elastic/eui/src/services/theme/types';

}
declare module '@elastic/eui/src/global_styling/functions/logicals' {
	import { CSSProperties } from 'react';
	/**
	 * EUI utilizes logical CSS properties to enable directional writing-modes.
	 * To encourage use of logical properties, we provide a few helper utilities to
	 * convert certain directional properties to logical properties.
	 * https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Logical_Properties
	 */
	export const logicalSide: {
	    left: string;
	    right: string;
	    top: string;
	    bottom: string;
	    horizontal: string;
	    vertical: string;
	};
	export const LOGICAL_SIDES: ("left" | "right" | "bottom" | "top" | "horizontal" | "vertical")[];
	export type LogicalSides = (typeof LOGICAL_SIDES)[number];
	export const logicals: {
	    height: string;
	    width: string;
	    "max-height": string;
	    "max-width": string;
	    "min-height": string;
	    "min-width": string;
	    top: string;
	    right: string;
	    bottom: string;
	    left: string;
	    horizontal: string;
	    vertical: string;
	    "margin-left": string;
	    "margin-right": string;
	    "margin-top": string;
	    "margin-bottom": string;
	    "margin-horizontal": string;
	    "margin-vertical": string;
	    "padding-left": string;
	    "padding-right": string;
	    "padding-top": string;
	    "padding-bottom": string;
	    "padding-horizontal": string;
	    "padding-vertical": string;
	    "overflow-x": string;
	    "overflow-y": string;
	    "border-horizontal": string;
	    "border-horizontal-color": string;
	    "border-horizontal-width": string;
	    "border-horizontal-style": string;
	    "border-vertical": string;
	    "border-vertical-color": string;
	    "border-vertical-width": string;
	    "border-vertical-style": string;
	    "border-bottom": string;
	    "border-bottom-color": string;
	    "border-bottom-style": string;
	    "border-bottom-width": string;
	    "border-top": string;
	    "border-top-color": string;
	    "border-top-style": string;
	    "border-top-width": string;
	    "border-right": string;
	    "border-right-color": string;
	    "border-right-style": string;
	    "border-right-width": string;
	    "border-left": string;
	    "border-left-color": string;
	    "border-left-style": string;
	    "border-left-width": string;
	    "border-top-left-radius": string;
	    "border-top-right-radius": string;
	    "border-bottom-left-radius": string;
	    "border-bottom-right-radius": string;
	    _shorthands: string[];
	};
	export const LOGICAL_PROPERTIES: ("left" | "right" | "width" | "bottom" | "height" | "top" | "horizontal" | "vertical" | "max-height" | "max-width" | "min-height" | "min-width" | "margin-left" | "margin-right" | "margin-top" | "margin-bottom" | "margin-horizontal" | "margin-vertical" | "padding-left" | "padding-right" | "padding-top" | "padding-bottom" | "padding-horizontal" | "padding-vertical" | "overflow-x" | "overflow-y" | "border-horizontal" | "border-horizontal-color" | "border-horizontal-width" | "border-horizontal-style" | "border-vertical" | "border-vertical-color" | "border-vertical-width" | "border-vertical-style" | "border-bottom" | "border-bottom-color" | "border-bottom-style" | "border-bottom-width" | "border-top" | "border-top-color" | "border-top-style" | "border-top-width" | "border-right" | "border-right-color" | "border-right-style" | "border-right-width" | "border-left" | "border-left-color" | "border-left-style" | "border-left-width" | "border-top-left-radius" | "border-top-right-radius" | "border-bottom-left-radius" | "border-bottom-right-radius")[];
	export type LogicalProperties = (typeof LOGICAL_PROPERTIES)[number];
	/**
	 *
	 * @param property A string that is a valid CSS logical property
	 * @param value String to output as the property value
	 * @returns `string` Returns the logical CSS property version for the given `property: value` pair
	 */
	export const logicalCSS: (property: LogicalProperties, value?: any) => string;
	/**
	 * Some logical properties are not yet fully supported by all browsers.
	 * For those cases, we should use the old property as a fallback for
	 * browsers missing support, while allowing supporting browsers to use
	 * the logical properties.
	 *
	 * Examples:
	 * https://caniuse.com/?search=overflow-block
	 * https://caniuse.com/mdn-css_properties_float_flow_relative_values
	 */
	export const logicalCSSWithFallback: (property: LogicalProperties, value?: any) => string;
	/**
	 *
	 * @param property A string that is a valid CSS logical property
	 * @param value String to output as the property value
	 * @returns `object` Returns the logical CSS property version for the given `property: value` pair
	 */
	export const logicalStyle: (property: LogicalProperties, value?: any) => {
	    [x: string]: any;
	};
	/**
	 * Given a style object with any amount of unknown CSS properties,
	 * find ones that can be converted to logical properties and convert them
	 *
	 * @param styleObject - A React object of camelCased styles
	 * @returns `object`
	 */
	export const logicalStyles: (styleObject: CSSProperties) => Record<string, string | number | undefined>;
	/**
	 *
	 * @param width A string value for the LTR width
	 * @param height A string value for the LTR height
	 * @returns `string` Returns the logical CSS properties for height and width
	 */
	export const logicalSizeCSS: (width: any, height?: any) => string;
	/**
	 *
	 * @param width A string value for the LTR width
	 * @param height A string value for the LTR height
	 * @returns `object` Returns the logical CSS properties for height and width
	 */
	export const logicalSizeStyle: (width: any, height: any) => {
	    [x: string]: any;
	};
	export const logicalText: {
	    'text-align': {
	        left: string;
	        center: string;
	        right: string;
	    };
	};
	export const LOGICAL_TEXT_ALIGNMENT: ("left" | "right" | "center")[];
	export type LogicalText = (typeof LOGICAL_TEXT_ALIGNMENT)[number];
	/**
	 *
	 * @param property A string that is a valid CSS logical property
	 * @param value String to output as the property value
	 * @returns `string` Returns the logical CSS property version for the given `property: value` pair
	 */
	export const logicalTextAlignCSS: (value: LogicalText) => string;
	/**
	 *
	 * @param property A string that is a valid CSS logical property
	 * @param value String to output as the property value
	 * @returns `object` Returns the logical CSS property version for the given `property: value` pair
	 */
	export const logicalTextAlignStyle: (value: LogicalText) => {
	    textAlign: string;
	};

}
declare module '@elastic/eui/src/global_styling/functions/logical_shorthands' {
	export const LOGICAL_SHORTHANDS: string[];
	export type LogicalShorthands = (typeof LOGICAL_SHORTHANDS)[number];
	/**
	 * Unfortunately, shorthand properties that describe boxes
	 * (@see https://developer.mozilla.org/en-US/docs/Web/CSS/Shorthand_properties#edges_of_a_box)
	 * do not currently automatically respond to logical changes in display direction
	 * (@see https://github.com/w3c/csswg-drafts/issues/1282)
	 *
	 * This utility is essentially a stop-gap for those shorthand properties,
	 * converting them to corresponding longer logical `-inline` and `-block` properties
	 *
	 * 🗑 NOTE: This file is in a separate util file from logicals.ts due to its relatively
	 * convoluted logic, & to make deleting it easier when an official CSS spec is implemented.
	 */
	export const logicalShorthandCSS: (property: LogicalShorthands, value: string | number) => string;
	/**
	 * Logical border radius is unfortunately a very special case as it handles corners
	 * and not sides (@see https://developer.mozilla.org/en-US/docs/Web/CSS/Shorthand_properties#corners_of_a_box)
	 * and does not have `-inline` or `-block` shorthands.
	 *
	 * It also needs to account for `/` syntax (horizontal vs vertical radii)
	 * @see https://www.sitepoint.com/setting-css3-border-radius-with-slash-syntax/
	 */
	export const logicalBorderRadiusCSS: (value: string, ignoreZeroes?: boolean) => string;

}
declare module '@elastic/eui/src/global_styling/functions/math' {
	 type ValueTypes = string | number | undefined;
	export const mathWithUnits: (values: ValueTypes | ValueTypes[], callback: (...args: number[]) => number, unit?: string) => string;
	export {};

}
declare module '@elastic/eui/src/global_styling/functions/size' {
	/**
	 * Calculates the `px` value based on a scale multiplier
	 * @param scale - The font scale multiplier
	 * *
	 * @param themeOrBase - Theme base value
	 * *
	 * @returns string - Rem unit aligned to baseline
	 */
	export const sizeToPixel: (scale?: number) => (themeOrBase: number | {
	    [key: string]: any;
	    base: number;
	}) => string;

}
declare module '@elastic/eui/src/global_styling/functions/typography' {
	import { _EuiThemeFontScale, _EuiThemeFontUnit, _EuiThemeFontWeights } from '@elastic/eui/src/global_styling/variables/typography';
	import { UseEuiTheme } from '@elastic/eui/src/services/theme/hooks';
	export interface _FontScaleOptions {
	    /**
	     * The font-size or line-height unit to return
	     */
	    unit?: _EuiThemeFontUnit;
	    /**
	     * An additional custom scale multiplier to use against the current scale
	     * This parameter can be used (e.g. by EuiText sizes) to get sizes of text smaller than the default
	     */
	    customScale?: _EuiThemeFontScale;
	}
	/**
	 * Calculates the font-size value based on the provided scale key
	 * @param scale - The font scale key
	 * @param theme - Requires the `base` and `font` keys
	 * @param options - Optional parameters - see _FontScaleOptions
	 *
	 * @returns string - Calculated font-size value
	 */
	export function euiFontSizeFromScale(scale: _EuiThemeFontScale, { base, font }: UseEuiTheme['euiTheme'], { unit, customScale }?: _FontScaleOptions): string;
	/**
	 * Calculates the line-height to the closest multiple of the baseline
	 * EX: A proper line-height for text is 1.5 times the font-size.
	 *     If our base font size (euiFontSize) is 16, and our baseline is 4. To ensure the
	 *     text stays on the baseline, we pass a multiplier to calculate a line-height.
	 * @param scale - The font scale key
	 * @param theme - Requires the `base` and `font` keys
	 * @param options - Optional parameters - see _FontScaleOptions
	 *
	 * @returns string - Calculated line-height value aligned to baseline
	 */
	export function euiLineHeightFromBaseline(scale: _EuiThemeFontScale, { base, font }: UseEuiTheme['euiTheme'], { unit, customScale }?: _FontScaleOptions): string;
	/**
	 * Text weight shifting
	 *
	 * When changing the font-weight based on the state of the component,
	 * this mixin will ensure that the sizing is dependent on the boldest
	 * weight so it doesn't shift sibling content.
	 */
	export const euiTextShift: (fontWeight: keyof _EuiThemeFontWeights | undefined, attribute: string | undefined, euiTheme: UseEuiTheme['euiTheme']) => string;

}
declare module '@elastic/eui/src/global_styling/functions' {
	export * from '@elastic/eui/src/global_styling/functions/logicals';
	export * from '@elastic/eui/src/global_styling/functions/logical_shorthands';
	export * from '@elastic/eui/src/global_styling/functions/math';
	export * from '@elastic/eui/src/global_styling/functions/size';
	export * from '@elastic/eui/src/global_styling/functions/typography';

}
declare module '@elastic/eui/src/global_styling/mixins/_helpers' {
	import { CSSProperties } from 'react';
	import { UseEuiTheme } from '@elastic/eui/src/services/theme';
	/**
	 * Set scroll bar appearance on Chrome (and firefox).
	 * All parameters are optional and default to specific global settings.
	 */
	export interface EuiScrollBarStyles {
	    thumbColor?: CSSProperties['backgroundColor'];
	    trackColor?: CSSProperties['backgroundColor'];
	    /**
	     * Defaults to `thin`. Use `auto` only for large page scrollbars
	     */
	    width?: CSSProperties['scrollbarWidth'];
	    /**
	     * Overall width (height for horizontal scrollbars)
	     */
	    size?: CSSProperties['width'];
	    /**
	     * Corner sizes are usually determined by `width` and
	     * are used as an inset border and therefore a smaller corner size means a larger thumb
	     */
	    corner?: CSSProperties['borderWidth'];
	}
	export const euiScrollBarStyles: ({ euiTheme: { colors, size } }: UseEuiTheme, { thumbColor: _thumbColor, trackColor, width, size: _size, corner: _corner, }?: EuiScrollBarStyles) => string;
	export const useEuiScrollBar: (options?: EuiScrollBarStyles | undefined) => string;
	/**
	 * 1. Focus rings shouldn't be visible on scrollable regions, but a11y requires them to be focusable.
	 *    Browser's supporting `:focus-visible` will still show outline on keyboard focus only.
	 *    Others like Safari, won't show anything at all.
	 */
	interface _EuiYScroll {
	    height?: CSSProperties['height'];
	}
	export const euiYScroll: (euiTheme: UseEuiTheme, { height }?: _EuiYScroll) => string;
	export const useEuiYScroll: ({ height }?: _EuiYScroll) => string;
	interface _EuiYScrollWithShadows extends _EuiYScroll {
	    side?: 'both' | 'start' | 'end';
	}
	export const euiYScrollWithShadows: (euiTheme: UseEuiTheme, { height, side }?: _EuiYScrollWithShadows) => string;
	export const useEuiYScrollWithShadows: ({ height }?: _EuiYScroll) => string;
	export const euiXScroll: (euiTheme: UseEuiTheme) => string;
	export const useEuiXScroll: () => string;
	export const euiXScrollWithShadows: (euiTheme: UseEuiTheme) => string;
	export const useEuiXScrollWithShadows: () => string;
	interface EuiScrollOverflowStyles {
	    direction?: 'y' | 'x';
	    mask?: boolean;
	}
	export const euiOverflowScroll: (euiTheme: UseEuiTheme, { direction, mask }?: EuiScrollOverflowStyles) => string;
	export const useEuiOverflowScroll: (direction: EuiScrollOverflowStyles['direction'], mask?: EuiScrollOverflowStyles['mask']) => string;
	/**
	 * For quickly applying a full-height element whether using flex or not
	 */
	export const euiFullHeight: () => string;
	export {};

}
declare module '@elastic/eui/src/global_styling/mixins/_padding' {
	import { SerializedStyles } from '@emotion/react';
	import { UseEuiTheme } from '@elastic/eui/src/services/theme';
	export const PADDING_SIZES: readonly ["none", "xs", "s", "m", "l", "xl"];
	export type EuiPaddingSize = (typeof PADDING_SIZES)[number];
	/**
	 * Get a single padding size
	 */
	export const euiPaddingSize: ({ euiTheme }: UseEuiTheme, size: EuiPaddingSize) => string | null;
	export const useEuiPaddingSize: (size: EuiPaddingSize) => string;
	export const useEuiPaddingCSS: (side?: "left" | "right" | "bottom" | "top" | "horizontal" | "vertical" | undefined) => Record<"xs" | "s" | "m" | "l" | "xl" | "none", SerializedStyles>;

}
declare module '@elastic/eui/src/global_styling/mixins/_states' {
	import { CSSProperties } from 'react';
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export type _EuiFocusRingOffset = 'inset' | 'outset' | 'center' | CSSProperties['outlineOffset'];
	/**
	 * It is best practice to utilize the browser's default `outline` property for handling focus rings.
	 * However, some components need to be forced to have the same behavior, or adjust the display.
	 * This function re-applies the same default outline with a couple parameters
	 * @param euiTheme UseEuiTheme
	 * @param offset Accepts a specific measurement or 'inset', 'outset' or 'center' to adjust outline position
	 * @param color Accepts any CSS color
	 */
	export const euiOutline: ({ euiTheme }: UseEuiTheme, offset?: _EuiFocusRingOffset, color?: CSSProperties['outlineColor']) => string;
	export const euiFocusRing: (euiThemeContext: UseEuiTheme, offset?: _EuiFocusRingOffset, options?: {
	    color?: CSSProperties['outlineColor'];
	} | undefined) => string;
	export const useEuiFocusRing: (offset?: _EuiFocusRingOffset, color?: CSSProperties['outlineColor']) => string;

}
declare module '@elastic/eui/src/global_styling/mixins/_typography' {
	import { CSSProperties } from 'react';
	import { _FontScaleOptions } from '@elastic/eui/src/global_styling/functions/typography';
	import { UseEuiTheme } from '@elastic/eui/src/services/theme';
	import { _EuiThemeFontScale } from '@elastic/eui/src/global_styling/variables/typography';
	export type EuiThemeFontSize = {
	    fontSize: CSSProperties['fontSize'];
	    lineHeight: CSSProperties['lineHeight'];
	};
	/**
	 * Returns font-size and line-height
	 */
	export const euiFontSize: ({ euiTheme }: UseEuiTheme, scale: _EuiThemeFontScale, options?: _FontScaleOptions | undefined) => EuiThemeFontSize;
	export const useEuiFontSize: (scale: _EuiThemeFontScale, options?: _FontScaleOptions | undefined) => EuiThemeFontSize;
	/**
	 * Force text to wrap on natural word breaks (e.g. spaces & hyphens)
	 * https://css-tricks.com/snippets/css/prevent-long-urls-from-breaking-out-of-container/
	 */
	export const euiTextBreakWord: () => string;
	/**
	 * Prevent text from wrapping onto multiple lines, and truncate with an ellipsis.
	 */
	export const euiTextTruncate: (maxWidth?: CSSProperties['maxWidth']) => string;
	/**
	 * Fixed-width numbers for tabular data
	 */
	export const euiNumberFormat: ({ euiTheme }: UseEuiTheme) => string;

}
declare module '@elastic/eui/src/services/breakpoint/_sorting' {
	import { _EuiThemeBreakpoints } from '@elastic/eui/src/global_styling/variables/breakpoint';
	export const sortMapByLargeToSmallValues: (breakpointsMap: _EuiThemeBreakpoints) => _EuiThemeBreakpoints;
	export const sortMapBySmallToLargeValues: (breakpointsMap: _EuiThemeBreakpoints) => _EuiThemeBreakpoints;

}
declare module '@elastic/eui/src/global_styling/variables/shadow' {
	export const EuiThemeShadowSizes: readonly ["xs", "s", "m", "l", "xl"];
	export type _EuiThemeShadowSize = (typeof EuiThemeShadowSizes)[number];
	/**
	 * Shadow t-shirt sizes descriptions
	 */
	export const _EuiShadowSizesDescriptions: Record<_EuiThemeShadowSize, string>;
	export interface _EuiThemeShadowCustomColor {
	    color?: string;
	    property?: 'box-shadow' | 'filter';
	}

}
declare module '@elastic/eui/src/global_styling/variables' {
	export * from '@elastic/eui/src/global_styling/variables/animations';
	export * from '@elastic/eui/src/global_styling/variables/borders';
	export * from '@elastic/eui/src/global_styling/variables/breakpoint';
	export * from '@elastic/eui/src/global_styling/variables/colors';
	export * from '@elastic/eui/src/global_styling/variables/levels';
	export * from '@elastic/eui/src/global_styling/variables/size';
	export * from '@elastic/eui/src/global_styling/variables/shadow';
	export * from '@elastic/eui/src/global_styling/variables/states';
	export * from '@elastic/eui/src/global_styling/variables/typography';

}
declare module '@elastic/eui/src/global_styling/mixins/_responsive' {
	import { UseEuiTheme } from '@elastic/eui/src/services/theme/hooks';
	import { _EuiThemeBreakpoint } from '@elastic/eui/src/global_styling/variables';
	/**
	 * Generates a CSS media query rule string based on the input breakpoint *ranges*.
	 * Examples with default theme breakpoints:
	 *
	 * euiBreakpoint(['s']) becomes `@media only screen and (min-width: 575px) and (max-width: 767px)`
	 * euiBreakpoint(['s', 'l']) becomes `@media only screen and (min-width: 575px) and (max-width: 1199px)`
	 *
	 * Use the smallest and largest sizes to generate media queries with only min/max-width.
	 * Examples with default theme breakpoints:
	 *
	 * euiBreakpoint(['xs', 'm']) becomes `@media only screen and (max-width: 991px)`
	 * euiBreakpoint(['l', 'xl']) becomes `@media only screen and (min-width: 992px)`
	 */
	export const euiBreakpoint: ({ euiTheme }: UseEuiTheme, sizes: [_EuiThemeBreakpoint, ..._EuiThemeBreakpoint[]]) => string;
	export const useEuiBreakpoint: (sizes: [_EuiThemeBreakpoint, ..._EuiThemeBreakpoint[]]) => string;
	/**
	 * Min/Max width breakpoint utilities that generate only a single min/max query/bound
	 *
	 * *Unlike the above euiBreakpoint utility*, these utilities treat breakpoint
	 * sizes as a one-dimensional point, rather than a two-dimensional *screen range*.
	 * Examples with default theme breakpoints:
	 *
	 * euiMaxBreakpoint('m') becomes `@media only screen and (max-width: 767px)`
	 * euiMinBreakpoint('m') becomes `@media only screen and (min-width: 768px)`
	 *
	 * This is safer and more intentional to use than euiBreakpoint(['xs', 's']) / euiBreakpoint(['m', 'xl'])
	 * in the event that consumers add larger or smaller custom breakpoints (e.g 'xxs' or `xxl`)
	 * and if the intention of the media query is actually "m and below/above" vs. "only screens m/l/xl".
	 */
	export const euiMinBreakpoint: ({ euiTheme }: UseEuiTheme, size: _EuiThemeBreakpoint) => string;
	export const useEuiMinBreakpoint: (size: _EuiThemeBreakpoint) => string;
	export const euiMaxBreakpoint: ({ euiTheme }: UseEuiTheme, size: _EuiThemeBreakpoint) => string;
	export const useEuiMaxBreakpoint: (size: _EuiThemeBreakpoint) => string;

}
declare module '@elastic/eui/src/global_styling/mixins' {
	export * from '@elastic/eui/src/global_styling/mixins/_color';
	export * from '@elastic/eui/src/global_styling/mixins/_helpers';
	export * from '@elastic/eui/src/global_styling/mixins/_padding';
	export * from '@elastic/eui/src/global_styling/mixins/_states';
	export * from '@elastic/eui/src/global_styling/mixins/_typography';
	export * from '@elastic/eui/src/global_styling/mixins/_responsive';

}
declare module '@elastic/eui/src/global_styling/reset/reset' {
	export const resetStyles = "\n/* // Adapted from Eric Meyer's reset (http://meyerweb.com/eric/tools/css/reset/, v2.0 | 20110126). */\n\n\n*, *:before, *:after {\n  box-sizing: border-box;\n}\n\nhtml, body, div, span, applet, object, iframe,\nh1, h2, h3, h4, h5, h6, p, blockquote, pre,\na, abbr, acronym, address, big, cite, code,\ndel, dfn, em, img, ins, kbd, q, s, samp,\nsmall, strike, strong, sub, sup, tt, var,\nb, u, i, center,\ndl, dt, dd, ol, ul, li,\nfieldset, form, label, legend,\ntable, caption, tbody, tfoot, thead, tr, th, td,\narticle, aside, canvas, details, embed,\nfigure, figcaption, footer, header, hgroup,\nmenu, nav, output, ruby, section, summary,\ntime, mark, audio, video {\n  margin: 0;\n  padding: 0;\n  border: none;\n  vertical-align: baseline;\n}\n\nh1, h2, h3, h4, h5, h6, p {\n  font-family: inherit;\n  font-weight: inherit;\n  font-size: inherit;\n}\n\n/* HTML5 display-role reset for older browsers */\narticle, aside, details, figcaption, figure,\nfooter, header, hgroup, menu, nav, section {\n  display: block;\n}\n\na[href],\nbutton,\n[role='button'] {\n  cursor: pointer;\n}\n\nbutton {\n  background: none;\n  border: none;\n  padding: 0;\n  margin: 0;\n  color: inherit;\n  border-radius: 0;\n  font-size: inherit;\n}\n\ninput {\n  margin: 0;\n  padding: 0;\n}\n\ninput:disabled {\n  opacity: 1; /* required on iOS */\n}\n\nol,\nul {\n  list-style: none;\n}\n\nblockquote,\nq {\n  quotes: none;\n}\n\nblockquote:before,\nblockquote:after,\nq:before,\nq:after {\n  content: '';\n}\n\ntable {\n  border-collapse: collapse;\n  border-spacing: 0;\n}\n\nhr {\n  margin: 0;\n}\n\nfieldset {\n  min-inline-size: auto;\n}\n\n/* Chrome has an issue around RTL languages in SVGs when letter-spacing is negative\n * https://bugs.chromium.org/p/chromium/issues/detail?id=966480\n */\nsvg text {\n  letter-spacing: normal !important;\n}";

}
declare module '@elastic/eui/src/global_styling/reset/global_styles' {
	import React from 'react';
	export interface EuiGlobalStylesProps {
	}
	export const EuiGlobalStyles: ({}: EuiGlobalStylesProps) => React.JSX.Element;

}
declare module '@elastic/eui/src/global_styling/utility/animations' {
	export const euiAnimFadeIn: import("@emotion/serialize").Keyframes;
	export const euiAnimSlideInUp: (size: string) => import("@emotion/serialize").Keyframes;
	export const euiAnimSlideX: (size: string) => import("@emotion/serialize").Keyframes;
	export const euiAnimScale: import("@emotion/serialize").Keyframes;

}
declare module '@elastic/eui/src/global_styling' {
	export * from '@elastic/eui/src/global_styling/reset/global_styles';
	export * from '@elastic/eui/src/global_styling/functions';
	export * from '@elastic/eui/src/global_styling/variables';
	export * from '@elastic/eui/src/global_styling/mixins';
	export * from '@elastic/eui/src/global_styling/utility/animations';

}
declare module '@elastic/eui/src/components/spacer/spacer.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiSpacerStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiSpacer: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    xl: import("@emotion/utils").SerializedStyles;
	    xxl: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/spacer/spacer' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const SIZES: readonly ["xs", "s", "m", "l", "xl", "xxl"];
	export type SpacerSize = (typeof SIZES)[number];
	export type EuiSpacerProps = HTMLAttributes<HTMLDivElement> & CommonProps & {
	    size?: SpacerSize;
	};
	export const EuiSpacer: FunctionComponent<EuiSpacerProps>;

}
declare module '@elastic/eui/src/components/spacer' {
	export type { EuiSpacerProps } from '@elastic/eui/src/components/spacer/spacer';
	export { EuiSpacer } from '@elastic/eui/src/components/spacer/spacer';

}
declare module '@elastic/eui/src/components/text/text_color.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiTextColorStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiTextColor: import("@emotion/utils").SerializedStyles;
	    default: import("@emotion/utils").SerializedStyles;
	    subdued: import("@emotion/utils").SerializedStyles;
	    success: import("@emotion/utils").SerializedStyles;
	    accent: import("@emotion/utils").SerializedStyles;
	    danger: import("@emotion/utils").SerializedStyles;
	    warning: import("@emotion/utils").SerializedStyles;
	    ghost: import("@emotion/utils").SerializedStyles;
	    inherit: import("@emotion/utils").SerializedStyles;
	    customColor: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/text/text_color' {
	import { FunctionComponent } from 'react';
	import type { SharedTextProps, CloneElement, EuiTextColors } from '@elastic/eui/src/components/text/types';
	export const COLORS: readonly ["default", "subdued", "success", "accent", "danger", "warning", "ghost", "inherit"];
	export type TextColor = (typeof COLORS)[number];
	export const _isNamedColor: (color: any) => color is "inherit" | "default" | "subdued" | "accent" | "success" | "warning" | "danger" | "ghost";
	export type EuiTextColorProps = SharedTextProps & CloneElement & EuiTextColors;
	export const EuiTextColor: FunctionComponent<EuiTextColorProps>;

}
declare module '@elastic/eui/src/components/text/text_align.styles' {
	export const euiTextAlignStyles: {
	    euiTextAlign: import("@emotion/utils").SerializedStyles;
	    left: import("@emotion/utils").SerializedStyles;
	    right: import("@emotion/utils").SerializedStyles;
	    center: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/text/text_align' {
	import { FunctionComponent } from 'react';
	import type { SharedTextProps, CloneElement, EuiTextAlignment } from '@elastic/eui/src/components/text/types';
	export const ALIGNMENTS: readonly ["left", "right", "center"];
	export type TextAlignment = (typeof ALIGNMENTS)[number];
	export type EuiTextAlignProps = SharedTextProps & CloneElement & EuiTextAlignment;
	export const EuiTextAlign: FunctionComponent<EuiTextAlignProps>;

}
declare module '@elastic/eui/src/components/text/types' {
	import type { HTMLAttributes, CSSProperties } from 'react';
	import type { CommonProps } from '@elastic/eui/src/components/common';
	import type { TextColor } from '@elastic/eui/src/components/text/text_color';
	import type { TextAlignment } from '@elastic/eui/src/components/text/text_align';
	export type SharedTextProps = CommonProps & Omit<HTMLAttributes<HTMLElement>, 'color'> & {
	    /**
	     * The HTML element/tag to render.
	     * Use with care when nesting multiple components to ensure valid XHTML:
	     * - `<div>` and other block tags are not valid to use inside `<p>`. If using the `<p>` tag, we recommend passing strings/text only.
	     * - `<span>` is valid to be nested in any tag, and can have any tag nested within it.
	     */
	    component?: 'div' | 'span' | 'p';
	};
	export type CloneElement = {
	    /**
	     * Applies text styling to the child element instead of rendering a parent wrapper.
	     * Can only be used when wrapping a *single* child element/tag, and not raw text.
	     */
	    cloneElement?: boolean;
	};
	export type EuiTextColors = {
	    /**
	     * Any of our named colors or a `hex`, `rgb` or `rgba` value.
	     * @default inherit
	     */
	    color?: TextColor | CSSProperties['color'];
	};
	export type EuiTextAlignment = {
	    /**
	     * Applies horizontal text alignment
	     * @default left
	     */
	    textAlign?: TextAlignment;
	};

}
declare module '@elastic/eui/src/components/link/link.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiLinkCSS: (euiThemeContext: UseEuiTheme) => string;
	export const euiLinkStyles: (euiThemeContext: UseEuiTheme) => {
	    euiLink: import("@emotion/utils").SerializedStyles;
	    disabled: import("@emotion/utils").SerializedStyles;
	    primary: import("@emotion/utils").SerializedStyles;
	    subdued: import("@emotion/utils").SerializedStyles;
	    success: import("@emotion/utils").SerializedStyles;
	    accent: import("@emotion/utils").SerializedStyles;
	    danger: import("@emotion/utils").SerializedStyles;
	    warning: import("@emotion/utils").SerializedStyles;
	    ghost: import("@emotion/utils").SerializedStyles;
	    text: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/title/title' {
	import { FunctionComponent, ReactElement } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const TITLE_SIZES: readonly ["xxxs", "xxs", "xs", "s", "m", "l"];
	export type EuiTitleSize = (typeof TITLE_SIZES)[number];
	export const TEXT_TRANSFORM: readonly ["uppercase"];
	export type EuiTitleTextTransform = (typeof TEXT_TRANSFORM)[number];
	export type EuiTitleProps = CommonProps & {
	    /**
	     * ReactElement to render as this component's content
	     */
	    children: ReactElement<any>;
	    size?: EuiTitleSize;
	    textTransform?: EuiTitleTextTransform;
	    id?: string;
	};
	export const EuiTitle: FunctionComponent<EuiTitleProps>;

}
declare module '@elastic/eui/src/components/title/title.styles' {
	import { CSSProperties } from 'react';
	import { UseEuiTheme } from '@elastic/eui/src/services';
	import { _FontScaleOptions } from '@elastic/eui/src/global_styling';
	import { EuiTitleSize } from '@elastic/eui/src/components/title/title'; type EuiThemeTitle = {
	    fontSize: CSSProperties['fontSize'];
	    lineHeight: CSSProperties['lineHeight'];
	    fontWeight: CSSProperties['fontWeight'];
	    color: CSSProperties['color'];
	};
	export const euiTitle: (euiThemeContext: UseEuiTheme, scale?: EuiTitleSize, options?: _FontScaleOptions | undefined) => EuiThemeTitle;
	/**
	 * Styles
	 */
	export const euiTitleStyles: (euiThemeContext: UseEuiTheme) => {
	    euiTitle: import("@emotion/utils").SerializedStyles;
	    uppercase: import("@emotion/utils").SerializedStyles;
	    xxxs: import("@emotion/utils").SerializedStyles;
	    xxs: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	};
	export {};

}
declare module '@elastic/eui/src/components/text/text.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	/**
	 * TODO: Make this a global value so it can be set by theme?
	 */
	export const euiTextConstrainedMaxWidth = "max(64ch, 75%)";
	/**
	 * Mixins
	 */
	export const euiText: (euiTheme: UseEuiTheme['euiTheme'], inheritColor?: boolean) => {
	    color: string;
	    fontWeight: import("csstype").Property.FontWeight | undefined;
	};
	/**
	 * Styles
	 */
	export const euiTextStyles: (euiThemeContext: UseEuiTheme) => {
	    euiText: import("@emotion/utils").SerializedStyles;
	    constrainedWidth: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	    relative: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/text/text' {
	import { FunctionComponent } from 'react';
	import type { SharedTextProps, EuiTextColors, EuiTextAlignment } from '@elastic/eui/src/components/text/types';
	export const TEXT_SIZES: readonly ["xs", "s", "m", "relative"];
	export type TextSize = (typeof TEXT_SIZES)[number];
	export type EuiTextProps = SharedTextProps & EuiTextColors & EuiTextAlignment & {
	    /**
	     * Determines the text size. Choose `relative` to control the `font-size` based on the value of a parent container.
	     */
	    size?: TextSize;
	    grow?: boolean;
	};
	export const EuiText: FunctionComponent<EuiTextProps>;

}
declare module '@elastic/eui/src/components/text' {
	export type { EuiTextProps } from '@elastic/eui/src/components/text/text';
	export { EuiText } from '@elastic/eui/src/components/text/text';
	export type { EuiTextColorProps } from '@elastic/eui/src/components/text/text_color';
	export { EuiTextColor } from '@elastic/eui/src/components/text/text_color';
	export type { EuiTextAlignProps } from '@elastic/eui/src/components/text/text_align';
	export { EuiTextAlign } from '@elastic/eui/src/components/text/text_align';

}
declare module '@elastic/eui/src/components/context/context' {
	import React, { Context, FunctionComponent, ReactChild, ReactNode } from 'react';
	export interface RenderableValues {
	    [key: string]: ReactChild | undefined;
	}
	export type Renderable<T> = ReactChild | ((values: T) => ReactChild);
	export interface I18nShape {
	    mapping?: {
	        [key: string]: Renderable<object>;
	    };
	    mappingFunc?: (value: string) => string;
	    /**
	     * Some browsers' translation features don't work with a rendered `<Fragment>` component.
	     * The `render` function allows you to pass in another component instead, e.g. `<div>`
	     */
	    render?: (children: any) => FunctionComponent;
	    formatNumber?: (x: number) => string;
	    formatDateTime?: (x: Date) => string;
	    locale?: string;
	} const I18nContext: Context<I18nShape>; const EuiI18nConsumer: React.Consumer<I18nShape>;
	export interface EuiContextProps {
	    i18n: I18nShape;
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: ReactNode;
	} const EuiContext: FunctionComponent<EuiContextProps>;
	export { EuiContext, EuiI18nConsumer, I18nContext };

}
declare module '@elastic/eui/src/components/context' {
	export type { EuiContextProps } from '@elastic/eui/src/components/context/context';
	export { EuiContext, EuiI18nConsumer } from '@elastic/eui/src/components/context/context';

}
declare module '@elastic/eui/src/services/predicate/common_predicates' {
	import moment from 'moment';
	export const always: (_value?: any) => boolean;
	export const never: (_value?: any) => boolean;
	export const isUndefined: (value: any) => value is undefined;
	export const isNull: (value: any) => value is null;
	export const isNil: (value: any) => value is null | undefined;
	export const isMoment: (value: any) => boolean;
	export const isDate: (value: any) => value is Date;
	export const isDateLike: (value: any) => value is Date | moment.Moment;

}
declare module '@elastic/eui/src/services/predicate/lodash_predicates' {
	export const isFunction: (value: any) => value is (...args: any[]) => any;
	export const isArray: (value: any) => value is any[];
	export const isString: (value: any) => value is string;
	export const isBoolean: (value: any) => value is boolean;
	export const isNumber: (value: any) => value is number;
	export const isNaN: (value: any) => boolean;
	export const isObject: (value: any) => value is object;

}
declare module '@elastic/eui/src/services/predicate' {
	export * from '@elastic/eui/src/services/predicate/common_predicates';
	export * from '@elastic/eui/src/services/predicate/lodash_predicates';

}
declare module '@elastic/eui/src/components/i18n/i18n_util' {
	import { ReactChild } from 'react';
	import { RenderableValues } from '@elastic/eui/src/components/context/context';
	/**
	 * Replaces placeholder values in `input` with their matching value in `values`
	 * e.g. input:'Hello, {name}' will replace `{name}` with `values[name]`
	 * @param {string} input
	 * @param {RenderableValues} values
	 * @param {Function} i18nMappingFunc
	 * @returns {string | React.ReactChild[]}
	 */
	export function processStringToChildren(input: string, values: RenderableValues, i18nMappingFunc?: (token: string) => string): string | ReactChild[];

}
declare module '@elastic/eui/src/components/i18n/i18n' {
	import React, { ReactChild, ReactElement } from 'react';
	import { ExclusiveUnion } from '@elastic/eui/src/components/common';
	import { Renderable } from '@elastic/eui/src/components/context/context'; type ResolvedType<T> = T extends (...args: any[]) => any ? ReturnType<T> : T;
	interface I18nTokenShape<T, DEFAULT extends Renderable<T>> {
	    token: string;
	    default: DEFAULT;
	    /**
	     * Render function that returns a ReactElement
	     */
	    children?: (x: ResolvedType<DEFAULT>) => ReactChild;
	    values?: T;
	}
	export interface I18nTokensShape<T extends any[]> {
	    tokens: string[];
	    defaults: T;
	    /**
	     * Render function that returns a ReactElement
	     */
	    children: (x: Array<T[number]>) => ReactChild;
	    values?: Record<string, ReactChild>;
	}
	export type EuiI18nProps<T, DEFAULT extends Renderable<T>, DEFAULTS extends any[]> = ExclusiveUnion<I18nTokenShape<T, DEFAULT>, I18nTokensShape<DEFAULTS>>; const EuiI18n: <T extends {}, DEFAULT extends Renderable<T>, DEFAULTS extends any[]>(props: (import ("@elastic/eui/src/components/common").DisambiguateSet<I18nTokenShape<T, DEFAULT>, I18nTokensShape<DEFAULTS>> & I18nTokensShape<DEFAULTS>) | (import ("@elastic/eui/src/components/common").DisambiguateSet<I18nTokensShape<DEFAULTS>, I18nTokenShape<T, DEFAULT>> & I18nTokenShape<T, DEFAULT>)) => React.JSX.Element; type DefaultRenderType<T, K extends Renderable<T>> = K extends ReactChild ? K : K extends () => infer RetValue ? RetValue : never; type DefaultsRenderType<K extends Array<string | ReactElement>> = K extends Array<infer Item> ? Item : never; function useEuiI18n<T extends {}, DEFAULT extends Renderable<T>>(token: string, defaultValue: DEFAULT, values?: T): DefaultRenderType<T, DEFAULT>; function useEuiI18n<DEFAULTS extends Array<string | ReactElement>>(tokens: string[], defaultValues: DEFAULTS): Array<DefaultsRenderType<DEFAULTS>>;
	export { EuiI18n, useEuiI18n };

}
declare module '@elastic/eui/src/components/i18n/i18n_number' {
	import { FunctionComponent, ReactChild, ReactElement } from 'react';
	import { ExclusiveUnion } from '@elastic/eui/src/components/common';
	interface EuiI18nNumberValueShape {
	    value: number;
	    children?: (x: ReactChild) => ReactElement<any>;
	}
	interface EuiI18nNumberValuesShape {
	    values: number[];
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: (x: ReactChild[]) => ReactElement<any>;
	}
	export type EuiI18nNumberProps = ExclusiveUnion<EuiI18nNumberValueShape, EuiI18nNumberValuesShape>; const EuiI18nNumber: FunctionComponent<EuiI18nNumberProps>;
	export { EuiI18nNumber };

}
declare module '@elastic/eui/src/components/i18n' {
	export type { EuiI18nProps } from '@elastic/eui/src/components/i18n/i18n';
	export { EuiI18n, useEuiI18n } from '@elastic/eui/src/components/i18n/i18n';
	export type { EuiI18nNumberProps } from '@elastic/eui/src/components/i18n/i18n_number';
	export { EuiI18nNumber } from '@elastic/eui/src/components/i18n/i18n_number';

}
declare module '@elastic/eui/src/components/observer/observer' {
	import { Component, ReactNode } from 'react';
	interface BaseProps {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: (ref: any) => ReactNode;
	}
	export interface Observer {
	    disconnect: () => void;
	    observe: (element: Element, options?: {
	        [key: string]: any;
	    }) => void;
	}
	export class EuiObserver<Props extends BaseProps> extends Component<Props> {
	    protected name: string;
	    protected childNode: null | Element;
	    protected observer: null | Observer;
	    componentDidMount(): void;
	    componentWillUnmount(): void;
	    updateChildNode: (ref: Element) => void;
	    beginObserve: () => void;
	    render(): ReactNode;
	}
	export {};

}
declare module '@elastic/eui/src/components/observer/resize_observer/resize_observer' {
	import { ReactNode } from 'react';
	import { EuiObserver } from '@elastic/eui/src/components/observer/observer';
	export interface EuiResizeObserverProps {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: (ref: (e: HTMLElement | null) => void) => ReactNode;
	    onResize: (dimensions: {
	        height: number;
	        width: number;
	    }) => void;
	}
	export const hasResizeObserver: boolean;
	export class EuiResizeObserver extends EuiObserver<EuiResizeObserverProps> {
	    name: string;
	    state: {
	        height: number;
	        width: number;
	    };
	    onResize: ResizeObserverCallback;
	    beginObserve: () => void;
	}
	export const useResizeObserver: (container: Element | null, dimension?: "width" | "height" | undefined) => {
	    width: number;
	    height: number;
	};

}
declare module '@elastic/eui/src/components/observer/resize_observer' {
	export type { EuiResizeObserverProps } from '@elastic/eui/src/components/observer/resize_observer/resize_observer';
	export { EuiResizeObserver, useResizeObserver } from '@elastic/eui/src/components/observer/resize_observer/resize_observer';

}
declare module '@elastic/eui/src/components/portal/portal' {
	/**
	 * NOTE: We can't test this component because Enzyme doesn't support rendering
	 * into portals.
	 */
	import React, { FunctionComponent, Component, ContextType, ReactNode } from 'react';
	import { EuiNestedThemeContext } from '@elastic/eui/src/services'; const INSERT_POSITIONS: readonly ["after", "before"]; type EuiPortalInsertPosition = (typeof INSERT_POSITIONS)[number];
	export interface EuiPortalProps {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: ReactNode;
	    /**
	     * If not specified, `EuiPortal` will insert itself
	     * into the end of the `document.body` by default
	     */
	    insert?: {
	        sibling: HTMLElement;
	        position: EuiPortalInsertPosition;
	    };
	    /**
	     * Optional ref callback
	     */
	    portalRef?: (ref: HTMLDivElement | null) => void;
	}
	export const EuiPortal: FunctionComponent<EuiPortalProps>;
	interface EuiPortalState {
	    portalNode: HTMLDivElement | null;
	}
	export class EuiPortalClass extends Component<EuiPortalProps, EuiPortalState> {
	    static contextType: React.Context<import ("@elastic/eui/src/services/theme/types").EuiThemeNested>;
	    context: ContextType<typeof EuiNestedThemeContext>;
	    constructor(props: EuiPortalProps);
	    componentDidMount(): void;
	    componentWillUnmount(): void;
	    private setThemeColor;
	    private updatePortalRef;
	    render(): React.ReactPortal | null;
	}
	export {};

}
declare module '@elastic/eui/src/components/portal' {
	export type { EuiPortalProps } from '@elastic/eui/src/components/portal/portal';
	export { EuiPortal } from '@elastic/eui/src/components/portal/portal';

}
declare module '@elastic/eui/src/components/table/mobile/responsive_context' {
	import { type EuiBreakpointSize } from '@elastic/eui/src/services';
	export const DEFAULT_TABLE_BREAKPOINT: EuiBreakpointSize;
	/**
	 * Used by parent/top-level table components to determine isResponsive state
	 * based on the passed breakpoint
	 */
	export const useIsEuiTableResponsive: (componentProp?: string | boolean | undefined) => boolean;
	/**
	 * Context set by parent table components
	 * Hook used by cells to fetch parent isResponsive state
	 */
	export const EuiTableIsResponsiveContext: import("react").Context<boolean>;
	export const useEuiTableIsResponsive: () => boolean;

}
declare module '@elastic/eui/src/components/table/table.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiTableVariables: ({ euiTheme }: UseEuiTheme) => {
	    cellContentPadding: string;
	    compressedCellContentPadding: string;
	    mobileSizes: {
	        actions: {
	            width: string;
	            offset: string;
	        };
	        checkbox: {
	            width: string;
	            offset: string;
	        };
	    };
	    checkboxSize: string;
	};
	export const euiTableStyles: (euiThemeContext: UseEuiTheme) => {
	    euiTable: import("@emotion/utils").SerializedStyles;
	    layout: {
	        fixed: import("@emotion/utils").SerializedStyles;
	        auto: import("@emotion/utils").SerializedStyles;
	    };
	    /**
	     * 1. The padding on the `.euiTableCellContent` div allows the ellipsis to show if the
	     * content is truncated. If the padding was on the cell, the ellipsis would be cropped.
	     * 2. The `:where()` selector sets the specificity to 0, allowing consumers to more easily
	     * override our CSS if needed
	     */
	    uncompressed: import("@emotion/utils").SerializedStyles;
	    compressed: import("@emotion/utils").SerializedStyles;
	    /**
	     * Responsive/mobile vs desktop styles
	     * Individual row/cells handle their own desktop vs mobile styles
	     */
	    desktop: import("@emotion/utils").SerializedStyles;
	    mobile: import("@emotion/utils").SerializedStyles;
	};
	export const euiTableCaptionStyles: import("@emotion/utils").SerializedStyles;

}
declare module '@elastic/eui/src/components/table/table' {
	import { FunctionComponent, TableHTMLAttributes } from 'react';
	import { type EuiBreakpointSize } from '@elastic/eui/src/services';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export interface EuiTableProps extends CommonProps, TableHTMLAttributes<HTMLTableElement> {
	    compressed?: boolean;
	    /**
	     * Named breakpoint. Below this size, the table will collapse
	     * into responsive cards.
	     *
	     * Pass `false` to never collapse to a mobile view, or inversely,
	     * `true` to always render mobile-friendly cards.
	     *
	     * @default m
	     */
	    responsiveBreakpoint?: EuiBreakpointSize | boolean;
	    /**
	     * Sets the table-layout CSS property
	     */
	    tableLayout?: 'fixed' | 'auto';
	}
	export const EuiTable: FunctionComponent<EuiTableProps>;

}
declare module '@elastic/eui/src/components/table/table_body' {
	import { FunctionComponent, PropsWithChildren, Ref } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiTableBodyProps = PropsWithChildren & CommonProps & {
	    bodyRef?: Ref<HTMLTableSectionElement>;
	};
	export const EuiTableBody: FunctionComponent<EuiTableBodyProps>;

}
declare module '@elastic/eui/src/components/table/table_footer' {
	import { FunctionComponent, PropsWithChildren } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const EuiTableFooter: FunctionComponent<PropsWithChildren & CommonProps>;

}
declare module '@elastic/eui/src/components/table/utils' {
	import { CSSProperties } from 'react';
	export const WARNING_MESSAGE = "Two `width` properties were provided. Provide only one of `style.width` or `width` to avoid conflicts.";
	export const resolveWidthAsStyle: (style?: CSSProperties, width?: string | number | undefined) => CSSProperties;

}
declare module '@elastic/eui/src/services/canvas/canvas_text_utils' {
	import type { ExclusiveUnion } from '@elastic/eui/src/components/common';
	export type CanvasTextParams = ExclusiveUnion<{
	    container: HTMLElement;
	}, {
	    font: CanvasTextDrawingStyles['font'];
	}>;
	/**
	 * Creates a temporary Canvas element for manipulating text & determining text width.
	 *
	 * To accurately measure text, canvas rendering requires either a container to
	 * compute/derive font styles from, or a static font string (useful for usage
	 * outside the DOM). Particular care should be applied when fallback fonts are
	 * used, as more fallback fonts can lead to less precision.
	 *
	 * Please note that while canvas is more significantly more performant than DOM
	 * measurement, there are subpixel to single digit pixel differences between
	 * DOM and canvas measurement due to the different rendering engines used.
	 */
	export class CanvasTextUtils {
	    context: CanvasRenderingContext2D;
	    currentText: string;
	    constructor({ font, container }: CanvasTextParams);
	    computeFontFromElement: (element: HTMLElement) => string;
	    get textWidth(): number;
	    setTextToCheck: (text: string) => void;
	}

}
declare module '@elastic/eui/src/services/canvas' {
	export { CanvasTextUtils } from '@elastic/eui/src/services/canvas/canvas_text_utils';
	export type { CanvasTextParams } from '@elastic/eui/src/services/canvas/canvas_text_utils';

}
declare module '@elastic/eui/src/components/text_truncate/utils' {
	import { CanvasTextParams, CanvasTextUtils } from '@elastic/eui/src/services/canvas'; type TruncationParams = CanvasTextParams & {
	    fullText: string;
	    ellipsis: string;
	    availableWidth: number;
	};
	/**
	 * Utilities for truncating types at various positions, as well as
	 * determining whether truncation is possible or even necessary.
	 */
	export class TruncationUtils extends CanvasTextUtils {
	    protected fullText: TruncationParams['fullText'];
	    protected ellipsis: TruncationParams['ellipsis'];
	    protected availableWidth: TruncationParams['availableWidth'];
	    constructor({ fullText, ellipsis, availableWidth, ...rest }: TruncationParams);
	    /**
	     * Performance utilities
	     */
	    debugPerformance: boolean;
	    debugCounter: number;
	    get textWidth(): number;
	    /**
	     * Internal utils for calculating a ratio based on the passed available width
	     * vs the full text width.
	     * This ratio is used to get an initial _approximate_ text string that should
	     * be slightly over the available width, which we can then remove from
	     * character-by-character until the text just fits within the available width.
	     */
	    widthRatio: number;
	    setTextWidthRatio: (text?: string, textToOffset?: string) => void;
	    getTextFromRatio: (text: string, type: 'start' | 'end') => string;
	    /**
	     * Early return checks
	     */
	    checkIfTruncationIsNeeded: () => false | undefined;
	    checkSufficientEllipsisWidth: (truncation: string) => false | undefined;
	    checkTruncationOffsetWidth: (text: string) => false | undefined;
	    /**
	     * Truncation types logic. This is where the magic happens
	     */
	    truncateStart: (truncationOffset?: number | undefined) => string;
	    truncateEnd: (truncationOffset?: number | undefined) => string;
	    truncateStartEndAtPosition: (truncationPosition: number) => string;
	    truncateStartEndAtMiddle: () => string;
	    truncateMiddle: () => string;
	}
	export {};

}
declare module '@elastic/eui/src/components/text_truncate/text_truncate.styles' {
	export const euiTextTruncateStyles: {
	    euiTextTruncate: import("@emotion/utils").SerializedStyles;
	    /**
	     * The below CSS is a hack to get double clicking and selecting the *full* text
	     * instead of the truncated text (useful for copying/pasting, and mimics how
	     * `text-overflow: ellipsis` works).
	     *
	     * Real talk: I'm lowkey amazed it works and it wouldn't surprise me if we ran into
	     * cross-browser issues with this at some point. Hopefully CSS natively implements
	     * custom text truncation some day (https://github.com/w3c/csswg-drafts/issues/3937)
	     * and there'll be no need for the entire component at that point 🙏
	     */
	    euiTextTruncate__truncatedText: import("@emotion/utils").SerializedStyles;
	    euiTextTruncate__fullText: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/text_truncate/text_truncate' {
	import { HTMLAttributes, FunctionComponent, ReactNode } from 'react';
	import type { CommonProps } from '@elastic/eui/src/components/common'; const TRUNCATION_TYPES: readonly ["end", "start", "startEnd", "middle"];
	export type EuiTextTruncationTypes = (typeof TRUNCATION_TYPES)[number];
	export type EuiTextTruncateProps = Omit<HTMLAttributes<HTMLDivElement>, 'children' | 'onResize'> & CommonProps & {
	    /**
	     * The full text string to truncate
	     */
	    text: string;
	    /**
	     * The truncation type desired. Determines where the ellipses are placed.
	     */
	    truncation?: EuiTextTruncationTypes;
	    /**
	     * This prop **only** applies to the `start` and `end` truncation types.
	     * It allows preserving a certain number of characters of either the
	     * starting or ending text.
	     *
	     * If the passed offset is greater than the total text length,
	     * the offset will be ignored.
	     */
	    truncationOffset?: number;
	    /**
	     * This prop **only** applies to the `startEnd` truncation type.
	     * It allows customizing the anchor position of the displayed text,
	     * which otherwise defaults to the middle of the text string.
	     *
	     * The primary use case for this prop for is search highlighting - e.g., if
	     * a user searches for a specific word in the text, pass the index of that
	     * found word to ensure it is always visible.
	     *
	     * This behavior will intelligently detect when positions are close to the start
	     * or end of the text, and omit leading or trailing ellipses when necessary.
	     * If the passed position is greater than the total text length,
	     * the truncation will simply default to `start` instead.
	     */
	    truncationPosition?: number;
	    /**
	     * Defaults to the horizontal ellipsis character.
	     * Can be optionally configured to use other punctuation,
	     * e.g. spaces, brackets, hyphens, asterisks, etc.
	     */
	    ellipsis?: string;
	    /**
	     * By default, EuiTextTruncate will render a resize observer to detect the
	     * available width it has. For performance reasons (e.g. multiple truncated
	     * text items within the same container), you may opt to pass in your own
	     * container width, which will skip initializing a resize observer.
	     */
	    width?: number;
	    /**
	     * Optional callback that fires when the default resizer observer both mounts and
	     * registers a size change. This callback will **not** fire if `width` is passed.
	     */
	    onResize?: (width: number) => void;
	    /**
	     * By default, EuiTextTruncate will render the truncated string directly.
	     * You can optionally pass a render prop function to the component, which
	     * allows for more flexible text rendering, e.g. adding custom markup
	     * or highlighting
	     */
	    children?: (truncatedString: string) => ReactNode;
	    /**
	     * For some edge case scenarios, EuiTextTruncate's calculations may be off until
	     * fonts are done loading or layout is done shifting or settling. Adding a delay
	     * may help resolve any rendering issues.
	     */
	    calculationDelayMs?: number;
	};
	export const EuiTextTruncate: FunctionComponent<EuiTextTruncateProps>;
	export {};

}
declare module '@elastic/eui/src/components/text_truncate/text_block_truncate' {
	import { FunctionComponent, HTMLAttributes, PropsWithChildren } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiTextBlockTruncateProps = PropsWithChildren & CommonProps & HTMLAttributes<HTMLDivElement> & {
	    /**
	     * Number of lines of text to truncate to
	     */
	    lines: number;
	    /**
	     * Applies styling to the child element instead of rendering a parent wrapper `div`.
	     * Can only be used when wrapping a *single* child element/tag, and not raw text.
	     */
	    cloneElement?: boolean;
	};
	export const EuiTextBlockTruncate: FunctionComponent<EuiTextBlockTruncateProps>;

}
declare module '@elastic/eui/src/components/text_truncate' {
	export type { EuiTextTruncateProps, EuiTextTruncationTypes, } from '@elastic/eui/src/components/text_truncate/text_truncate';
	export { EuiTextTruncate } from '@elastic/eui/src/components/text_truncate/text_truncate';
	export type { EuiTextBlockTruncateProps } from '@elastic/eui/src/components/text_truncate/text_block_truncate';
	export { EuiTextBlockTruncate } from '@elastic/eui/src/components/text_truncate/text_block_truncate';
	export { TruncationUtils } from '@elastic/eui/src/components/text_truncate/utils';

}
declare module '@elastic/eui/src/components/table/table_row_cell.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiTableRowCellStyles: (euiThemeContext: UseEuiTheme) => {
	    euiTableRowCell: import("@emotion/utils").SerializedStyles;
	    rowHeader: import("@emotion/utils").SerializedStyles;
	    isExpander: import("@emotion/utils").SerializedStyles;
	    hasActions: import("@emotion/utils").SerializedStyles;
	    middle: import("@emotion/utils").SerializedStyles;
	    baseline: import("@emotion/utils").SerializedStyles;
	    top: import("@emotion/utils").SerializedStyles;
	    bottom: import("@emotion/utils").SerializedStyles;
	    desktop: {
	        desktop: import("@emotion/utils").SerializedStyles;
	        actions: import("@emotion/utils").SerializedStyles;
	    };
	    mobile: {
	        mobile: import("@emotion/utils").SerializedStyles;
	        enlarge: import("@emotion/utils").SerializedStyles;
	        rightColumnContent: string;
	        readonly actions: import("@emotion/utils").SerializedStyles;
	        readonly expander: import("@emotion/utils").SerializedStyles;
	        /**
	         * Custom actions may not be icons and therefore may not fit in a column
	         * If they're the last cell, we can create a pseudo "row"/"border-top"
	         * that mimicks the visual separation that the right column has
	         */
	        customActions: import("@emotion/utils").SerializedStyles;
	    };
	    euiTableRowCell__mobileHeader: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/table/table_row_cell' {
	import { CSSProperties, FunctionComponent, ReactNode, TdHTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { HorizontalAlignment } from '@elastic/eui/src/services';
	interface EuiTableRowCellSharedPropsShape {
	    /**
	     * Horizontal alignment of the text in the cell
	     */
	    align?: HorizontalAlignment;
	    /**
	     * Creates a text wrapper around cell content that helps word break or truncate
	     * long text correctly.
	     * @default true
	     */
	    textOnly?: boolean;
	    /**
	     * Indicates whether this column should truncate overflowing text content.
	     * - Set to `true` to enable single-line truncation.
	     * - To enable multi-line truncation, use a configuration object with `lines`
	     * set to a number of lines to truncate to.
	     * @default false
	     */
	    truncateText?: boolean | {
	        lines: number;
	    };
	    width?: CSSProperties['width'];
	}
	export interface EuiTableRowCellMobileOptionsShape extends EuiTableRowCellSharedPropsShape {
	    /**
	     * If false, will not render the cell at all for mobile
	     * @default true
	     */
	    show?: boolean;
	    /**
	     * Only show for mobile? If true, will not render the column at all for desktop
	     * @default false
	     */
	    only?: boolean;
	    /**
	     * Custom render/children if different from desktop
	     */
	    render?: ReactNode;
	    /**
	     * The column's header for use in mobile view (automatically passed down
	     * when using `EuiBasicTable`).
	     * Or pass `false` to not show a header at all.
	     */
	    header?: ReactNode | boolean;
	    /**
	     * Increase text size compared to rest of cells
	     * @default false
	     */
	    enlarge?: boolean;
	    /**
	     * Applies the value to the width of the cell in mobile view (typically 50%)
	     * @default 50%
	     */
	    width?: CSSProperties['width'];
	}
	export interface EuiTableRowCellProps extends EuiTableRowCellSharedPropsShape {
	    /**
	     * Vertical alignment of the content in the cell
	     */
	    valign?: TdHTMLAttributes<HTMLTableCellElement>['valign'];
	    /**
	     * Indicates whether the cell should be marked as the heading for its row
	     */
	    setScopeRow?: boolean;
	    /**
	     * Indicates if the cell is dedicated to row actions
	     * (used for mobile styling and desktop action hover behavior)
	     */
	    hasActions?: boolean | 'custom';
	    /**
	     * Indicates if the column is dedicated as the expandable row toggle
	     */
	    isExpander?: boolean;
	    /**
	     * Mobile options for displaying differently at small screens;
	     * See #EuiTableRowCellMobileOptionsShape
	     */
	    mobileOptions?: EuiTableRowCellMobileOptionsShape;
	    /**
	     * Content rendered outside the visible cell content wrapper. Useful for, e.g. screen reader text.
	     *
	     * Used by EuiBasicTable to render hidden copy markers
	     */
	    append?: ReactNode;
	} type Props = CommonProps & Omit<TdHTMLAttributes<HTMLTableCellElement>, 'valign'> & EuiTableRowCellProps;
	export const EuiTableRowCell: FunctionComponent<Props>;
	export {};

}
declare module '@elastic/eui/src/components/table/_table_cell_content.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiTableCellContentStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiTableCellContent: import("@emotion/utils").SerializedStyles;
	    left: null;
	    right: import("@emotion/utils").SerializedStyles;
	    center: import("@emotion/utils").SerializedStyles;
	    truncateText: import("@emotion/utils").SerializedStyles;
	    wrapText: import("@emotion/utils").SerializedStyles;
	    hasActions: {
	        actions: import("@emotion/utils").SerializedStyles;
	        desktop: import("@emotion/utils").SerializedStyles;
	        mobile: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/table/_table_cell_content' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import type { EuiTableRowCellProps } from '@elastic/eui/src/components/table/table_row_cell';
	export type EuiTableCellContentProps = CommonProps & HTMLAttributes<HTMLDivElement> & Pick<EuiTableRowCellProps, 'align' | 'hasActions' | 'textOnly'> & {
	    truncateText?: EuiTableRowCellProps['truncateText'] | null;
	};
	export const EuiTableCellContent: FunctionComponent<EuiTableCellContentProps>;

}
declare module '@elastic/eui/src/components/table/table_cells_shared.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiTableHeaderFooterCellStyles: (euiThemeContext: UseEuiTheme) => {
	    euiTableHeaderCell: import("@emotion/utils").SerializedStyles;
	    euiTableHeaderCell__content: import("@emotion/utils").SerializedStyles;
	    euiTableHeaderCell__button: import("@emotion/utils").SerializedStyles;
	    euiTableFooterCell: import("@emotion/utils").SerializedStyles;
	};
	export const euiTableCellCheckboxStyles: (euiThemeContext: UseEuiTheme) => {
	    euiTableHeaderCellCheckbox: import("@emotion/utils").SerializedStyles;
	    euiTableRowCellCheckbox: import("@emotion/utils").SerializedStyles;
	    desktop: import("@emotion/utils").SerializedStyles;
	    mobile: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/table/table_footer_cell' {
	import { FunctionComponent, TdHTMLAttributes } from 'react';
	import { HorizontalAlignment } from '@elastic/eui/src/services';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiTableFooterCellProps = CommonProps & TdHTMLAttributes<HTMLTableCellElement> & {
	    align?: HorizontalAlignment;
	    width?: string | number;
	};
	export const EuiTableFooterCell: FunctionComponent<EuiTableFooterCellProps>;

}
declare module '@elastic/eui/src/components/table/table_header' {
	import { FunctionComponent, ReactNode, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiTableHeaderProps = CommonProps & HTMLAttributes<HTMLElement> & {
	    /**
	     * Children must be valid DOM structure residing within `<thead>`.
	     * Use `<td> | <th>` by default, or `<tr><th/></tr>` when `wrapWithTableRow=false`
	     */
	    children?: ReactNode;
	    /**
	     * Automatically adds a wrapping `<tr>` element around the children
	     */
	    wrapWithTableRow?: boolean;
	};
	export const EuiTableHeader: FunctionComponent<EuiTableHeaderProps>;

}
declare module '@elastic/eui/src/components/icon/icon_map' {
	export const typeToPathMap: {
	    accessibility: string;
	    addDataApp: string;
	    advancedSettingsApp: string;
	    agentApp: string;
	    aggregate: string;
	    analyzeEvent: string;
	    annotation: string;
	    anomalyChart: string;
	    anomalySwimLane: string;
	    apmApp: string;
	    apmTrace: string;
	    appSearchApp: string;
	    apps: string;
	    arrowDown: string;
	    arrowLeft: string;
	    arrowRight: string;
	    arrowUp: string;
	    arrowStart: string;
	    arrowEnd: string;
	    article: string;
	    asterisk: string;
	    at: string;
	    auditbeatApp: string;
	    beaker: string;
	    bell: string;
	    bellSlash: string;
	    beta: string;
	    bolt: string;
	    boxesHorizontal: string;
	    boxesVertical: string;
	    branch: string;
	    branchUser: string;
	    broom: string;
	    brush: string;
	    bug: string;
	    bullseye: string;
	    calendar: string;
	    canvasApp: string;
	    casesApp: string;
	    changePointDetection: string;
	    check: string;
	    checkInCircleFilled: string;
	    cheer: string;
	    classificationJob: string;
	    clickLeft: string;
	    clickRight: string;
	    clock: string;
	    clockCounter: string;
	    cloudDrizzle: string;
	    cloudStormy: string;
	    cloudSunny: string;
	    cluster: string;
	    codeApp: string;
	    color: string;
	    compute: string;
	    console: string;
	    consoleApp: string;
	    container: string;
	    continuityAbove: string;
	    continuityAboveBelow: string;
	    continuityBelow: string;
	    continuityWithin: string;
	    contrast: string;
	    contrastHigh: string;
	    controlsHorizontal: string;
	    controlsVertical: string;
	    copy: string;
	    copyClipboard: string;
	    createAdvancedJob: string;
	    createGenericJob: string;
	    createGeoJob: string;
	    createMultiMetricJob: string;
	    createPopulationJob: string;
	    createSingleMetricJob: string;
	    cross: string;
	    crossClusterReplicationApp: string;
	    crossInCircle: string;
	    crosshairs: string;
	    currency: string;
	    cut: string;
	    dashboardApp: string;
	    dataVisualizer: string;
	    database: string;
	    desktop: string;
	    devToolsApp: string;
	    diff: string;
	    discoverApp: string;
	    discuss: string;
	    document: string;
	    documentEdit: string;
	    documentation: string;
	    documents: string;
	    dot: string;
	    dotInCircle: string;
	    doubleArrowLeft: string;
	    doubleArrowRight: string;
	    download: string;
	    editorAlignCenter: string;
	    editorAlignLeft: string;
	    editorAlignRight: string;
	    editorBold: string;
	    editorChecklist: string;
	    editorCodeBlock: string;
	    editorComment: string;
	    editorDistributeHorizontal: string;
	    editorDistributeVertical: string;
	    editorHeading: string;
	    editorItalic: string;
	    editorItemAlignBottom: string;
	    editorItemAlignCenter: string;
	    editorItemAlignLeft: string;
	    editorItemAlignMiddle: string;
	    editorItemAlignRight: string;
	    editorItemAlignTop: string;
	    editorLink: string;
	    editorOrderedList: string;
	    editorPositionBottomLeft: string;
	    editorPositionBottomRight: string;
	    editorPositionTopLeft: string;
	    editorPositionTopRight: string;
	    editorRedo: string;
	    editorStrike: string;
	    editorTable: string;
	    editorUnderline: string;
	    editorUndo: string;
	    editorUnorderedList: string;
	    email: string;
	    empty: string;
	    emsApp: string;
	    endpoint: string;
	    eql: string;
	    eraser: string;
	    error: string;
	    errorFilled: string;
	    esqlVis: string;
	    exit: string;
	    expand: string;
	    expandMini: string;
	    exportAction: string;
	    eye: string;
	    eyeClosed: string;
	    faceHappy: string;
	    faceNeutral: string;
	    faceSad: string;
	    fieldStatistics: string;
	    filebeatApp: string;
	    filter: string;
	    filterExclude: string;
	    filterIgnore: string;
	    filterInclude: string;
	    filterInCircle: string;
	    flag: string;
	    fleetApp: string;
	    fold: string;
	    folderCheck: string;
	    folderClosed: string;
	    folderExclamation: string;
	    folderOpen: string;
	    frameNext: string;
	    framePrevious: string;
	    fullScreen: string;
	    fullScreenExit: string;
	    function: string;
	    gear: string;
	    gisApp: string;
	    glasses: string;
	    globe: string;
	    grab: string;
	    grabHorizontal: string;
	    grabOmnidirectional: string;
	    gradient: string;
	    graphApp: string;
	    grid: string;
	    grokApp: string;
	    heart: string;
	    heartbeatApp: string;
	    heatmap: string;
	    help: string;
	    home: string;
	    iInCircle: string;
	    image: string;
	    importAction: string;
	    index: string;
	    indexClose: string;
	    indexEdit: string;
	    indexFlush: string;
	    indexManagementApp: string;
	    indexMapping: string;
	    indexOpen: string;
	    indexPatternApp: string;
	    indexRollupApp: string;
	    indexRuntime: string;
	    indexSettings: string;
	    indexTemporary: string;
	    infinity: string;
	    inputOutput: string;
	    inspect: string;
	    invert: string;
	    ip: string;
	    key: string;
	    keyboard: string;
	    kqlField: string;
	    kqlFunction: string;
	    kqlOperand: string;
	    kqlSelector: string;
	    kqlValue: string;
	    kubernetesNode: string;
	    kubernetesPod: string;
	    launch: string;
	    layers: string;
	    lensApp: string;
	    lettering: string;
	    lineDashed: string;
	    lineDotted: string;
	    lineSolid: string;
	    link: string;
	    list: string;
	    listAdd: string;
	    lock: string;
	    lockOpen: string;
	    logPatternAnalysis: string;
	    logRateAnalysis: string;
	    logoAWS: string;
	    logoAWSMono: string;
	    logoAerospike: string;
	    logoApache: string;
	    logoAppSearch: string;
	    logoAzure: string;
	    logoAzureMono: string;
	    logoBeats: string;
	    logoBusinessAnalytics: string;
	    logoCeph: string;
	    logoCloud: string;
	    logoCloudEnterprise: string;
	    logoCode: string;
	    logoCodesandbox: string;
	    logoCouchbase: string;
	    logoDocker: string;
	    logoDropwizard: string;
	    logoElastic: string;
	    logoElasticStack: string;
	    logoElasticsearch: string;
	    logoEnterpriseSearch: string;
	    logoEtcd: string;
	    logoGCP: string;
	    logoGCPMono: string;
	    logoGithub: string;
	    logoGmail: string;
	    logoGolang: string;
	    logoGoogleG: string;
	    logoHAproxy: string;
	    logoIBM: string;
	    logoIBMMono: string;
	    logoKafka: string;
	    logoKibana: string;
	    logoKubernetes: string;
	    logoLogging: string;
	    logoLogstash: string;
	    logoMaps: string;
	    logoMemcached: string;
	    logoMetrics: string;
	    logoMongodb: string;
	    logoMySQL: string;
	    logoNginx: string;
	    logoObservability: string;
	    logoOsquery: string;
	    logoPhp: string;
	    logoPostgres: string;
	    logoPrometheus: string;
	    logoRabbitmq: string;
	    logoRedis: string;
	    logoSecurity: string;
	    logoSiteSearch: string;
	    logoSketch: string;
	    logoSlack: string;
	    logoUptime: string;
	    logoVulnerabilityManagement: string;
	    logoWebhook: string;
	    logoWindows: string;
	    logoWorkplaceSearch: string;
	    logsApp: string;
	    logstashFilter: string;
	    logstashIf: string;
	    logstashInput: string;
	    logstashOutput: string;
	    logstashQueue: string;
	    machineLearningApp: string;
	    magnet: string;
	    magnifyWithExclamation: string;
	    magnifyWithMinus: string;
	    magnifyWithPlus: string;
	    managementApp: string;
	    mapMarker: string;
	    memory: string;
	    menu: string;
	    menuDown: string;
	    menuLeft: string;
	    menuRight: string;
	    menuUp: string;
	    merge: string;
	    metricbeatApp: string;
	    metricsApp: string;
	    minimize: string;
	    minus: string;
	    minusInCircle: string;
	    minusInCircleFilled: string;
	    minusInSquare: string;
	    mobile: string;
	    monitoringApp: string;
	    moon: string;
	    move: string;
	    namespace: string;
	    nested: string;
	    newChat: string;
	    node: string;
	    notebookApp: string;
	    number: string;
	    offline: string;
	    online: string;
	    outlierDetectionJob: string;
	    package: string;
	    packetbeatApp: string;
	    pageSelect: string;
	    pagesSelect: string;
	    palette: string;
	    paperClip: string;
	    partial: string;
	    pause: string;
	    payment: string;
	    pencil: string;
	    percent: string;
	    pin: string;
	    pinFilled: string;
	    pipeBreaks: string;
	    pipelineApp: string;
	    pipeNoBreaks: string;
	    pivot: string;
	    play: string;
	    playFilled: string;
	    plus: string;
	    plusInCircle: string;
	    plusInCircleFilled: string;
	    plusInSquare: string;
	    popout: string;
	    push: string;
	    questionInCircle: string;
	    quote: string;
	    recentlyViewedApp: string;
	    refresh: string;
	    regressionJob: string;
	    reporter: string;
	    reportingApp: string;
	    returnKey: string;
	    save: string;
	    savedObjectsApp: string;
	    scale: string;
	    search: string;
	    searchProfilerApp: string;
	    section: string;
	    securityAnalyticsApp: string;
	    securityApp: string;
	    securitySignal: string;
	    securitySignalDetected: string;
	    securitySignalResolved: string;
	    sessionViewer: string;
	    shard: string;
	    share: string;
	    singleMetricViewer: string;
	    snowflake: string;
	    sortAscending: string;
	    sortDescending: string;
	    sortDown: string;
	    sortLeft: string;
	    sortRight: string;
	    sortUp: string;
	    sortable: string;
	    spaces: string;
	    spacesApp: string;
	    sparkles: string;
	    sqlApp: string;
	    starEmpty: string;
	    starEmptySpace: string;
	    starFilled: string;
	    starFilledSpace: string;
	    starMinusEmpty: string;
	    starMinusFilled: string;
	    starPlusEmpty: string;
	    starPlusFilled: string;
	    stats: string;
	    stop: string;
	    stopFilled: string;
	    stopSlash: string;
	    storage: string;
	    string: string;
	    submodule: string;
	    sun: string;
	    swatchInput: string;
	    symlink: string;
	    tableDensityCompact: string;
	    tableDensityExpanded: string;
	    tableDensityNormal: string;
	    tableOfContents: string;
	    tag: string;
	    tear: string;
	    temperature: string;
	    timeline: string;
	    timelineWithArrow: string;
	    timelionApp: string;
	    timeRefresh: string;
	    timeslider: string;
	    training: string;
	    transitionLeftIn: string;
	    transitionLeftOut: string;
	    transitionTopIn: string;
	    transitionTopOut: string;
	    trash: string;
	    unfold: string;
	    unlink: string;
	    upgradeAssistantApp: string;
	    uptimeApp: string;
	    user: string;
	    userAvatar: string;
	    users: string;
	    usersRolesApp: string;
	    vector: string;
	    videoPlayer: string;
	    visArea: string;
	    visAreaStacked: string;
	    visBarHorizontal: string;
	    visBarHorizontalStacked: string;
	    visBarVertical: string;
	    visBarVerticalStacked: string;
	    visGauge: string;
	    visGoal: string;
	    visLine: string;
	    visMapCoordinate: string;
	    visMapRegion: string;
	    visMetric: string;
	    visPie: string;
	    visTable: string;
	    visTagCloud: string;
	    visText: string;
	    visTimelion: string;
	    visVega: string;
	    visVisualBuilder: string;
	    visualizeApp: string;
	    vulnerabilityManagementApp: string;
	    warning: string;
	    warningFilled: string;
	    alert: string;
	    watchesApp: string;
	    wordWrap: string;
	    wordWrapDisabled: string;
	    workplaceSearchApp: string;
	    wrench: string;
	    tokenAlias: string;
	    tokenAnnotation: string;
	    tokenArray: string;
	    tokenBinary: string;
	    tokenBoolean: string;
	    tokenClass: string;
	    tokenCompletionSuggester: string;
	    tokenConstant: string;
	    tokenDate: string;
	    tokenDimension: string;
	    tokenElement: string;
	    tokenEnum: string;
	    tokenEnumMember: string;
	    tokenEvent: string;
	    tokenException: string;
	    tokenField: string;
	    tokenFile: string;
	    tokenFlattened: string;
	    tokenFunction: string;
	    tokenGeo: string;
	    tokenHistogram: string;
	    tokenInterface: string;
	    tokenIP: string;
	    tokenJoin: string;
	    tokenKey: string;
	    tokenKeyword: string;
	    tokenMethod: string;
	    tokenMetricCounter: string;
	    tokenMetricGauge: string;
	    tokenModule: string;
	    tokenNamespace: string;
	    tokenNested: string;
	    tokenNull: string;
	    tokenNumber: string;
	    tokenObject: string;
	    tokenOperator: string;
	    tokenPackage: string;
	    tokenParameter: string;
	    tokenPercolator: string;
	    tokenProperty: string;
	    tokenRange: string;
	    tokenRankFeature: string;
	    tokenRankFeatures: string;
	    tokenRepo: string;
	    tokenSearchType: string;
	    tokenSemanticText: string;
	    tokenShape: string;
	    tokenString: string;
	    tokenStruct: string;
	    tokenSymbol: string;
	    tokenTag: string;
	    tokenText: string;
	    tokenTokenCount: string;
	    tokenVariable: string;
	    tokenVectorDense: string;
	    tokenDenseVector: string;
	    tokenVectorSparse: string;
	};

}
declare module '@elastic/eui/src/components/icon/assets/empty' {
	import * as React from 'react';
	import type { SVGProps } from 'react';
	interface SVGRProps {
	    title?: string;
	    titleId?: string;
	}
	export const icon: ({ title, titleId, ...props }: SVGProps<SVGSVGElement> & SVGRProps) => React.JSX.Element;
	export {};

}
declare module '@elastic/eui/src/services/react' {
	export function enqueueStateChange(fn: Function): void;

}
declare module '@elastic/eui/src/components/icon/named_colors' {
	export const COLORS: readonly ["default", "primary", "success", "accent", "warning", "danger", "text", "subdued", "ghost", "inherit"];
	export type NamedColor = (typeof COLORS)[number];
	export function isNamedColor(name: string): boolean;

}
declare module '@elastic/eui/src/components/icon/icon.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const iconLoadingOpacity = 0.05;
	export const euiIconStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiIcon: import("@emotion/utils").SerializedStyles;
	    accent: import("@emotion/utils").SerializedStyles;
	    danger: import("@emotion/utils").SerializedStyles;
	    ghost: import("@emotion/utils").SerializedStyles;
	    primary: import("@emotion/utils").SerializedStyles;
	    success: import("@emotion/utils").SerializedStyles;
	    subdued: import("@emotion/utils").SerializedStyles;
	    text: import("@emotion/utils").SerializedStyles;
	    warning: import("@emotion/utils").SerializedStyles;
	    inherit: import("@emotion/utils").SerializedStyles;
	    default: import("@emotion/utils").SerializedStyles;
	    customColor: import("@emotion/utils").SerializedStyles;
	    logoElasticOutline: import("@emotion/utils").SerializedStyles;
	    original: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    xl: import("@emotion/utils").SerializedStyles;
	    xxl: import("@emotion/utils").SerializedStyles;
	    app: import("@emotion/utils").SerializedStyles;
	    logo: import("@emotion/utils").SerializedStyles;
	    isLoading: import("@emotion/utils").SerializedStyles;
	    isLoaded: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/icon/icon' {
	import React, { PureComponent, ComponentType, SVGAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { typeToPathMap } from '@elastic/eui/src/components/icon/icon_map';
	import { WithEuiStylesMemoizerProps } from '@elastic/eui/src/services';
	export { COLORS } from '@elastic/eui/src/components/icon/named_colors';
	import { NamedColor } from '@elastic/eui/src/components/icon/named_colors';
	export const TYPES: ("string" | "number" | "function" | "search" | "link" | "at" | "article" | "menu" | "section" | "filter" | "image" | "stop" | "key" | "temperature" | "warning" | "color" | "copy" | "cut" | "error" | "pause" | "play" | "scale" | "wordWrap" | "grid" | "grab" | "help" | "move" | "invert" | "spaces" | "dot" | "alert" | "document" | "list" | "email" | "push" | "container" | "accessibility" | "aggregate" | "analyzeEvent" | "annotation" | "apps" | "arrowStart" | "arrowEnd" | "asterisk" | "beaker" | "bell" | "bellSlash" | "beta" | "bolt" | "branch" | "branchUser" | "broom" | "brush" | "bug" | "bullseye" | "calendar" | "check" | "checkInCircleFilled" | "cheer" | "clickLeft" | "clickRight" | "clock" | "clockCounter" | "cloudDrizzle" | "cloudStormy" | "cloudSunny" | "cluster" | "compute" | "console" | "continuityAbove" | "continuityAboveBelow" | "continuityBelow" | "continuityWithin" | "contrast" | "contrastHigh" | "cross" | "crosshairs" | "currency" | "database" | "desktop" | "diff" | "discuss" | "documentEdit" | "documentation" | "documents" | "dotInCircle" | "doubleArrowLeft" | "doubleArrowRight" | "download" | "editorDistributeHorizontal" | "editorDistributeVertical" | "editorItemAlignBottom" | "editorItemAlignCenter" | "editorItemAlignLeft" | "editorItemAlignMiddle" | "editorItemAlignRight" | "editorItemAlignTop" | "editorPositionBottomLeft" | "editorPositionBottomRight" | "editorPositionTopLeft" | "editorPositionTopRight" | "empty" | "endpoint" | "eql" | "eraser" | "errorFilled" | "esqlVis" | "exit" | "expand" | "expandMini" | "eye" | "filterExclude" | "filterIgnore" | "filterInclude" | "filterInCircle" | "flag" | "fold" | "frameNext" | "framePrevious" | "fullScreenExit" | "gear" | "glasses" | "globe" | "grabOmnidirectional" | "gradient" | "heart" | "heatmap" | "home" | "iInCircle" | "index" | "indexTemporary" | "infinity" | "inputOutput" | "inspect" | "ip" | "keyboard" | "kubernetesNode" | "kubernetesPod" | "launch" | "layers" | "lettering" | "lineDashed" | "lineDotted" | "lineSolid" | "lock" | "lockOpen" | "magnet" | "magnifyWithExclamation" | "magnifyWithMinus" | "magnifyWithPlus" | "memory" | "menuDown" | "menuLeft" | "menuRight" | "menuUp" | "merge" | "minimize" | "minus" | "mobile" | "moon" | "namespace" | "nested" | "node" | "offline" | "online" | "package" | "pageSelect" | "pagesSelect" | "palette" | "partial" | "payment" | "pencil" | "percent" | "pin" | "pipeBreaks" | "pipeNoBreaks" | "pivot" | "playFilled" | "plus" | "popout" | "quote" | "refresh" | "reporter" | "save" | "securitySignal" | "securitySignalDetected" | "securitySignalResolved" | "sessionViewer" | "shard" | "share" | "snowflake" | "sortAscending" | "sortDescending" | "sortLeft" | "sortRight" | "sortable" | "sparkles" | "starPlusEmpty" | "starPlusFilled" | "stats" | "storage" | "submodule" | "sun" | "symlink" | "tableOfContents" | "tag" | "tear" | "timeline" | "timelineWithArrow" | "timeRefresh" | "timeslider" | "training" | "transitionLeftIn" | "transitionLeftOut" | "transitionTopIn" | "transitionTopOut" | "trash" | "unfold" | "unlink" | "user" | "userAvatar" | "users" | "vector" | "videoPlayer" | "warningFilled" | "wordWrapDisabled" | "wrench" | "tokenAlias" | "tokenAnnotation" | "tokenArray" | "tokenBinary" | "tokenBoolean" | "tokenClass" | "tokenCompletionSuggester" | "tokenConstant" | "tokenDate" | "tokenDimension" | "tokenElement" | "tokenEnum" | "tokenEnumMember" | "tokenEvent" | "tokenException" | "tokenField" | "tokenFile" | "tokenFlattened" | "tokenFunction" | "tokenGeo" | "tokenHistogram" | "tokenInterface" | "tokenIP" | "tokenJoin" | "tokenKey" | "tokenKeyword" | "tokenMethod" | "tokenMetricCounter" | "tokenMetricGauge" | "tokenModule" | "tokenNamespace" | "tokenNested" | "tokenNull" | "tokenNumber" | "tokenObject" | "tokenOperator" | "tokenPackage" | "tokenParameter" | "tokenPercolator" | "tokenProperty" | "tokenRange" | "tokenRankFeature" | "tokenRankFeatures" | "tokenRepo" | "tokenSearchType" | "tokenSemanticText" | "tokenShape" | "tokenString" | "tokenStruct" | "tokenSymbol" | "tokenTag" | "tokenText" | "tokenTokenCount" | "tokenVariable" | "tokenVectorDense" | "tokenVectorSparse" | "addDataApp" | "advancedSettingsApp" | "agentApp" | "anomalyChart" | "anomalySwimLane" | "apmApp" | "apmTrace" | "appSearchApp" | "arrowDown" | "arrowLeft" | "arrowRight" | "arrowUp" | "auditbeatApp" | "boxesHorizontal" | "boxesVertical" | "canvasApp" | "casesApp" | "changePointDetection" | "classificationJob" | "codeApp" | "consoleApp" | "controlsHorizontal" | "controlsVertical" | "copyClipboard" | "createAdvancedJob" | "createGenericJob" | "createGeoJob" | "createMultiMetricJob" | "createPopulationJob" | "createSingleMetricJob" | "crossClusterReplicationApp" | "crossInCircle" | "dashboardApp" | "dataVisualizer" | "devToolsApp" | "discoverApp" | "editorAlignCenter" | "editorAlignLeft" | "editorAlignRight" | "editorBold" | "editorChecklist" | "editorCodeBlock" | "editorComment" | "editorHeading" | "editorItalic" | "editorLink" | "editorOrderedList" | "editorRedo" | "editorStrike" | "editorTable" | "editorUnderline" | "editorUndo" | "editorUnorderedList" | "emsApp" | "exportAction" | "eyeClosed" | "faceHappy" | "faceNeutral" | "faceSad" | "fieldStatistics" | "filebeatApp" | "fleetApp" | "folderCheck" | "folderClosed" | "folderExclamation" | "folderOpen" | "fullScreen" | "gisApp" | "grabHorizontal" | "graphApp" | "grokApp" | "heartbeatApp" | "importAction" | "indexClose" | "indexEdit" | "indexFlush" | "indexManagementApp" | "indexMapping" | "indexOpen" | "indexPatternApp" | "indexRollupApp" | "indexRuntime" | "indexSettings" | "kqlField" | "kqlFunction" | "kqlOperand" | "kqlSelector" | "kqlValue" | "lensApp" | "listAdd" | "logPatternAnalysis" | "logRateAnalysis" | "logoAWS" | "logoAWSMono" | "logoAerospike" | "logoApache" | "logoAppSearch" | "logoAzure" | "logoAzureMono" | "logoBeats" | "logoBusinessAnalytics" | "logoCeph" | "logoCloud" | "logoCloudEnterprise" | "logoCode" | "logoCodesandbox" | "logoCouchbase" | "logoDocker" | "logoDropwizard" | "logoElastic" | "logoElasticStack" | "logoElasticsearch" | "logoEnterpriseSearch" | "logoEtcd" | "logoGCP" | "logoGCPMono" | "logoGithub" | "logoGmail" | "logoGolang" | "logoGoogleG" | "logoHAproxy" | "logoIBM" | "logoIBMMono" | "logoKafka" | "logoKibana" | "logoKubernetes" | "logoLogging" | "logoLogstash" | "logoMaps" | "logoMemcached" | "logoMetrics" | "logoMongodb" | "logoMySQL" | "logoNginx" | "logoObservability" | "logoOsquery" | "logoPhp" | "logoPostgres" | "logoPrometheus" | "logoRabbitmq" | "logoRedis" | "logoSecurity" | "logoSiteSearch" | "logoSketch" | "logoSlack" | "logoUptime" | "logoVulnerabilityManagement" | "logoWebhook" | "logoWindows" | "logoWorkplaceSearch" | "logsApp" | "logstashFilter" | "logstashIf" | "logstashInput" | "logstashOutput" | "logstashQueue" | "machineLearningApp" | "managementApp" | "mapMarker" | "metricbeatApp" | "metricsApp" | "minusInCircle" | "minusInCircleFilled" | "minusInSquare" | "monitoringApp" | "newChat" | "notebookApp" | "outlierDetectionJob" | "packetbeatApp" | "paperClip" | "pinFilled" | "pipelineApp" | "plusInCircle" | "plusInCircleFilled" | "plusInSquare" | "questionInCircle" | "recentlyViewedApp" | "regressionJob" | "reportingApp" | "returnKey" | "savedObjectsApp" | "searchProfilerApp" | "securityAnalyticsApp" | "securityApp" | "singleMetricViewer" | "sortDown" | "sortUp" | "spacesApp" | "sqlApp" | "starEmpty" | "starEmptySpace" | "starFilled" | "starFilledSpace" | "starMinusEmpty" | "starMinusFilled" | "stopFilled" | "stopSlash" | "swatchInput" | "tableDensityCompact" | "tableDensityExpanded" | "tableDensityNormal" | "timelionApp" | "upgradeAssistantApp" | "uptimeApp" | "usersRolesApp" | "visArea" | "visAreaStacked" | "visBarHorizontal" | "visBarHorizontalStacked" | "visBarVertical" | "visBarVerticalStacked" | "visGauge" | "visGoal" | "visLine" | "visMapCoordinate" | "visMapRegion" | "visMetric" | "visPie" | "visTable" | "visTagCloud" | "visText" | "visTimelion" | "visVega" | "visVisualBuilder" | "visualizeApp" | "vulnerabilityManagementApp" | "watchesApp" | "workplaceSearchApp" | "tokenDenseVector")[];
	export type EuiIconType = keyof typeof typeToPathMap;
	export type IconType = EuiIconType | string | ComponentType;
	export type IconColor = string | NamedColor;
	export const SIZES: readonly ["original", "s", "m", "l", "xl", "xxl"];
	export type IconSize = (typeof SIZES)[number];
	export type EuiIconProps = CommonProps & Omit<SVGAttributes<SVGElement>, 'type' | 'color' | 'size'> & {
	    /**
	     * `Enum` is any of the named icons listed in the docs, `string` is usually a URL to an SVG file, and `elementType` is any React SVG component
	     */
	    type: IconType;
	    /**
	     * One of EUI's color palette or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value.
	     * Note that coloring only works if your SVG is removed of fill attributes.
	     */
	    color?: IconColor;
	    /**
	     * Note that every size other than `original` assumes the provided SVG sits on a square viewbox.
	     */
	    size?: IconSize;
	    /**
	     * Descriptive title for naming the icon based on its use
	     */
	    title?: string;
	    /**
	     * A unique identifier for the title element
	     */
	    titleId?: string;
	    /**
	     * Its value should be one or more element IDs
	     */
	    'aria-labelledby'?: string;
	    /**
	     * Callback when the icon has been loaded & rendered
	     */
	    onIconLoad?: () => void;
	};
	interface State {
	    icon: undefined | ComponentType | string;
	    iconTitle: undefined | string;
	    isLoading: boolean;
	    neededLoading: boolean;
	}
	export const clearIconComponentCache: (iconType?: "string" | "number" | "function" | "search" | "link" | "at" | "article" | "menu" | "section" | "filter" | "image" | "stop" | "key" | "temperature" | "warning" | "color" | "copy" | "cut" | "error" | "pause" | "play" | "scale" | "wordWrap" | "grid" | "grab" | "help" | "move" | "invert" | "spaces" | "dot" | "alert" | "document" | "list" | "email" | "push" | "container" | "accessibility" | "aggregate" | "analyzeEvent" | "annotation" | "apps" | "arrowStart" | "arrowEnd" | "asterisk" | "beaker" | "bell" | "bellSlash" | "beta" | "bolt" | "branch" | "branchUser" | "broom" | "brush" | "bug" | "bullseye" | "calendar" | "check" | "checkInCircleFilled" | "cheer" | "clickLeft" | "clickRight" | "clock" | "clockCounter" | "cloudDrizzle" | "cloudStormy" | "cloudSunny" | "cluster" | "compute" | "console" | "continuityAbove" | "continuityAboveBelow" | "continuityBelow" | "continuityWithin" | "contrast" | "contrastHigh" | "cross" | "crosshairs" | "currency" | "database" | "desktop" | "diff" | "discuss" | "documentEdit" | "documentation" | "documents" | "dotInCircle" | "doubleArrowLeft" | "doubleArrowRight" | "download" | "editorDistributeHorizontal" | "editorDistributeVertical" | "editorItemAlignBottom" | "editorItemAlignCenter" | "editorItemAlignLeft" | "editorItemAlignMiddle" | "editorItemAlignRight" | "editorItemAlignTop" | "editorPositionBottomLeft" | "editorPositionBottomRight" | "editorPositionTopLeft" | "editorPositionTopRight" | "empty" | "endpoint" | "eql" | "eraser" | "errorFilled" | "esqlVis" | "exit" | "expand" | "expandMini" | "eye" | "filterExclude" | "filterIgnore" | "filterInclude" | "filterInCircle" | "flag" | "fold" | "frameNext" | "framePrevious" | "fullScreenExit" | "gear" | "glasses" | "globe" | "grabOmnidirectional" | "gradient" | "heart" | "heatmap" | "home" | "iInCircle" | "index" | "indexTemporary" | "infinity" | "inputOutput" | "inspect" | "ip" | "keyboard" | "kubernetesNode" | "kubernetesPod" | "launch" | "layers" | "lettering" | "lineDashed" | "lineDotted" | "lineSolid" | "lock" | "lockOpen" | "magnet" | "magnifyWithExclamation" | "magnifyWithMinus" | "magnifyWithPlus" | "memory" | "menuDown" | "menuLeft" | "menuRight" | "menuUp" | "merge" | "minimize" | "minus" | "mobile" | "moon" | "namespace" | "nested" | "node" | "offline" | "online" | "package" | "pageSelect" | "pagesSelect" | "palette" | "partial" | "payment" | "pencil" | "percent" | "pin" | "pipeBreaks" | "pipeNoBreaks" | "pivot" | "playFilled" | "plus" | "popout" | "quote" | "refresh" | "reporter" | "save" | "securitySignal" | "securitySignalDetected" | "securitySignalResolved" | "sessionViewer" | "shard" | "share" | "snowflake" | "sortAscending" | "sortDescending" | "sortLeft" | "sortRight" | "sortable" | "sparkles" | "starPlusEmpty" | "starPlusFilled" | "stats" | "storage" | "submodule" | "sun" | "symlink" | "tableOfContents" | "tag" | "tear" | "timeline" | "timelineWithArrow" | "timeRefresh" | "timeslider" | "training" | "transitionLeftIn" | "transitionLeftOut" | "transitionTopIn" | "transitionTopOut" | "trash" | "unfold" | "unlink" | "user" | "userAvatar" | "users" | "vector" | "videoPlayer" | "warningFilled" | "wordWrapDisabled" | "wrench" | "tokenAlias" | "tokenAnnotation" | "tokenArray" | "tokenBinary" | "tokenBoolean" | "tokenClass" | "tokenCompletionSuggester" | "tokenConstant" | "tokenDate" | "tokenDimension" | "tokenElement" | "tokenEnum" | "tokenEnumMember" | "tokenEvent" | "tokenException" | "tokenField" | "tokenFile" | "tokenFlattened" | "tokenFunction" | "tokenGeo" | "tokenHistogram" | "tokenInterface" | "tokenIP" | "tokenJoin" | "tokenKey" | "tokenKeyword" | "tokenMethod" | "tokenMetricCounter" | "tokenMetricGauge" | "tokenModule" | "tokenNamespace" | "tokenNested" | "tokenNull" | "tokenNumber" | "tokenObject" | "tokenOperator" | "tokenPackage" | "tokenParameter" | "tokenPercolator" | "tokenProperty" | "tokenRange" | "tokenRankFeature" | "tokenRankFeatures" | "tokenRepo" | "tokenSearchType" | "tokenSemanticText" | "tokenShape" | "tokenString" | "tokenStruct" | "tokenSymbol" | "tokenTag" | "tokenText" | "tokenTokenCount" | "tokenVariable" | "tokenVectorDense" | "tokenVectorSparse" | "addDataApp" | "advancedSettingsApp" | "agentApp" | "anomalyChart" | "anomalySwimLane" | "apmApp" | "apmTrace" | "appSearchApp" | "arrowDown" | "arrowLeft" | "arrowRight" | "arrowUp" | "auditbeatApp" | "boxesHorizontal" | "boxesVertical" | "canvasApp" | "casesApp" | "changePointDetection" | "classificationJob" | "codeApp" | "consoleApp" | "controlsHorizontal" | "controlsVertical" | "copyClipboard" | "createAdvancedJob" | "createGenericJob" | "createGeoJob" | "createMultiMetricJob" | "createPopulationJob" | "createSingleMetricJob" | "crossClusterReplicationApp" | "crossInCircle" | "dashboardApp" | "dataVisualizer" | "devToolsApp" | "discoverApp" | "editorAlignCenter" | "editorAlignLeft" | "editorAlignRight" | "editorBold" | "editorChecklist" | "editorCodeBlock" | "editorComment" | "editorHeading" | "editorItalic" | "editorLink" | "editorOrderedList" | "editorRedo" | "editorStrike" | "editorTable" | "editorUnderline" | "editorUndo" | "editorUnorderedList" | "emsApp" | "exportAction" | "eyeClosed" | "faceHappy" | "faceNeutral" | "faceSad" | "fieldStatistics" | "filebeatApp" | "fleetApp" | "folderCheck" | "folderClosed" | "folderExclamation" | "folderOpen" | "fullScreen" | "gisApp" | "grabHorizontal" | "graphApp" | "grokApp" | "heartbeatApp" | "importAction" | "indexClose" | "indexEdit" | "indexFlush" | "indexManagementApp" | "indexMapping" | "indexOpen" | "indexPatternApp" | "indexRollupApp" | "indexRuntime" | "indexSettings" | "kqlField" | "kqlFunction" | "kqlOperand" | "kqlSelector" | "kqlValue" | "lensApp" | "listAdd" | "logPatternAnalysis" | "logRateAnalysis" | "logoAWS" | "logoAWSMono" | "logoAerospike" | "logoApache" | "logoAppSearch" | "logoAzure" | "logoAzureMono" | "logoBeats" | "logoBusinessAnalytics" | "logoCeph" | "logoCloud" | "logoCloudEnterprise" | "logoCode" | "logoCodesandbox" | "logoCouchbase" | "logoDocker" | "logoDropwizard" | "logoElastic" | "logoElasticStack" | "logoElasticsearch" | "logoEnterpriseSearch" | "logoEtcd" | "logoGCP" | "logoGCPMono" | "logoGithub" | "logoGmail" | "logoGolang" | "logoGoogleG" | "logoHAproxy" | "logoIBM" | "logoIBMMono" | "logoKafka" | "logoKibana" | "logoKubernetes" | "logoLogging" | "logoLogstash" | "logoMaps" | "logoMemcached" | "logoMetrics" | "logoMongodb" | "logoMySQL" | "logoNginx" | "logoObservability" | "logoOsquery" | "logoPhp" | "logoPostgres" | "logoPrometheus" | "logoRabbitmq" | "logoRedis" | "logoSecurity" | "logoSiteSearch" | "logoSketch" | "logoSlack" | "logoUptime" | "logoVulnerabilityManagement" | "logoWebhook" | "logoWindows" | "logoWorkplaceSearch" | "logsApp" | "logstashFilter" | "logstashIf" | "logstashInput" | "logstashOutput" | "logstashQueue" | "machineLearningApp" | "managementApp" | "mapMarker" | "metricbeatApp" | "metricsApp" | "minusInCircle" | "minusInCircleFilled" | "minusInSquare" | "monitoringApp" | "newChat" | "notebookApp" | "outlierDetectionJob" | "packetbeatApp" | "paperClip" | "pinFilled" | "pipelineApp" | "plusInCircle" | "plusInCircleFilled" | "plusInSquare" | "questionInCircle" | "recentlyViewedApp" | "regressionJob" | "reportingApp" | "returnKey" | "savedObjectsApp" | "searchProfilerApp" | "securityAnalyticsApp" | "securityApp" | "singleMetricViewer" | "sortDown" | "sortUp" | "spacesApp" | "sqlApp" | "starEmpty" | "starEmptySpace" | "starFilled" | "starFilledSpace" | "starMinusEmpty" | "starMinusFilled" | "stopFilled" | "stopSlash" | "swatchInput" | "tableDensityCompact" | "tableDensityExpanded" | "tableDensityNormal" | "timelionApp" | "upgradeAssistantApp" | "uptimeApp" | "usersRolesApp" | "visArea" | "visAreaStacked" | "visBarHorizontal" | "visBarHorizontalStacked" | "visBarVertical" | "visBarVerticalStacked" | "visGauge" | "visGoal" | "visLine" | "visMapCoordinate" | "visMapRegion" | "visMetric" | "visPie" | "visTable" | "visTagCloud" | "visText" | "visTimelion" | "visVega" | "visVisualBuilder" | "visualizeApp" | "vulnerabilityManagementApp" | "watchesApp" | "workplaceSearchApp" | "tokenDenseVector" | undefined) => void;
	export const appendIconComponentCache: (iconTypeToIconComponentMap: {
	    [iconType: string]: React.ComponentType<{}>;
	}) => void;
	export class EuiIconClass extends PureComponent<EuiIconProps & WithEuiStylesMemoizerProps, State> {
	    isMounted: boolean;
	    constructor(props: EuiIconProps & WithEuiStylesMemoizerProps);
	    componentDidMount(): void;
	    componentDidUpdate(prevProps: EuiIconProps): void;
	    componentWillUnmount(): void;
	    loadIconComponent: (iconType: EuiIconType) => void;
	    onIconLoad: () => void;
	    render(): React.JSX.Element;
	}
	export const EuiIcon: React.ForwardRefExoticComponent<Omit<EuiIconProps, "stylesMemoizer"> & React.RefAttributes<Omit<EuiIconProps, "stylesMemoizer">>>;

}
declare module '@elastic/eui/src/components/icon' {
	export type { EuiIconProps, IconColor, IconSize, IconType } from '@elastic/eui/src/components/icon/icon';
	export { EuiIcon, TYPES as ICON_TYPES, SIZES as ICON_SIZES, COLORS as ICON_COLORS, } from '@elastic/eui/src/components/icon/icon';

}
declare module '@elastic/eui/src/components/inner_text/inner_text' {
	import { FunctionComponent, ReactElement } from 'react'; type RefT = HTMLElement | Element | undefined | null;
	export function useInnerText(innerTextFallback?: string): [(node: RefT) => void, string | undefined];
	export interface EuiInnerTextProps {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: (ref?: (node: RefT) => void, innerText?: string) => ReactElement;
	    fallback?: string;
	}
	export const EuiInnerText: FunctionComponent<EuiInnerTextProps>;
	export {};

}
declare module '@elastic/eui/src/components/inner_text' {
	export type { EuiInnerTextProps } from '@elastic/eui/src/components/inner_text/inner_text';
	export { useInnerText, EuiInnerText } from '@elastic/eui/src/components/inner_text/inner_text';

}
declare module '@elastic/eui/src/components/table/table_header_cell_shared' {
	export const HEADER_CELL_SCOPE: readonly ["col", "row", "colgroup", "rowgroup"];

}
declare module '@elastic/eui/src/components/table/table_header_cell' {
	import { FunctionComponent, ThHTMLAttributes, ReactNode } from 'react';
	import { HorizontalAlignment } from '@elastic/eui/src/services';
	import { CommonProps, NoArgCallback } from '@elastic/eui/src/components/common';
	import type { EuiTableRowCellMobileOptionsShape } from '@elastic/eui/src/components/table/table_row_cell';
	import { HEADER_CELL_SCOPE } from '@elastic/eui/src/components/table/table_header_cell_shared';
	export type TableHeaderCellScope = (typeof HEADER_CELL_SCOPE)[number];
	export type EuiTableHeaderCellProps = CommonProps & Omit<ThHTMLAttributes<HTMLTableHeaderCellElement>, 'align' | 'scope'> & {
	    align?: HorizontalAlignment;
	    isSortAscending?: boolean;
	    isSorted?: boolean;
	    mobileOptions?: Pick<EuiTableRowCellMobileOptionsShape, 'only' | 'show'>;
	    onSort?: NoArgCallback<void>;
	    scope?: TableHeaderCellScope;
	    width?: string | number;
	    description?: string;
	    /**
	     * Shows the sort indicator but removes the button
	     */
	    readOnly?: boolean;
	    /**
	     * Content rendered outside the visible cell content wrapper. Useful for, e.g. screen reader text.
	     *
	     * Used by EuiBasicTable to render hidden copy markers
	     */
	    append?: ReactNode;
	};
	export const EuiTableHeaderCell: FunctionComponent<EuiTableHeaderCellProps>;

}
declare module '@elastic/eui/src/components/table/table_header_cell_checkbox' {
	import { FunctionComponent, ThHTMLAttributes, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { HEADER_CELL_SCOPE } from '@elastic/eui/src/components/table/table_header_cell_shared';
	export type EuiTableHeaderCellCheckboxScope = (typeof HEADER_CELL_SCOPE)[number];
	export interface EuiTableHeaderCellCheckboxProps {
	    width?: string | number;
	    scope?: EuiTableHeaderCellCheckboxScope;
	    append?: ReactNode;
	}
	export const EuiTableHeaderCellCheckbox: FunctionComponent<CommonProps & ThHTMLAttributes<HTMLTableHeaderCellElement> & EuiTableHeaderCellCheckboxProps>;

}
declare module '@elastic/eui/src/themes/amsterdam/global_styling/mixins/button' {
	import { type SerializedStyles } from '@emotion/react';
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const BUTTON_COLORS: readonly ["text", "accent", "primary", "success", "warning", "danger"];
	export type _EuiButtonColor = (typeof BUTTON_COLORS)[number];
	export const BUTTON_DISPLAYS: readonly ["base", "fill", "empty"];
	export type _EuiButtonDisplay = (typeof BUTTON_DISPLAYS)[number];
	export interface _EuiButtonOptions {
	    display?: _EuiButtonDisplay;
	}
	/**
	 * Creates the `base` version of button styles with proper text contrast.
	 * @param euiThemeContext
	 * @param color One of the named button colors or 'disabled'
	 * @returns Style object `{ backgroundColor, color }`
	 */
	export const euiButtonColor: (euiThemeContext: UseEuiTheme, color: _EuiButtonColor | 'disabled') => {
	    color: string;
	    backgroundColor: string;
	};
	/**
	 * Creates the `fill` version of buttons styles with proper text contrast.
	 * @param euiThemeContext
	 * @param color One of the named button colors or 'disabled'
	 * @returns Style object `{ backgroundColor, color }`
	 */
	export const euiButtonFillColor: (euiThemeContext: UseEuiTheme, color: _EuiButtonColor | 'disabled') => {
	    color: string;
	    backgroundColor: string;
	};
	/**
	 * Creates the `empty` version of button styles using the text-variant and adding interactive styles.
	 * @param euiThemeContext
	 * @param color One of the named button colors or 'disabled'
	 * @returns Style object `{ backgroundColor, color }` where `background` is typically used for interactive states
	 */
	export const euiButtonEmptyColor: (euiThemeContext: UseEuiTheme, color: _EuiButtonColor | 'disabled') => {
	    color: string;
	    backgroundColor: string;
	};
	/**
	 * Given the button display type, returns the Emotion based color keys.
	 * @param options Button display type
	 * @returns An object of `_EuiButtonColor` keys including `disabled`
	 */
	export const useEuiButtonColorCSS: (options?: _EuiButtonOptions) => Record<"text" | "accent" | "primary" | "success" | "warning" | "danger" | "disabled", SerializedStyles>;
	/**
	 * Creates the translate animation when button is in focus.
	 * @returns string
	 */
	export const useEuiButtonFocusCSS: () => SerializedStyles;
	/**
	 * Map of `size` props to various sizings/scales
	 * that should remain consistent across all buttons
	 */
	export const euiButtonSizeMap: ({ euiTheme }: UseEuiTheme) => {
	    xs: {
	        height: string;
	        radius: import("csstype").Property.BorderRadius<string | number> | undefined;
	        fontScale: "xs";
	    };
	    s: {
	        height: string;
	        radius: import("csstype").Property.BorderRadius<string | number> | undefined;
	        fontScale: "s";
	    };
	    m: {
	        height: string;
	        radius: import("csstype").Property.BorderRadius<string | number> | undefined;
	        fontScale: "s";
	    };
	};

}
declare module '@elastic/eui/src/themes/amsterdam/global_styling/functions/shadows' {
	import { EuiThemeColorModeStandard } from '@elastic/eui/src/services/theme/types';
	export const getShadowColor: (color: string, opacity: number, colorMode: EuiThemeColorModeStandard) => string;

}
declare module '@elastic/eui/src/themes/amsterdam/global_styling/functions' {
	export * from '@elastic/eui/src/themes/amsterdam/global_styling/functions/shadows';

}
declare module '@elastic/eui/src/themes/amsterdam/global_styling/mixins/shadow' {
	import { UseEuiTheme } from '@elastic/eui/src/services/theme';
	import { _EuiThemeShadowSize, _EuiThemeShadowCustomColor } from '@elastic/eui/src/global_styling/variables/shadow';
	export interface EuiShadowCustomColor {
	    color?: string;
	}
	/**
	 * euiSlightShadow
	 */
	export const euiShadowXSmall: ({ euiTheme, colorMode }: UseEuiTheme, { color: _color }?: _EuiThemeShadowCustomColor) => string;
	/**
	 * bottomShadowSmall
	 */
	export const euiShadowSmall: ({ euiTheme, colorMode }: UseEuiTheme, { color: _color }?: _EuiThemeShadowCustomColor) => string;
	/**
	 * bottomShadowMedium
	 */
	export const euiShadowMedium: ({ euiTheme, colorMode }: UseEuiTheme, { color: _color, property }?: _EuiThemeShadowCustomColor) => string;
	/**
	 * bottomShadow
	 */
	export const euiShadowLarge: ({ euiTheme, colorMode }: UseEuiTheme, { color: _color }?: _EuiThemeShadowCustomColor) => string;
	/**
	 * bottomShadowLarge
	 */
	export interface EuiShadowXLarge extends _EuiThemeShadowCustomColor {
	    reverse?: boolean;
	}
	export const euiShadowXLarge: ({ euiTheme, colorMode }: UseEuiTheme, { color: _color, reverse }?: EuiShadowXLarge) => string;
	/**
	 * slightShadowHover
	 */
	export const euiSlightShadowHover: ({ euiTheme, colorMode }: UseEuiTheme, { color: _color }?: _EuiThemeShadowCustomColor) => string;
	export const useEuiSlightShadowHover: (color?: _EuiThemeShadowCustomColor['color']) => string;
	/**
	 * bottomShadowFlat
	 *
	 * Similar to shadow medium but without the bottom depth.
	 * Useful for popovers that drop UP rather than DOWN.
	 */
	export const euiShadowFlat: ({ euiTheme, colorMode }: UseEuiTheme, { color: _color }?: _EuiThemeShadowCustomColor) => string;
	export const useEuiShadowFlat: (color?: _EuiThemeShadowCustomColor['color']) => string;
	export const euiShadow: (euiThemeContext: UseEuiTheme, size?: _EuiThemeShadowSize, { color }?: _EuiThemeShadowCustomColor) => string;
	export const useEuiShadow: (size?: _EuiThemeShadowSize, color?: _EuiThemeShadowCustomColor['color']) => string;

}
declare module '@elastic/eui/src/themes/amsterdam/global_styling/mixins' {
	export * from '@elastic/eui/src/themes/amsterdam/global_styling/mixins/button';
	export * from '@elastic/eui/src/themes/amsterdam/global_styling/mixins/shadow';

}
declare module '@elastic/eui/src/components/button/button_display/_button_display.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiButtonBaseCSS: () => string;
	export const euiButtonDisplayStyles: (euiThemeContext: UseEuiTheme) => {
	    euiButtonDisplay: import("@emotion/utils").SerializedStyles;
	    isDisabled: import("@emotion/utils").SerializedStyles;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    defaultMinWidth: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/loading/_loading_strings' {
	export const useLoadingAriaLabel: () => string;

}
declare module '@elastic/eui/src/components/loading/loading_elastic.styles' {
	export const euiLoadingElasticStyles: {
	    euiLoadingElastic: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/loading/loading_elastic' {
	import { HTMLAttributes, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const SIZES: readonly ["m", "l", "xl", "xxl"];
	export type EuiLoadingElasticSize = (typeof SIZES)[number];
	export interface EuiLoadingElasticProps {
	    size?: EuiLoadingElasticSize;
	}
	export const EuiLoadingElastic: FunctionComponent<CommonProps & HTMLAttributes<HTMLDivElement> & EuiLoadingElasticProps>;

}
declare module '@elastic/eui/src/components/loading/loading_chart.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiLoadingChartStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiLoadingChart: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    xl: import("@emotion/utils").SerializedStyles;
	};
	export const BARS_COUNT = 4;
	export const euiLoadingChartBarStyles: ({ euiTheme, colorMode, }: UseEuiTheme) => {
	    euiLoadingChart__bar: import("@emotion/utils").SerializedStyles;
	    nonmono: import("@emotion/utils").SerializedStyles;
	    mono: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    xl: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/loading/loading_chart' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const SIZES: readonly ["m", "l", "xl"];
	export type EuiLoadingChartSize = (typeof SIZES)[number];
	export type EuiLoadingChartProps = CommonProps & HTMLAttributes<HTMLDivElement> & {
	    size?: EuiLoadingChartSize;
	    mono?: boolean;
	};
	export const EuiLoadingChart: FunctionComponent<EuiLoadingChartProps>;

}
declare module '@elastic/eui/src/components/loading/loading_spinner.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	import { EuiLoadingSpinnerColor } from '@elastic/eui/src/components/loading/loading_spinner';
	export const euiSpinnerBorderColorsCSS: ({ euiTheme }: UseEuiTheme, colors?: EuiLoadingSpinnerColor) => string;
	export const euiLoadingSpinnerStyles: (euiThemeContext: UseEuiTheme) => {
	    euiLoadingSpinner: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    xl: import("@emotion/utils").SerializedStyles;
	    xxl: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/loading/loading_spinner' {
	import { HTMLAttributes, FunctionComponent, CSSProperties } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const SIZES: readonly ["s", "m", "l", "xl", "xxl"];
	export type EuiLoadingSpinnerSize = (typeof SIZES)[number];
	export type EuiLoadingSpinnerColor = {
	    border?: CSSProperties['color'];
	    highlight?: CSSProperties['color'];
	};
	export type EuiLoadingSpinnerProps = CommonProps & Omit<HTMLAttributes<HTMLDivElement>, 'color'> & {
	    size?: EuiLoadingSpinnerSize;
	    /**
	     * Sets the color of the border and highlight.
	     * Each key accepts any valid CSS color value as a `string`
	     * See #EuiLoadingSpinnerColor
	     */
	    color?: EuiLoadingSpinnerColor;
	};
	export const EuiLoadingSpinner: FunctionComponent<EuiLoadingSpinnerProps>;

}
declare module '@elastic/eui/src/components/loading/loading_logo.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiLoadingLogoStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiLoadingLogo: import("@emotion/utils").SerializedStyles;
	    euiLoadingLogo__icon: import("@emotion/utils").SerializedStyles;
	    /**
	     * 1. Requires pixel math for animation
	     * 2. Add a half the amount of animation distance padding to the top to give it more room
	     */
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    xl: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/loading/loading_logo' {
	import { HTMLAttributes, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { IconType } from '@elastic/eui/src/components/icon';
	export const SIZES: readonly ["m", "l", "xl"];
	export type EuiLoadingLogoSize = (typeof SIZES)[number];
	export type EuiLoadingLogoProps = CommonProps & HTMLAttributes<HTMLDivElement> & {
	    size?: EuiLoadingLogoSize;
	    /**
	     * While this component should be restricted to using logo icons, it works with any IconType
	     */
	    logo?: IconType;
	};
	export const EuiLoadingLogo: FunctionComponent<EuiLoadingLogoProps>;

}
declare module '@elastic/eui/src/components/loading' {
	export type { EuiLoadingElasticProps } from '@elastic/eui/src/components/loading/loading_elastic';
	export { EuiLoadingElastic } from '@elastic/eui/src/components/loading/loading_elastic';
	export type { EuiLoadingChartProps } from '@elastic/eui/src/components/loading/loading_chart';
	export { EuiLoadingChart } from '@elastic/eui/src/components/loading/loading_chart';
	export type { EuiLoadingSpinnerProps } from '@elastic/eui/src/components/loading/loading_spinner';
	export { EuiLoadingSpinner } from '@elastic/eui/src/components/loading/loading_spinner';
	export type { EuiLoadingLogoProps } from '@elastic/eui/src/components/loading/loading_logo';
	export { EuiLoadingLogo } from '@elastic/eui/src/components/loading/loading_logo';

}
declare module '@elastic/eui/src/components/button/button_display/_button_display_content.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiButtonDisplayContentStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiButtonDisplayContent: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/button/button_display/_button_display_content' {
	import { HTMLAttributes, FunctionComponent, Ref } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { IconType } from '@elastic/eui/src/components/icon';
	export const ICON_SIZES: readonly ["s", "m"];
	export type ButtonContentIconSize = (typeof ICON_SIZES)[number];
	export const ICON_SIDES: readonly ["left", "right"];
	export type ButtonContentIconSide = (typeof ICON_SIDES)[number] | undefined;
	export type EuiButtonDisplayContentType = HTMLAttributes<HTMLSpanElement>;
	/**
	 * *INTERNAL ONLY*
	 * This component is simply a helper component for reuse within other button components.
	 */
	export interface EuiButtonDisplayContentProps extends CommonProps {
	    /**
	     * Any `type` accepted by EuiIcon
	     */
	    iconType?: IconType;
	    /**
	     * Can only be one side `left` or `right`
	     */
	    iconSide?: ButtonContentIconSide;
	    isLoading?: boolean;
	    /**
	     * Object of props passed to the `<span>` wrapping the content's text/children only (not icon)
	     *
	     * This span wrapper can be removed by passing `textProps={false}`.
	     */
	    textProps?: (HTMLAttributes<HTMLSpanElement> & CommonProps & {
	        ref?: Ref<HTMLSpanElement>;
	        'data-text'?: string;
	    }) | false;
	    iconSize?: ButtonContentIconSize;
	    isDisabled?: boolean;
	}
	export const EuiButtonDisplayContent: FunctionComponent<EuiButtonDisplayContentType & EuiButtonDisplayContentProps>;

}
declare module '@elastic/eui/src/services/security/href_validator' {
	export function validateHref(href: string): boolean;

}
declare module '@elastic/eui/src/components/button/button_display/_button_display' {
	import React, { CSSProperties, ReactNode, Ref, ButtonHTMLAttributes } from 'react';
	import { CommonProps, ExclusiveUnion, PropsForAnchor, PropsForButton } from '@elastic/eui/src/components/common';
	import { EuiButtonDisplayContentProps, EuiButtonDisplayContentType } from '@elastic/eui/src/components/button/button_display/_button_display_content'; const SIZES: readonly ["xs", "s", "m"];
	export type EuiButtonDisplaySizes = (typeof SIZES)[number];
	/**
	 * Extends EuiButtonDisplayContentProps which provides
	 * `iconType`, `iconSide`, and `textProps`
	 */
	export interface EuiButtonDisplayCommonProps extends EuiButtonDisplayContentProps, CommonProps {
	    element?: 'a' | 'button' | 'span';
	    children?: ReactNode;
	    size?: EuiButtonDisplaySizes;
	    /**
	     * Applies the boolean state as the `aria-pressed` property to create a toggle button.
	     * *Only use when the readable text does not change between states.*
	     */
	    isSelected?: boolean;
	    /**
	     * Extends the button to 100% width
	     */
	    fullWidth?: boolean;
	    /**
	     * Override the default minimum width
	     */
	    minWidth?: CSSProperties['minWidth'] | false;
	    /**
	     * Force disables the button and changes the icon to a loading spinner
	     */
	    isLoading?: boolean;
	    /**
	     * Object of props passed to the <span/> wrapping the button's content
	     */
	    contentProps?: CommonProps & EuiButtonDisplayContentType;
	    style?: CSSProperties;
	    type?: ButtonHTMLAttributes<HTMLButtonElement>['type'];
	}
	export type EuiButtonDisplayPropsForAnchor = PropsForAnchor<EuiButtonDisplayCommonProps, {
	    buttonRef?: Ref<HTMLAnchorElement>;
	}>;
	export type EuiButtonDisplayPropsForButton = PropsForButton<EuiButtonDisplayCommonProps, {
	    buttonRef?: Ref<HTMLButtonElement>;
	}>;
	export type EuiButtonDisplayProps = ExclusiveUnion<EuiButtonDisplayPropsForAnchor, EuiButtonDisplayPropsForButton>;
	export function isButtonDisabled({ href, isDisabled, isLoading, }: {
	    href?: string;
	    isDisabled?: boolean;
	    isLoading?: boolean;
	}): boolean;
	/**
	 * EuiButtonDisplay is an internal-only component used for displaying
	 * any element as a button.
	 */
	export const EuiButtonDisplay: React.ForwardRefExoticComponent<((import ("@elastic/eui/src/components/common").DisambiguateSet<EuiButtonDisplayPropsForAnchor, EuiButtonDisplayPropsForButton> & EuiButtonDisplayCommonProps & {
	    onClick?: React.MouseEventHandler<HTMLButtonElement> | undefined;
	} & React.ButtonHTMLAttributes<HTMLButtonElement> & {
	    buttonRef?: React.Ref<HTMLButtonElement> | undefined;
	}) | (import ("@elastic/eui/src/components/common").DisambiguateSet<EuiButtonDisplayPropsForButton, EuiButtonDisplayPropsForAnchor> & EuiButtonDisplayCommonProps & {
	    href?: string | undefined;
	    onClick?: React.MouseEventHandler<HTMLAnchorElement> | undefined;
	} & React.AnchorHTMLAttributes<HTMLAnchorElement> & {
	    buttonRef?: React.Ref<HTMLAnchorElement> | undefined;
	})) & React.RefAttributes<HTMLElement>>;
	export {};

}
declare module '@elastic/eui/src/components/button/button' {
	import { FunctionComponent, Ref, ReactNode } from 'react';
	import { CommonProps, ExclusiveUnion, PropsForAnchor, PropsForButton } from '@elastic/eui/src/components/common';
	import { _EuiButtonColor } from '@elastic/eui/src/themes/amsterdam/global_styling/mixins/button';
	import { EuiButtonDisplayCommonProps } from '@elastic/eui/src/components/button/button_display/_button_display';
	export const COLORS: readonly ["text", "accent", "primary", "success", "warning", "danger"];
	export type EuiButtonColor = _EuiButtonColor;
	export const SIZES: readonly ["s", "m"];
	export type EuiButtonSize = (typeof SIZES)[number];
	interface BaseProps {
	    children?: ReactNode;
	    /**
	     * Make button a solid color for prominence
	     */
	    fill?: boolean;
	    /**
	     * Any of the named color palette options.
	     */
	    color?: EuiButtonColor;
	    /**
	     * Use size `s` in confined spaces
	     */
	    size?: EuiButtonSize;
	    /**
	     * `disabled` is also allowed
	     */
	    isDisabled?: boolean;
	}
	export interface EuiButtonProps extends BaseProps, Omit<EuiButtonDisplayCommonProps, 'size'>, CommonProps {
	}
	export type EuiButtonPropsForAnchor = PropsForAnchor<EuiButtonProps, {
	    buttonRef?: Ref<HTMLAnchorElement>;
	}>;
	export type EuiButtonPropsForButton = EuiButtonDisplayCommonProps & PropsForButton<EuiButtonProps, {
	    buttonRef?: Ref<HTMLButtonElement>;
	}>;
	export type Props = ExclusiveUnion<EuiButtonPropsForAnchor, EuiButtonPropsForButton>;
	/**
	 * EuiButton is largely responsible for providing relevant props
	 * and the logic for element-specific attributes
	 */
	export const EuiButton: FunctionComponent<Props>;
	export {};

}
declare module '@elastic/eui/src/components/button/button_empty/button_empty.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiButtonEmptyStyles: (euiThemeContext: UseEuiTheme) => {
	    euiButtonEmpty: import("@emotion/utils").SerializedStyles;
	    isDisabled: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    flush: import("@emotion/utils").SerializedStyles;
	    left: import("@emotion/utils").SerializedStyles;
	    right: import("@emotion/utils").SerializedStyles;
	    both: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/button/button_empty/button_empty' {
	import { FunctionComponent, Ref, ButtonHTMLAttributes } from 'react';
	import { CommonProps, ExclusiveUnion, PropsForAnchor, PropsForButton } from '@elastic/eui/src/components/common';
	import { EuiButtonDisplayContentProps, EuiButtonDisplayContentType } from '@elastic/eui/src/components/button/button_display/_button_display_content';
	import { _EuiButtonColor } from '@elastic/eui/src/themes/amsterdam/global_styling/mixins/button';
	export const SIZES: readonly ["xs", "s", "m"];
	export type EuiButtonEmptySizes = (typeof SIZES)[number];
	export const FLUSH_TYPES: readonly ["left", "right", "both"];
	export type EuiButtonEmptyFlush = (typeof FLUSH_TYPES)[number];
	/**
	 * Extends EuiButtonContentProps which provides
	 * `iconType`, `iconSide`, and `textProps`
	 */
	export interface CommonEuiButtonEmptyProps extends EuiButtonDisplayContentProps, CommonProps {
	    /**
	     * Any of the named color palette options.
	     */
	    color?: _EuiButtonColor;
	    size?: EuiButtonEmptySizes;
	    /**
	     * Ensure the text of the button sits flush to the left, right, or both sides of its container
	     */
	    flush?: EuiButtonEmptyFlush;
	    /**
	     * `disabled` is also allowed
	     */
	    isDisabled?: boolean;
	    /**
	     * Force disables the button and changes the icon to a loading spinner
	     */
	    isLoading?: boolean;
	    /**
	     * Applies the boolean state as the `aria-pressed` property to create a toggle button.
	     * *Only use when the readable text does not change between states.*
	     */
	    isSelected?: boolean;
	    href?: string;
	    target?: string;
	    rel?: string;
	    type?: ButtonHTMLAttributes<HTMLButtonElement>['type'];
	    buttonRef?: Ref<HTMLButtonElement | HTMLAnchorElement>;
	    /**
	     * Object of props passed to the `<span>` wrapping the button's content
	     */
	    contentProps?: CommonProps & EuiButtonDisplayContentType;
	} type EuiButtonEmptyPropsForAnchor = PropsForAnchor<CommonEuiButtonEmptyProps>;
	export type EuiButtonEmptyPropsForButton = PropsForButton<CommonEuiButtonEmptyProps>;
	export type EuiButtonEmptyProps = ExclusiveUnion<EuiButtonEmptyPropsForAnchor, EuiButtonEmptyPropsForButton>;
	export const EuiButtonEmpty: FunctionComponent<EuiButtonEmptyProps>;
	export {};

}
declare module '@elastic/eui/src/components/button/button_empty' {
	export type { EuiButtonEmptyProps, EuiButtonEmptySizes } from '@elastic/eui/src/components/button/button_empty/button_empty';
	export { EuiButtonEmpty } from '@elastic/eui/src/components/button/button_empty/button_empty';

}
declare module '@elastic/eui/src/components/button/button_icon/button_icon.styles' {
	import { type SerializedStyles } from '@emotion/react';
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiButtonIconStyles: (euiThemeContext: UseEuiTheme) => {
	    euiButtonIcon: SerializedStyles;
	    isDisabled: SerializedStyles;
	    xs: SerializedStyles;
	    s: SerializedStyles;
	    m: SerializedStyles;
	};
	export const _emptyHoverStyles: (euiThemeContext: UseEuiTheme) => Record<"text" | "accent" | "primary" | "success" | "warning" | "danger", SerializedStyles>;

}
declare module '@elastic/eui/src/components/button/button_icon/button_icon' {
	import { AnchorHTMLAttributes, ButtonHTMLAttributes, FunctionComponent, Ref } from 'react';
	import { CommonProps, ExclusiveUnion, PropsForAnchor, PropsForButton } from '@elastic/eui/src/components/common';
	import { IconType, IconSize } from '@elastic/eui/src/components/icon';
	import { _EuiButtonColor } from '@elastic/eui/src/themes/amsterdam/global_styling/mixins/button';
	export const SIZES: readonly ["xs", "s", "m"];
	export type EuiButtonIconSizes = (typeof SIZES)[number];
	export const DISPLAYS: readonly ["base", "empty", "fill"]; type EuiButtonIconDisplay = (typeof DISPLAYS)[number];
	export interface EuiButtonIconProps extends CommonProps {
	    iconType: IconType;
	    /**
	     * Any of the named color palette options.
	     */
	    color?: _EuiButtonColor;
	    'aria-label'?: string;
	    'aria-labelledby'?: string;
	    isDisabled?: boolean;
	    /**
	     * Overall size of button.
	     * Matches the sizes of other EuiButtons
	     */
	    size?: EuiButtonIconSizes;
	    /**
	     * Size of the icon only.
	     * This will not affect the overall size of the button
	     */
	    iconSize?: IconSize;
	    /**
	     * Applies the boolean state as the `aria-pressed` property to create a toggle button.
	     * *Only use when the readable text does not change between states.*
	     */
	    isSelected?: boolean;
	    /**
	     * Sets the display style for matching other EuiButton types.
	     * `base` is equivalent to a typical EuiButton
	     * `fill` is equivalent to a filled EuiButton
	     * `empty` (default) is equivalent to an EuiButtonEmpty
	     */
	    display?: EuiButtonIconDisplay;
	    /**
	     * Disables the button and changes the icon to a loading spinner
	     */
	    isLoading?: boolean;
	}
	export type EuiButtonIconPropsForAnchor = {
	    type?: AnchorHTMLAttributes<HTMLAnchorElement>['type'];
	} & PropsForAnchor<EuiButtonIconProps, {
	    buttonRef?: Ref<HTMLAnchorElement>;
	}>;
	export type EuiButtonIconPropsForButton = {
	    type?: ButtonHTMLAttributes<HTMLButtonElement>['type'];
	} & PropsForButton<EuiButtonIconProps, {
	    buttonRef?: Ref<HTMLButtonElement>;
	}>; type Props = ExclusiveUnion<EuiButtonIconPropsForAnchor, EuiButtonIconPropsForButton>;
	export const EuiButtonIcon: FunctionComponent<Props>;
	export {};

}
declare module '@elastic/eui/src/components/button/button_icon' {
	export type { EuiButtonIconProps, EuiButtonIconPropsForButton, EuiButtonIconPropsForAnchor, } from '@elastic/eui/src/components/button/button_icon/button_icon';
	export { EuiButtonIcon } from '@elastic/eui/src/components/button/button_icon/button_icon';

}
declare module '@elastic/eui/src/themes/amsterdam' {
	export * from '@elastic/eui/src/themes/amsterdam/global_styling/mixins/shadow';

}
declare module '@elastic/eui/src/components/tool_tip/tool_tip.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiToolTipBackgroundColor: (euiTheme: UseEuiTheme['euiTheme'], colorMode: UseEuiTheme['colorMode']) => string;
	export const euiToolTipBorderColor: (euiTheme: UseEuiTheme['euiTheme'], colorMode: UseEuiTheme['colorMode']) => string;
	export const euiToolTipStyles: (euiThemeContext: UseEuiTheme) => {
	    euiToolTip: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    top: import("@emotion/utils").SerializedStyles;
	    bottom: import("@emotion/utils").SerializedStyles;
	    left: import("@emotion/utils").SerializedStyles;
	    right: import("@emotion/utils").SerializedStyles;
	    euiToolTip__arrow: import("@emotion/utils").SerializedStyles;
	    arrowPositions: {
	        top: import("@emotion/utils").SerializedStyles;
	        bottom: import("@emotion/utils").SerializedStyles;
	        left: import("@emotion/utils").SerializedStyles;
	        right: import("@emotion/utils").SerializedStyles;
	    };
	    euiToolTip__title: import("@emotion/utils").SerializedStyles;
	};
	export const euiToolTipAnchorStyles: () => {
	    euiToolTipAnchor: import("@emotion/utils").SerializedStyles;
	    block: import("@emotion/utils").SerializedStyles;
	    inlineBlock: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/tool_tip/tool_tip_popover' {
	import { HTMLAttributes, FunctionComponent, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type ToolTipPositions = 'top' | 'right' | 'bottom' | 'left'; type Props = CommonProps & Omit<HTMLAttributes<HTMLDivElement>, 'title'> & {
	    positionToolTip: () => void;
	    children?: ReactNode;
	    title?: ReactNode;
	    popoverRef?: (ref: HTMLDivElement) => void;
	    calculatedPosition?: ToolTipPositions;
	};
	export const EuiToolTipPopover: FunctionComponent<Props>;
	export {};

}
declare module '@elastic/eui/src/components/tool_tip/tool_tip_anchor' {
	import React, { HTMLAttributes } from 'react';
	import type { EuiToolTipProps } from '@elastic/eui/src/components/tool_tip/tool_tip';
	export type EuiToolTipAnchorProps = Omit<HTMLAttributes<HTMLSpanElement>, 'onBlur' | 'onFocus' | 'children'> & Required<Pick<EuiToolTipProps, 'display' | 'children'>> & {
	    onBlur: () => void;
	    onFocus: () => void;
	    isVisible: boolean;
	};
	export const EuiToolTipAnchor: React.ForwardRefExoticComponent<Omit<React.HTMLAttributes<HTMLSpanElement>, "children" | "onFocus" | "onBlur"> & Required<Pick<EuiToolTipProps, "children" | "display">> & {
	    onBlur: () => void;
	    onFocus: () => void;
	    isVisible: boolean;
	} & React.RefAttributes<HTMLSpanElement>>;

}
declare module '@elastic/eui/src/components/tool_tip/tool_tip_arrow' {
	import { HTMLAttributes, FunctionComponent } from 'react';
	import { ToolTipPositions } from '@elastic/eui/src/components/tool_tip/tool_tip_popover';
	export const EuiToolTipArrow: FunctionComponent<{
	    position: ToolTipPositions;
	} & HTMLAttributes<HTMLDivElement>>;

}
declare module '@elastic/eui/src/components/tool_tip/tool_tip_manager' {
	 class ToolTipManager {
	    toolTipsToHide: Set<Function>;
	    registerTooltip: (hideCallback: Function) => void;
	    deregisterToolTip: (hideCallback: Function) => void;
	}
	export const toolTipManager: ToolTipManager;
	export {};

}
declare module '@elastic/eui/src/components/tool_tip/tool_tip' {
	import React, { Component, ReactElement, ReactNode, MouseEvent as ReactMouseEvent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { ToolTipPositions } from '@elastic/eui/src/components/tool_tip/tool_tip_popover';
	export const POSITIONS: readonly ["top", "right", "bottom", "left"]; const DISPLAYS: readonly ["inlineBlock", "block"];
	export type ToolTipDelay = 'regular' | 'long';
	interface ToolTipStyles {
	    top: number;
	    left: number | 'auto';
	    right?: number | 'auto';
	    opacity?: number;
	    visibility?: 'hidden';
	}
	export interface EuiToolTipProps extends CommonProps {
	    /**
	     * Passes onto the span wrapping the trigger.
	     */
	    anchorClassName?: string;
	    /**
	     * Passes onto the span wrapping the trigger.
	     */
	    anchorProps?: CommonProps & HTMLAttributes<HTMLSpanElement>;
	    /**
	     * The in-view trigger for your tooltip.
	     */
	    children: ReactElement;
	    /**
	     * Passes onto the tooltip itself, not the trigger.
	     */
	    className?: string;
	    /**
	     * The main content of your tooltip.
	     */
	    content?: ReactNode;
	    /**
	     * Common display alternatives for the anchor wrapper
	     */
	    display?: (typeof DISPLAYS)[number];
	    /**
	     * Delay before showing tooltip. Good for repeatable items.
	     */
	    delay: ToolTipDelay;
	    /**
	     * An optional title for your tooltip.
	     */
	    title?: ReactNode;
	    /**
	     * Unless you provide one, this will be randomly generated.
	     */
	    id?: string;
	    /**
	     * Suggested position. If there is not enough room for it this will be changed.
	     */
	    position: ToolTipPositions;
	    /**
	     * When `true`, the tooltip's position is re-calculated when the user
	     * scrolls. This supports having fixed-position tooltip anchors.
	     *
	     * When nesting an `EuiTooltip` in a scrollable container, `repositionOnScroll` should be `true`
	     */
	    repositionOnScroll?: boolean;
	    /**
	     * If supplied, called when mouse movement causes the tool tip to be
	     * hidden.
	     */
	    onMouseOut?: (event: ReactMouseEvent<HTMLSpanElement, MouseEvent>) => void;
	}
	interface State {
	    visible: boolean;
	    hasFocus: boolean;
	    calculatedPosition: ToolTipPositions;
	    toolTipStyles: ToolTipStyles;
	    arrowStyles: undefined | {
	        left: number;
	        top: number;
	    };
	    id: string;
	}
	export class EuiToolTip extends Component<EuiToolTipProps, State> {
	    _isMounted: boolean;
	    anchor: null | HTMLElement;
	    popover: null | HTMLElement;
	    private timeoutId?;
	    state: State;
	    static defaultProps: Partial<EuiToolTipProps>;
	    clearAnimationTimeout: () => void;
	    componentDidMount(): void;
	    componentWillUnmount(): void;
	    componentDidUpdate(prevProps: EuiToolTipProps, prevState: State): void;
	    testAnchor: () => void;
	    setAnchorRef: (ref: HTMLElement) => HTMLElement;
	    setPopoverRef: (ref: HTMLElement) => HTMLElement;
	    showToolTip: () => void;
	    positionToolTip: () => void;
	    hideToolTip: () => void;
	    onFocus: () => void;
	    onBlur: () => void;
	    onEscapeKey: (event: React.KeyboardEvent<HTMLSpanElement>) => void;
	    onMouseOut: (event: ReactMouseEvent<HTMLSpanElement, MouseEvent>) => void;
	    render(): React.JSX.Element;
	}
	export {};

}
declare module '@elastic/eui/src/components/tool_tip/icon_tip' {
	import { FunctionComponent } from 'react';
	import { PropsOf } from '@elastic/eui/src/components/common';
	import { EuiIcon, IconSize, IconType } from '@elastic/eui/src/components/icon';
	import { EuiToolTipProps } from '@elastic/eui/src/components/tool_tip/tool_tip';
	export interface EuiIconTipProps {
	    /**
	     * Children are not allowed as they are built using the icon props
	     */
	    children?: never;
	    /**
	     * The icon color.
	     */
	    color?: string;
	    /**
	     * The icon type.
	     */
	    type?: IconType;
	    /**
	     * The icon size.
	     */
	    size?: IconSize;
	    /**
	     * Explain what this icon means for screen readers.
	     */
	    'aria-label'?: string;
	    /**
	     * Pass certain props down to `EuiIcon`
	     */
	    iconProps?: Omit<PropsOf<typeof EuiIcon>, 'type'> & {
	        type?: never;
	    };
	}
	export type Props = Omit<EuiToolTipProps, 'children' | 'delay' | 'position'> & EuiIconTipProps & {
	    delay?: EuiToolTipProps['delay'];
	    position?: EuiToolTipProps['position'];
	};
	export const EuiIconTip: FunctionComponent<Props>;

}
declare module '@elastic/eui/src/components/tool_tip' {
	export type { ToolTipPositions } from '@elastic/eui/src/components/tool_tip/tool_tip_popover';
	export type { EuiToolTipProps } from '@elastic/eui/src/components/tool_tip/tool_tip';
	export { EuiToolTip } from '@elastic/eui/src/components/tool_tip/tool_tip';
	export type { EuiIconTipProps } from '@elastic/eui/src/components/tool_tip/icon_tip';
	export { EuiIconTip } from '@elastic/eui/src/components/tool_tip/icon_tip';

}
declare module '@elastic/eui/src/components/form/form.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFormMaxWidth: ({ euiTheme }: UseEuiTheme) => string;
	export const euiFormVariables: (euiThemeContext: UseEuiTheme) => {
	    animationTiming: string;
	    controlLayoutGroupInputHeight: string;
	    controlLayoutGroupInputCompressedHeight: string;
	    controlLayoutGroupInputCompressedBorderRadius: import("csstype").Property.BorderRadius<string | number> | undefined;
	    controlIconSize: {
	        s: string;
	        m: string;
	        l: string;
	        xl: string;
	        xxl: string;
	    };
	    textColor: string;
	    backgroundColor: string;
	    backgroundDisabledColor: string;
	    backgroundReadOnlyColor: string;
	    borderColor: string;
	    controlDisabledColor: string;
	    controlBoxShadow: string;
	    controlPlaceholderText: string;
	    appendPrependBackground: string;
	    maxWidth: string;
	    controlHeight: string;
	    controlCompressedHeight: string;
	    controlPadding: string;
	    controlCompressedPadding: string;
	    controlBorderRadius: import("csstype").Property.BorderRadius<string | number> | undefined;
	    controlCompressedBorderRadius: import("csstype").Property.BorderRadius<string | number> | undefined;
	    iconAffordance: string;
	    iconCompressedAffordance: string;
	};
	export const euiFormControlStyles: (euiThemeContext: UseEuiTheme) => {
	    shared: string;
	    uncompressed: string;
	    compressed: string;
	    inGroup: string;
	    formWidth: string;
	    fullWidth: string;
	    invalid: string;
	    focus: string;
	    disabled: string;
	    readOnly: string;
	    autoFill: string;
	};
	export const euiFormControlText: (euiThemeContext: UseEuiTheme) => string;
	export const euiFormControlDefaultShadow: (euiThemeContext: UseEuiTheme, { withBorder, withBackground, withBackgroundColor, withBackgroundAnimation, }?: {
	    withBorder?: boolean | undefined;
	    withBackground?: boolean | undefined;
	    withBackgroundColor?: boolean | undefined;
	    withBackgroundAnimation?: boolean | undefined;
	}) => string;
	export const euiFormControlFocusStyles: ({ euiTheme, colorMode, }: UseEuiTheme) => string;
	export const euiFormControlInvalidStyles: ({ euiTheme }: UseEuiTheme) => string;
	export const euiFormControlDisabledStyles: (euiThemeContext: UseEuiTheme) => string;
	export const euiFormControlReadOnlyStyles: (euiThemeContext: UseEuiTheme) => string;
	export const euiFormControlAutoFillStyles: (euiThemeContext: UseEuiTheme) => string;
	/**
	 * Selection custom controls - checkboxes, radios, and switches
	 */
	export const euiFormCustomControlVariables: (euiThemeContext: UseEuiTheme) => {
	    sizes: {
	        control: string;
	        lineHeight: string;
	        labelGap: string;
	    };
	    colors: {
	        unselected: string;
	        unselectedBorder: string;
	        selected: string;
	        selectedIcon: string;
	        disabled: string;
	        disabledIcon: string;
	        disabledLabel: string;
	    };
	    animation: {
	        speed: import("csstype").Property.AnimationDuration<string & {}> | undefined;
	        easing: string;
	    };
	};
	export const euiFormCustomControlStyles: (euiThemeContext: UseEuiTheme) => {
	    wrapper: string;
	    input: {
	        fauxInput: string;
	        hasLabel: string;
	        enabled: {
	            selected: string;
	            unselected: string;
	        };
	        disabled: {
	            selected: string;
	            unselected: string;
	        };
	        icon: string;
	        hiddenInput: string;
	    };
	    label: {
	        label: string;
	        enabled: string;
	        disabled: string;
	    };
	};

}
declare module '@elastic/eui/src/components/button/button_group/button_group_button.styles' {
	import { type SerializedStyles } from '@emotion/react';
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiButtonGroupButtonStyles: (euiThemeContext: UseEuiTheme) => {
	    euiButtonGroupButton: SerializedStyles;
	    iconOnly: SerializedStyles;
	    uncompressed: {
	        uncompressed: SerializedStyles;
	        readonly borders: string;
	        readonly s: SerializedStyles;
	        readonly m: SerializedStyles;
	        hasToolTip: SerializedStyles;
	    };
	    compressed: SerializedStyles;
	    disabledAndSelected: SerializedStyles;
	    tooltipWrapper: SerializedStyles;
	    content: {
	        euiButtonGroupButton__content: SerializedStyles;
	        compressed: SerializedStyles;
	    };
	    text: {
	        euiButtonGroupButton__text: SerializedStyles;
	        euiButtonGroupButton__iconOnly: SerializedStyles;
	    };
	};
	export const _compressedButtonFocusColors: (euiThemeContext: UseEuiTheme) => Record<"text" | "accent" | "primary" | "success" | "warning" | "danger" | "disabled", SerializedStyles>;

}
declare module '@elastic/eui/src/components/button/button_group/button_group_button' {
	import { FunctionComponent, MouseEventHandler } from 'react';
	import { EuiButtonGroupOptionProps, EuiButtonGroupProps } from '@elastic/eui/src/components/button/button_group/button_group'; type Props = EuiButtonGroupOptionProps & {
	    /**
	     * Styles the selected button to look selected (usually with `fill`)
	     */
	    isSelected?: boolean;
	    /**
	     * Inherit from EuiButtonGroup
	     */
	    color: EuiButtonGroupProps['color'];
	    /**
	     * Inherit from EuiButtonGroup
	     */
	    size: NonNullable<EuiButtonGroupProps['buttonSize']>;
	    /**
	     * Inherit from EuiButtonGroup
	     */
	    isIconOnly: EuiButtonGroupProps['isIconOnly'];
	    /**
	     * Inherit from EuiButtonGroup
	     */
	    onClick: MouseEventHandler<HTMLButtonElement>;
	};
	export const EuiButtonGroupButton: FunctionComponent<Props>;
	export {};

}
declare module '@elastic/eui/src/components/button/button_group/button_group.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiButtonGroupStyles: {
	    euiButtonGroup: import("@emotion/utils").SerializedStyles;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	};
	export const euiButtonGroupButtonsStyles: (euiThemeContext: UseEuiTheme) => {
	    euiButtonGroup__buttons: import("@emotion/utils").SerializedStyles;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    compressed: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/button/button_group/button_group' {
	import { FunctionComponent, HTMLAttributes, ButtonHTMLAttributes, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { _EuiButtonColor } from '@elastic/eui/src/themes/amsterdam/global_styling/mixins';
	import { EuiToolTipProps } from '@elastic/eui/src/components/tool_tip';
	import { EuiButtonDisplayContentProps } from '@elastic/eui/src/components/button/button_display/_button_display_content';
	export interface EuiButtonGroupOptionProps extends EuiButtonDisplayContentProps, CommonProps {
	    /**
	     * Each option must have a unique `id` for maintaining selection
	     */
	    id: string;
	    /**
	     * Each option must have a `label` even for icons which will be applied as the `aria-label`
	     */
	    label: ReactNode;
	    isDisabled?: boolean;
	    /**
	     * The value of the radio input.
	     */
	    value?: any;
	    /**
	     * The type of the underlying HTML button
	     */
	    type?: ButtonHTMLAttributes<HTMLButtonElement>['type'];
	    /**
	     * By default, will use the button text for the native browser title.
	     *
	     * This can be either customized or unset via `title: ''` if necessary.
	     */
	    title?: ButtonHTMLAttributes<HTMLButtonElement>['title'];
	    /**
	     * Optional custom tooltip content for the button
	     */
	    toolTipContent?: EuiToolTipProps['content'];
	    /**
	     * Optional props to pass to the underlying **[EuiToolTip](/#/display/tooltip)**
	     */
	    toolTipProps?: Partial<Omit<EuiToolTipProps, 'content' | 'children'>>;
	}
	export type EuiButtonGroupProps = CommonProps & {
	    /**
	     * Typical sizing is `s`. Medium `m` size should be reserved for major features.
	     * `compressed` is meant to be used alongside and within compressed forms.
	     */
	    buttonSize?: 's' | 'm' | 'compressed';
	    isDisabled?: boolean;
	    /**
	     * Expands the whole group to the full width of the container.
	     * Each button gets equal widths no matter the content
	     */
	    isFullWidth?: boolean;
	    /**
	     * Hides the label to only show the `iconType` provided by the `option`
	     */
	    isIconOnly?: boolean;
	    /**
	     * A hidden group title (required for accessibility)
	     */
	    legend: string;
	    /**
	     * Any of the named color palette options.
	     */
	    color?: _EuiButtonColor;
	    /**
	     * Actual type is `'single' | 'multi'`.
	     * Determines how the selection of the group should be handled.
	     * With `'single'` only one option can be selected at a time (similar to radio group).
	     * With `'multi'` multiple options selected (similar to checkbox group).
	     */
	    type?: 'single' | 'multi';
	    /**
	     * An array of #EuiButtonGroupOptionProps
	     */
	    options: EuiButtonGroupOptionProps[];
	} & ({
	    /**
	     * Default for `type` is single so it can also be excluded
	     */
	    type?: 'single';
	    /**
	     * @deprecated No longer needed. You can safely remove this prop entirely
	     */
	    name?: string;
	    /**
	     * Styles the selected option to look selected (usually with `fill`)
	     * Required by and only used in `type='single'`.
	     */
	    idSelected: string;
	    /**
	     * Single: Returns the `id` of the clicked option and the `value`
	     */
	    onChange: (id: string, value?: any) => void;
	    idToSelectedMap?: never;
	} | {
	    type: 'multi';
	    /**
	     * A map of `id`s as keys with the selected boolean values.
	     * Required by and only used in `type='multi'`.
	     */
	    idToSelectedMap?: {
	        [id: string]: boolean;
	    };
	    /**
	     * Multi: Returns the `id` of the clicked option
	     */
	    onChange: (id: string) => void;
	    idSelected?: never;
	    /**
	     * @deprecated
	     */
	    name?: never;
	}); type Props = Omit<HTMLAttributes<HTMLFieldSetElement>, 'onChange' | 'color'> & EuiButtonGroupProps;
	export const EuiButtonGroup: FunctionComponent<Props>;
	export {};

}
declare module '@elastic/eui/src/components/button/button_group' {
	export type { EuiButtonGroupOptionProps, EuiButtonGroupProps, } from '@elastic/eui/src/components/button/button_group/button_group';
	export { EuiButtonGroup } from '@elastic/eui/src/components/button/button_group/button_group';

}
declare module '@elastic/eui/src/components/button' {
	export type { EuiButtonColor, EuiButtonSize, EuiButtonProps } from '@elastic/eui/src/components/button/button';
	export { COLORS, EuiButton } from '@elastic/eui/src/components/button/button';
	export type { EuiButtonEmptyProps, EuiButtonEmptySizes } from '@elastic/eui/src/components/button/button_empty';
	export { EuiButtonEmpty } from '@elastic/eui/src/components/button/button_empty';
	export type { EuiButtonIconProps, EuiButtonIconPropsForButton, } from '@elastic/eui/src/components/button/button_icon';
	export { EuiButtonIcon } from '@elastic/eui/src/components/button/button_icon';
	export type { EuiButtonGroupOptionProps, EuiButtonGroupProps, } from '@elastic/eui/src/components/button/button_group';
	export { EuiButtonGroup } from '@elastic/eui/src/components/button/button_group';

}
declare module '@elastic/eui/src/components/horizontal_rule/horizontal_rule.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiHorizontalRuleStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiHorizontalRule: import("@emotion/utils").SerializedStyles;
	    full: import("@emotion/utils").SerializedStyles;
	    half: import("@emotion/utils").SerializedStyles;
	    quarter: import("@emotion/utils").SerializedStyles;
	    none: string;
	    xs: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    xl: import("@emotion/utils").SerializedStyles;
	    xxl: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/horizontal_rule/horizontal_rule' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const SIZES: readonly ["full", "half", "quarter"];
	export const MARGINS: readonly ["none", "xs", "s", "m", "l", "xl", "xxl"];
	export type EuiHorizontalRuleSize = (typeof SIZES)[number];
	export type EuiHorizontalRuleMargin = (typeof MARGINS)[number];
	export interface EuiHorizontalRuleProps extends CommonProps, HTMLAttributes<HTMLHRElement> {
	    /**
	     * Defines the width of the HR.
	     */
	    size?: EuiHorizontalRuleSize;
	    margin?: EuiHorizontalRuleMargin;
	}
	export const EuiHorizontalRule: FunctionComponent<EuiHorizontalRuleProps>;

}
declare module '@elastic/eui/src/components/horizontal_rule' {
	export type { EuiHorizontalRuleProps } from '@elastic/eui/src/components/horizontal_rule/horizontal_rule';
	export { EuiHorizontalRule } from '@elastic/eui/src/components/horizontal_rule/horizontal_rule';

}
declare module '@elastic/eui/src/components/context_menu/context_menu_item.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiContextMenuItemStyles: (euiThemeContext: UseEuiTheme) => {
	    euiContextMenuItem: import("@emotion/utils").SerializedStyles;
	    disabled: import("@emotion/utils").SerializedStyles;
	    layoutAlign: {
	        center: import("@emotion/utils").SerializedStyles;
	        top: import("@emotion/utils").SerializedStyles;
	        bottom: import("@emotion/utils").SerializedStyles;
	    };
	    sizes: {
	        m: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	    };
	    euiContextMenu__icon: import("@emotion/utils").SerializedStyles;
	    text: {
	        euiContextMenuItem__text: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	    };
	    euiContextMenuItem__arrow: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/context_menu/context_menu_item' {
	import React, { PropsWithChildren, ButtonHTMLAttributes, FunctionComponent, ReactElement, ReactNode, Ref } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { type IconType } from '@elastic/eui/src/components/icon';
	import { EuiToolTipProps } from '@elastic/eui/src/components/tool_tip';
	export type EuiContextMenuItemIcon = IconType | ReactElement<any> | HTMLElement;
	export type EuiContextMenuItemLayoutAlignment = 'center' | 'top' | 'bottom';
	export const SIZES: readonly ["s", "m"];
	export interface EuiContextMenuItemProps extends PropsWithChildren, CommonProps {
	    icon?: EuiContextMenuItemIcon;
	    hasPanel?: boolean;
	    disabled?: boolean;
	    onClick?: (event: React.MouseEvent) => void;
	    buttonRef?: Ref<HTMLButtonElement>;
	    /**
	     * Required if using a tooltip. Add an optional tooltip on hover
	     */
	    toolTipContent?: ReactNode;
	    /**
	     * Optional configuration to pass to the underlying [EuiToolTip](/#/display/tooltip).
	     * Accepts any prop that EuiToolTip does, except for `content` and `children`.
	     */
	    toolTipProps?: Partial<Omit<EuiToolTipProps, 'content' | 'children'>>;
	    href?: string;
	    target?: string;
	    rel?: string;
	    /**
	     * How to align icon with content of button
	     */
	    layoutAlign?: EuiContextMenuItemLayoutAlignment;
	    /**
	     * Reduce the size to `s` when in need of a more compressed menu
	     */
	    size?: (typeof SIZES)[number];
	} type Props = CommonProps & Omit<ButtonHTMLAttributes<HTMLButtonElement>, 'type' | 'onClick' | 'disabled'> & EuiContextMenuItemProps;
	export const LAYOUT_ALIGN: EuiContextMenuItemLayoutAlignment[];
	export const EuiContextMenuItem: FunctionComponent<Props>;
	export {};

}
declare module '@elastic/eui/src/components/context_menu/context_menu.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiContextMenuVariables: ({ euiTheme }: UseEuiTheme) => {
	    panelWidth: string;
	};
	export const euiContextMenuStyles: (euiThemeContext: UseEuiTheme) => {
	    euiContextMenu: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/context_menu/context_menu_panel.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiContextMenuPanelStyles: (euiThemeContext: UseEuiTheme) => {
	    euiContextMenuPanel: import("@emotion/utils").SerializedStyles;
	    next: {
	        in: import("@emotion/utils").SerializedStyles;
	        out: import("@emotion/utils").SerializedStyles;
	    };
	    previous: {
	        in: import("@emotion/utils").SerializedStyles;
	        out: import("@emotion/utils").SerializedStyles;
	    };
	    euiContextMenuPanel__title: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/context_menu/context_menu_panel' {
	import React, { Component, HTMLAttributes, PropsWithChildren, ReactElement, ReactNode } from 'react';
	import { FocusableElement } from 'tabbable';
	import { WithEuiStylesMemoizerProps } from '@elastic/eui/src/services';
	import { CommonProps, NoArgCallback } from '@elastic/eui/src/components/common';
	export type EuiContextMenuPanelHeightChangeHandler = (height: number) => void;
	export type EuiContextMenuPanelTransitionType = 'in' | 'out';
	export type EuiContextMenuPanelTransitionDirection = 'next' | 'previous';
	export type EuiContextMenuPanelShowPanelCallback = (currentPanelIndex?: number) => void;
	export const SIZES: readonly ["s", "m"];
	export type EuiContextMenuPanelProps = PropsWithChildren & CommonProps & Omit<HTMLAttributes<HTMLDivElement>, 'onKeyDown' | 'tabIndex' | 'onAnimationEnd' | 'title'> & {
	    /**
	     * Determines the initially focused menu item for keyboard and screen reader users.
	     *
	     * Can be set to `-1` to prevent autofocus (an uncommon case that must have
	     * keyboard accessibility accounted for manually if used)
	     */
	    initialFocusedItemIndex?: number;
	    items?: ReactElement[];
	    onClose?: NoArgCallback<void>;
	    onHeightChange?: EuiContextMenuPanelHeightChangeHandler;
	    onTransitionComplete?: NoArgCallback<void>;
	    onUseKeyboardToNavigate?: NoArgCallback<void>;
	    showNextPanel?: EuiContextMenuPanelShowPanelCallback;
	    showPreviousPanel?: NoArgCallback<void>;
	    title?: ReactNode;
	    transitionDirection?: EuiContextMenuPanelTransitionDirection;
	    transitionType?: EuiContextMenuPanelTransitionType;
	    /**
	     * Alters the size of the items and the title
	     */
	    size?: (typeof SIZES)[number];
	}; type Props = EuiContextMenuPanelProps;
	interface State {
	    prevProps: {
	        items: Props['items'];
	    };
	    menuItems: FocusableElement[];
	    focusedItemIndex?: number;
	    currentHeight?: number;
	    height?: number;
	    waitingForInitialPopover: boolean;
	    tookInitialFocus: boolean;
	}
	export class EuiContextMenuPanelClass extends Component<WithEuiStylesMemoizerProps & Props, State> {
	    static defaultProps: Partial<Props>;
	    private _isMounted;
	    private backButton?;
	    private panel?;
	    private initialPopoverParent?;
	    constructor(props: WithEuiStylesMemoizerProps & Props);
	    findMenuItems: () => void;
	    focusMenuItem: (direction: 'up' | 'down') => void;
	    onKeyDown: (event: React.KeyboardEvent<HTMLDivElement>) => void;
	    takeInitialFocus(): void;
	    reclaimPopoverFocus: () => void;
	    onTransitionComplete: () => void;
	    componentDidUpdate(_: Props, prevState: State): void;
	    componentDidMount(): void;
	    componentWillUnmount(): void;
	    static getDerivedStateFromProps(nextProps: Props, prevState: State): Partial<State> | null;
	    updateHeight(): void;
	    getInitialPopoverParent(): void;
	    panelRef: (node: HTMLElement | null) => void;
	    render(): React.JSX.Element;
	}
	export const EuiContextMenuPanel: React.ForwardRefExoticComponent<Omit<EuiContextMenuPanelProps, "stylesMemoizer"> & React.RefAttributes<Omit<EuiContextMenuPanelProps, "stylesMemoizer">>>;
	export {};

}
declare module '@elastic/eui/src/components/context_menu/context_menu' {
	import React, { Component, HTMLAttributes, CSSProperties, ReactElement, ReactNode } from 'react';
	import { WithEuiStylesMemoizerProps } from '@elastic/eui/src/services';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	import { EuiHorizontalRuleProps } from '@elastic/eui/src/components/horizontal_rule';
	import { EuiContextMenuPanelTransitionDirection, EuiContextMenuPanelTransitionType } from '@elastic/eui/src/components/context_menu/context_menu_panel';
	import { EuiContextMenuItemProps } from '@elastic/eui/src/components/context_menu/context_menu_item';
	export type EuiContextMenuPanelId = string | number;
	export type EuiContextMenuPanelItemDescriptorEntry = Omit<EuiContextMenuItemProps, 'hasPanel'> & {
	    name: React.ReactNode;
	    key?: string;
	    panel?: EuiContextMenuPanelId;
	};
	export interface EuiContextMenuPanelItemSeparator extends EuiHorizontalRuleProps {
	    isSeparator: true;
	    key?: string;
	}
	export type EuiContextMenuPanelItemRenderCustom = {
	    /**
	     * Allows rendering any custom content alongside your array of context menu items.
	     * Accepts either a component or an inline function component that returns any JSX.
	     */
	    renderItem: (() => ReactNode) | Function;
	    key?: string;
	};
	export type EuiContextMenuPanelItemDescriptor = ExclusiveUnion<ExclusiveUnion<EuiContextMenuPanelItemDescriptorEntry, EuiContextMenuPanelItemSeparator>, EuiContextMenuPanelItemRenderCustom>;
	export interface EuiContextMenuPanelDescriptor {
	    id: EuiContextMenuPanelId;
	    title?: ReactNode;
	    items?: EuiContextMenuPanelItemDescriptor[];
	    content?: ReactNode;
	    width?: CSSProperties['width'];
	    initialFocusedItemIndex?: number;
	    /**
	     * Alters the size of the items and the title
	     */
	    size?: (typeof SIZES)[number];
	}
	export const SIZES: readonly ["s", "m"];
	export type EuiContextMenuProps = CommonProps & Omit<HTMLAttributes<HTMLDivElement>, 'style'> & {
	    panels?: EuiContextMenuPanelDescriptor[];
	    /**
	     * Optional callback that fires on every panel change. Passes back
	     * the new panel ID and whether its direction was `next` or `previous`.
	     */
	    onPanelChange?: (panelDetails: {
	        panelId: EuiContextMenuPanelId;
	        direction?: EuiContextMenuPanelTransitionDirection;
	    }) => void;
	    initialPanelId?: EuiContextMenuPanelId;
	    /**
	     * Alters the size of the items and the title
	     */
	    size?: (typeof SIZES)[number];
	};
	interface State {
	    prevProps: {
	        panels?: EuiContextMenuPanelDescriptor[];
	    };
	    idToPanelMap: {
	        [id: string]: EuiContextMenuPanelDescriptor;
	    };
	    idToPreviousPanelIdMap: {
	        [panel: string]: EuiContextMenuPanelId;
	    };
	    idAndItemIndexToPanelIdMap: {
	        [id: string]: {
	            [index: string]: EuiContextMenuPanelId;
	        };
	    };
	    idToRenderedItemsMap: {
	        [id: string]: ReactElement[];
	    };
	    height?: number;
	    outgoingPanelId?: EuiContextMenuPanelId;
	    incomingPanelId?: EuiContextMenuPanelId;
	    transitionDirection?: EuiContextMenuPanelTransitionDirection;
	    isOutgoingPanelVisible: boolean;
	    focusedItemIndex?: number;
	    isUsingKeyboardToNavigate: boolean;
	}
	export class EuiContextMenuClass extends Component<WithEuiStylesMemoizerProps & EuiContextMenuProps, State> {
	    static defaultProps: Partial<EuiContextMenuProps>;
	    static getDerivedStateFromProps(nextProps: EuiContextMenuProps, prevState: State): Partial<State> | null;
	    constructor(props: WithEuiStylesMemoizerProps & EuiContextMenuProps);
	    componentDidUpdate(prevProps: EuiContextMenuProps): void;
	    hasPreviousPanel: (panelId: EuiContextMenuPanelId) => boolean;
	    showPanel(panelId: EuiContextMenuPanelId, direction?: EuiContextMenuPanelTransitionDirection): void;
	    showNextPanel: (itemIndex?: number | undefined) => void;
	    showPreviousPanel: () => void;
	    onIncomingPanelHeightChange: (height: number) => void;
	    onOutGoingPanelTransitionComplete: () => void;
	    onUseKeyboardToNavigate: () => void;
	    mapIdsToRenderedItems: (panels?: EuiContextMenuPanelDescriptor[]) => {
	        [id: string]: React.ReactElement<any, string | React.JSXElementConstructor<any>>[];
	    };
	    renderItems(items?: EuiContextMenuPanelItemDescriptor[]): React.JSX.Element[];
	    renderPanel(panelId: EuiContextMenuPanelId, transitionType: EuiContextMenuPanelTransitionType): React.JSX.Element | undefined;
	    render(): React.JSX.Element;
	}
	export const EuiContextMenu: React.ForwardRefExoticComponent<Omit<EuiContextMenuProps, "stylesMemoizer"> & React.RefAttributes<Omit<EuiContextMenuProps, "stylesMemoizer">>>;
	export {};

}
declare module '@elastic/eui/src/components/context_menu' {
	export type { EuiContextMenuProps, EuiContextMenuPanelDescriptor, EuiContextMenuPanelItemDescriptor, } from '@elastic/eui/src/components/context_menu/context_menu';
	export { EuiContextMenu } from '@elastic/eui/src/components/context_menu/context_menu';
	export type { EuiContextMenuPanelProps } from '@elastic/eui/src/components/context_menu/context_menu_panel';
	export { EuiContextMenuPanel } from '@elastic/eui/src/components/context_menu/context_menu_panel';
	export type { EuiContextMenuItemProps, EuiContextMenuItemIcon, EuiContextMenuItemLayoutAlignment, } from '@elastic/eui/src/components/context_menu/context_menu_item';
	export { EuiContextMenuItem } from '@elastic/eui/src/components/context_menu/context_menu_item';

}
declare module '@elastic/eui/src/components/flex/flex_group.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFlexGroupStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFlexGroup: import("@emotion/utils").SerializedStyles;
	    responsive: import("@emotion/utils").SerializedStyles;
	    wrap: import("@emotion/utils").SerializedStyles;
	    gutterSizes: {
	        none: import("@emotion/utils").SerializedStyles;
	        xs: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	        l: import("@emotion/utils").SerializedStyles;
	        xl: import("@emotion/utils").SerializedStyles;
	    };
	    justifyContent: {
	        flexStart: import("@emotion/utils").SerializedStyles;
	        flexEnd: import("@emotion/utils").SerializedStyles;
	        spaceEvenly: import("@emotion/utils").SerializedStyles;
	        spaceBetween: import("@emotion/utils").SerializedStyles;
	        spaceAround: import("@emotion/utils").SerializedStyles;
	        center: import("@emotion/utils").SerializedStyles;
	    };
	    alignItems: {
	        stretch: import("@emotion/utils").SerializedStyles;
	        flexStart: import("@emotion/utils").SerializedStyles;
	        flexEnd: import("@emotion/utils").SerializedStyles;
	        center: import("@emotion/utils").SerializedStyles;
	        baseline: import("@emotion/utils").SerializedStyles;
	    };
	    direction: {
	        row: import("@emotion/utils").SerializedStyles;
	        rowReverse: import("@emotion/utils").SerializedStyles;
	        column: import("@emotion/utils").SerializedStyles;
	        columnReverse: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/flex/flex_group' {
	import React, { ComponentPropsWithoutRef, ElementType, PropsWithChildren, ReactElement, Ref } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const GUTTER_SIZES: readonly ["none", "xs", "s", "m", "l", "xl"];
	export type EuiFlexGroupGutterSize = (typeof GUTTER_SIZES)[number];
	export const ALIGN_ITEMS: readonly ["stretch", "flexStart", "flexEnd", "center", "baseline"];
	export type FlexGroupAlignItems = (typeof ALIGN_ITEMS)[number];
	export const JUSTIFY_CONTENTS: readonly ["flexStart", "flexEnd", "center", "spaceBetween", "spaceAround", "spaceEvenly"]; type FlexGroupJustifyContent = (typeof JUSTIFY_CONTENTS)[number];
	export const DIRECTIONS: readonly ["row", "rowReverse", "column", "columnReverse"]; type FlexGroupDirection = (typeof DIRECTIONS)[number];
	export type EuiFlexGroupProps<TComponent extends ElementType = 'div'> = PropsWithChildren & CommonProps & ComponentPropsWithoutRef<TComponent> & {
	    alignItems?: FlexGroupAlignItems;
	    /**
	     * Customize the component type that is rendered.
	     *
	     * It can be any valid React component type like a tag name string
	     * such as `'div'` or `'span'`, a React component (a function, a class,
	     * or an exotic component like `memo()`).
	     *
	     * `EuiFlexGroup` accepts and forwards all extra props to the custom
	     * component.
	     *
	     * @default "div"
	     */
	    component?: TComponent;
	    direction?: FlexGroupDirection;
	    gutterSize?: EuiFlexGroupGutterSize;
	    justifyContent?: FlexGroupJustifyContent;
	    responsive?: boolean;
	    wrap?: boolean;
	};
	export const EuiFlexGroup: (<TComponent extends React.ElementType = "div", TComponentRef = React.ReactElement<any, TComponent>>(props: {
	    children?: React.ReactNode;
	} & CommonProps & React.PropsWithoutRef<React.ComponentProps<TComponent>> & {
	    alignItems?: "center" | "stretch" | "baseline" | "flexStart" | "flexEnd" | undefined;
	    /**
	     * Customize the component type that is rendered.
	     *
	     * It can be any valid React component type like a tag name string
	     * such as `'div'` or `'span'`, a React component (a function, a class,
	     * or an exotic component like `memo()`).
	     *
	     * `EuiFlexGroup` accepts and forwards all extra props to the custom
	     * component.
	     *
	     * @default "div"
	     */
	    component?: TComponent | undefined;
	    direction?: "column" | "row" | "rowReverse" | "columnReverse" | undefined;
	    gutterSize?: "xs" | "s" | "m" | "l" | "xl" | "none" | undefined;
	    justifyContent?: "center" | "flexStart" | "flexEnd" | "spaceBetween" | "spaceAround" | "spaceEvenly" | undefined;
	    responsive?: boolean | undefined;
	    wrap?: boolean | undefined;
	} & {
	    ref?: React.Ref<TComponentRef> | undefined;
	}) => ReactElement) & {
	    displayName?: string | undefined;
	};
	export {};

}
declare module '@elastic/eui/src/components/flex/flex_grid.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFlexGridStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFlexGrid: import("@emotion/utils").SerializedStyles;
	    responsive: import("@emotion/utils").SerializedStyles;
	    direction: {
	        row: import("@emotion/utils").SerializedStyles;
	        column: import("@emotion/utils").SerializedStyles;
	    };
	    columnCount: {
	        '1': import("@emotion/utils").SerializedStyles;
	        '2': import("@emotion/utils").SerializedStyles;
	        '3': import("@emotion/utils").SerializedStyles;
	        '4': import("@emotion/utils").SerializedStyles;
	    };
	    gutterSizes: {
	        none: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	        l: import("@emotion/utils").SerializedStyles;
	        xl: import("@emotion/utils").SerializedStyles;
	    };
	    alignItems: {
	        stretch: import("@emotion/utils").SerializedStyles;
	        start: import("@emotion/utils").SerializedStyles;
	        end: import("@emotion/utils").SerializedStyles;
	        center: import("@emotion/utils").SerializedStyles;
	        baseline: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/flex/flex_grid' {
	import { HTMLAttributes, ReactNode, FunctionComponent, ElementType } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const DIRECTIONS: readonly ["row", "column"];
	export type FlexGridDirection = (typeof DIRECTIONS)[number];
	export const ALIGN_ITEMS: readonly ["stretch", "start", "end", "center", "baseline"];
	export type FlexGridAlignItems = (typeof ALIGN_ITEMS)[number];
	export const GUTTER_SIZES: readonly ["none", "s", "m", "l", "xl"];
	export type FlexGridGutterSize = (typeof GUTTER_SIZES)[number];
	export interface EuiFlexGridProps {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children?: ReactNode;
	    /**
	     * Number of columns. Accepts `1-4`
	     */
	    columns?: 1 | 2 | 3 | 4;
	    /**
	     * Flex layouts default to left-right then top-down (`row`).
	     * Change this prop to `column` to create a top-down then left-right display.
	     */
	    direction?: FlexGridDirection;
	    /**
	     * Aligns grid items vertically
	     */
	    alignItems?: FlexGridAlignItems;
	    /**
	     * Space between flex items
	     */
	    gutterSize?: FlexGridGutterSize;
	    /**
	     * Will display each item at full-width on smaller screens
	     */
	    responsive?: boolean;
	    /**
	     * The tag to render
	     * @default div
	     */
	    component?: ElementType;
	}
	export const EuiFlexGrid: FunctionComponent<CommonProps & HTMLAttributes<HTMLDivElement> & EuiFlexGridProps>;

}
declare module '@elastic/eui/src/components/flex/flex_item.styles' {
	export const euiFlexItemStyles: {
	    euiFlexItem: import("@emotion/utils").SerializedStyles;
	    growZero: import("@emotion/utils").SerializedStyles;
	    grow: import("@emotion/utils").SerializedStyles;
	    growSizes: {
	        '1': import("@emotion/utils").SerializedStyles;
	        '2': import("@emotion/utils").SerializedStyles;
	        '3': import("@emotion/utils").SerializedStyles;
	        '4': import("@emotion/utils").SerializedStyles;
	        '5': import("@emotion/utils").SerializedStyles;
	        '6': import("@emotion/utils").SerializedStyles;
	        '7': import("@emotion/utils").SerializedStyles;
	        '8': import("@emotion/utils").SerializedStyles;
	        '9': import("@emotion/utils").SerializedStyles;
	        '10': import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/flex/flex_item' {
	import React, { ElementType, ComponentPropsWithoutRef, PropsWithChildren, Ref, ReactElement } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiFlexItemProps<TComponent extends ElementType = 'div'> = PropsWithChildren & CommonProps & ComponentPropsWithoutRef<TComponent> & {
	    grow?: boolean | 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | null;
	    /**
	     * Customize the component type that is rendered.
	     *
	     * It can be any valid React component type like a tag name string
	     * such as `'div'` or `'span'`, a React component (a function, a class,
	     * or an exotic component like `memo()`).
	     *
	     * `<EuiFlexItem>` accepts and forwards all extra props to the custom
	     * component.
	     *
	     * @example
	     * // Renders a <button> element
	     * <EuiFlexItem component="button">
	     *   Submit form
	     * </EuiFlexItem>
	     * @default "div"
	     */
	    component?: TComponent;
	};
	export const EuiFlexItem: (<TComponent extends React.ElementType, TComponentRef = React.ReactElement<any, TComponent>>(props: {
	    children?: React.ReactNode;
	} & CommonProps & React.PropsWithoutRef<React.ComponentProps<TComponent>> & {
	    grow?: boolean | 0 | 5 | 2 | 10 | 3 | 8 | 9 | 1 | 4 | 6 | 7 | null | undefined;
	    /**
	     * Customize the component type that is rendered.
	     *
	     * It can be any valid React component type like a tag name string
	     * such as `'div'` or `'span'`, a React component (a function, a class,
	     * or an exotic component like `memo()`).
	     *
	     * `<EuiFlexItem>` accepts and forwards all extra props to the custom
	     * component.
	     *
	     * @example
	     * // Renders a <button> element
	     * <EuiFlexItem component="button">
	     *   Submit form
	     * </EuiFlexItem>
	     * @default "div"
	     */
	    component?: TComponent | undefined;
	} & {
	    ref?: React.Ref<TComponentRef> | undefined;
	}) => ReactElement) & {
	    displayName?: string | undefined;
	};

}
declare module '@elastic/eui/src/components/flex' {
	export type { EuiFlexGroupProps, EuiFlexGroupGutterSize } from '@elastic/eui/src/components/flex/flex_group';
	export { EuiFlexGroup } from '@elastic/eui/src/components/flex/flex_group';
	export type { EuiFlexGridProps } from '@elastic/eui/src/components/flex/flex_grid';
	export { EuiFlexGrid } from '@elastic/eui/src/components/flex/flex_grid';
	export type { EuiFlexItemProps } from '@elastic/eui/src/components/flex/flex_item';
	export { EuiFlexItem } from '@elastic/eui/src/components/flex/flex_item';

}
declare module '@elastic/eui/src/components/pagination/pagination_button.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiPaginationButtonStyles: (euiThemeContext: UseEuiTheme) => {
	    euiPaginationButton: import("@emotion/utils").SerializedStyles;
	    isActive: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/pagination/pagination_button' {
	import { FunctionComponent } from 'react';
	import { ExclusiveUnion, PropsForAnchor, PropsForButton } from '@elastic/eui/src/components/common';
	import { EuiButtonEmptyProps } from '@elastic/eui/src/components/button';
	export type EuiPaginationButtonProps = EuiButtonEmptyProps & {
	    isActive?: boolean;
	    pageIndex: number;
	    totalPages?: number;
	}; type EuiPaginationButtonPropsForAnchor = PropsForAnchor<EuiPaginationButtonProps>; type EuiPaginationButtonPropsForButton = PropsForButton<EuiPaginationButtonProps>; type Props = ExclusiveUnion<EuiPaginationButtonPropsForAnchor, EuiPaginationButtonPropsForButton>;
	export const EuiPaginationButton: FunctionComponent<Props>;
	export {};

}
declare module '@elastic/eui/src/components/pagination/pagination_button_arrow' {
	import { FunctionComponent } from 'react';
	import { EuiButtonIconPropsForAnchor } from '@elastic/eui/src/components/button/button_icon';
	export const TYPES: ("first" | "last" | "next" | "previous")[];
	export type EuiPaginationButtonArrowType = (typeof TYPES)[number];
	export type Props = Partial<Omit<EuiButtonIconPropsForAnchor, 'type'>> & {
	    type: EuiPaginationButtonArrowType;
	    disabled?: boolean;
	    ariaControls?: string;
	};
	export const EuiPaginationButtonArrow: FunctionComponent<Props>;

}
declare module '@elastic/eui/src/components/pagination/pagination.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiPaginationStyles: (euiThemeContext: UseEuiTheme) => {
	    euiPagination: import("@emotion/utils").SerializedStyles;
	    euiPagination__compressedText: import("@emotion/utils").SerializedStyles;
	    euiPagination__list: import("@emotion/utils").SerializedStyles;
	    euiPagination__ellipsis: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/pagination/pagination' {
	import { FunctionComponent, HTMLAttributes, MouseEvent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiBreakpointSize } from '@elastic/eui/src/services';
	export type PageClickHandler = (pageIndex: number) => void;
	export type SafeClickHandler = (e: MouseEvent, pageIndex: number) => void;
	export interface EuiPaginationProps {
	    /**
	     * The total number of pages.
	     * Pass `0` if total count is unknown.
	     */
	    pageCount?: number;
	    /**
	     * The current page using a zero based index.
	     * So if you set the activePage to 1, it will activate the second page.
	     * Pass `-1` for forcing to last page.
	     */
	    activePage?: number;
	    /**
	     * Click handler that passes back the internally calculated `activePage` index
	     */
	    onPageClick?: (pageIndex: number) => void;
	    /**
	     * If true, will only show next/prev arrows and simplified number set.
	     */
	    compressed?: boolean;
	    /**
	     * If passed in, passes value through to each button to set aria-controls.
	     */
	    'aria-controls'?: string;
	    /**
	     * Automatically reduces to the `compressed` version on smaller screens.
	     * Remove completely with `false` or provide your own list of responsive breakpoints.
	     */
	    responsive?: false | EuiBreakpointSize[];
	} type Props = CommonProps & HTMLAttributes<HTMLDivElement> & EuiPaginationProps;
	export const EuiPagination: FunctionComponent<Props>;
	export {};

}
declare module '@elastic/eui/src/components/pagination' {
	export type { EuiPaginationProps } from '@elastic/eui/src/components/pagination/pagination';
	export { EuiPagination } from '@elastic/eui/src/components/pagination/pagination';
	export type { EuiPaginationButtonProps } from '@elastic/eui/src/components/pagination/pagination_button';
	export { EuiPaginationButton } from '@elastic/eui/src/components/pagination/pagination_button';

}
declare module '@elastic/eui/src/components/table/table_pagination/table_pagination_defaults' {
	import { EuiTablePaginationProps } from '@elastic/eui/src/components/table/table_pagination/table_pagination';
	/**
	 * Table pagination prop defaults live in a separate file because
	 * they'll be reused by basic tables and datagrids as fallbacks
	 */
	export const euiTablePaginationDefaults: Required<Pick<EuiTablePaginationProps, 'itemsPerPage' | 'itemsPerPageOptions' | 'showPerPageOptions'>>;
	export const useEuiTablePaginationDefaults: () => {
	    itemsPerPage: number;
	    itemsPerPageOptions: number[];
	    showPerPageOptions: boolean;
	};

}
declare module '@elastic/eui/src/components/table/table_pagination/table_pagination' {
	import { FunctionComponent } from 'react';
	import { EuiPaginationProps } from '@elastic/eui/src/components/pagination';
	export type PageChangeHandler = EuiPaginationProps['onPageClick'];
	export type ItemsPerPageChangeHandler = (pageSize: number) => void;
	export interface EuiTablePaginationProps extends Omit<EuiPaginationProps, 'onPageClick'> {
	    /**
	     * Option to completely hide the "Rows per page" selector.
	     *
	     * @default true
	     */
	    showPerPageOptions?: boolean;
	    /**
	     * Current selection for "Rows per page".
	     * Pass `0` to display the selected "Show all" option and hide the pagination.
	     *
	     * @default 10
	     */
	    itemsPerPage?: number;
	    /**
	     * Custom array of options for "Rows per page".
	     * Pass `0` as one of the options to create a "Show all" option.
	     *
	     * @default [10, 25, 50]
	     */
	    itemsPerPageOptions?: number[];
	    /**
	     * Click handler that passes back selected `pageSize` number
	     */
	    onChangeItemsPerPage?: ItemsPerPageChangeHandler;
	    onChangePage?: PageChangeHandler;
	    /**
	     * Requires the `id` of the table being controlled
	     */
	    'aria-controls'?: string;
	    'aria-label'?: string;
	}
	export const EuiTablePagination: FunctionComponent<EuiTablePaginationProps>;

}
declare module '@elastic/eui/src/components/table/table_pagination' {
	export type { EuiTablePaginationProps } from '@elastic/eui/src/components/table/table_pagination/table_pagination';
	export { EuiTablePagination } from '@elastic/eui/src/components/table/table_pagination/table_pagination';
	export { useEuiTablePaginationDefaults, euiTablePaginationDefaults, } from '@elastic/eui/src/components/table/table_pagination/table_pagination_defaults';

}
declare module '@elastic/eui/src/components/table/mobile/table_header_mobile.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiTableHeaderMobileStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiTableHeaderMobile: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/table/mobile/table_header_mobile' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import type { EuiTableProps } from '@elastic/eui/src/components/table/table';
	export const EuiTableHeaderMobile: FunctionComponent<CommonProps & HTMLAttributes<HTMLDivElement> & Pick<EuiTableProps, 'responsiveBreakpoint'>>;

}
declare module '@elastic/eui/src/components/table/mobile/table_sort_mobile_item' {
	import { FunctionComponent, PropsWithChildren } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export interface EuiTableSortMobileItemProps extends PropsWithChildren, CommonProps {
	    /**
	     * Callback to know when an item has been clicked
	     */
	    onSort?: () => void;
	    /**
	     * Indicates current option is the sorted on column
	     */
	    isSorted?: boolean;
	    /**
	     * Indicates which direction the current column is sorted on
	     */
	    isSortAscending?: boolean;
	    ariaLabel?: string;
	}
	export const EuiTableSortMobileItem: FunctionComponent<EuiTableSortMobileItemProps>;

}
declare module '@elastic/eui/src/components/table/mobile/table_sort_mobile' {
	import React, { Component, ReactNode, Key } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { PopoverAnchorPosition } from '@elastic/eui/src/components/popover';
	interface ItemProps {
	    name: ReactNode;
	    key?: Key;
	    onSort?: () => void;
	    isSorted?: boolean;
	    isSortAscending?: boolean;
	}
	export interface EuiTableSortMobileProps extends CommonProps {
	    anchorPosition?: PopoverAnchorPosition;
	    items?: ItemProps[];
	}
	interface State {
	    isPopoverOpen: boolean;
	}
	export class EuiTableSortMobile extends Component<EuiTableSortMobileProps, State> {
	    state: {
	        isPopoverOpen: boolean;
	    };
	    onButtonClick: () => void;
	    closePopover: () => void;
	    euiTableSortMobileStyles: {
	        marginInlineStart: string;
	        label: string;
	    };
	    render(): React.JSX.Element;
	}
	export {};

}
declare module '@elastic/eui/src/components/table/table_row.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiTableRowStyles: (euiThemeContext: UseEuiTheme) => {
	    euiTableRow: import("@emotion/utils").SerializedStyles;
	    desktop: {
	        desktop: import("@emotion/utils").SerializedStyles;
	        expanded: import("@emotion/utils").SerializedStyles;
	        clickable: import("@emotion/utils").SerializedStyles;
	        selected: import("@emotion/utils").SerializedStyles;
	        checkboxOffset: import("@emotion/utils").SerializedStyles;
	    };
	    mobile: {
	        mobile: import("@emotion/utils").SerializedStyles;
	        selected: import("@emotion/utils").SerializedStyles;
	        /**
	         * Left column offset (no border)
	         * Used for selection checkbox, which will be absolutely positioned
	         */
	        hasLeftColumn: import("@emotion/utils").SerializedStyles;
	        /**
	         * Right column styles + border
	         * Used for cell actions and row expander arrow
	         */
	        hasRightColumn: import("@emotion/utils").SerializedStyles;
	        /**
	         * Bottom of card - expanded rows
	         */
	        expanded: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/table/table_row' {
	import { FunctionComponent, HTMLAttributes, KeyboardEventHandler, MouseEventHandler } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export interface EuiTableRowProps {
	    /**
	     * Indicates if the table has a single column of checkboxes for selecting
	     * rows (used for mobile styling)
	     */
	    hasSelection?: boolean;
	    /**
	     * Indicates that the current row's checkbox is selectable / not disabled
	     */
	    isSelectable?: boolean;
	    /**
	     * Indicates the current row has been selected
	     */
	    isSelected?: boolean;
	    /**
	     * Indicates if the table has a dedicated column for actions
	     * (used for mobile styling and desktop action hover behavior)
	     */
	    hasActions?: boolean | 'custom';
	    /**
	     * Indicates if the row will have an expanded row
	     */
	    isExpandable?: boolean;
	    /**
	     * Indicates if the row will be the expanded row
	     */
	    isExpandedRow?: boolean;
	    onClick?: MouseEventHandler<HTMLTableRowElement> & KeyboardEventHandler<HTMLTableRowElement>;
	} type Props = CommonProps & HTMLAttributes<HTMLTableRowElement> & EuiTableRowProps;
	export const EuiTableRow: FunctionComponent<Props>;
	export {};

}
declare module '@elastic/eui/src/components/table/table_row_cell_checkbox' {
	import { FunctionComponent, TdHTMLAttributes, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const EuiTableRowCellCheckbox: FunctionComponent<CommonProps & TdHTMLAttributes<HTMLTableCellElement> & {
	    append?: ReactNode;
	}>;

}
declare module '@elastic/eui/src/components/table' {
	export type { EuiTableProps } from '@elastic/eui/src/components/table/table';
	export { EuiTable } from '@elastic/eui/src/components/table/table';
	export type { EuiTableBodyProps } from '@elastic/eui/src/components/table/table_body';
	export { EuiTableBody } from '@elastic/eui/src/components/table/table_body';
	export { EuiTableFooter } from '@elastic/eui/src/components/table/table_footer';
	export type { EuiTableFooterCellProps } from '@elastic/eui/src/components/table/table_footer_cell';
	export { EuiTableFooterCell } from '@elastic/eui/src/components/table/table_footer_cell';
	export type { EuiTableHeaderProps } from '@elastic/eui/src/components/table/table_header';
	export { EuiTableHeader } from '@elastic/eui/src/components/table/table_header';
	export type { EuiTableHeaderCellProps } from '@elastic/eui/src/components/table/table_header_cell';
	export { EuiTableHeaderCell } from '@elastic/eui/src/components/table/table_header_cell';
	export type { EuiTableHeaderCellCheckboxProps } from '@elastic/eui/src/components/table/table_header_cell_checkbox';
	export { EuiTableHeaderCellCheckbox } from '@elastic/eui/src/components/table/table_header_cell_checkbox';
	export type { EuiTablePaginationProps } from '@elastic/eui/src/components/table/table_pagination';
	export { EuiTablePagination } from '@elastic/eui/src/components/table/table_pagination';
	export { EuiTableHeaderMobile } from '@elastic/eui/src/components/table/mobile/table_header_mobile';
	export type { EuiTableSortMobileProps } from '@elastic/eui/src/components/table/mobile/table_sort_mobile';
	export { EuiTableSortMobile } from '@elastic/eui/src/components/table/mobile/table_sort_mobile';
	export type { EuiTableSortMobileItemProps } from '@elastic/eui/src/components/table/mobile/table_sort_mobile_item';
	export { EuiTableSortMobileItem } from '@elastic/eui/src/components/table/mobile/table_sort_mobile_item';
	export type { EuiTableRowProps } from '@elastic/eui/src/components/table/table_row';
	export { EuiTableRow } from '@elastic/eui/src/components/table/table_row';
	export type { EuiTableRowCellProps } from '@elastic/eui/src/components/table/table_row_cell';
	export { EuiTableRowCell } from '@elastic/eui/src/components/table/table_row_cell';
	export { EuiTableRowCellCheckbox } from '@elastic/eui/src/components/table/table_row_cell_checkbox';

}
declare module '@elastic/eui/src/components/provider/component_defaults/component_defaults' {
	import React, { FunctionComponent, PropsWithChildren } from 'react';
	import type { EuiPortalProps } from '@elastic/eui/src/components/portal';
	import type { EuiFocusTrapProps } from '@elastic/eui/src/components/focus_trap';
	import type { EuiTablePaginationProps, EuiTableProps } from '@elastic/eui/src/components/table';
	export type EuiComponentDefaults = {
	    /**
	     * Provide a global configuration for EuiPortal's default insertion position.
	     */
	    EuiPortal?: Pick<EuiPortalProps, 'insert'>;
	    /**
	     * Provide a global configuration for EuiFocusTrap's `gapMode` and `crossFrame` props
	     */
	    EuiFocusTrap?: Pick<EuiFocusTrapProps, 'gapMode' | 'crossFrame'>;
	    /**
	     * Provide global settings for EuiTablePagination's props that affect page size
	     * / the rows per page selection.
	     *
	     * These defaults will be inherited all table and grid components that utilize EuiTablePagination.
	     */
	    EuiTablePagination?: Pick<EuiTablePaginationProps, 'itemsPerPage' | 'itemsPerPageOptions' | 'showPerPageOptions'>;
	    /**
	     * Provide a global configuration for EuiTable's `responsiveBreakpoint` prop. Defaults to `'s'`.
	     *
	     * Defaults will be inherited by all `EuiBasicTable`s and `EuiInMemoryTable`s.
	     */
	    EuiTable?: Pick<EuiTableProps, 'responsiveBreakpoint'>;
	};
	export const EuiComponentDefaultsContext: React.Context<EuiComponentDefaults>;
	export type EuiComponentDefaultsProviderProps = PropsWithChildren & {
	    componentDefaults?: EuiComponentDefaults;
	};
	export const EuiComponentDefaultsProvider: FunctionComponent<EuiComponentDefaultsProviderProps>;
	export const useComponentDefaults: () => EuiComponentDefaults;
	export const usePropsWithComponentDefaults: <TComponentName extends keyof EuiComponentDefaults, TComponentProps>(componentName: TComponentName, props: TComponentProps) => TComponentProps;

}
declare module '@elastic/eui/src/components/provider/component_defaults' {
	export * from '@elastic/eui/src/components/provider/component_defaults/component_defaults';

}
declare module '@elastic/eui/src/components/focus_trap/focus_trap' {
	import { FunctionComponent, CSSProperties } from 'react';
	import { ReactFocusOnProps } from 'react-focus-on/dist/es5/types';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { ElementTarget } from '@elastic/eui/src/services';
	export type FocusTarget = ElementTarget;
	export type EuiFocusTrapProps = Omit<ReactFocusOnProps, 'enabled' | 'style' | 'className' | 'css' | 'gapMode' | 'crossFrame' | 'scrollLock' | 'noIsolation' | 'returnFocus'> & {
	    className?: CommonProps['className'];
	    css?: CommonProps['css'];
	    style?: CSSProperties;
	    /**
	     * @default false
	     */
	    disabled?: boolean;
	    /**
	     * Whether `onClickOutside` should be called on mouseup instead of mousedown.
	     * This flag can be used to prevent conflicts with outside toggle buttons by delaying the closing click callback.
	     */
	    closeOnMouseup?: boolean;
	    /**
	     * Clicking outside the trap area will disable the trap
	     * @default false
	     */
	    clickOutsideDisables?: boolean;
	    /**
	     * Reference to element that will get focus when the trap is initiated
	     */
	    initialFocus?: FocusTarget;
	    /**
	     * if `scrollLock` is set to true, the body's scrollbar width will be preserved on lock
	     * via the `gapMode` CSS property. Depending on your custom CSS, you may prefer to use
	     * `margin` instead of `padding`.
	     * @default padding
	     */
	    gapMode?: 'padding' | 'margin';
	    /**
	     * Configures focus trapping between iframes.
	     * By default, EuiFocusTrap allows focus to leave iframes and move to elements outside of it.
	     * Set to `true` if you want focus to remain trapped within the iframe.
	     * @default false
	     */
	    crossFrame?: ReactFocusOnProps['crossFrame'];
	    /**
	     * @default false
	     */
	    scrollLock?: ReactFocusOnProps['scrollLock'];
	    /**
	     * @default true
	     */
	    noIsolation?: ReactFocusOnProps['noIsolation'];
	    /**
	     * @default true
	     */
	    returnFocus?: ReactFocusOnProps['returnFocus'];
	};
	export const EuiFocusTrap: FunctionComponent<EuiFocusTrapProps>;

}
declare module '@elastic/eui/src/components/focus_trap' {
	export type { EuiFocusTrapProps, FocusTarget } from '@elastic/eui/src/components/focus_trap/focus_trap';
	export { EuiFocusTrap } from '@elastic/eui/src/components/focus_trap/focus_trap';

}
declare module '@elastic/eui/src/components/observer/mutation_observer/mutation_observer' {
	import { ReactNode } from 'react';
	import { EuiObserver } from '@elastic/eui/src/components/observer/observer';
	export interface EuiMutationObserverProps {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: (ref: (e: HTMLElement | null) => void) => ReactNode;
	    onMutation: MutationCallback;
	    observerOptions?: MutationObserverInit;
	}
	export class EuiMutationObserver extends EuiObserver<EuiMutationObserverProps> {
	    name: string;
	    onMutation: MutationCallback;
	    beginObserve: () => void;
	}
	export const useMutationObserver: (container: Element | null, callback: MutationCallback, observerOptions?: MutationObserverInit | undefined) => void;

}
declare module '@elastic/eui/src/components/observer/mutation_observer' {
	export type { EuiMutationObserverProps } from '@elastic/eui/src/components/observer/mutation_observer/mutation_observer';
	export { EuiMutationObserver, useMutationObserver } from '@elastic/eui/src/components/observer/mutation_observer/mutation_observer';

}
declare module '@elastic/eui/src/services/popover/types' {
	export type EuiPopoverPosition = 'top' | 'right' | 'bottom' | 'left';

}
declare module '@elastic/eui/src/services/popover/calculate_popover_position' {
	import { EuiPopoverPosition } from '@elastic/eui/src/services/popover/types';
	interface EuiPopoverBoundingBox {
	    top: number;
	    left: number;
	    width: number;
	    height: number;
	}
	interface EuiPopoverAnchorRect extends EuiPopoverBoundingBox {
	    right: number;
	    bottom: number;
	}
	interface EuiPopoverDimensions {
	    width: number;
	    height: number;
	}
	interface EuiPopoverPositionedBox extends EuiPopoverBoundingBox {
	    position: EuiPopoverPosition;
	}
	/**
	 * Determine the best position for a popover that avoids clipping by the window view port.
	 *
	 * @param {Object} anchorBounds - getBoundingClientRect() of the node the popover is tethered to (e.g. a button).
	 * @param {Object} popoverBounds - getBoundingClientRect() of the popover node (e.g. the tooltip).
	 * @param {string} requestedPosition - Position the user wants. One of ["top", "right", "bottom", "left"]
	 * @param {number} buffer - The space between the wrapper and the popover. Also the minimum space between the
	 * popover and the window.
	 * @param {Array} positions - List of acceptable positions. Defaults to ["top", "right", "bottom", "left"].
	 *
	 * @returns {Object} With properties position (one of ["top", "right", "bottom", "left"]), left, top, width, and height.
	 */
	export function calculatePopoverPosition(anchorBounds: EuiPopoverAnchorRect, popoverBounds: EuiPopoverDimensions, requestedPosition: EuiPopoverPosition, buffer?: number, positions?: EuiPopoverPosition[]): EuiPopoverPositionedBox;
	export {};

}
declare module '@elastic/eui/src/services/popover/popover_positioning' {
	import { EuiPopoverPosition } from '@elastic/eui/src/services/popover/types';
	export const POSITIONS: EuiPopoverPosition[];
	interface BoundingBox {
	    [position: string]: number;
	    top: number;
	    right: number;
	    bottom: number;
	    left: number;
	}
	export interface EuiClientRect extends BoundingBox {
	    height: number;
	    width: number;
	}
	interface FindPopoverPositionArgs {
	    anchor: HTMLElement;
	    popover: HTMLElement;
	    align?: EuiPopoverPosition;
	    position: EuiPopoverPosition;
	    forcePosition?: boolean;
	    buffer?: number | [number, number, number, number];
	    offset?: number;
	    allowCrossAxis?: boolean;
	    container?: HTMLElement;
	    arrowConfig?: {
	        arrowWidth: number;
	        arrowBuffer: number;
	    };
	    returnBoundingBox?: boolean;
	}
	interface FindPopoverPositionResult {
	    top: number;
	    left: number;
	    position: EuiPopoverPosition;
	    fit: number;
	    arrow?: {
	        left: number;
	        top: number;
	    };
	    anchorBoundingBox?: EuiClientRect;
	}
	/**
	 * Calculates the absolute positioning (relative to document.body) to place a popover element
	 *
	 * @param anchor {HTMLElement} Element to anchor the popover to
	 * @param popover {HTMLElement} Element containing the popover content
	 * @param position {string} Position the user wants. One of ["top", "right", "bottom", "left"]
	 * @param [forcePosition] {boolean} If true, use only the provided `position` value and don't try any other position
	 * @param [align] {string} Cross-axis alignment. One of ["top", "right", "bottom", "left"]
	 * @param [buffer=16] {number} Minimum distance between the popover and the bounding container
	 * @param [offset=0] {number} Distance between the popover and the anchor
	 * @param [allowCrossAxis=true] {boolean} Whether to allow the popover to be positioned on the cross-axis
	 * @param [container] {HTMLElement} Element the popover must be constrained to fit within
	 * @param [arrowConfig] {{arrowWidth: number, arrowBuffer: number}} If
	 *  present, describes the size & constraints for an arrow element, and the
	 *  function return value will include an `arrow` param with position details
	 *
	 * @returns {FindPopoverPositionResult} absolute page coordinates for the
	 * popover, and the placement's relation to the anchor or undefined
	 * there's no room.
	 */
	export function findPopoverPosition({ anchor, popover, align, position, forcePosition, buffer, offset, allowCrossAxis, container, arrowConfig, returnBoundingBox, }: FindPopoverPositionArgs): FindPopoverPositionResult;
	interface GetPopoverScreenCoordinatesArgs {
	    position: EuiPopoverPosition;
	    align?: EuiPopoverPosition;
	    anchorBoundingBox: EuiClientRect;
	    popoverBoundingBox: EuiClientRect;
	    windowBoundingBox: EuiClientRect;
	    containerBoundingBox: EuiClientRect;
	    arrowConfig?: {
	        arrowWidth: number;
	        arrowBuffer: number;
	    };
	    offset?: number;
	    buffer?: number | [number, number, number, number];
	}
	interface GetPopoverScreenCoordinatesResult {
	    top: number;
	    left: number;
	    fit: number;
	    arrow: {
	        top: number;
	        left: number;
	    } | undefined;
	}
	/**
	 * Given a target position and the popover's surrounding context, returns either an
	 * object with {top, left} screen coordinates or `null` if it's not possible to show
	 * content in the target position
	 * @param position {string} the target position, one of ["top", "right", "bottom", "left"]
	 * @param align {string} target alignment on the cross-axis, one of ["top", "right", "bottom", "left"]
	 * @param anchorBoundingBox {Object} bounding box of the anchor element
	 * @param popoverBoundingBox {Object} bounding box of the popover element
	 * @param windowBoundingBox {Object} bounding box of the window
	 * @param containerBoundingBox {Object} bounding box of the container
	 * @param [arrowConfig] {{arrowWidth: number, arrowBuffer: number}} If present, describes the size &
	 *  constraints for an arrow element, and the function return value will include an `arrow` param
	 *  with position details
	 * @param [offset=0] {number} Distance between the popover and the anchor
	 * @param [buffer=0] {number} Minimum distance between the popover's
	 *  placement and the container edge
	 *
	 * @returns {GetPopoverScreenCoordinatesResult}
	 *  object with top/left coordinates, the popover's relative position to the anchor, and how well the
	 *  popover fits in the location (0.0 -> 1.0) coordinates and the popover's relative position, if
	 *  there is no room in this placement then null
	 */
	export function getPopoverScreenCoordinates({ position, align, anchorBoundingBox, popoverBoundingBox, windowBoundingBox, containerBoundingBox, arrowConfig, offset, buffer, }: GetPopoverScreenCoordinatesArgs): GetPopoverScreenCoordinatesResult;
	/**
	 * Finds the client pixel coordinate of each edge for the element's bounding box,
	 * and the bounding box's width & height
	 *
	 * @param {HTMLElement} element
	 * @returns {{top: number, right: number, bottom: number, left: number, height: number, width: number}}
	 */
	export function getElementBoundingBox(element: HTMLElement): EuiClientRect;
	/**
	 * Calculates the available content space between anchor and container
	 *
	 * @param {Object} anchorBoundingBox Client bounding box of the anchor element
	 * @param {Object} containerBoundingBox Client bounding box of the container element
	 * @param {number} buffer Minimum distance between the popover and the bounding container
	 * @param {number} offset Distance between the popover and the anchor
	 * @param {string} offsetSide Side the offset needs to be applied to, one
	 *  of ["top", "right", "bottom", "left"]
	 * @returns {{top: number, right: number, bottom: number, left: number}}
	 */
	export function getAvailableSpace(anchorBoundingBox: BoundingBox, containerBoundingBox: BoundingBox, buffer: number | [number, number, number, number], offset: number, offsetSide: EuiPopoverPosition): BoundingBox;
	/**
	 * Computes the fit (overlap) of the content within the container, fit is in range 0.0 => 1.0
	 * @param contentBoundingBox bounding box of content to calculate fit for
	 * @param containerBoundingBox bounding box of container
	 * @returns {number}
	 */
	export function getVisibleFit(contentBoundingBox: BoundingBox, containerBoundingBox: BoundingBox): number;
	/**
	 * Calculates the intersection space between two bounding boxes
	 *
	 * @param firstBox
	 * @param secondBox
	 * @returns {EuiClientRect}
	 */
	export function intersectBoundingBoxes(firstBox: BoundingBox, secondBox: BoundingBox): EuiClientRect;
	/**
	 * Returns the top-most defined z-index in the element's ancestor hierarchy
	 * relative to the `target` element; if no z-index is defined, returns 0
	 * @param element {HTMLElement}
	 * @param cousin {HTMLElement}
	 * @returns {number}
	 */
	export function getElementZIndex(element: HTMLElement, cousin: HTMLElement): number;
	export {};

}
declare module '@elastic/eui/src/services/popover' {
	export { calculatePopoverPosition } from '@elastic/eui/src/services/popover/calculate_popover_position';
	export { findPopoverPosition, getElementZIndex } from '@elastic/eui/src/services/popover/popover_positioning';
	export type { EuiPopoverPosition } from '@elastic/eui/src/services/popover/types';

}
declare module '@elastic/eui/src/components/outside_click_detector/outside_click_detector' {
	import { Component, EventHandler, MouseEvent as ReactMouseEvent, ReactElement } from 'react';
	export interface EuiEvent extends Event {
	    euiGeneratedBy: string[];
	}
	export interface EuiOutsideClickDetectorProps {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: ReactElement<any>;
	    onOutsideClick: (event: Event) => void;
	    isDisabled?: boolean;
	    onMouseDown?: (event: ReactMouseEvent) => void;
	    onMouseUp?: (event: ReactMouseEvent) => void;
	    onTouchStart?: (event: ReactMouseEvent) => void;
	    onTouchEnd?: (event: ReactMouseEvent) => void;
	}
	export class EuiOutsideClickDetector extends Component<EuiOutsideClickDetectorProps> {
	    private id;
	    private capturedDownIds;
	    constructor(props: EuiOutsideClickDetectorProps);
	    onClickOutside: EventHandler<any>;
	    componentDidMount(): void;
	    componentWillUnmount(): void;
	    onChildClick: (event: ReactMouseEvent, cb: (event: ReactMouseEvent) => void) => void;
	    onChildMouseDown: (event: ReactMouseEvent) => void;
	    onChildMouseUp: (event: ReactMouseEvent) => void;
	    render(): ReactElement<any, string | import("react").JSXElementConstructor<any>>;
	}

}
declare module '@elastic/eui/src/components/outside_click_detector' {
	export type { EuiOutsideClickDetectorProps } from '@elastic/eui/src/components/outside_click_detector/outside_click_detector';
	export { EuiOutsideClickDetector } from '@elastic/eui/src/components/outside_click_detector/outside_click_detector';

}
declare module '@elastic/eui/src/components/popover/popover_arrow/_popover_arrow.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const popoverArrowSize = "m";
	export const euiPopoverArrowStyles: (euiThemeContext: UseEuiTheme) => {
	    euiPopoverArrow: import("@emotion/utils").SerializedStyles;
	    top: import("@emotion/utils").SerializedStyles;
	    bottom: import("@emotion/utils").SerializedStyles;
	    left: import("@emotion/utils").SerializedStyles;
	    right: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/popover/popover_arrow/_popover_arrow' {
	import { HTMLAttributes, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const POSITIONS: readonly ["top", "left", "right", "bottom"];
	export type EuiPopoverArrowPositions = (typeof POSITIONS)[number];
	export type EuiPopoverArrowProps = HTMLAttributes<HTMLDivElement> & CommonProps & {
	    position: EuiPopoverArrowPositions;
	};
	export const EuiPopoverArrow: FunctionComponent<EuiPopoverArrowProps>;

}
declare module '@elastic/eui/src/components/popover/popover_arrow' {
	export type { EuiPopoverArrowProps, EuiPopoverArrowPositions, } from '@elastic/eui/src/components/popover/popover_arrow/_popover_arrow';
	export { EuiPopoverArrow } from '@elastic/eui/src/components/popover/popover_arrow/_popover_arrow';

}
declare module '@elastic/eui/src/components/popover/popover.styles' {
	export const euiPopoverStyles: () => {
	    euiPopover: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/panel/panel.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiPanelStyles: (euiThemeContext: UseEuiTheme) => {
	    euiPanel: import("@emotion/utils").SerializedStyles;
	    grow: import("@emotion/utils").SerializedStyles;
	    hasShadow: import("@emotion/utils").SerializedStyles;
	    hasBorder: import("@emotion/utils").SerializedStyles;
	    radius: {
	        none: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	    };
	    isClickable: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/panel/panel' {
	import { ButtonHTMLAttributes, FunctionComponent, HTMLAttributes, Ref } from 'react';
	import { _EuiBackgroundColor, EuiPaddingSize } from '@elastic/eui/src/global_styling';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	export const SIZES: readonly ["none", "xs", "s", "m", "l", "xl"]; const _SIZES: ("xs" | "s" | "m" | "l" | "xl" | "none")[];
	export type PanelPaddingSize = (typeof _SIZES)[number];
	export const BORDER_RADII: readonly ["none", "m"];
	export type PanelBorderRadius = (typeof BORDER_RADII)[number];
	export const COLORS: readonly ["transparent", "plain", "subdued", "accent", "primary", "success", "warning", "danger"];
	export type PanelColor = _EuiBackgroundColor;
	export interface _EuiPanelProps extends CommonProps {
	    /**
	     * Adds a medium shadow to the panel;
	     * Only works when `color="plain"`
	     */
	    hasShadow?: boolean;
	    /**
	     * Adds a slight 1px border on all edges.
	     * Only works when `color="plain | transparent"`
	     */
	    hasBorder?: boolean;
	    /**
	     * Padding for all four sides
	     */
	    paddingSize?: EuiPaddingSize;
	    /**
	     * Corner border radius
	     */
	    borderRadius?: PanelBorderRadius;
	    /**
	     * When true the panel will grow in height to match `EuiFlexItem`
	     */
	    grow?: boolean;
	    panelRef?: Ref<HTMLDivElement>;
	    /**
	     * Background color of the panel;
	     * Usually a lightened form of the brand colors
	     */
	    color?: PanelColor;
	}
	export interface _EuiPanelDivlike extends _EuiPanelProps, Omit<HTMLAttributes<HTMLDivElement>, 'color'> {
	    element?: 'div';
	}
	export interface _EuiPanelButtonlike extends _EuiPanelProps, Omit<ButtonHTMLAttributes<HTMLButtonElement>, 'color'> {
	    element?: 'button';
	}
	export type EuiPanelProps = ExclusiveUnion<_EuiPanelButtonlike, _EuiPanelDivlike>;
	export const EuiPanel: FunctionComponent<EuiPanelProps>;
	export {};

}
declare module '@elastic/eui/src/components/popover/popover_panel/_popover_panel.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const openAnimationTiming = "slow";
	/**
	 * 1. Can expand further, but it looks weird if it's smaller than the originating button.
	 * 2. Animation happens on the panel. But don't animate position when using the attached mode like for inputs
	 * 3. Make sure the panel stays within the window.
	 * 4. Make the popover lighter on dark mode (too hard to distinguish from plain bgs otherwise), and set a CSS var for the arrow to use
	 */
	export const euiPopoverPanelStyles: (euiThemeContext: UseEuiTheme) => {
	    euiPopover__panel: import("@emotion/utils").SerializedStyles;
	    isOpen: import("@emotion/utils").SerializedStyles;
	    light: import("@emotion/utils").SerializedStyles;
	    dark: import("@emotion/utils").SerializedStyles;
	    hasTransform: {
	        hasTransform: import("@emotion/utils").SerializedStyles;
	        top: import("@emotion/utils").SerializedStyles;
	        bottom: import("@emotion/utils").SerializedStyles;
	        left: import("@emotion/utils").SerializedStyles;
	        right: import("@emotion/utils").SerializedStyles;
	    };
	    isAttached: {
	        isAttached: import("@emotion/utils").SerializedStyles;
	        top: import("@emotion/utils").SerializedStyles;
	        bottom: import("@emotion/utils").SerializedStyles;
	        readonly left: import("@emotion/utils").SerializedStyles;
	        readonly right: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/popover/popover_panel/_popover_panel' {
	import React, { FunctionComponent } from 'react';
	import { EuiPaddingSize } from '@elastic/eui/src/global_styling';
	import { _EuiPanelDivlike } from '@elastic/eui/src/components/panel/panel';
	import { EuiPopoverArrowPositions } from '@elastic/eui/src/components/popover/popover_arrow';
	export const EuiPopoverPanelContext: React.Context<{
	    paddingSize: EuiPaddingSize;
	}>;
	export type EuiPopoverPanelProps = _EuiPanelDivlike; type EuiPopoverPanelInternalProps = {
	    isOpen?: boolean;
	    isAttached?: boolean;
	    position?: EuiPopoverArrowPositions | null;
	};
	/**
	 * *INTERNAL ONLY*
	 * Purely for re-use of styling
	 */
	export const EuiPopoverPanel: FunctionComponent<EuiPopoverPanelProps & EuiPopoverPanelInternalProps>;
	export {};

}
declare module '@elastic/eui/src/components/popover/popover_panel' {
	export { EuiPopoverPanel } from '@elastic/eui/src/components/popover/popover_panel/_popover_panel';

}
declare module '@elastic/eui/src/components/popover/popover' {
	import React, { Component, KeyboardEvent, CSSProperties, HTMLAttributes, ReactNode, Ref, RefCallback, PropsWithChildren } from 'react';
	import { CommonProps, NoArgCallback } from '@elastic/eui/src/components/common';
	import { FocusTarget, EuiFocusTrapProps } from '@elastic/eui/src/components/focus_trap';
	import { EuiPopoverPosition } from '@elastic/eui/src/services/popover';
	import { EuiPopoverArrowPositions } from '@elastic/eui/src/components/popover/popover_arrow';
	import { EuiPopoverPanelProps } from '@elastic/eui/src/components/popover/popover_panel/_popover_panel';
	import { EuiPaddingSize } from '@elastic/eui/src/global_styling';
	export const popoverAnchorPosition: readonly ["upCenter", "upLeft", "upRight", "downCenter", "downLeft", "downRight", "leftCenter", "leftUp", "leftDown", "rightCenter", "rightUp", "rightDown"];
	export type PopoverAnchorPosition = (typeof popoverAnchorPosition)[number];
	export interface EuiPopoverProps extends PropsWithChildren, CommonProps {
	    /**
	     * Alignment of the popover and arrow relative to the button
	     */
	    anchorPosition?: PopoverAnchorPosition;
	    /**
	     * Style and position alteration for arrow-less attachment.
	     * Intended for use with inputs as anchors, e.g. EuiInputPopover
	     */
	    attachToAnchor?: boolean;
	    /**
	     * Triggering element for which to align the popover to
	     */
	    button: NonNullable<ReactNode>;
	    /**
	     * Callback to handle hiding of the popover
	     */
	    closePopover: NoArgCallback<void>;
	    /**
	     * Restrict the popover's position within this element
	     */
	    container?: HTMLElement;
	    /**
	     * CSS display type for both the popover and anchor
	     */
	    display?: CSSProperties['display'];
	    /**
	     * Object of props passed to EuiFocusTrap
	     */
	    focusTrapProps?: Partial<EuiFocusTrapProps>;
	    /**
	     * Show arrow indicating to originating button
	     */
	    hasArrow?: boolean;
	    /**
	     * Specifies what element should initially have focus; Can be a DOM
	     * node, or a selector string (which will be passed to
	     * document.querySelector() to find the DOM node), or a function that
	     * returns a DOM node.
	     *
	     * If not passed, initial focus defaults to the popover panel.
	     */
	    initialFocus?: FocusTarget;
	    /**
	     * Passed directly to EuiPortal for DOM positioning. Both properties are
	     * required if prop is specified
	     */
	    insert?: {
	        sibling: HTMLElement;
	        position: 'before' | 'after';
	    };
	    /**
	     * Visibility state of the popover
	     */
	    isOpen?: boolean;
	    /**
	     * Traps tab focus within the popover contents
	     */
	    ownFocus?: boolean;
	    /**
	     * Custom class added to the EuiPanel containing the popover contents
	     */
	    panelClassName?: string;
	    /**
	     * EuiPanel padding on all sides
	     */
	    panelPaddingSize?: EuiPaddingSize;
	    /**
	     * Standard DOM `style` attribute. Passed to the EuiPanel
	     */
	    panelStyle?: CSSProperties;
	    /**
	     * Object of props passed to EuiPanel. See #EuiPopoverPanelProps
	     */
	    panelProps?: Omit<EuiPopoverPanelProps, 'style' | 'hasShadow' | 'hasBorder' | 'color'>;
	    panelRef?: RefCallback<HTMLElement | null>;
	    /**
	     * Optional screen reader instructions to announce upon popover open,
	     * in addition to EUI's default popover instructions for Escape on close.
	     * Useful for popovers that may have additional keyboard capabilities such as
	     * arrow navigation.
	     */
	    popoverScreenReaderText?: string | ReactNode;
	    popoverRef?: Ref<HTMLDivElement>;
	    /**
	     * When `true`, the popover's position is re-calculated when the user
	     * scrolls, this supports having fixed-position popover anchors. When nesting
	     * an `EuiPopover` in a scrollable container, `repositionOnScroll` should be `true`
	     */
	    repositionOnScroll?: boolean;
	    /**
	     * By default, popovers will attempt to position themselves along the initial
	     * axis specified. If there is not enough room either vertically or horizontally
	     * however, the popover will attempt to reposition itself along the secondary
	     * cross axis if there is room there instead.
	     *
	     * If you do not not want this repositioning to occur (and it is acceptable for
	     * the popover to appear offscreen), set this to false to disable this behavior.
	     *
	     * @default true
	     */
	    repositionToCrossAxis?: boolean;
	    /**
	     * By default, popover content inherits the z-index of the anchor
	     * component; pass `zIndex` to override
	     */
	    zIndex?: number;
	    /**
	     * Distance away from the anchor that the popover will render
	     */
	    offset?: number;
	    /**
	     * Minimum distance between the popover and the bounding container;
	     * Pass an array of 4 values to adjust each side differently: `[top, right, bottom, left]`
	     * @default 16
	     */
	    buffer?: number | [number, number, number, number];
	    /**
	     * Element to pass as the child element of the arrow;
	     * Use case is typically limited to an accompanying `EuiBeacon`
	     */
	    arrowChildren?: ReactNode;
	    /**
	     * Provide a name to the popover panel
	     */
	    'aria-label'?: string;
	    /**
	     * Alternative option to `aria-label` that takes an `id`.
	     * Usually takes the `id` of the popover title
	     */
	    'aria-labelledby'?: string;
	    /**
	     * Function callback for when the popover positon changes
	     */
	    onPositionChange?: (position: EuiPopoverPosition) => void;
	}
	export function getPopoverPositionFromAnchorPosition(anchorPosition: PopoverAnchorPosition): EuiPopoverPosition;
	export function getPopoverAlignFromAnchorPosition(anchorPosition: PopoverAnchorPosition): EuiPopoverPosition;
	export type Props = EuiPopoverProps & HTMLAttributes<HTMLDivElement>;
	interface State {
	    prevProps: {
	        isOpen?: boolean;
	    };
	    suppressingPopover?: boolean;
	    isClosing: boolean;
	    isOpening: boolean;
	    popoverStyles: CSSProperties;
	    arrowStyles?: CSSProperties;
	    arrowPosition: EuiPopoverArrowPositions | null;
	    openPosition: any;
	    isOpenStable: boolean;
	} type PropsWithDefaults = Props & {
	    anchorPosition: PopoverAnchorPosition;
	    hasArrow: boolean;
	    isOpen: boolean;
	    ownFocus: boolean;
	    panelPaddingSize: EuiPaddingSize;
	};
	export class EuiPopover extends Component<Props, State> {
	    static defaultProps: Partial<PropsWithDefaults>;
	    static getDerivedStateFromProps(nextProps: Props, prevState: State): Partial<State> | null;
	    private respositionTimeout;
	    private strandedFocusTimeout;
	    private closingTransitionTimeout;
	    private closingTransitionAnimationFrame;
	    private button;
	    private panel;
	    private descriptionId;
	    constructor(props: Props);
	    closePopover: () => void;
	    onEscapeKey: (event: Event) => void;
	    handleStrandedFocus: () => void;
	    onKeyDown: (event: KeyboardEvent) => void;
	    onClickOutside: (event: Event) => void;
	    onOpenPopover: () => void;
	    componentDidMount(): void;
	    componentDidUpdate(prevProps: Props): void;
	    componentWillUnmount(): void;
	    onMutation: (records: MutationRecord[]) => void;
	    positionPopover: (allowEnforcePosition: boolean) => void;
	    positionPopoverFixed: () => void;
	    positionPopoverFluid: () => void;
	    panelRef: (node: HTMLElement | null) => void;
	    popoverRef: (node: HTMLDivElement | null) => void;
	    render(): React.JSX.Element;
	}
	export {};

}
declare module '@elastic/eui/src/components/popover/input_popover' {
	import React, { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiPopoverProps } from '@elastic/eui/src/components/popover/popover';
	export interface _EuiInputPopoverProps extends Omit<EuiPopoverProps, 'button' | 'buttonRef' | 'anchorPosition'> {
	    /**
	     * Alignment of the popover relative to the input
	     */
	    anchorPosition?: 'downLeft' | 'downRight' | 'downCenter';
	    disableFocusTrap?: boolean;
	    /**
	     * Allows automatically closing the input popover on page scroll
	     */
	    closeOnScroll?: boolean;
	    fullWidth?: boolean;
	    input: EuiPopoverProps['button'];
	    inputRef?: EuiPopoverProps['popoverRef'];
	    onPanelResize?: (width: number) => void;
	    /**
	     * By default, **EuiInputPopovers** inherit the same width as the passed input element.
	     * However, if the input width is too small, you can pass a minimum panel width
	     * (that should be based on the popover content).
	     */
	    panelMinWidth?: number;
	}
	export type EuiInputPopoverProps = CommonProps & HTMLAttributes<HTMLDivElement> & _EuiInputPopoverProps;
	export const EuiInputPopoverWidthContext: React.Context<number>;
	export const EuiInputPopover: FunctionComponent<EuiInputPopoverProps>;

}
declare module '@elastic/eui/src/components/popover/popover_title.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiPopoverTitleStyles: (euiThemeContext: UseEuiTheme) => {
	    euiPopoverTitle: import("@emotion/utils").SerializedStyles;
	    panelPaddingSizes: {
	        none: import("@emotion/utils").SerializedStyles;
	        xs: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	        l: import("@emotion/utils").SerializedStyles;
	        xl: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/popover/popover_title' {
	import { HTMLAttributes, FunctionComponent } from 'react';
	import { EuiPaddingSize } from '@elastic/eui/src/global_styling';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiPopoverTitleProps = FunctionComponent<HTMLAttributes<HTMLDivElement> & CommonProps & {
	    /**
	     * Customize the all around padding of the popover title.
	     * Leave `undefined` to inherit from the `panelPaddingSize` of the containing EuiPopover
	     */
	    paddingSize?: EuiPaddingSize;
	}>;
	export const EuiPopoverTitle: EuiPopoverTitleProps;

}
declare module '@elastic/eui/src/components/popover/popover_footer.styles' {
	import { EuiPaddingSize } from '@elastic/eui/src/global_styling';
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiPopoverFooterStyles: (euiThemeContext: UseEuiTheme) => {
	    euiPopoverFooter: import("@emotion/utils").SerializedStyles;
	    panelPaddingSizes: {
	        none: import("@emotion/utils").SerializedStyles;
	        xs: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	        l: import("@emotion/utils").SerializedStyles;
	        xl: import("@emotion/utils").SerializedStyles;
	    };
	};
	export const panelPaddingOffset: (euiThemeContext: UseEuiTheme, size: EuiPaddingSize) => string;

}
declare module '@elastic/eui/src/components/popover/popover_footer' {
	import { HTMLAttributes, FunctionComponent } from 'react';
	import { EuiPaddingSize } from '@elastic/eui/src/global_styling';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiPopoverFooterProps = FunctionComponent<HTMLAttributes<HTMLDivElement> & CommonProps & {
	    /**
	     * Customize the all around padding of the popover footer.
	     * Leave `undefined` to inherit from the `panelPaddingSize` of the containing EuiPopover
	     */
	    paddingSize?: EuiPaddingSize;
	}>;
	export const EuiPopoverFooter: EuiPopoverFooterProps;

}
declare module '@elastic/eui/src/components/popover/wrapping_popover' {
	import React, { Component } from 'react';
	import { Props as EuiPopoverProps } from '@elastic/eui/src/components/popover/popover';
	export interface EuiWrappingPopoverProps extends Omit<EuiPopoverProps, 'button'> {
	    button: HTMLElement;
	}
	/**
	 * Injects the EuiPopover next to the button via EuiPortal
	 * then the button element is moved into the popover dom.
	 * On unmount, the button is moved back to its original location.
	 */
	export class EuiWrappingPopover extends Component<EuiWrappingPopoverProps> {
	    private portal;
	    componentWillUnmount(): void;
	    setPortalRef: (node: HTMLElement | null) => void;
	    setAnchorRef: (node: HTMLElement | null) => void;
	    render(): React.JSX.Element;
	}

}
declare module '@elastic/eui/src/components/popover' {
	export type { EuiInputPopoverProps } from '@elastic/eui/src/components/popover/input_popover';
	export { EuiInputPopover } from '@elastic/eui/src/components/popover/input_popover';
	export type { EuiPopoverProps, PopoverAnchorPosition } from '@elastic/eui/src/components/popover/popover';
	export { EuiPopover } from '@elastic/eui/src/components/popover/popover';
	export type { EuiPopoverTitleProps } from '@elastic/eui/src/components/popover/popover_title';
	export { EuiPopoverTitle } from '@elastic/eui/src/components/popover/popover_title';
	export type { EuiPopoverFooterProps } from '@elastic/eui/src/components/popover/popover_footer';
	export { EuiPopoverFooter } from '@elastic/eui/src/components/popover/popover_footer';
	export type { EuiWrappingPopoverProps } from '@elastic/eui/src/components/popover/wrapping_popover';
	export { EuiWrappingPopover } from '@elastic/eui/src/components/popover/wrapping_popover';

}
declare module '@elastic/eui/src/components/form/form_label/form_label.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFormLabel: (euiThemeContext: UseEuiTheme) => string;
	export const euiFormLabelStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFormLabel: import("@emotion/utils").SerializedStyles;
	    notDisabled: string;
	    invalid: import("@emotion/utils").SerializedStyles;
	    focused: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/form_label/form_label' {
	import { FunctionComponent, LabelHTMLAttributes, HTMLAttributes } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	interface EuiFormLabelCommonProps {
	    isFocused?: boolean;
	    isInvalid?: boolean;
	    /**
	     * Changes `cursor` to `default`.
	     */
	    isDisabled?: boolean;
	    /**
	     * Default type is a `label` but can be changed to a `legend`
	     * if using inside a `fieldset`.
	     */
	    type?: 'label' | 'legend';
	}
	export type _EuiFormLabelProps = {
	    type?: 'label';
	} & EuiFormLabelCommonProps & CommonProps & LabelHTMLAttributes<HTMLLabelElement>;
	export type _EuiFormLegendProps = {
	    type: 'legend';
	} & EuiFormLabelCommonProps & CommonProps & HTMLAttributes<HTMLLegendElement>;
	export type EuiFormLabelProps = ExclusiveUnion<_EuiFormLabelProps, _EuiFormLegendProps>;
	export const EuiFormLabel: FunctionComponent<EuiFormLabelProps>;
	export {};

}
declare module '@elastic/eui/src/components/form/form_label' {
	export type { EuiFormLabelProps } from '@elastic/eui/src/components/form/form_label/form_label';
	export { EuiFormLabel } from '@elastic/eui/src/components/form/form_label/form_label';

}
declare module '@elastic/eui/src/components/form/eui_form_context' {
	import React from 'react';
	export interface FormContextValue {
	    defaultFullWidth: boolean;
	}
	export const FormContext: React.Context<FormContextValue>;
	export function useFormContext(): FormContextValue;

}
declare module '@elastic/eui/src/components/form/form_control_layout/form_control_layout_clear_button.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const EuiFormControlLayoutClearButtonStyles: ({ euiTheme, colorMode, }: UseEuiTheme) => {
	    euiFormControlLayoutClearButton: import("@emotion/utils").SerializedStyles;
	    euiFormControlLayoutClearButton__icon: import("@emotion/utils").SerializedStyles;
	    size: {
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/form/form_control_layout/form_control_layout_clear_button' {
	import { FunctionComponent, ButtonHTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiFormControlLayoutClearButtonProps = CommonProps & ButtonHTMLAttributes<HTMLButtonElement> & {
	    size?: 's' | 'm';
	};
	export const EuiFormControlLayoutClearButton: FunctionComponent<EuiFormControlLayoutClearButtonProps>;

}
declare module '@elastic/eui/src/components/form/form_control_layout/form_control_layout_custom_icon' {
	import { ButtonHTMLAttributes, FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	import { EuiIconProps, IconType } from '@elastic/eui/src/components/icon';
	export type EuiFormControlLayoutCustomIconProps = CommonProps & ExclusiveUnion<Omit<ButtonHTMLAttributes<HTMLButtonElement>, 'type'>, HTMLAttributes<HTMLSpanElement>> & {
	    type: IconType;
	    size?: EuiIconProps['size'];
	    iconRef?: string | ((el: HTMLButtonElement | HTMLSpanElement | null) => void);
	};
	export const EuiFormControlLayoutCustomIcon: FunctionComponent<EuiFormControlLayoutCustomIconProps>;

}
declare module '@elastic/eui/src/components/form/form_control_layout/form_control_layout_icons.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFormControlLayoutIconsStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFormControlLayoutIcons: import("@emotion/utils").SerializedStyles;
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	    disabled: import("@emotion/utils").SerializedStyles;
	    position: {
	        absolute: {
	            absolute: import("@emotion/utils").SerializedStyles;
	            uncompressed: {
	                left: import("@emotion/utils").SerializedStyles;
	                right: import("@emotion/utils").SerializedStyles;
	            };
	            compressed: {
	                left: import("@emotion/utils").SerializedStyles;
	                right: import("@emotion/utils").SerializedStyles;
	            };
	        };
	        static: {
	            static: import("@emotion/utils").SerializedStyles;
	            uncompressed: string;
	            compressed: string;
	        };
	    };
	};

}
declare module '@elastic/eui/src/components/form/form_control_layout/form_control_layout_icons' {
	import React, { Component } from 'react';
	import { DistributiveOmit } from '@elastic/eui/src/components/common';
	import { IconColor, IconType } from '@elastic/eui/src/components/icon';
	import { EuiFormControlLayoutClearButtonProps } from '@elastic/eui/src/components/form/form_control_layout/form_control_layout_clear_button';
	import { EuiFormControlLayoutCustomIconProps } from '@elastic/eui/src/components/form/form_control_layout/form_control_layout_custom_icon';
	export const ICON_SIDES: readonly ["left", "right"];
	export type IconShape = DistributiveOmit<EuiFormControlLayoutCustomIconProps, 'type' | 'iconRef'> & {
	    type: IconType;
	    side?: (typeof ICON_SIDES)[number];
	    color?: IconColor;
	    ref?: EuiFormControlLayoutCustomIconProps['iconRef'];
	};
	export const isIconShape: (icon: EuiFormControlLayoutIconsProps['icon']) => icon is IconShape;
	export interface EuiFormControlLayoutIconsProps {
	    icon?: IconType | IconShape;
	    side?: (typeof ICON_SIDES)[number];
	    iconsPosition?: 'absolute' | 'static';
	    clear?: EuiFormControlLayoutClearButtonProps;
	    isLoading?: boolean;
	    isInvalid?: boolean;
	    isDropdown?: boolean;
	    compressed?: boolean;
	    isDisabled?: boolean;
	}
	export class EuiFormControlLayoutIcons extends Component<EuiFormControlLayoutIconsProps> {
	    render(): React.JSX.Element;
	    renderCustomIcon(): React.JSX.Element | null;
	    renderDropdownIcon(): React.JSX.Element | null;
	    renderLoadingSpinner(): React.JSX.Element | null;
	    renderClearButton(): React.JSX.Element | null;
	    renderInvalidIcon(): React.JSX.Element | null;
	}

}
declare module '@elastic/eui/src/components/form/form_control_layout/_num_icons' {
	import { type EuiFormControlLayoutIconsProps } from '@elastic/eui/src/components/form/form_control_layout/form_control_layout_icons';
	export const isRightSideIcon: (icon?: EuiFormControlLayoutIconsProps['icon']) => boolean;
	export const getIconAffordanceStyles: ({ icon, clear, isLoading, isInvalid, isDropdown, }: {
	    icon?: EuiFormControlLayoutIconsProps['icon'];
	    clear?: EuiFormControlLayoutIconsProps['clear'] | boolean;
	    isLoading?: boolean | undefined;
	    isInvalid?: boolean | undefined;
	    isDropdown?: boolean | undefined;
	}) => {
	    [k: string]: number;
	} | undefined;

}
declare module '@elastic/eui/src/components/form/form_control_layout/form_control_layout.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFormControlLayoutStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFormControlLayout: import("@emotion/utils").SerializedStyles;
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	    formWidth: string;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    group: {
	        group: import("@emotion/utils").SerializedStyles;
	        uncompressed: string;
	        compressed: string;
	    };
	    children: {
	        euiFormControlLayout__childrenWrapper: import("@emotion/utils").SerializedStyles;
	        inGroup: import("@emotion/utils").SerializedStyles;
	        prependOnly: import("@emotion/utils").SerializedStyles;
	        appendOnly: import("@emotion/utils").SerializedStyles;
	    };
	};
	export const euiFormControlLayoutSideNodeStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFormControlLayout__side: import("@emotion/utils").SerializedStyles;
	    append: import("@emotion/utils").SerializedStyles;
	    prepend: import("@emotion/utils").SerializedStyles;
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/form_control_layout/form_control_layout' {
	import { FunctionComponent, HTMLAttributes, ReactElement, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiFormControlLayoutIconsProps } from '@elastic/eui/src/components/form/form_control_layout/form_control_layout_icons'; type StringOrReactElement = string | ReactElement; type PrependAppendType = StringOrReactElement | StringOrReactElement[];
	export type EuiFormControlLayoutProps = CommonProps & HTMLAttributes<HTMLDivElement> & {
	    /**
	     * Creates an input group with element(s) coming before children.
	     * `string` | `ReactElement` or an array of these
	     */
	    prepend?: PrependAppendType;
	    /**
	     * Creates an input group with element(s) coming after children.
	     * `string` | `ReactElement` or an array of these
	     */
	    append?: PrependAppendType;
	    children?: ReactNode;
	    icon?: EuiFormControlLayoutIconsProps['icon'];
	    /**
	     * Determines whether icons are absolutely or statically rendered. For single inputs,
	     * absolute rendering is typically preferred.
	     * @default absolute
	     */
	    iconsPosition?: EuiFormControlLayoutIconsProps['iconsPosition'];
	    clear?: EuiFormControlLayoutIconsProps['clear'];
	    /**
	     * Expand to fill 100% of the parent.
	     * Defaults to `fullWidth` prop of `<EuiForm>`.
	     * @default false
	     */
	    fullWidth?: boolean;
	    isLoading?: boolean;
	    isDisabled?: boolean;
	    className?: string;
	    compressed?: boolean;
	    readOnly?: boolean;
	    isInvalid?: boolean;
	    /**
	     * Controls the adding of and visibility of a down arrow icon
	     */
	    isDropdown?: boolean;
	    /**
	     * Connects the prepend and append labels to the input
	     */
	    inputId?: string;
	    /**
	     * Allows passing optional additional props to `.euiFormControlLayout__childrenWrapper`
	     */
	    wrapperProps?: CommonProps & HTMLAttributes<HTMLDivElement>;
	};
	export const EuiFormControlLayout: FunctionComponent<EuiFormControlLayoutProps & {
	    isDelimited?: boolean;
	}>;
	export {};

}
declare module '@elastic/eui/src/components/form/form_control_layout/form_control_layout_delimited.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFormControlLayoutDelimitedStyles: (euiThemeContext: UseEuiTheme) => {
	    delimited: import("@emotion/utils").SerializedStyles;
	    disabled: import("@emotion/utils").SerializedStyles;
	    readOnly: import("@emotion/utils").SerializedStyles;
	    childrenWrapper: {
	        delimited: import("@emotion/utils").SerializedStyles;
	        invalid: import("@emotion/utils").SerializedStyles;
	    };
	};
	export const euiFormControlLayoutDelimited__delimiter: import("@emotion/utils").SerializedStyles;
	export const euiFormControlLayoutDelimited__input: import("@emotion/utils").SerializedStyles;

}
declare module '@elastic/eui/src/components/form/form_control_layout/form_control_layout_delimited' {
	import { FunctionComponent, ReactElement, ReactNode } from 'react';
	import { EuiFormControlLayoutProps } from '@elastic/eui/src/components/form/form_control_layout/form_control_layout';
	export type EuiFormControlLayoutDelimitedProps = Partial<EuiFormControlLayoutProps> & {
	    /**
	     * Left side control
	     */
	    startControl: ReactElement;
	    /**
	     * Right side control
	     */
	    endControl: ReactElement;
	    /**
	     * The center content. Accepts a string to be wrapped in a subdued EuiText
	     * or a single ReactElement
	     */
	    delimiter?: ReactNode;
	    className?: string;
	};
	export const EuiFormControlLayoutDelimited: FunctionComponent<EuiFormControlLayoutDelimitedProps>;

}
declare module '@elastic/eui/src/components/form/form_control_layout' {
	export type { EuiFormControlLayoutProps } from '@elastic/eui/src/components/form/form_control_layout/form_control_layout';
	export { EuiFormControlLayout } from '@elastic/eui/src/components/form/form_control_layout/form_control_layout';
	export type { EuiFormControlLayoutDelimitedProps } from '@elastic/eui/src/components/form/form_control_layout/form_control_layout_delimited';
	export { EuiFormControlLayoutDelimited } from '@elastic/eui/src/components/form/form_control_layout/form_control_layout_delimited';
	export { EuiFormControlLayoutIcons, type EuiFormControlLayoutIconsProps, } from '@elastic/eui/src/components/form/form_control_layout/form_control_layout_icons';

}
declare module '@elastic/eui/src/components/form/super_select/super_select.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiSuperSelectStyles: {
	    euiSuperSelect__listbox: import("@emotion/utils").SerializedStyles;
	};
	export const euiSuperSelectItemStyles: (euiThemeContext: UseEuiTheme) => {
	    euiSuperSelect__item: import("@emotion/utils").SerializedStyles;
	    hasDividers: import("@emotion/utils").SerializedStyles;
	};
	export const euiSuperSelectControlStyles: (euiThemeContext: UseEuiTheme) => {
	    euiSuperSelect__control: import("@emotion/utils").SerializedStyles;
	    open: import("@emotion/utils").SerializedStyles;
	    invalid: import("@emotion/utils").SerializedStyles;
	    disabled: import("@emotion/utils").SerializedStyles;
	    readOnly: import("@emotion/utils").SerializedStyles;
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	    formWidth: string;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    inGroup: import("@emotion/utils").SerializedStyles;
	    euiSuperSelect__placeholder: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/super_select/super_select_item' {
	import { FunctionComponent, ComponentProps, ReactNode } from 'react';
	import { EuiContextMenuItem } from '@elastic/eui/src/components/context_menu';
	export interface EuiSuperSelectOption<T> {
	    value: NonNullable<T>;
	    inputDisplay?: ReactNode;
	    dropdownDisplay?: ReactNode;
	    disabled?: boolean;
	    'data-test-subj'?: string;
	} type EuiSuperSelectItemProps = ComponentProps<typeof EuiContextMenuItem> & {
	    hasDividers?: boolean;
	};
	export const EuiSuperSelectItem: FunctionComponent<EuiSuperSelectItemProps>;
	export {};

}
declare module '@elastic/eui/src/components/form/super_select/super_select_control' {
	import { Ref, FunctionComponent, ButtonHTMLAttributes, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiFormControlLayoutProps } from '@elastic/eui/src/components/form/form_control_layout';
	import { type EuiSuperSelectOption } from '@elastic/eui/src/components/form/super_select/super_select_item';
	export interface EuiSuperSelectControlProps<T> extends CommonProps, Omit<ButtonHTMLAttributes<HTMLButtonElement>, 'value' | 'placeholder'> {
	    buttonRef?: Ref<HTMLButtonElement>;
	    /**
	     * @default false
	     */
	    compressed?: boolean;
	    /**
	     * Expand to fill 100% of the parent.
	     * Defaults to `fullWidth` prop of `<EuiForm>`.
	     * @default false
	     */
	    fullWidth?: boolean;
	    /**
	     * @default false
	     */
	    isInvalid?: boolean;
	    /**
	     * @default false
	     */
	    isLoading?: boolean;
	    readOnly?: boolean;
	    name?: string;
	    placeholder?: ReactNode;
	    value?: T;
	    options?: Array<EuiSuperSelectOption<T>>;
	    /**
	     * Creates an input group with element(s) coming before input.
	     * `string` | `ReactElement` or an array of these
	     */
	    prepend?: EuiFormControlLayoutProps['prepend'];
	    /**
	     * Creates an input group with element(s) coming after input.
	     * `string` | `ReactElement` or an array of these
	     */
	    append?: EuiFormControlLayoutProps['append'];
	}
	export const EuiSuperSelectControl: <T = string>(props: EuiSuperSelectControlProps<T> & {
	    isDropdownOpen?: boolean;
	}) => ReturnType<FunctionComponent<EuiSuperSelectControlProps<T>>>;

}
declare module '@elastic/eui/src/components/form/super_select/super_select' {
	import React, { Component, FocusEvent, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { type EuiInputPopoverProps } from '@elastic/eui/src/components/popover';
	import { type EuiContextMenuItemLayoutAlignment } from '@elastic/eui/src/components/context_menu';
	import { type EuiSuperSelectControlProps } from '@elastic/eui/src/components/form/super_select/super_select_control';
	import { type EuiSuperSelectOption } from '@elastic/eui/src/components/form/super_select/super_select_item'; enum ShiftDirection {
	    BACK = "back",
	    FORWARD = "forward"
	}
	export type EuiSuperSelectProps<T = string> = CommonProps & Omit<EuiSuperSelectControlProps<T>, 'onChange' | 'onClick' | 'onFocus' | 'onBlur' | 'options' | 'value'> & {
	    /**
	     * Pass an array of options that must at least include:
	     * `value`: storing unique value of item,
	     * `inputDisplay`: what shows inside the form input when selected
	     * `dropdownDisplay` (optional): what shows for the item in the dropdown
	     */
	    options: Array<EuiSuperSelectOption<T>>;
	    valueOfSelected?: NonNullable<T>;
	    /**
	     * Placeholder to display when the current selected value is empty.
	     */
	    placeholder?: ReactNode;
	    /**
	     * Classes for the context menu item
	     */
	    itemClassName?: string;
	    /**
	     * You must pass an `onChange` function to handle the update of the value
	     */
	    onChange?: (value: T) => void;
	    onFocus?: (event?: FocusEvent) => void;
	    onBlur?: (event?: FocusEvent) => void;
	    /**
	     * Change to `true` if you want horizontal lines between options.
	     * This is best used when options are multi-line.
	     */
	    hasDividers?: boolean;
	    /**
	     * Change `EuiContextMenuItem` layout position of icon
	     */
	    itemLayoutAlign?: EuiContextMenuItemLayoutAlignment;
	    /**
	     * Controls whether the options are shown. Default: false
	     */
	    isOpen?: boolean;
	    /**
	     * Optional props to pass to the underlying [EuiInputPopover](/#/layout/popover#popover-attached-to-input-element).
	     * Allows fine-grained control of the popover dropdown menu, including
	     * `repositionOnScroll` for EuiSuperSelects used within scrollable containers,
	     * and customizing popover panel styling.
	     *
	     * Does not accept a nested `popoverProps.isOpen` property - use the top level
	     * `isOpen` API instead.
	     */
	    popoverProps?: Partial<CommonProps & Omit<EuiInputPopoverProps, 'isOpen'>>;
	};
	export class EuiSuperSelect<T = string> extends Component<EuiSuperSelectProps<T>> {
	    static defaultProps: {
	        hasDividers: boolean;
	        fullWidth: boolean;
	        compressed: boolean;
	        isInvalid: boolean;
	        isLoading: boolean;
	    };
	    private itemNodes;
	    private _isMounted;
	    private controlButtonRef;
	    describedById: string;
	    state: {
	        isPopoverOpen: boolean;
	    };
	    componentDidMount(): void;
	    componentWillUnmount(): void;
	    setItemNode: (node: HTMLButtonElement | null, index: number) => void;
	    openPopover: () => void;
	    closePopover: () => void;
	    itemClicked: (value: T) => void;
	    onSelectKeyDown: (event: React.KeyboardEvent<HTMLButtonElement>) => void;
	    onItemKeyDown: (event: React.KeyboardEvent<HTMLButtonElement>) => void;
	    focusItemAt(index: number, direction?: ShiftDirection): void;
	    shiftFocus(direction: ShiftDirection): void;
	    render(): React.JSX.Element;
	}
	export {};

}
declare module '@elastic/eui/src/components/form/super_select' {
	export type { EuiSuperSelectProps } from '@elastic/eui/src/components/form/super_select/super_select';
	export { EuiSuperSelect } from '@elastic/eui/src/components/form/super_select/super_select';
	export type { EuiSuperSelectOption } from '@elastic/eui/src/components/form/super_select/super_select_item';
	export type { EuiSuperSelectControlProps } from '@elastic/eui/src/components/form/super_select/super_select_control';
	export { EuiSuperSelectControl } from '@elastic/eui/src/components/form/super_select/super_select_control';

}
declare module '@elastic/eui/src/components/color_picker/utils' {
	import chroma, { ColorSpaces } from 'chroma-js';
	import type { PaletteColorStop } from '@elastic/eui/src/components/color_picker/color_palette_picker';
	export const getEventPosition: (location: {
	    x: number;
	    y: number;
	}, container: HTMLElement) => {
	    left: number;
	    top: number;
	    width: number;
	    height: number;
	};
	export const HEX_FALLBACK = "";
	export const HSV_FALLBACK: ColorSpaces['hsv'];
	export const RGB_FALLBACK: ColorSpaces['rgba'];
	export const RGB_JOIN = ", ";
	export const parseColor: (input?: string | null | undefined) => string | number[] | null;
	export const chromaValid: (color: string | number[]) => boolean;
	export const getChromaColor: (input?: string | null | undefined, allowOpacity?: boolean) => chroma.Color | null;
	export const getLinearGradient: (palette: string[] | PaletteColorStop[]) => string;
	export const getFixedLinearGradient: (palette: string[] | PaletteColorStop[]) => {
	    color: string;
	    width: string;
	}[];

}
declare module '@elastic/eui/src/components/color_picker/color_palette_display/color_palette_display_fixed.styles' {
	export const euiColorPaletteDisplayFixed__bleedArea: import("@emotion/utils").SerializedStyles;

}
declare module '@elastic/eui/src/components/color_picker/color_palette_display/color_palette_display_fixed' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiColorPaletteDisplayShared } from '@elastic/eui/src/components/color_picker/color_palette_display/color_palette_display';
	export interface EuiColorPaletteDisplayFixedProps extends HTMLAttributes<HTMLSpanElement>, CommonProps, EuiColorPaletteDisplayShared {
	}
	export const EuiColorPaletteDisplayFixed: FunctionComponent<EuiColorPaletteDisplayFixedProps>;

}
declare module '@elastic/eui/src/components/color_picker/color_palette_display/color_palette_display_gradient' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiColorPaletteDisplayShared } from '@elastic/eui/src/components/color_picker/color_palette_display/color_palette_display';
	export interface EuiColorPaletteDisplayGradientProps extends HTMLAttributes<HTMLSpanElement>, CommonProps, EuiColorPaletteDisplayShared {
	}
	export const EuiColorPaletteDisplayGradient: FunctionComponent<EuiColorPaletteDisplayGradientProps>;

}
declare module '@elastic/eui/src/components/color_picker/color_palette_display/color_palette_display.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiColorPaletteDisplayStyles: (euiThemeContext: UseEuiTheme) => {
	    euiColorPaletteDisplay: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/color_picker/color_palette_display/color_palette_display' {
	import { FunctionComponent } from 'react';
	import { ExclusiveUnion } from '@elastic/eui/src/components/common';
	import type { PaletteColorStop } from '@elastic/eui/src/components/color_picker/color_palette_picker';
	import { EuiColorPaletteDisplayFixedProps } from '@elastic/eui/src/components/color_picker/color_palette_display/color_palette_display_fixed';
	import { EuiColorPaletteDisplayGradientProps } from '@elastic/eui/src/components/color_picker/color_palette_display/color_palette_display_gradient';
	export const SIZES: readonly ["xs", "s", "m"];
	export type EuiColorPaletteDisplaySize = (typeof SIZES)[number];
	export interface EuiColorPaletteDisplayShared {
	    /**
	     * Array of color `strings` or an array of #PaletteColorStop. The stops must be numbers in an ordered range.
	     */
	    palette: string[] | PaletteColorStop[];
	}
	interface DisplayGradient extends EuiColorPaletteDisplayGradientProps {
	    /**
	     *   Specify the type of palette.
	     *  `gradient`: each color fades into the next.
	     */
	    type: 'gradient';
	}
	interface DisplayFixed extends EuiColorPaletteDisplayFixedProps {
	    /**
	     *  `fixed`: individual color blocks.
	     */
	    type?: 'fixed';
	}
	export type EuiColorPaletteDisplayProps = {
	    /**
	     * Height of the palette display
	     */
	    size?: EuiColorPaletteDisplaySize;
	} & ExclusiveUnion<DisplayFixed, DisplayGradient>;
	export const EuiColorPaletteDisplay: FunctionComponent<EuiColorPaletteDisplayProps>;
	export {};

}
declare module '@elastic/eui/src/components/color_picker/color_palette_display' {
	export type { EuiColorPaletteDisplayProps } from '@elastic/eui/src/components/color_picker/color_palette_display/color_palette_display';
	export { EuiColorPaletteDisplay } from '@elastic/eui/src/components/color_picker/color_palette_display/color_palette_display';
	export type { EuiColorPaletteDisplayFixedProps } from '@elastic/eui/src/components/color_picker/color_palette_display/color_palette_display_fixed';
	export { EuiColorPaletteDisplayFixed } from '@elastic/eui/src/components/color_picker/color_palette_display/color_palette_display_fixed';
	export type { EuiColorPaletteDisplayGradientProps } from '@elastic/eui/src/components/color_picker/color_palette_display/color_palette_display_gradient';
	export { EuiColorPaletteDisplayGradient } from '@elastic/eui/src/components/color_picker/color_palette_display/color_palette_display_gradient';

}
declare module '@elastic/eui/src/components/color_picker/color_palette_picker/color_palette_picker' {
	import { FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { type EuiSuperSelectProps } from '@elastic/eui/src/components/form/super_select';
	export interface PaletteColorStop {
	    stop: number;
	    color: string;
	}
	export interface EuiColorPalettePickerPaletteTextProps extends CommonProps {
	    /**
	     *  For storing unique value of item
	     */
	    value: string;
	    /**
	     *  The name of your palette
	     */
	    title: string;
	    /**
	     * `text`: a text only option (a title is required).
	     */
	    type: 'text';
	    /**
	     * Array of color `strings` or an array of #PaletteColorStop. The stops must be numbers in an ordered range.
	     */
	    palette?: string[] | PaletteColorStop[];
	}
	export interface EuiColorPalettePickerPaletteFixedProps extends CommonProps {
	    /**
	     *  For storing unique value of item
	     */
	    value: string;
	    /**
	     *  The name of your palette
	     */
	    title?: string;
	    /**
	     * `fixed`: individual color blocks
	     */
	    type: 'fixed';
	    /**
	     * Array of color `strings` or an array of #PaletteColorStop. The stops must be numbers in an ordered range.
	     */
	    palette: string[] | PaletteColorStop[];
	}
	export interface EuiColorPalettePickerPaletteGradientProps extends CommonProps {
	    /**
	     *  For storing unique value of item
	     */
	    value: string;
	    /**
	     *  The name of your palette
	     */
	    title?: string;
	    /**
	     * `gradient`: each color fades into the next
	     */
	    type: 'gradient';
	    /**
	     * Array of color `strings` or an array of #PaletteColorStop. The stops must be numbers in an ordered range.
	     */
	    palette: string[] | PaletteColorStop[];
	}
	export type EuiColorPalettePickerPaletteProps = EuiColorPalettePickerPaletteTextProps | EuiColorPalettePickerPaletteFixedProps | EuiColorPalettePickerPaletteGradientProps;
	export type EuiColorPalettePickerProps<T extends string> = CommonProps & Omit<EuiSuperSelectProps<T>, 'options' | 'itemLayoutAlign' | 'hasDividers'> & {
	    /**
	     *  Specify what should be displayed after a selection: a `palette` or `title`
	     */
	    selectionDisplay?: 'palette' | 'title';
	    /**
	     * An array of one of the following objects: #EuiColorPalettePickerPaletteText, #EuiColorPalettePickerPaletteFixed, #EuiColorPalettePickerPaletteGradient
	     */
	    palettes: EuiColorPalettePickerPaletteProps[];
	};
	export const EuiColorPalettePicker: FunctionComponent<EuiColorPalettePickerProps<string>>;

}
declare module '@elastic/eui/src/components/color_picker/color_palette_picker' {
	export type { EuiColorPalettePickerProps, EuiColorPalettePickerPaletteTextProps, EuiColorPalettePickerPaletteFixedProps, EuiColorPalettePickerPaletteGradientProps, EuiColorPalettePickerPaletteProps, PaletteColorStop, } from '@elastic/eui/src/components/color_picker/color_palette_picker/color_palette_picker';
	export { EuiColorPalettePicker } from '@elastic/eui/src/components/color_picker/color_palette_picker/color_palette_picker';

}
declare module '@elastic/eui/src/services/color/stepped_gradient' {
	import { PaletteColorStop } from '@elastic/eui/src/components/color_picker/color_palette_picker';
	export const getSteppedGradient: (colors: PaletteColorStop[], steps: number) => string[];

}
declare module '@elastic/eui/src/services/color/manipulation' {
	import { EuiThemeColorModeStandard } from '@elastic/eui/src/services/theme';
	/**
	 * Makes a color more transparent.
	 * @param color - Color to manipulate
	 * @param alpha - alpha channel value. From 0-1.
	 */
	export const transparentize: (color: string, alpha: number) => string;
	/**
	 * Mixes a provided color with white.
	 * @param color - Color to mix with white
	 * @param ratio - Mix weight. From 0-1. Larger value indicates more white.
	 */
	export const tint: (color: string, ratio: number) => string;
	/**
	 * Mixes a provided color with black.
	 * @param color - Color to mix with black
	 * @param ratio - Mix weight. From 0-1. Larger value indicates more black.
	 */
	export const shade: (color: string, ratio: number) => string;
	/**
	 * Returns the tinted color for light mode and shaded color for dark mode
	 * @param color - Color to mix with white
	 * @param ratio - Mix weight. From 0-1. Larger value indicates more white.
	 * @param colorMode - Light or dark only
	 */
	export const tintOrShade: (color: string, ratio: number, colorMode: EuiThemeColorModeStandard) => string;
	/**
	 * Returns the shaded color for light mode and tinted color for dark mode
	 * @param color - Color to mix with white
	 * @param ratio - Mix weight. From 0-1. Larger value indicates more white.
	 * @param colorMode - Light or dark only
	 */
	export const shadeOrTint: (color: string, ratio: number, colorMode: EuiThemeColorModeStandard) => string;
	/**
	 * Increases the saturation of a color by manipulating the hsl saturation.
	 * @param color - Color to manipulate
	 * @param amount - Amount to change in absolute terms. 0-1.
	 */
	export const saturate: (color: string, amount: number) => string;
	/**
	 * Decreases the saturation of a color by manipulating the hsl saturation.
	 * @param color - Color to manipulate
	 * @param amount - Amount to change in absolute terms. 0-1.
	 */
	export const desaturate: (color: string, amount: number) => string;
	/**
	 * Returns the lightness value of a color. 0-100
	 * @param color
	 */
	export const lightness: (color: string) => number;
	/**
	 * Returns the darken value of a color. 0-100
	 * @param color - Color to manipulate
	 * @param amount - Amount to change in absolute terms. 0-1.
	 */
	export const darken: (color: string, amount: number) => string;
	/**
	 * Returns the brighten value of a color. 0-100
	 * @param color - Color to manipulate
	 * @param amount - Amount to change in absolute terms. 0-1.
	 */
	export const brighten: (color: string, amount: number) => string;

}
declare module '@elastic/eui/src/services/color/contrast' {
	export const wcagContrastMin = 4.5;
	/**
	 * Creates a new color that meets or exceeds WCAG level AA
	 * @param foreground - Color to manipulate
	 * @param ratio - Amount to change in absolute terms. 0-10.
	 * *
	 * @param themeOrBackground - Color to use as the contrast basis or just pass EuiTheme
	 */
	export const makeHighContrastColor: (_foreground: string, ratio?: number) => (themeOrBackground: string | {
	    [key: string]: any;
	    colors: {
	        body: string;
	    };
	}) => string;
	/**
	 * Creates a new color with increased contrast
	 * Disabled content only needs a contrast of at least 2 because there is no interaction available
	 * @param foreground - Color to manipulate
	 * @param ratio - Amount to change in absolute terms. 0-10.
	 * *
	 * @param themeOrBackground - Color to use as the contrast basis
	 */
	export const makeDisabledContrastColor: (color: string, ratio?: number) => (themeOrBackground: string | {
	    [key: string]: any;
	    colors: {
	        body: string;
	    };
	}) => string;

}
declare module '@elastic/eui/src/services/color' {
	export { isColorDark } from '@elastic/eui/src/services/color/is_color_dark';
	export { isValidHex } from '@elastic/eui/src/services/color/is_valid_hex';
	export { hexToHsv } from '@elastic/eui/src/services/color/hex_to_hsv';
	export { hexToRgb } from '@elastic/eui/src/services/color/hex_to_rgb';
	export { hsvToHex } from '@elastic/eui/src/services/color/hsv_to_hex';
	export { hsvToRgb } from '@elastic/eui/src/services/color/hsv_to_rgb';
	export { rgbToHex } from '@elastic/eui/src/services/color/rgb_to_hex';
	export { rgbToHsv } from '@elastic/eui/src/services/color/rgb_to_hsv';
	export { calculateContrast, calculateLuminance, } from '@elastic/eui/src/services/color/luminance_and_contrast';
	export { VISUALIZATION_COLORS, DEFAULT_VISUALIZATION_COLOR, } from '@elastic/eui/src/services/color/visualization_colors';
	export { colorPalette } from '@elastic/eui/src/services/color/color_palette';
	export { euiPaletteForLightBackground, euiPaletteForDarkBackground, euiPaletteColorBlind, euiPaletteColorBlindBehindText, euiPaletteForStatus, euiPaletteForTemperature, euiPaletteComplementary, euiPaletteRed, euiPaletteGreen, euiPaletteCool, euiPaletteWarm, euiPaletteGray, } from '@elastic/eui/src/services/color/eui_palettes';
	export type { rgbDef, HSV, RGB } from '@elastic/eui/src/services/color/color_types';
	export { getSteppedGradient } from '@elastic/eui/src/services/color/stepped_gradient';
	export * from '@elastic/eui/src/services/color/manipulation';
	export * from '@elastic/eui/src/services/color/contrast';

}
declare module '@elastic/eui/src/themes/amsterdam/global_styling/variables/_colors' {
	import { _EuiThemeColors, _EuiThemeBrandColors, _EuiThemeBrandTextColors, _EuiThemeShadeColors, _EuiThemeSpecialColors, _EuiThemeTextColors, _EuiThemeColorsMode } from '@elastic/eui/src/global_styling/variables/colors';
	export const brand_colors: _EuiThemeBrandColors;
	export const brand_text_colors: _EuiThemeBrandTextColors;
	export const shade_colors: _EuiThemeShadeColors;
	export const special_colors: _EuiThemeSpecialColors;
	export const text_colors: _EuiThemeTextColors;
	export const light_colors: _EuiThemeColorsMode;
	export const dark_shades: _EuiThemeShadeColors;
	export const dark_colors_ams: _EuiThemeColorsMode;
	export const colors: _EuiThemeColors;

}
declare module '@elastic/eui/src/themes/amsterdam/global_styling/variables/_animation' {
	import { _EuiThemeAnimationSpeeds, _EuiThemeAnimationEasings, _EuiThemeAnimation } from '@elastic/eui/src/global_styling/variables/animations';
	export const animation_speed: _EuiThemeAnimationSpeeds;
	export const animation_ease: _EuiThemeAnimationEasings;
	export const animation: _EuiThemeAnimation;

}
declare module '@elastic/eui/src/themes/amsterdam/global_styling/variables/_breakpoint' {
	import { _EuiThemeBreakpoints } from '@elastic/eui/src/global_styling/variables';
	export const breakpoint: _EuiThemeBreakpoints;

}
declare module '@elastic/eui/src/themes/amsterdam/global_styling/variables/_size' {
	import { _EuiThemeBase, _EuiThemeSizes } from '@elastic/eui/src/global_styling/variables';
	export const base: _EuiThemeBase;
	export const size: _EuiThemeSizes;

}
declare module '@elastic/eui/src/themes/amsterdam/global_styling/variables/_borders' {
	import { _EuiThemeBorder } from '@elastic/eui/src/global_styling/variables';
	export const border: _EuiThemeBorder;

}
declare module '@elastic/eui/src/themes/amsterdam/global_styling/variables/_levels' {
	import { _EuiThemeLevels } from '@elastic/eui/src/global_styling/variables';
	export const levels: _EuiThemeLevels;

}
declare module '@elastic/eui/src/themes/amsterdam/global_styling/variables/_typography' {
	import { _EuiThemeFont, _EuiThemeFontBase, _EuiThemeFontScales, _EuiThemeFontWeights } from '@elastic/eui/src/global_styling/variables/typography';
	export const fontScale: _EuiThemeFontScales;
	export const fontBase: _EuiThemeFontBase;
	export const fontWeight: _EuiThemeFontWeights;
	export const font: _EuiThemeFont;

}
declare module '@elastic/eui/src/themes/amsterdam/global_styling/variables/_states' {
	import { _EuiThemeFocus } from '@elastic/eui/src/global_styling/variables/states';
	export const focus: _EuiThemeFocus;

}
declare module '@elastic/eui/src/themes/amsterdam/theme' {
	import { EuiThemeShape } from '@elastic/eui/src/services/theme/types';
	export const AMSTERDAM_NAME_KEY = "EUI_THEME_AMSTERDAM";
	export const euiThemeAmsterdam: EuiThemeShape;
	export const EuiThemeAmsterdam: {
	    model: EuiThemeShape;
	    root: EuiThemeShape;
	    key: string;
	};

}
declare module '@elastic/eui/src/services/theme/context' {
	import { EuiThemeColorModeStandard, EuiThemeSystem, EuiThemeComputed, EuiThemeNested } from '@elastic/eui/src/services/theme/types';
	export const EuiSystemContext: import("react").Context<EuiThemeSystem<{}>>;
	export const EuiModificationsContext: import("react").Context<import ("@elastic/eui").RecursivePartial<import ("@elastic/eui/src/services/theme/types").EuiThemeShape>>;
	export const EuiColorModeContext: import("react").Context<EuiThemeColorModeStandard>;
	export const defaultComputedTheme: EuiThemeComputed<import ("@elastic/eui/src/services/theme/types").EuiThemeShape>;
	export const EuiThemeContext: import("react").Context<EuiThemeComputed<{}>>;
	export const EuiNestedThemeContext: import("react").Context<EuiThemeNested>;

}
declare module '@elastic/eui/src/services/theme/hooks' {
	import React from 'react';
	import { EuiThemeColorModeStandard, EuiThemeModifications, EuiThemeComputed } from '@elastic/eui/src/services/theme/types';
	/**
	 * Hook for function components
	 */
	export interface UseEuiTheme<T extends {} = {}> {
	    euiTheme: EuiThemeComputed<T>;
	    colorMode: EuiThemeColorModeStandard;
	    modifications: EuiThemeModifications<T>;
	}
	export const useEuiTheme: <T extends {} = {}>() => UseEuiTheme<T>;
	/**
	 * HOC for class components
	 */
	export interface WithEuiThemeProps<P extends {} = {}> {
	    theme: UseEuiTheme<P>;
	}
	export const withEuiTheme: <T extends {} = {}, U extends {} = {}>(Component: React.ComponentType<T & WithEuiThemeProps<U>>) => React.ForwardRefExoticComponent<React.PropsWithoutRef<Omit<T, "theme">> & React.RefAttributes<Omit<T, "theme">>>;
	/**
	 * Render prop alternative for complex class components
	 * Most useful for scenarios where a HOC may interfere with typing
	 */
	export const RenderWithEuiTheme: <T extends {} = {}>({ children, }: {
	    children: (theme: UseEuiTheme) => React.ReactElement;
	}) => React.ReactElement<any, string | React.JSXElementConstructor<any>>;
	/**
	 * Minor syntactical sugar hook for theme CSS variables.
	 * Primarily meant for internal EUI usage.
	 */
	export const useEuiThemeCSSVariables: () => {
	    setGlobalCSSVariables: Function;
	    globalCSSVariables: import("@emotion/serialize").CSSObject | undefined;
	    setNearestThemeCSSVariables: Function;
	    themeCSSVariables: import("@emotion/serialize").CSSObject | undefined;
	};

}
declare module '@elastic/eui/src/services/breakpoint/current_breakpoint' {
	import React, { FunctionComponent, PropsWithChildren } from 'react';
	import { _EuiThemeBreakpoint } from '@elastic/eui/src/global_styling/variables/breakpoint'; type CurrentEuiBreakpoint = _EuiThemeBreakpoint | undefined;
	export const CurrentEuiBreakpointContext: React.Context<CurrentEuiBreakpoint>;
	/**
	 * Returns the current breakpoint based on window width.
	 * Typically only called by the top-level `EuiProvider` (to reduce the number
	 * of window resize listeners on the page). Also conditionally called if a
	 * nested `EuiThemeProvider` defines a `modify.breakpoint` override
	 */
	export const CurrentEuiBreakpointProvider: FunctionComponent<PropsWithChildren>;
	export {};

}
declare module '@elastic/eui/src/services/breakpoint/current_breakpoint_hook' {
	/**
	 * Hook util / syntactical sugar for useContext()
	 *
	 * This hook is in its own separate file to make mocking it
	 * as a testenv easy for Jest unit tests
	 */
	export const useCurrentEuiBreakpoint: () => string | undefined;

}
declare module '@elastic/eui/src/services/breakpoint/is_within_hooks' {
	import { _EuiThemeBreakpoint } from '@elastic/eui/src/global_styling/variables/breakpoint';
	/**
	 * Given an array of breakpoint keys, this hook returns true or false
	 * if the breakpoint size of the current window width falls within
	 * any of the named breakpoints.
	 *
	 * @param {EuiThemeBreakpoint[]} sizes An array of named EUI breakpoints
	 * @param {boolean} isResponsive Some components have the option to turn off responsive behavior.
	 *   Since hooks can't be called conditionally, it's easier to pass the condition into the hook
	 * @returns {boolean} Returns `true` if current breakpoint name is included in `sizes`
	 */
	export const useIsWithinBreakpoints: (sizes: _EuiThemeBreakpoint[], isResponsive?: boolean) => boolean;
	/**
	 * Given a max breakpoint key, this hook returns true if the breakpoint size
	 * of the current window width falls within the max breakpoint or any below,
	 * and false otherwise
	 *
	 * @param {EuiThemeBreakpoint} max The named max breakpoint to check against
	 * @returns {boolean} Will return `false` if it can't find a value for the `max` breakpoint
	 */
	export function useIsWithinMaxBreakpoint(max: _EuiThemeBreakpoint): boolean;
	/**
	 * Given a min breakpoint key, this hook returns true if the breakpoint size
	 * of the current window width falls within the min breakpoint or any above,
	 * and false otherwise
	 *
	 * @param {EuiThemeBreakpoint} min The named min breakpoint to check against
	 * @returns {boolean} Will return `false` if it can't find a value for the `min` breakpoint
	 */
	export function useIsWithinMinBreakpoint(min: _EuiThemeBreakpoint): boolean;

}
declare module '@elastic/eui/src/services/breakpoint' {
	export type { _EuiThemeBreakpoint as EuiBreakpointSize } from '@elastic/eui/src/global_styling/variables/breakpoint';
	export * from '@elastic/eui/src/services/breakpoint/current_breakpoint';
	export * from '@elastic/eui/src/services/breakpoint/current_breakpoint_hook';
	export * from '@elastic/eui/src/services/breakpoint/is_within_hooks';

}
declare module '@elastic/eui/src/services/color_picker/color_picker' {
	interface colorStopsType {
	    stop: number;
	    color: string;
	}
	/**
	 * @deprecated
	 */
	export const useColorStopsState: (useRandomColor?: boolean, initialColorStops?: colorStopsType[]) => (string | colorStopsType[] | ((colorStops: colorStopsType[]) => void))[];
	export type EuiSetColorMethod = (text: string, { hex, isValid }: {
	    hex: string;
	    isValid: boolean;
	}) => void;
	export const useColorPickerState: (initialColor?: string) => [color: string, setColor: EuiSetColorMethod, errors: string[] | null];
	export {};

}
declare module '@elastic/eui/src/services/color_picker' {
	export type { EuiSetColorMethod } from '@elastic/eui/src/services/color_picker/color_picker';
	export { useColorPickerState, useColorStopsState } from '@elastic/eui/src/services/color_picker/color_picker';

}
declare module '@elastic/eui/src/services/console/warn_once' {
	export const warnOnce: (id: string, message: string) => void;

}
declare module '@elastic/eui/src/services/console' {
	export * from '@elastic/eui/src/services/console/warn_once';

}
declare module '@elastic/eui/src/services/copy/copy_to_clipboard' {
	export function copyToClipboard(text: string): boolean;

}
declare module '@elastic/eui/src/services/copy/tabular_copy' {
	import React, { PropsWithChildren } from 'react';
	/**
	 * Clipboard text cleaning logic
	 */
	export const CHARS: {
	    NEWLINE: string;
	    TAB: string;
	    TABULAR_CONTENT_BOUND: string;
	    NO_COPY_BOUND: string;
	};
	export const noCopyBoundsRegex: RegExp;
	export const onTabularCopy: (event: ClipboardEvent | React.ClipboardEvent) => void;
	export const tabularCopyMarkers: {
	    hiddenTab: React.JSX.Element;
	    hiddenNewline: React.JSX.Element;
	    hiddenWrapperBoundary: React.JSX.Element;
	    hiddenNoCopyBoundary: React.JSX.Element;
	};
	/**
	 * Wrapper setup around table/grid tabular content we want to override/clean up on copy
	 */
	export const OverrideCopiedTabularContent: ({ children, }: PropsWithChildren) => React.JSX.Element;

}
declare module '@elastic/eui/src/services/copy' {
	export { copyToClipboard } from '@elastic/eui/src/services/copy/copy_to_clipboard';
	export { tabularCopyMarkers, noCopyBoundsRegex, OverrideCopiedTabularContent, } from '@elastic/eui/src/services/copy/tabular_copy';

}
declare module '@elastic/eui/src/services/findElement' {
	/**
	 * A DOM node, a selector string (which will be passed to
	 * `document.querySelector()` to find the DOM node), or a function that
	 * returns a DOM node.
	 */
	export type ElementTarget = HTMLElement | string | (() => HTMLElement);
	export const findElementBySelectorOrRef: (elementTarget?: ElementTarget | undefined) => HTMLElement | null;

}
declare module '@elastic/eui/src/services/format/format_boolean' {
	export const formatBoolean: (value: boolean, { yes, no, nil }?: {
	    yes?: string | undefined;
	    no?: string | undefined;
	    nil?: string | undefined;
	}) => string;

}
declare module '@elastic/eui/src/services/format/format_date' {
	import moment from 'moment'; type CalendarOptions = moment.CalendarSpec & {
	    refTime?: moment.MomentInput;
	};
	export const dateFormatAliases: {
	    date: string;
	    longDate: string;
	    shortDate: string;
	    dateTime: string;
	    longDateTime: string;
	    shortDateTime: string;
	    dobShort: string;
	    dobLong: string;
	    iso8601: string;
	    calendar: (value: moment.MomentInput, options?: CalendarOptions) => string;
	    calendarDateTime: (value: moment.MomentInput, options: moment.CalendarSpec) => string;
	    calendarDate: (value: moment.MomentInput, options: moment.CalendarSpec) => string;
	}; type DateFormat = keyof typeof dateFormatAliases;
	interface FormatDateConfig {
	    format: DateFormat;
	    nil: string;
	    options: any;
	}
	export const formatDate: (value?: moment.MomentInput, dateFormatKeyOrConfig?: DateFormat | string | Partial<FormatDateConfig>) => string;
	export {};

}
declare module '@elastic/eui/src/services/format/format_number' {
	interface FormatNumberConfig {
	    format: string;
	    nil: string;
	    round: boolean;
	}
	export const formatNumber: (value?: number | null | undefined, numberFormatOrConfig?: string | Partial<FormatNumberConfig>) => string;
	export {};

}
declare module '@elastic/eui/src/services/format/format_text' {
	interface FormatTextOptions {
	    nil: string;
	}
	export const formatText: (value?: any, options?: Partial<FormatTextOptions>) => any;
	export {};

}
declare module '@elastic/eui/src/services/format/format_auto' {
	export const formatAuto: (value: any) => string;

}
declare module '@elastic/eui/src/services/format' {
	export { formatAuto } from '@elastic/eui/src/services/format/format_auto';
	export { formatBoolean } from '@elastic/eui/src/services/format/format_boolean';
	export { formatDate, dateFormatAliases } from '@elastic/eui/src/services/format/format_date';
	export { formatNumber } from '@elastic/eui/src/services/format/format_number';
	export { formatText } from '@elastic/eui/src/services/format/format_text';

}
declare module '@elastic/eui/src/services/number/number' {
	export const isWithinRange: (min: number | string, max: number | string, value: number | string) => boolean;
	export function isEvenlyDivisibleBy(num: number, factor: number): boolean;

}
declare module '@elastic/eui/src/services/number' {
	export * from '@elastic/eui/src/services/number/number';

}
declare module '@elastic/eui/src/services/paging/pager' {
	export class Pager {
	    currentPageIndex: number;
	    firstItemIndex: number;
	    itemsPerPage: number;
	    lastItemIndex: number;
	    totalItems: number;
	    totalPages: number;
	    constructor(totalItems: number, itemsPerPage: number, initialPageIndex?: number);
	    setTotalItems: (totalItems: number) => void;
	    setItemsPerPage: (itemsPerPage: number) => void;
	    isPageable: () => boolean;
	    getTotalPages: () => number;
	    getCurrentPageIndex: () => number;
	    getFirstItemIndex: () => number;
	    getLastItemIndex: () => number;
	    hasNextPage: () => boolean;
	    hasPreviousPage: () => boolean;
	    goToNextPage: () => void;
	    goToPreviousPage: () => void;
	    goToPageIndex: (pageIndex: number) => void;
	    update: () => void;
	}

}
declare module '@elastic/eui/src/services/paging' {
	export { Pager } from '@elastic/eui/src/services/paging/pager';

}
declare module '@elastic/eui/src/services/security/get_secure_rel_for_target' {
	/**
	 * Secures outbound links. For more info:
	 * https://www.jitbit.com/alexblog/256-targetblank---the-most-underestimated-vulnerability-ever/
	 */
	export const getSecureRelForTarget: ({ target, rel, }: {
	    href?: string | undefined;
	    target?: string | undefined;
	    rel?: string | undefined;
	}) => string;

}
declare module '@elastic/eui/src/services/security' {
	export { getSecureRelForTarget } from '@elastic/eui/src/services/security/get_secure_rel_for_target';

}
declare module '@elastic/eui/src/services/sort/sort_direction' {
	import PropTypes from 'prop-types'; const ASC: "asc"; const DESC: "desc";
	export type Direction = typeof ASC | typeof DESC;
	export const SortDirection: Readonly<{
	    ASC: "asc";
	    DESC: "desc";
	    isAsc(direction: Direction): boolean;
	    reverse(direction: Direction): "desc" | "asc";
	}>;
	export const SortDirectionType: PropTypes.Requireable<"desc" | "asc">;
	export {};

}
declare module '@elastic/eui/src/services/objects' {
	export const get: (object: {}, path: string[] | string, defaultValue?: any) => any;
	export const omit: (object: {} | null | undefined, paths: string[]) => Partial<{}>;

}
declare module '@elastic/eui/src/services/sort/comparators' {
	export type Primitive = string | boolean | number | null | undefined; type Comparator<T = Primitive> = (a: T, b: T) => number;
	export const Comparators: Readonly<{
	    default: (direction?: 'asc' | 'desc') => (v1: Primitive, v2: Primitive) => number;
	    reverse: <T>(comparator: Comparator<T>) => Comparator<T>;
	    value<T_1>(valueCallback: (value: T_1) => Primitive, comparator?: Comparator<Primitive> | undefined): Comparator<T_1>;
	    property<T_2 extends object>(prop: string, comparator?: Comparator<Primitive> | undefined): Comparator<T_2>;
	}>;
	export {};

}
declare module '@elastic/eui/src/services/sort/sortable_properties' {
	import { Primitive } from '@elastic/eui/src/services/sort/comparators';
	export interface SortableProperty<T> {
	    name: string;
	    getValue: (obj: T) => Primitive;
	    isAscending: boolean;
	}
	/**
	 * @typedef {Object} SortableProperty
	 * @property {string} sortableProperty.name - Name of the property.
	 * @property {function} sortableProperty.getValue - A function that takes in an object and returns a value to sort
	 * by.
	 * @property {boolean} sortableProperty.isAscending - The direction of the last sort by this property. Used to preserve
	 * past sort orders.
	 */
	/**
	 * Stores sort information for a set of SortableProperties, including which property is currently being sorted on, as
	 * well as the last sort order for each property.
	 */
	export class SortableProperties<T> {
	    sortableProperties: Array<SortableProperty<T>>;
	    currentSortedProperty: SortableProperty<T>;
	    /**
	     * @param {Array<SortableProperty>} sortableProperties - a set of sortable properties.
	     * @param {string} initialSortablePropertyName - Which sort property should be sorted on by default.
	     */
	    constructor(sortableProperties: Array<SortableProperty<T>>, initialSortablePropertyName: string);
	    /**
	     * @returns {SortableProperty} The current property that is being sorted on. Undefined if no sort order is applied.
	     */
	    getSortedProperty(): SortableProperty<T>;
	    /**
	     * Sorts the items passed in and returns a newly sorted array.
	     * @param items {Array.<Object>}
	     * @returns {Array.<Object>} sorted array of items, based off the sort properties.
	     */
	    sortItems(items: T[]): T[];
	    /**
	     * Returns the SortProperty with the given name, if found.
	     * @param {String} propertyName
	     * @returns {SortableProperty|undefined}
	     */
	    getSortablePropertyByName(propertyName: string): SortableProperty<T> | undefined;
	    /**
	     * Updates the sort property, potentially flipping the sort order based on whether the same
	     * property was already being sorted.
	     * @param propertyName {String}
	     */
	    sortOn(propertyName: string): void;
	    /**
	     * @returns {boolean} True if the current sortable property is sorted in ascending order.
	     */
	    isCurrentSortAscending(): boolean;
	    /**
	     * @param {string} propertyName
	     * @returns {boolean} True if the given sort property is sorted in ascending order.
	     */
	    isAscendingByName(propertyName: string): boolean;
	    /**
	     * Flips the current sorted property sort order.
	     */
	    flipCurrentSortOrder(): void;
	}

}
declare module '@elastic/eui/src/services/sort/property_sort' {
	import PropTypes from 'prop-types';
	import { Direction } from '@elastic/eui/src/services/sort/sort_direction';
	export const PropertySortType: PropTypes.Requireable<PropTypes.InferProps<{
	    field: PropTypes.Validator<string>;
	    direction: PropTypes.Validator<"desc" | "asc">;
	}>>;
	export interface PropertySort {
	    field: string;
	    direction: Direction;
	}

}
declare module '@elastic/eui/src/services/sort' {
	export { SortableProperties } from '@elastic/eui/src/services/sort/sortable_properties';
	export type { Direction } from '@elastic/eui/src/services/sort/sort_direction';
	export { SortDirectionType, SortDirection } from '@elastic/eui/src/services/sort/sort_direction';
	export type { PropertySort } from '@elastic/eui/src/services/sort/property_sort';
	export { PropertySortType } from '@elastic/eui/src/services/sort/property_sort';
	export { Comparators } from '@elastic/eui/src/services/sort/comparators';

}
declare module '@elastic/eui/src/services/string/to_initials' {
	/**
	 * This function calculates the initials/acronym for a given name.
	 * It defaults to only 2 characters and will take the first character (of each word).
	 * If only one word is supplied for the name, it will only pass back the first letter of the word,
	 * unless forced to 2 letters by setting `initialsLength` to `2`.
	 * It will pass back the characters with the same casing as the original string
	 * unless otherwise specified.
	 *
	 * @param {string} name The full name of the item to turn into initials
	 * @param {number} initialsLength (Optional) How many characters to show (max 2 allowed)
	 * @param {string} initials (Optional) Custom initials (max 2 characters)
	 * @returns {string} True if the color is dark, false otherwise.
	 */
	export const MAX_INITIALS = 2;
	export function toInitials(name: string, initialsLength?: 1 | 2, initials?: string): string | null;

}
declare module '@elastic/eui/src/services/string/to_case' {
	/**
	 * This function returns the same string with the first letter of the first word capitalized.
	 *
	 * @param {string} string The input string
	 */
	export function toSentenceCase(string: string): string;

}
declare module '@elastic/eui/src/services/string/slugify' {
	/**
	 * Lowercases input and replaces spaces with hyphens:
	 * e.g. 'GridView Example' -> 'gridview-example'
	 *
	 * @param {string} string The starting string
	 * @returns {string} Lowercase, dashed version of the starting staring
	 */
	export function slugify(str: string): string;

}
declare module '@elastic/eui/src/services/string' {
	export { toInitials } from '@elastic/eui/src/services/string/to_initials';
	export { toSentenceCase } from '@elastic/eui/src/services/string/to_case';
	export { slugify } from '@elastic/eui/src/services/string/slugify';

}
declare module '@elastic/eui/src/services/transition/transition' {
	export const getTransitionTimings: (element: Element) => {
	    durationMatch: number;
	    delayMatch: number;
	};
	export const getWaitDuration: (records: MutationRecord[]) => number;
	export const performOnFrame: (waitDuration: number, toPerform: () => void) => void;
	export const getDurationAndPerformOnFrame: (records: MutationRecord[], toPerform: () => void) => void;

}
declare module '@elastic/eui/src/services/transition' {
	export { getDurationAndPerformOnFrame, getTransitionTimings, getWaitDuration, performOnFrame, } from '@elastic/eui/src/services/transition/transition';

}
declare module '@elastic/eui/src/services/window_event/window_event' {
	import { Component } from 'react'; type EventNames = keyof WindowEventMap;
	interface Props<Ev extends EventNames> {
	    event: Ev;
	    handler: (this: Window, ev: WindowEventMap[Ev]) => any;
	}
	export class EuiWindowEvent<E extends EventNames> extends Component<Props<E>> {
	    componentDidMount(): void;
	    componentDidUpdate(prevProps: Props<E>): void;
	    componentWillUnmount(): void;
	    addEvent<Ev extends EventNames>({ event, handler }: Props<Ev>): void;
	    removeEvent<Ev extends EventNames>({ event, handler }: Props<Ev>): void;
	    render(): null;
	}
	export {};

}
declare module '@elastic/eui/src/services/window_event' {
	export { EuiWindowEvent } from '@elastic/eui/src/services/window_event/window_event';

}
declare module '@elastic/eui/src/services' {
	import * as keys from '@elastic/eui/src/services/keys';
	export { htmlIdGenerator, useGeneratedHtmlId } from '@elastic/eui/src/services/accessibility';
	export { CENTER_ALIGNMENT, LEFT_ALIGNMENT, RIGHT_ALIGNMENT } from '@elastic/eui/src/services/alignment';
	export type { HorizontalAlignment } from '@elastic/eui/src/services/alignment';
	export { CurrentEuiBreakpointContext, CurrentEuiBreakpointProvider, useCurrentEuiBreakpoint, useIsWithinBreakpoints, useIsWithinMaxBreakpoint, useIsWithinMinBreakpoint, } from '@elastic/eui/src/services/breakpoint';
	export type { EuiBreakpointSize } from '@elastic/eui/src/services/breakpoint';
	export { CanvasTextUtils, type CanvasTextParams } from '@elastic/eui/src/services/canvas';
	export { brighten, calculateContrast, calculateLuminance, colorPalette, darken, DEFAULT_VISUALIZATION_COLOR, desaturate, euiPaletteColorBlind, euiPaletteColorBlindBehindText, euiPaletteComplementary, euiPaletteCool, euiPaletteForDarkBackground, euiPaletteForLightBackground, euiPaletteForStatus, euiPaletteForTemperature, euiPaletteGray, euiPaletteRed, euiPaletteGreen, euiPaletteWarm, getSteppedGradient, hexToHsv, hexToRgb, hsvToHex, hsvToRgb, isColorDark, isValidHex, lightness, makeDisabledContrastColor, makeHighContrastColor, rgbToHex, rgbToHsv, saturate, shade, shadeOrTint, tint, tintOrShade, transparentize, VISUALIZATION_COLORS, wcagContrastMin, } from '@elastic/eui/src/services/color';
	export type { HSV } from '@elastic/eui/src/services/color';
	export { useColorPickerState, useColorStopsState } from '@elastic/eui/src/services/color_picker';
	export type { EuiSetColorMethod } from '@elastic/eui/src/services/color_picker';
	export * from '@elastic/eui/src/services/console';
	export * from '@elastic/eui/src/services/copy';
	export * from '@elastic/eui/src/services/emotion';
	export * from '@elastic/eui/src/services/findElement';
	export { dateFormatAliases, formatAuto, formatBoolean, formatDate, formatNumber, formatText, } from '@elastic/eui/src/services/format';
	export * from '@elastic/eui/src/services/hooks';
	export { isEvenlyDivisibleBy, isWithinRange } from '@elastic/eui/src/services/number';
	export { Pager } from '@elastic/eui/src/services/paging';
	export { calculatePopoverPosition, findPopoverPosition } from '@elastic/eui/src/services/popover';
	export { getSecureRelForTarget } from '@elastic/eui/src/services/security';
	export { Comparators, PropertySortType, SortableProperties, SortDirection, SortDirectionType, } from '@elastic/eui/src/services/sort';
	export type { Direction, PropertySort } from '@elastic/eui/src/services/sort';
	export { slugify, toInitials, toSentenceCase } from '@elastic/eui/src/services/string';
	export * from '@elastic/eui/src/services/theme';
	export { throttle } from '@elastic/eui/src/services/throttle';
	export { getDurationAndPerformOnFrame, getTransitionTimings, getWaitDuration, performOnFrame, } from '@elastic/eui/src/services/transition';
	export { EuiWindowEvent } from '@elastic/eui/src/services/window_event';
	export { keys };

}
declare module '@elastic/eui/src/components/accessibility/screen_reader_only/screen_reader_only.styles' {
	export const euiScreenReaderOnly: () => string;
	export const euiScreenReaderOnlyStyles: {
	    euiScreenReaderOnly: import("@emotion/utils").SerializedStyles;
	    'euiScreenReaderOnly-showOnFocus': import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/accessibility/screen_reader_only/screen_reader_only' {
	import { ReactElement, FunctionComponent } from 'react';
	export interface EuiScreenReaderOnlyProps {
	    /**
	     * ReactElement to render as this component's content
	     */
	    children: ReactElement;
	    /**
	     * For keyboard navigation, force content to display visually upon focus/focus-within.
	     */
	    showOnFocus?: boolean;
	    className?: string;
	}
	export const EuiScreenReaderOnly: FunctionComponent<EuiScreenReaderOnlyProps>;

}
declare module '@elastic/eui/src/components/accessibility/screen_reader_only' {
	export type { EuiScreenReaderOnlyProps } from '@elastic/eui/src/components/accessibility/screen_reader_only/screen_reader_only';
	export { EuiScreenReaderOnly } from '@elastic/eui/src/components/accessibility/screen_reader_only/screen_reader_only';
	export { euiScreenReaderOnly } from '@elastic/eui/src/components/accessibility/screen_reader_only/screen_reader_only.styles';

}
declare module '@elastic/eui/src/components/accessibility/screen_reader_live/screen_reader_live' {
	import { AriaAttributes, HTMLAttributes, FunctionComponent, ReactNode } from 'react';
	export interface EuiScreenReaderLiveProps {
	    /**
	     * Whether to make screen readers aware of the content
	     */
	    isActive?: boolean;
	    /**
	     * Content for screen readers to announce
	     */
	    children?: ReactNode;
	    /**
	     * `role` attribute for both live regions.
	     *
	     * https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Live_Regions#roles_with_implicit_live_region_attributes
	     */
	    role?: HTMLAttributes<HTMLDivElement>['role'];
	    /**
	     * `aria-live` attribute for both live regions
	     */
	    'aria-live'?: AriaAttributes['aria-live'];
	    /**
	     * On `children`/text change, the region will auto-focus itself, causing screen readers
	     * to automatically read out the text content. This prop should primarily be used for
	     * navigation or page changes, where programmatically resetting focus location back to
	     * a certain part of the page is desired.
	     */
	    focusRegionOnTextChange?: boolean;
	}
	export const EuiScreenReaderLive: FunctionComponent<EuiScreenReaderLiveProps>;

}
declare module '@elastic/eui/src/components/accessibility/screen_reader_live' {
	export { EuiScreenReaderLive } from '@elastic/eui/src/components/accessibility/screen_reader_live/screen_reader_live';
	export type { EuiScreenReaderLiveProps } from '@elastic/eui/src/components/accessibility/screen_reader_live/screen_reader_live';

}
declare module '@elastic/eui/src/components/accessibility/skip_link/skip_link.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiSkipLinkStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiSkipLink: import("@emotion/utils").SerializedStyles;
	    absolute: import("@emotion/utils").SerializedStyles;
	    fixed: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/accessibility/skip_link/skip_link' {
	import { FunctionComponent, Ref } from 'react';
	import { EuiButtonProps } from '@elastic/eui/src/components/button/button';
	import { PropsForAnchor } from '@elastic/eui/src/components/common';
	export const POSITIONS: readonly ["static", "fixed", "absolute"]; type Positions = (typeof POSITIONS)[number];
	interface EuiSkipLinkInterface extends EuiButtonProps {
	    /**
	     * Change the display position of the element when focused.
	     * If 'fixed', the link will be fixed to the top left of the viewport
	     */
	    position?: Positions;
	    /**
	     * Typically an anchor id (e.g. `a11yMainContent`), the value provided
	     * will be prepended with a hash `#` and used as the link `href`
	     */
	    destinationId: string;
	    /**
	     * If no destination ID element exists or can be found, you may provide a query selector
	     * string to fall back to.
	     *
	     * For complex applications with potentially variable layouts per page, an array of
	     * query selectors can be passed, e.g. `['main', '[role=main]', '.appWrapper']`, which
	     * prioritizes looking for multiple fallbacks based on array order.
	     * @default main
	     */
	    fallbackDestination?: string | string[];
	    /**
	     * If default HTML anchor link behavior is not desired (e.g. for SPAs with hash routing),
	     * setting this flag to true will manually scroll to and focus the destination element
	     * without changing the browser URL's hash
	     */
	    overrideLinkBehavior?: boolean;
	    /**
	     * When position is fixed, this is forced to `0`
	     */
	    tabIndex?: number;
	}
	export type EuiSkipLinkProps = PropsForAnchor<EuiSkipLinkInterface, {
	    buttonRef?: Ref<HTMLAnchorElement>;
	}>;
	export const EuiSkipLink: FunctionComponent<EuiSkipLinkProps>;
	export {};

}
declare module '@elastic/eui/src/components/accessibility/skip_link' {
	export type { EuiSkipLinkProps } from '@elastic/eui/src/components/accessibility/skip_link/skip_link';
	export { EuiSkipLink } from '@elastic/eui/src/components/accessibility/skip_link/skip_link';

}
declare module '@elastic/eui/src/components/accessibility' {
	export { EuiScreenReaderLive } from '@elastic/eui/src/components/accessibility/screen_reader_live';
	export type { EuiScreenReaderLiveProps } from '@elastic/eui/src/components/accessibility/screen_reader_live';
	export { EuiScreenReaderOnly, euiScreenReaderOnly } from '@elastic/eui/src/components/accessibility/screen_reader_only';
	export type { EuiScreenReaderOnlyProps } from '@elastic/eui/src/components/accessibility/screen_reader_only';
	export { EuiSkipLink } from '@elastic/eui/src/components/accessibility/skip_link';
	export type { EuiSkipLinkProps } from '@elastic/eui/src/components/accessibility/skip_link';

}
declare module '@elastic/eui/src/components/accordion/accordion_trigger/accordion_button.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiAccordionButtonStyles: (euiThemeContext: UseEuiTheme) => {
	    euiAccordion__button: import("@emotion/utils").SerializedStyles;
	    disabled: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    arrowLeft: import("@emotion/utils").SerializedStyles;
	    arrowRight: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/accordion/accordion_trigger/accordion_button' {
	import { FunctionComponent, PropsWithChildren, HTMLAttributes } from 'react';
	import { EuiAccordionProps } from '@elastic/eui/src/components/accordion/accordion'; type _EuiAccordionButtonProps = PropsWithChildren & HTMLAttributes<HTMLElement> & Required<Pick<EuiAccordionProps, 'buttonElement'>> & Pick<EuiAccordionProps, 'buttonClassName' | 'buttonProps' | 'buttonContentClassName' | 'isDisabled' | 'arrowDisplay'>;
	export const EuiAccordionButton: FunctionComponent<_EuiAccordionButtonProps>;
	export {};

}
declare module '@elastic/eui/src/components/accordion/accordion_trigger/accordion_arrow.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiAccordionArrowStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiAccordion__arrow: import("@emotion/utils").SerializedStyles;
	    left: import("@emotion/utils").SerializedStyles;
	    right: import("@emotion/utils").SerializedStyles;
	    isClosed: import("@emotion/utils").SerializedStyles;
	    isOpen: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/accordion/accordion_trigger/accordion_arrow' {
	import { FunctionComponent } from 'react';
	import { EuiButtonIconPropsForButton } from '@elastic/eui/src/components/button';
	import { EuiAccordionProps } from '@elastic/eui/src/components/accordion/accordion'; type _EuiAccordionArrowProps = Partial<EuiButtonIconPropsForButton> & Pick<EuiAccordionProps, 'arrowDisplay' | 'arrowProps'> & {
	    isOpen: boolean;
	};
	export const EuiAccordionArrow: FunctionComponent<_EuiAccordionArrowProps>;
	export {};

}
declare module '@elastic/eui/src/components/accordion/accordion_trigger/accordion_trigger' {
	import { FunctionComponent, MouseEventHandler } from 'react';
	import { EuiAccordionProps } from '@elastic/eui/src/components/accordion/accordion'; type _EuiAccordionTriggerProps = Pick<EuiAccordionProps, 'arrowDisplay' | 'arrowProps' | 'buttonElement' | 'buttonClassName' | 'buttonProps' | 'buttonContent' | 'buttonContentClassName' | 'extraAction' | 'isDisabled'> & {
	    isOpen: boolean;
	    ariaControlsId: string;
	    buttonId: string;
	    onToggle: MouseEventHandler;
	};
	export const EuiAccordionTrigger: FunctionComponent<_EuiAccordionTriggerProps>;
	export {};

}
declare module '@elastic/eui/src/components/accordion/accordion_trigger' {
	export { EuiAccordionTrigger } from '@elastic/eui/src/components/accordion/accordion_trigger/accordion_trigger';

}
declare module '@elastic/eui/src/components/accordion/accordion_children/accordion_children_loading' {
	import { FunctionComponent } from 'react';
	import { EuiAccordionProps } from '@elastic/eui/src/components/accordion/accordion'; type _EuiAccordionChildrenLoadingProps = Pick<EuiAccordionProps, 'isLoadingMessage'>;
	export const EuiAccordionChildrenLoading: FunctionComponent<_EuiAccordionChildrenLoadingProps>;
	export {};

}
declare module '@elastic/eui/src/components/accordion/accordion_children/accordion_children.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiAccordionChildrenStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiAccordion__children: import("@emotion/utils").SerializedStyles;
	    isLoading: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    xl: import("@emotion/utils").SerializedStyles;
	};
	export const euiAccordionChildWrapperStyles: (euiThemeContext: UseEuiTheme) => {
	    euiAccordion__childWrapper: import("@emotion/utils").SerializedStyles;
	    isClosed: import("@emotion/utils").SerializedStyles;
	    isOpen: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/accordion/accordion_children/accordion_children' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { EuiAccordionProps } from '@elastic/eui/src/components/accordion/accordion'; type _EuiAccordionChildrenProps = HTMLAttributes<HTMLDivElement> & Pick<EuiAccordionProps, 'role' | 'children' | 'paddingSize' | 'isLoading' | 'isLoadingMessage'> & {
	    isOpen: boolean;
	};
	export const EuiAccordionChildren: FunctionComponent<_EuiAccordionChildrenProps>;
	export {};

}
declare module '@elastic/eui/src/components/accordion/accordion_children' {
	export { EuiAccordionChildren } from '@elastic/eui/src/components/accordion/accordion_children/accordion_children';

}
declare module '@elastic/eui/src/components/accordion/accordion.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiAccordionStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiAccordion: import("@emotion/utils").SerializedStyles;
	    borders: {
	        borders: import("@emotion/utils").SerializedStyles;
	        horizontal: import("@emotion/utils").SerializedStyles;
	        all: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/accordion/accordion' {
	import React, { Component, HTMLAttributes, ReactNode } from 'react';
	import { WithEuiThemeProps } from '@elastic/eui/src/services';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import type { EuiButtonIconProps } from '@elastic/eui/src/components/button';
	export const PADDING_SIZES: readonly ["none", "xs", "s", "m", "l", "xl"];
	export type EuiAccordionPaddingSize = (typeof PADDING_SIZES)[number];
	export type EuiAccordionProps = CommonProps & Omit<HTMLAttributes<HTMLElement>, 'id' | 'role'> & {
	    id: string;
	    /**
	     * Applied to the entire .euiAccordion wrapper.
	     * When using `fieldset`, it will enforce `buttonElement = legend` as well.
	     */
	    element?: 'div' | 'fieldset';
	    /**
	     * Defaults to the [group role](https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/group_role).
	     *
	     * If your accordion contains significant enough content to be a document
	     * [landmark role](https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/region_role#accessibility_concerns), consider using the `region` role instead.
	     * @default group
	     */
	    role?: HTMLAttributes<HTMLElement>['role'];
	    /**
	     * Class that will apply to the trigger for the accordion.
	     */
	    buttonClassName?: string;
	    /**
	     * Apply more props to the triggering button.
	     *
	     * Includes optional `paddingSize` prop which allows sizes of `s`, `m`, or `l`.
	     * Note: Padding will not be present on the side closest to the accordion arrow.
	     */
	    buttonProps?: CommonProps & HTMLAttributes<HTMLElement> & {
	        paddingSize?: 's' | 'm' | 'l';
	    };
	    /**
	     * Class that will apply to the trigger content for the accordion.
	     */
	    buttonContentClassName?: string;
	    /**
	     * The content of the clickable trigger
	     */
	    buttonContent?: ReactNode;
	    /**
	     * Applied to the main button receiving the `onToggle` event.
	     * Anything other than the default `button` does not support removing the arrow display (for accessibility of focus).
	     */
	    buttonElement?: 'div' | 'legend' | 'button';
	    /**
	     * Extra props to pass to the EuiButtonIcon containing the arrow.
	     */
	    arrowProps?: Partial<Omit<EuiButtonIconProps, 'iconType' | 'onClick' | 'aria-labelledby'>>;
	    /**
	     * Will appear right aligned against the button. Useful for separate actions like deletions.
	     */
	    extraAction?: ReactNode;
	    /**
	     * The accordion will start in the open state.
	     */
	    initialIsOpen?: boolean;
	    /**
	     * Optional callback method called on open and close with a single `isOpen` parameter
	     */
	    onToggle?: (isOpen: boolean) => void;
	    /**
	     * The padding around the exposed accordion content.
	     */
	    paddingSize?: EuiAccordionPaddingSize;
	    /**
	     * Placement of the arrow indicator, or 'none' to hide it.
	     */
	    arrowDisplay?: 'left' | 'right' | 'none';
	    /**
	     * Optional border styling. Defaults to 'none'.
	     */
	    borders?: 'horizontal' | 'all' | 'none';
	    /**
	     * Control the opening of accordion via prop
	     */
	    forceState?: 'closed' | 'open';
	    /**
	     * Change `extraAction` and children into a loading spinner
	     */
	    isLoading?: boolean;
	    /**
	     * Choose whether the loading message replaces the content. Customize the message by passing a node
	     */
	    isLoadingMessage?: boolean | ReactNode;
	    /**
	     * Disable the open/close interaction and visually subdues the trigger
	     */
	    isDisabled?: boolean;
	}; type EuiAccordionState = {
	    isOpen: boolean;
	};
	export class EuiAccordionClass extends Component<WithEuiThemeProps & EuiAccordionProps, EuiAccordionState> {
	    static defaultProps: {
	        initialIsOpen: boolean;
	        borders: "none";
	        paddingSize: "none";
	        arrowDisplay: "left";
	        isLoading: boolean;
	        isDisabled: boolean;
	        isLoadingMessage: boolean;
	        element: "div";
	        buttonElement: "button";
	        role: "group";
	    };
	    state: {
	        isOpen: boolean;
	    };
	    get isOpen(): boolean;
	    onToggle: () => void;
	    generatedId: string;
	    render(): React.JSX.Element;
	}
	export const EuiAccordion: React.ForwardRefExoticComponent<Omit<EuiAccordionProps, "theme"> & React.RefAttributes<Omit<EuiAccordionProps, "theme">>>;
	export {};

}
declare module '@elastic/eui/src/components/accordion' {
	export type { EuiAccordionProps } from '@elastic/eui/src/components/accordion/accordion';
	export { EuiAccordion } from '@elastic/eui/src/components/accordion/accordion';

}
declare module '@elastic/eui/src/components/aspect_ratio/aspect_ratio' {
	import { FunctionComponent, HTMLAttributes, ReactElement, CSSProperties } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiAspectRatioProps = HTMLAttributes<HTMLDivElement> & CommonProps & {
	    /**
	     * Aspect ratio height. For example 9 would be widescreen video.
	     */
	    height: number;
	    /**
	     * Aspect ratio width. For example 16 would be widescreen video.
	     */
	    width: number;
	    /**
	     * The maximum width you want the child to stretch to.
	     */
	    maxWidth?: CSSProperties['width'];
	    children: ReactElement<any>;
	};
	export const EuiAspectRatio: FunctionComponent<EuiAspectRatioProps>;

}
declare module '@elastic/eui/src/components/aspect_ratio' {
	export type { EuiAspectRatioProps } from '@elastic/eui/src/components/aspect_ratio/aspect_ratio';
	export { EuiAspectRatio } from '@elastic/eui/src/components/aspect_ratio/aspect_ratio';

}
declare module '@elastic/eui/src/components/auto_sizer/auto_sizer' {
	import type { ComponentProps } from 'react';
	import type { Size, HorizontalSize, VerticalSize } from 'react-virtualized-auto-sizer';
	export type EuiAutoSizerProps = ComponentProps<typeof AutoSizer>;
	export type EuiAutoSize = Size;
	export type EuiAutoSizeHorizontal = HorizontalSize;
	export type EuiAutoSizeVertical = VerticalSize;
	import AutoSizer from 'react-virtualized-auto-sizer';
	export class EuiAutoSizer extends AutoSizer {
	}

}
declare module '@elastic/eui/src/components/auto_sizer' {
	export * from '@elastic/eui/src/components/auto_sizer/auto_sizer';

}
declare module '@elastic/eui/src/components/avatar/avatar.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiAvatarStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiAvatar: import("@emotion/utils").SerializedStyles;
	    plain: import("@emotion/utils").SerializedStyles;
	    subdued: import("@emotion/utils").SerializedStyles;
	    user: import("@emotion/utils").SerializedStyles;
	    space: import("@emotion/utils").SerializedStyles;
	    isDisabled: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    xl: import("@emotion/utils").SerializedStyles;
	    capitalize: import("@emotion/utils").SerializedStyles;
	    uppercase: import("@emotion/utils").SerializedStyles;
	    lowercase: import("@emotion/utils").SerializedStyles;
	    none: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/avatar/avatar' {
	import { HTMLAttributes, FunctionComponent } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	import { IconType, IconSize, IconColor } from '@elastic/eui/src/components/icon';
	export const SIZES: readonly ["s", "m", "l", "xl"];
	export type EuiAvatarSize = (typeof SIZES)[number];
	export const TYPES: readonly ["space", "user"];
	export type EuiAvatarType = (typeof TYPES)[number];
	export const CASING: readonly ["capitalize", "uppercase", "lowercase", "none"];
	export type EuiAvatarCasing = (typeof CASING)[number]; type _EuiAvatarContent = ExclusiveUnion<ExclusiveUnion<{
	    /**
	     * Custom initials (max 2 characters).
	     * By default will take the first character (of each word).
	     */
	    initials?: string;
	    /**
	     * Specify how many characters to show (1 or 2).
	     * By default, will show based on number of words (max first 2).
	     */
	    initialsLength?: 1 | 2;
	}, {
	    /**
	     * Path to an image to display instead of initials
	     */
	    imageUrl: string;
	}>, {
	    /**
	     * Any EUI glyph, logo or custom icon to display instead of initials
	     */
	    iconType: IconType;
	    /**
	     * Manually change icon size
	     */
	    iconSize?: IconSize;
	    /**
	     * Manually change icon color
	     */
	    iconColor?: IconColor | null;
	}>;
	export type EuiAvatarProps = Omit<HTMLAttributes<HTMLDivElement>, 'color'> & CommonProps & _EuiAvatarContent & {
	    /**
	     * Full name of avatar for title attribute and calculating initial if not provided
	     */
	    name: string;
	    /**
	     * Accepts hex values like `#FFFFFF`, `#000` otherwise a viz palette color will be assigned.
	     * Or pass `'plain'` for an empty shade, `'subdued'` for a light gray shade or `null` to remove entirely and the text/icon color will `inherit`
	     */
	    color?: string | 'plain' | 'subdued' | null;
	    /**
	     * The type of avatar mainly controlling the shape.
	     * `user` = circle
	     * `space` = rounded square
	     */
	    type?: EuiAvatarType;
	    size?: EuiAvatarSize;
	    /**
	     * Sets the letter casing of the displayed initials.
	     * Defaults to `uppercase` for `type="user"` avatars.
	     * Defaults to `none` (uses the existing casing of the passed `name` or `initials`) for `type="space"` avatars.
	     * @default uppercase
	     */
	    casing?: EuiAvatarCasing;
	    /**
	     * Grays out the avatar to simulate being disabled
	     */
	    isDisabled?: boolean;
	};
	export const EuiAvatar: FunctionComponent<EuiAvatarProps>;
	export const checkValidColor: (color: EuiAvatarProps['color']) => void;
	export {};

}
declare module '@elastic/eui/src/components/avatar' {
	export type { EuiAvatarProps } from '@elastic/eui/src/components/avatar/avatar';
	export { EuiAvatar, checkValidColor } from '@elastic/eui/src/components/avatar/avatar';

}
declare module '@elastic/eui/src/components/badge/color_utils' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiBadgeColors: (euiThemeContext: UseEuiTheme) => {
	    primary: {
	        color: string;
	        backgroundColor: string;
	    };
	    success: {
	        color: string;
	        backgroundColor: string;
	    };
	    warning: {
	        color: string;
	        backgroundColor: string;
	    };
	    danger: {
	        color: string;
	        backgroundColor: string;
	    };
	    accent: {
	        color: string;
	        backgroundColor: string;
	    };
	    disabled: {
	        color: string;
	        backgroundColor: string;
	    };
	    default: {
	        backgroundColor: string;
	        color: string;
	    };
	    hollow: {
	        borderColor: string;
	        backgroundColor: string;
	        color: string;
	    };
	    subdued: {
	        backgroundColor: string;
	        color: string;
	    };
	    accentText: {
	        backgroundColor: string;
	        color: string;
	    };
	};
	export const getBadgeColors: (euiThemeContext: UseEuiTheme, backgroundColor: string) => {
	    backgroundColor: string;
	    color: string;
	};
	export const getTextColor: ({ euiTheme }: UseEuiTheme, bgColor: string) => string;
	export const getColorContrast: (textColor: string, color: string) => number;
	export const getIsValidColor: (color?: string | undefined) => boolean;

}
declare module '@elastic/eui/src/components/badge/badge.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiBadgeStyles: (euiThemeContext: UseEuiTheme) => {
	    euiBadge: import("@emotion/utils").SerializedStyles;
	    clickable: import("@emotion/utils").SerializedStyles;
	    default: import("@emotion/utils").SerializedStyles;
	    hollow: import("@emotion/utils").SerializedStyles;
	    primary: import("@emotion/utils").SerializedStyles;
	    accent: import("@emotion/utils").SerializedStyles;
	    warning: import("@emotion/utils").SerializedStyles;
	    danger: import("@emotion/utils").SerializedStyles;
	    success: import("@emotion/utils").SerializedStyles;
	    disabled: import("@emotion/utils").SerializedStyles;
	    euiBadge__content: import("@emotion/utils").SerializedStyles;
	    text: {
	        euiBadge__text: import("@emotion/utils").SerializedStyles;
	        clickable: import("@emotion/utils").SerializedStyles;
	    };
	    icon: {
	        euiBadge__icon: import("@emotion/utils").SerializedStyles;
	        right: import("@emotion/utils").SerializedStyles;
	        left: import("@emotion/utils").SerializedStyles;
	    };
	    iconButton: {
	        euiBadge__iconButton: import("@emotion/utils").SerializedStyles;
	        right: import("@emotion/utils").SerializedStyles;
	        left: import("@emotion/utils").SerializedStyles;
	    };
	    euiBadge__childButton: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/badge/badge' {
	import { AriaAttributes, FunctionComponent, HTMLAttributes, MouseEventHandler } from 'react';
	import { CommonProps, ExclusiveUnion, PropsOf } from '@elastic/eui/src/components/common';
	import { EuiIcon, IconType } from '@elastic/eui/src/components/icon';
	export const ICON_SIDES: readonly ["left", "right"]; type IconSide = (typeof ICON_SIDES)[number];
	export const COLORS: readonly ["default", "hollow", "primary", "success", "accent", "warning", "danger"]; type BadgeColor = (typeof COLORS)[number]; type WithButtonProps = {
	    /**
	     * Will apply an onclick to the badge itself
	     */
	    onClick: MouseEventHandler<HTMLButtonElement>;
	    /**
	     * Aria label applied to the onClick button
	     */
	    onClickAriaLabel: AriaAttributes['aria-label'];
	} & Omit<HTMLAttributes<HTMLButtonElement>, 'onClick' | 'color'>; type WithAnchorProps = {
	    href: string;
	    target?: string;
	    rel?: string;
	} & Omit<HTMLAttributes<HTMLAnchorElement>, 'href' | 'color' | 'onClick'>; type WithSpanProps = Omit<HTMLAttributes<HTMLSpanElement>, 'onClick' | 'color'>;
	interface WithIconOnClick {
	    /**
	     * Will apply an onclick to icon within the badge
	     */
	    iconOnClick: MouseEventHandler<HTMLButtonElement>;
	    /**
	     * Aria label applied to the iconOnClick button
	     */
	    iconOnClickAriaLabel: AriaAttributes['aria-label'];
	}
	export type EuiBadgeProps = {
	    /**
	     * Accepts any string from our icon library
	     */
	    iconType?: IconType;
	    /**
	     * The side of the badge the icon should sit
	     */
	    iconSide?: IconSide;
	    /**
	     * Accepts either our palette colors (primary, success ..etc) or a hex value `#FFFFFF`, `#000`.
	     */
	    color?: BadgeColor | string;
	    /**
	     * Will override any color passed through the `color` prop.
	     */
	    isDisabled?: boolean;
	    /**
	     * Props passed to the close button.
	     */
	    closeButtonProps?: Partial<PropsOf<typeof EuiIcon>>;
	} & CommonProps & ExclusiveUnion<WithIconOnClick, {}> & ExclusiveUnion<ExclusiveUnion<WithButtonProps, WithAnchorProps>, WithSpanProps>;
	export const EuiBadge: FunctionComponent<EuiBadgeProps>;
	export {};

}
declare module '@elastic/eui/src/components/badge/beta_badge/beta_badge.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiBetaBadgeStyles: (euiThemeContext: UseEuiTheme) => {
	    euiBetaBadge: import("@emotion/utils").SerializedStyles;
	    accent: import("@emotion/utils").SerializedStyles;
	    subdued: import("@emotion/utils").SerializedStyles;
	    hollow: import("@emotion/utils").SerializedStyles;
	    warning: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    badgeSizes: {
	        default: {
	            m: string;
	            s: string;
	        };
	        circle: {
	            m: string;
	            s: string;
	        };
	    };
	    euiBetaBadge__icon: import("@emotion/utils").SerializedStyles;
	    baseline: import("@emotion/utils").SerializedStyles;
	    middle: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/badge/beta_badge/beta_badge' {
	import { AriaAttributes, FunctionComponent, HTMLAttributes, MouseEventHandler, ReactNode } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	import { EuiToolTipProps, ToolTipPositions } from '@elastic/eui/src/components/tool_tip';
	import { IconType } from '@elastic/eui/src/components/icon';
	export const COLORS: readonly ["accent", "subdued", "hollow", "warning"];
	export type BetaBadgeColor = (typeof COLORS)[number];
	export const SIZES: readonly ["s", "m"];
	export type BetaBadgeSize = (typeof SIZES)[number];
	export const ALIGNMENTS: readonly ["baseline", "middle"];
	export type BetaBadgeAlignment = (typeof ALIGNMENTS)[number]; type WithButtonProps = {
	    /**
	     * Will apply an onclick to the badge itself
	     */
	    onClick?: MouseEventHandler<HTMLButtonElement>;
	    /**
	     * Aria label applied to the onClick button
	     */
	    onClickAriaLabel?: AriaAttributes['aria-label'];
	} & Omit<HTMLAttributes<HTMLButtonElement>, 'onClick' | 'color'>; type WithAnchorProps = {
	    href: string;
	    target?: string;
	    rel?: string;
	} & Omit<HTMLAttributes<HTMLAnchorElement>, 'href' | 'color' | 'onClick'>; type WithSpanProps = Omit<HTMLAttributes<HTMLSpanElement>, 'onClick' | 'color' | 'title'>; type LabelAsNode = ExclusiveUnion<{
	    title: string;
	    tooltipContent?: ReactNode;
	}, {
	    tooltipContent: ReactNode;
	    title?: string;
	}> & {
	    label: ReactNode;
	}; type LabelAsString = {
	    /**
	     * One word label like "Beta" or "Lab"
	     */
	    label: string;
	}; type BadgeProps = {
	    /**
	     * Supply an icon type if the badge should just be an icon
	     */
	    iconType?: IconType;
	    /**
	     * One word label like "Beta" or "Lab"
	     */
	    label: ReactNode;
	    /**
	     * Content for the tooltip
	     */
	    tooltipContent?: ReactNode;
	    /**
	     * Custom position of the tooltip
	     */
	    tooltipPosition?: ToolTipPositions;
	    /**
	     * Passes onto the span wrapping the badge
	     */
	    anchorProps?: EuiToolTipProps['anchorProps'];
	    /**
	     * Optional title will be supplied as tooltip title or title attribute
	     * otherwise the label will be used
	     */
	    title?: string;
	    /**
	     * Accepts accent, subdued, hollow and warning.
	     */
	    color?: BetaBadgeColor;
	    size?: BetaBadgeSize;
	    /**
	     * Sets the `vertical-align` CSS property
	     */
	    alignment?: BetaBadgeAlignment;
	} & ExclusiveUnion<LabelAsNode, LabelAsString>;
	export type EuiBetaBadgeProps = CommonProps & ExclusiveUnion<ExclusiveUnion<WithButtonProps, WithAnchorProps>, WithSpanProps> & BadgeProps;
	export const EuiBetaBadge: FunctionComponent<EuiBetaBadgeProps>;
	export {};

}
declare module '@elastic/eui/src/components/badge/beta_badge' {
	export type { EuiBetaBadgeProps } from '@elastic/eui/src/components/badge/beta_badge/beta_badge';
	export { EuiBetaBadge } from '@elastic/eui/src/components/badge/beta_badge/beta_badge';

}
declare module '@elastic/eui/src/components/badge/notification_badge/badge_notification.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiNotificationBadgeStyles: (euiThemeContext: UseEuiTheme) => {
	    euiNotificationBadge: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    accent: import("@emotion/utils").SerializedStyles;
	    success: import("@emotion/utils").SerializedStyles;
	    subdued: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/badge/notification_badge/badge_notification' {
	import { HTMLAttributes, ReactNode, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const COLORS: readonly ["accent", "subdued", "success"];
	export type BadgeNotificationColor = (typeof COLORS)[number];
	export const SIZES: readonly ["s", "m"];
	export type BadgeNotificationSize = (typeof SIZES)[number];
	export interface EuiNotificationBadgeProps extends CommonProps, Omit<HTMLAttributes<HTMLSpanElement>, 'color'> {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: ReactNode;
	    size?: BadgeNotificationSize;
	    color?: BadgeNotificationColor;
	}
	export const EuiNotificationBadge: FunctionComponent<EuiNotificationBadgeProps>;

}
declare module '@elastic/eui/src/components/badge/notification_badge' {
	export type { EuiNotificationBadgeProps } from '@elastic/eui/src/components/badge/notification_badge/badge_notification';
	export { EuiNotificationBadge } from '@elastic/eui/src/components/badge/notification_badge/badge_notification';

}
declare module '@elastic/eui/src/components/badge/badge_group/badge_group.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiBadgeGroupStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiBadgeGroup: import("@emotion/utils").SerializedStyles;
	    none: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/badge/badge_group/badge_group' {
	import React, { ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const GUTTER_SIZES: readonly ["none", "xs", "s"]; type BadgeGroupGutterSize = (typeof GUTTER_SIZES)[number];
	export interface EuiBadgeGroupProps {
	    /**
	     * Space between badges
	     */
	    gutterSize?: BadgeGroupGutterSize;
	    /**
	     * Should be a list of `EuiBadge`s, but can also be any other element
	     */
	    children?: ReactNode;
	}
	export const EuiBadgeGroup: React.ForwardRefExoticComponent<CommonProps & React.HTMLAttributes<HTMLDivElement> & EuiBadgeGroupProps & React.RefAttributes<HTMLDivElement>>;
	export {};

}
declare module '@elastic/eui/src/components/badge/badge_group' {
	export type { EuiBadgeGroupProps } from '@elastic/eui/src/components/badge/badge_group/badge_group';
	export { EuiBadgeGroup } from '@elastic/eui/src/components/badge/badge_group/badge_group';

}
declare module '@elastic/eui/src/components/badge' {
	export type { EuiBadgeProps } from '@elastic/eui/src/components/badge/badge';
	export { EuiBadge } from '@elastic/eui/src/components/badge/badge';
	export type { EuiBetaBadgeProps } from '@elastic/eui/src/components/badge/beta_badge';
	export { EuiBetaBadge } from '@elastic/eui/src/components/badge/beta_badge';
	export { EuiNotificationBadge } from '@elastic/eui/src/components/badge/notification_badge';
	export type { EuiBadgeGroupProps } from '@elastic/eui/src/components/badge/badge_group';
	export { EuiBadgeGroup } from '@elastic/eui/src/components/badge/badge_group';

}
declare module '@elastic/eui/src/components/beacon/beacon.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiBeaconStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiBeacon: import("@emotion/utils").SerializedStyles;
	    subdued: import("@emotion/utils").SerializedStyles;
	    primary: import("@emotion/utils").SerializedStyles;
	    success: import("@emotion/utils").SerializedStyles;
	    warning: import("@emotion/utils").SerializedStyles;
	    danger: import("@emotion/utils").SerializedStyles;
	    accent: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/beacon/beacon' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const COLORS: readonly ["subdued", "primary", "success", "accent", "danger", "warning"];
	export type EuiBeaconColor = (typeof COLORS)[number];
	export type EuiBeaconProps = Omit<HTMLAttributes<HTMLDivElement>, 'children' | 'color'> & CommonProps & {
	    /**
	     * Height and width of the center circle. Value is passed directly to the `style` attribute
	     */
	    size?: number | string;
	    /**
	     * Any of the named color palette options.
	     */
	    color?: EuiBeaconColor;
	};
	export const EuiBeacon: FunctionComponent<EuiBeaconProps>;

}
declare module '@elastic/eui/src/components/beacon' {
	export type { EuiBeaconProps } from '@elastic/eui/src/components/beacon/beacon';
	export { EuiBeacon } from '@elastic/eui/src/components/beacon/beacon';

}
declare module '@elastic/eui/src/components/bottom_bar/bottom_bar.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiBottomBarStyles: (euiThemeContext: UseEuiTheme) => {
	    euiBottomBar: import("@emotion/utils").SerializedStyles;
	    static: import("@emotion/utils").SerializedStyles;
	    fixed: import("@emotion/utils").SerializedStyles;
	    sticky: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    none: string;
	};

}
declare module '@elastic/eui/src/components/bottom_bar/bottom_bar' {
	import React, { CSSProperties, HTMLAttributes } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	import { EuiPortalProps } from '@elastic/eui/src/components/portal';
	export const PADDING_SIZES: readonly ["none", "s", "m", "l"]; type BottomBarPaddingSize = (typeof PADDING_SIZES)[number];
	export const POSITIONS: readonly ["static", "fixed", "sticky"];
	export type _BottomBarPosition = (typeof POSITIONS)[number]; type _BottomBarExclusivePositions = ExclusiveUnion<{
	    position?: 'fixed';
	    /**
	     * Whether to wrap in an EuiPortal which appends the component to the body element.
	     * Only works if `position` is `fixed`.
	     */
	    usePortal?: boolean | EuiPortalProps;
	    /**
	     * Whether the component should apply padding on the document body element to afford for its own displacement height.
	     * Only works if `usePortal` is true and `position` is `fixed`.
	     */
	    affordForDisplacement?: boolean;
	}, {
	    /**
	     * How to position the bottom bar against its parent.
	     */
	    position: 'static' | 'sticky';
	}>;
	export type EuiBottomBarProps = CommonProps & HTMLAttributes<HTMLElement> & _BottomBarExclusivePositions & {
	    /**
	     * Padding applied to the bar. Default is 'm'.
	     */
	    paddingSize?: BottomBarPaddingSize;
	    /**
	     * Optional class applied to the body element on mount.
	     */
	    bodyClassName?: string;
	    /**
	     * Customize the screen reader heading that helps users find this control.
	     *
	     * @default Page level controls
	     */
	    landmarkHeading?: string;
	    /**
	     * Starting vertical position when `fixed` position.
	     * Offset from the top of the window when `sticky` position.
	     * Has no affect on `static` positions.
	     */
	    top?: CSSProperties['top'];
	    /**
	     * Ending horizontal position when `fixed` position.
	     * Has no affect on `static` or `sticky` positions.
	     */
	    right?: CSSProperties['right'];
	    /**
	     * Starting vertical position when `fixed` position.
	     * Offset from the bottom of the window when `sticky` position.
	     * Has no affect on `static` positions.
	     */
	    bottom?: CSSProperties['bottom'];
	    /**
	     * Starting horizontal position when `fixed` position.
	     * Has no affect on `static` or `sticky` positions.
	     */
	    left?: CSSProperties['left'];
	};
	export const EuiBottomBar: React.ForwardRefExoticComponent<EuiBottomBarProps & React.RefAttributes<HTMLElement>>;
	export {};

}
declare module '@elastic/eui/src/components/bottom_bar' {
	export type { EuiBottomBarProps } from '@elastic/eui/src/components/bottom_bar/bottom_bar';
	export { EuiBottomBar } from '@elastic/eui/src/components/bottom_bar/bottom_bar';

}
declare module '@elastic/eui/src/components/link/external_link_icon' {
	import { FunctionComponent, AnchorHTMLAttributes } from 'react';
	import { EuiIconProps } from '@elastic/eui/src/components/icon';
	/**
	 * DRY util for indicating external links both via icon and to
	 * screen readers. Used internally by at EuiLink and EuiListGroupItem
	 */
	export type EuiExternalLinkIconProps = {
	    target?: AnchorHTMLAttributes<HTMLAnchorElement>['target'];
	    /**
	     * Set to true to show an icon indicating that it is an external link;
	     * Defaults to true if `target="_blank"`
	     */
	    external?: boolean;
	};
	export const EuiExternalLinkIcon: FunctionComponent<EuiExternalLinkIconProps & Partial<EuiIconProps>>;

}
declare module '@elastic/eui/src/components/link/link' {
	import React, { AnchorHTMLAttributes, ButtonHTMLAttributes, MouseEventHandler } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	export type EuiLinkType = 'button' | 'reset' | 'submit';
	export const COLORS: readonly ["primary", "subdued", "success", "accent", "danger", "warning", "text", "ghost"];
	export type EuiLinkColor = (typeof COLORS)[number];
	export interface LinkButtonProps {
	    type?: EuiLinkType;
	    /**
	     * Any of our named colors.
	     */
	    color?: EuiLinkColor;
	    onClick?: MouseEventHandler<HTMLButtonElement>;
	}
	export interface EuiLinkButtonProps extends CommonProps, Omit<ButtonHTMLAttributes<HTMLButtonElement>, 'type' | 'color' | 'onClick'>, LinkButtonProps {
	}
	export interface LinkAnchorProps {
	    type?: EuiLinkType;
	    /**
	     * Any of our named colors.
	     */
	    color?: EuiLinkColor;
	    /**
	     * Set to true to show an icon indicating that it is an external link;
	     * Defaults to true if `target="_blank"`
	     */
	    external?: boolean;
	}
	export interface EuiLinkAnchorProps extends CommonProps, Omit<AnchorHTMLAttributes<HTMLAnchorElement>, 'type' | 'color' | 'onClick'>, LinkAnchorProps {
	    onClick?: MouseEventHandler<HTMLAnchorElement>;
	}
	export type EuiLinkProps = ExclusiveUnion<EuiLinkButtonProps, EuiLinkAnchorProps>; const EuiLink: React.ForwardRefExoticComponent<((import ("@elastic/eui/src/components/common").DisambiguateSet<EuiLinkButtonProps, EuiLinkAnchorProps> & EuiLinkAnchorProps) | (import ("@elastic/eui/src/components/common").DisambiguateSet<EuiLinkAnchorProps, EuiLinkButtonProps> & EuiLinkButtonProps)) & React.RefAttributes<HTMLAnchorElement | HTMLButtonElement>>;
	export { EuiLink };

}
declare module '@elastic/eui/src/components/link' {
	export type { EuiLinkColor, EuiLinkProps, EuiLinkType, EuiLinkAnchorProps, EuiLinkButtonProps, } from '@elastic/eui/src/components/link/link';
	export { EuiLink } from '@elastic/eui/src/components/link/link';

}
declare module '@elastic/eui/src/components/breadcrumbs/types' {
	import type { ReactNode, HTMLAttributes, AriaAttributes, MouseEventHandler } from 'react';
	import type { EuiBreakpointSize } from '@elastic/eui/src/services';
	import type { CommonProps } from '@elastic/eui/src/components/common';
	import type { EuiLinkColor } from '@elastic/eui/src/components/link';
	import type { EuiPopoverProps } from '@elastic/eui/src/components/popover';
	/**
	 * Consumer facing type exports
	 */
	export type EuiBreadcrumbResponsiveMaxCount = {
	    [key in EuiBreakpointSize]?: number;
	};
	export type EuiBreadcrumbsProps = CommonProps & {
	    /**
	     * Hides extra (above the max) breadcrumbs under a collapsed item as the window gets smaller.
	     * Pass a custom #EuiBreadcrumbResponsiveMaxCount object to change the number of breadcrumbs to show at the particular breakpoints.
	     *
	     * Pass `false` to turn this behavior off.
	     *
	     * Default: `{ xs: 1, s: 2, m: 4 }`
	     */
	    responsive?: boolean | EuiBreadcrumbResponsiveMaxCount;
	    /**
	     * Forces all breadcrumbs to single line and
	     * truncates each breadcrumb to a particular width,
	     * except for the last item
	     */
	    truncate?: boolean;
	    /**
	     * Collapses the inner items past the maximum set here
	     * into a single ellipses item.
	     * Omitting or passing a `0` value will show all breadcrumbs.
	     */
	    max?: number | null;
	    /**
	     * The array of individual #EuiBreadcrumb items
	     */
	    breadcrumbs: EuiBreadcrumbProps[];
	    /**
	     * Determines breadcrumbs appearance, with `page` being the default styling.
	     * Application breadcrumbs should only be once per page, in (e.g.) EuiHeader
	     */
	    type?: 'page' | 'application';
	    /**
	     * Whether the last breadcrumb should be semantically highlighted as the
	     * current page. (improves accessibility for screen readers users)
	     * Defaults to true.
	     */
	    lastBreadcrumbIsCurrentPage?: boolean;
	};
	export type EuiBreadcrumbProps = Omit<HTMLAttributes<HTMLElement>, 'color' | 'aria-current'> & CommonProps & {
	    href?: string;
	    rel?: string;
	    onClick?: MouseEventHandler<HTMLAnchorElement>;
	    /**
	     * Visible label of the breadcrumb
	     */
	    text: ReactNode;
	    /**
	     * Force a max-width on the breadcrumb text
	     */
	    truncate?: boolean;
	    /**
	     * @deprecated - if a custom color is wanted, use the `css` prop to pass custom css
	     */
	    color?: EuiLinkColor;
	    /**
	     * Override the existing `aria-current` which defaults to `page` for the last breadcrumb
	     */
	    'aria-current'?: AriaAttributes['aria-current'];
	    /**
	     * Creates a breadcrumb that toggles a popover dialog. Takes any rendered node(s),
	     * or a render function that will pass callback allowing you to close the
	     * breadcrumb popover from within your popover content.
	     *
	     * If passed, both `href` and `onClick` will be ignored - the breadcrumb's
	     * click behavior should only trigger a popover.
	     */
	    popoverContent?: ReactNode | ((closePopover: () => void) => ReactNode);
	    /**
	     * Allows customizing the popover if necessary. Accepts any props that
	     * [EuiPopover](/#/layout/popover) accepts, except for props that control state.
	     */
	    popoverProps?: Omit<EuiPopoverProps, 'button' | 'closePopover' | 'isOpen'>;
	};
	/**
	 * Internal props set by parent EuiBreadcrumbs only
	 */
	export type _EuiBreadcrumbProps = {
	    type: NonNullable<EuiBreadcrumbsProps['type']>;
	    isFirstBreadcrumb?: boolean;
	    isLastBreadcrumb?: boolean;
	    isOnlyBreadcrumb?: boolean;
	    highlightLastBreadcrumb?: boolean;
	    truncateLastBreadcrumb?: boolean;
	};

}
declare module '@elastic/eui/src/components/breadcrumbs/_breadcrumb_content.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	/**
	 * Styles cast to inner <a>, <button>, <span> elements
	 */
	export const euiBreadcrumbContentStyles: (euiThemeContext: UseEuiTheme) => {
	    euiBreadcrumb__content: import("@emotion/utils").SerializedStyles;
	    isTruncated: import("@emotion/utils").SerializedStyles;
	    isTruncatedLast: import("@emotion/utils").SerializedStyles;
	    isInteractive: import("@emotion/utils").SerializedStyles;
	    page: import("@emotion/utils").SerializedStyles;
	    application: import("@emotion/utils").SerializedStyles;
	    applicationStyles: {
	        onlyChild: import("@emotion/utils").SerializedStyles;
	        firstChild: import("@emotion/utils").SerializedStyles;
	        lastChild: import("@emotion/utils").SerializedStyles;
	    };
	};
	export const euiBreadcrumbPopoverStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiBreadcrumb__popoverButton: import("@emotion/utils").SerializedStyles;
	    euiBreadcrumb__popoverTruncation: import("@emotion/utils").SerializedStyles;
	    popoverWrapper: {
	        euiBreadcrumb__popoverWrapper: import("@emotion/utils").SerializedStyles;
	        page: import("@emotion/utils").SerializedStyles;
	        application: null;
	    };
	};

}
declare module '@elastic/eui/src/components/breadcrumbs/_breadcrumb_content' {
	import { FunctionComponent } from 'react';
	import type { EuiBreadcrumbProps, _EuiBreadcrumbProps } from '@elastic/eui/src/components/breadcrumbs/types';
	export const EuiBreadcrumbContent: FunctionComponent<EuiBreadcrumbProps & _EuiBreadcrumbProps>;

}
declare module '@elastic/eui/src/components/breadcrumbs/breadcrumb.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	/**
	 * Styles cast to <li> element
	 */
	export const euiBreadcrumbStyles: (euiThemeContext: UseEuiTheme) => {
	    euiBreadcrumb: import("@emotion/utils").SerializedStyles;
	    isTruncated: import("@emotion/utils").SerializedStyles;
	    isCollapsed: import("@emotion/utils").SerializedStyles;
	    page: import("@emotion/utils").SerializedStyles;
	    application: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/breadcrumbs/breadcrumb' {
	import { FunctionComponent, HTMLAttributes, PropsWithChildren } from 'react';
	import type { EuiBreadcrumbProps, _EuiBreadcrumbProps } from '@elastic/eui/src/components/breadcrumbs/types';
	export const EuiBreadcrumb: FunctionComponent<HTMLAttributes<HTMLLIElement> & Pick<_EuiBreadcrumbProps, 'type'> & Pick<EuiBreadcrumbProps, 'truncate'>>;
	export const EuiBreadcrumbCollapsed: FunctionComponent<PropsWithChildren & Pick<_EuiBreadcrumbProps, 'type' | 'isFirstBreadcrumb'>>;

}
declare module '@elastic/eui/src/components/breadcrumbs/breadcrumbs.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiBreadcrumbsListStyles: (euiThemeContext: UseEuiTheme) => {
	    euiBreadcrumbs__list: import("@emotion/utils").SerializedStyles;
	    isTruncated: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/breadcrumbs/breadcrumbs' {
	import { FunctionComponent } from 'react';
	import { ExclusiveUnion } from '@elastic/eui/src/components/common';
	import type { EuiBreadcrumbsProps, EuiBreadcrumbProps } from '@elastic/eui/src/components/breadcrumbs/types';
	export const EuiBreadcrumbs: FunctionComponent<EuiBreadcrumbsProps>;
	export const useResponsiveMax: (responsive: EuiBreadcrumbsProps['responsive'], max: EuiBreadcrumbsProps['max']) => number | null | undefined; type _EuiBreadcrumbCollapsedObj = {
	    isCollapsedButton: true;
	    overflowBreadcrumbs: EuiBreadcrumbProps[];
	}; type _EuiBreadcrumbsObjs = Array<ExclusiveUnion<EuiBreadcrumbProps, _EuiBreadcrumbCollapsedObj>>;
	export const limitBreadcrumbs: (breadcrumbs: EuiBreadcrumbsProps['breadcrumbs'], max: number) => _EuiBreadcrumbsObjs;
	export {};

}
declare module '@elastic/eui/src/components/breadcrumbs' {
	export type { EuiBreadcrumbProps as EuiBreadcrumb, EuiBreadcrumbsProps, EuiBreadcrumbResponsiveMaxCount, } from '@elastic/eui/src/components/breadcrumbs/types';
	export { EuiBreadcrumbs } from '@elastic/eui/src/components/breadcrumbs/breadcrumbs';

}
declare module '@elastic/eui/src/components/panel/split_panel/split_panel.styles' {
	export const euiSplitPanelOuterStyles: {
	    euiSplitPanelOuter: import("@emotion/utils").SerializedStyles;
	    column: import("@emotion/utils").SerializedStyles;
	    row: import("@emotion/utils").SerializedStyles;
	};
	export const euiSplitPanelInnerStyles: {
	    euiSplitPanelInner: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/panel/split_panel/split_panel' {
	import React, { FunctionComponent, ReactNode, HTMLAttributes } from 'react';
	import { EuiBreakpointSize } from '@elastic/eui/src/services/breakpoint';
	import { _EuiPanelProps } from '@elastic/eui/src/components/panel/panel';
	export type _EuiSplitPanelInnerProps = HTMLAttributes<HTMLDivElement> & Omit<_EuiPanelProps, 'hasShadow' | 'hasBorder' | 'borderRadius'>;
	/**
	 * Consumed via `EuiSplitPanel.Inner`.
	 * Extends most `EuiPanelProps`.
	 */
	export const _EuiSplitPanelInner: FunctionComponent<_EuiSplitPanelInnerProps>;
	export type _EuiSplitPanelOuterProps = HTMLAttributes<HTMLDivElement> & {
	    /**
	     * Any number of _EuiSplitPanelInner components
	     */
	    children?: ReactNode;
	    /**
	     * Changes the flex-direction
	     */
	    direction?: 'column' | 'row';
	    /**
	     * Stacks row display on small screens.
	     * Remove completely with `false` or provide your own list of breakpoint sizes to stack on.
	     */
	    responsive?: false | EuiBreakpointSize[];
	} & Omit<_EuiPanelProps, 'paddingSize'>;
	/**
	 * Consumed via `EuiSplitPanel.Outer`.
	 * Extends most `EuiPanelProps`.
	 */
	export const _EuiSplitPanelOuter: FunctionComponent<_EuiSplitPanelOuterProps>;
	export const EuiSplitPanel: {
	    Outer: React.FunctionComponent<_EuiSplitPanelOuterProps>;
	    Inner: React.FunctionComponent<_EuiSplitPanelInnerProps>;
	};

}
declare module '@elastic/eui/src/components/panel/split_panel' {
	export type { _EuiSplitPanelInnerProps, _EuiSplitPanelOuterProps, } from '@elastic/eui/src/components/panel/split_panel/split_panel';
	export { EuiSplitPanel } from '@elastic/eui/src/components/panel/split_panel/split_panel';

}
declare module '@elastic/eui/src/components/panel' {
	export type { EuiPanelProps, PanelPaddingSize } from '@elastic/eui/src/components/panel/panel';
	export { EuiPanel, SIZES } from '@elastic/eui/src/components/panel/panel';
	export { EuiSplitPanel } from '@elastic/eui/src/components/panel/split_panel';

}
declare module '@elastic/eui/src/components/title' {
	export type { EuiTitleProps, EuiTitleSize } from '@elastic/eui/src/components/title/title';
	export { EuiTitle } from '@elastic/eui/src/components/title/title';

}
declare module '@elastic/eui/src/components/call_out/call_out.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCallOutStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiCallOut: import("@emotion/utils").SerializedStyles;
	    hasDismissButton: {
	        hasDimissButton: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	    };
	    dismissButton: {
	        euiCallOut__dismissButton: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	    };
	};
	export const euiCallOutHeaderStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiCallOutHeader: import("@emotion/utils").SerializedStyles;
	    primary: import("@emotion/utils").SerializedStyles;
	    success: import("@emotion/utils").SerializedStyles;
	    warning: import("@emotion/utils").SerializedStyles;
	    danger: import("@emotion/utils").SerializedStyles;
	    euiCallOut__icon: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/call_out/call_out' {
	import React, { HTMLAttributes, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { IconType } from '@elastic/eui/src/components/icon';
	export const COLORS: readonly ["primary", "success", "warning", "danger"];
	export type Color = (typeof COLORS)[number];
	export const HEADINGS: readonly ["h1", "h2", "h3", "h4", "h5", "h6", "p"]; type Heading = (typeof HEADINGS)[number]; type Size = 's' | 'm';
	export type EuiCallOutProps = CommonProps & Omit<HTMLAttributes<HTMLDivElement>, 'title' | 'color'> & {
	    title?: ReactNode;
	    iconType?: IconType;
	    color?: Color;
	    size?: Size;
	    heading?: Heading;
	    /**
	     * Passing an `onDismiss` callback will render a cross in the top right hand corner
	     * of the callout.
	     *
	     * This callback fires when users click this button, which allows conditionally
	     * removing the callout or other actions.
	     */
	    onDismiss?: () => void;
	};
	export const EuiCallOut: React.ForwardRefExoticComponent<CommonProps & Omit<React.HTMLAttributes<HTMLDivElement>, "title" | "color"> & {
	    title?: ReactNode;
	    iconType?: IconType | undefined;
	    color?: "primary" | "success" | "warning" | "danger" | undefined;
	    size?: Size | undefined;
	    heading?: "h1" | "h2" | "h3" | "h4" | "h5" | "h6" | "p" | undefined;
	    /**
	     * Passing an `onDismiss` callback will render a cross in the top right hand corner
	     * of the callout.
	     *
	     * This callback fires when users click this button, which allows conditionally
	     * removing the callout or other actions.
	     */
	    onDismiss?: (() => void) | undefined;
	} & React.RefAttributes<HTMLDivElement>>;
	export {};

}
declare module '@elastic/eui/src/components/call_out' {
	export type { EuiCallOutProps } from '@elastic/eui/src/components/call_out/call_out';
	export { EuiCallOut } from '@elastic/eui/src/components/call_out/call_out';

}
declare module '@elastic/eui/src/components/card/card_select/card_select.styles' {
	export const euiCardSelectStyles: () => {
	    euiCardSelect: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/card/card_select/card_select' {
	import { FunctionComponent } from 'react';
	import { Props } from '@elastic/eui/src/components/button/button';
	export type EuiCardSelectProps = Props;
	export const EuiCardSelect: FunctionComponent<EuiCardSelectProps>;
	export function euiCardSelectableColor(color: Props['color'], isSelected: boolean | undefined): Props['color'];

}
declare module '@elastic/eui/src/components/card/card_select' {
	export type { EuiCardSelectProps } from '@elastic/eui/src/components/card/card_select/card_select';
	export { EuiCardSelect, euiCardSelectableColor } from '@elastic/eui/src/components/card/card_select/card_select';

}
declare module '@elastic/eui/src/components/card/card.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	import { EuiCardProps } from '@elastic/eui/src/components/card/card';
	/**
	 * 1. Footer is always at the bottom.
	 * 3. Horizontal layouts should always top left align no matter the textAlign prop
	 * 4. Ensures the contents always stretch no matter the flex layout
	 */
	export const euiCardStyles: (euiThemeContext: UseEuiTheme, paddingSize: EuiCardProps['paddingSize']) => {
	    card: {
	        euiCard: import("@emotion/utils").SerializedStyles;
	        aligned: {
	            center: import("@emotion/utils").SerializedStyles;
	            left: import("@emotion/utils").SerializedStyles;
	            right: import("@emotion/utils").SerializedStyles;
	        };
	        disabled: import("@emotion/utils").SerializedStyles;
	    };
	    main: {
	        euiCard__main: import("@emotion/utils").SerializedStyles;
	        layout: {
	            vertical: import("@emotion/utils").SerializedStyles;
	            horizontal: import("@emotion/utils").SerializedStyles;
	        };
	    };
	    content: {
	        euiCard__content: import("@emotion/utils").SerializedStyles;
	        layout: {
	            vertical: import("@emotion/utils").SerializedStyles;
	            horizontal: import("@emotion/utils").SerializedStyles;
	        };
	    };
	    euiCard__children: import("@emotion/utils").SerializedStyles;
	    euiCard__description: import("@emotion/utils").SerializedStyles;
	    euiCard__footer: import("@emotion/utils").SerializedStyles;
	    top: {
	        euiCard__top: import("@emotion/utils").SerializedStyles;
	        layout: {
	            vertical: import("@emotion/utils").SerializedStyles;
	            horizontal: import("@emotion/utils").SerializedStyles;
	        };
	        disabled: import("@emotion/utils").SerializedStyles;
	    };
	    image: {
	        euiCard__image: import("@emotion/utils").SerializedStyles;
	        transparent: import("@emotion/utils").SerializedStyles;
	    };
	    icon: {
	        euiCard__icon: import("@emotion/utils").SerializedStyles;
	        withImage: import("@emotion/utils").SerializedStyles;
	        layout: {
	            vertical: import("@emotion/utils").SerializedStyles;
	            horizontal: import("@emotion/utils").SerializedStyles;
	        };
	    };
	};
	export const euiCardTextStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCard__text: import("@emotion/utils").SerializedStyles;
	    interactive: import("@emotion/utils").SerializedStyles;
	    aligned: {
	        center: import("@emotion/utils").SerializedStyles;
	        left: import("@emotion/utils").SerializedStyles;
	        right: import("@emotion/utils").SerializedStyles;
	    };
	    disabled: import("@emotion/utils").SerializedStyles;
	};
	export const euiCardBetaBadgeStyles: (euiThemeContext: UseEuiTheme, paddingSize: EuiCardProps['paddingSize']) => {
	    hasBetaBadge: import("@emotion/utils").SerializedStyles;
	    euiCard__betaBadgeAnchor: import("@emotion/utils").SerializedStyles;
	    euiCard__betaBadge: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/card/card' {
	import React, { FunctionComponent, ReactElement, ReactNode, HTMLAttributes } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	import { EuiBetaBadgeProps } from '@elastic/eui/src/components/badge/beta_badge';
	import { EuiIconProps } from '@elastic/eui/src/components/icon';
	import { EuiPanelProps } from '@elastic/eui/src/components/panel';
	import { EuiCardSelectProps } from '@elastic/eui/src/components/card/card_select';
	export const ALIGNMENTS: readonly ["left", "center", "right"]; type CardAlignment = (typeof ALIGNMENTS)[number]; type EuiCardPropsLayout = ExclusiveUnion<{
	    layout?: 'vertical';
	    /**
	     * Changes alignment of the title and description
	     */
	    textAlign?: CardAlignment;
	    /**
	     * Accepts any combination of elements
	     */
	    footer?: ReactNode;
	    /**
	     * Accepts a url in string form or ReactElement for a custom image component
	     */
	    image?: string | ReactElement;
	}, {
	    /**
	     * Change to "horizontal" if you need the icon to be left of the content.
	     * Horizontal layouts cannot be used in conjunction with `image`, `footer`, or `textAlign`.
	     */
	    layout: 'horizontal';
	}>;
	export type EuiCardProps = Omit<CommonProps, 'aria-label'> & Omit<HTMLAttributes<HTMLDivElement>, 'color' | 'title' | 'onClick'> & EuiCardPropsLayout & {
	    /**
	     * Cards are required to have at least a title and a description and/or children
	     */
	    title: NonNullable<ReactNode>;
	    /**
	     * Determines the title's heading element
	     */
	    titleElement?: 'h2' | 'h3' | 'h4' | 'h5' | 'h6' | 'span' | 'p';
	    /**
	     * Determines the title's size, matching that of EuiTitle.
	     * Though, card titles can't be too large or small relative to the description text.
	     */
	    titleSize?: 's' | 'xs';
	    /**
	     * Placed within a small EuiText `<p>` tag
	     */
	    description?: NonNullable<ReactNode>;
	    /**
	     * Accepts an `<EuiIcon>` node or `null`
	     */
	    icon?: ReactElement<EuiIconProps> | null;
	    /**
	     * Custom children
	     */
	    children?: ReactNode;
	    /**
	     * Use only if you want to forego a button in the footer and make the whole card clickable
	     */
	    onClick?: React.MouseEventHandler<HTMLButtonElement> | React.MouseEventHandler<HTMLAnchorElement>;
	    isDisabled?: boolean;
	    href?: string;
	    target?: string;
	    rel?: string;
	    /**
	     * Adds a badge to top of the card to label it as "Beta" or other non-GA state.
	     * Accepts all the props of [EuiBetaBadge](#/display/badge#beta-badge-type), where `label` is required.
	     */
	    betaBadgeProps?: EuiBetaBadgeProps;
	    /**
	     * Matches to the color property of EuiPanel. If defined, removes any border & shadow.
	     * Leave as `undefined` to display as a default panel.
	     * Selectable cards will always display as a default panel.
	     */
	    display?: EuiPanelProps['color'];
	    /**
	     * Padding applied around the content of the card
	     */
	    paddingSize?: EuiPanelProps['paddingSize'];
	    /**
	     * Adds a button to the bottom of the card to allow for in-place selection
	     */
	    selectable?: EuiCardSelectProps;
	    /**
	     * Use a border style of card instead of shadow
	     */
	    hasBorder?: EuiPanelProps['hasBorder'];
	};
	export const EuiCard: FunctionComponent<EuiCardProps>;
	export {};

}
declare module '@elastic/eui/src/components/form/checkbox/checkbox.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCheckboxStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCheckbox: import("@emotion/utils").SerializedStyles;
	    input: {
	        euiCheckbox__square: import("@emotion/utils").SerializedStyles;
	        hasLabel: string;
	        enabled: {
	            selected: import("@emotion/utils").SerializedStyles;
	            unselected: import("@emotion/utils").SerializedStyles;
	        };
	        disabled: {
	            selected: import("@emotion/utils").SerializedStyles;
	            unselected: import("@emotion/utils").SerializedStyles;
	        };
	        readOnly: import("@emotion/utils").SerializedStyles;
	        icon: {
	            euiCheckbox__icon: import("@emotion/utils").SerializedStyles;
	            check: import("@emotion/utils").SerializedStyles;
	            indeterminate: import("@emotion/utils").SerializedStyles;
	        };
	        euiCheckbox__input: import("@emotion/utils").SerializedStyles;
	    };
	    label: {
	        euiCheckbox__label: import("@emotion/utils").SerializedStyles;
	        enabled: string;
	        disabled: import("@emotion/utils").SerializedStyles;
	        readOnly: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/form/checkbox/checkbox' {
	import { FunctionComponent, ChangeEventHandler, ReactNode, InputHTMLAttributes, LabelHTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export interface EuiCheckboxProps extends CommonProps, InputHTMLAttributes<HTMLInputElement> {
	    id: string;
	    checked?: boolean;
	    onChange: ChangeEventHandler<HTMLInputElement>;
	    inputRef?: (element: HTMLInputElement) => void;
	    label?: ReactNode;
	    disabled?: boolean;
	    indeterminate?: boolean;
	    /**
	     * Object of props passed to the <label/>
	     */
	    labelProps?: CommonProps & LabelHTMLAttributes<HTMLLabelElement>;
	}
	export const EuiCheckbox: FunctionComponent<EuiCheckboxProps>;

}
declare module '@elastic/eui/src/components/form/form_fieldset/form_legend.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFormLegendStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFormLegend: import("@emotion/utils").SerializedStyles;
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/form_fieldset/form_legend' {
	import { HTMLAttributes, FunctionComponent, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiFormLegendProps = HTMLAttributes<HTMLLegendElement> & CommonProps & {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: ReactNode;
	    /**
	     * For a hidden legend that is still visible to the screen reader, set to 'hidden'
	     */
	    display?: 'hidden' | 'visible';
	    compressed?: boolean;
	};
	export const EuiFormLegend: FunctionComponent<EuiFormLegendProps>;

}
declare module '@elastic/eui/src/components/form/form_fieldset/form_fieldset' {
	import { HTMLAttributes, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiFormLegendProps } from '@elastic/eui/src/components/form/form_fieldset/form_legend';
	export interface EuiFormFieldsetProps extends CommonProps, HTMLAttributes<HTMLFieldSetElement> {
	    /**
	     * Adds an EuiFormLegend element as the first child
	     */
	    legend?: EuiFormLegendProps;
	}
	export const EuiFormFieldset: FunctionComponent<EuiFormFieldsetProps>;

}
declare module '@elastic/eui/src/components/form/form_fieldset' {
	export type { EuiFormFieldsetProps } from '@elastic/eui/src/components/form/form_fieldset/form_fieldset';
	export { EuiFormFieldset } from '@elastic/eui/src/components/form/form_fieldset/form_fieldset';
	export type { EuiFormLegendProps } from '@elastic/eui/src/components/form/form_fieldset/form_legend';
	export { EuiFormLegend } from '@elastic/eui/src/components/form/form_fieldset/form_legend';

}
declare module '@elastic/eui/src/components/form/checkbox/checkbox_group.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCheckboxGroupStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiCheckboxGroup: import("@emotion/utils").SerializedStyles;
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/checkbox/checkbox_group' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	import { EuiFormFieldsetProps, EuiFormLegendProps } from '@elastic/eui/src/components/form/form_fieldset';
	import { EuiCheckboxProps } from '@elastic/eui/src/components/form/checkbox/checkbox';
	export interface EuiCheckboxGroupOption extends Omit<EuiCheckboxProps, 'checked' | 'onChange'> {
	    id: string;
	}
	export interface EuiCheckboxGroupIdToSelectedMap {
	    [id: string]: boolean;
	} type AsDivProps = Omit<HTMLAttributes<HTMLDivElement>, 'onChange'>; type WithLegendProps = Omit<EuiFormFieldsetProps, 'onChange'> & {
	    /**
	     * If the individual labels for each radio do not provide a sufficient description, add a legend.
	     * Wraps the group in a `EuiFormFieldset` which adds an `EuiLegend` for titling the whole group.
	     * Accepts an `EuiFormLegendProps` shape.
	     */
	    legend?: EuiFormLegendProps;
	};
	export type EuiCheckboxGroupProps = CommonProps & {
	    options: EuiCheckboxGroupOption[];
	    idToSelectedMap: EuiCheckboxGroupIdToSelectedMap;
	    onChange: (optionId: string) => void;
	    /**
	     * Tightens up the spacing between checkbox rows
	     */
	    compressed?: boolean;
	    /**
	     * Passed down to all child `EuiCheckbox`es
	     */
	    disabled?: boolean;
	} & ExclusiveUnion<AsDivProps, WithLegendProps>;
	export const EuiCheckboxGroup: FunctionComponent<EuiCheckboxGroupProps>;
	export {};

}
declare module '@elastic/eui/src/components/form/checkbox' {
	export type { EuiCheckboxProps } from '@elastic/eui/src/components/form/checkbox/checkbox';
	export { EuiCheckbox } from '@elastic/eui/src/components/form/checkbox/checkbox';
	export type { EuiCheckboxGroupProps, EuiCheckboxGroupOption, } from '@elastic/eui/src/components/form/checkbox/checkbox_group';
	export { EuiCheckboxGroup } from '@elastic/eui/src/components/form/checkbox/checkbox_group';

}
declare module '@elastic/eui/src/components/form/described_form_group/described_form_group.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDescribedFormGroupStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDescribedFormGroup: import("@emotion/utils").SerializedStyles;
	    formWidth: string;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    euiDescribedFormGroup__descriptionColumn: import("@emotion/utils").SerializedStyles;
	    euiDescribedFormGroup__description: import("@emotion/utils").SerializedStyles;
	    euiDescribedFormGroup__fields: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/described_form_group/described_form_group' {
	import { FunctionComponent, ReactNode, HTMLAttributes } from 'react';
	import { CommonProps, PropsOf } from '@elastic/eui/src/components/common';
	import { EuiTitleSize, EuiTitleProps } from '@elastic/eui/src/components/title';
	import { EuiFlexItem, EuiFlexGroupGutterSize } from '@elastic/eui/src/components/flex';
	export type EuiDescribedFormGroupProps = CommonProps & Omit<HTMLAttributes<HTMLDivElement>, 'title'> & {
	    /**
	     * One or more `EuiFormRow`s.
	     */
	    children?: ReactNode;
	    /**
	     * Passed to `EuiFlexGroup`.
	     * @default l
	     */
	    gutterSize?: EuiFlexGroupGutterSize;
	    /**
	     * Expand to fill 100% of the parent.
	     * Defaults to `fullWidth` prop of `<EuiForm>`.
	     * Default max-width is 800px.
	     * @default false
	     */
	    fullWidth?: boolean;
	    /**
	     * Width ratio of description column compared to field column.
	     * Can be used in conjunction with `fullWidth` and
	     * may require `fullWidth` to be applied to child elements.
	     * @default half
	     */
	    ratio?: 'half' | 'third' | 'quarter';
	    /**
	     * For better accessibility, it's recommended to use an HTML heading.
	     */
	    title: EuiTitleProps['children'];
	    /**
	     * Adjust the visual `size` of the EuiTitle that wraps `title`.
	     * @default xs
	     */
	    titleSize?: EuiTitleSize;
	    /**
	     * Added as a child of `EuiText`.
	     */
	    description?: ReactNode;
	    /**
	     * For customizing the description container. Extended from `EuiFlexItem`.
	     */
	    descriptionFlexItemProps?: PropsOf<typeof EuiFlexItem>;
	    /**
	     * For customizing the field container. Extended from `EuiFlexItem`.
	     */
	    fieldFlexItemProps?: PropsOf<typeof EuiFlexItem>;
	};
	export const EuiDescribedFormGroup: FunctionComponent<EuiDescribedFormGroupProps>;

}
declare module '@elastic/eui/src/components/form/described_form_group' {
	export type { EuiDescribedFormGroupProps } from '@elastic/eui/src/components/form/described_form_group/described_form_group';
	export { EuiDescribedFormGroup } from '@elastic/eui/src/components/form/described_form_group/described_form_group';

}
declare module '@elastic/eui/src/components/form/validatable_control/validatable_control' {
	import { ReactElement, Ref, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export interface HTMLConstraintValidityElement extends Element {
	    setCustomValidity: (error: string) => void;
	}
	export interface ReactElementWithRef extends ReactElement {
	    ref?: Ref<HTMLConstraintValidityElement>;
	}
	/**
	 * The `EuiValidatableControl` component should be used in scenarios where
	 * we can render the validated `<input>` as its direct child.
	 */
	export interface EuiValidatableControlProps {
	    isInvalid?: boolean;
	    children: ReactElementWithRef;
	}
	export const EuiValidatableControl: FunctionComponent<CommonProps & EuiValidatableControlProps>;
	/**
	 * The `UseEuiValidatableControl` hook should be used in scenarios where
	 * we *cannot* control where the validated `<input>` is rendered (e.g., ReactDatePicker)
	 * and instead need to access the input via a ref and pass the element in directly
	 */
	export interface UseEuiValidatableControlProps {
	    isInvalid?: boolean;
	    controlEl: HTMLInputElement | HTMLConstraintValidityElement | null;
	}
	export const useEuiValidatableControl: ({ isInvalid, controlEl, }: UseEuiValidatableControlProps) => void;

}
declare module '@elastic/eui/src/components/form/validatable_control' {
	export type { EuiValidatableControlProps, UseEuiValidatableControlProps, } from '@elastic/eui/src/components/form/validatable_control/validatable_control';
	export { EuiValidatableControl, useEuiValidatableControl, } from '@elastic/eui/src/components/form/validatable_control/validatable_control';

}
declare module '@elastic/eui/src/components/form/field_number/field_number.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFieldNumberStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFieldNumber: import("@emotion/utils").SerializedStyles;
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	    formWidth: string;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    inGroup: import("@emotion/utils").SerializedStyles;
	    controlOnly: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/field_number/field_number' {
	import { InputHTMLAttributes, Ref, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiFormControlLayoutProps } from '@elastic/eui/src/components/form/form_control_layout';
	export type EuiFieldNumberProps = Omit<InputHTMLAttributes<HTMLInputElement>, 'min' | 'max' | 'readOnly' | 'step'> & CommonProps & {
	    icon?: EuiFormControlLayoutProps['icon'];
	    isInvalid?: boolean;
	    /**
	     * Expand to fill 100% of the parent.
	     * Defaults to `fullWidth` prop of `<EuiForm>`.
	     * @default false
	     */
	    fullWidth?: boolean;
	    /**
	     * @default false
	     */
	    isLoading?: boolean;
	    readOnly?: boolean;
	    min?: number;
	    max?: number;
	    /**
	     * Specifies the granularity that the value must adhere to.
	     * Accepts a `number`, e.g. `1` for integers, or `0.5` for decimal steps.
	     * Defaults to `"any"` for no stepping, which allows any decimal value(s).
	     * @default "any"
	     */
	    step?: number | 'any';
	    inputRef?: Ref<HTMLInputElement>;
	    /**
	     * Creates an input group with element(s) coming before input.
	     * `string` | `ReactElement` or an array of these
	     */
	    prepend?: EuiFormControlLayoutProps['prepend'];
	    /**
	     * Creates an input group with element(s) coming after input.
	     * `string` | `ReactElement` or an array of these
	     */
	    append?: EuiFormControlLayoutProps['append'];
	    /**
	     * Completely removes form control layout wrapper and ignores
	     * icon, prepend, and append. Best used inside EuiFormControlLayoutDelimited.
	     */
	    controlOnly?: boolean;
	    /**
	     * when `true` creates a shorter height input
	     * @default false
	     */
	    compressed?: boolean;
	};
	export const EuiFieldNumber: FunctionComponent<EuiFieldNumberProps>;

}
declare module '@elastic/eui/src/components/form/field_number' {
	export type { EuiFieldNumberProps } from '@elastic/eui/src/components/form/field_number/field_number';
	export { EuiFieldNumber } from '@elastic/eui/src/components/form/field_number/field_number';

}
declare module '@elastic/eui/src/components/form/field_password/field_password.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFieldPasswordStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFieldPassword: import("@emotion/utils").SerializedStyles;
	    withToggle: import("@emotion/utils").SerializedStyles;
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	    formWidth: string;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    inGroup: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/field_password/field_password' {
	import { InputHTMLAttributes, FunctionComponent, Ref } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiButtonIconPropsForButton } from '@elastic/eui/src/components/button';
	import { EuiFormControlLayoutProps } from '@elastic/eui/src/components/form/form_control_layout';
	export type EuiFieldPasswordProps = Omit<InputHTMLAttributes<HTMLInputElement>, 'type' | 'value'> & CommonProps & {
	    isInvalid?: boolean;
	    /**
	     * Expand to fill 100% of the parent.
	     * Defaults to `fullWidth` prop of `<EuiForm>`.
	     * @default false
	     */
	    fullWidth?: boolean;
	    isLoading?: boolean;
	    compressed?: boolean;
	    inputRef?: Ref<HTMLInputElement>;
	    /**
	     * Creates an input group with element(s) coming before input.
	     * `string` | `ReactElement` or an array of these
	     */
	    prepend?: EuiFormControlLayoutProps['prepend'];
	    /**
	     * Creates an input group with element(s) coming after input.
	     * `string` | `ReactElement` or an array of these
	     */
	    append?: EuiFormControlLayoutProps['append'];
	    value?: string | number;
	    /**
	     * Change the `type` of input for manually handling obfuscation.
	     * The `dual` option adds the ability to toggle the obfuscation of the input by
	     * adding an icon button as the first `append` element
	     * @default password
	     */
	    type?: 'password' | 'text' | 'dual';
	    /**
	     * Additional props to apply to the dual toggle. Extends EuiButtonIcon
	     */
	    dualToggleProps?: Partial<EuiButtonIconPropsForButton>;
	};
	export const EuiFieldPassword: FunctionComponent<EuiFieldPasswordProps>;

}
declare module '@elastic/eui/src/components/form/field_password' {
	export type { EuiFieldPasswordProps } from '@elastic/eui/src/components/form/field_password/field_password';
	export { EuiFieldPassword } from '@elastic/eui/src/components/form/field_password/field_password';

}
declare module '@elastic/eui/src/services/browser/browser' {
	interface IBrowser {
	    isEventSupported: (name: string, element: EventTarget) => boolean;
	}
	export const Browser: Readonly<IBrowser>;
	export {};

}
declare module '@elastic/eui/src/services/browser' {
	export { Browser } from '@elastic/eui/src/services/browser/browser';

}
declare module '@elastic/eui/src/components/form/field_search/field_search.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFieldSearchStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFieldSearch: import("@emotion/utils").SerializedStyles;
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	    formWidth: string;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    inGroup: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/field_search/field_search' {
	import React, { Component, InputHTMLAttributes, KeyboardEvent } from 'react';
	import { WithEuiStylesMemoizerProps } from '@elastic/eui/src/services';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiFormControlLayoutProps } from '@elastic/eui/src/components/form/form_control_layout';
	import { FormContextValue } from '@elastic/eui/src/components/form/eui_form_context';
	export interface EuiFieldSearchProps extends CommonProps, InputHTMLAttributes<HTMLInputElement> {
	    name?: string;
	    id?: string;
	    placeholder?: string;
	    value?: string;
	    isInvalid?: boolean;
	    /**
	     * Expand to fill 100% of the parent.
	     * Defaults to `fullWidth` prop of `<EuiForm>`.
	     * @default false
	     */
	    fullWidth?: boolean;
	    isLoading?: boolean;
	    /**
	     * Called when the user presses [Enter] OR on change if the incremental prop is `true`.
	     * If you don't need the on[Enter] functionality, prefer using onChange
	     */
	    onSearch?: (value: string) => void;
	    /**
	     * When `true` the search will be executed (that is, the `onSearch` will be called) as the
	     * user types.
	     */
	    incremental?: boolean;
	    /**
	     * when `true` creates a shorter height input
	     */
	    compressed?: boolean;
	    inputRef?: (node: HTMLInputElement | null) => void;
	    /**
	     * Shows a button that quickly clears any input
	     */
	    isClearable?: boolean;
	    /**
	     * Creates an input group with element(s) coming before input
	     * `string` | `ReactElement` or an array of these
	     */
	    prepend?: EuiFormControlLayoutProps['prepend'];
	    /**
	     * Creates an input group with element(s) coming after input.
	     * `string` | `ReactElement` or an array of these
	     */
	    append?: EuiFormControlLayoutProps['append'];
	}
	interface EuiFieldSearchState {
	    value: string;
	}
	export class EuiFieldSearchClass extends Component<EuiFieldSearchProps & WithEuiStylesMemoizerProps, EuiFieldSearchState> {
	    static contextType: React.Context<FormContextValue>;
	    static defaultProps: {
	        isLoading: boolean;
	        incremental: boolean;
	        compressed: boolean;
	        isClearable: boolean;
	    };
	    state: {
	        value: string;
	    };
	    inputElement: HTMLInputElement | null;
	    cleanups: Array<() => void>;
	    componentDidMount(): void;
	    onClear: () => void;
	    componentWillUnmount(): void;
	    setRef: (inputElement: HTMLInputElement | null) => void;
	    onKeyUp: (event: KeyboardEvent<HTMLInputElement>, incremental?: boolean | undefined, onSearch?: ((value: string) => void) | undefined) => void;
	    render(): React.JSX.Element;
	}
	export const EuiFieldSearch: React.ForwardRefExoticComponent<Omit<EuiFieldSearchProps, "stylesMemoizer"> & React.RefAttributes<Omit<EuiFieldSearchProps, "stylesMemoizer">>>;
	export {};

}
declare module '@elastic/eui/src/components/form/field_search' {
	export type { EuiFieldSearchProps } from '@elastic/eui/src/components/form/field_search/field_search';
	export { EuiFieldSearch } from '@elastic/eui/src/components/form/field_search/field_search';

}
declare module '@elastic/eui/src/components/form/field_text/field_text.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFieldTextStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFieldText: import("@emotion/utils").SerializedStyles;
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	    formWidth: string;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    inGroup: import("@emotion/utils").SerializedStyles;
	    controlOnly: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/field_text/field_text' {
	import { InputHTMLAttributes, Ref, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiFormControlLayoutProps } from '@elastic/eui/src/components/form/form_control_layout';
	export type EuiFieldTextProps = InputHTMLAttributes<HTMLInputElement> & CommonProps & {
	    icon?: EuiFormControlLayoutProps['icon'];
	    isInvalid?: boolean;
	    /**
	     * Expand to fill 100% of the parent.
	     * Defaults to `fullWidth` prop of `<EuiForm>`.
	     * @default false
	     */
	    fullWidth?: boolean;
	    isLoading?: boolean;
	    readOnly?: boolean;
	    inputRef?: Ref<HTMLInputElement>;
	    /**
	     * Creates an input group with element(s) coming before input.
	     * `string` | `ReactElement` or an array of these
	     */
	    prepend?: EuiFormControlLayoutProps['prepend'];
	    /**
	     * Creates an input group with element(s) coming after input.
	     * `string` | `ReactElement` or an array of these
	     */
	    append?: EuiFormControlLayoutProps['append'];
	    /**
	     * Completely removes form control layout wrapper and ignores
	     * icon, prepend, and append. Best used inside EuiFormControlLayoutDelimited.
	     */
	    controlOnly?: boolean;
	    /**
	     * when `true` creates a shorter height input
	     */
	    compressed?: boolean;
	};
	export const EuiFieldText: FunctionComponent<EuiFieldTextProps>;

}
declare module '@elastic/eui/src/components/form/field_text' {
	export type { EuiFieldTextProps } from '@elastic/eui/src/components/form/field_text/field_text';
	export { EuiFieldText } from '@elastic/eui/src/components/form/field_text/field_text';

}
declare module '@elastic/eui/src/components/progress/progress.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	/**
	 * Emotion styles
	 */
	export const euiProgressStyles: ({ euiTheme }: UseEuiTheme, isNative: boolean) => {
	    euiProgress: import("@emotion/utils").SerializedStyles;
	    native: import("@emotion/utils").SerializedStyles;
	    indeterminate: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    fixed: import("@emotion/utils").SerializedStyles;
	    absolute: import("@emotion/utils").SerializedStyles;
	    static: import("@emotion/utils").SerializedStyles;
	    primary: import("@emotion/utils").SerializedStyles;
	    success: import("@emotion/utils").SerializedStyles;
	    warning: import("@emotion/utils").SerializedStyles;
	    danger: import("@emotion/utils").SerializedStyles;
	    subdued: import("@emotion/utils").SerializedStyles;
	    accent: import("@emotion/utils").SerializedStyles;
	    vis0: import("@emotion/utils").SerializedStyles;
	    vis1: import("@emotion/utils").SerializedStyles;
	    vis2: import("@emotion/utils").SerializedStyles;
	    vis3: import("@emotion/utils").SerializedStyles;
	    vis4: import("@emotion/utils").SerializedStyles;
	    vis5: import("@emotion/utils").SerializedStyles;
	    vis6: import("@emotion/utils").SerializedStyles;
	    vis7: import("@emotion/utils").SerializedStyles;
	    vis8: import("@emotion/utils").SerializedStyles;
	    vis9: import("@emotion/utils").SerializedStyles;
	    customColor: import("@emotion/utils").SerializedStyles;
	};
	/**
	 * Data styles
	 */
	export const euiProgressDataStyles: (euiThemeContext: UseEuiTheme) => {
	    euiProgress__data: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	};
	export const euiProgressLabelStyles: {
	    euiProgress__label: import("@emotion/utils").SerializedStyles;
	};
	export const euiProgressValueTextStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiProgress__valueText: import("@emotion/utils").SerializedStyles;
	    primary: import("@emotion/utils").SerializedStyles;
	    success: import("@emotion/utils").SerializedStyles;
	    warning: import("@emotion/utils").SerializedStyles;
	    danger: import("@emotion/utils").SerializedStyles;
	    subdued: import("@emotion/utils").SerializedStyles;
	    accent: import("@emotion/utils").SerializedStyles;
	    vis0: import("@emotion/utils").SerializedStyles;
	    vis1: import("@emotion/utils").SerializedStyles;
	    vis2: import("@emotion/utils").SerializedStyles;
	    vis3: import("@emotion/utils").SerializedStyles;
	    vis4: import("@emotion/utils").SerializedStyles;
	    vis5: import("@emotion/utils").SerializedStyles;
	    vis6: import("@emotion/utils").SerializedStyles;
	    vis7: import("@emotion/utils").SerializedStyles;
	    vis8: import("@emotion/utils").SerializedStyles;
	    vis9: import("@emotion/utils").SerializedStyles;
	    customColor: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/progress/progress' {
	import { FunctionComponent, HTMLAttributes, ProgressHTMLAttributes, ReactNode, CSSProperties } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	export const SIZES: readonly ["xs", "s", "m", "l"];
	export type EuiProgressSize = (typeof SIZES)[number];
	export const COLORS: readonly ["primary", "success", "warning", "danger", "subdued", "accent", "vis0", "vis1", "vis2", "vis3", "vis4", "vis5", "vis6", "vis7", "vis8", "vis9"];
	export type EuiProgressColor = (typeof COLORS)[number];
	export const POSITIONS: readonly ["fixed", "absolute", "static"];
	export type EuiProgressPosition = (typeof POSITIONS)[number];
	export type EuiProgressProps = CommonProps & {
	    size?: EuiProgressSize;
	    /**
	     * One of EUI's color palette, vis colors or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value
	     */
	    color?: EuiProgressColor | CSSProperties['color'];
	    position?: EuiProgressPosition;
	}; type Indeterminate = EuiProgressProps & HTMLAttributes<HTMLDivElement>; type Determinate = EuiProgressProps & Omit<ProgressHTMLAttributes<HTMLProgressElement>, 'max'> & {
	    max?: number;
	    valueText?: boolean | ReactNode;
	    label?: ReactNode;
	    /**
	     * Object of props passed to the <span/> wrapping the determinate progress's label
	     */
	    labelProps?: CommonProps & HTMLAttributes<HTMLSpanElement>;
	};
	export const EuiProgress: FunctionComponent<ExclusiveUnion<Determinate, Indeterminate>>;
	export {};

}
declare module '@elastic/eui/src/components/progress' {
	export type { EuiProgressProps } from '@elastic/eui/src/components/progress/progress';
	export { EuiProgress } from '@elastic/eui/src/components/progress/progress';

}
declare module '@elastic/eui/src/components/form/file_picker/file_picker.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFilePickerStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFilePicker: import("@emotion/utils").SerializedStyles;
	    isDroppingFile: import("@emotion/utils").SerializedStyles;
	    invalid: import("@emotion/utils").SerializedStyles;
	    hasFiles: import("@emotion/utils").SerializedStyles;
	    loading: import("@emotion/utils").SerializedStyles;
	    formWidth: string;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    input: {
	        euiFilePicker__input: import("@emotion/utils").SerializedStyles;
	        largeInteractive: import("@emotion/utils").SerializedStyles;
	    };
	    euiFilePicker__prompt: import("@emotion/utils").SerializedStyles;
	    disabled: import("@emotion/utils").SerializedStyles;
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	    large: {
	        large: import("@emotion/utils").SerializedStyles;
	        uncompressed: string;
	        compressed: import("@emotion/utils").SerializedStyles;
	    };
	    icon: {
	        euiFilePicker__icon: import("@emotion/utils").SerializedStyles;
	        normal: import("@emotion/utils").SerializedStyles;
	        uncompressed: string;
	        compresssed: import("@emotion/utils").SerializedStyles;
	        large: import("@emotion/utils").SerializedStyles;
	    };
	    rightIcon: {
	        euiFilePicker__rightIcon: import("@emotion/utils").SerializedStyles;
	        uncompressed: string;
	        compressed: import("@emotion/utils").SerializedStyles;
	    };
	    euiFilePicker__clearButton: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/file_picker/file_picker' {
	import React, { Component, InputHTMLAttributes, ReactNode } from 'react';
	import { WithEuiStylesMemoizerProps } from '@elastic/eui/src/services';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { FormContextValue } from '@elastic/eui/src/components/form/eui_form_context';
	export interface EuiFilePickerProps extends CommonProps, Omit<InputHTMLAttributes<HTMLInputElement>, 'onChange'> {
	    id?: string;
	    name?: string;
	    className?: string;
	    /**
	     * The content that appears in the dropzone if no file is attached
	     * @default 'Select or drag and drop a file'
	     */
	    initialPromptText?: ReactNode;
	    /**
	     * Use as a callback to access the HTML FileList API
	     */
	    onChange?: (files: FileList | null) => void;
	    /**
	     * Reduces the size to a typical (compressed) input
	     * @default false
	     */
	    compressed?: boolean;
	    /**
	     * Size or type of display;
	     * `default` for normal height, similar to other controls;
	     * `large` for taller size
	     * @default large
	     */
	    display?: 'default' | 'large';
	    /**
	     * Expand to fill 100% of the parent.
	     * Defaults to `fullWidth` prop of `<EuiForm>`.
	     * @default false
	     */
	    fullWidth?: boolean;
	    isInvalid?: boolean;
	    isLoading?: boolean;
	    disabled?: boolean;
	}
	export class EuiFilePickerClass extends Component<EuiFilePickerProps & WithEuiStylesMemoizerProps> {
	    static contextType: React.Context<FormContextValue>;
	    static defaultProps: Partial<EuiFilePickerProps>;
	    state: {
	        promptText: null;
	        isHoveringDrop: boolean;
	    };
	    fileInput: HTMLInputElement | null;
	    generatedId: string;
	    handleChange: () => void;
	    removeFiles: (e?: React.MouseEvent<HTMLButtonElement, MouseEvent> | undefined) => void;
	    showDrop: () => void;
	    hideDrop: () => void;
	    render(): React.JSX.Element;
	}
	export const EuiFilePicker: React.ForwardRefExoticComponent<Omit<EuiFilePickerProps, "stylesMemoizer"> & React.RefAttributes<Omit<EuiFilePickerProps, "stylesMemoizer">>>;

}
declare module '@elastic/eui/src/components/form/file_picker' {
	export type { EuiFilePickerProps } from '@elastic/eui/src/components/form/file_picker/file_picker';
	export { EuiFilePicker } from '@elastic/eui/src/components/form/file_picker/file_picker';

}
declare module '@elastic/eui/src/components/form/form' {
	import React, { ReactNode, HTMLAttributes, FormHTMLAttributes } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	export type EuiFormProps = CommonProps & ExclusiveUnion<{
	    component: 'form';
	} & FormHTMLAttributes<HTMLFormElement>, {
	    component?: 'div';
	} & HTMLAttributes<HTMLDivElement>> & {
	    isInvalid?: boolean;
	    /**
	     * Which HTML element to render `div` or `form`
	     */
	    component?: 'form' | 'div';
	    error?: ReactNode | ReactNode[];
	    /**
	     * Where to display the callout with the list of errors
	     */
	    invalidCallout?: 'above' | 'none';
	    /**
	     * When set to `true`, all the rows/controls in this form will
	     * default to taking up 100% of the width of their continer. You
	     * can specify `fullWidth={false}` on individual rows/controls to
	     * disable this behavior for specific components.
	     * @default false
	     */
	    fullWidth?: boolean;
	};
	export const EuiForm: React.ForwardRefExoticComponent<EuiFormProps & React.RefAttributes<HTMLElement>>;

}
declare module '@elastic/eui/src/components/form/form_error_text/form_error_text.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFormErrorTextStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFormErrorText: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/form_error_text/form_error_text' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiFormErrorTextProps = CommonProps & HTMLAttributes<HTMLDivElement>;
	export const EuiFormErrorText: FunctionComponent<EuiFormErrorTextProps>;

}
declare module '@elastic/eui/src/components/form/form_error_text' {
	export type { EuiFormErrorTextProps } from '@elastic/eui/src/components/form/form_error_text/form_error_text';
	export { EuiFormErrorText } from '@elastic/eui/src/components/form/form_error_text/form_error_text';

}
declare module '@elastic/eui/src/components/form/form_help_text/form_help_text.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFormHelpTextStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFormHelpText: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/form_help_text/form_help_text' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiFormHelpTextProps = CommonProps & HTMLAttributes<HTMLDivElement>;
	export const EuiFormHelpText: FunctionComponent<EuiFormHelpTextProps>;

}
declare module '@elastic/eui/src/components/form/form_help_text' {
	export type { EuiFormHelpTextProps } from '@elastic/eui/src/components/form/form_help_text/form_help_text';
	export { EuiFormHelpText } from '@elastic/eui/src/components/form/form_help_text/form_help_text';

}
declare module '@elastic/eui/src/components/form/form_row/form_row.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFormRowStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFormRow: import("@emotion/utils").SerializedStyles;
	    formWidth: string;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    row: string;
	    readonly rowCompressed: string;
	    columnCompressed: import("@emotion/utils").SerializedStyles;
	    centerDisplayCss: (compressed: boolean) => string;
	    readonly center: import("@emotion/utils").SerializedStyles;
	    readonly centerCompressed: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/form_row/form_row' {
	import { FunctionComponent, HTMLAttributes, ReactElement, ReactNode } from 'react';
	import { ExclusiveUnion, CommonProps } from '@elastic/eui/src/components/common';
	export const DISPLAYS: readonly ["row", "columnCompressed", "center", "centerCompressed", "rowCompressed"];
	export type EuiFormRowDisplayKeys = (typeof DISPLAYS)[number]; type EuiFormRowCommonProps = CommonProps & {
	    /**
	     * - `columnCompressed` creates a compressed and horizontal layout
	     * - `center`/`centerCompressed` helps align non-input content better with inline form layouts
	     * - `rowCompressed` - **deprecated**, does not currently affect styling
	     */
	    display?: EuiFormRowDisplayKeys;
	    /**
	     * Useful for inline form layouts, primarily for content that
	     * needs to be aligned with inputs but does not need a label
	     */
	    hasEmptyLabelSpace?: boolean;
	    /**
	     * Expand to fill 100% of the parent.
	     * Defaults to `fullWidth` prop of `<EuiForm>`.
	     * @default false
	     */
	    fullWidth?: boolean;
	    /**
	     * IDs of additional elements that should be part of children's `aria-describedby`
	     */
	    describedByIds?: string[];
	    /**
	     * Escape hatch to not render duplicate labels if the child also renders a label
	     */
	    hasChildLabel?: boolean;
	    /**
	     * ReactElement to render as this component's content
	     */
	    children: ReactElement;
	    label?: ReactNode;
	    /**
	     * Adds an extra node to the right of the form label without
	     * being contained inside the form label. Good for things
	     * like documentation links.
	     */
	    labelAppend?: any;
	    id?: string;
	    isInvalid?: boolean;
	    error?: ReactNode | ReactNode[];
	    /**
	     *  Adds a single node/string or an array of nodes/strings below the input
	     */
	    helpText?: ReactNode | ReactNode[];
	    /**
	     *  Passed along to the label element; and to the child field element when `disabled` doesn't already exist on the child field element.
	     */
	    isDisabled?: boolean;
	}; type LabelProps = {
	    labelType?: 'label';
	} & EuiFormRowCommonProps & HTMLAttributes<HTMLDivElement>; type LegendProps = {
	    /**
	     * Defaults to rendering a `<label>` but if passed `'legend'` for labelType,
	     * will render both a `<legend>` and the surrounding container as a `<fieldset>`
	     */
	    labelType?: 'legend';
	} & EuiFormRowCommonProps & Omit<HTMLAttributes<HTMLFieldSetElement>, 'disabled'>;
	export type EuiFormRowProps = ExclusiveUnion<LabelProps, LegendProps>;
	export const EuiFormRow: FunctionComponent<EuiFormRowProps>;
	export {};

}
declare module '@elastic/eui/src/components/form/form_row' {
	export type { EuiFormRowProps } from '@elastic/eui/src/components/form/form_row/form_row';
	export { EuiFormRow } from '@elastic/eui/src/components/form/form_row/form_row';

}
declare module '@elastic/eui/src/components/form/radio/radio.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiRadioStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRadio: import("@emotion/utils").SerializedStyles;
	    input: {
	        euiRadio__circle: import("@emotion/utils").SerializedStyles;
	        hasLabel: string;
	        enabled: {
	            selected: import("@emotion/utils").SerializedStyles;
	            unselected: import("@emotion/utils").SerializedStyles;
	        };
	        disabled: {
	            selected: import("@emotion/utils").SerializedStyles;
	            unselected: import("@emotion/utils").SerializedStyles;
	        };
	        euiRadio__icon: import("@emotion/utils").SerializedStyles;
	        euiRadio__input: import("@emotion/utils").SerializedStyles;
	    };
	    label: {
	        euiRadio__label: import("@emotion/utils").SerializedStyles;
	        enabled: string;
	        disabled: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/form/radio/radio' {
	import { FunctionComponent, ChangeEventHandler, HTMLAttributes, LabelHTMLAttributes, ReactNode } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	export interface RadioProps {
	    autoFocus?: boolean;
	    name?: string;
	    value?: string;
	    checked?: boolean;
	    disabled?: boolean;
	    onChange: ChangeEventHandler<HTMLInputElement>;
	    /**
	     * Object of props passed to the <label/>
	     */
	    labelProps?: CommonProps & LabelHTMLAttributes<HTMLLabelElement>;
	}
	interface idWithLabel extends RadioProps {
	    label: ReactNode;
	    id: string;
	}
	interface withId extends RadioProps {
	    id: string;
	}
	export type EuiRadioProps = CommonProps & Omit<HTMLAttributes<HTMLDivElement>, 'onChange' | 'id'> & ExclusiveUnion<ExclusiveUnion<RadioProps, idWithLabel>, withId>;
	export const EuiRadio: FunctionComponent<EuiRadioProps>;
	export {};

}
declare module '@elastic/eui/src/components/form/radio/radio_group.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiRadioGroupStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiRadioGroup: import("@emotion/utils").SerializedStyles;
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/radio/radio_group' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	import { EuiFormFieldsetProps, EuiFormLegendProps } from '@elastic/eui/src/components/form/form_fieldset';
	import { EuiRadioProps } from '@elastic/eui/src/components/form/radio/radio';
	export interface EuiRadioGroupOption extends Omit<EuiRadioProps, 'checked' | 'onChange'> {
	    id: string;
	}
	export type EuiRadioGroupChangeCallback = (id: string, value?: string) => void; type AsDivProps = Omit<HTMLAttributes<HTMLDivElement>, 'onChange'>; type WithLegendProps = Omit<EuiFormFieldsetProps, 'onChange'> & {
	    /**
	     * If the individual labels for each radio do not provide a sufficient description, add a legend.
	     * Wraps the group in a `EuiFormFieldset` which adds an `EuiLegend` for titling the whole group.
	     * Accepts an `EuiFormLegendProps` shape.
	     */
	    legend?: EuiFormLegendProps;
	};
	export type EuiRadioGroupProps = CommonProps & {
	    /**
	     * Passed down to all child `EuiCheckbox`es
	     */
	    disabled?: boolean;
	    /**
	     * Tightens up the spacing between radio rows
	     */
	    compressed?: boolean;
	    name?: string;
	    options: EuiRadioGroupOption[];
	    idSelected?: string;
	    onChange: EuiRadioGroupChangeCallback;
	} & ExclusiveUnion<AsDivProps, WithLegendProps>;
	export const EuiRadioGroup: FunctionComponent<EuiRadioGroupProps>;
	export {};

}
declare module '@elastic/eui/src/components/form/radio' {
	export type { EuiRadioProps } from '@elastic/eui/src/components/form/radio/radio';
	export { EuiRadio } from '@elastic/eui/src/components/form/radio/radio';
	export type { EuiRadioGroupProps, EuiRadioGroupOption } from '@elastic/eui/src/components/form/radio/radio_group';
	export { EuiRadioGroup } from '@elastic/eui/src/components/form/radio/radio_group';

}
declare module '@elastic/eui/src/components/form/range/range_levels_colors' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	import type { EuiRangeLevel } from '@elastic/eui/src/components/form/range/types';
	export const LEVEL_COLORS: readonly ["primary", "success", "warning", "danger"];
	export type EuiRangeLevelColor = (typeof LEVEL_COLORS)[number];
	export const isNamedLevelColor: (color?: string | undefined) => boolean;
	export const euiRangeLevelColor: (color: EuiRangeLevelColor | string, euiTheme: UseEuiTheme['euiTheme']) => string;
	export const getLevelColor: (levels: EuiRangeLevel[], value: number) => "primary" | "success" | "warning" | "danger" | import("csstype").Property.Color | undefined;

}
declare module '@elastic/eui/src/components/form/range/range_input.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiRangeInputStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiRangeInput: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/range/range_input' {
	import { FunctionComponent } from 'react';
	import { EuiFieldNumberProps } from '@elastic/eui/src/components/form/field_number';
	import type { _SingleRangeValue, _SharedRangeInputSide } from '@elastic/eui/src/components/form/range/types';
	export interface EuiRangeInputProps extends Omit<EuiFieldNumberProps, 'max' | 'min' | 'value' | 'step'>, Omit<_SingleRangeValue, 'onChange'>, _SharedRangeInputSide {
	    autoSize?: boolean;
	}
	export const EuiRangeInput: FunctionComponent<EuiRangeInputProps>;

}
declare module '@elastic/eui/src/components/form/range/types' {
	import type { ReactNode, CSSProperties, InputHTMLAttributes } from 'react';
	import type { CommonProps } from '@elastic/eui/src/components/common';
	import type { EuiInputPopoverProps } from '@elastic/eui/src/components/popover/input_popover';
	import type { EuiFormControlLayoutProps } from '@elastic/eui/src/components/form/form_control_layout';
	import type { EuiRangeLevelColor } from '@elastic/eui/src/components/form/range/range_levels_colors';
	import type { EuiRangeInputProps } from '@elastic/eui/src/components/form/range/range_input';
	/**
	 * Internal type atoms split up both for easier categorization
	 * and for easier reusing/picking
	 */
	export interface _SharedRangeValuesProps {
	    max: number;
	    min: number;
	    /**
	     * The number to increment or decrement between each interval
	     * @default 1
	     */
	    step?: number;
	}
	export interface _SingleRangeValue extends _SharedRangeValuesProps {
	    value: string | number;
	    onChange?: (event: _SingleRangeChangeEvent, isValid: boolean) => void;
	}
	export interface _DualRangeValue extends _SharedRangeValuesProps {
	    value: [_SingleRangeValue['value'], _SingleRangeValue['value']];
	    onChange: (values: [_SingleRangeValue['value'], _SingleRangeValue['value']], isValid: boolean, event?: _DualRangeChangeEvent) => void;
	}
	export interface _SharedRangesValues extends _SharedRangeValuesProps {
	    value?: _SingleRangeValue['value'] | _DualRangeValue['value'];
	}
	export type _SingleRangeChangeEvent = React.ChangeEvent<HTMLInputElement> | React.KeyboardEvent<HTMLInputElement> | React.MouseEvent<HTMLButtonElement>;
	export type _DualRangeChangeEvent = _SingleRangeChangeEvent | React.KeyboardEvent<HTMLDivElement>;
	export interface _SharedRangeDataStructures {
	    /**
	     * Specified ticks at specified values
	     */
	    ticks?: EuiRangeTick[];
	    /**
	     * Modifies the number of tick marks and at what interval
	     */
	    tickInterval?: number;
	    /**
	     * Create colored indicators for certain intervals.
	     * An array of #EuiRangeLevel objects
	     */
	    levels?: EuiRangeLevel[];
	}
	export interface _SharedRangeVisualConfiguration {
	    /**
	     * Pass `true` to displays an extra input control for direct manipulation.
	     * Pass `"inputWithPopover"` to only show the input but show the range in a dropdown.
	     */
	    showInput?: boolean | 'inputWithPopover';
	    /**
	     * Shows static min/max labels on the sides of the range slider
	     */
	    showLabels?: boolean;
	    /**
	     * Shows a thick line from min to value
	     */
	    showRange?: boolean;
	    /**
	     * Shows clickable tick marks and labels at the given interval (`step`/`tickInterval`)
	     */
	    showTicks?: boolean;
	}
	export interface _SharedRangeInputProps {
	    id?: string;
	    name?: string;
	    /**
	     * Only impacts ticks rendered by `showTicks` or inputs rendered by `showInput`.
	     */
	    compressed?: boolean;
	    /**
	     * Only impacts inputs rendered by the `showInput` prop.
	     * The range slider itself remains interactable unless `disabled` is applied.
	     */
	    readOnly?: boolean;
	    /**
	     * Disables both the range track and any input(s)
	     */
	    disabled?: boolean;
	    /**
	     * Expand to fill 100% of the parent.
	     * Defaults to `fullWidth` prop of `<EuiForm>`.
	     * @default false
	     */
	    fullWidth?: boolean;
	    /**
	     * Only impacts inputs rendered by the `showInput` prop
	     */
	    isInvalid?: boolean;
	    /**
	     * Only impacts inputs rendered when the `showInput` prop is set to `"inputWithPopover"`
	     */
	    isLoading?: boolean;
	    /**
	     * Only impacts input popovers rendered when the `showInput` prop is set to `"inputWithPopover"`
	     *
	     * Allows customizing the underlying [EuiInputPopover](/#/layout/popover#popover-attached-to-input-element),
	     * except for props controlled by the range component
	     */
	    inputPopoverProps?: Omit<EuiInputPopoverProps, 'input' | 'isOpen' | 'closePopover' | 'disableFocusTrap' | 'popoverScreenReaderText' | 'fullWidth'>;
	}
	export type _SharedRangeInputSide = {
	    /**
	     * @default 'max'
	     */
	    side?: 'min' | 'max';
	};
	/**
	 * Externally exported props types
	 */
	export interface EuiRangeProps extends CommonProps, Omit<InputHTMLAttributes<HTMLInputElement>, 'value' | 'min' | 'max' | 'step' | 'onChange'>, _SingleRangeValue, _SharedRangeDataStructures, _SharedRangeVisualConfiguration, _SharedRangeInputProps {
	    /**
	     * Shows a tooltip styled value
	     */
	    showValue?: boolean;
	    /**
	     * Appends to the tooltip
	     */
	    valueAppend?: ReactNode;
	    /**
	     * Prepends to the tooltip
	     */
	    valuePrepend?: ReactNode;
	    /**
	     * Only impacts the input rendered by the `showInput` prop.
	     * `string` | `ReactElement` or an array of these
	     */
	    prepend?: EuiFormControlLayoutProps['prepend'];
	    /**
	     * Only impacts the input rendered by the `showInput` prop.
	     * `string` | `ReactElement` or an array of these
	     */
	    append?: EuiFormControlLayoutProps['append'];
	}
	export interface EuiDualRangeProps extends CommonProps, Omit<InputHTMLAttributes<HTMLInputElement>, 'value' | 'min' | 'max' | 'step' | 'onChange'>, _DualRangeValue, _SharedRangeDataStructures, _SharedRangeVisualConfiguration, _SharedRangeInputProps {
	    /**
	     * Creates a draggble highlighted range area
	     */
	    isDraggable?: boolean;
	    onBlur?: (event: React.FocusEvent<HTMLInputElement> | React.FocusEvent<HTMLDivElement>) => void;
	    onFocus?: (event: React.FocusEvent<HTMLInputElement> | React.FocusEvent<HTMLDivElement>) => void;
	    /**
	     * Only impacts inputs rendered when the `showInput` prop is set to `"inputWithPopover"`.
	     * `string` | `ReactElement` or an array of these
	     */
	    prepend?: EuiFormControlLayoutProps['prepend'];
	    /**
	     * Only impacts inputs rendered when the `showInput` prop is set to `"inputWithPopover"`.
	     * `string` | `ReactElement` or an array of these
	     */
	    append?: EuiFormControlLayoutProps['append'];
	    /**
	     * Intended to be used with aria attributes. Some attributes may be overwritten.
	     */
	    minInputProps?: Partial<Omit<EuiRangeInputProps, 'max' | 'min' | 'step' | 'compressed' | 'autoSize' | 'fullWidth' | 'controlOnly'>>;
	    /**
	     *  Intended to be used with aria attributes. Some attributes may be overwritten.
	     */
	    maxInputProps?: EuiDualRangeProps['minInputProps'];
	}
	export interface EuiRangeTick {
	    value: number;
	    label: ReactNode;
	    accessibleLabel?: string;
	}
	export interface EuiRangeLevel extends CommonProps, Pick<_SharedRangeValuesProps, 'min' | 'max'> {
	    /**
	     * Accepts one of `["primary", "success", "warning", "danger"]` or a valid CSS color value.
	     */
	    color: EuiRangeLevelColor | CSSProperties['color'];
	}

}
declare module '@elastic/eui/src/components/form/range/range.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiRangeVariables: (euiThemeContext: UseEuiTheme) => {
	    trackColor: string;
	    highlightColor: string;
	    focusColor: string;
	    thumbHeight: string;
	    thumbWidth: string;
	    thumbBorderWidth: import("csstype").Property.BorderWidth<string | number> | undefined;
	    thumbBorderColor: string;
	    thumbBackgroundColor: string;
	    trackWidth: string;
	    trackHeight: string;
	    trackBorderWidth: string;
	    trackBorderColor: string;
	    trackBorderRadius: import("csstype").Property.BorderRadius<string | number> | undefined;
	    tickHeight: string;
	    tickWidth: string;
	    disabledOpacity: number;
	    highlightHeight: string;
	    height: string;
	    compressedHeight: string;
	    trackTopPositionWithTicks: string;
	    trackBottomPositionWithTicks: string;
	    trackTopPositionWithoutTicks: string;
	    levelsZIndex: number;
	    highlightZIndex: number;
	    thumbZIndex: number;
	};
	export const euiRangeTrackPerBrowser: (content: string) => string;
	export const euiRangeThumbBorder: (euiThemeContext: UseEuiTheme) => string;
	export const euiRangeThumbBoxShadow: (euiThemeContext: UseEuiTheme) => string;
	export const euiRangeThumbFocusBoxShadow: (euiThemeContext: UseEuiTheme) => string;
	export const euiRangeThumbStyle: (euiThemeContext: UseEuiTheme) => string;
	export const euiRangeThumbPerBrowser: (content: string) => string;
	export const euiRangeThumbFocus: (euiThemeContext: UseEuiTheme, color?: string | undefined) => string;
	export const euiRangeStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiRange: import("@emotion/utils").SerializedStyles;
	    hasInput: import("@emotion/utils").SerializedStyles;
	    euiRange__horizontalSpacer: import("@emotion/utils").SerializedStyles;
	    euiRange__slimHorizontalSpacer: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/range/range_draggable.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiRangeDraggableStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeDraggable: import("@emotion/utils").SerializedStyles;
	    hasTicks: import("@emotion/utils").SerializedStyles;
	    disabled: import("@emotion/utils").SerializedStyles;
	};
	export const euiRangeDraggableInnerStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeDraggable__inner: import("@emotion/utils").SerializedStyles;
	    enabled: import("@emotion/utils").SerializedStyles;
	    disabled: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/range/range_draggable' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import type { EuiDualRangeProps } from '@elastic/eui/src/components/form/range/types';
	export interface EuiRangeDraggableProps extends Omit<HTMLAttributes<HTMLDivElement>, 'onChange'>, Pick<EuiDualRangeProps, 'min' | 'max' | 'value' | 'disabled' | 'showTicks'> {
	    lowerPosition: string;
	    upperPosition: string;
	    onChange: (x: number, isFirstInteraction?: boolean) => void;
	}
	export const EuiRangeDraggable: FunctionComponent<EuiRangeDraggableProps>;

}
declare module '@elastic/eui/src/components/form/range/range_highlight.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiRangeHighlightStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeHighlight: import("@emotion/utils").SerializedStyles;
	    hasTicks: import("@emotion/utils").SerializedStyles;
	};
	export const euiRangeHighlightProgressStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeHighlight__progress: import("@emotion/utils").SerializedStyles;
	};
	export const euiRangeHighlightLevelsWrapperStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeHighlight__levelsWrapper: import("@emotion/utils").SerializedStyles;
	};
	export const euiRangeHighlightLevelsStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeHighlight__levels: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/range/range_levels.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiRangeLevelsStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeLevels: import("@emotion/utils").SerializedStyles;
	    hasRange: import("@emotion/utils").SerializedStyles;
	    hasTicks: import("@emotion/utils").SerializedStyles;
	};
	export const euiRangeLevelStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeLevel: import("@emotion/utils").SerializedStyles;
	    primary: import("@emotion/utils").SerializedStyles;
	    success: import("@emotion/utils").SerializedStyles;
	    warning: import("@emotion/utils").SerializedStyles;
	    danger: import("@emotion/utils").SerializedStyles;
	    customColor: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/range/utils' {
	export const EUI_THUMB_SIZE = 16;
	export const calculateThumbPosition: (value: number, min: number, max: number, trackWidth: number, thumbSize?: number) => number;

}
declare module '@elastic/eui/src/components/form/range/range_levels' {
	import { CSSProperties, FunctionComponent } from 'react';
	import type { EuiRangeProps } from '@elastic/eui/src/components/form/range/types';
	export interface EuiRangeLevelsProps extends Pick<EuiRangeProps, 'levels' | 'min' | 'max' | 'showTicks' | 'showRange'> {
	    trackWidth: number;
	    style?: CSSProperties;
	}
	export const EuiRangeLevels: FunctionComponent<EuiRangeLevelsProps>;

}
declare module '@elastic/eui/src/components/form/range/range_highlight' {
	import React, { FunctionComponent } from 'react';
	import type { EuiRangeProps } from '@elastic/eui/src/components/form/range/types';
	export interface EuiRangeHighlightProps extends Pick<EuiRangeProps, 'min' | 'max' | 'levels' | 'showTicks'> {
	    className?: string;
	    background?: string;
	    trackWidth: number;
	    lowerValue: number;
	    upperValue: number;
	    onClick?: (e: React.MouseEvent<HTMLDivElement>) => void;
	}
	export const EuiRangeHighlight: FunctionComponent<EuiRangeHighlightProps>;

}
declare module '@elastic/eui/src/components/form/range/range_label.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiRangeLabelStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeLabel: import("@emotion/utils").SerializedStyles;
	    min: import("@emotion/utils").SerializedStyles;
	    max: import("@emotion/utils").SerializedStyles;
	    isDisabled: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/range/range_label' {
	import { FunctionComponent } from 'react';
	import type { _SharedRangeInputProps, _SharedRangeInputSide } from '@elastic/eui/src/components/form/range/types';
	export interface EuiRangeLabelProps extends Pick<_SharedRangeInputProps, 'disabled'>, _SharedRangeInputSide {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: string | number;
	}
	export const EuiRangeLabel: FunctionComponent<EuiRangeLabelProps>;

}
declare module '@elastic/eui/src/components/form/range/range_slider.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiRangeSliderStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeSlider: import("@emotion/utils").SerializedStyles;
	    hasTicks: import("@emotion/utils").SerializedStyles;
	    hasRange: import("@emotion/utils").SerializedStyles;
	    hasLevels: import("@emotion/utils").SerializedStyles;
	};
	export const euiRangeSliderThumbStyles: (euiThemeContext: UseEuiTheme) => {
	    thumb: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/range/range_slider' {
	import { ChangeEventHandler, InputHTMLAttributes, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiResizeObserverProps } from '@elastic/eui/src/components/observer/resize_observer';
	import type { EuiRangeProps, EuiRangeLevel } from '@elastic/eui/src/components/form/range/types';
	export interface EuiRangeSliderProps extends Omit<InputHTMLAttributes<HTMLInputElement>, 'min' | 'max' | 'step' | 'onResize'>, CommonProps, Pick<EuiRangeProps, 'id' | 'name' | 'tabIndex' | 'min' | 'max' | 'step' | 'disabled' | 'isLoading' | 'showRange' | 'showTicks'> {
	    onChange?: ChangeEventHandler<HTMLInputElement>;
	    thumbColor?: EuiRangeLevel['color'];
	    onResize: EuiResizeObserverProps['onResize'];
	    ariaValueText?: string;
	}
	export const EuiRangeSlider: FunctionComponent<EuiRangeSliderProps>;

}
declare module '@elastic/eui/src/components/form/range/range_thumb.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiRangeThumbStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeThumb: import("@emotion/utils").SerializedStyles;
	    hasTicks: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/range/range_thumb' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	import type { EuiRangeProps } from '@elastic/eui/src/components/form/range/types';
	interface BaseProps extends CommonProps, Pick<EuiRangeProps, 'min' | 'max' | 'value' | 'disabled' | 'showInput' | 'showTicks'> {
	}
	interface ButtonLike extends BaseProps, HTMLAttributes<HTMLButtonElement> {
	}
	interface DivLike extends BaseProps, Omit<HTMLAttributes<HTMLDivElement>, 'onClick' | 'onMouseDown'> {
	}
	export type EuiRangeThumbProps = ExclusiveUnion<ButtonLike, DivLike>;
	export const EuiRangeThumb: FunctionComponent<EuiRangeThumbProps>;
	export {};

}
declare module '@elastic/eui/src/components/form/range/range_ticks.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiRangeTicksStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeTicks: import("@emotion/utils").SerializedStyles;
	    isCustom: import("@emotion/utils").SerializedStyles;
	    regular: import("@emotion/utils").SerializedStyles;
	    compressed: import("@emotion/utils").SerializedStyles;
	};
	export const euiRangeTickStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeTick: import("@emotion/utils").SerializedStyles;
	    compressed: import("@emotion/utils").SerializedStyles;
	    regular: import("@emotion/utils").SerializedStyles;
	    selected: import("@emotion/utils").SerializedStyles;
	    isCustom: import("@emotion/utils").SerializedStyles;
	    hasPseudoTickMark: import("@emotion/utils").SerializedStyles;
	    euiRangeTick__pseudo: import("@emotion/utils").SerializedStyles;
	    isMin: import("@emotion/utils").SerializedStyles;
	    isMax: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/range/range_ticks' {
	import { ButtonHTMLAttributes, MouseEventHandler, FunctionComponent } from 'react';
	import type { _SharedRangesValues, _SharedRangeDataStructures, _SharedRangeInputProps } from '@elastic/eui/src/components/form/range/types';
	export interface EuiRangeTicksProps extends Omit<ButtonHTMLAttributes<HTMLButtonElement>, 'value'>, _SharedRangesValues, Pick<_SharedRangeInputProps, 'compressed' | 'disabled'>, Pick<_SharedRangeDataStructures, 'ticks' | 'tickInterval'> {
	    tickSequence: number[];
	    trackWidth: number;
	    onChange?: MouseEventHandler<HTMLButtonElement>;
	}
	export const EuiRangeTicks: FunctionComponent<EuiRangeTicksProps>;

}
declare module '@elastic/eui/src/components/form/range/range_track.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiRangeTrackStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeTrack: import("@emotion/utils").SerializedStyles;
	    hasTicks: import("@emotion/utils").SerializedStyles;
	    disabled: import("@emotion/utils").SerializedStyles;
	    hasLevels: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/range/range_track' {
	import { FunctionComponent, MouseEventHandler, HTMLAttributes } from 'react';
	import type { _SharedRangesValues, _SharedRangeDataStructures, _SharedRangeVisualConfiguration, _SharedRangeInputProps } from '@elastic/eui/src/components/form/range/types';
	export interface EuiRangeTrackProps extends Omit<HTMLAttributes<HTMLDivElement>, 'onChange'>, _SharedRangesValues, _SharedRangeDataStructures, Pick<_SharedRangeVisualConfiguration, 'showTicks' | 'showRange'>, Pick<_SharedRangeInputProps, 'compressed' | 'disabled'> {
	    trackWidth: number;
	    onChange?: MouseEventHandler<HTMLButtonElement>;
	}
	export const EuiRangeTrack: FunctionComponent<EuiRangeTrackProps>;

}
declare module '@elastic/eui/src/components/form/range/range_wrapper.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiRangeWrapperStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeWrapper: import("@emotion/utils").SerializedStyles;
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	    formWidth: string;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/range/range_wrapper' {
	import React, { HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import type { _SharedRangeInputProps } from '@elastic/eui/src/components/form/range/types';
	export interface EuiRangeWrapperProps extends CommonProps, HTMLAttributes<HTMLDivElement>, Pick<_SharedRangeInputProps, 'fullWidth' | 'compressed'> {
	}
	export const EuiRangeWrapper: React.ForwardRefExoticComponent<EuiRangeWrapperProps & React.RefAttributes<HTMLDivElement>>;

}
declare module '@elastic/eui/src/components/form/range/dual_range.styles' {
	export const euiDualRangeStyles: () => {
	    euiDualRange: import("@emotion/utils").SerializedStyles;
	    euiDualRange__slider: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/range/dual_range' {
	
	import React, { Component } from 'react';
	import { WithEuiThemeProps } from '@elastic/eui/src/services';
	import { FormContextValue } from '@elastic/eui/src/components/form/eui_form_context';
	import type { EuiDualRangeProps, _SingleRangeValue } from '@elastic/eui/src/components/form/range/types'; type ValueMember = _SingleRangeValue['value'];
	export class EuiDualRangeClass extends Component<EuiDualRangeProps & WithEuiThemeProps> {
	    static contextType: React.Context<FormContextValue>;
	    static defaultProps: {
	        min: number;
	        max: number;
	        step: number;
	        compressed: boolean;
	        isLoading: boolean;
	        showLabels: boolean;
	        showInput: boolean;
	        showRange: boolean;
	        showTicks: boolean;
	        levels: never[];
	    };
	    state: {
	        id: string;
	        isPopoverOpen: boolean;
	        rangeWidth: number;
	    };
	    get isInPopover(): boolean;
	    preventPopoverClose: boolean;
	    private leftPosition;
	    private dragAcc;
	    get lowerValue(): string | number;
	    get upperValue(): string | number;
	    get lowerValueIsValid(): boolean;
	    get upperValueIsValid(): boolean;
	    get isValid(): boolean;
	    _determineInvalidThumbMovement: (newVal: ValueMember, lower: ValueMember, upper: ValueMember, e: React.ChangeEvent<HTMLInputElement> | React.MouseEvent<HTMLButtonElement> | React.KeyboardEvent<HTMLInputElement>) => void;
	    _determineValidThumbMovement: (newVal: ValueMember, lower: ValueMember, upper: ValueMember, e: React.ChangeEvent<HTMLInputElement> | React.MouseEvent<HTMLButtonElement>) => void;
	    _determineThumbMovement: (newVal: number, e: React.ChangeEvent<HTMLInputElement> | React.MouseEvent<HTMLButtonElement>) => void;
	    _handleOnChange: (lower: ValueMember, upper: ValueMember, e?: React.KeyboardEvent<HTMLDivElement> | React.MouseEvent<HTMLButtonElement, MouseEvent> | React.ChangeEvent<HTMLInputElement> | React.KeyboardEvent<HTMLInputElement> | undefined) => void;
	    handleSliderChange: (e: React.ChangeEvent<HTMLInputElement> | React.MouseEvent<HTMLButtonElement>) => void;
	    _resetToRangeEnds: (e: React.KeyboardEvent<HTMLInputElement>) => void;
	    _isDirectionalKeyPress: (event: React.KeyboardEvent<HTMLInputElement>) => boolean;
	    handleInputKeyDown: (e: React.KeyboardEvent<HTMLInputElement>) => void;
	    handleLowerInputChange: (e: React.ChangeEvent<HTMLInputElement>) => void;
	    handleUpperInputChange: (e: React.ChangeEvent<HTMLInputElement>) => void;
	    _handleKeyDown: (value: ValueMember, event: React.KeyboardEvent<HTMLInputElement> | React.KeyboardEvent<HTMLDivElement>) => number;
	    handleLowerKeyDown: (event: React.KeyboardEvent<HTMLInputElement>) => void;
	    handleUpperKeyDown: (event: React.KeyboardEvent<HTMLInputElement>) => void;
	    handleDraggableKeyDown: (event: React.KeyboardEvent<HTMLDivElement>) => void;
	    calculateThumbPositionStyle: (value: number, width?: number | undefined) => {
	        left: string;
	    };
	    onThumbFocus: (e: React.FocusEvent<HTMLDivElement>) => void;
	    onThumbBlur: (e: React.FocusEvent<HTMLDivElement>) => void;
	    onInputFocus: (e: React.FocusEvent<HTMLInputElement>) => void;
	    onInputBlur: (e: React.FocusEvent<HTMLInputElement>) => NodeJS.Timeout;
	    closePopover: () => void;
	    setRangeWidth: ({ width }: {
	        width: number;
	    }) => void;
	    getNearestStep: (value: number) => number;
	    handleDrag: (x: number, isFirstInteraction?: boolean | undefined) => void;
	    render(): React.JSX.Element;
	}
	export const EuiDualRange: React.ForwardRefExoticComponent<Omit<EuiDualRangeProps, "theme"> & React.RefAttributes<Omit<EuiDualRangeProps, "theme">>>;
	export {};

}
declare module '@elastic/eui/src/components/form/range/range_tooltip.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiRangeTooltipStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeTooltip: import("@emotion/utils").SerializedStyles;
	};
	export const euiRangeTooltipValueStyles: (euiThemeContext: UseEuiTheme) => {
	    euiRangeTooltip__value: import("@emotion/utils").SerializedStyles;
	    left: import("@emotion/utils").SerializedStyles;
	    right: import("@emotion/utils").SerializedStyles;
	    hasTicks: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/form/range/range_tooltip' {
	import { FunctionComponent } from 'react';
	import type { EuiRangeProps } from '@elastic/eui/src/components/form/range/types';
	export interface EuiRangeTooltipProps extends Pick<EuiRangeProps, 'min' | 'max' | 'value' | 'valueAppend' | 'valuePrepend' | 'showTicks'> {
	    name?: string;
	}
	export const EuiRangeTooltip: FunctionComponent<EuiRangeTooltipProps>;

}
declare module '@elastic/eui/src/components/form/range/range' {
	
	import React, { Component } from 'react';
	import { WithEuiThemeProps } from '@elastic/eui/src/services';
	import { FormContextValue } from '@elastic/eui/src/components/form/eui_form_context';
	import type { EuiRangeProps, EuiRangeTick } from '@elastic/eui/src/components/form/range/types';
	export class EuiRangeClass extends Component<EuiRangeProps & WithEuiThemeProps> {
	    static contextType: React.Context<FormContextValue>;
	    static defaultProps: {
	        min: number;
	        max: number;
	        step: number;
	        compressed: boolean;
	        isLoading: boolean;
	        showLabels: boolean;
	        showInput: boolean;
	        showRange: boolean;
	        showTicks: boolean;
	        showValue: boolean;
	        levels: never[];
	    };
	    preventPopoverClose: boolean;
	    state: {
	        id: string;
	        isPopoverOpen: boolean;
	        trackWidth: number;
	    };
	    handleOnChange: (e: React.ChangeEvent<HTMLInputElement> | React.MouseEvent<HTMLButtonElement>) => void;
	    get isValid(): boolean;
	    setTrackWidth: ({ width }: {
	        width: number;
	    }) => void;
	    onInputFocus: (e: React.FocusEvent<HTMLInputElement>) => void;
	    onInputBlur: (e: React.FocusEvent<HTMLInputElement>) => NodeJS.Timeout;
	    closePopover: () => void;
	    handleAriaValueText: (ticks: EuiRangeTick[], currentVal: string | number) => string | undefined;
	    render(): React.JSX.Element;
	}
	export const EuiRange: React.ForwardRefExoticComponent<Omit<EuiRangeProps, "theme"> & React.RefAttributes<Omit<EuiRangeProps, "theme">>>;

}
declare module '@elastic/eui/src/components/form/range' {
	export { EuiDualRange } from '@elastic/eui/src/components/form/range/dual_range';
	export { EuiRange } from '@elastic/eui/src/components/form/range/range';
	export type { EuiRangeProps, EuiDualRangeProps, EuiRangeTick, EuiRangeLevel, } from '@elastic/eui/src/components/form/range/types';

}
declare module '@elastic/eui/src/components/form/select/select.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiSelectStyles: (euiThemeContext: UseEuiTheme) => {
	    euiSelect: import("@emotion/utils").SerializedStyles;
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	    formWidth: string;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    inGroup: import("@emotion/utils").SerializedStyles;
	    lineHeight: {
	        removePadding: string;
	        uncompressed: string;
	        compressed: string;
	        inGroup: {
	            uncompressed: string;
	            compressed: string;
	        };
	    };
	};

}
declare module '@elastic/eui/src/components/form/select/select' {
	import React, { SelectHTMLAttributes, OptionHTMLAttributes, Ref, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiFormControlLayoutProps } from '@elastic/eui/src/components/form/form_control_layout';
	export interface EuiSelectOption extends OptionHTMLAttributes<HTMLOptionElement> {
	    text: React.ReactNode;
	}
	export type EuiSelectProps = Omit<SelectHTMLAttributes<HTMLSelectElement>, 'value'> & CommonProps & {
	    /**
	     * @default []
	     */
	    options?: EuiSelectOption[];
	    isInvalid?: boolean;
	    /**
	     * Expand to fill 100% of the parent.
	     * Defaults to `fullWidth` prop of `<EuiForm>`.
	     * @default false
	     */
	    fullWidth?: boolean;
	    isLoading?: boolean;
	    /**
	     * Simulates no selection by creating an empty, selected, hidden first option
	     * @default false
	     */
	    hasNoInitialSelection?: boolean;
	    inputRef?: Ref<HTMLSelectElement>;
	    value?: string | number;
	    /**
	     * when `true` creates a shorter height input
	     * @default false
	     */
	    compressed?: boolean;
	    /**
	     * Creates an input group with element(s) coming before select.
	     * `string` | `ReactElement` or an array of these
	     */
	    prepend?: EuiFormControlLayoutProps['prepend'];
	    /**
	     * Creates an input group with element(s) coming after select.
	     * `string` | `ReactElement` or an array of these
	     */
	    append?: EuiFormControlLayoutProps['append'];
	};
	export const EuiSelect: FunctionComponent<EuiSelectProps>;

}
declare module '@elastic/eui/src/components/form/select' {
	export type { EuiSelectProps, EuiSelectOption } from '@elastic/eui/src/components/form/select/select';
	export { EuiSelect } from '@elastic/eui/src/components/form/select/select';

}
declare module '@elastic/eui/src/components/form/switch/switch.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiSwitchStyles: (euiThemeContext: UseEuiTheme) => {
	    euiSwitch: import("@emotion/utils").SerializedStyles;
	    enabled: string;
	    disabled: import("@emotion/utils").SerializedStyles;
	    button: {
	        euiSwitch__button: import("@emotion/utils").SerializedStyles;
	        uncompressed: string;
	        compressed: import("@emotion/utils").SerializedStyles;
	        mini: import("@emotion/utils").SerializedStyles;
	    };
	    body: {
	        euiSwitch__body: import("@emotion/utils").SerializedStyles;
	        on: import("@emotion/utils").SerializedStyles;
	        off: import("@emotion/utils").SerializedStyles;
	        disabled: {
	            uncompressed: import("@emotion/utils").SerializedStyles;
	            compressed: import("@emotion/utils").SerializedStyles;
	            mini: import("@emotion/utils").SerializedStyles;
	        };
	    };
	    icons: {
	        euiSwitch__icons: import("@emotion/utils").SerializedStyles;
	        on: import("@emotion/utils").SerializedStyles;
	        off: import("@emotion/utils").SerializedStyles;
	        enabled: import("@emotion/utils").SerializedStyles;
	        disabled: import("@emotion/utils").SerializedStyles;
	    };
	    thumb: {
	        euiSwitch__thumb: import("@emotion/utils").SerializedStyles;
	        off: import("@emotion/utils").SerializedStyles;
	        readonly on: {
	            uncompressed: import("@emotion/utils").SerializedStyles;
	            compressed: import("@emotion/utils").SerializedStyles;
	            mini: import("@emotion/utils").SerializedStyles;
	        };
	        enabled: {
	            enabled: string;
	            uncompressed: string;
	            compressed: string;
	            mini: string;
	        };
	        disabled: {
	            disabled: import("@emotion/utils").SerializedStyles;
	            uncompressed: string;
	            compressed: string;
	            mini: string;
	        };
	    };
	    label: {
	        euiSwitch__label: import("@emotion/utils").SerializedStyles;
	        uncompressed: string;
	        compressed: import("@emotion/utils").SerializedStyles;
	        mini: import("@emotion/utils").SerializedStyles;
	        disabled: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/form/switch/switch' {
	import React, { ButtonHTMLAttributes, HTMLAttributes, FunctionComponent, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiSwitchEvent = React.BaseSyntheticEvent<React.MouseEvent<HTMLButtonElement>, HTMLButtonElement, EventTarget & {
	    checked: boolean;
	}>;
	export type EuiSwitchProps = CommonProps & Omit<ButtonHTMLAttributes<HTMLButtonElement>, 'onChange' | 'disabled'> & {
	    /**
	     * Whether to render the text label
	     */
	    showLabel?: boolean;
	    /**
	     * Must be a string if `showLabel` prop is false
	     */
	    label: ReactNode | string;
	    checked: boolean;
	    onChange: (event: EuiSwitchEvent) => void;
	    disabled?: boolean;
	    /**
	     * Compressed switches are smaller and contain no icon signifiers
	     */
	    compressed?: boolean;
	    /**
	     * Object of props passed to the label's `<span />`
	     */
	    labelProps?: CommonProps & HTMLAttributes<HTMLSpanElement>;
	};
	export const EuiSwitch: FunctionComponent<EuiSwitchProps & {
	    /**
	     * Mini styling is similar to compressed, but even smaller.
	     * It's undocumented because it has very specific uses.
	     */
	    mini?: boolean;
	}>;

}
declare module '@elastic/eui/src/components/form/switch' {
	export type { EuiSwitchProps, EuiSwitchEvent } from '@elastic/eui/src/components/form/switch/switch';
	export { EuiSwitch } from '@elastic/eui/src/components/form/switch/switch';

}
declare module '@elastic/eui/src/components/form/text_area/text_area.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiTextAreaStyles: (euiThemeContext: UseEuiTheme) => {
	    euiTextArea: import("@emotion/utils").SerializedStyles;
	    resize: {
	        vertical: import("@emotion/utils").SerializedStyles;
	        horizontal: import("@emotion/utils").SerializedStyles;
	        both: import("@emotion/utils").SerializedStyles;
	        none: import("@emotion/utils").SerializedStyles;
	    };
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	    formWidth: string;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    formControlLayout: {
	        euiTextArea: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/form/text_area/text_area' {
	import { TextareaHTMLAttributes, Ref, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiFormControlLayoutIconsProps } from '@elastic/eui/src/components/form/form_control_layout/form_control_layout_icons';
	export const RESIZE: readonly ["vertical", "horizontal", "both", "none"];
	export type EuiTextAreaProps = TextareaHTMLAttributes<HTMLTextAreaElement> & CommonProps & {
	    icon?: EuiFormControlLayoutIconsProps['icon'];
	    isLoading?: boolean;
	    isInvalid?: boolean;
	    /**
	     * Shows a button that allows users to quickly clear the textarea
	     */
	    isClearable?: boolean;
	    /**
	     * Expand to fill 100% of the parent.
	     * Defaults to `fullWidth` prop of `<EuiForm>`.
	     * @default false
	     */
	    fullWidth?: boolean;
	    compressed?: boolean;
	    /**
	     * Which direction, if at all, should the textarea resize
	     * @default vertical
	     */
	    resize?: (typeof RESIZE)[number];
	    inputRef?: Ref<HTMLTextAreaElement>;
	};
	export const EuiTextArea: FunctionComponent<EuiTextAreaProps>;

}
declare module '@elastic/eui/src/components/form/text_area' {
	export type { EuiTextAreaProps } from '@elastic/eui/src/components/form/text_area/text_area';
	export { EuiTextArea } from '@elastic/eui/src/components/form/text_area/text_area';

}
declare module '@elastic/eui/src/components/form' {
	export * from '@elastic/eui/src/components/form/checkbox';
	export * from '@elastic/eui/src/components/form/described_form_group';
	export * from '@elastic/eui/src/components/form/field_number';
	export * from '@elastic/eui/src/components/form/field_password';
	export * from '@elastic/eui/src/components/form/field_search';
	export * from '@elastic/eui/src/components/form/field_text';
	export * from '@elastic/eui/src/components/form/file_picker';
	export * from '@elastic/eui/src/components/form/form';
	export * from '@elastic/eui/src/components/form/form_control_layout';
	export * from '@elastic/eui/src/components/form/form_error_text';
	export * from '@elastic/eui/src/components/form/form_fieldset';
	export * from '@elastic/eui/src/components/form/form_help_text';
	export * from '@elastic/eui/src/components/form/form_label';
	export * from '@elastic/eui/src/components/form/form_row';
	export * from '@elastic/eui/src/components/form/radio';
	export * from '@elastic/eui/src/components/form/range';
	export * from '@elastic/eui/src/components/form/select';
	export * from '@elastic/eui/src/components/form/super_select';
	export * from '@elastic/eui/src/components/form/switch';
	export * from '@elastic/eui/src/components/form/text_area';
	export * from '@elastic/eui/src/components/form/validatable_control';

}
declare module '@elastic/eui/src/components/card/checkable_card/checkable_card.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCheckableCardStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCheckableCard: import("@emotion/utils").SerializedStyles;
	    isChecked: import("@emotion/utils").SerializedStyles;
	    label: {
	        euiCheckableCard__label: import("@emotion/utils").SerializedStyles;
	        isDisabled: import("@emotion/utils").SerializedStyles;
	    };
	    euiCheckableCard__children: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/card/checkable_card/checkable_card' {
	import { FunctionComponent, ReactNode } from 'react';
	import { EuiRadioProps, EuiCheckboxProps } from '@elastic/eui/src/components/form';
	import { _EuiSplitPanelOuterProps } from '@elastic/eui/src/components/panel/split_panel';
	interface EuiCheckableCardBaseProps {
	    id: string;
	    label: ReactNode;
	    hasShadow?: _EuiSplitPanelOuterProps['hasShadow'];
	    hasBorder?: _EuiSplitPanelOuterProps['hasBorder'];
	}
	interface EuiCheckableCardAsRadioProps extends Omit<EuiRadioProps, 'compressed'> {
	    /**
	     * Whether the control is a radio button or checkbox
	     */
	    checkableType?: 'radio';
	}
	interface EuiCheckableCardAsCheckboxProps extends Omit<EuiCheckboxProps, 'compressed'> {
	    checkableType: 'checkbox';
	}
	export type EuiCheckableCardProps = Omit<EuiCheckableCardAsCheckboxProps | EuiCheckableCardAsRadioProps, 'label' | 'id'> & EuiCheckableCardBaseProps;
	export const EuiCheckableCard: FunctionComponent<EuiCheckableCardProps>;
	export {};

}
declare module '@elastic/eui/src/components/card/checkable_card' {
	export type { EuiCheckableCardProps } from '@elastic/eui/src/components/card/checkable_card/checkable_card';
	export { EuiCheckableCard } from '@elastic/eui/src/components/card/checkable_card/checkable_card';

}
declare module '@elastic/eui/src/components/card' {
	export type { EuiCardProps } from '@elastic/eui/src/components/card/card';
	export { EuiCard } from '@elastic/eui/src/components/card/card';
	export type { EuiCheckableCardProps } from '@elastic/eui/src/components/card/checkable_card';
	export { EuiCheckableCard } from '@elastic/eui/src/components/card/checkable_card';

}
declare module '@elastic/eui/src/components/code/code_block_annotations.style' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCodeBlockAnnotationsStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiCodeBlockAnnotation: import("@emotion/utils").SerializedStyles;
	    euiCodeBlockAnnotation__buttonIcon: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/code/code_block_annotations' {
	import { FunctionComponent, PropsWithChildren, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type LineAnnotationMap = Record<number, ReactNode>; type EuiCodeBlockAnnotationProps = PropsWithChildren & CommonProps & {
	    lineNumber: number;
	};
	export const EuiCodeBlockAnnotation: FunctionComponent<EuiCodeBlockAnnotationProps>;
	export {};

}
declare module '@elastic/eui/src/components/code/code_block_line.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCodeBlockLineStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCodeBlock__line: string;
	    hasLineNumbers: string;
	    lineText: {
	        euiCodeBlock__lineText: string;
	        isHighlighted: string;
	    };
	    lineNumber: {
	        euiCodeBlock__lineNumberWrapper: string;
	        euiCodeBlock__lineNumber: string;
	    };
	};

}
declare module '@elastic/eui/src/components/code/utils' {
	import { ReactElement, ReactNode, HTMLAttributes } from 'react';
	import { AST, RefractorNode } from 'refractor';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { UseEuiTheme } from '@elastic/eui/src/services';
	import { LineAnnotationMap } from '@elastic/eui/src/components/code/code_block_annotations';
	/**
	 * Utils shared between EuiCode and EuiCodeBlock
	 */
	export type EuiCodeSharedProps = CommonProps & HTMLAttributes<HTMLElement> & {
	    /**
	     * Sets the syntax highlighting for a specific language
	     * @see [https://prismjs.com/#supported-languages](https://prismjs.com/#supported-languages) for options
	     */
	    language?: string;
	    transparentBackground?: boolean;
	};
	export const SUPPORTED_LANGUAGES: string[];
	export const DEFAULT_LANGUAGE = "text";
	/**
	 * Platform-agnostic new line regex that safely matches all standard
	 * line termination conventions:
	 * - LF: Unix-based platforms and JS-native sources like text areas
	 * - CRLF: Windows
	 * - CR: Mac Classic; to support files saved a long time ago
	 */
	export const NEW_LINE_REGEX: RegExp;
	/**
	 * Platform-agnostic global new line regex that safely matches all standard
	 * line termination conventions.
	 * See [NEW_LINE_REGEX]{@link NEW_LINE_REGEX} for more details.
	 */
	export const NEW_LINE_REGEX_GLOBAL: RegExp;
	export const checkSupportedLanguage: (language: string) => string;
	export const getHtmlContent: (data: RefractorNode[], children: ReactNode) => ReactElement[] | ReactNode;
	export const isAstElement: (node: RefractorNode) => node is AST.Element;
	export const nodeToHtml: (node: RefractorNode, idx: number, nodes: RefractorNode[], depth?: number) => ReactElement;
	interface LineNumbersConfig {
	    start: number;
	    show: boolean;
	    highlight?: string;
	    annotations?: LineAnnotationMap;
	}
	export const parseLineRanges: (ranges: string) => number[];
	export const highlightByLine: (children: string, language: string, data: LineNumbersConfig, euiTheme: UseEuiTheme) => RefractorNode[];
	export {};

}
declare module '@elastic/eui/src/components/code/code_syntax.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCodeSyntaxVariables: ({ euiTheme }: UseEuiTheme) => {
	    backgroundColor: string;
	    color: string;
	    inlineCodeColor: string;
	    selectedBackgroundColor: string;
	    commentColor: string;
	    selectorTagColor: string;
	    stringColor: string;
	    tagColor: string;
	    nameColor: string;
	    numberColor: string;
	    keywordColor: string;
	    functionTitleColor: string;
	    typeColor: string;
	    attributeColor: string;
	    symbolColor: string;
	    paramsColor: string;
	    metaColor: string;
	    titleColor: string;
	    sectionColor: string;
	    additionColor: string;
	    deletionColor: string;
	    selectorClassColor: string;
	    selectorIdColor: string;
	    readonly tokensCss: string;
	};

}
declare module '@elastic/eui/src/components/code/code.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCodeStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCode: import("@emotion/utils").SerializedStyles;
	    transparentBackground: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/code/code' {
	import { FunctionComponent } from 'react';
	import { EuiCodeSharedProps } from '@elastic/eui/src/components/code/utils';
	export type EuiCodeProps = EuiCodeSharedProps;
	export const EuiCode: FunctionComponent<EuiCodeProps>;

}
declare module '@elastic/eui/src/components/code/code_block_overflow' {
	import { CSSProperties } from 'react';
	/**
	 * Overflow logic - returns overflow-related state/logic/utils
	 *
	 * Detects whether the code block overflows and returns a tabIndex of 0 if so,
	 * which allows keyboard users to use the up/down arrow keys to scroll through
	 * the container.
	 */
	export const useOverflow: ({ overflowHeight, }: {
	    overflowHeight?: string | number | undefined;
	}) => {
	    setWrapperRef: import("react").Dispatch<import("react").SetStateAction<Element | null>>;
	    tabIndex: 0 | -1;
	    overflowHeightStyles: CSSProperties;
	};

}
declare module '@elastic/eui/src/components/copy/copy' {
	import React, { Component, ReactElement, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiToolTipProps } from '@elastic/eui/src/components/tool_tip';
	export interface EuiCopyProps extends CommonProps, Partial<Omit<EuiToolTipProps, 'children'>> {
	    /**
	     * Text that will be copied to clipboard when copy function is executed.
	     */
	    textToCopy: string;
	    /**
	     * Tooltip message displayed before copy function is called.
	     */
	    beforeMessage?: ReactNode;
	    /**
	     * Tooltip message displayed after copy function is called that lets the user know that
	     * 'textToCopy' has been copied to the clipboard.
	     */
	    afterMessage?: ReactNode;
	    /**
	     * Function that must return a component. First argument is 'copy' function.
	     * Use your own logic to create the component that users interact with when triggering copy.
	     */
	    children(copy: () => void): ReactElement;
	}
	interface EuiCopyState {
	    tooltipText: ReactNode;
	}
	export class EuiCopy extends Component<EuiCopyProps, EuiCopyState> {
	    static defaultProps: {
	        afterMessage: string;
	    };
	    constructor(props: EuiCopyProps);
	    copy: () => void;
	    resetTooltipText: () => void;
	    render(): React.JSX.Element;
	}
	export {};

}
declare module '@elastic/eui/src/components/copy' {
	export type { EuiCopyProps } from '@elastic/eui/src/components/copy/copy';
	export { EuiCopy } from '@elastic/eui/src/components/copy/copy';

}
declare module '@elastic/eui/src/components/code/code_block_copy' {
	import React, { ReactNode } from 'react';
	/**
	 * Hook that returns copy-related state/logic/utils
	 */
	export const useCopy: ({ copyAriaLabel, isCopyable, isVirtualized, children, }: {
	    copyAriaLabel?: string | undefined;
	    isCopyable: boolean;
	    isVirtualized: boolean;
	    children: ReactNode;
	}) => {
	    innerTextRef: (node: HTMLElement | Element | null | undefined) => void;
	    copyButton: React.JSX.Element | null;
	};

}
declare module '@elastic/eui/src/components/overlay_mask/overlay_mask.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiOverlayMaskStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiOverlayMask: string;
	    aboveHeader: string;
	    belowHeader: string;
	};

}
declare module '@elastic/eui/src/components/overlay_mask/overlay_mask_body.styles' {
	export const euiOverlayMaskBodyStyles: import("@emotion/utils").SerializedStyles;

}
declare module '@elastic/eui/src/components/overlay_mask/overlay_mask' {
	import { FunctionComponent, HTMLAttributes, MutableRefObject, ReactNode, Ref } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export interface EuiOverlayMaskInterface {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children?: ReactNode;
	    /**
	     * Should the mask visually sit above or below the EuiHeader (controlled by z-index)
	     */
	    headerZindexLocation?: 'above' | 'below';
	    /**
	     * React ref to be passed to the wrapping container
	     */
	    maskRef?: Ref<HTMLDivElement> | MutableRefObject<HTMLDivElement>;
	}
	export type EuiOverlayMaskProps = Omit<CommonProps, 'css'> & Omit<Partial<Record<keyof HTMLAttributes<HTMLDivElement>, string>>, keyof EuiOverlayMaskInterface> & EuiOverlayMaskInterface;
	export const EuiOverlayMask: FunctionComponent<EuiOverlayMaskProps>;

}
declare module '@elastic/eui/src/components/overlay_mask' {
	export type { EuiOverlayMaskProps } from '@elastic/eui/src/components/overlay_mask/overlay_mask';
	export { EuiOverlayMask } from '@elastic/eui/src/components/overlay_mask/overlay_mask';

}
declare module '@elastic/eui/src/components/code/code_block.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCodeBlockStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCodeBlock: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    transparentBackground: import("@emotion/utils").SerializedStyles;
	    isFullScreen: import("@emotion/utils").SerializedStyles;
	    hasControls: {
	        none: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	        l: import("@emotion/utils").SerializedStyles;
	        xl: import("@emotion/utils").SerializedStyles;
	    };
	    hasBothControls: {
	        none: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	        l: import("@emotion/utils").SerializedStyles;
	        xl: import("@emotion/utils").SerializedStyles;
	    };
	};
	export const euiCodeBlockPreStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCodeBlock__pre: import("@emotion/utils").SerializedStyles;
	    padding: {
	        none: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	        l: import("@emotion/utils").SerializedStyles;
	        xl: import("@emotion/utils").SerializedStyles;
	    };
	    whiteSpace: {
	        pre: {
	            pre: import("@emotion/utils").SerializedStyles;
	            controlsOffset: {
	                none: import("@emotion/utils").SerializedStyles;
	                s: import("@emotion/utils").SerializedStyles;
	                m: import("@emotion/utils").SerializedStyles;
	                l: import("@emotion/utils").SerializedStyles;
	                xl: import("@emotion/utils").SerializedStyles;
	            };
	        };
	        preWrap: {
	            preWrap: import("@emotion/utils").SerializedStyles;
	            controlsOffset: {
	                none: import("@emotion/utils").SerializedStyles;
	                s: import("@emotion/utils").SerializedStyles;
	                m: import("@emotion/utils").SerializedStyles;
	                l: import("@emotion/utils").SerializedStyles;
	                xl: import("@emotion/utils").SerializedStyles;
	            };
	        };
	    };
	};
	export const euiCodeBlockCodeStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCodeBlock__code: import("@emotion/utils").SerializedStyles;
	    isVirtualized: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/delay_render/delay_render' {
	import { Component, PropsWithChildren } from 'react';
	export interface EuiDelayRenderProps extends PropsWithChildren {
	    delay: number;
	}
	interface EuiDelayRenderState {
	    toggle: boolean;
	}
	export class EuiDelayRender extends Component<EuiDelayRenderProps, EuiDelayRenderState> {
	    static defaultProps: {
	        delay: number;
	    };
	    private delayID;
	    private toBeDelayed;
	    constructor(props: EuiDelayRenderProps);
	    shouldUpdate(): void;
	    startDelaying: () => void;
	    stopDelaying: () => void;
	    componentDidMount(): void;
	    shouldComponentUpdate(): boolean;
	    componentWillUnmount(): void;
	    componentDidUpdate(): void;
	    render(): import("react").ReactNode;
	}
	export {};

}
declare module '@elastic/eui/src/components/delay_render' {
	export type { EuiDelayRenderProps } from '@elastic/eui/src/components/delay_render/delay_render';
	export { EuiDelayRender } from '@elastic/eui/src/components/delay_render/delay_render';

}
declare module '@elastic/eui/src/components/code/code_block_full_screen' {
	import React, { FunctionComponent, KeyboardEvent, PropsWithChildren } from 'react';
	/**
	 * Hook that returns fullscreen-related state/logic/utils
	 */
	export const useFullScreen: ({ overflowHeight, }: {
	    overflowHeight?: string | number | undefined;
	}) => {
	    fullScreenButton: React.JSX.Element | null;
	    isFullScreen: boolean;
	    onKeyDown: (event: KeyboardEvent<HTMLElement>) => void;
	};
	/**
	 * Portalled full screen wrapper
	 */
	export const EuiCodeBlockFullScreenWrapper: FunctionComponent<PropsWithChildren & {
	    onClose: (event: React.KeyboardEvent<HTMLElement>) => void;
	}>;

}
declare module '@elastic/eui/src/components/code/code_block_controls.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCodeBlockControlsStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCodeBlock__controls: import("@emotion/utils").SerializedStyles;
	    offset: {
	        none: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	        l: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/code/code_block_controls' {
	import { FC, ReactNode } from 'react';
	import type { EuiCodeBlockPaddingSize } from '@elastic/eui/src/components/code/code_block';
	export const EuiCodeBlockControls: FC<{
	    controls: ReactNode[];
	    paddingSize: EuiCodeBlockPaddingSize;
	}>;

}
declare module '@elastic/eui/src/components/code/code_block_virtualized' {
	import React, { HTMLAttributes } from 'react';
	import { RefractorNode } from 'refractor';
	export const EuiCodeBlockVirtualized: ({ data, rowHeight, overflowHeight, preProps, codeProps, }: {
	    data: RefractorNode[];
	    rowHeight: number;
	    overflowHeight?: string | number | undefined;
	    preProps: HTMLAttributes<HTMLPreElement>;
	    codeProps: HTMLAttributes<HTMLElement>;
	}) => React.JSX.Element;

}
declare module '@elastic/eui/src/components/code/code_block' {
	import { FunctionComponent } from 'react';
	import { ExclusiveUnion } from '@elastic/eui/src/components/common';
	import { EuiCodeSharedProps } from '@elastic/eui/src/components/code/utils';
	import { LineAnnotationMap } from '@elastic/eui/src/components/code/code_block_annotations';
	export const FONT_SIZES: readonly ["s", "m", "l"];
	export type EuiCodeBlockFontSize = (typeof FONT_SIZES)[number];
	export const PADDING_SIZES: readonly ["none", "s", "m", "l"];
	export type EuiCodeBlockPaddingSize = (typeof PADDING_SIZES)[number]; type VirtualizedOptionProps = ExclusiveUnion<{
	    isVirtualized: true;
	    overflowHeight: number | string;
	    whiteSpace?: 'pre';
	}, {
	    isVirtualized?: false;
	    overflowHeight?: number | string;
	    whiteSpace?: 'pre' | 'pre-wrap';
	}>;
	interface LineNumbersConfig {
	    start?: number;
	    highlight?: string;
	    annotations?: LineAnnotationMap;
	}
	export type EuiCodeBlockProps = EuiCodeSharedProps & {
	    paddingSize?: EuiCodeBlockPaddingSize;
	    fontSize?: EuiCodeBlockFontSize;
	    /**
	     * Specify how `white-space` inside the element is handled.
	     * `pre` respects line breaks/white space but doesn't force them to wrap the line
	     * `pre-wrap` respects line breaks/white space but does force them to wrap the line when necessary.
	     */
	    whiteSpace?: 'pre' | 'pre-wrap';
	    /**
	     * Displays an icon button to copy the code snippet to the clipboard.
	     */
	    isCopyable?: boolean;
	    /**
	     * Customizes the aria-label for the copy button.
	     *
	     * @default 'Copy'
	     */
	    copyAriaLabel?: string;
	    /**
	     * Displays line numbers.
	     * Optionally accepts a configuration object for setting the starting number,
	     * visually highlighting ranges, or annotating specific lines:
	     * `{ start: 100, highlight: '1, 5-10, 20-30, 40', annotations: { 6: 'A special note about this line' } }`
	     */
	    lineNumbers?: boolean | LineNumbersConfig;
	    /**
	     * Sets the maximum container height.
	     * Accepts a pixel value (`300`) or a percentage (`'100%'`)
	     * Ensure the container has calcuable height when using a percentage
	     */
	    overflowHeight?: number | string;
	    /**
	     * Renders code block lines virtually.
	     * Useful for improving load times of large code blocks.
	     *
	     * When using this configuration, `overflowHeight` is required and
	     * `whiteSpace` can only be `pre`.
	     */
	    isVirtualized?: boolean;
	} & VirtualizedOptionProps;
	export const EuiCodeBlock: FunctionComponent<EuiCodeBlockProps>;
	export {};

}
declare module '@elastic/eui/src/components/code' {
	export type { EuiCodeProps } from '@elastic/eui/src/components/code/code';
	export { EuiCode } from '@elastic/eui/src/components/code/code';
	export type { EuiCodeBlockProps } from '@elastic/eui/src/components/code/code_block';
	export { EuiCodeBlock } from '@elastic/eui/src/components/code/code_block';

}
declare module '@elastic/eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCollapsibleNavGroupStyles: ({ euiTheme, colorMode, }: UseEuiTheme) => {
	    euiCollapsibleNavGroup: import("@emotion/utils").SerializedStyles;
	    none: import("@emotion/utils").SerializedStyles;
	    light: import("@emotion/utils").SerializedStyles;
	    dark: import("@emotion/utils").SerializedStyles;
	    isCollapsible: import("@emotion/utils").SerializedStyles;
	    notCollapsible: import("@emotion/utils").SerializedStyles;
	    childrenWrapper: {
	        euiCollapsibleNavGroup__children: import("@emotion/utils").SerializedStyles;
	        withHeading: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group' {
	import { FunctionComponent, ReactNode, HTMLAttributes } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	import { EuiAccordionProps } from '@elastic/eui/src/components/accordion';
	import { IconType, IconSize, EuiIconProps } from '@elastic/eui/src/components/icon';
	import { EuiTitleProps } from '@elastic/eui/src/components/title';
	export const BACKGROUNDS: readonly ["none", "light", "dark"]; type Background = (typeof BACKGROUNDS)[number];
	export interface EuiCollapsibleNavGroupInterface extends CommonProps {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children?: ReactNode;
	    /**
	     * Sits left of the `title` and only when `title` is present
	     */
	    iconType?: IconType;
	    /**
	     * Change the size of the icon in the `title`
	     */
	    iconSize?: IconSize;
	    /**
	     * Further extend the props applied to EuiIcon
	     */
	    iconProps?: Omit<EuiIconProps, 'type' | 'size'>;
	    /**
	     * Optionally provide an id, otherwise one will be created
	     */
	    id?: string;
	    /**
	     * Adds a background color to the entire group,
	     * applying the correct text color to the `title` only
	     */
	    background?: Background;
	    /**
	     * Determines the title's heading element
	     */
	    titleElement?: 'h2' | 'h3' | 'h4' | 'h5' | 'h6' | 'span';
	    /**
	     * Title sizing equivalent to EuiTitle, but only `s` and smaller
	     */
	    titleSize?: Exclude<EuiTitleProps['size'], 'l' | 'm'>;
	} type GroupAsAccordion = EuiCollapsibleNavGroupInterface & Omit<EuiAccordionProps, 'id' | 'title'> & {
	    /**
	     * If `true`, wraps children in the body of an accordion,
	     * requiring the prop `title` to be used as the button.
	     * When `false`, simply renders a div without any accordion functionality.
	     */
	    isCollapsible: true;
	    /**
	     * The title gets wrapped in the appropriate heading level
	     * with the option to add an iconType
	     */
	    title: ReactNode;
	}; type GroupAsDiv = EuiCollapsibleNavGroupInterface & {
	    /**
	     * If `true`, wraps children in the body of an accordion,
	     * requiring the prop `title` to be used as the button.
	     * When `false`, simply renders a div without any accordion functionality.
	     */
	    isCollapsible?: false;
	    /**
	     * The title gets wrapped in the appropriate heading level
	     * with the option to add an iconType
	     */
	    title?: ReactNode;
	} & Omit<HTMLAttributes<HTMLDivElement>, 'title'>;
	export type EuiCollapsibleNavGroupProps = ExclusiveUnion<GroupAsAccordion, GroupAsDiv>;
	export const EuiCollapsibleNavGroup: FunctionComponent<EuiCollapsibleNavGroupProps>;
	export {};

}
declare module '@elastic/eui/src/components/collapsible_nav/collapsible_nav_group' {
	export type { EuiCollapsibleNavGroupProps } from '@elastic/eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group';
	export { EuiCollapsibleNavGroup } from '@elastic/eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group';

}
declare module '@elastic/eui/src/components/flyout/flyout.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const FLYOUT_BREAKPOINT: "m";
	export const euiFlyoutSlideInRight: import("@emotion/serialize").Keyframes;
	export const euiFlyoutSlideInLeft: import("@emotion/serialize").Keyframes;
	export const euiFlyoutStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFlyout: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    noMaxWidth: import("@emotion/utils").SerializedStyles;
	    right: import("@emotion/utils").SerializedStyles;
	    left: import("@emotion/utils").SerializedStyles;
	    overlay: import("@emotion/utils").SerializedStyles;
	    push: {
	        push: import("@emotion/utils").SerializedStyles;
	        right: import("@emotion/utils").SerializedStyles;
	        left: import("@emotion/utils").SerializedStyles;
	        noAnimation: import("@emotion/utils").SerializedStyles;
	    };
	    paddingSizes: {
	        none: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	        l: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/flyout/_flyout_close_button.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFlyoutCloseButtonStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFlyout__closeButton: import("@emotion/utils").SerializedStyles;
	    inside: import("@emotion/utils").SerializedStyles;
	    outside: import("@emotion/utils").SerializedStyles;
	    outsideSide: {
	        right: import("@emotion/utils").SerializedStyles;
	        left: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/flyout/_flyout_close_button' {
	import { FunctionComponent } from 'react';
	import type { EuiFlyoutProps } from '@elastic/eui/src/components/flyout/flyout'; type EuiFlyoutCloseButtonProps = EuiFlyoutProps['closeButtonProps'] & Required<Pick<EuiFlyoutProps, 'closeButtonPosition' | 'onClose' | 'side'>>;
	export const EuiFlyoutCloseButton: FunctionComponent<EuiFlyoutCloseButtonProps>;
	export {};

}
declare module '@elastic/eui/src/components/flyout/flyout' {
	import React, { ComponentPropsWithRef, CSSProperties, ElementType } from 'react';
	import { EuiBreakpointSize } from '@elastic/eui/src/services';
	import { CommonProps, PropsOfElement } from '@elastic/eui/src/components/common';
	import { EuiFocusTrapProps } from '@elastic/eui/src/components/focus_trap';
	import { EuiOverlayMaskProps } from '@elastic/eui/src/components/overlay_mask';
	import type { EuiButtonIconPropsForButton } from '@elastic/eui/src/components/button';
	export const TYPES: readonly ["push", "overlay"]; type _EuiFlyoutType = (typeof TYPES)[number];
	export const SIDES: readonly ["left", "right"];
	export type _EuiFlyoutSide = (typeof SIDES)[number];
	export const SIZES: readonly ["s", "m", "l"];
	export type EuiFlyoutSize = (typeof SIZES)[number];
	export const PADDING_SIZES: readonly ["none", "s", "m", "l"];
	export type _EuiFlyoutPaddingSize = (typeof PADDING_SIZES)[number];
	interface _EuiFlyoutProps {
	    onClose: (event: MouseEvent | TouchEvent | KeyboardEvent) => void;
	    /**
	     * Defines the width of the panel.
	     * Pass a predefined size of `s | m | l`, or pass any number/string compatible with the CSS `width` attribute
	     * @default m
	     */
	    size?: EuiFlyoutSize | CSSProperties['width'];
	    /**
	     * Sets the max-width of the panel,
	     * set to `true` to use the default size,
	     * set to `false` to not restrict the width,
	     * set to a number for a custom width in px,
	     * set to a string for a custom width in custom measurement.
	     * @default false
	     */
	    maxWidth?: boolean | number | string;
	    /**
	     * Customize the padding around the content of the flyout header, body and footer
	     * @default l
	     */
	    paddingSize?: _EuiFlyoutPaddingSize;
	    /**
	     * Adds an EuiOverlayMask and wraps in an EuiPortal
	     * @default true
	     */
	    ownFocus?: boolean;
	    /**
	     * Hides the default close button. You must provide another close button somewhere within the flyout.
	     * @default false
	     */
	    hideCloseButton?: boolean;
	    /**
	     * Extends EuiButtonIconProps onto the close button
	     */
	    closeButtonProps?: Partial<EuiButtonIconPropsForButton>;
	    /**
	     * Position of close button.
	     * `inside`: Floating to just inside the flyout, always top right;
	     * `outside`: Floating just outside the flyout near the top (side dependent on `side`). Helpful when the close button may cover other interactable content.
	     * @default inside
	     */
	    closeButtonPosition?: 'inside' | 'outside';
	    /**
	     * Adjustments to the EuiOverlayMask that is added when `ownFocus = true`
	     */
	    maskProps?: EuiOverlayMaskProps;
	    /**
	     * How to display the the flyout in relation to the body content;
	     * `push` keeps it visible, pushing the `<body>` content via padding
	     * @default overlay
	     */
	    type?: _EuiFlyoutType;
	    /**
	     * Forces this interaction on the mask overlay or body content.
	     * Defaults depend on `ownFocus` and `type` values
	     */
	    outsideClickCloses?: boolean;
	    /**
	     * Which side of the window to attach to.
	     * The `left` option should only be used for navigation.
	     * @default right
	     */
	    side?: _EuiFlyoutSide;
	    /**
	     * Named breakpoint (`xs` through `xl`) for customizing the minimum window width to enable the `push` type
	     * @default l
	     */
	    pushMinBreakpoint?: EuiBreakpointSize;
	    /**
	     * Enables a slide in animation on push flyouts
	     * @default false
	     */
	    pushAnimation?: boolean;
	    style?: CSSProperties;
	    /**
	     * Object of props passed to EuiFocusTrap.
	     * `shards` specifies an array of elements that will be considered part of the flyout, preventing the flyout from being closed when clicked.
	     * `closeOnMouseup` will delay the close callback, allowing time for external toggle buttons to handle close behavior.
	     */
	    focusTrapProps?: Pick<EuiFocusTrapProps, 'closeOnMouseup' | 'shards'>;
	    /**
	     * By default, EuiFlyout will consider any fixed `EuiHeader`s that sit alongside or above the EuiFlyout
	     * as part of the flyout's focus trap. This prevents focus fighting with interactive elements
	     * within fixed headers.
	     *
	     * Set this to `false` if you need to disable this behavior for a specific reason.
	     */
	    includeFixedHeadersInFocusTrap?: boolean;
	} const defaultElement = "div"; type Props<T extends ElementType> = CommonProps & {
	    /**
	     * Sets the HTML element for `EuiFlyout`
	     */
	    as?: T;
	} & _EuiFlyoutProps & Omit<PropsOfElement<T>, keyof _EuiFlyoutProps>;
	export type EuiFlyoutProps<T extends ElementType = typeof defaultElement> = Props<T> & Omit<ComponentPropsWithRef<T>, keyof Props<T>>;
	export const EuiFlyout: <T extends React.ElementType = "div">(props: EuiFlyoutProps<T>) => JSX.Element;
	export {};

}
declare module '@elastic/eui/src/components/flyout/flyout_body.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFlyoutBodyStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFlyoutBody: import("@emotion/utils").SerializedStyles;
	    overflow: {
	        euiFlyoutBody__overflow: import("@emotion/utils").SerializedStyles;
	        noBanner: import("@emotion/utils").SerializedStyles;
	        hasBanner: import("@emotion/utils").SerializedStyles;
	    };
	    euiFlyoutBody__banner: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/flyout/flyout_body' {
	import { FunctionComponent, HTMLAttributes, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiFlyoutBodyProps = FunctionComponent<HTMLAttributes<HTMLDivElement> & CommonProps & {
	    /**
	     * Use to display a banner at the top of the body. It is suggested to use `EuiCallOut` for it.
	     */
	    banner?: ReactNode;
	    /**
	     * [Scrollable regions (or their children) should be focusable](https://dequeuniversity.com/rules/axe/4.0/scrollable-region-focusable)
	     * to allow keyboard users to scroll the region via arrow keys.
	     *
	     * By default, EuiFlyoutBody's scroll overflow wrapper sets a `tabIndex` of `0`.
	     * If you know your flyout body content already contains focusable children
	     * that satisfy keyboard accessibility requirements, you can use this prop
	     * to override this default.
	     */
	    scrollableTabIndex?: number;
	}>;
	export const EuiFlyoutBody: EuiFlyoutBodyProps;

}
declare module '@elastic/eui/src/components/flyout/flyout_footer.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFlyoutFooterStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFlyoutFooter: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/flyout/flyout_footer' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiFlyoutFooterProps = FunctionComponent<HTMLAttributes<HTMLDivElement> & CommonProps>;
	export const EuiFlyoutFooter: EuiFlyoutFooterProps;

}
declare module '@elastic/eui/src/components/flyout/flyout_header.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFlyoutHeaderStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFlyoutHeader: import("@emotion/utils").SerializedStyles;
	    hasBorder: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/flyout/flyout_header' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiFlyoutHeaderProps = FunctionComponent<HTMLAttributes<HTMLDivElement> & CommonProps & {
	    hasBorder?: boolean;
	}>;
	export const EuiFlyoutHeader: EuiFlyoutHeaderProps;

}
declare module '@elastic/eui/src/components/resizable_container/types' {
	import { KeyboardEvent, MouseEvent, TouchEvent } from 'react';
	export type PanelModeType = 'collapsible' | 'main' | 'custom';
	export type PanelPosition = 'first' | 'middle' | 'last';
	export type PanelDirection = 'left' | 'right';
	export type KeyMoveDirection = 'forward' | 'backward';
	export type ResizeTrigger = 'pointer' | 'key';
	export interface EuiResizablePanelController {
	    id: string;
	    size: number;
	    getSizePx: () => number;
	    minSize: string[];
	    mode?: PanelModeType;
	    isCollapsed: boolean;
	    prevSize: number;
	    position: PanelPosition;
	}
	export interface EuiResizableButtonController {
	    id: string;
	    ref: HTMLElement;
	    isDisabled: boolean;
	    isFocused: boolean;
	}
	export interface EuiResizableContainerRegistry {
	    panels: {
	        [key: string]: EuiResizablePanelController;
	    };
	    resizers: {
	        [key: string]: EuiResizableButtonController;
	    };
	}
	export type EuiResizableButtonMouseEvent = MouseEvent<HTMLButtonElement> | TouchEvent<HTMLButtonElement>;
	export type EuiResizableButtonKeyEvent = KeyboardEvent<HTMLButtonElement>;
	export interface EuiResizableContainerState {
	    isDragging: boolean;
	    currentResizerPos: number;
	    prevPanelId: string | null;
	    nextPanelId: string | null;
	    containerSize: number;
	    isHorizontal?: boolean;
	    panels: EuiResizableContainerRegistry['panels'];
	    resizers: EuiResizableContainerRegistry['resizers'];
	}
	export interface ActionToggleOptions {
	    direction: PanelDirection;
	}
	interface ActionReset {
	    type: 'EUI_RESIZABLE_RESET';
	}
	interface ActionInit {
	    type: 'EUI_RESIZABLE_CONTAINER_INIT';
	    payload: {
	        isHorizontal: boolean;
	    };
	}
	export interface ActionDragStart {
	    type: 'EUI_RESIZABLE_DRAG_START';
	    payload: {
	        prevPanelId: string;
	        nextPanelId: string;
	        position: number;
	    };
	}
	export interface ActionDragMove {
	    type: 'EUI_RESIZABLE_DRAG_MOVE';
	    payload: {
	        prevPanelId: string;
	        nextPanelId: string;
	        position: number;
	    };
	}
	export interface ActionKeyMove {
	    type: 'EUI_RESIZABLE_KEY_MOVE';
	    payload: {
	        prevPanelId: string;
	        nextPanelId: string;
	        direction: KeyMoveDirection;
	    };
	}
	export interface ActionResize {
	    type: 'EUI_RESIZABLE_RESIZE';
	    payload: {};
	}
	export interface ActionToggle {
	    type: 'EUI_RESIZABLE_TOGGLE';
	    payload: {
	        panelId: string;
	        options: ActionToggleOptions;
	    };
	}
	interface ActionRegisterPanel {
	    type: 'EUI_RESIZABLE_PANEL_REGISTER';
	    payload: {
	        panel: EuiResizablePanelController;
	    };
	}
	interface ActionDeregisterPanel {
	    type: 'EUI_RESIZABLE_PANEL_DEREGISTER';
	    payload: {
	        panelId: EuiResizablePanelController['id'];
	    };
	}
	interface ActionRegisterResizer {
	    type: 'EUI_RESIZABLE_BUTTON_REGISTER';
	    payload: {
	        resizer: EuiResizableButtonController;
	    };
	}
	interface ActionDeregisterResizer {
	    type: 'EUI_RESIZABLE_BUTTON_DEREGISTER';
	    payload: {
	        resizerId: EuiResizableButtonController['id'];
	    };
	}
	export interface ActionFocus {
	    type: 'EUI_RESIZABLE_BUTTON_FOCUS';
	    payload: {
	        resizerId: EuiResizableButtonController['id'];
	    };
	}
	interface ActionBlur {
	    type: 'EUI_RESIZABLE_BUTTON_BLUR';
	}
	interface ActionOnChange {
	    type: 'EUI_RESIZABLE_ONCHANGE';
	}
	export type EuiResizableContainerAction = ActionReset | ActionInit | ActionRegisterPanel | ActionDeregisterPanel | ActionRegisterResizer | ActionDeregisterResizer | ActionDragStart | ActionDragMove | ActionKeyMove | ActionResize | ActionToggle | ActionFocus | ActionBlur | ActionOnChange;
	export interface EuiResizableContainerActions {
	    reset: () => void;
	    initContainer: (isHorizontal: boolean) => void;
	    registerPanel: (panel: EuiResizablePanelController) => void;
	    deregisterPanel: (panelId: EuiResizablePanelController['id']) => void;
	    registerResizer: (resizer: EuiResizableButtonController) => void;
	    deregisterResizer: (resizerId: EuiResizableButtonController['id']) => void;
	    dragStart: ({ prevPanelId, nextPanelId, position, }: ActionDragStart['payload']) => void;
	    dragMove: ({ prevPanelId, nextPanelId, position, }: ActionDragMove['payload']) => void;
	    keyMove: ({ prevPanelId, nextPanelId, direction, }: ActionKeyMove['payload']) => void;
	    resizerFocus: (resizerId: ActionFocus['payload']['resizerId']) => void;
	    resizerBlur: () => void;
	    togglePanel: (panelId: ActionToggle['payload']['panelId'], options: ActionToggle['payload']['options']) => void;
	}
	export {};

}
declare module '@elastic/eui/src/components/resizable_container/context' {
	import React from 'react';
	import { EuiResizableContainerRegistry } from '@elastic/eui/src/components/resizable_container/types';
	interface ContainerContextProps {
	    registry?: EuiResizableContainerRegistry;
	}
	interface ContextProviderProps extends Required<ContainerContextProps> {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: any;
	}
	export function EuiResizableContainerContextProvider({ children, registry, }: ContextProviderProps): React.JSX.Element;
	export const useEuiResizableContainerContext: () => ContainerContextProps;
	export {};

}
declare module '@elastic/eui/src/components/resizable_container/resizable_button.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiResizableButtonStyles: (euiThemeContext: UseEuiTheme) => {
	    euiResizableButton: import("@emotion/utils").SerializedStyles;
	    horizontal: import("@emotion/utils").SerializedStyles;
	    vertical: import("@emotion/utils").SerializedStyles;
	    accountForScrollbars: {
	        horizontal: {
	            both: import("@emotion/utils").SerializedStyles;
	            before: import("@emotion/utils").SerializedStyles;
	            after: import("@emotion/utils").SerializedStyles;
	            none: import("@emotion/utils").SerializedStyles;
	        };
	        vertical: {
	            both: import("@emotion/utils").SerializedStyles;
	            before: import("@emotion/utils").SerializedStyles;
	            after: import("@emotion/utils").SerializedStyles;
	            none: import("@emotion/utils").SerializedStyles;
	        };
	    };
	    border: import("@emotion/utils").SerializedStyles;
	    borderDirection: {
	        horizontal: import("@emotion/utils").SerializedStyles;
	        vertical: import("@emotion/utils").SerializedStyles;
	    };
	    handle: import("@emotion/utils").SerializedStyles;
	    handleDirection: {
	        horizontal: import("@emotion/utils").SerializedStyles;
	        vertical: import("@emotion/utils").SerializedStyles;
	    };
	    alignIndicator: {
	        center: import("@emotion/utils").SerializedStyles;
	        start: import("@emotion/utils").SerializedStyles;
	        end: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/resizable_container/resizable_button' {
	import React, { FunctionComponent, ButtonHTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiResizableButtonController, EuiResizableButtonMouseEvent, EuiResizableButtonKeyEvent } from '@elastic/eui/src/components/resizable_container/types';
	export type EuiResizableButtonProps = ButtonHTMLAttributes<HTMLButtonElement> & CommonProps & {
	    /**
	     * Defaults to displaying a resizer for vertical (y-axis) resizing.
	     * Set to `true` to display a resizer for horizontal (x-axis) resizing.
	     */
	    isHorizontal?: boolean;
	    /**
	     * By default, EuiResizableButton will show a grab handle to indicate resizability.
	     * This indicator can be optionally hidden to show a plain border instead.
	     */
	    indicator?: 'handle' | 'border';
	    /**
	     * Allows customizing the alignment of grab `handle` indicators (does nothing for
	     * border indicators). Defaults to `center`, but consider using `start` for extremely
	     * tall content that scrolls off-screen
	     */
	    alignIndicator?: 'center' | 'start' | 'end';
	    /**
	     * By default, EuiResizableButton will overlap into the panels before/after it.
	     * This can occasionally occlude interactive elements like scrollbars. To prevent
	     * this overlap, use this prop to remove the overlap for the specified side.
	     */
	    accountForScrollbars?: 'before' | 'after' | 'both';
	    /**
	     * When disabled, the resizer button will be completely hidden
	     */
	    disabled?: boolean;
	};
	/**
	 * A generic button for indicating/facilitating resizable content,
	 * usable outside of the EuiResizableContainer context
	 */
	export const EuiResizableButton: React.ForwardRefExoticComponent<React.ButtonHTMLAttributes<HTMLButtonElement> & CommonProps & {
	    /**
	     * Defaults to displaying a resizer for vertical (y-axis) resizing.
	     * Set to `true` to display a resizer for horizontal (x-axis) resizing.
	     */
	    isHorizontal?: boolean | undefined;
	    /**
	     * By default, EuiResizableButton will show a grab handle to indicate resizability.
	     * This indicator can be optionally hidden to show a plain border instead.
	     */
	    indicator?: "border" | "handle" | undefined;
	    /**
	     * Allows customizing the alignment of grab `handle` indicators (does nothing for
	     * border indicators). Defaults to `center`, but consider using `start` for extremely
	     * tall content that scrolls off-screen
	     */
	    alignIndicator?: "center" | "end" | "start" | undefined;
	    /**
	     * By default, EuiResizableButton will overlap into the panels before/after it.
	     * This can occasionally occlude interactive elements like scrollbars. To prevent
	     * this overlap, use this prop to remove the overlap for the specified side.
	     */
	    accountForScrollbars?: "both" | "before" | "after" | undefined;
	    /**
	     * When disabled, the resizer button will be completely hidden
	     */
	    disabled?: boolean | undefined;
	} & React.RefAttributes<HTMLButtonElement>>;
	/**
	 * Resizer button specific to controlled EuiResizableContainer usage
	 */
	export type EuiResizableButtonControls = Omit<EuiResizableButtonProps, 'onFocus'> & {
	    registration: {
	        register: (resizer: EuiResizableButtonController) => void;
	        deregister: (resizerId: EuiResizableButtonController['id']) => void;
	    };
	    onKeyDown: (e: EuiResizableButtonKeyEvent) => void;
	    onKeyUp: (e: EuiResizableButtonKeyEvent) => void;
	    onMouseDown: (e: EuiResizableButtonMouseEvent) => void;
	    onTouchStart: (e: EuiResizableButtonMouseEvent) => void;
	    onBlur: () => void;
	    onFocus: (id: string) => void;
	};
	export const EuiResizableButtonControlled: FunctionComponent<Partial<EuiResizableButtonControls>>;
	export const euiResizableButtonWithControls: (controls: EuiResizableButtonControls) => (props: CommonProps) => React.JSX.Element;

}
declare module '@elastic/eui/src/components/resizable_container/resizable_collapse_button.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiResizableCollapseButtonStyles: (euiThemeContext: UseEuiTheme) => {
	    euiResizableCollapseButton: import("@emotion/utils").SerializedStyles;
	    collapsible: {
	        collapsible: import("@emotion/utils").SerializedStyles;
	        horizontal: {
	            after: import("@emotion/utils").SerializedStyles;
	            before: import("@emotion/utils").SerializedStyles;
	            middle: import("@emotion/utils").SerializedStyles;
	            top: import("@emotion/utils").SerializedStyles;
	            bottom: import("@emotion/utils").SerializedStyles;
	            readonly left: import("@emotion/utils").SerializedStyles;
	            readonly right: import("@emotion/utils").SerializedStyles;
	        };
	        vertical: {
	            after: import("@emotion/utils").SerializedStyles;
	            before: import("@emotion/utils").SerializedStyles;
	            middle: import("@emotion/utils").SerializedStyles;
	            left: import("@emotion/utils").SerializedStyles;
	            right: import("@emotion/utils").SerializedStyles;
	            readonly top: import("@emotion/utils").SerializedStyles;
	            readonly bottom: import("@emotion/utils").SerializedStyles;
	        };
	    };
	    collapsed: {
	        collapsed: import("@emotion/utils").SerializedStyles;
	        horizontal: import("@emotion/utils").SerializedStyles;
	        vertical: import("@emotion/utils").SerializedStyles;
	        horizontalPositions: {
	            top: import("@emotion/utils").SerializedStyles;
	            bottom: import("@emotion/utils").SerializedStyles;
	            middle: import("@emotion/utils").SerializedStyles;
	            left: import("@emotion/utils").SerializedStyles;
	            right: import("@emotion/utils").SerializedStyles;
	        };
	        verticalPositions: {
	            left: import("@emotion/utils").SerializedStyles;
	            right: import("@emotion/utils").SerializedStyles;
	            middle: import("@emotion/utils").SerializedStyles;
	            top: import("@emotion/utils").SerializedStyles;
	            bottom: import("@emotion/utils").SerializedStyles;
	        };
	    };
	};

}
declare module '@elastic/eui/src/components/resizable_container/resizable_collapse_button' {
	import { FunctionComponent } from 'react';
	import { EuiButtonIconPropsForButton } from '@elastic/eui/src/components/button';
	import { ToggleOptions } from '@elastic/eui/src/components/resizable_container/resizable_panel';
	import { EuiResizableContainerProps } from '@elastic/eui/src/components/resizable_container/resizable_container';
	export type EuiResizableCollapseButtonProps = Omit<EuiButtonIconPropsForButton, 'iconType'> & {
	    /**
	     * Position of the toggle button.
	     * Enums based on the `direction` of the EuiResizableContainer
	     */
	    internalPosition?: ToggleOptions['position'];
	    /**
	     * Position of the toggle button.
	     * Enums based on the `direction` of the EuiResizableContainer
	     */
	    externalPosition?: 'before' | 'after';
	    /**
	     * Same direction derived from EuiResizableContainer
	     */
	    direction?: EuiResizableContainerProps['direction'];
	    isVisible?: boolean;
	    isCollapsed?: boolean;
	};
	export const EuiResizableCollapseButton: FunctionComponent<EuiResizableCollapseButtonProps>;

}
declare module '@elastic/eui/src/components/resizable_container/resizable_panel.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiResizablePanelStyles: {
	    euiResizablePanel: import("@emotion/utils").SerializedStyles;
	    collapsed: import("@emotion/utils").SerializedStyles;
	};
	export const euiResizablePanelContentStyles: (euiThemeContext: UseEuiTheme) => {
	    euiResizablePanel__content: import("@emotion/utils").SerializedStyles;
	    scrollable: import("@emotion/utils").SerializedStyles;
	    collapsedChildren: import("@emotion/utils").SerializedStyles;
	    horizontal: {
	        collapsed: import("@emotion/utils").SerializedStyles;
	        hasCollapsibleButton: import("@emotion/utils").SerializedStyles;
	    };
	    vertical: {
	        collapsed: import("@emotion/utils").SerializedStyles;
	        hasCollapsibleButton: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/resizable_container/resizable_panel' {
	import React, { CSSProperties, ReactNode, FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { PanelPaddingSize, _EuiPanelProps } from '@elastic/eui/src/components/panel/panel';
	import { EuiResizablePanelController, ActionToggleOptions, PanelModeType } from '@elastic/eui/src/components/resizable_container/types';
	export interface ToggleOptions {
	    'data-test-subj'?: string;
	    className?: string;
	    /**
	     * Position of the toggle button.
	     * Enums based on the `direction` of the EuiResizableContainer
	     */
	    position?: 'top' | 'middle' | 'bottom' | 'left' | 'right';
	}
	export type ModeOptions = PanelModeType | [PanelModeType, Partial<ToggleOptions>];
	export type ToggleCollapseCallback = (panelId: EuiResizablePanelController['id'], options: ActionToggleOptions) => void;
	export const getModeType: (mode?: ModeOptions | undefined) => PanelModeType | undefined;
	export const getToggleOptions: (mode?: ModeOptions | undefined) => {
	    'data-test-subj': string | undefined;
	    className: string | null;
	    position: string;
	};
	export interface EuiResizablePanelControls {
	    isHorizontal: boolean;
	    registration: {
	        register: (panel: EuiResizablePanelController) => void;
	        deregister: (panelId: EuiResizablePanelController['id']) => void;
	    };
	    /**
	     * #ToggleCollapseCallback
	     */
	    onToggleCollapsed?: ToggleCollapseCallback;
	    onToggleCollapsedInternal: ToggleCollapseCallback;
	}
	export interface EuiResizablePanelProps extends _EuiPanelProps, CommonProps, Partial<EuiResizablePanelControls> {
	    /**
	     * Specify a desired minimum panel size in pixels or percents,
	     * for example "300px" or "30%"
	     * The actual minimum size will be calculated,
	     * using the larger of this prop and the panelProps.paddingSize
	     */
	    minSize?: string;
	    /**
	     * Specify id of panel if you want to track panel size in "onPanelWidthChange" callback
	     */
	    id?: string;
	    /**
	     * Initial size of the panel in percents
	     * Specify this prop if you don't need to handle the panel size from outside
	     */
	    initialSize?: number;
	    /**
	     * Size of the panel in percents.
	     * Specify this prop if you want to control the size from outside, the panel will ignore the "initialSize"
	     */
	    size?: number;
	    /**
	     * Add Eui scroll and overflow for the panel
	     */
	    scrollable?: boolean;
	    mode?: ModeOptions;
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: ReactNode;
	    /**
	     * Custom CSS properties applied to the wrapping `.euiResizablePanel` div
	     */
	    style?: CSSProperties;
	    /**
	     * tabIndex={0} provides full keyboard access when content overflows `<EuiResizablePanel />`
	     */
	    tabIndex?: number;
	    /**
	     * Props to add to the wrapping `.euiResizablePanel` div
	     */
	    wrapperProps?: CommonProps & HTMLAttributes<HTMLDivElement>;
	    /**
	     * Padding to add directly to the wrapping `.euiResizablePanel` div
	     * Gives space around the actual panel.
	     */
	    wrapperPadding?: PanelPaddingSize;
	}
	export const EuiResizablePanel: FunctionComponent<EuiResizablePanelProps>;
	export function euiResizablePanelWithControls(controls: EuiResizablePanelControls): (props: EuiResizablePanelProps) => React.JSX.Element;

}
declare module '@elastic/eui/src/components/resizable_container/helpers' {
	import { MouseEvent as ReactMouseEvent, TouchEvent as ReactTouchEvent } from 'react';
	import { EuiResizableContainerRegistry, EuiResizableContainerState, EuiResizableContainerActions } from '@elastic/eui/src/components/resizable_container/types';
	interface Params {
	    initialState: EuiResizableContainerState;
	    containerRef: React.RefObject<HTMLDivElement>;
	    onPanelWidthChange?: ({}: {
	        [key: string]: number;
	    }) => any;
	}
	export const isTouchEvent: (event: MouseEvent | ReactMouseEvent | TouchEvent | ReactTouchEvent) => event is TouchEvent | ReactTouchEvent<Element>;
	export const pxToPercent: (proportion: number, whole: number) => number;
	export const sizesOnly: (panelObject: EuiResizableContainerRegistry['panels']) => {
	    [key: string]: number;
	};
	export const getPanelMinSize: (panelMinSize: string[], containerSize: number) => number;
	export const getPosition: (event: ReactMouseEvent | MouseEvent | ReactTouchEvent | TouchEvent, isHorizontal: boolean) => number;
	export const useContainerCallbacks: ({ initialState, containerRef, onPanelWidthChange, }: Params) => [EuiResizableContainerActions, EuiResizableContainerState];
	export {};

}
declare module '@elastic/eui/src/components/resizable_container/resizable_container.styles' {
	export const euiResizableContainerStyles: {
	    euiResizableContainer: import("@emotion/utils").SerializedStyles;
	    horizontal: import("@emotion/utils").SerializedStyles;
	    vertical: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/resizable_container/resizable_container' {
	import { ReactNode, CSSProperties, FunctionComponent, HTMLAttributes, ComponentType } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiResizableButtonProps } from '@elastic/eui/src/components/resizable_container/resizable_button';
	import { EuiResizablePanelProps, ToggleCollapseCallback } from '@elastic/eui/src/components/resizable_container/resizable_panel';
	import { EuiResizableContainerActions, ResizeTrigger } from '@elastic/eui/src/components/resizable_container/types';
	export interface EuiResizableContainerProps extends Omit<HTMLAttributes<HTMLDivElement>, 'children'>, CommonProps {
	    /**
	     * Specify the container direction
	     */
	    direction?: 'vertical' | 'horizontal';
	    /**
	     * Pure function which accepts Panel and Resizer components in arguments
	     * and returns a component tree
	     */
	    children: (Panel: ComponentType<EuiResizablePanelProps>, Resizer: ComponentType<EuiResizableButtonProps>, actions: Partial<EuiResizableContainerActions>) => ReactNode;
	    /**
	     * Pure function which accepts an object where keys are IDs of panels, which sizes were changed,
	     * and values are actual sizes in percents
	     */
	    onPanelWidthChange?: ({}: {
	        [key: string]: number;
	    }) => void;
	    onToggleCollapsed?: ToggleCollapseCallback;
	    /**
	     * Called when resizing starts
	     */
	    onResizeStart?: (trigger: ResizeTrigger) => void;
	    /**
	     * Called when resizing ends
	     */
	    onResizeEnd?: () => void;
	    style?: CSSProperties;
	}
	export const EuiResizableContainer: FunctionComponent<EuiResizableContainerProps>;

}
declare module '@elastic/eui/src/components/resizable_container' {
	export type { EuiResizableContainerProps } from '@elastic/eui/src/components/resizable_container/resizable_container';
	export { EuiResizableContainer } from '@elastic/eui/src/components/resizable_container/resizable_container';
	export type { EuiResizableButtonProps } from '@elastic/eui/src/components/resizable_container/resizable_button';
	export { EuiResizableButton } from '@elastic/eui/src/components/resizable_container/resizable_button';

}
declare module '@elastic/eui/src/components/flyout/flyout_resizable.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFlyoutResizableButtonStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiFlyoutResizableButton: import("@emotion/utils").SerializedStyles;
	    overlay: {
	        left: import("@emotion/utils").SerializedStyles;
	        right: import("@emotion/utils").SerializedStyles;
	    };
	    push: {
	        left: import("@emotion/utils").SerializedStyles;
	        right: import("@emotion/utils").SerializedStyles;
	    };
	    noOverlay: {
	        noOverlay: import("@emotion/utils").SerializedStyles;
	        left: import("@emotion/utils").SerializedStyles;
	        right: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/flyout/flyout_resizable' {
	import React from 'react';
	import { EuiFlyoutProps } from '@elastic/eui/src/components/flyout/flyout';
	export type EuiFlyoutResizableProps = {
	    maxWidth?: number;
	    minWidth?: number;
	    /**
	     * Optional callback that fires on user resize with the new flyout width
	     */
	    onResize?: (width: number) => void;
	} & Omit<EuiFlyoutProps, 'maxWidth' | 'onResize'>;
	export const EuiFlyoutResizable: React.ForwardRefExoticComponent<Omit<EuiFlyoutResizableProps, "ref"> & React.RefAttributes<unknown>>;

}
declare module '@elastic/eui/src/components/flyout' {
	export type { EuiFlyoutProps, EuiFlyoutSize } from '@elastic/eui/src/components/flyout/flyout';
	export { EuiFlyout } from '@elastic/eui/src/components/flyout/flyout';
	export type { EuiFlyoutBodyProps } from '@elastic/eui/src/components/flyout/flyout_body';
	export { EuiFlyoutBody } from '@elastic/eui/src/components/flyout/flyout_body';
	export type { EuiFlyoutFooterProps } from '@elastic/eui/src/components/flyout/flyout_footer';
	export { EuiFlyoutFooter } from '@elastic/eui/src/components/flyout/flyout_footer';
	export type { EuiFlyoutHeaderProps } from '@elastic/eui/src/components/flyout/flyout_header';
	export { EuiFlyoutHeader } from '@elastic/eui/src/components/flyout/flyout_header';
	export { euiFlyoutSlideInRight, euiFlyoutSlideInLeft } from '@elastic/eui/src/components/flyout/flyout.styles';
	export type { EuiFlyoutResizableProps } from '@elastic/eui/src/components/flyout/flyout_resizable';
	export { EuiFlyoutResizable } from '@elastic/eui/src/components/flyout/flyout_resizable';

}
declare module '@elastic/eui/src/components/collapsible_nav/collapsible_nav.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCollapsibleNavStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiCollapsibleNav: import("@emotion/utils").SerializedStyles;
	    push: import("@emotion/utils").SerializedStyles;
	    overlay: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/collapsible_nav/collapsible_nav' {
	import { FunctionComponent, ReactElement, ReactNode } from 'react';
	import { EuiFlyoutProps } from '@elastic/eui/src/components/flyout';
	export type EuiCollapsibleNavProps = Omit<EuiFlyoutProps<'nav' | 'div'>, 'type' | 'pushBreakpoint'> & {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children?: ReactNode;
	    /**
	     * Shows the navigation flyout
	     */
	    isOpen?: boolean;
	    /**
	     * Keeps navigation flyout visible and push `<body>` content via padding
	     */
	    isDocked?: boolean;
	    /**
	     * Named breakpoint (`xs` through `xl`) for customizing the minimum window width to enable docking
	     */
	    dockedBreakpoint?: EuiFlyoutProps['pushMinBreakpoint'];
	    /**
	     * Button for controlling visible state of the nav
	     */
	    button?: ReactElement;
	    /**
	     * Keeps the display of toggle button when in docked state
	     */
	    showButtonIfDocked?: boolean;
	};
	export const EuiCollapsibleNav: FunctionComponent<EuiCollapsibleNavProps>;

}
declare module '@elastic/eui/src/components/collapsible_nav' {
	export type { EuiCollapsibleNavGroupProps } from '@elastic/eui/src/components/collapsible_nav/collapsible_nav_group';
	export { EuiCollapsibleNavGroup } from '@elastic/eui/src/components/collapsible_nav/collapsible_nav_group';
	export type { EuiCollapsibleNavProps } from '@elastic/eui/src/components/collapsible_nav/collapsible_nav';
	export { EuiCollapsibleNav } from '@elastic/eui/src/components/collapsible_nav/collapsible_nav';

}
declare module '@elastic/eui/src/components/header/header.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiHeaderVariables: (euiThemeContext: UseEuiTheme) => {
	    height: string;
	    childHeight: string;
	    padding: string;
	};
	export const euiHeaderStyles: (euiThemeContext: UseEuiTheme) => {
	    euiHeader: import("@emotion/utils").SerializedStyles;
	    static: import("@emotion/utils").SerializedStyles;
	    fixed: import("@emotion/utils").SerializedStyles;
	    default: import("@emotion/utils").SerializedStyles;
	    dark: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/context' {
	import { MouseEventHandler } from 'react';
	import { _EuiFlyoutSide } from '@elastic/eui/src/components/flyout/flyout'; type _EuiCollapsibleNavContext = {
	    isCollapsed: boolean;
	    isPush: boolean;
	    isOverlayOpen: boolean;
	    side: _EuiFlyoutSide;
	    closePortals?: MouseEventHandler;
	};
	export const EuiCollapsibleNavContext: import("react").Context<_EuiCollapsibleNavContext>;
	export {};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_button/collapsible_nav_button.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCollapsibleNavButtonWrapperStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCollapsibleNavButtonWrapper: import("@emotion/utils").SerializedStyles;
	    euiCollapsibleNavButton: import("@emotion/utils").SerializedStyles;
	    left: import("@emotion/utils").SerializedStyles;
	    right: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_button/collapsible_nav_button' {
	import React from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiButtonIconPropsForButton } from '@elastic/eui/src/components/button';
	export type EuiCollapsibleNavButtonProps = CommonProps & Partial<EuiButtonIconPropsForButton>;
	export const EuiCollapsibleNavButton: React.ForwardRefExoticComponent<CommonProps & Partial<EuiButtonIconPropsForButton> & React.RefAttributes<HTMLDivElement>>;

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_button' {
	export { EuiCollapsibleNavButton } from '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_button/collapsible_nav_button';

}
declare module '@elastic/eui/src/themes/themes' {
	import { EuiThemeSystem } from '@elastic/eui/src/services';
	export interface EUI_THEME {
	    text: string;
	    value: string;
	    provider?: EuiThemeSystem;
	}
	export const EUI_THEMES: EUI_THEME[];
	export const isDefaultTheme: (name: string) => boolean;

}
declare module '@elastic/eui/src/themes' {
	export type { EUI_THEME } from '@elastic/eui/src/themes/themes';
	export { EUI_THEMES, isDefaultTheme } from '@elastic/eui/src/themes/themes';
	export { AMSTERDAM_NAME_KEY, EuiThemeAmsterdam } from '@elastic/eui/src/themes/amsterdam/theme';
	export * from '@elastic/eui/src/themes/amsterdam';

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_body_footer.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const hideScrollbars = "\n  scrollbar-width: none; /* Firefox */\n\n  &::-webkit-scrollbar {\n    display: none; /* Chrome, Edge, & Safari */\n  }\n";
	export const euiCollapsibleNavBodyStyles: {
	    euiCollapsibleNav__body: import("@emotion/utils").SerializedStyles;
	    isPushCollapsed: import("@emotion/utils").SerializedStyles;
	};
	export const euiCollapsibleNavFooterStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCollapsibleNav__footer: import("@emotion/utils").SerializedStyles;
	    euiFlyoutFooter__overflow: import("@emotion/utils").SerializedStyles;
	    isPushCollapsed: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_beta.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCollapsibleNavBetaStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCollapsibleNavBeta: import("@emotion/utils").SerializedStyles;
	    left: import("@emotion/utils").SerializedStyles;
	    right: import("@emotion/utils").SerializedStyles;
	    isPush: import("@emotion/utils").SerializedStyles;
	    isPushCollapsed: import("@emotion/utils").SerializedStyles;
	    isOverlayFullWidth: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_body_footer' {
	import { EuiFlyoutBodyProps, EuiFlyoutFooterProps } from '@elastic/eui/src/components/flyout';
	/**
	 * These components are incredibly light wrappers around `EuiFlyoutBody`
	 * and `EuiFlyoutFooter` with collapsible nav-specific styling/considerations.
	 *
	 * Note: They are not intended to be used standalone outside of EuiCollapsibleNav
	 */
	export const EuiCollapsibleNavBody: EuiFlyoutBodyProps;
	export const EuiCollapsibleNavFooter: EuiFlyoutFooterProps;

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_item.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	/**
	 * Style variables shared between accordion, link, and sub items
	 */
	export const euiCollapsibleNavItemVariables: (euiThemeContext: UseEuiTheme) => {
	    animation: string;
	    borderRadius: import("csstype").Property.BorderRadius<string | number> | undefined;
	    backgroundHoverColor: string;
	    backgroundSelectedColor: string;
	    color: string;
	    rightIconColor: string;
	    fontSize: import("csstype").Property.FontSize<string | number> | undefined;
	    lineHeight: import("csstype").Property.LineHeight<string | number> | undefined;
	    height: string;
	    padding: string;
	};
	/**
	 * Title styles
	 */
	export const euiCollapsibleNavItemTitleStyles: {
	    euiCollapsibleNavItem__title: import("@emotion/utils").SerializedStyles;
	};
	/**
	 * Sub item groups
	 */
	export const euiCollapsibleNavSubItemsStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiCollapsibleNavItem__items: import("@emotion/utils").SerializedStyles;
	    isTopItem: import("@emotion/utils").SerializedStyles;
	    isSubItem: import("@emotion/utils").SerializedStyles;
	};
	/**
	 * Top-level item only styles
	 */
	export const euiCollapsibleNavTopItemStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiCollapsibleNavTopItem: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsed/collapsed_nav_button.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCollapsedNavButtonStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCollapsedNavButton: import("@emotion/utils").SerializedStyles;
	    isSelected: import("@emotion/utils").SerializedStyles;
	};
	export const euiCollapsedNavItemTooltipStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiCollapsedNavItemTooltip: import("@emotion/utils").SerializedStyles;
	    left: import("@emotion/utils").SerializedStyles;
	    right: import("@emotion/utils").SerializedStyles;
	    hidden: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsed/collapsed_nav_button' {
	import { FunctionComponent } from 'react';
	import { EuiCollapsibleNavItemProps } from '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_item';
	export const EuiCollapsedNavButton: FunctionComponent<Omit<EuiCollapsibleNavItemProps, 'items' | 'isCollapsible' | 'accordionProps'> & {
	    hideToolTip?: boolean;
	}>;

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsed/collapsed_nav_popover.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCollapsedNavPopoverStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCollapsedNavPopover__panel: import("@emotion/utils").SerializedStyles;
	    euiCollapsedNavPopover__title: import("@emotion/utils").SerializedStyles;
	    euiCollapsedNavPopover__items: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsed/collapsed_nav_popover' {
	import { FunctionComponent } from 'react';
	import { type EuiPopoverProps } from '@elastic/eui/src/components/popover';
	import { EuiCollapsibleNavItemProps } from '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_item';
	export const EuiCollapsedNavPopover: FunctionComponent<Omit<EuiCollapsibleNavItemProps, 'isCollapsible' | 'accordionProps' | 'href' | 'linkProps'> & Partial<EuiPopoverProps>>;

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsed/collapsed_nav_item' {
	import { FunctionComponent } from 'react';
	import { EuiCollapsibleNavItemProps } from '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_item';
	/**
	 * The collapsed nav item state only shows on larger/non-mobile screens
	 * and collapses top-level link/accordion items to only rendering icons.
	 *
	 * Accordions turn into popovers, links turn into icon buttons
	 */
	export const EuiCollapsedNavItem: FunctionComponent<EuiCollapsibleNavItemProps>;

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsed' {
	export { EuiCollapsedNavItem } from '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsed/collapsed_nav_item';

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_link.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCollapsibleNavLinkStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCollapsibleNavLink: import("@emotion/utils").SerializedStyles;
	    isSelected: import("@emotion/utils").SerializedStyles;
	    isTopItem: {
	        isTopItem: import("@emotion/utils").SerializedStyles;
	        isNotAccordion: import("@emotion/utils").SerializedStyles;
	        isInteractive: import("@emotion/utils").SerializedStyles;
	    };
	    isSubItem: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_link' {
	import { FunctionComponent, ReactNode } from 'react';
	import { EuiLinkProps } from '@elastic/eui/src/components/link';
	import type { _SharedEuiCollapsibleNavItemProps, _EuiCollapsibleNavItemDisplayProps, EuiCollapsibleNavItemProps } from '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_item'; type EuiCollapsibleNavLinkProps = Omit<EuiLinkProps, 'children'> & _SharedEuiCollapsibleNavItemProps & _EuiCollapsibleNavItemDisplayProps & Pick<EuiCollapsibleNavItemProps, 'href' | 'linkProps'> & {
	    children: ReactNode;
	    isInteractive?: boolean;
	    isNotAccordion?: boolean;
	};
	/**
	 * Internal nav link component.
	 *
	 * Can be rendered as a standalone nav item, or as part of an accordion header.
	 * Can also be rendered as top-level item (has a background hover) or as a
	 * sub-item (renders closer to plain text).
	 *
	 * In terms of DOM output, follows the same logic as EuiLink (renders either
	 * an `a` tag or a `button` if no valid link exists), and can also additionally
	 * rendered a plain `span` if the item is not interactive.
	 */
	export const EuiCollapsibleNavLink: FunctionComponent<EuiCollapsibleNavLinkProps>;
	export {};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_accordion.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCollapsibleNavAccordionStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCollapsibleNavAccordion: import("@emotion/utils").SerializedStyles;
	    isSelected: import("@emotion/utils").SerializedStyles;
	    isTopItem: import("@emotion/utils").SerializedStyles;
	    isSubItem: import("@emotion/utils").SerializedStyles;
	    euiCollapsibleNavAccordion__arrow: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_accordion' {
	import { FunctionComponent, ReactNode } from 'react';
	import { type _SharedEuiCollapsibleNavItemProps, type _EuiCollapsibleNavItemDisplayProps, type EuiCollapsibleNavItemProps } from '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_item'; type EuiCollapsibleNavAccordionProps = _SharedEuiCollapsibleNavItemProps & _EuiCollapsibleNavItemDisplayProps & Pick<EuiCollapsibleNavItemProps, 'accordionProps'> & Required<Pick<EuiCollapsibleNavItemProps, 'items'>> & {
	    buttonContent: ReactNode;
	};
	/**
	 * Internal nav accordion component.
	 *
	 * Renders children as either a nav link or any number/nesting of more nav accordions.
	 * Triggering the open/closed state is handled only by the accordion `arrow` for
	 * UX consistency, as accordion/nav titles can be their own links to pages.
	 */
	export const EuiCollapsibleNavAccordion: FunctionComponent<EuiCollapsibleNavAccordionProps>;
	export {};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_group' {
	import { FunctionComponent, ReactNode } from 'react';
	import { type _SharedEuiCollapsibleNavItemProps, type _EuiCollapsibleNavItemDisplayProps, type EuiCollapsibleNavItemProps } from '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_item'; type EuiCollapsibleNavGroupProps = _SharedEuiCollapsibleNavItemProps & _EuiCollapsibleNavItemDisplayProps & Required<Pick<EuiCollapsibleNavItemProps, 'items'>> & {
	    header: ReactNode;
	};
	/**
	 * Internal nav group. Should look the same as an open accordion,
	 * but not be toggle-able to close.
	 *
	 * Yes, I know this is the 3rd component in EUI named EuiCollapsibleNavGroup :|
	 * I'm waiting for serverless's design architecture to settle before untangling
	 * this pasghetti
	 */
	export const EuiCollapsibleNavGroup: FunctionComponent<EuiCollapsibleNavGroupProps>;
	export {};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_item' {
	import { FunctionComponent, HTMLAttributes, MouseEventHandler, ReactNode } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	import { IconType, EuiIconProps } from '@elastic/eui/src/components/icon';
	import { EuiLinkProps } from '@elastic/eui/src/components/link';
	import { EuiAccordionProps } from '@elastic/eui/src/components/accordion';
	export type _SharedEuiCollapsibleNavItemProps = HTMLAttributes<HTMLElement> & CommonProps & {
	    /**
	     * Highlights whether an item is currently selected, e.g.
	     * if the user is on the same page as the nav link
	     */
	    isSelected?: boolean;
	};
	export type EuiCollapsibleNavItemProps = _SharedEuiCollapsibleNavItemProps & {
	    /**
	     * Required text to render as the nav item title
	     */
	    title: string;
	    /**
	     * Allows customizing the title element.
	     * Consider using a heading element for better accessibility.
	     * Defaults to an unsemantic `span` or `div`, depending on context.
	     */
	    titleElement?: 'h2' | 'h3' | 'h4' | 'h5' | 'h6' | 'span' | 'div';
	    /**
	     * Optional icon to render to the left of title content
	     */
	    icon?: IconType;
	    /**
	     * Optional props to pass to the title icon
	     */
	    iconProps?: Partial<EuiIconProps>;
	} & ExclusiveUnion<{
	    /**
	     * The nav item link.
	     *
	     * If not included, and no `onClick` is specified, the nav item
	     * will render as an non-interactive `<span>`.
	     *
	     * Should not be used together with `items`, as the title will
	     * trigger the accordion collapse/expand action instead of a link.
	     */
	    href?: string;
	    /**
	     * If a `href` is specified, use this prop to pass any prop that `EuiLink` accepts
	     */
	    linkProps?: Partial<EuiLinkProps>;
	}, {
	    /**
	     * Will render either an accordion or group of nested child item links.
	     *
	     * Accepts any #EuiCollapsibleNavItemProps. Or, to render completely custom
	     * subitem content, pass an object with a `renderItem` callback.
	     */
	    items: EuiCollapsibleNavSubItemProps[];
	    /**
	     * If set to false, will (visually) render an always-open accordion that cannot
	     * be toggled closed. Ignored if `items` is not passed.
	     *
	     * @default true
	     */
	    isCollapsible?: boolean;
	    /**
	     * If `items` is specified, and `isCollapsible` is not set to false, you may
	     * use this prop to pass any prop that `EuiAccordion` accepts, including props
	     * that control the toggled state of the accordion (e.g. `initialIsOpen`, `forceState`)
	     */
	    accordionProps?: Partial<EuiAccordionProps>;
	}>;
	export type EuiCollapsibleNavCustomSubItem = {
	    renderItem: (options: {
	        /**
	         * When the side nav is collapsed on larger screens, the menu appears in an EuiPopover.
	         * When the sidenav is collapsed on smaller screens, the menu appears in an EuiFlyout.
	         *
	         * Use this handler to close either the portalled flyout or popover, depending on which is present.
	         * If the handler is not defined, it means there is no portal onscreen to close.
	         */
	        closePortals?: MouseEventHandler;
	    }) => ReactNode;
	};
	export type EuiCollapsibleNavSubItemProps = ExclusiveUnion<EuiCollapsibleNavItemProps, EuiCollapsibleNavCustomSubItem>;
	export type _EuiCollapsibleNavItemDisplayProps = {
	    /**
	     * Determines whether the item should render as a top-level nav item
	     * or a nested nav subitem. Set internally by EUI
	     */
	    isSubItem?: boolean;
	};
	/**
	 * Internal subcomponent for title display
	 */
	export const EuiCollapsibleNavItemTitle: FunctionComponent<Pick<EuiCollapsibleNavItemProps, 'title' | 'titleElement' | 'icon' | 'iconProps'>>;
	/**
	 * Sub-items can either be a totally custom rendered item,
	 * or they can simply be more links or accordions
	 */
	export const EuiCollapsibleNavSubItem: FunctionComponent<EuiCollapsibleNavSubItemProps>; type EuiCollapsibleNavSubItemsProps = HTMLAttributes<HTMLDivElement> & _EuiCollapsibleNavItemDisplayProps & {
	    items: EuiCollapsibleNavSubItemProps[];
	};
	export const EuiCollapsibleNavSubItems: FunctionComponent<EuiCollapsibleNavSubItemsProps>;
	/**
	 * The actual exported component
	 */
	export const EuiCollapsibleNavItem: FunctionComponent<EuiCollapsibleNavItemProps>;
	export {};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item' {
	export type { EuiCollapsibleNavItemProps, EuiCollapsibleNavSubItemProps, } from '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_item';
	export { EuiCollapsibleNavItem, EuiCollapsibleNavSubItem, } from '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_item';

}
declare module '@elastic/eui/src/components/list_group/list_group_item_extra_action.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiListGroupItemExtraActionStyles: ({ euiTheme, }: UseEuiTheme) => {
	    euiListGroupItemExtraAction: import("@emotion/utils").SerializedStyles;
	    hoverStyles: import("@emotion/utils").SerializedStyles;
	    alwaysShow: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/list_group/list_group_item_extra_action' {
	import { FunctionComponent } from 'react';
	import { EuiButtonIconPropsForButton } from '@elastic/eui/src/components/button';
	export type EuiListGroupItemExtraActionProps = {
	    alwaysShow?: boolean;
	} & EuiButtonIconPropsForButton; type _FromEuiListGroupItem = {
	    parentIsDisabled?: boolean;
	};
	export const EuiListGroupItemExtraAction: FunctionComponent<EuiListGroupItemExtraActionProps & _FromEuiListGroupItem>;
	export {};

}
declare module '@elastic/eui/src/components/list_group/list_group_item.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiListGroupItemStyles: (euiThemeContext: UseEuiTheme) => {
	    euiListGroupItem: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    colors: {
	        isActive: {
	            primary: import("@emotion/utils").SerializedStyles;
	            text: import("@emotion/utils").SerializedStyles;
	            subdued: import("@emotion/utils").SerializedStyles;
	        };
	        isClickable: {
	            primary: import("@emotion/utils").SerializedStyles;
	            text: import("@emotion/utils").SerializedStyles;
	            subdued: import("@emotion/utils").SerializedStyles;
	        };
	    };
	};
	export const euiListGroupItemInnerStyles: (euiThemeContext: UseEuiTheme) => {
	    euiListGroupItem__inner: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    primary: import("@emotion/utils").SerializedStyles;
	    text: import("@emotion/utils").SerializedStyles;
	    subdued: import("@emotion/utils").SerializedStyles;
	    ghost: import("@emotion/utils").SerializedStyles;
	    isDisabled: import("@emotion/utils").SerializedStyles;
	    isActive: import("@emotion/utils").SerializedStyles;
	    isClickable: import("@emotion/utils").SerializedStyles;
	    externalIcon: import("@emotion/utils").SerializedStyles;
	};
	export const euiListGroupItemLabelStyles: () => {
	    euiListGroupItem__label: import("@emotion/utils").SerializedStyles;
	    truncate: import("@emotion/utils").SerializedStyles;
	    wrapText: import("@emotion/utils").SerializedStyles;
	};
	export const euiListGroupItemIconStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiListGroupItem__icon: import("@emotion/utils").SerializedStyles;
	};
	export const euiListGroupItemTooltipStyles: () => {
	    euiListGroupItem__tooltip: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/list_group/list_group_item' {
	import React, { HTMLAttributes, AnchorHTMLAttributes, ButtonHTMLAttributes, ReactNode, ReactElement, MouseEventHandler, FunctionComponent } from 'react';
	import { IconType, EuiIconProps } from '@elastic/eui/src/components/icon';
	import { EuiToolTipProps } from '@elastic/eui/src/components/tool_tip';
	import { ExclusiveUnion, CommonProps } from '@elastic/eui/src/components/common';
	import { EuiListGroupItemExtraActionProps } from '@elastic/eui/src/components/list_group/list_group_item_extra_action';
	export const SIZES: readonly ["xs", "s", "m", "l"];
	export type EuiListGroupItemSize = (typeof SIZES)[number];
	export const COLORS: readonly ["primary", "text", "subdued"];
	export type EuiListGroupItemColor = (typeof COLORS)[number];
	export type EuiListGroupItemProps = CommonProps & Omit<ExclusiveUnion<ExclusiveUnion<ButtonHTMLAttributes<HTMLButtonElement>, Omit<AnchorHTMLAttributes<HTMLAnchorElement>, 'href'>>, HTMLAttributes<HTMLSpanElement>>, 'onClick' | 'color' | 'target' | 'rel'> & {
	    /**
	     * Size of the label text
	     */
	    size?: EuiListGroupItemSize;
	    /**
	     * By default the item will get the color `text`.
	     * You can customize the color of the item by passing a color name.
	     */
	    color?: EuiListGroupItemColor;
	    /**
	     * Content to be displayed in the list item
	     */
	    label: ReactNode;
	    /**
	     * Apply styles indicating an item is active
	     */
	    isActive?: boolean;
	    /**
	     * Apply styles indicating an item is disabled
	     */
	    isDisabled?: boolean;
	    /**
	     * Make the list item label a link.
	     * While permitted, `href` and `onClick` should not be used together in most cases and may create problems.
	     */
	    href?: string;
	    rel?: string;
	    target?: string;
	    /**
	     * Set to true to show an icon indicating that it is an external link;
	     * Defaults to true if `target="_blank"`
	     */
	    external?: boolean;
	    /**
	     * Adds `EuiIcon` of `EuiIcon.type`
	     */
	    iconType?: IconType;
	    /**
	     * Further extend the props applied to EuiIcon
	     */
	    iconProps?: Omit<EuiIconProps, 'type'>;
	    /**
	     * Custom node to pass as the icon. Cannot be used in conjunction
	     * with `iconType` and `iconProps`.
	     */
	    icon?: ReactElement;
	    /**
	     * Display tooltip on list item
	     */
	    showToolTip?: boolean;
	    /**
	     * An object of #EuiListGroupItemExtraAction props.
	     * Adds an `EuiButtonIcon` to the right side of the item; `iconType` is required;
	     * pass `alwaysShow` if you don't want the default behavior of only showing on hover
	     */
	    extraAction?: EuiListGroupItemExtraActionProps;
	    /**
	     * Make the list item label a button.
	     * While permitted, `href` and `onClick` should not be used together in most cases and may create problems.
	     */
	    onClick?: MouseEventHandler<HTMLButtonElement>;
	    /**
	     * Allow link text to wrap
	     */
	    wrapText?: boolean;
	    /**
	     * Pass-through ref reference specifically for targeting
	     * instances where the item content is rendered as a `button`
	     */
	    buttonRef?: React.Ref<HTMLButtonElement>;
	    /**
	     * Text to be displayed in the tooltip when `showToolTip` is true.
	     * By default the text will be same as the label text.
	     */
	    toolTipText?: string;
	    /**
	     * Allows customizing the tooltip shown when `showToolTip` is true.
	     * Accepts any props that [EuiToolTip](/#/display/tooltip) accepts.
	     */
	    toolTipProps?: Partial<EuiToolTipProps>;
	};
	export const EuiListGroupItem: FunctionComponent<EuiListGroupItemProps>;

}
declare module '@elastic/eui/src/components/list_group/list_group.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiListGroupStyles: (euiThemeContext: UseEuiTheme) => {
	    euiListGroup: import("@emotion/utils").SerializedStyles;
	    flush: import("@emotion/utils").SerializedStyles;
	    bordered: import("@emotion/utils").SerializedStyles;
	    maxWidthDefault: import("@emotion/utils").SerializedStyles;
	    none: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/list_group/list_group' {
	import { FunctionComponent, HTMLAttributes, CSSProperties } from 'react';
	import { EuiListGroupItemProps } from '@elastic/eui/src/components/list_group/list_group_item';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const GUTTER_SIZES: readonly ["none", "s", "m"];
	export type EuiListGroupGutterSize = (typeof GUTTER_SIZES)[number];
	export type EuiListGroupProps = CommonProps & Omit<HTMLAttributes<HTMLUListElement>, 'color'> & {
	    /**
	     * Add a border to the list container
	     */
	    bordered?: boolean;
	    /**
	     * Remove container padding, stretching list items to the edges
	     */
	    flush?: boolean;
	    /**
	     * Spacing between list items
	     */
	    gutterSize?: EuiListGroupGutterSize;
	    /**
	     * Items to display in this group. See #EuiListGroupItem
	     */
	    listItems?: EuiListGroupItemProps[];
	    /**
	     * Change the colors of all `listItems` at once
	     * @default text
	     */
	    color?: EuiListGroupItemProps['color'];
	    /**
	     * Change the size of all `listItems` at once
	     * @default m
	     */
	    size?: EuiListGroupItemProps['size'];
	    /**
	     * Sets the max-width of the page.
	     * Set to `true` to use the default size,
	     * set to `false` to not restrict the width,
	     * or set to a number/string for a custom CSS width/measurement.
	     */
	    maxWidth?: boolean | CSSProperties['maxWidth'];
	    /**
	     * Display tooltips on all list items
	     */
	    showToolTips?: boolean;
	    /**
	     * Allow link text to wrap vs truncated
	     */
	    wrapText?: boolean;
	    ariaLabelledby?: string;
	};
	export const EuiListGroup: FunctionComponent<EuiListGroupProps>;

}
declare module '@elastic/eui/src/components/list_group/pinnable_list_group/pinnable_list_group.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiPinnableListGroupItemExtraActionStyles: ({ euiTheme, }: UseEuiTheme) => {
	    euiPinnableListGroup__itemExtraAction: import("@emotion/utils").SerializedStyles;
	    pinned: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/list_group/pinnable_list_group/pinnable_list_group' {
	import { FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiListGroupProps } from '@elastic/eui/src/components/list_group/list_group';
	import { EuiListGroupItemProps } from '@elastic/eui/src/components/list_group/list_group_item';
	export type EuiPinnableListGroupItemProps = EuiListGroupItemProps & {
	    /**
	     * Saves the pinned status and changes the visibility of the pin icon
	     */
	    pinned?: boolean;
	    /**
	     * Passing `onPinClick` to the full EuiPinnableListGroup, will make every item pinnable.
	     * Set this property to `false` to turn off individual item pinnability
	     */
	    pinnable?: boolean;
	};
	export interface EuiPinnableListGroupProps extends CommonProps, EuiListGroupProps {
	    /**
	     * Extends `EuiListGroupItemProps`, at the very least, expecting a `label`.
	     * See #EuiPinnableListGroupItem
	     */
	    listItems: EuiPinnableListGroupItemProps[];
	    /**
	     * Shows the pin icon and calls this function on click.
	     * Returns `item: EuiPinnableListGroupItemProps`
	     */
	    onPinClick: (item: EuiPinnableListGroupItemProps) => void;
	    /**
	     * The pin icon needs a title/aria-label for accessibility.
	     * It is a function that passes the item back and must return a string `(item) => string`.
	     * Default is `"Pin item"`
	     */
	    pinTitle?: (item: EuiPinnableListGroupItemProps) => string;
	    /**
	     * The unpin icon needs a title/aria-label for accessibility.
	     * It is a function that passes the item back and must return a string `(item) => string`.
	     * Default is `"Unpin item"`
	     */
	    unpinTitle?: (item: EuiPinnableListGroupItemProps) => string;
	}
	export const EuiPinnableListGroup: FunctionComponent<EuiPinnableListGroupProps>;

}
declare module '@elastic/eui/src/components/list_group/pinnable_list_group' {
	export type { EuiPinnableListGroupProps, EuiPinnableListGroupItemProps, } from '@elastic/eui/src/components/list_group/pinnable_list_group/pinnable_list_group';
	export { EuiPinnableListGroup } from '@elastic/eui/src/components/list_group/pinnable_list_group/pinnable_list_group';

}
declare module '@elastic/eui/src/components/list_group' {
	export type { EuiListGroupProps } from '@elastic/eui/src/components/list_group/list_group';
	export { EuiListGroup } from '@elastic/eui/src/components/list_group/list_group';
	export type { EuiListGroupItemProps } from '@elastic/eui/src/components/list_group/list_group_item';
	export type { EuiListGroupItemExtraActionProps } from '@elastic/eui/src/components/list_group/list_group_item_extra_action';
	export { EuiListGroupItem } from '@elastic/eui/src/components/list_group/list_group_item';
	export type { EuiPinnableListGroupProps, EuiPinnableListGroupItemProps, } from '@elastic/eui/src/components/list_group/pinnable_list_group';
	export { EuiPinnableListGroup } from '@elastic/eui/src/components/list_group/pinnable_list_group';

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/_kibana_solution/collapsible_nav_kibana_solution.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCollapsibleNavKibanaSolutionStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCollapsibleNavKibanaSolution: import("@emotion/utils").SerializedStyles;
	    collapsed: import("@emotion/utils").SerializedStyles;
	    uncollapsed: import("@emotion/utils").SerializedStyles;
	    euiCollapsibleNavKibanaSolution__title: import("@emotion/utils").SerializedStyles;
	    euiCollapsibleNavKibanaSolution__logo: import("@emotion/utils").SerializedStyles;
	    euiCollapsibleNavKibanaSolution__switcherIcon: import("@emotion/utils").SerializedStyles;
	    euiCollapsibleNavKibanaSolution__switcherPopover: import("@emotion/utils").SerializedStyles;
	    euiCollapsibleNavKibanaSolution__secondaryItems: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/_kibana_solution/collapsible_nav_kibana_solution' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { type EuiListGroupItemProps } from '@elastic/eui/src/components/list_group';
	import { type EuiCollapsibleNavItemProps } from '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item/collapsible_nav_item';
	export type KibanaCollapsibleNavSolutionProps = HTMLAttributes<HTMLDivElement> & CommonProps & Required<Pick<EuiCollapsibleNavItemProps, 'title' | 'icon' | 'items'>> & {
	    solutions: EuiListGroupItemsModified;
	};
	/**
	 * This component should only ever be used as a **top-level component**.
	 * It also should **not** be used in the nav footer.
	 *
	 * This component is **very** specific to Kibana and is not meant to be a generic component.
	 */
	export const KibanaCollapsibleNavSolution: FunctionComponent<KibanaCollapsibleNavSolutionProps>; type EuiListGroupItemsModified = Array<Omit<EuiListGroupItemProps, 'label' | 'iconType' | 'icon'> & {
	    title: string;
	    icon?: EuiListGroupItemProps['iconType'];
	    isSecondary?: boolean;
	}>;
	export {};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/_kibana_solution' {
	export { KibanaCollapsibleNavSolution } from '@elastic/eui/src/components/collapsible_nav_beta/_kibana_solution/collapsible_nav_kibana_solution';

}
declare module '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_beta' {
	import React, { HTMLAttributes, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiFlyoutProps } from '@elastic/eui/src/components/flyout';
	export type EuiCollapsibleNavBetaProps = CommonProps & HTMLAttributes<HTMLElement> & Pick<EuiFlyoutProps, // Extend only specific flyout props - EuiCollapsibleNav is much less customizable than EuiFlyout
	// Extend only specific flyout props - EuiCollapsibleNav is much less customizable than EuiFlyout
	'side' | 'focusTrapProps' | 'includeFixedHeadersInFocusTrap'> & {
	    /**
	     * ReactNode(s) to render as navigation flyout content, typically `EuiCollapsibleNavBeta.Item`s.
	     * You will likely want to use `EuiCollapsibleNavBeta.Body` and `EuiCollapsibleNavBeta.Footer`
	     * for organization.
	     */
	    children?: ReactNode;
	    /**
	     * Whether the navigation flyout should default to initially collapsed or expanded.
	     * Used for **uncontrolled** state.
	     */
	    initialIsCollapsed?: boolean;
	    /**
	     * If defined, the navigation collapsed/expanded state is **controlled**
	     * by the consumer and `onCollapseToggle` must be passed as well.
	     * This prop supercedes `initialIsCollapsed`.
	     */
	    isCollapsed?: boolean;
	    /**
	     * Optional callback that fires when the user toggles the nav between
	     * collapsed and uncollapsed states
	     */
	    onCollapseToggle?: (isCollapsed: boolean) => void;
	    /**
	     * Defaults to 248px wide. The navigation width determines behavior at
	     * various responsive breakpoints.
	     *
	     * At larger screen sizes (at least 3x the width of the nav), the nav will
	     * be able to be toggled between a docked full width nav and a collapsed
	     * side bar that only shows the icon of each item.
	     *
	     * At under 3 times the width of the nav, the behavior will lose the collapsed
	     * side bar behavior, and switch from a docked flyout to an overlay flyout only.
	     *
	     * If the page is under 1.5 times the width of the nav, the overlay will
	     * take up the full width of the page.
	     */
	    width?: number;
	    /**
	     * Overlay flyouts are considered dialogs, and dialogs must have a label.
	     * By default, a label of `Site menu` will be applied.
	     *
	     * If your usage of this component is not actually for site-wide navigation,
	     * please set your own `aria-label` or `aria-labelledby`.
	     *
	     * @default 'Site menu'
	     */
	    'aria-label'?: string;
	};
	export const EuiCollapsibleNavBeta: React.FunctionComponent<EuiCollapsibleNavBetaProps> & {
	    Body: import ("@elastic/eui/src/components/flyout").EuiFlyoutBodyProps;
	    Footer: import ("@elastic/eui/src/components/flyout").EuiFlyoutFooterProps;
	    Item: React.FunctionComponent<import ("@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item").EuiCollapsibleNavItemProps>;
	    KibanaSolution: React.FunctionComponent<import ("@elastic/eui/src/components/collapsible_nav_beta/_kibana_solution/collapsible_nav_kibana_solution").KibanaCollapsibleNavSolutionProps>;
	};

}
declare module '@elastic/eui/src/components/collapsible_nav_beta' {
	/**
	 * NOTE: This is currently still a beta component, being exported for Kibana
	 * development usage. It is not yet fully documented or supported.
	 */
	export type { EuiCollapsibleNavBetaProps } from '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_beta';
	export { EuiCollapsibleNavBeta } from '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_beta';
	export type { EuiCollapsibleNavItemProps, EuiCollapsibleNavSubItemProps, } from '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item';
	export { EuiCollapsibleNavItem } from '@elastic/eui/src/components/collapsible_nav_beta/collapsible_nav_item';

}
declare module '@elastic/eui/src/components/color_picker/color_picker_swatch.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiColorPickerSwatchStyles: (euiThemeContext: UseEuiTheme) => {
	    euiColorPickerSwatch: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/color_picker/color_picker_swatch' {
	import React, { ButtonHTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiColorPickerSwatchProps = CommonProps & Omit<ButtonHTMLAttributes<HTMLButtonElement>, 'color'> & {
	    color?: string;
	};
	export const EuiColorPickerSwatch: React.ForwardRefExoticComponent<CommonProps & Omit<React.ButtonHTMLAttributes<HTMLButtonElement>, "color"> & {
	    color?: string | undefined;
	} & React.RefAttributes<HTMLButtonElement>>;

}
declare module '@elastic/eui/src/components/color_picker/hue.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiHueStyles: (euiThemeContext: UseEuiTheme) => {
	    euiHue: import("@emotion/utils").SerializedStyles;
	    euiHue__range: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/color_picker/hue' {
	import { InputHTMLAttributes, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiHueProps = Omit<InputHTMLAttributes<HTMLInputElement>, 'onChange'> & CommonProps & {
	    hex?: string;
	    hue?: string | number;
	    onChange: (hue: number) => void;
	};
	export const EuiHue: FunctionComponent<EuiHueProps>;

}
declare module '@elastic/eui/src/components/color_picker/saturation.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiSaturationStyles: (euiThemeContext: UseEuiTheme) => {
	    euiSaturation: import("@emotion/utils").SerializedStyles;
	    euiSaturation__lightness: import("@emotion/utils").SerializedStyles;
	    euiSaturation__saturation: import("@emotion/utils").SerializedStyles;
	    euiSaturation__indicator: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/color_picker/saturation' {
	import React, { HTMLAttributes } from 'react';
	import { ColorSpaces } from 'chroma-js';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type SaturationClientRect = Pick<ClientRect, 'left' | 'top' | 'width' | 'height'>;
	export type SaturationPosition = Pick<SaturationClientRect, 'left' | 'top'>;
	interface HTMLDivElementOverrides {
	    color?: ColorSpaces['hsv'];
	    onChange: (color: ColorSpaces['hsv']) => void;
	}
	export type EuiSaturationProps = Omit<HTMLAttributes<HTMLDivElement>, keyof HTMLDivElementOverrides> & CommonProps & HTMLDivElementOverrides & {
	    hex?: string;
	};
	export const EuiSaturation: React.ForwardRefExoticComponent<Omit<React.HTMLAttributes<HTMLDivElement>, keyof HTMLDivElementOverrides> & CommonProps & HTMLDivElementOverrides & {
	    hex?: string | undefined;
	} & React.RefAttributes<HTMLDivElement>>;
	export {};

}
declare module '@elastic/eui/src/components/color_picker/color_picker.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiColorPickerStyles: (euiThemeContext: UseEuiTheme) => {
	    euiColorPicker: import("@emotion/utils").SerializedStyles;
	    euiColorPicker__swatches: import("@emotion/utils").SerializedStyles;
	    euiColorPicker__alphaRange: import("@emotion/utils").SerializedStyles;
	    euiColorPicker__swatchInputIcon: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/color_picker/color_picker' {
	import { FunctionComponent, HTMLAttributes, ReactElement } from 'react';
	import { ColorSpaces } from 'chroma-js';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiFormControlLayoutProps } from '@elastic/eui/src/components/form'; type EuiColorPickerDisplay = 'default' | 'inline'; type EuiColorPickerMode = 'default' | 'swatch' | 'picker' | 'secondaryInput';
	export interface EuiColorPickerOutput {
	    rgba: ColorSpaces['rgba'];
	    hex: string;
	    isValid: boolean;
	}
	interface HTMLDivElementOverrides {
	    /**
	     * hex (string)
	     * RGB (as comma separated string)
	     * RGBa (as comma separated string)
	     * Empty string will register as 'transparent'
	     */
	    color?: string | null;
	    onBlur?: () => void;
	    /**
	     * text (string, as entered or selected)
	     * hex (8-digit hex if alpha < 1, otherwise 6-digit hex)
	     * RGBa (as array; values of NaN if color is invalid)
	     * isValid (boolean signifying if the input text is a valid color)
	     */
	    onChange: (text: string, output: EuiColorPickerOutput) => void;
	    onFocus?: () => void;
	}
	export interface EuiColorPickerProps extends CommonProps, Omit<HTMLAttributes<HTMLDivElement>, keyof HTMLDivElementOverrides>, HTMLDivElementOverrides {
	    /**
	     *  Custom element to use instead of text input
	     */
	    button?: ReactElement;
	    /**
	     *  Use the compressed style for EuiFieldText
	     */
	    compressed?: boolean;
	    display?: EuiColorPickerDisplay;
	    disabled?: boolean;
	    fullWidth?: boolean;
	    id?: string;
	    /**
	     *  Custom validation flag
	     */
	    isInvalid?: boolean;
	    /**
	     * Choose between swatches with gradient picker (default), swatches only, gradient picker only, or secondary input only.
	     */
	    mode?: EuiColorPickerMode;
	    /**
	     *  Custom z-index for the popover
	     */
	    popoverZIndex?: number;
	    readOnly?: boolean;
	    /**
	     *  Array of hex strings (3 or 6 character) to use as swatch options. Defaults to EUI visualization colors
	     */
	    swatches?: string[];
	    /**
	     * Creates an input group with element(s) coming before input. It only shows when the `display` is set to `default`.
	     * `string` | `ReactElement` or an array of these
	     */
	    prepend?: EuiFormControlLayoutProps['prepend'];
	    /**
	     * Creates an input group with element(s) coming after input. It only shows when the `display` is set to `default`.
	     * `string` | `ReactElement` or an array of these
	     */
	    append?: EuiFormControlLayoutProps['append'];
	    /**
	     * Whether to render the alpha channel (opacity) value range slider.
	     */
	    showAlpha?: boolean;
	    /**
	     * Will format the text input in the provided format when possible (hue and saturation selection)
	     * Exceptions: Manual text input and swatches will display as-authored
	     * Default is to display the last format entered by the user
	     */
	    format?: 'hex' | 'rgba';
	    /**
	     * Placement option for a secondary color value input.
	     */
	    secondaryInputDisplay?: 'top' | 'bottom' | 'none';
	    /**
	     * Add a button to the primary input to clear its value.
	     */
	    isClearable?: boolean;
	    /**
	     * Text to replace the default 'Transparent' placeholder for unset color values.
	     */
	    placeholder?: string;
	}
	export const EuiColorPicker: FunctionComponent<EuiColorPickerProps>;
	export {};

}
declare module '@elastic/eui/src/components/color_picker' {
	export type { EuiColorPickerProps } from '@elastic/eui/src/components/color_picker/color_picker';
	export { EuiColorPicker } from '@elastic/eui/src/components/color_picker/color_picker';
	export type { EuiColorPickerSwatchProps } from '@elastic/eui/src/components/color_picker/color_picker_swatch';
	export { EuiColorPickerSwatch } from '@elastic/eui/src/components/color_picker/color_picker_swatch';
	export type { EuiColorPalettePickerProps, EuiColorPalettePickerPaletteProps, } from '@elastic/eui/src/components/color_picker/color_palette_picker';
	export { EuiColorPalettePicker } from '@elastic/eui/src/components/color_picker/color_palette_picker';
	export type { EuiColorPaletteDisplayProps } from '@elastic/eui/src/components/color_picker/color_palette_display';
	export { EuiColorPaletteDisplay } from '@elastic/eui/src/components/color_picker/color_palette_display';

}
declare module '@elastic/eui/src/components/combo_box/types' {
	import { ButtonHTMLAttributes, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import type { _EuiComboBoxProps } from '@elastic/eui/src/components/combo_box/combo_box';
	import { EuiToolTipProps } from '@elastic/eui/src/components/tool_tip';
	export interface EuiComboBoxOptionOption<T = string | number | string[] | undefined> extends CommonProps, Omit<ButtonHTMLAttributes<HTMLButtonElement>, 'value'> {
	    isGroupLabelOption?: boolean;
	    label: string;
	    key?: string;
	    options?: Array<EuiComboBoxOptionOption<T>>;
	    value?: T;
	    prepend?: ReactNode;
	    append?: ReactNode;
	    truncationProps?: _EuiComboBoxProps<T>['truncationProps'];
	    /**
	     * Optional custom tooltip content for the button
	     */
	    toolTipContent?: EuiToolTipProps['content'];
	    /**
	     * Optional props to pass to the underlying **[EuiToolTip](/#/display/tooltip)**
	     */
	    toolTipProps?: Partial<Omit<EuiToolTipProps, 'content' | 'children'>>;
	}
	export type OptionHandler<T> = (option: EuiComboBoxOptionOption<T>) => void;
	export type RefInstance<T> = T | null;
	export interface EuiComboBoxSingleSelectionShape {
	    asPlainText?: boolean;
	}
	export interface EuiComboBoxOptionMatcherArgs<TOption> {
	    /**
	     * Option being currently processed
	     */
	    option: EuiComboBoxOptionOption<TOption>;
	    /**
	     * Raw search input value
	     */
	    searchValue: string;
	    /**
	     * Search input value normalized for case-sensitivity
	     * and with leading and trailing whitespace characters trimmed
	     */
	    normalizedSearchValue: string;
	    /**
	     * Whether to match the option with case-sensitivity
	     */
	    isCaseSensitive: boolean;
	}
	/**
	 * Option matcher function for EuiComboBox component.
	 *
	 * @example
	 * const equalityMatcher: EuiComboBoxOptionMatcher = ({ option, searchValue }) => {
	 *   return option.label === searchValue;
	 * }
	 */
	export type EuiComboBoxOptionMatcher<TOption> = (args: EuiComboBoxOptionMatcherArgs<TOption>) => boolean;

}
declare module '@elastic/eui/src/components/combo_box/matching_options' {
	import { EuiComboBoxOptionOption, EuiComboBoxOptionMatcher } from '@elastic/eui/src/components/combo_box/types';
	export type SortMatchesBy = 'none' | 'startsWith';
	interface GetMatchingOptions<T> {
	    options: Array<EuiComboBoxOptionOption<T>>;
	    selectedOptions: Array<EuiComboBoxOptionOption<T>>;
	    searchValue: string;
	    optionMatcher: EuiComboBoxOptionMatcher<T>;
	    isCaseSensitive?: boolean;
	    isPreFiltered?: boolean;
	    showPrevSelected?: boolean;
	    sortMatchesBy?: SortMatchesBy;
	}
	interface GetSelectedOptionForSearchValue<T> extends Pick<GetMatchingOptions<T>, 'isCaseSensitive' | 'searchValue' | 'selectedOptions'> {
	    optionKey?: string;
	}
	export const transformForCaseSensitivity: (string: string, isCaseSensitive?: boolean | undefined) => string;
	export const flattenOptionGroups: <T>(optionsOrGroups: EuiComboBoxOptionOption<T>[]) => EuiComboBoxOptionOption<T>[];
	export const getSelectedOptionForSearchValue: <T>({ isCaseSensitive, searchValue, selectedOptions, optionKey, }: GetSelectedOptionForSearchValue<T>) => EuiComboBoxOptionOption<T> | undefined;
	export const getMatchingOptions: <T>({ options, selectedOptions, searchValue, optionMatcher, isCaseSensitive, isPreFiltered, showPrevSelected, sortMatchesBy, }: GetMatchingOptions<T>) => EuiComboBoxOptionOption<T>[];
	/**
	 * Partial string equality option matcher for EuiComboBox.
	 * It matches all options with labels including the searched string.
	 */
	export const createPartialStringEqualityOptionMatcher: <TOption>() => EuiComboBoxOptionMatcher<TOption>;
	export {};

}
declare module '@elastic/eui/src/components/combo_box/utils' {
	import React, { PropsWithChildren } from 'react';
	import { EuiComboBoxOptionOption } from '@elastic/eui/src/components/combo_box/types';
	/**
	 * DRY util for rendering an option with its prepend and append properties
	 */
	export const EuiComboBoxOptionAppendPrepend: <T>({ children, option, classNamePrefix, marginSize, }: {
	    children?: React.ReactNode;
	} & {
	    option?: EuiComboBoxOptionOption<T> | undefined;
	    classNamePrefix?: string | undefined;
	    marginSize?: "xs" | "s" | "xxs" | undefined;
	}) => React.JSX.Element;

}
declare module '@elastic/eui/src/components/combo_box/combo_box_input/combo_box_pill.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiComboBoxPillStyles: (euiThemeContext: UseEuiTheme) => {
	    euiComboBoxPill: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/combo_box/combo_box_input/combo_box_pill' {
	import React, { AriaAttributes, MouseEventHandler } from 'react';
	import { EuiComboBoxOptionOption, OptionHandler } from '@elastic/eui/src/components/combo_box/types';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export interface EuiComboBoxPillProps<T> extends CommonProps {
	    children?: string;
	    className?: string;
	    color?: string;
	    onClick?: MouseEventHandler<HTMLButtonElement>;
	    onClickAriaLabel?: AriaAttributes['aria-label'];
	    onClose?: OptionHandler<T>;
	    option: EuiComboBoxOptionOption<T>;
	}
	export const EuiComboBoxPill: <T>({ children, className, color, onClick, onClickAriaLabel, onClose, option, ...rest }: EuiComboBoxPillProps<T>) => React.JSX.Element;

}
declare module '@elastic/eui/src/components/combo_box/combo_box_input/combo_box_input.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiComboBoxInputStyles: (euiThemeContext: UseEuiTheme) => {
	    euiComboBoxInputWrapper: import("@emotion/utils").SerializedStyles;
	    multiSelect: import("@emotion/utils").SerializedStyles;
	    uncompressed: string;
	    compressed: import("@emotion/utils").SerializedStyles;
	    plainText: {
	        plainText: import("@emotion/utils").SerializedStyles;
	        compressed: string;
	        uncompressed: string;
	    };
	    invalid: import("@emotion/utils").SerializedStyles;
	    disabled: import("@emotion/utils").SerializedStyles;
	    open: import("@emotion/utils").SerializedStyles;
	    inGroup: import("@emotion/utils").SerializedStyles;
	    euiComboBoxInput: import("@emotion/utils").SerializedStyles;
	    formLayout: {
	        euiComboBox__formControlLayout: import("@emotion/utils").SerializedStyles;
	        multiSelect: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/combo_box/combo_box_input/combo_box_input' {
	import React, { Component, FocusEventHandler, KeyboardEventHandler, RefCallback } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { htmlIdGenerator } from '@elastic/eui/src/services';
	import { EuiFormControlLayoutProps } from '@elastic/eui/src/components/form/form_control_layout';
	import { EuiComboBoxOptionOption, EuiComboBoxSingleSelectionShape, OptionHandler } from '@elastic/eui/src/components/combo_box/types';
	export interface EuiComboBoxInputProps<T> extends CommonProps {
	    compressed: boolean;
	    focusedOptionId?: string;
	    fullWidth?: boolean;
	    hasSelectedOptions: boolean;
	    id?: string;
	    inputRef?: RefCallback<HTMLInputElement>;
	    isDisabled?: boolean;
	    isListOpen: boolean;
	    noIcon: boolean;
	    onBlur?: FocusEventHandler<HTMLInputElement>;
	    onChange: (searchValue: string) => void;
	    onClear?: () => void;
	    onClick: () => void;
	    onCloseListClick: () => void;
	    onFocus: FocusEventHandler<HTMLInputElement>;
	    onOpenListClick: () => void;
	    onRemoveOption: OptionHandler<T>;
	    placeholder?: string;
	    rootId: ReturnType<typeof htmlIdGenerator>;
	    searchValue: string;
	    selectedOptions: Array<EuiComboBoxOptionOption<T>>;
	    singleSelection?: boolean | EuiComboBoxSingleSelectionShape;
	    toggleButtonRef?: RefCallback<HTMLButtonElement | HTMLSpanElement>;
	    value?: string;
	    prepend?: EuiFormControlLayoutProps['prepend'];
	    append?: EuiFormControlLayoutProps['append'];
	    isLoading?: boolean;
	    isInvalid?: boolean;
	    autoFocus?: boolean;
	    'aria-label'?: string;
	    'aria-labelledby'?: string;
	}
	interface EuiComboBoxInputState {
	    inputWidth: number;
	    hasFocus: boolean;
	}
	export class EuiComboBoxInput<T> extends Component<EuiComboBoxInputProps<T>, EuiComboBoxInputState> {
	    state: EuiComboBoxInputState;
	    private widthUtils?;
	    inputRefCallback: (el: HTMLInputElement) => void;
	    updateInputSize: (inputValue: string) => void;
	    componentDidUpdate(prevProps: EuiComboBoxInputProps<T>): void;
	    onFocus: FocusEventHandler<HTMLInputElement>;
	    onBlur: FocusEventHandler<HTMLInputElement>;
	    onKeyDown: KeyboardEventHandler<HTMLInputElement>;
	    get asPlainText(): boolean;
	    get searchValue(): string;
	    renderPills: () => React.JSX.Element[] | null;
	    render(): React.JSX.Element;
	}
	export {};

}
declare module '@elastic/eui/src/components/mark/mark.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiMarkStyles: ({ euiTheme, colorMode }: UseEuiTheme) => {
	    euiMark: import("@emotion/utils").SerializedStyles;
	};
	export const euiMarkScreenReaderStyles: (highlightStart: string, highlightEnd: string) => {
	    hasScreenReaderHelpText: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/mark/mark' {
	import { HTMLAttributes, FunctionComponent, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiMarkProps = HTMLAttributes<HTMLElement> & CommonProps & {
	    /**
	     * Set to `false` to remove the CSS :before and :after
	     * screen reader helper text
	     */
	    hasScreenReaderHelpText?: boolean;
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: ReactNode;
	};
	export const EuiMark: FunctionComponent<EuiMarkProps>;

}
declare module '@elastic/eui/src/components/mark' {
	export type { EuiMarkProps } from '@elastic/eui/src/components/mark/mark';
	export { EuiMark } from '@elastic/eui/src/components/mark/mark';

}
declare module '@elastic/eui/src/components/highlight/_highlight_all' {
	import { FunctionComponent } from 'react';
	import type { _SharedSubcomponentProps } from '@elastic/eui/src/components/highlight/highlight';
	/**
	 * Internal subcomponent with logic for highlighting all occurrences
	 * of a search value within a subject
	 *
	 * Uses regex rather than indexOf/while loops for easier dev maintainability
	 */
	export const HighlightAll: FunctionComponent<_SharedSubcomponentProps>;

}
declare module '@elastic/eui/src/components/highlight/_highlight_first' {
	import { FunctionComponent } from 'react';
	import { _SharedSubcomponentProps } from '@elastic/eui/src/components/highlight/highlight';
	/**
	 * Internal subcomponent with logic for highlighting only the first occurrence
	 * of a search value within a subject
	 *
	 * Uses indexOf for performance (which does matter for, e.g. EuiSelectable searching)
	 */
	export const HighlightFirst: FunctionComponent<_SharedSubcomponentProps>;

}
declare module '@elastic/eui/src/components/highlight/highlight' {
	import { HTMLAttributes, FunctionComponent, ElementType } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiMarkProps } from '@elastic/eui/src/components/mark';
	export type EuiHighlightProps = HTMLAttributes<HTMLSpanElement> & Pick<EuiMarkProps, 'hasScreenReaderHelpText'> & CommonProps & {
	    /**
	     * string to highlight as this component's content
	     */
	    children: string;
	    /**
	     * What to search for.
	     *
	     * Allows passing an array of strings (searching by multiple separate
	     * words or phrases) **only** if `highlightAll` is also set to `true`.
	     */
	    search: string | string[];
	    /**
	     * Should the search be strict or not
	     */
	    strict?: boolean;
	    /**
	     * Should highlight all matches
	     */
	    highlightAll?: boolean;
	};
	export const EuiHighlight: FunctionComponent<EuiHighlightProps>;
	export type _SharedSubcomponentProps = {
	    searchValue: EuiHighlightProps['search'];
	    searchSubject: EuiHighlightProps['children'];
	    isStrict: EuiHighlightProps['strict'];
	    highlightComponent?: ElementType;
	};

}
declare module '@elastic/eui/src/components/highlight' {
	export type { EuiHighlightProps } from '@elastic/eui/src/components/highlight/highlight';
	export { EuiHighlight } from '@elastic/eui/src/components/highlight/highlight';

}
declare module '@elastic/eui/src/components/filter_group/filter_select_item.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFilterSelectItemStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFilterSelectItem: import("@emotion/utils").SerializedStyles;
	    isFocused: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/filter_group/filter_select_item' {
	import React, { ButtonHTMLAttributes, Component } from 'react';
	import { WithEuiThemeProps } from '@elastic/eui/src/services';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiToolTip } from '@elastic/eui/src/components/tool_tip';
	import { EuiComboBoxOptionOption } from '@elastic/eui/src/components/combo_box';
	export type FilterChecked = 'on' | 'off';
	export interface EuiFilterSelectItemProps extends CommonProps, ButtonHTMLAttributes<HTMLButtonElement> {
	    checked?: FilterChecked;
	    showIcons?: boolean;
	    isFocused?: boolean;
	    toolTipContent?: EuiComboBoxOptionOption['toolTipContent'];
	    toolTipProps?: EuiComboBoxOptionOption['toolTipProps'];
	}
	/**
	 * TODO: This component should removed in favor of EuiSelectable usage
	 * once EuiComboBox has been converted to dogfood EuiSelectable.
	 *
	 * @deprecated - Use EuiSelectable instead
	 */
	export class EuiFilterSelectItemClass extends Component<WithEuiThemeProps & EuiFilterSelectItemProps> {
	    static defaultProps: {
	        showIcons: boolean;
	    };
	    buttonRef: HTMLButtonElement | null;
	    tooltipRef: React.RefObject<EuiToolTip>;
	    state: {
	        hasFocus: boolean;
	    };
	    focus: () => void;
	    toggleToolTip: (isFocused: boolean) => void;
	    hasFocus: () => boolean;
	    render(): React.JSX.Element;
	}
	/**
	 * @deprecated - Use EuiSelectable instead
	 */
	export const EuiFilterSelectItem: React.ForwardRefExoticComponent<Omit<EuiFilterSelectItemProps, "theme"> & React.RefAttributes<Omit<EuiFilterSelectItemProps, "theme">>>;

}
declare module '@elastic/eui/src/components/combo_box/combo_box_options_list/combo_box_title' {
	import { FunctionComponent, PropsWithChildren } from 'react';
	export const EuiComboBoxTitle: FunctionComponent<PropsWithChildren>;

}
declare module '@elastic/eui/src/components/combo_box/combo_box_options_list/combo_box_options_list.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const LIST_MAX_HEIGHT = 200;
	export const euiComboBoxOptionListStyles: (euiThemeContext: UseEuiTheme) => {
	    euiComboBoxOptionList: import("@emotion/utils").SerializedStyles;
	    euiComboBoxOptionList__virtualization: import("@emotion/utils").SerializedStyles;
	    euiComboBoxOptionsList__empty: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/combo_box/combo_box_options_list/combo_box_options_list' {
	import React, { Component, ContextType, ReactNode, RefCallback } from 'react';
	import { FixedSizeList, FixedSizeListProps, ListProps, ListChildComponentProps } from 'react-window';
	import { htmlIdGenerator } from '@elastic/eui/src/services';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiInputPopoverWidthContext } from '@elastic/eui/src/components/popover/input_popover';
	import type { _EuiComboBoxProps } from '@elastic/eui/src/components/combo_box/combo_box';
	import { EuiComboBoxOptionOption, EuiComboBoxSingleSelectionShape, OptionHandler } from '@elastic/eui/src/components/combo_box/types';
	export type EuiComboBoxOptionsListProps<T> = CommonProps & {
	    activeOptionIndex?: number;
	    areAllOptionsSelected?: boolean;
	    listboxAriaLabel: string;
	    /**
	     * Creates a custom text option. You can use `{searchValue}` inside your string to better customize your text.
	     * It won't show if there's no onCreateOption.
	     */
	    customOptionText?: string;
	    fullWidth?: boolean;
	    getSelectedOptionForSearchValue?: (params: {
	        isCaseSensitive?: boolean;
	        searchValue: string;
	        selectedOptions: any[];
	    }) => EuiComboBoxOptionOption<T> | undefined;
	    isCaseSensitive?: boolean;
	    isLoading?: boolean;
	    listRef: RefCallback<HTMLDivElement>;
	    matchingOptions: Array<EuiComboBoxOptionOption<T>>;
	    onCloseList: (event: Event) => void;
	    onCreateOption?: (searchValue: string, options: Array<EuiComboBoxOptionOption<T>>) => boolean | void;
	    onOptionClick?: OptionHandler<T>;
	    onOptionEnterKey?: OptionHandler<T>;
	    onScroll?: ListProps['onScroll'];
	    /**
	     * Array of EuiComboBoxOptionOption objects. See #EuiComboBoxOptionOption
	     */
	    options: Array<EuiComboBoxOptionOption<T>>;
	    renderOption?: (option: EuiComboBoxOptionOption<T>, searchValue: string, OPTION_CONTENT_CLASSNAME: string) => ReactNode;
	    rootId: ReturnType<typeof htmlIdGenerator>;
	    rowHeight: number;
	    scrollToIndex?: number;
	    searchValue: string;
	    selectedOptions: Array<EuiComboBoxOptionOption<T>>;
	    singleSelection?: boolean | EuiComboBoxSingleSelectionShape;
	    delimiter?: string;
	    truncationProps?: _EuiComboBoxProps<T>['truncationProps'];
	};
	export class EuiComboBoxOptionsList<T> extends Component<EuiComboBoxOptionsListProps<T>> {
	    listRef: FixedSizeList | null;
	    static contextType: React.Context<number>;
	    context: ContextType<typeof EuiInputPopoverWidthContext>;
	    static defaultProps: {
	        'data-test-subj': string;
	        rowHeight: number;
	        isCaseSensitive: boolean;
	    };
	    componentDidUpdate(prevProps: EuiComboBoxOptionsListProps<T>): void;
	    setListRef: (ref: FixedSizeList | null) => void;
	    ListInnerElement: FixedSizeListProps['innerElementType'];
	    ListRow: ({ data, index, style }: ListChildComponentProps) => React.JSX.Element;
	    optionWidth: number | undefined;
	    setOptionWidth: (width: number) => void;
	    renderTruncatedOption: (text: string, truncationProps?: EuiComboBoxOptionsListProps<T>['truncationProps']) => string | React.JSX.Element;
	    render(): React.JSX.Element;
	}

}
declare module '@elastic/eui/src/components/combo_box/combo_box_options_list' {
	export type { EuiComboBoxOptionsListProps } from '@elastic/eui/src/components/combo_box/combo_box_options_list/combo_box_options_list';
	export { EuiComboBoxOptionsList } from '@elastic/eui/src/components/combo_box/combo_box_options_list/combo_box_options_list';
	export { EuiComboBoxTitle } from '@elastic/eui/src/components/combo_box/combo_box_options_list/combo_box_title';

}
declare module '@elastic/eui/src/components/combo_box/combo_box.styles' {
	export const euiComboBoxStyles: {
	    euiComboBox: import("@emotion/utils").SerializedStyles;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/combo_box/combo_box' {
	/**
	 * Elements within EuiComboBox which would normally be tabbable (inputs, buttons) have been removed
	 * from the tab order with tabindex={-1} so that we can control the keyboard navigation interface.
	 */
	import React, { Component, FocusEventHandler, HTMLAttributes, KeyboardEventHandler, RefCallback } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiInputPopoverProps } from '@elastic/eui/src/components/popover';
	import { EuiFormControlLayoutProps } from '@elastic/eui/src/components/form';
	import type { EuiTextTruncateProps } from '@elastic/eui/src/components/text_truncate';
	import { SortMatchesBy } from '@elastic/eui/src/components/combo_box/matching_options';
	import { EuiComboBoxInputProps } from '@elastic/eui/src/components/combo_box/combo_box_input/combo_box_input';
	import { EuiComboBoxOptionsListProps } from '@elastic/eui/src/components/combo_box/combo_box_options_list/combo_box_options_list';
	import { OptionHandler, RefInstance, EuiComboBoxOptionOption, EuiComboBoxSingleSelectionShape, EuiComboBoxOptionMatcher } from '@elastic/eui/src/components/combo_box/types'; type DrillProps<T> = Pick<EuiComboBoxOptionsListProps<T>, 'customOptionText' | 'onCreateOption' | 'options' | 'renderOption' | 'selectedOptions'>;
	export interface _EuiComboBoxProps<T> extends CommonProps, Omit<HTMLAttributes<HTMLDivElement>, 'onChange'>, DrillProps<T> {
	    'data-test-subj'?: string;
	    /**
	     * Updates the list of options asynchronously
	     */
	    async: boolean;
	    className?: string;
	    /**
	     * When `true` creates a shorter height input
	     */
	    compressed: boolean;
	    /**
	     * When `true` expands to the entire width available
	     */
	    fullWidth: boolean;
	    id?: string;
	    inputRef?: RefCallback<HTMLInputElement>;
	    /**
	     * Shows a button that quickly clears any input
	     */
	    isClearable: boolean;
	    /**
	     * Disables the input
	     */
	    isDisabled?: boolean;
	    isInvalid?: boolean;
	    /**
	     * Swaps the dropdown options for a loading spinner
	     */
	    isLoading?: boolean;
	    /**
	     * Doesn't show the suggestions list/dropdown
	     */
	    noSuggestions?: boolean;
	    onBlur?: FocusEventHandler<HTMLDivElement>;
	    /**
	     * Called every time the query in the combo box is parsed
	     */
	    onChange?: (options: Array<EuiComboBoxOptionOption<T>>) => void;
	    onFocus?: FocusEventHandler<HTMLDivElement>;
	    onKeyDown?: KeyboardEventHandler<HTMLDivElement>;
	    /**
	     * Called every time the text query in the search box is parsed
	     */
	    onSearchChange?: (searchValue: string, hasMatchingOptions?: boolean) => void;
	    /**
	     * Sets the placeholder of the input
	     */
	    placeholder?: string;
	    /**
	     * Every option must be the same height and must be explicitly set if using a custom render
	     */
	    rowHeight?: number;
	    /**
	     * When `true` only allows the user to select a single option. Set to `{ asPlainText: true }` to not render input selection as pills
	     */
	    singleSelection: boolean | EuiComboBoxSingleSelectionShape;
	    /**
	     * Display matching options by:
	     * `startsWith`: moves items that start with search value to top of the list;
	     * `none`: don't change the sort order of initial object
	     */
	    sortMatchesBy: SortMatchesBy;
	    /**
	     * Whether to match options with case sensitivity.
	     */
	    isCaseSensitive?: boolean;
	    /**
	     * Optional custom option matcher function
	     *
	     * @example
	     * const exactEqualityMatcher: EuiComboBoxOptionMatcher = ({ option, searchValue }) => {
	     *   return option.label === searchValue;
	     * }
	     */
	    optionMatcher?: EuiComboBoxOptionMatcher<T>;
	    /**
	     * Creates an input group with element(s) coming before input. It won't show if `singleSelection` is set to `false`.
	     * `string` | `ReactElement` or an array of these
	     */
	    prepend?: EuiFormControlLayoutProps['prepend'];
	    /**
	     * Creates an input group with element(s) coming after input. It won't show if `singleSelection` is set to `false`.
	     * `string` | `ReactElement` or an array of these
	     */
	    append?: EuiFormControlLayoutProps['append'];
	    /**
	     * A special character to use as a value separator. Typically a comma `,`
	     */
	    delimiter?: string;
	    /**
	     * Specifies that the input should have focus when the component loads
	     */
	    autoFocus?: boolean;
	    /**
	     * Required when rendering without a visible label from [EuiFormRow](/#/forms/form-layouts).
	     */
	    'aria-label'?: string;
	    /**
	     * Reference ID of a text element containing the visible label for the combo box when not
	     * supplied by `aria-label` or from [EuiFormRow](/#/forms/form-layouts).
	     */
	    'aria-labelledby'?: string;
	    /**
	     * By default, EuiComboBox will truncate option labels at the end of
	     * the string. You can use pass in a custom truncation configuration that
	     * accepts any [EuiTextTruncate](/#/utilities/text-truncation) prop,
	     * except for `text` and `children`.
	     *
	     * Note: when searching, custom truncation props are ignored. The highlighted search
	     * text will always take precedence.
	     */
	    truncationProps?: Partial<Omit<EuiTextTruncateProps, 'text' | 'children'>>;
	    /**
	     * Allows customizing the underlying EuiInputPopover component
	     * (except for props that control state).
	     */
	    inputPopoverProps?: Partial<Omit<EuiInputPopoverProps, 'input' | 'isOpen' | 'closePopover'>>;
	} type DefaultProps<T> = Omit<(typeof EuiComboBox)['defaultProps'], 'options' | 'selectedOptions' | 'optionMatcher'> & {
	    options: Array<EuiComboBoxOptionOption<T>>;
	    selectedOptions: Array<EuiComboBoxOptionOption<T>>;
	    optionMatcher: EuiComboBoxOptionMatcher<T>;
	};
	export type EuiComboBoxProps<T> = Omit<_EuiComboBoxProps<T>, keyof DefaultProps<T>> & Partial<DefaultProps<T>>;
	interface EuiComboBoxState<T> {
	    activeOptionIndex: number;
	    hasFocus: boolean;
	    isListOpen: boolean;
	    matchingOptions: Array<EuiComboBoxOptionOption<T>>;
	    searchValue: string;
	}
	export class EuiComboBox<T> extends Component<_EuiComboBoxProps<T>, EuiComboBoxState<T>> {
	    static defaultProps: {
	        async: boolean;
	        compressed: boolean;
	        fullWidth: boolean;
	        isClearable: boolean;
	        options: never[];
	        selectedOptions: never[];
	        singleSelection: boolean;
	        prepend: undefined;
	        append: undefined;
	        sortMatchesBy: "none";
	        optionMatcher: EuiComboBoxOptionMatcher<unknown>;
	    };
	    state: EuiComboBoxState<T>;
	    rootId: (idSuffix?: string) => string;
	    comboBoxRefInstance: RefInstance<HTMLDivElement>;
	    comboBoxRefCallback: RefCallback<HTMLDivElement>;
	    searchInputRefInstance: RefInstance<HTMLInputElement>;
	    searchInputRefCallback: RefCallback<HTMLInputElement>;
	    listRefInstance: RefInstance<HTMLDivElement>;
	    listRefCallback: RefCallback<HTMLDivElement>;
	    openList: () => void;
	    closeList: () => void;
	    incrementActiveOptionIndex: (amount: number) => void;
	    hasActiveOption: () => boolean;
	    clearActiveOption: () => void;
	    clearSearchValue: () => void;
	    addCustomOption: (isContainerBlur: boolean, searchValue: string) => void;
	    doesSearchMatchOnlyOption: () => EuiComboBoxOptionOption<T> | undefined;
	    areAllOptionsSelected: () => boolean;
	    onComboBoxFocus: FocusEventHandler<HTMLInputElement>;
	    setCustomOptions: (isContainerBlur: boolean) => void;
	    onContainerBlur: FocusEventHandler<HTMLDivElement>;
	    onKeyDown: KeyboardEventHandler<HTMLDivElement>;
	    onOptionEnterKey: OptionHandler<T>;
	    onOptionClick: OptionHandler<T>;
	    onAddOption: (addedOption: EuiComboBoxOptionOption<T>, isContainerBlur?: boolean | undefined) => void;
	    onRemoveOption: OptionHandler<T>;
	    clearSelectedOptions: () => void;
	    onComboBoxClick: () => void;
	    onOpenListClick: () => void;
	    onOptionListScroll: () => void;
	    onSearchChange: NonNullable<EuiComboBoxInputProps<T>['onChange']>;
	    static getDerivedStateFromProps<T>(nextProps: _EuiComboBoxProps<T>, prevState: EuiComboBoxState<T>): Partial<EuiComboBoxState<T>>;
	    render(): React.JSX.Element;
	}
	export {};

}
declare module '@elastic/eui/src/components/combo_box/combo_box_input' {
	export type { EuiComboBoxInputProps } from '@elastic/eui/src/components/combo_box/combo_box_input/combo_box_input';
	export { EuiComboBoxInput } from '@elastic/eui/src/components/combo_box/combo_box_input/combo_box_input';
	export type { EuiComboBoxPillProps } from '@elastic/eui/src/components/combo_box/combo_box_input/combo_box_pill';
	export { EuiComboBoxPill } from '@elastic/eui/src/components/combo_box/combo_box_input/combo_box_pill';

}
declare module '@elastic/eui/src/components/combo_box' {
	export type { EuiComboBoxProps } from '@elastic/eui/src/components/combo_box/combo_box';
	export { EuiComboBox } from '@elastic/eui/src/components/combo_box/combo_box';
	export * from '@elastic/eui/src/components/combo_box/combo_box_input';
	export * from '@elastic/eui/src/components/combo_box/combo_box_options_list';
	export type { EuiComboBoxOptionOption, EuiComboBoxSingleSelectionShape, EuiComboBoxOptionMatcher, EuiComboBoxOptionMatcherArgs, } from '@elastic/eui/src/components/combo_box/types';
	export { createPartialStringEqualityOptionMatcher } from '@elastic/eui/src/components/combo_box/matching_options';

}
declare module '@elastic/eui/src/components/timeline/timeline_item_event.styles' {
	export const euiTimelineItemEventStyles: () => {
	    euiTimelineItemEvent: import("@emotion/utils").SerializedStyles;
	    top: import("@emotion/utils").SerializedStyles;
	    center: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/timeline/timeline_item_event' {
	import { FunctionComponent, ReactNode } from 'react';
	import { EuiTimelineItemVerticalAlign } from '@elastic/eui/src/components/timeline/timeline_item';
	export interface EuiTimelineItemEventProps {
	    /**
	     * Accepts any node. But preferably `EuiPanel`
	     */
	    children: ReactNode;
	    verticalAlign?: EuiTimelineItemVerticalAlign;
	}
	export const EuiTimelineItemEvent: FunctionComponent<EuiTimelineItemEventProps>;

}
declare module '@elastic/eui/src/components/timeline/timeline_item_icon.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiTimelineItemIconStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiTimelineItemIcon: import("@emotion/utils").SerializedStyles;
	    euiTimelineItemIcon__content: import("@emotion/utils").SerializedStyles;
	    top: import("@emotion/utils").SerializedStyles;
	    center: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/timeline/timeline_item_icon' {
	import { FunctionComponent, ReactNode } from 'react';
	import { IconType } from '@elastic/eui/src/components/icon';
	import { EuiTimelineItemVerticalAlign } from '@elastic/eui/src/components/timeline/timeline_item';
	export interface EuiTimelineItemIconProps {
	    /**
	     * Any `ReactNode`, but preferably `EuiAvatar`, or a `string` as an `EuiIcon['type']`.
	     */
	    icon: ReactNode | IconType;
	    verticalAlign?: EuiTimelineItemVerticalAlign;
	    /**
	     * Specify an `aria-label` for the icon when passed as an `IconType`.
	     * If no `aria-label` is passed we assume the icon is purely decorative.
	     */
	    iconAriaLabel?: string;
	}
	export const EuiTimelineItemIcon: FunctionComponent<EuiTimelineItemIconProps>;

}
declare module '@elastic/eui/src/components/timeline/timeline_item.styles' {
	export const euiTimelineItemStyles: () => {
	    euiTimelineItem: import("@emotion/utils").SerializedStyles;
	    top: import("@emotion/utils").SerializedStyles;
	    center: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/timeline/timeline_item' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiTimelineItemEventProps } from '@elastic/eui/src/components/timeline/timeline_item_event';
	import { EuiTimelineItemIconProps } from '@elastic/eui/src/components/timeline/timeline_item_icon';
	export const VERTICAL_ALIGN: readonly ["top", "center"];
	export type EuiTimelineItemVerticalAlign = (typeof VERTICAL_ALIGN)[number];
	export interface EuiTimelineItemProps extends Omit<HTMLAttributes<HTMLElement>, 'children'>, CommonProps, Omit<EuiTimelineItemIconProps, 'verticalAlign'>, Omit<EuiTimelineItemEventProps, 'verticalAlign'> {
	    /**
	     * Vertical alignment of the event with the icon
	     */
	    verticalAlign?: EuiTimelineItemVerticalAlign;
	}
	export const EuiTimelineItem: FunctionComponent<EuiTimelineItemProps>;

}
declare module '@elastic/eui/src/components/timeline/timeline.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiTimelineStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiTimeline: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    xl: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/timeline/timeline' {
	import { HTMLAttributes, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiTimelineItemProps } from '@elastic/eui/src/components/timeline/timeline_item';
	export const GUTTER_SIZES: readonly ["m", "l", "xl"];
	export type EuiTimelineGutterSize = (typeof GUTTER_SIZES)[number];
	export interface EuiTimelineProps extends HTMLAttributes<HTMLOListElement>, CommonProps {
	    /**
	     * List of timeline items to render. See #EuiTimelineItem
	     */
	    items?: EuiTimelineItemProps[];
	    /**
	     * Sets the size of the vertical space between each timeline item
	     */
	    gutterSize?: EuiTimelineGutterSize;
	}
	export const EuiTimeline: FunctionComponent<EuiTimelineProps>;

}
declare module '@elastic/eui/src/components/timeline' {
	export type { EuiTimelineProps } from '@elastic/eui/src/components/timeline/timeline';
	export { EuiTimeline } from '@elastic/eui/src/components/timeline/timeline';
	export type { EuiTimelineItemProps, EuiTimelineItemVerticalAlign, } from '@elastic/eui/src/components/timeline/timeline_item';
	export { EuiTimelineItem } from '@elastic/eui/src/components/timeline/timeline_item';
	export { EuiTimelineItemEvent } from '@elastic/eui/src/components/timeline/timeline_item_event';
	export { EuiTimelineItemIcon } from '@elastic/eui/src/components/timeline/timeline_item_icon';

}
declare module '@elastic/eui/src/components/comment_list/comment_event.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiCommentEventStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCommentEvent: import("@emotion/utils").SerializedStyles;
	    border: import("@emotion/utils").SerializedStyles;
	};
	export const euiCommentEventHeaderStyles: (euiThemeContext: UseEuiTheme) => {
	    euiCommentEvent__header: import("@emotion/utils").SerializedStyles;
	    border: import("@emotion/utils").SerializedStyles;
	    euiCommentEvent__headerMain: import("@emotion/utils").SerializedStyles;
	    euiCommentEvent__headerData: import("@emotion/utils").SerializedStyles;
	    euiCommentEvent__headerEventIcon: import("@emotion/utils").SerializedStyles;
	    euiCommentEvent__headerUsername: import("@emotion/utils").SerializedStyles;
	    euiCommentEvent__headerEvent: import("@emotion/utils").SerializedStyles;
	    euiCommentEvent__headerActions: import("@emotion/utils").SerializedStyles;
	};
	export const euiCommentEventBodyStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiCommentEvent__body: import("@emotion/utils").SerializedStyles;
	    regular: import("@emotion/utils").SerializedStyles;
	    update: import("@emotion/utils").SerializedStyles;
	    custom: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/comment_list/comment_event' {
	import { FunctionComponent, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { IconType } from '@elastic/eui/src/components/icon';
	import { EuiPanelProps } from '@elastic/eui/src/components/panel';
	export interface EuiCommentEventProps extends CommonProps {
	    /**
	     * Author of the comment.
	     */
	    username: ReactNode;
	    /**
	     * Time of occurrence of the event. Its format is set on the consumer's side
	     */
	    timestamp?: ReactNode;
	    /**
	     * Describes the event that took place
	     */
	    event?: ReactNode;
	    /**
	     * Custom actions that the user can perform from the comment's header
	     */
	    actions?: ReactNode | ReactNode[];
	    /**
	     * Accepts any ReactNode. Renders in a panel within the comment event.
	     */
	    children?: ReactNode;
	    /**
	     * Custom icon that shows before the username.
	     */
	    eventIcon?: IconType;
	    /**
	     * Specify an `aria-label` for the `eventIcon`.
	     * If no `aria-label` is passed we assume the icon is purely decorative.
	     */
	    eventIconAriaLabel?: string;
	    /**
	     * Background color for the comment's header.
	     */
	    eventColor?: EuiPanelProps['color'];
	}
	export const EuiCommentEvent: FunctionComponent<EuiCommentEventProps>;

}
declare module '@elastic/eui/src/components/comment_list/comment_timeline' {
	import { FunctionComponent, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiAvatarProps } from '@elastic/eui/src/components/avatar';
	export interface EuiCommentTimelineProps extends CommonProps {
	    /**
	     * Main avatar that accompanies the comment. Should indicate who is the author of the comment.
	     * Any `ReactNode`, but preferably `EuiAvatar`, or a `string` as an `EuiAvatarProps['iconType']`.
	     * If no `timelineAvatar` is passed, the `userAvatar` icon will be used as the avatar.
	     */
	    timelineAvatar?: ReactNode | EuiAvatarProps['iconType'];
	    /**
	     * Specify an `aria-label` and `title` for the `timelineAvatar` when passed as an `IconType` or when nothing is passed.
	     * If no `timelineAvatarAriaLabel` is passed we assume the avatar is purely decorative.
	     */
	    timelineAvatarAriaLabel?: string;
	}
	export const EuiCommentTimeline: FunctionComponent<EuiCommentTimelineProps>;

}
declare module '@elastic/eui/src/components/comment_list/comment' {
	import { FunctionComponent } from 'react';
	import { EuiTimelineItemProps } from '@elastic/eui/src/components/timeline';
	import { EuiCommentEventProps } from '@elastic/eui/src/components/comment_list/comment_event';
	import { EuiCommentTimelineProps } from '@elastic/eui/src/components/comment_list/comment_timeline';
	export interface EuiCommentProps extends EuiCommentEventProps, EuiCommentTimelineProps, Omit<EuiTimelineItemProps, 'children' | 'icon' | 'iconAriaLabel'> {
	}
	export const EuiComment: FunctionComponent<EuiCommentProps>;

}
declare module '@elastic/eui/src/components/comment_list/comment_list' {
	import { FunctionComponent } from 'react';
	import { EuiCommentProps } from '@elastic/eui/src/components/comment_list/comment';
	import { EuiTimelineProps } from '@elastic/eui/src/components/timeline';
	export type EuiCommentListProps = Omit<EuiTimelineProps, 'items' | 'gutterSize'> & {
	    /**
	     * List of comments to render. See #EuiComment
	     */
	    comments?: EuiCommentProps[];
	    /**
	     * Sets the size of the vertical space between each comment
	     */
	    gutterSize?: EuiTimelineProps['gutterSize'];
	};
	export const EuiCommentList: FunctionComponent<EuiCommentListProps>;

}
declare module '@elastic/eui/src/components/comment_list' {
	export type { EuiCommentProps } from '@elastic/eui/src/components/comment_list/comment';
	export { EuiComment } from '@elastic/eui/src/components/comment_list/comment';
	export type { EuiCommentEventProps } from '@elastic/eui/src/components/comment_list/comment_event';
	export { EuiCommentEvent } from '@elastic/eui/src/components/comment_list/comment_event';
	export type { EuiCommentListProps } from '@elastic/eui/src/components/comment_list/comment_list';
	export { EuiCommentList } from '@elastic/eui/src/components/comment_list/comment_list';

}
declare module '@elastic/eui/src/components/datagrid/utils/data_grid_schema' {
	import { EuiDataGridColumn, EuiDataGridInMemory, EuiDataGridInMemoryValues, EuiDataGridSchema, EuiDataGridSchemaDetector } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const schemaDetectors: EuiDataGridSchemaDetector[];
	export const defaultComparator: NonNullable<EuiDataGridSchemaDetector['comparator']>;
	/**
	 * Schema detection & merging used by EuiDataGrid
	 */
	interface UseSchemaProps {
	    columns: EuiDataGridColumn[];
	    inMemory: EuiDataGridInMemory | undefined;
	    inMemoryValues: EuiDataGridInMemoryValues;
	    schemaDetectors: EuiDataGridSchemaDetector[];
	    autoDetectSchema: boolean;
	}
	export const useDefinedColumnSchemas: (columns: EuiDataGridColumn[]) => {
	    [key: string]: string;
	};
	export const useDetectSchema: ({ columns, inMemory, inMemoryValues, schemaDetectors, autoDetectSchema, }: UseSchemaProps) => EuiDataGridSchema;
	export const useMergedSchema: (props: UseSchemaProps) => {
	    [x: string]: {
	        columnType: string | null;
	    };
	};
	/**
	 * Schema utils used by columns
	 */
	export const getDetailsForSchema: (detectors: EuiDataGridSchemaDetector[], providedSchema: string | null) => EuiDataGridSchemaDetector;
	export {};

}
declare module '@elastic/eui/src/components/datagrid/utils/sorting' {
	import { DataGridSortedContextShape, EuiDataGridSorting, EuiDataGridInMemory, EuiDataGridInMemoryValues, EuiDataGridSchema, EuiDataGridSchemaDetector } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const DataGridSortedContext: import("react").Context<DataGridSortedContextShape>;
	export type useSortingArgs = {
	    sorting?: EuiDataGridSorting;
	    inMemory?: EuiDataGridInMemory;
	    inMemoryValues: EuiDataGridInMemoryValues;
	    schema: EuiDataGridSchema;
	    schemaDetectors: EuiDataGridSchemaDetector[];
	    startRow: number;
	};
	export const useSorting: ({ sorting, inMemory, inMemoryValues, schema, schemaDetectors, startRow, }: useSortingArgs) => {
	    sortedRowMap: number[];
	    getCorrectRowIndex: (visibleRowIndex: number) => number;
	};

}
declare module '@elastic/eui/src/components/datagrid/utils/row_heights' {
	import { MutableRefObject } from 'react';
	import { GridOnItemsRenderedProps } from 'react-window';
	import { EuiDataGridColumn, EuiDataGridRowHeightOption, EuiDataGridRowHeightsOptions, EuiDataGridScrollAnchorRow, ImperativeGridApi } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export type RowHeightUtilsType = RowHeightUtils | RowHeightVirtualizationUtils;
	export class RowHeightUtils {
	    getRowHeightOption(rowIndex: number, rowHeightsOptions?: EuiDataGridRowHeightsOptions): EuiDataGridRowHeightOption | undefined;
	    isRowHeightOverride(rowIndex: number, rowHeightsOptions?: EuiDataGridRowHeightsOptions): boolean;
	    getCalculatedHeight(heightOption: EuiDataGridRowHeightOption, defaultHeight: number, rowIndex?: number, rowHeightsOptions?: EuiDataGridRowHeightsOptions): number;
	    /**
	     * Height types
	     */
	    getHeightType: (option?: EuiDataGridRowHeightOption | undefined) => "auto" | "default" | "lineCount" | "numerical";
	    /**
	     * Line count utils
	     */
	    getLineCount(option?: EuiDataGridRowHeightOption): number | undefined;
	    calculateHeightForLineCount(cellRef: HTMLElement, lineCount: number): number;
	    isAutoBelowLineCount(options?: EuiDataGridRowHeightsOptions, option?: EuiDataGridRowHeightOption): boolean;
	    /**
	     * Auto height utils
	     */
	    isAutoHeight(rowIndex: number, rowHeightsOptions?: EuiDataGridRowHeightsOptions): boolean;
	    /**
	     * Heights cache utils
	     * This cache is primarily used by auto heights & secondarily used by lineCount row overrides
	     */
	    private heightsCache;
	    getRowHeight(rowIndex: number): number;
	    setRowHeight(rowIndex: number, colId: string, height: number | undefined, _visibleRowIndex: number): boolean;
	    pruneHiddenColumnHeights(visibleColumns: EuiDataGridColumn[]): boolean;
	}
	/**
	 * Row height utils with virtualization library-specific APIs
	 */
	export class RowHeightVirtualizationUtils extends RowHeightUtils {
	    private gridRef;
	    private outerGridElementRef;
	    private gridItemsRenderedRef;
	    private rerenderGridBodyRef;
	    constructor(gridRef: MutableRefObject<ImperativeGridApi | null>, outerGridElementRef: MutableRefObject<HTMLDivElement | null>, gridItemsRenderedRef: MutableRefObject<GridOnItemsRenderedProps | null>, rerenderGridBodyRef: MutableRefObject<(() => void) | null>);
	    /**
	     * Virtualization workarounds for auto height rows
	     */
	    private timerId?;
	    private lastUpdatedRow;
	    setRowHeight(rowIndex: number, colId: string, height: number | undefined, visibleRowIndex: number): boolean;
	    pruneHiddenColumnHeights(visibleColumns: EuiDataGridColumn[]): boolean;
	    resetRow(visibleRowIndex: number): void;
	    resetGrid(): void;
	    compensateForLayoutShift(rowIndex: number, verticalLayoutShift: number, anchorRow: EuiDataGridScrollAnchorRow): void;
	}
	/**
	 * Hook for instantiating RowHeightUtils, setting internal class vars,
	 * and setting up various row-height-related side effects
	 */
	export const useRowHeightUtils: ({ virtualization, rowHeightsOptions, columns, }: {
	    virtualization?: false | {
	        gridRef: MutableRefObject<ImperativeGridApi | null>;
	        outerGridElementRef: MutableRefObject<HTMLDivElement | null>;
	        gridItemsRenderedRef: MutableRefObject<GridOnItemsRenderedProps | null>;
	    } | undefined;
	    rowHeightsOptions?: EuiDataGridRowHeightsOptions | undefined;
	    columns: EuiDataGridColumn[];
	}) => RowHeightUtils;
	export const useDefaultRowHeight: ({ rowHeightsOptions, rowHeightUtils, }: {
	    rowHeightsOptions?: EuiDataGridRowHeightsOptions | undefined;
	    rowHeightUtils: RowHeightUtilsType;
	}) => {
	    defaultRowHeight: number;
	    setRowHeight: import("react").Dispatch<import("react").SetStateAction<number>>;
	    getRowHeight: (rowIndex: number) => number;
	};

}
declare module '@elastic/eui/src/components/token/token_types' {
	import { HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { IconType } from '@elastic/eui/src/components/icon';
	export const SIZES: readonly ["xs", "s", "m", "l"];
	export type TokenSize = (typeof SIZES)[number];
	export const SHAPES: readonly ["circle", "square", "rectangle"];
	export type TokenShape = (typeof SHAPES)[number];
	export const FILLS: readonly ["light", "dark", "none"];
	export type TokenFill = (typeof FILLS)[number];
	export const COLORS: readonly ["euiColorVis0", "euiColorVis1", "euiColorVis2", "euiColorVis3", "euiColorVis4", "euiColorVis5", "euiColorVis6", "euiColorVis7", "euiColorVis8", "euiColorVis9", "gray"];
	export type TokenColor = (typeof COLORS)[number];
	export interface TokenProps {
	    /**
	     * An EUI icon type
	     */
	    iconType: IconType;
	    /**
	     * For best results use one of the vis color names (or 'gray').
	     * Or supply your own HEX color. The `fill='light'` (lightened background) will always be overridden by `fill='dark'` (solid background).
	     * Default: `gray` for glyphs or one of the vis colors for prefab token types
	     */
	    color?: TokenColor | string;
	    /**
	     * Outer shape surrounding the icon
	     * Default: `circle`
	     */
	    shape?: TokenShape;
	    /**
	     * `light` for lightened color with border, `dark` for solid, or `none`
	     * Default: `light`
	     */
	    fill?: TokenFill;
	    /**
	     * Size of the token
	     */
	    size?: TokenSize;
	    /**
	     * The icon's title. Required for accessibility
	     */
	    title?: string;
	    'aria-label'?: string;
	    'aria-labelledby'?: string;
	    'aria-describedby'?: string;
	}
	export type EuiTokenProps = CommonProps & TokenProps & Omit<HTMLAttributes<HTMLSpanElement>, 'title'>;

}
declare module '@elastic/eui/src/components/token/token_map' {
	import type { TokenProps } from '@elastic/eui/src/components/token/token_types';
	export type EuiTokenMapType = 'tokenAlias' | 'tokenAnnotation' | 'tokenArray' | 'tokenBinary' | 'tokenBoolean' | 'tokenClass' | 'tokenCompletionSuggester' | 'tokenConstant' | 'tokenDate' | 'tokenDimension' | 'tokenElement' | 'tokenEnum' | 'tokenEnumMember' | 'tokenEvent' | 'tokenException' | 'tokenField' | 'tokenFile' | 'tokenFlattened' | 'tokenFunction' | 'tokenGeo' | 'tokenHistogram' | 'tokenInterface' | 'tokenIP' | 'tokenJoin' | 'tokenKey' | 'tokenKeyword' | 'tokenMethod' | 'tokenMetricCounter' | 'tokenMetricGauge' | 'tokenModule' | 'tokenNamespace' | 'tokenNested' | 'tokenNull' | 'tokenNumber' | 'tokenObject' | 'tokenOperator' | 'tokenPackage' | 'tokenParameter' | 'tokenPercolator' | 'tokenProperty' | 'tokenRange' | 'tokenRankFeature' | 'tokenRankFeatures' | 'tokenRepo' | 'tokenSearchType' | 'tokenSemanticText' | 'tokenShape' | 'tokenString' | 'tokenStruct' | 'tokenSymbol' | 'tokenTag' | 'tokenText' | 'tokenTokenCount' | 'tokenVariable' | 'tokenVectorDense' | 'tokenDenseVector' | 'tokenVectorSparse';
	/**
	 * Most of the style combinations for tokens are semi-arbitrary. However, there was an effort
	 * to use the square shape for more common token types like string and number. Reserving the
	 * circle shape for more uncommon token types so they grab attention.
	 */
	export const TOKEN_MAP: {
	    [mapType in EuiTokenMapType]: Omit<TokenProps, 'iconType'>;
	};

}
declare module '@elastic/eui/src/components/token/token.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	import type { TokenFill } from '@elastic/eui/src/components/token/token_types';
	export const euiTokenStyles: ({ euiTheme, colorMode }: UseEuiTheme, fill: TokenFill) => {
	    euiToken: import("@emotion/utils").SerializedStyles;
	    circle: import("@emotion/utils").SerializedStyles;
	    square: import("@emotion/utils").SerializedStyles;
	    rectangle: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    euiColorVis0: import("@emotion/utils").SerializedStyles;
	    euiColorVis1: import("@emotion/utils").SerializedStyles;
	    euiColorVis2: import("@emotion/utils").SerializedStyles;
	    euiColorVis3: import("@emotion/utils").SerializedStyles;
	    euiColorVis4: import("@emotion/utils").SerializedStyles;
	    euiColorVis5: import("@emotion/utils").SerializedStyles;
	    euiColorVis6: import("@emotion/utils").SerializedStyles;
	    euiColorVis7: import("@emotion/utils").SerializedStyles;
	    euiColorVis8: import("@emotion/utils").SerializedStyles;
	    euiColorVis9: import("@emotion/utils").SerializedStyles;
	    gray: import("@emotion/utils").SerializedStyles;
	    customColor: import("@emotion/utils").SerializedStyles;
	    light: import("@emotion/utils").SerializedStyles;
	    dark: import("@emotion/utils").SerializedStyles;
	    none: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/token/token' {
	import { FunctionComponent } from 'react';
	import type { EuiTokenProps } from '@elastic/eui/src/components/token/token_types';
	export const EuiToken: FunctionComponent<EuiTokenProps>;

}
declare module '@elastic/eui/src/components/token' {
	export type { EuiTokenProps } from '@elastic/eui/src/components/token/token_types';
	export { SIZES as TOKEN_SIZES, SHAPES as TOKEN_SHAPES, COLORS as TOKEN_COLORS, } from '@elastic/eui/src/components/token/token_types';
	export { EuiToken } from '@elastic/eui/src/components/token/token';

}
declare module '@elastic/eui/src/components/datagrid/data_grid_types' {
	import { ComponentType, JSXElementConstructor, ReactNode, HTMLAttributes, CSSProperties, ReactElement, AriaAttributes, MutableRefObject, Ref, Component, ComponentClass, KeyboardEventHandler } from 'react';
	import { VariableSizeGridProps, VariableSizeGrid as Grid, GridOnItemsRenderedProps } from 'react-window';
	import { EuiListGroupItemProps } from '@elastic/eui/src/components/list_group';
	import { EuiButtonEmpty, EuiButtonIcon } from '@elastic/eui/src/components/button';
	import { ExclusiveUnion, CommonProps, OneOf } from '@elastic/eui/src/components/common';
	import { RowHeightUtilsType } from '@elastic/eui/src/components/datagrid/utils/row_heights';
	import { IconType } from '@elastic/eui/src/components/icon';
	import { EuiTokenProps } from '@elastic/eui/src/components/token';
	import { EuiPopoverProps } from '@elastic/eui/src/components/popover';
	export type ImperativeGridApi = Omit<Grid, keyof Component>;
	export interface EuiDataGridToolbarProps {
	    gridWidth: number;
	    minSizeForControls?: number;
	    toolbarVisibility: boolean | EuiDataGridToolBarVisibilityOptions;
	    isFullScreen: boolean;
	    fullScreenSelector: ReactNode;
	    keyboardShortcuts: ReactNode;
	    displaySelector: ReactNode;
	    columnSelector: ReactNode;
	    columnSorting: ReactNode;
	    renderCustomToolbar?: (props: EuiDataGridCustomToolbarProps) => ReactElement;
	}
	/**
	 * Props which are available for a custom toolbar rendering
	 */
	export interface EuiDataGridCustomToolbarProps {
	    hasRoomForGridControls: boolean;
	    fullScreenControl: ReactNode;
	    keyboardShortcutsControl: ReactNode;
	    displayControl: ReactNode;
	    columnControl: ReactNode;
	    columnSortingControl: ReactNode;
	}
	export interface EuiDataGridInMemoryRendererProps {
	    inMemory: EuiDataGridInMemory;
	    columns: EuiDataGridColumn[];
	    rowCount: number;
	    renderCellValue: EuiDataGridCellProps['renderCellValue'];
	    onCellRender: (rowIndex: number, columnId: string, value: string) => void;
	}
	export interface DataGridWrapperRowsContentsShape {
	    headerRowHeight: number;
	    headerRow: ReactElement;
	    footerRow: ReactElement | null;
	}
	export interface EuiDataGridSchema {
	    [columnId: string]: {
	        columnType: string | null;
	    };
	}
	export interface SchemaTypeScore {
	    type: string;
	    score: number;
	}
	export interface EuiDataGridSchemaDetector {
	    /**
	     * The name of this data type, matches #EuiDataGridColumn / `schema`
	     */
	    type: string;
	    /**
	     * The function given the text value of a cell and returns a score of [0...1] of how well the value matches this data type
	     */
	    detector: (value: string) => number;
	    /**
	     * A custom comparator function when performing in-memory sorting on this data type, takes `(a: string, b: string, direction: 'asc' | 'desc', indexes: {aIndex: number, bIndex: number}) => -1 | 0 | 1`
	     */
	    comparator?: (a: string, b: string, direction: 'asc' | 'desc', indexes: {
	        aIndex: number;
	        bIndex: number;
	    }) => -1 | 0 | 1;
	    /**
	     * The icon used to visually represent this data type. Accepts any `EuiIcon IconType`.
	     */
	    icon: IconType;
	    /**
	     * The color associated with this data type; it's used to color the icon token
	     */
	    color?: EuiTokenProps['color'] | string;
	    /**
	     * Text for how to represent an ascending sort of this data type, e.g. 'A -> Z'
	     */
	    sortTextAsc: ReactNode;
	    /**
	     * Text for how to represent a descending sort of this data type, e.g. 'Z -> A'
	     */
	    sortTextDesc: ReactNode;
	    /**
	     * Whether columns with this schema are sortable (defaults to true). Can be overridden at the individual #EuiDataGridColumn level
	     */
	    isSortable?: boolean;
	    /**
	     * This property controls the capitalization of text
	     */
	    textTransform?: 'uppercase' | 'lowercase' | 'capitalize';
	    /**
	     * Default sort direction of columns with this schema. Can be overridden at the individual #EuiDataGridColumn level
	     */
	    defaultSortDirection?: 'asc' | 'desc';
	}
	export interface EuiDataGridHeaderRowPropsSpecificProps {
	    sorting?: EuiDataGridSorting;
	    leadingControlColumns?: EuiDataGridControlColumn[];
	    trailingControlColumns?: EuiDataGridControlColumn[];
	    columns: EuiDataGridColumn[];
	    columnWidths: EuiDataGridColumnWidths;
	    schema: EuiDataGridSchema;
	    schemaDetectors: EuiDataGridSchemaDetector[];
	    defaultColumnWidth?: number | null;
	    setColumnWidth: (columnId: string, width: number) => void;
	    visibleColCount: number;
	    setVisibleColumns: (columnId: string[]) => void;
	    switchColumnPos: (colFromId: string, colToId: string) => void;
	    gridStyles: EuiDataGridStyle;
	    canDragAndDropColumns?: boolean;
	}
	export type EuiDataGridHeaderRowProps = CommonProps & HTMLAttributes<HTMLDivElement> & EuiDataGridHeaderRowPropsSpecificProps;
	export interface EuiDataGridHeaderCellProps extends Omit<EuiDataGridHeaderRowPropsSpecificProps, 'leadingControlColumns' | 'trailingControlColumns' | 'visibleColCount'> {
	    index: number;
	    column: EuiDataGridColumn;
	    isLastColumn: boolean;
	}
	export interface EuiDataGridControlHeaderCellProps {
	    index: number;
	    isLastColumn: boolean;
	    controlColumn: EuiDataGridControlColumn;
	}
	export interface EuiDataGridHeaderCellWrapperProps {
	    children: ReactNode | ((renderFocusTrap: boolean) => ReactNode);
	    id: string;
	    index: number;
	    isLastColumn: boolean;
	    width?: number | null;
	    className?: string;
	    'aria-label'?: AriaAttributes['aria-label'];
	    hasColumnActions?: boolean;
	    isDragging?: boolean;
	    onKeyDown?: KeyboardEventHandler;
	}
	export type EuiDataGridFooterRowProps = CommonProps & HTMLAttributes<HTMLDivElement> & {
	    rowIndex: number;
	    leadingControlColumns: EuiDataGridControlColumn[];
	    trailingControlColumns: EuiDataGridControlColumn[];
	    columns: EuiDataGridColumn[];
	    schema: EuiDataGridSchema;
	    columnWidths: EuiDataGridColumnWidths;
	    defaultColumnWidth?: number | null;
	    renderCellValue: EuiDataGridCellProps['renderCellValue'];
	    renderCellPopover?: EuiDataGridCellProps['renderCellPopover'];
	    interactiveCellId: EuiDataGridCellProps['interactiveCellId'];
	    visibleRowIndex?: number;
	    visibleColCount: number;
	    gridStyles: EuiDataGridStyle;
	};
	export interface EuiDataGridVisibleRows {
	    startRow: number;
	    endRow: number;
	    visibleRowCount: number;
	}
	export interface DataGridSortedContextShape {
	    sorting?: EuiDataGridSorting;
	    sortedRowMap: number[];
	    getCorrectRowIndex: (visibleRowIndex: number) => number;
	}
	export type EuiDataGridFocusedCell = [number, number];
	export interface DataGridFocusContextShape {
	    focusedCell?: EuiDataGridFocusedCell;
	    setFocusedCell: (cell: EuiDataGridFocusedCell, forceUpdate?: boolean) => void;
	    setIsFocusedCellInView: (isFocusedCellInView: boolean) => void;
	    onFocusUpdate: (cell: EuiDataGridFocusedCell, updateFocus: Function) => () => void;
	    focusFirstVisibleInteractiveCell: () => void;
	}
	export interface DataGridCellPopoverContextShape {
	    popoverIsOpen: boolean;
	    cellLocation: {
	        rowIndex: number;
	        colIndex: number;
	    };
	    openCellPopover(args: {
	        rowIndex: number;
	        colIndex: number;
	    }): void;
	    closeCellPopover(): void;
	    setPopoverAnchor(anchor: HTMLElement): void;
	    setPopoverAnchorPosition(position: 'downLeft' | 'upLeft'): void;
	    setPopoverContent(content: ReactNode): void;
	    setCellPopoverProps: EuiDataGridCellPopoverElementProps['setCellPopoverProps'];
	}
	export type CommonGridProps = CommonProps & HTMLAttributes<HTMLDivElement> & {
	    /**
	     * An array of #EuiDataGridColumn objects. Lists the columns available and the schema and settings tied to it.
	     */
	    columns: EuiDataGridColumn[];
	    /**
	     * An array of #EuiDataGridControlColumn objects. Used to define ancillary columns on the left side of the data grid.
	     * Useful for adding items like checkboxes and buttons.
	     */
	    leadingControlColumns?: EuiDataGridControlColumn[];
	    /**
	     * An array of #EuiDataGridControlColumn objects. Used to define ancillary columns on the right side of the data grid.
	     * Useful for adding items like checkboxes and buttons.
	     */
	    trailingControlColumns?: EuiDataGridControlColumn[];
	    /**
	     * An array of #EuiDataGridColumnVisibility objects.
	     * Defines which columns are **intitially** visible in the grid and the order they are displayed.
	     * Users can still turn their visibility on/off when `toolbarVisibility.showColumnSelector = true` (which is the default).
	     */
	    columnVisibility: EuiDataGridColumnVisibility;
	    /**
	     * An array of custom #EuiDataGridSchemaDetector objects. You can inject custom schemas to the grid to define the classnames applied.
	     */
	    schemaDetectors?: EuiDataGridSchemaDetector[];
	    /**
	     * The total number of rows in the dataset (used by e.g. pagination to know how many pages to list).
	     */
	    rowCount: number;
	    /**
	     * A function called to render a cell's value. Behind the scenes it is treated as a React component
	     * allowing hooks, context, and other React concepts to be used. The function receives #EuiDataGridCellValueElementProps
	     * as its only argument.
	     */
	    renderCellValue: EuiDataGridCellProps['renderCellValue'];
	    /**
	     * An optional object of props passed to the `renderCellValue` component.
	     * This API exists to make it easier to define your `renderCellValue` function
	     * component statically, and not rerender due to other dependent state.
	     */
	    cellContext?: EuiDataGridCellProps['cellContext'];
	    /**
	     * An optional function that can be used to completely customize the rendering of cell popovers.
	     *
	     * If not specified, defaults to an `<EuiText>` wrapper around the rendered cell value and an
	     * `<EuiPopoverFooter>` around the cell actions.
	     *
	     * Behind the scenes it is treated as a React component allowing hooks, context, and other React concepts to be used.
	     * The function receives #EuiDataGridCellPopoverElementProps as its only argument.
	     *
	     */
	    renderCellPopover?: EuiDataGridCellProps['renderCellPopover'];
	    /**
	     * An optional function called to render a footer cell. If not specified, no footer row is rendered.
	     *
	     * Behind the scenes it is treated as a React component
	     * allowing hooks, context, and other React concepts to be used. The function receives #EuiDataGridCellValueElementProps
	     * as its only argument.
	     */
	    renderFooterCellValue?: EuiDataGridCellProps['renderCellValue'];
	    /**
	     * An optional function called to completely customize and control the rendering of
	     * EuiDataGrid's body and cell placement.  This can be used to, e.g. remove EuiDataGrid's
	     * virtualization library, or roll your own.
	     *
	     * This component is **only** meant as an escape hatch for extremely custom use cases.
	     *
	     * Behind the scenes, this function is treated as a React component,
	     * allowing hooks, context, and other React concepts to be used.
	     * It receives #EuiDataGridCustomBodyProps as its only argument.
	     */
	    renderCustomGridBody?: (args: EuiDataGridCustomBodyProps) => ReactNode;
	    /**
	     * An optional function called to customize placement of controls in EuiDataGrid's toolbar.
	     * This can be used to add custom buttons or reorder existing ones.
	     *
	     * Behind the scenes, this function is treated as a React component,
	     * allowing hooks, context, and other React concepts to be used.
	     * It receives #EuiDataGridCustomToolbarProps as its only argument.
	     */
	    renderCustomToolbar?: EuiDataGridToolbarProps['renderCustomToolbar'];
	    /**
	     * Defines the initial style of the grid. Accepts a partial #EuiDataGridStyle object.
	     * Settings provided may be overwritten or merged with user defined preferences if `toolbarVisibility.showDisplaySelector.allowDensity = true` (which is the default).
	     */
	    gridStyle?: EuiDataGridStyle;
	    /**
	     * Allows you to configure what features the toolbar shows.
	     *
	     * Accepts either a boolean or #EuiDataGridToolBarVisibilityOptions object.
	     * When used as a boolean, defines the display of the entire toolbar.
	     * When passed an object allows you to turn off individual controls within the toolbar as well as add additional buttons.
	     */
	    toolbarVisibility?: boolean | EuiDataGridToolBarVisibilityOptions;
	    /**
	     * A #EuiDataGridInMemory object to define the level of high order schema-detection and sorting logic to use on your data.
	     * **Try to set when possible**.
	     * If omitted, disables all enhancements and assumes content is flat strings.
	     */
	    inMemory?: EuiDataGridInMemory;
	    /**
	     * A #EuiDataGridPaginationProps object. Omit to disable pagination completely.
	     */
	    pagination?: EuiDataGridPaginationProps;
	    /**
	     * A #EuiDataGridSorting object that provides the sorted columns along with their direction. Provides a callback for when it changes.
	     * Optional, but required when inMemory is set.
	     * Omit to disable, but you'll likely want to also turn off the user sorting controls through the `toolbarVisibility` prop.
	     */
	    sorting?: EuiDataGridSorting;
	    /**
	     * A callback for when a column's size changes. Callback receives `{ columnId: string, width: number }`.
	     */
	    onColumnResize?: EuiDataGridOnColumnResizeHandler;
	    /**
	     * Defines a minimum width for the grid to show all controls in its toolbar.
	     */
	    minSizeForControls?: number;
	    /**
	     * Sets the grid's height, forcing it to overflow in a scrollable container with cell virtualization.
	     */
	    height?: CSSProperties['height'];
	    /**
	     * Sets the grid's width, forcing it to overflow in a scrollable container with cell virtualization.
	     */
	    width?: CSSProperties['width'];
	    /**
	     * Allows customizing the underlying [react-window grid](https://react-window.vercel.app/#/api/VariableSizeGrid) props.
	     */
	    virtualizationOptions?: Partial<Omit<VariableSizeGridProps, 'children' | 'itemData' | 'height' | 'width' | 'rowCount' | 'rowHeight' | 'columnCount' | 'columnWidth' | 'ref' | 'innerRef' | 'outerRef' | 'innerElementType' | 'useIsScrolling'>>;
	    /**
	     * A #EuiDataGridRowHeightsOptions object that provides row heights options.
	     * Allows configuring both default and specific heights of grid rows.
	     * Settings provided may be overwritten or merged with user defined preferences if `toolbarVisibility.showDisplaySelector.allowRowHeight = true` (which is the default).
	     */
	    rowHeightsOptions?: EuiDataGridRowHeightsOptions;
	};
	export type EuiDataGridProps = OneOf<CommonGridProps, 'aria-label' | 'aria-labelledby'>;
	export interface EuiDataGridRefProps {
	    /**
	     * Allows manually controlling the fullscreen state of the grid.
	     */
	    setIsFullScreen: (isFullScreen: boolean) => void;
	    /**
	     * Allows manually focusing the specified cell in the grid.
	     *
	     * Using this method is an accessibility requirement if your EuiDataGrid
	     * toggles a modal or flyout - focus must be restored to the grid on close
	     * to prevent keyboard or screen reader users from being stranded.
	     */
	    setFocusedCell: (cell: {
	        rowIndex: number;
	        colIndex: number;
	    }) => void;
	    /**
	     * Allows manually opening the popover of the specified cell in the grid.
	     */
	    openCellPopover: (cell: {
	        rowIndex: number;
	        colIndex: number;
	    }) => void;
	    /**
	     * Closes any currently open popovers in the data grid.
	     */
	    closeCellPopover: () => void;
	    /**
	     * Scrolls to a specified top and left offset.
	     */
	    scrollTo?: ImperativeGridApi['scrollTo'];
	    /**
	     * Scrolls to a specified rowIndex.
	     */
	    scrollToItem?: ImperativeGridApi['scrollToItem'];
	}
	export interface EuiDataGridColumnResizerProps {
	    columnId: string;
	    columnWidth: number;
	    setColumnWidth: (columnId: string, width: number) => void;
	    isLastColumn: boolean;
	}
	export interface EuiDataGridColumnResizerState {
	    initialX: number;
	    offset: number;
	}
	export interface EuiDataGridColumnSortingDraggableProps {
	    id: string;
	    direction: string;
	    index: number;
	    sorting: EuiDataGridSorting;
	    schema: EuiDataGridSchema;
	    schemaDetectors: EuiDataGridSchemaDetector[];
	    /**
	     * Value to be shown in column sorting popover.
	     */
	    display: string;
	}
	export interface EuiDataGridBodyProps {
	    leadingControlColumns: EuiDataGridControlColumn[];
	    trailingControlColumns: EuiDataGridControlColumn[];
	    columns: EuiDataGridColumn[];
	    visibleColCount: number;
	    schema: EuiDataGridSchema;
	    schemaDetectors: EuiDataGridSchemaDetector[];
	    rowCount: number;
	    visibleRows: EuiDataGridVisibleRows;
	    renderCellValue: EuiDataGridCellProps['renderCellValue'];
	    cellContext?: EuiDataGridCellProps['cellContext'];
	    renderCellPopover?: EuiDataGridCellProps['renderCellPopover'];
	    renderFooterCellValue?: EuiDataGridCellProps['renderCellValue'];
	    renderCustomGridBody?: EuiDataGridProps['renderCustomGridBody'];
	    interactiveCellId: EuiDataGridCellProps['interactiveCellId'];
	    sorting?: EuiDataGridSorting;
	    pagination?: Required<EuiDataGridPaginationProps>;
	    setVisibleColumns: EuiDataGridHeaderRowProps['setVisibleColumns'];
	    switchColumnPos: EuiDataGridHeaderRowProps['switchColumnPos'];
	    onColumnResize?: EuiDataGridOnColumnResizeHandler;
	    virtualizationOptions?: EuiDataGridProps['virtualizationOptions'];
	    rowHeightsOptions?: EuiDataGridRowHeightsOptions;
	    isFullScreen: boolean;
	    gridStyles: EuiDataGridStyle;
	    gridWidth: number;
	    gridRef: MutableRefObject<Grid | null>;
	    gridItemsRendered: MutableRefObject<GridOnItemsRenderedProps | null>;
	    wrapperRef: MutableRefObject<HTMLDivElement | null>;
	    className?: string;
	    canDragAndDropColumns?: boolean;
	}
	export interface EuiDataGridCustomBodyProps {
	    /**
	     * When taking control of data grid rendering, the underlying `EuiDataGridCell`
	     * is passed as a prop for usage. You **must** pass in a valid `colIndex`
	     * and `visibleRowIndex` to this cell component.
	     *
	     * You may also pass in any other optional cell prop overrides
	     * that `EuiDataGridCell` accepts, such as `isExpandable` or `renderCellValue`.
	     */
	    Cell: JSXElementConstructor<{
	        colIndex: number;
	        visibleRowIndex: number;
	    } & Partial<EuiDataGridCellProps>>;
	    /**
	     * The currently visible columns are passed to your data grid renderer so that your
	     * custom grid can automatically adjust to column hiding & reordering.
	     */
	    visibleColumns: EuiDataGridColumn[];
	    /**
	     * The currently visible rows are passed to your data grid renderer so that your
	     * custom grid can automatically adjust to sorting and pagination.
	     *
	     * You will need  to manually slice your data with `startRow` and `endRow` in order to simulate pagination.
	     */
	    visibleRowData: {
	        startRow: number;
	        endRow: number;
	        visibleRowCount: number;
	    };
	    /**
	     * Callback function to set custom props & attributes on the custom grid body's wrapping `div` element.
	     * It's best to wrap calls to `setCustomGridBodyProps` in a `useEffect` hook
	     */
	    setCustomGridBodyProps: (props: EuiDataGridSetCustomGridBodyProps) => void;
	    /**
	     * The width of the grid, can be used by consumer as a layout utility
	     */
	    gridWidth: number;
	    /**
	     * Header row component to render by custom renderer
	     * */
	    headerRow: React.JSX.Element;
	    /**
	     * Footer row component to render by custom renderer
	     * */
	    footerRow: React.JSX.Element | null;
	}
	export type EuiDataGridSetCustomGridBodyProps = CommonProps & HTMLAttributes<HTMLDivElement> & {
	    ref?: MutableRefObject<HTMLDivElement> | Ref<HTMLDivElement>;
	};
	/**
	 * Props shared between renderCellValue and renderCellPopover
	 */
	interface SharedRenderCellElementProps {
	    /**
	     * Index of the row being rendered, 0 represents the first row. This index always includes
	     * pagination offset, meaning the first rowIndex in a grid is `pagination.pageIndex * pagination.pageSize`
	     * so take care if you need to adjust the rowIndex to fit your data
	     */
	    rowIndex: number;
	    /**
	     * Index of the column being rendered, 0 represents the first column. This index accounts
	     * for columns that have been hidden or reordered by the user, so take care if you need
	     * to adjust the colIndex to fit your data
	     */
	    colIndex: number;
	    /**
	     * ID of the column being rendered, the value comes from the #EuiDataGridColumn `id`
	     */
	    columnId: string;
	    /**
	     * The schema type of the column being rendered
	     */
	    schema?: string | null;
	}
	export type EuiDataGridSetCellProps = CommonProps & Omit<HTMLAttributes<HTMLDivElement>, 'role' | 'tabIndex' | 'aria-rowindex'> & {
	    isExpandable?: boolean;
	};
	export interface EuiDataGridCellValueElementProps extends SharedRenderCellElementProps {
	    /**
	     * Callback function to set custom props & attributes on the cell's wrapping `div` element;
	     * it's best to wrap calls to `setCellProps` in a `useEffect` hook
	     */
	    setCellProps: (props: EuiDataGridSetCellProps) => void;
	    /**
	     * Whether or not the cell is expandable, comes from the #EuiDataGridColumn `isExpandable` which defaults to `true`
	     */
	    isExpandable: boolean;
	    /**
	     * Whether or not the cell is expanded
	     */
	    isExpanded: boolean;
	    /**
	     * When rendering the cell, `isDetails` is false; when the cell is expanded, `renderCellValue` is called again to render into the details popover and `isDetails` is true
	     */
	    isDetails: boolean;
	}
	export interface EuiDataGridCellPopoverElementProps extends SharedRenderCellElementProps {
	    /**
	     * The default `children` passed to the cell popover comes from the passed `renderCellValue` prop as a ReactElement.
	     *
	     * Allows wrapping the rendered content: `({ children }) => <div>{children}</div>` - or leave it out to render completely custom content.
	     */
	    children: ReactNode;
	    /**
	     * References the div element the cell contents have been rendered into. Primarily useful for processing the rendered text
	     */
	    cellContentsElement: HTMLDivElement;
	    /**
	     * An `EuiPopoverFooter` containing all column `cellActions` (as `EuiEmptyButton`s).
	     * Use `{cellActions}` to render the default cell action buttons, or leave it out to hide cell actions/render your own.
	     */
	    cellActions: ReactNode;
	    /**
	     * For certain columns or schemas, you may want to fall back to the standard EuiDataGrid popover display.
	     * If so, that component is provided here as a passed React function component for your usage.
	     */
	    DefaultCellPopover: JSXElementConstructor<EuiDataGridCellPopoverElementProps>;
	    /**
	     * Allows passing props to the wrapping cell expansion popover and panel.
	     * Accepts any props that `EuiPopover` accepts, except for `button` and `closePopover`.
	     */
	    setCellPopoverProps: (props: Omit<EuiPopoverProps, 'button' | 'closePopover'>) => void;
	} type CellContext = Omit<Record<string, any>, keyof EuiDataGridCellValueElementProps>; type CellPropsWithContext = CellContext & EuiDataGridCellValueElementProps;
	export type RenderCellValue = ((props: CellPropsWithContext) => ReactNode) | ComponentClass<CellPropsWithContext>;
	export interface EuiDataGridCellProps {
	    rowIndex: number;
	    visibleRowIndex: number;
	    colIndex: number;
	    column?: EuiDataGridColumn;
	    columnId: string;
	    columnType?: string | null;
	    width?: number;
	    interactiveCellId: string;
	    isExpandable: boolean;
	    className?: string;
	    popoverContext: DataGridCellPopoverContextShape;
	    renderCellValue: RenderCellValue;
	    cellContext?: CellContext;
	    renderCellPopover?: JSXElementConstructor<EuiDataGridCellPopoverElementProps> | ((props: EuiDataGridCellPopoverElementProps) => ReactNode);
	    setRowHeight?: (height: number) => void;
	    getRowHeight?: (rowIndex: number) => number;
	    style?: CSSProperties;
	    rowHeightsOptions?: EuiDataGridRowHeightsOptions;
	    rowHeightUtils?: RowHeightUtilsType;
	    rowManager?: EuiDataGridRowManager;
	    pagination?: Required<EuiDataGridPaginationProps>;
	    gridStyles: EuiDataGridStyle;
	}
	export interface EuiDataGridCellState {
	    cellProps: EuiDataGridSetCellProps;
	    isFocused: boolean;
	    isHovered: boolean;
	}
	export type EuiDataGridCellValueProps = Omit<EuiDataGridCellProps, 'width' | 'interactiveCellId' | 'popoverContext' | 'rowManager'>;
	export interface EuiDataGridControlColumn {
	    /**
	     * Used as the React `key` when rendering content
	     */
	    id: string;
	    /**
	     * Width of the column, users are unable to change this
	     */
	    width: number;
	    /**
	     * Component to render in the column header
	     */
	    headerCellRender: ComponentType;
	    /**
	     * Optional props to pass to the column header cell
	     */
	    headerCellProps?: HTMLAttributes<HTMLDivElement>;
	    /**
	     * Component to render for each row in the column
	     */
	    rowCellRender: EuiDataGridCellProps['renderCellValue'];
	    /**
	     * Component to render in the optional column footer
	     */
	    footerCellRender?: EuiDataGridCellProps['renderCellValue'];
	    /**
	     * Optional props to pass to the column footer cell
	     */
	    footerCellProps?: HTMLAttributes<HTMLDivElement>;
	}
	export const emptyControlColumns: EuiDataGridControlColumn[];
	export interface EuiDataGridColumn {
	    /**
	     * The unique identifier for this column
	     */
	    id: string;
	    /**
	     * A `ReactNode` used when rendering the column header. When providing complicated content, please make sure to utilize CSS to respect truncation as space allows. Check the docs example.
	     */
	    display?: ReactNode;
	    /**
	     * Display name as text for the column.
	     * This can be used to display a readable column name in column hiding/sorting, where `display` won't be used.
	     * This will also be used as a `title` attribute that will display on mouseover (useful if the display text is being truncated by the column width).
	     * If not passed, `id` will be shown as the column name.
	     * Passing this together with `display` is useful to ensure an accessible label is added to the column.
	     */
	    displayAsText?: string;
	    /**
	     * Optional props to pass to the column header cell
	     */
	    displayHeaderCellProps?: HTMLAttributes<HTMLDivElement>;
	    /**
	     * Initial width (in pixels) of the column
	     */
	    initialWidth?: number;
	    /**
	     * Defaults to true, always true if cellActions are defined. Defines whether or not the column's cells can be expanded with a popup onClick / keydown.
	     */
	    isExpandable?: boolean;
	    /**
	     * Whether this column's width can be changed by the user, defaults to true
	     */
	    isResizable?: boolean;
	    /**
	     * Whether this column is sortable
	     */
	    isSortable?: boolean;
	    /**
	     * Default sort direction of the column
	     */
	    defaultSortDirection?: 'asc' | 'desc';
	    /**
	     * A Schema to use for the column.
	     * Built-in values are [`boolean`, `currency`, `datetime`, `numeric`, `json`] but can be expanded by defining your own #EuiDataGrid `schemaDetectors` (for in-memory detection).
	     * In general, it is advised to pass in a value here when you are sure of the schema ahead of time, so that you don't need to rely on the automatic detection.
	     */
	    schema?: string;
	    /**
	     * Configuration of column actions. Set to false to disable or use #EuiDataGridColumnActions to configure the actions displayed in the header cell of the column.
	     */
	    actions?: false | EuiDataGridColumnActions;
	    /**
	     * Additional actions displayed as icon on hover / focus, and in the expanded view of the cell containing the value
	     */
	    cellActions?: EuiDataGridColumnCellAction[];
	    /**
	     * Configures the amount of cell action buttons immediately visible on a cell.
	     * Any cell actions above this number will only display in the cell expansion popover.
	     * Defaults to 2.
	     */
	    visibleCellActions?: number;
	}
	export type EuiDataGridColumnCellAction = ComponentType<EuiDataGridColumnCellActionProps>;
	export interface EuiDataGridColumnActions {
	    /**
	     * Show/hide/configure the action to hide a column, provided EuiListGroupItemProps are merged
	     */
	    showHide?: boolean | EuiListGroupItemProps;
	    /**
	     * Show/hide/configure the action that switches the actual column with the column to the left side, provided EuiListGroupItemProps are merged
	     */
	    showMoveLeft?: boolean | EuiListGroupItemProps;
	    /**
	     * Show/hide/configure the action that switches the actual column with the column to the right side, provided EuiListGroupItemProps are merged
	     */
	    showMoveRight?: boolean | EuiListGroupItemProps;
	    /**
	     * Show/hide/configure the action to sort ascending by the actual column, provided EuiListGroupItemProps are merged
	     */
	    showSortAsc?: boolean | EuiListGroupItemProps;
	    /**
	     * Show/hide/configure the action to sort descending by the actual column, provided EuiListGroupItemProps are merged
	     */
	    showSortDesc?: boolean | EuiListGroupItemProps;
	    /**
	     * Append additional actions
	     */
	    additional?: EuiListGroupItemProps[];
	}
	export interface EuiDataGridColumnCellActionProps {
	    /**
	     * The index of the row that contains cell's data
	     */
	    rowIndex: number;
	    /**
	     * The index of the column that contains cell's data
	     */
	    colIndex: number;
	    /**
	     * The id of the column that contains the cell's data
	     */
	    columnId: string;
	    /**
	     * React component representing the action displayed in the cell.
	     *
	     * On cell hover/focus, an EuiButtonIcon will be displayed that cannot
	     * have its size or color customized, only its icon.
	     *
	     * On cell expand, an EuiButtonEmpty will be displayed in the cell popover
	     * that can have any sizing, color, or text.
	     */
	    Component: typeof EuiButtonEmpty | typeof EuiButtonIcon;
	    /**
	     * Determines whether the cell's action is displayed expanded (in the Popover)
	     */
	    isExpanded: boolean;
	}
	export interface EuiDataGridColumnVisibility {
	    /**
	     * An array of #EuiDataGridColumn `id`s dictating the order and visibility of columns.
	     */
	    visibleColumns: string[];
	    /**
	     * A callback for when a column's visibility or order is modified by the user.
	     */
	    setVisibleColumns: (visibleColumns: string[]) => void;
	    /** Enables reordering grid columns on drag and drop via the headers cells */
	    canDragAndDropColumns?: boolean;
	}
	export interface EuiDataGridColumnWidths {
	    [key: string]: number;
	}
	export type EuiDataGridStyleFontSizes = 's' | 'm' | 'l';
	export type EuiDataGridStyleBorders = 'all' | 'horizontal' | 'none';
	export type EuiDataGridStyleHeader = 'shade' | 'underline';
	export type EuiDataGridStyleFooter = 'shade' | 'overline' | 'striped';
	export type EuiDataGridStyleRowHover = 'highlight' | 'none';
	export type EuiDataGridStyleCellPaddings = 's' | 'm' | 'l';
	export interface EuiDataGridStyle {
	    /**
	     * Size of fonts used within the row and column cells
	     * @default m
	     */
	    fontSize?: EuiDataGridStyleFontSizes;
	    /**
	     * Defines the padding with the row and column cells
	     * @default m
	     */
	    cellPadding?: EuiDataGridStyleCellPaddings;
	    /**
	     * Border used for the row and column cells
	     * @default all
	     */
	    border?: EuiDataGridStyleBorders;
	    /**
	     * If set to true, rows will alternate zebra striping for clarity
	     * @default false
	     */
	    stripes?: boolean;
	    /**
	     * Visual style for the column headers. Recommendation is to use the `underline` style in times when #EuiDataGrid `toolbarVisibility` is set to `false`.
	     * @default shade
	     */
	    header?: EuiDataGridStyleHeader;
	    /**
	     * Visual style for the column footers.
	     * @default overline
	     */
	    footer?: EuiDataGridStyleFooter;
	    /**
	     * If set to true, the footer row will be sticky
	     * @default true
	     */
	    stickyFooter?: boolean;
	    /**
	     * Will define what visual style to show on row hover
	     * @default hover
	     */
	    rowHover?: EuiDataGridStyleRowHover;
	    /**
	     * Optionally pass custom classes to highlight or customize certain rows
	     */
	    rowClasses?: {
	        [rowIndex: number]: string;
	    };
	    /**
	     * Optional callback returning the current `gridStyle` config when changes occur from user input (e.g. toolbar display controls).
	     * Can be used for, e.g. storing user `gridStyle` in a local storage object.
	     */
	    onChange?: (gridStyle: EuiDataGridStyle) => void;
	}
	export interface EuiDataGridToolBarVisibilityColumnSelectorOptions {
	    /**
	     * When `false`, removes the ability to show & hide columns through the UI
	     */
	    allowHide?: boolean;
	    /**
	     * When `false`, removes the ability to re-order columns through the UI
	     */
	    allowReorder?: boolean;
	}
	export interface EuiDataGridToolBarVisibilityDisplaySelectorOptions {
	    /**
	     * When `false`, removes the ability to change density display through the UI
	     */
	    allowDensity?: boolean;
	    /**
	     * When `false`, removes the ability to change row height display through the UI
	     */
	    allowRowHeight?: boolean;
	    /**
	     * When `false`, removes the ability to reset styles to default through the UI
	     */
	    allowResetButton?: boolean;
	    /**
	     * Allows appending additional content to the bottom of the display settings popover
	     */
	    additionalDisplaySettings?: ReactNode;
	    /**
	     * Allows completely custom rendering of the display selector popover via render prop.
	     * Passes back the default controls as arguments for optional rendering.
	     */
	    customRender?: EuiDataGridDisplaySelectorCustomRender;
	}
	export type EuiDataGridDisplaySelectorCustomRender = (args: {
	    densityControl: ReactNode;
	    rowHeightControl: ReactNode;
	    additionalDisplaySettings: ReactNode;
	    resetButton: ReactNode;
	}) => ReactNode;
	export interface EuiDataGridToolBarVisibilityOptions {
	    /**
	     * Allows the ability for the user to hide fields and sort columns, boolean or a #EuiDataGridToolBarVisibilityColumnSelectorOptions
	     * @default true
	     */
	    showColumnSelector?: boolean | EuiDataGridToolBarVisibilityColumnSelectorOptions;
	    /**
	     * Allows the ability for the user to customize display settings such as grid density and row heights.
	     * User changes will override what is provided in #EuiDataGridStyle and #EuiDataGridRowHeightsOptions
	     * @default true
	     */
	    showDisplaySelector?: boolean | EuiDataGridToolBarVisibilityDisplaySelectorOptions;
	    /**
	     * Allows the ability for the user to sort rows based upon column values
	     * @default true
	     */
	    showSortSelector?: boolean;
	    /**
	     * Displays a popover listing all keyboard controls and shortcuts for the data grid.
	     * If set to `false`, the toggle will be visually hidden, but still focusable by keyboard and screen reader users.
	     * @default true
	     */
	    showKeyboardShortcuts?: boolean;
	    /**
	     * Allows user to be able to fullscreen the data grid. If set to `false` make sure your grid fits within a large enough panel to still show the other controls.
	     * @default true
	     */
	    showFullScreenSelector?: boolean;
	    /**
	     * If passed a `ReactNode`, appends the passed custom control into the left side of the toolbar, after the column & sort controls.
	     * Or use #EuiDataGridToolBarAdditionalControlsOptions to customize the location of your control.
	     */
	    additionalControls?: ReactNode | EuiDataGridToolBarAdditionalControlsOptions;
	}
	export interface EuiDataGridToolBarAdditionalControlsOptions {
	    /**
	     * If passed a `ReactNode`, appends the passed node into the left side of the toolbar, **after** the column & sort controls.
	     * Or use #EuiDataGridToolBarAdditionalControlsLeftOptions to customize the location of your control.
	     * We recommend using `<EuiButtonEmpty size="xs" />` to match the existing controls on the left.
	     */
	    left?: ReactNode | EuiDataGridToolBarAdditionalControlsLeftOptions;
	    /**
	     * Will prepend the passed node into the right side of the toolbar, **before** the density & fullscreen controls.
	     * We recommend using `<EuiButtonIcon size="xs" />` to match the existing controls on the right.
	     */
	    right?: ReactNode;
	}
	export interface EuiDataGridToolBarAdditionalControlsLeftOptions {
	    /**
	     * Will prepend the passed node into the left side of the toolbar, **before** the column & sort controls.
	     */
	    prepend?: ReactNode;
	    /**
	     * Will append the passed node into the left side of the toolbar, **after** the column & sort controls.
	     */
	    append?: ReactNode;
	}
	export interface EuiDataGridPaginationProps {
	    /**
	     * The index of the current page, starts at 0 for the first page
	     */
	    pageIndex: number;
	    /**
	     * How many rows should initially be shown per page.
	     * Pass `0` to display the selected "Show all" option and hide the pagination.
	     *
	     * @default 10
	     */
	    pageSize?: number;
	    /**
	     * An array of page sizes the user can select from.
	     * Pass `0` as one of the options to create a "Show all" option.
	     * Pass an empty array to hide "Rows per page" select button.
	     *
	     * @default [10, 25, 50]
	     */
	    pageSizeOptions?: number[];
	    /**
	     * A callback for when the user changes the page size selection
	     */
	    onChangeItemsPerPage: (itemsPerPage: number) => void;
	    /**
	     * A callback for when the current page index changes
	     */
	    onChangePage: (pageIndex: number) => void;
	}
	export interface EuiDataGridColumnSortingConfig {
	    id: string;
	    direction: 'asc' | 'desc';
	}
	export interface EuiDataGridSorting {
	    /**
	     * A function that receives updated column sort details in response to user interactions in the toolbar controls
	     */
	    onSort: (columns: EuiDataGridColumnSortingConfig[]) => void;
	    /**
	     * An array of the column ids currently being sorted and their sort direction. The array order determines the sort order. `{ id: 'A'; direction: 'asc' }`
	     */
	    columns: EuiDataGridColumnSortingConfig[];
	}
	export interface EuiDataGridInMemory {
	    /**
	      Given the data flow Sorting->Pagination:
	      Each step can be performed by service calls or in-memory by the grid.
	      However, we cannot allow any service calls after an in-memory operation.
	      E.g. if Pagination requires a service call the grid cannot perform
	      in-memory Sorting. This means a single value representing the
	      service / in-memory boundary can be used. Thus there are four states for in-memory's level:
	      * "enhancements" - no in-memory operations, but use the available data to enhance the grid
	      * "pagination" - only pagination is performed in-memory
	      * "sorting" - sorting & pagination is performed in-memory
	   */
	    level: 'enhancements' | 'pagination' | 'sorting';
	    /**
	     * An array of column ids for the in-memory processing to skip
	     */
	    skipColumns?: string[];
	}
	export interface EuiDataGridInMemoryValues {
	    [rowIndex: string]: {
	        [columnId: string]: string;
	    };
	}
	export interface EuiDataGridOnColumnResizeData {
	    columnId: string;
	    width: number;
	}
	export type EuiDataGridOnColumnResizeHandler = (data: EuiDataGridOnColumnResizeData) => void;
	export type EuiDataGridScrollAnchorRow = 'start' | 'center' | undefined;
	export type EuiDataGridRowHeightOption = number | 'auto' | ExclusiveUnion<{
	    lineCount: number;
	}, {
	    height: number;
	}>;
	export interface EuiDataGridRowHeightsOptions {
	    /**
	     * Defines the default size for all rows. It can be line count or just height.
	     */
	    defaultHeight?: EuiDataGridRowHeightOption;
	    /**
	     * Feature flag for custom `lineCount` behavior, where `lineCount` acts like a
	     * *max* number of lines (instead of a set number of lines for all rows).
	     *
	     * This functionality is in beta and has performance implications;
	     * we do not yet fully recommend/support it for heavy production usage.
	     */
	    autoBelowLineCount?: boolean;
	    /**
	     * Defines the height for a specific row. It can be line count or just height.
	     *
	     * When using row height overrides, we strongly setting the `showDisplaySelector: allowRowHeight`
	     * toolbar control to `false` in #EuiDataGridToolBarVisibilityOptions
	     */
	    rowHeights?: Record<number, EuiDataGridRowHeightOption>;
	    /**
	     * Defines a global lineHeight style to apply to all cells
	     */
	    lineHeight?: string;
	    /**
	     * Optional callback returning the current `rowHeightsOptions` when changes occur from user input (e.g. toolbar display controls).
	     * Can be used for, e.g. storing user `rowHeightsOptions` in a local storage object.
	     */
	    onChange?: (rowHeightsOptions: EuiDataGridRowHeightsOptions) => void;
	    /**
	     * Optional indicator of the row that should be used as an anchor for vertical layout shift compensation.
	     * When set to 'start' or 'center', the topmost or middle visible row will try
	     * to compensate for changes in their top offsets by adjusting the grid's scroll
	     * position.
	     */
	    scrollAnchorRow?: EuiDataGridScrollAnchorRow;
	}
	export interface EuiDataGridRowManager {
	    getRow(args: {
	        rowIndex: number;
	        visibleRowIndex: number;
	        top: string;
	        height: number;
	    }): HTMLDivElement;
	}
	export {};

}
declare module '@elastic/eui/src/components/drag_and_drop/drag_drop_context' {
	import React, { FunctionComponent } from 'react';
	import { DragDropContextProps } from '@hello-pangea/dnd'; type EuiDraggingType = string | null;
	export interface EuiDragDropContextProps {
	    isDraggingType: EuiDraggingType;
	}
	export const EuiDragDropContextContext: React.Context<EuiDragDropContextProps>;
	export const EuiDragDropContext: FunctionComponent<DragDropContextProps>;
	export {};

}
declare module '@elastic/eui/src/components/drag_and_drop/droppable.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDroppableStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDroppable: import("@emotion/utils").SerializedStyles;
	    isDragging: import("@emotion/utils").SerializedStyles;
	    isDraggingOver: import("@emotion/utils").SerializedStyles;
	    grow: import("@emotion/utils").SerializedStyles;
	    noGrow: import("@emotion/utils").SerializedStyles;
	    spacing: {
	        none: null;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	        l: import("@emotion/utils").SerializedStyles;
	    };
	};
	export const sharedSpacingPadding: ({ euiTheme }: UseEuiTheme) => {
	    none: null;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/drag_and_drop/droppable' {
	import React, { CSSProperties, FunctionComponent, ReactElement } from 'react';
	import { DroppableProps } from '@hello-pangea/dnd';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const SPACINGS: readonly ["none", "s", "m", "l"];
	export interface EuiDroppableProps extends CommonProps, Omit<DroppableProps, 'children'> {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: ReactElement | ReactElement[] | DroppableProps['children'];
	    className?: string;
	    /**
	     * Makes its items immutable. Dragging creates cloned items that can be dropped elsewhere.
	     */
	    cloneDraggables?: boolean;
	    style?: CSSProperties;
	    /**
	     * Adds padding to the droppable area
	     */
	    spacing?: (typeof SPACINGS)[number];
	    /**
	     * Adds an EuiPanel style to the droppable area
	     */
	    withPanel?: boolean;
	    /**
	     * Allow the panel to flex-grow?
	     */
	    grow?: boolean;
	}
	export const EuiDroppableContext: React.Context<{
	    cloneItems: boolean;
	}>;
	export const EuiDroppable: FunctionComponent<EuiDroppableProps>;

}
declare module '@elastic/eui/src/components/drag_and_drop/draggable.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDraggableStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDraggable: import("@emotion/utils").SerializedStyles;
	    isDragging: import("@emotion/utils").SerializedStyles;
	    hasClone: import("@emotion/utils").SerializedStyles;
	    isRemovable: import("@emotion/utils").SerializedStyles;
	    spacing: {
	        none: null;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	        l: import("@emotion/utils").SerializedStyles;
	    };
	};
	export const euiDraggableItemStyles: {
	    euiDraggable__item: import("@emotion/utils").SerializedStyles;
	    disabled: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/drag_and_drop/draggable' {
	import { CSSProperties, FunctionComponent, ReactElement } from 'react';
	import { DraggableProps } from '@hello-pangea/dnd';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { SPACINGS } from '@elastic/eui/src/components/drag_and_drop/droppable';
	export interface EuiDraggableProps extends CommonProps, Omit<DraggableProps, 'children'> {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: ReactElement | DraggableProps['children'];
	    className?: string;
	    /**
	     * Whether the `children` will provide and set up its own drag handle.
	     * The `custom` value additionally removes the `role` from the draggable container.
	     * Use this if the `children` element is focusable and should keep its
	     * semantic role for accessibility purposes.
	     */
	    customDragHandle?: boolean | 'custom';
	    /**
	     * Whether the container has interactive children and should have `role="group"` instead of `"button"`.
	     * Setting this flag ensures your drag & drop container is keyboard and screen reader accessible.
	     */
	    hasInteractiveChildren?: boolean;
	    /**
	     * Whether the item is currently in a position to be removed
	     */
	    isRemovable?: boolean;
	    /**
	     * Whether the currently dragged item is cloned into a portal in the body. This settings will
	     * ensure that drag & drop still works as expected within stacking contexts (e.g. within `EuiFlyout`,
	     * `EuiModal` and `EuiPopover`).
	     *
	     * Make sure to apply styles directly to the Draggable content as relative styling from an outside
	     * scope might not be applied when the content is placed in a portal as the DOM structure changes.
	     */
	    usePortal?: boolean;
	    /**
	     * Adds padding to the draggable item
	     */
	    spacing?: (typeof SPACINGS)[number];
	    style?: CSSProperties;
	}
	export const EuiDraggable: FunctionComponent<EuiDraggableProps>;

}
declare module '@elastic/eui/src/components/drag_and_drop/services' {
	import { DraggableLocation } from '@hello-pangea/dnd';
	interface DropResult {
	    [droppableId: string]: any[];
	}
	export const euiDragDropReorder: <T extends any[]>(list: T, startIndex: number, endIndex: number) => T;
	export const euiDragDropMove: (sourceList: any[], destinationList: any[], dropResultSource: DraggableLocation, dropResultDestination: DraggableLocation) => DropResult;
	export const euiDragDropCopy: (sourceList: any[], destinationList: any[], dropResultSource: DraggableLocation, dropResultDestination: DraggableLocation, idModification: {
	    property: string | number;
	    modifier: () => string | number;
	}) => DropResult;
	export {};

}
declare module '@elastic/eui/src/components/drag_and_drop' {
	export type { EuiDragDropContextProps } from '@elastic/eui/src/components/drag_and_drop/drag_drop_context';
	export { EuiDragDropContext } from '@elastic/eui/src/components/drag_and_drop/drag_drop_context';
	export type { EuiDraggableProps } from '@elastic/eui/src/components/drag_and_drop/draggable';
	export { EuiDraggable } from '@elastic/eui/src/components/drag_and_drop/draggable';
	export type { EuiDroppableProps } from '@elastic/eui/src/components/drag_and_drop/droppable';
	export { EuiDroppable } from '@elastic/eui/src/components/drag_and_drop/droppable';
	export { euiDragDropCopy, euiDragDropMove, euiDragDropReorder, } from '@elastic/eui/src/components/drag_and_drop/services';
	export type { DraggableLocation, DraggableProps, DraggableProvidedDragHandleProps, DragDropContextProps, DragStart, DroppableProps, DropResult, ResponderProvided, } from '@hello-pangea/dnd';

}
declare module '@elastic/eui/src/components/datagrid/utils/focus' {
	import { HTMLAttributes, KeyboardEvent } from 'react';
	import { DataGridFocusContextShape, EuiDataGridFocusedCell, EuiDataGridProps } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const DataGridFocusContext: import("react").Context<DataGridFocusContextShape>; type FocusProps = Pick<HTMLAttributes<HTMLDivElement>, 'tabIndex' | 'onKeyUp'>;
	/**
	 * Main focus context and overarching focus state management
	 */
	export const useFocus: () => DataGridFocusContextShape & {
	    focusProps: FocusProps;
	};
	export const notifyCellOfFocusState: (cellsUpdateFocus: Map<string, Function>, cell: EuiDataGridFocusedCell, isFocused: boolean) => void;
	/**
	 * Keydown handler for connecting focus state with keyboard navigation
	 */
	export const createKeyDownHandler: ({ gridElement, visibleColCount, visibleRowCount, visibleRowStartIndex, rowCount, pagination, hasFooter, focusContext, }: {
	    gridElement: HTMLDivElement | null;
	    visibleColCount: number;
	    visibleRowCount: number;
	    visibleRowStartIndex: number;
	    rowCount: EuiDataGridProps['rowCount'];
	    pagination: Required<EuiDataGridProps['pagination']>;
	    hasFooter: boolean;
	    focusContext: DataGridFocusContextShape;
	}) => (event: KeyboardEvent<HTMLDivElement>) => void;
	/**
	 * Mutation observer for the grid body, which exists to pick up DOM changes
	 * in cells and remove interactive elements from the page's tab index, as
	 * we want to move between cells via arrow keys instead of tabbing.
	 */
	export const preventTabbing: (records: MutationRecord[]) => void;
	export const getParentCellContent: (_element: Node | HTMLElement) => HTMLElement | null;
	export {};

}
declare module '@elastic/eui/src/components/datagrid/data_grid.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridVariables: (euiThemeContext: UseEuiTheme) => {
	    cellPadding: {
	        s: string;
	        m: string;
	        l: string;
	    };
	    lineHeight: {
	        s: import("csstype").Property.LineHeight<string | number> | undefined;
	        m: import("csstype").Property.LineHeight<string | number> | undefined;
	    };
	    fontSize: {
	        s: import("csstype").Property.FontSize<string | number> | undefined;
	        m: import("csstype").Property.FontSize<string | number> | undefined;
	    };
	    levels: {
	        cellPopover: number;
	        readonly stickyHeader: number;
	    };
	};
	export const euiDataGridStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDataGrid: import("@emotion/utils").SerializedStyles;
	    cellPadding: {
	        cellPadding: (size: 's' | 'm' | 'l') => import("@emotion/utils").SerializedStyles;
	        readonly s: import("@emotion/utils").SerializedStyles;
	        readonly m: import("@emotion/utils").SerializedStyles;
	        readonly l: import("@emotion/utils").SerializedStyles;
	    };
	    fontSize: {
	        fontSize: (size: 's' | 'm') => import("@emotion/utils").SerializedStyles;
	        readonly s: import("@emotion/utils").SerializedStyles;
	        readonly m: import("@emotion/utils").SerializedStyles;
	        readonly l: import("@emotion/utils").SerializedStyles;
	    };
	    borders: {
	        none: null;
	        horizontal: import("@emotion/utils").SerializedStyles;
	        all: import("@emotion/utils").SerializedStyles;
	    };
	    euiDataGrid__content: import("@emotion/utils").SerializedStyles;
	    euiDataGrid__focusWrap: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/body/header/draggable_columns.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridDraggableHeaderStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiDataGridHeaderDroppable: import("@emotion/utils").SerializedStyles;
	    euiDataGridHeaderCellDraggableWrapper: import("@emotion/utils").SerializedStyles;
	    euiDataGridHeaderCellDraggable: import("@emotion/utils").SerializedStyles;
	    isKeyboardDragging: import("@emotion/utils").SerializedStyles;
	    underline: import("@emotion/utils").SerializedStyles;
	    shade: import("@emotion/utils").SerializedStyles;
	    noLeadingBorder: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/body/header/draggable_columns' {
	import { CSSProperties, FunctionComponent, ComponentProps, ReactElement, ReactNode } from 'react';
	import { DraggableProvidedDragHandleProps } from '@hello-pangea/dnd';
	import { EuiDroppableProps } from '@elastic/eui/src/components/drag_and_drop';
	import { EuiDataGridHeaderRowProps, EuiDataGridStyle } from '@elastic/eui/src/components/datagrid/data_grid_types';
	/**
	 * Parent context + EuiDroppable wrapper
	 */
	export const DroppableColumns: FunctionComponent<Pick<EuiDataGridHeaderRowProps, 'columns' | 'switchColumnPos'> & {
	    indexOffset: number;
	    children: EuiDroppableProps['children'];
	}>;
	/**
	 * Individual EuiDraggable columns
	 */
	export const DraggableColumn: FunctionComponent<{
	    id: string;
	    index: number;
	    gridStyles: EuiDataGridStyle;
	    columnResizer?: ReactNode;
	    actionsPopoverToggle?: HTMLButtonElement | null;
	    children: (dragProps?: Partial<DraggableProvidedDragHandleProps> & {
	        'data-column-moving'?: boolean;
	    }) => ReactElement;
	}>; type CanDragAndDropColumns = {
	    canDragAndDropColumns: boolean;
	};
	export const ConditionalDroppableColumns: FunctionComponent<ComponentProps<typeof DroppableColumns> & CanDragAndDropColumns>;
	export const ConditionalDraggableColumn: FunctionComponent<ComponentProps<typeof DraggableColumn> & CanDragAndDropColumns>;
	/**
	 * Creates an invisible overlay that prevents hover interactions/transitions
	 * on other elements that the dragged element is dragged over, and also maintains
	 * the intended drag cursor over any location.
	 *
	 * TODO: If this is useful elsewhere, consider moving it to `src/services`
	 */
	export const DragOverlay: FunctionComponent<{
	    isDragging?: boolean;
	    cursor?: CSSProperties['cursor'];
	    zIndex?: CSSProperties['zIndex'];
	}>;
	export {};

}
declare module '@elastic/eui/src/utils/prop_types/is' {
	export const is: <T>(expectedValue: any) => {
	    (props: T, propName: keyof T, componentName: string): Error | null;
	    isRequired(props: T, propName: keyof T, componentName: string): Error | null;
	};

}
declare module '@elastic/eui/src/utils/prop_types/with_required_prop' {
	/**
	 * PropType validation that, if the property is present,
	 * validates against a proptype and verifies that another property exists
	 *
	 * example:
	 * ExampleComponent.propTypes = {
	 *   items: PropTypes.array,
	 *   itemId: withRequiredProp(PropTypes.string, 'items', 'itemId is required to extract the ID from an item')
	 * }
	 *
	 * this validator warns if ExampleComponent is passed an `items` prop but not `itemId`
	 */
	export const withRequiredProp: (proptype: any, requiredPropName: string, messageDescription?: string | undefined) => (...args: any[]) => any;

}
declare module '@elastic/eui/src/utils/prop_types' {
	export const EuiPropTypes: {
	    is: <T>(expectedValue: any) => {
	        (props: T, propName: keyof T, componentName: string): Error | null;
	        isRequired(props: T, propName: keyof T, componentName: string): Error | null;
	    };
	    withRequiredProp: (proptype: any, requiredPropName: string, messageDescription?: string | undefined) => (...args: any[]) => any;
	};

}
declare module '@elastic/eui/src/utils/is_jest' {
	export const IS_JEST_ENVIRONMENT: boolean;

}
declare module '@elastic/eui/src/utils/type_guards' {
	export const isDOMNode: (el: any) => el is Node;

}
declare module '@elastic/eui/src/utils' {
	export * from '@elastic/eui/src/utils/prop_types';
	export * from '@elastic/eui/src/utils/is_jest';
	export * from '@elastic/eui/src/utils/type_guards';

}
declare module '@elastic/eui/src/components/datagrid/body/cell/focus_utils' {
	import { PropsWithChildren, FunctionComponent } from 'react';
	import { FocusableElement } from 'tabbable';
	/**
	 * This internal utility component is used by all cells, both header and body/footer cells.
	 * It always handles:
	 *   1. Removing any interactive children from keyboard tab order on cell mount
	 *   2. Listening for focus on any interactive children and updating the cell focus context
	 *
	 * It should *only* render focus traps for:
	 *   1. Header cells that are `actions: false` but still have interactive children
	 *   2. Body cells that are `isExpandable: false` but still have interactive children
	 */
	export const HandleInteractiveChildren: FunctionComponent<PropsWithChildren & {
	    cellEl?: HTMLElement | null;
	    updateCellFocusContext: Function;
	    renderFocusTrap?: boolean;
	    onInteractiveChildrenFound?: (interactiveChildren: FocusableElement[]) => void;
	}>;
	/**
	 * Cells with interactive children but no cell popover expansion should render a
	 * focus trap that can be entered with the Enter key, which cycles keyboard tabs
	 * through the cell contents only, and exited with the Escape key
	 */
	export const FocusTrappedChildren: FunctionComponent<PropsWithChildren & {
	    cellEl: HTMLElement;
	}>;

}
declare module '@elastic/eui/src/components/datagrid/body/cell/data_grid_cell.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridCellOutlineStyles: ({ euiTheme }: UseEuiTheme) => {
	    borderRadius: string;
	    focusColor: string;
	    focusStyles: string;
	    hoverColor: string;
	    hoverStyles: string;
	};
	export const euiDataGridCellOutlineSelectors: (parentSelector?: string) => {
	    outline: {
	        show: string;
	        hover: string;
	        focusTrapped: string;
	    };
	    actions: {
	        hoverZone: string;
	        hoverColor: string;
	        showAnimation: string;
	        hoverAnimation: string;
	    };
	    header: {
	        focus: string;
	        focusTrapped: string;
	        showActions: string;
	        hideActions: string;
	    };
	};
	export const euiDataGridRowCellStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDataGridRowCell: import("@emotion/utils").SerializedStyles;
	    content: {
	        euiDataGridRowCell__content: import("@emotion/utils").SerializedStyles;
	        autoHeight: import("@emotion/utils").SerializedStyles;
	        defaultHeight: import("@emotion/utils").SerializedStyles;
	        controlColumn: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/datagrid/body/header/data_grid_header_cell_wrapper.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	/**
	 * Styles that apply to both control and non-control columns
	 */
	export const euiDataGridHeaderCellWrapperStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDataGridHeaderCell: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/body/header/data_grid_header_cell_wrapper' {
	import { FunctionComponent } from 'react';
	import { EuiDataGridHeaderCellWrapperProps } from '@elastic/eui/src/components/datagrid/data_grid_types';
	/**
	 * This is a wrapper that handles repeated concerns between control &
	 * standard header cells. Most of its shared logic is around focus state/UX,
	 * but it also DRY's out certain class/data-test-subj/style attributes
	 */
	export const EuiDataGridHeaderCellWrapper: FunctionComponent<EuiDataGridHeaderCellWrapperProps>;

}
declare module '@elastic/eui/src/components/datagrid/body/header/data_grid_control_header_cell' {
	import { FunctionComponent } from 'react';
	import { EuiDataGridControlHeaderCellProps } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const EuiDataGridControlHeaderCell: FunctionComponent<EuiDataGridControlHeaderCellProps>;

}
declare module '@elastic/eui/src/components/datagrid/controls/column_sorting.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridColumnSortingStyles: (euiThemeContext: UseEuiTheme) => {
	    /**
	     * Sorted fields
	     */
	    euiDataGridColumnSorting: import("@emotion/utils").SerializedStyles;
	    euiDataGridColumnSorting__item: import("@emotion/utils").SerializedStyles;
	    euiDataGridColumnSorting__name: import("@emotion/utils").SerializedStyles;
	    euiDataGridColumnSorting__order: import("@emotion/utils").SerializedStyles;
	    euiDataGridColumnSorting__dragHandle: import("@emotion/utils").SerializedStyles;
	    /**
	     * 'Pick fields to sort by' popover
	     */
	    euiDataGridColumnSorting__fieldList: import("@emotion/utils").SerializedStyles;
	    euiDataGridColumnSorting__field: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/controls/column_sorting_draggable' {
	import React, { FunctionComponent } from 'react';
	import { EuiDataGridColumnSortingDraggableProps } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const defaultSortAscLabel: React.JSX.Element;
	export const defaultSortDescLabel: React.JSX.Element;
	export const EuiDataGridColumnSortingDraggable: FunctionComponent<EuiDataGridColumnSortingDraggableProps>;

}
declare module '@elastic/eui/src/components/datagrid/body/header/data_grid_header_cell.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	/**
	 * Styles only applied to data header cell content, not control header cells
	 */
	export const euiDataGridHeaderCellStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDataGridHeaderCell__content: import("@emotion/utils").SerializedStyles;
	    right: import("@emotion/utils").SerializedStyles;
	    euiDataGridHeaderCell__popover: import("@emotion/utils").SerializedStyles;
	    euiDataGridHeaderCell__actions: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/body/header/column_actions' {
	import React, { Ref, KeyboardEventHandler, FunctionComponent } from 'react';
	import { EuiListGroupItemProps } from '@elastic/eui/src/components/list_group';
	import { EuiDataGridHeaderCellProps, EuiDataGridColumn, EuiDataGridColumnActions, EuiDataGridSchema, EuiDataGridSchemaDetector, EuiDataGridSorting, DataGridFocusContextShape } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const useHasColumnActions: (columnActions: EuiDataGridColumn['actions']) => boolean;
	export type PropsFromColumnActions = {
	    className?: string;
	    onKeyDown?: KeyboardEventHandler;
	    'data-column-moving'?: boolean;
	};
	export const ColumnActions: FunctionComponent<Pick<EuiDataGridHeaderCellProps, 'index' | 'column' | 'columns' | 'schema' | 'schemaDetectors' | 'setVisibleColumns' | 'switchColumnPos' | 'sorting'> & {
	    id: string;
	    title: string;
	    hasFocusTrap: boolean;
	    setPropsFromColumnActions: (props: PropsFromColumnActions) => void;
	    actionsButtonRef: Ref<HTMLButtonElement>;
	}>;
	/**
	 * Add keyboard arrow navigation to the cell actions popover
	 * to match the UX of the rest of EuiDataGrid
	 */
	export const usePopoverArrowNavigation: () => {
	    panelRef: (ref: HTMLElement | null) => void;
	    panelProps: {
	        onKeyDown: (e: React.KeyboardEvent) => void;
	    };
	    popoverScreenReaderText: React.JSX.Element;
	};
	/**
	 * Logic for returning an array of actions/items to pass to EuiListGroup
	 */
	interface GetColumnActions {
	    column: EuiDataGridColumn;
	    columns: EuiDataGridColumn[];
	    schema: EuiDataGridSchema;
	    schemaDetectors: EuiDataGridSchemaDetector[];
	    setVisibleColumns: (columnId: string[]) => void;
	    focusFirstVisibleInteractiveCell: DataGridFocusContextShape['focusFirstVisibleInteractiveCell'];
	    setIsPopoverOpen: (value: boolean) => void;
	    sorting: EuiDataGridSorting | undefined;
	    switchColumnPos: (colFromId: string, colToId: string) => void;
	    setIsColumnMoving: (value: boolean) => void;
	    setFocusedCell: DataGridFocusContextShape['setFocusedCell'];
	    columnFocusIndex: number;
	}
	export const getColumnActions: ({ column, columns, schema, schemaDetectors, setVisibleColumns, focusFirstVisibleInteractiveCell, setIsPopoverOpen, sorting, switchColumnPos, setIsColumnMoving, setFocusedCell, columnFocusIndex, }: GetColumnActions) => EuiListGroupItemProps[]; type HideColumnAction = Pick<GetColumnActions, 'column' | 'columns' | 'setVisibleColumns' | 'focusFirstVisibleInteractiveCell'>;
	export const getHideColumnAction: ({ column, columns, setVisibleColumns, focusFirstVisibleInteractiveCell, }: HideColumnAction) => EuiListGroupItemProps[]; type SortColumnActions = Pick<GetColumnActions, 'column' | 'sorting' | 'schema' | 'schemaDetectors'>;
	export const getSortColumnActions: ({ column, sorting, schema, schemaDetectors, }: SortColumnActions) => EuiListGroupItemProps[];
	/**
	 * Column action utility helpers - mostly syntactical sugar for adding an extra
	 * actions !== false checks, which we make an early return for in the main fn,
	 * but that the individual utils don't know about and Typescript complains about
	 */
	export const isColumnActionEnabled: (actionKey: keyof EuiDataGridColumnActions, actions: EuiDataGridColumn['actions']) => boolean;
	export const getColumnActionConfig: (action: EuiListGroupItemProps, actionKey: keyof EuiDataGridColumnActions, actions: EuiDataGridColumn['actions']) => EuiListGroupItemProps;
	export {};

}
declare module '@elastic/eui/src/components/datagrid/body/header/column_sorting' {
	import React from 'react';
	import { EuiDataGridSorting } from '@elastic/eui/src/components/datagrid/data_grid_types';
	/**
	 * Column sorting utility helpers
	 */
	export const useColumnSorting: ({ sorting, id, hasColumnActions, }: {
	    sorting?: EuiDataGridSorting | undefined;
	    id: string;
	    hasColumnActions: boolean;
	}) => {
	    sortingArrow: React.JSX.Element | null;
	    ariaSort: "ascending" | "descending" | undefined;
	    sortingAriaId: string;
	    sortingScreenReaderText: React.JSX.Element | null;
	};

}
declare module '@elastic/eui/src/components/datagrid/body/header/column_resizer.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridColumnResizerStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDataGridColumnResizer: import("@emotion/utils").SerializedStyles;
	    isLastColumn: import("@emotion/utils").SerializedStyles;
	    isDragging: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/body/header/column_resizer' {
	import React, { Component } from 'react';
	import { EuiDataGridColumnResizerProps, EuiDataGridColumnResizerState } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export class EuiDataGridColumnResizer extends Component<EuiDataGridColumnResizerProps, EuiDataGridColumnResizerState> {
	    state: {
	        initialX: number;
	        offset: number;
	    };
	    onMouseDown: (e: React.MouseEvent<HTMLDivElement>) => void;
	    onMouseUp: () => void;
	    onMouseMove: (e: {
	        pageX: number;
	    }) => void;
	    render(): React.JSX.Element;
	}

}
declare module '@elastic/eui/src/components/datagrid/body/header/data_grid_header_cell' {
	import { FunctionComponent } from 'react';
	import { EuiDataGridHeaderCellProps } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const EuiDataGridHeaderCell: FunctionComponent<EuiDataGridHeaderCellProps>;

}
declare module '@elastic/eui/src/components/datagrid/body/header/data_grid_header_row.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridHeaderStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDataGridHeader: import("@emotion/utils").SerializedStyles;
	    underline: import("@emotion/utils").SerializedStyles;
	    shade: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/body/header/data_grid_header_row' {
	import React from 'react'; const EuiDataGridHeaderRow: React.MemoExoticComponent<React.ForwardRefExoticComponent<import ("@elastic/eui/src/components").CommonProps & React.HTMLAttributes<HTMLDivElement> & import ("@elastic/eui/src/components/datagrid/data_grid_types").EuiDataGridHeaderRowPropsSpecificProps & React.RefAttributes<HTMLDivElement>>>;
	export { EuiDataGridHeaderRow };

}
declare module '@elastic/eui/src/components/datagrid/body/header/use_data_grid_header' {
	import React from 'react';
	import { EuiDataGridHeaderRowProps } from '@elastic/eui/src/components/datagrid/data_grid_types';
	/**
	 * DRY out setting up the grid header and its refs & observers
	 */
	export const useDataGridHeader: (props: EuiDataGridHeaderRowProps) => {
	    headerRow: React.JSX.Element;
	    headerRowHeight: number;
	};

}
declare module '@elastic/eui/src/components/datagrid/body/header' {
	export { EuiDataGridHeaderRow } from '@elastic/eui/src/components/datagrid/body/header/data_grid_header_row';
	export { useDataGridHeader } from '@elastic/eui/src/components/datagrid/body/header/use_data_grid_header';

}
declare module '@elastic/eui/src/components/datagrid/body/cell/data_grid_cell_actions.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridCellActionsStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDataGridRowCell__actionsWrapper: import("@emotion/utils").SerializedStyles;
	    euiDataGridRowCell__actions: import("@emotion/utils").SerializedStyles;
	    euiDataGridRowCell__actionButtonIcon: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/body/cell/data_grid_cell_actions' {
	import React, { Ref } from 'react';
	import { EuiDataGridColumn } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const EuiDataGridCellActions: ({ onExpandClick, popoverAnchorRef, column, rowIndex, colIndex, }: {
	    onExpandClick: () => void;
	    popoverAnchorRef: Ref<HTMLDivElement>;
	    column?: EuiDataGridColumn | undefined;
	    rowIndex: number;
	    colIndex: number;
	}) => React.JSX.Element;
	export const EuiDataGridCellPopoverActions: ({ rowIndex, colIndex, column, }: {
	    column?: EuiDataGridColumn | undefined;
	    colIndex: number;
	    rowIndex: number;
	}) => React.JSX.Element;

}
declare module '@elastic/eui/src/components/datagrid/body/cell/data_grid_cell_popover.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridCellPopoverStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDataGridRowCell__popover: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/body/cell/data_grid_cell_popover' {
	import React, { ReactNode } from 'react';
	import { DataGridCellPopoverContextShape, EuiDataGridCellPopoverElementProps } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const DataGridCellPopoverContext: React.Context<DataGridCellPopoverContextShape>;
	export const useCellPopover: () => {
	    cellPopoverContext: DataGridCellPopoverContextShape;
	    cellPopover: ReactNode;
	};
	export const DefaultCellPopover: ({ schema, cellActions, children, cellContentsElement, }: EuiDataGridCellPopoverElementProps) => React.JSX.Element;
	export const JsonPopoverContent: ({ cellText }: {
	    cellText: string;
	}) => React.JSX.Element;

}
declare module '@elastic/eui/src/components/datagrid/body/cell/data_grid_cell' {
	import React, { Component, ContextType, KeyboardEvent } from 'react';
	import { DataGridFocusContext } from '@elastic/eui/src/components/datagrid/utils/focus';
	import { EuiDataGridCellProps, EuiDataGridCellState, EuiDataGridSetCellProps } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export class EuiDataGridCell extends Component<EuiDataGridCellProps, EuiDataGridCellState> {
	    cellRef: React.MutableRefObject<HTMLDivElement | null>;
	    contentObserver: any;
	    popoverAnchorRef: React.MutableRefObject<HTMLDivElement | null>;
	    cellContentsRef: HTMLDivElement | null;
	    state: EuiDataGridCellState;
	    unsubscribeCell?: Function;
	    style: null;
	    static contextType: React.Context<import ("@elastic/eui/src/components/datagrid/data_grid_types").DataGridFocusContextShape>;
	    context: ContextType<typeof DataGridFocusContext>;
	    updateCellFocusContext: () => void;
	    takeFocus: (preventScroll: boolean) => void;
	    recalculateAutoHeight: () => void;
	    recalculateLineHeight: () => void;
	    componentDidMount(): void;
	    isFocusedCell: () => boolean;
	    onFocusUpdate: (isFocused: boolean, preventScroll?: boolean) => void;
	    componentWillUnmount(): void;
	    componentDidUpdate(prevProps: EuiDataGridCellProps): void;
	    shouldComponentUpdate(nextProps: EuiDataGridCellProps, nextState: EuiDataGridCellState): boolean;
	    setCellProps: (cellProps: EuiDataGridSetCellProps) => void;
	    setCellContentsRef: (ref: HTMLDivElement | null) => void;
	    isExpandable: () => boolean;
	    isPopoverOpen: () => boolean;
	    handleCellPopover: () => void;
	    handleCellKeyDown: (event: KeyboardEvent<HTMLDivElement>) => void;
	    handleCellExpansionClick: () => void;
	    onMouseEnter: () => void;
	    onMouseLeave: () => void;
	    render(): React.JSX.Element;
	}

}
declare module '@elastic/eui/src/components/datagrid/body/cell/data_grid_cell_wrapper' {
	import { FunctionComponent } from 'react';
	import { EuiDataGridCellProps, EuiDataGridBodyProps, EuiDataGridHeaderRowProps } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export type CellProps = Pick<EuiDataGridCellProps, 'colIndex' | 'visibleRowIndex' | 'style' | 'renderCellValue' | 'cellContext' | 'renderCellPopover' | 'interactiveCellId' | 'gridStyles' | 'rowHeightsOptions' | 'rowHeightUtils' | 'rowManager' | 'setRowHeight' | 'column'> & Pick<EuiDataGridBodyProps, 'schema' | 'schemaDetectors' | 'pagination' | 'columns' | 'leadingControlColumns' | 'trailingControlColumns' | 'visibleColCount'> & Pick<EuiDataGridHeaderRowProps, 'columnWidths' | 'defaultColumnWidth'> & Partial<EuiDataGridCellProps>;
	/**
	 * A DRY wrapper used by both custom and virtualized grid cells.
	 * It grabs context,  determines the type of cell being rendered
	 * (e.g. control vs data cell), & sets shared props between all cells
	 */
	export const CellWrapper: FunctionComponent<CellProps>;

}
declare module '@elastic/eui/src/components/datagrid/body/cell' {
	export { EuiDataGridCell } from '@elastic/eui/src/components/datagrid/body/cell/data_grid_cell';
	export { CellWrapper } from '@elastic/eui/src/components/datagrid/body/cell/data_grid_cell_wrapper';
	export { DataGridCellPopoverContext, useCellPopover, } from '@elastic/eui/src/components/datagrid/body/cell/data_grid_cell_popover';

}
declare module '@elastic/eui/src/components/datagrid/body/footer/data_grid_footer.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridFooterStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDataGridFooter: import("@emotion/utils").SerializedStyles;
	    sticky: import("@emotion/utils").SerializedStyles;
	    overline: import("@emotion/utils").SerializedStyles;
	    shade: import("@emotion/utils").SerializedStyles;
	    striped: import("@emotion/utils").SerializedStyles;
	    euiDataGridFooterCell: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/body/footer/data_grid_footer_row' {
	import React from 'react'; const EuiDataGridFooterRow: React.MemoExoticComponent<React.ForwardRefExoticComponent<import ("@elastic/eui/src/components").CommonProps & React.HTMLAttributes<HTMLDivElement> & {
	    rowIndex: number;
	    leadingControlColumns: import ("@elastic/eui/src/components/datagrid/data_grid_types").EuiDataGridControlColumn[];
	    trailingControlColumns: import ("@elastic/eui/src/components/datagrid/data_grid_types").EuiDataGridControlColumn[];
	    columns: import ("@elastic/eui/src/components/datagrid/data_grid_types").EuiDataGridColumn[];
	    schema: import ("@elastic/eui/src/components/datagrid/data_grid_types").EuiDataGridSchema;
	    columnWidths: import ("@elastic/eui/src/components/datagrid/data_grid_types").EuiDataGridColumnWidths;
	    defaultColumnWidth?: number | null | undefined;
	    renderCellValue: import ("@elastic/eui/src/components/datagrid/data_grid_types").RenderCellValue;
	    renderCellPopover?: React.JSXElementConstructor<import ("@elastic/eui/src/components/datagrid/data_grid_types").EuiDataGridCellPopoverElementProps> | ((props: import ("@elastic/eui/src/components/datagrid/data_grid_types").EuiDataGridCellPopoverElementProps) => React.ReactNode) | undefined;
	    interactiveCellId: string;
	    visibleRowIndex?: number | undefined;
	    visibleColCount: number;
	    gridStyles: import ("@elastic/eui/src/components/datagrid/data_grid_types").EuiDataGridStyle;
	} & React.RefAttributes<HTMLDivElement>>>;
	export { EuiDataGridFooterRow };

}
declare module '@elastic/eui/src/components/datagrid/body/footer/use_data_grid_footer' {
	import React from 'react';
	import { EuiDataGridFooterRowProps } from '@elastic/eui/src/components/datagrid/data_grid_types'; type Props = Omit<EuiDataGridFooterRowProps, 'renderCellValue'> & {
	    renderFooterCellValue?: EuiDataGridFooterRowProps['renderCellValue'];
	};
	/**
	 * DRY out setting up the grid footer and its refs & observers
	 */
	export const useDataGridFooter: (props: Props) => {
	    footerRow: React.JSX.Element | null;
	    footerRowHeight: number;
	};
	export {};

}
declare module '@elastic/eui/src/components/datagrid/body/footer' {
	export { EuiDataGridFooterRow } from '@elastic/eui/src/components/datagrid/body/footer/data_grid_footer_row';
	export { useDataGridFooter } from '@elastic/eui/src/components/datagrid/body/footer/use_data_grid_footer';

}
declare module '@elastic/eui/src/components/datagrid/body/data_grid_row_manager' {
	import { RefObject } from 'react';
	import { EuiDataGridRowManager, EuiDataGridStyle } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const useRowManager: ({ innerGridRef, rowClasses, }: {
	    innerGridRef: RefObject<HTMLDivElement>;
	    rowClasses?: EuiDataGridStyle['rowClasses'];
	}) => EuiDataGridRowManager;

}
declare module '@elastic/eui/src/components/datagrid/utils/grid_height_width' {
	import { MutableRefObject } from 'react';
	import { EuiDataGridRowHeightsOptions } from '@elastic/eui/src/components/datagrid/data_grid_types';
	import { RowHeightUtilsType } from '@elastic/eui/src/components/datagrid/utils/row_heights';
	export const useFinalGridDimensions: ({ unconstrainedHeight, unconstrainedWidth, wrapperDimensions, wrapperRef, isFullScreen, rowCount, }: {
	    unconstrainedHeight: number;
	    unconstrainedWidth: number;
	    wrapperDimensions: {
	        width: number;
	        height: number;
	    };
	    wrapperRef: MutableRefObject<HTMLDivElement | null>;
	    isFullScreen: boolean;
	    rowCount: number;
	}) => {
	    finalHeight: number;
	    finalWidth: number;
	};
	/**
	 * Computes the unconstrained (total possible) height of a grid
	 */
	export const useUnconstrainedHeight: ({ rowHeightUtils, startRow, endRow, rowHeightsOptions, defaultRowHeight, headerRowHeight, footerRowHeight, scrollBarHeight, innerGridRef, }: {
	    rowHeightUtils: RowHeightUtilsType;
	    startRow: number;
	    endRow: number;
	    rowHeightsOptions?: EuiDataGridRowHeightsOptions | undefined;
	    defaultRowHeight: number;
	    headerRowHeight: number;
	    footerRowHeight: number;
	    scrollBarHeight: number;
	    innerGridRef: React.MutableRefObject<HTMLDivElement | null>;
	}) => number;
	/**
	 * Returns the size of the cell container minus the scroll bar width.
	 * To do so, this hook is listening for size changes of the container itself,
	 * as well as pagination changes to make sure every update is caught.
	 *
	 * This is necessary because there is no callback/event fired by the browser
	 * indicating the scroll bar state has changed.
	 * @param resizeRef the wrapper element containging the data grid
	 * @param pageSize the currently applied page size
	 */
	export const useVirtualizeContainerWidth: (virtualizeContainer: HTMLDivElement | null, gridWidth: number, pageSize: number | undefined) => number;

}
declare module '@elastic/eui/src/components/datagrid/utils/col_widths' {
	import { EuiDataGridColumn, EuiDataGridColumnWidths, EuiDataGridControlColumn, EuiDataGridOnColumnResizeHandler, EuiDataGridProps } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const useDefaultColumnWidth: (gridWidth: number, leadingControlColumns: EuiDataGridControlColumn[], trailingControlColumns: EuiDataGridControlColumn[], columns: EuiDataGridProps['columns']) => number | null;
	export const doesColumnHaveAnInitialWidth: (column: EuiDataGridColumn) => boolean;
	export const useColumnWidths: ({ columns, leadingControlColumns, trailingControlColumns, defaultColumnWidth, onColumnResize, }: {
	    columns: EuiDataGridColumn[];
	    leadingControlColumns: EuiDataGridControlColumn[];
	    trailingControlColumns: EuiDataGridControlColumn[];
	    defaultColumnWidth?: number | null | undefined;
	    onColumnResize?: EuiDataGridOnColumnResizeHandler | undefined;
	}) => {
	    columnWidths: EuiDataGridColumnWidths;
	    setColumnWidth: (columnId: string, width: number) => void;
	    getColumnWidth: (index: number) => number;
	};

}
declare module '@elastic/eui/src/components/datagrid/utils/scrolling.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridScrollBarStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDataGrid__scrollOverlay: import("@emotion/utils").SerializedStyles;
	    euiDataGrid__scrollBarOverlayBottom: import("@emotion/utils").SerializedStyles;
	    euiDataGrid__scrollBarOverlayRight: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/utils/scrolling' {
	import { MutableRefObject, ReactNode } from 'react';
	import { VariableSizeGrid as Grid } from 'react-window';
	import { EuiDataGridStyle } from '@elastic/eui/src/components/datagrid/data_grid_types';
	interface ScrollCellIntoView {
	    rowIndex: number;
	    colIndex: number;
	}
	interface Dependencies {
	    gridRef: MutableRefObject<Grid | null>;
	    outerGridRef: MutableRefObject<HTMLDivElement | null>;
	    hasGridScrolling: boolean;
	    headerRowHeight: number;
	    footerRowHeight: number;
	    visibleRowCount: number;
	    hasStickyFooter: boolean;
	    canDragAndDropColumns?: boolean;
	}
	/**
	 * The primary goal of this scroll logic is to ensure keyboard navigation works accessibly,
	 * but there are other scenarios where it applies (e.g. clicking partially-visible cells)
	 * or is useful for (e.g. manually scrolling to cell that is currently out of viewport
	 * while accounting for headers/footers/scrollbars)
	 */
	export const useScroll: (args: Dependencies) => {
	    scrollCellIntoView: ({ rowIndex, colIndex }: ScrollCellIntoView) => Promise<void>;
	};
	/**
	 * Ensures that the passed cell is always fully in view by using cell position
	 * checks and scroll adjustments/workarounds.
	 */
	export const useScrollCellIntoView: ({ gridRef, outerGridRef, hasGridScrolling, headerRowHeight, footerRowHeight, visibleRowCount, hasStickyFooter, canDragAndDropColumns, }: Dependencies) => {
	    scrollCellIntoView: ({ rowIndex, colIndex }: ScrollCellIntoView) => Promise<void>;
	};
	/**
	 * Checks whether the current grid scrolls and/or has scrollbars
	 */
	export const useScrollBars: (outerGridRef: MutableRefObject<HTMLDivElement | null>, borderStyle?: EuiDataGridStyle['border']) => {
	    scrollBarHeight: number;
	    scrollBarWidth: number;
	    hasVerticalScroll: boolean;
	    hasHorizontalScroll: boolean;
	    scrollBorderOverlay: ReactNode;
	};
	export {};

}
declare module '@elastic/eui/src/components/datagrid/body/data_grid_body_virtualized' {
	import React, { FunctionComponent } from 'react';
	import { GridChildComponentProps } from 'react-window';
	import { EuiDataGridBodyProps, DataGridWrapperRowsContentsShape } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const Cell: FunctionComponent<GridChildComponentProps>;
	export const DataGridWrapperRowsContext: React.Context<DataGridWrapperRowsContentsShape>;
	export const EuiDataGridBodyVirtualized: FunctionComponent<EuiDataGridBodyProps>;

}
declare module '@elastic/eui/src/components/datagrid/body/data_grid_body_custom' {
	import { FunctionComponent } from 'react';
	import { EuiDataGridBodyProps } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const EuiDataGridBodyCustomRender: FunctionComponent<EuiDataGridBodyProps>;

}
declare module '@elastic/eui/src/components/datagrid/body/data_grid_body.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridBodyStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDataGridBody: import("@emotion/utils").SerializedStyles;
	    virtualized: import("@emotion/utils").SerializedStyles;
	    customRender: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/body/data_grid_body' {
	import { FunctionComponent } from 'react';
	import { EuiDataGridBodyProps } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const EuiDataGridBody: FunctionComponent<EuiDataGridBodyProps>;

}
declare module '@elastic/eui/src/components/datagrid/body' {
	export { EuiDataGridBody } from '@elastic/eui/src/components/datagrid/body/data_grid_body';

}
declare module '@elastic/eui/src/components/datagrid/controls/data_grid_toolbar.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridToolbarStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiDataGrid__controls: import("@emotion/utils").SerializedStyles;
	    euiDataGrid__rightControls: import("@emotion/utils").SerializedStyles;
	    euiDataGrid__leftControls: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/controls/data_grid_toolbar' {
	import React, { ReactNode } from 'react';
	import { EuiDataGridProps, EuiDataGridToolbarProps, EuiDataGridToolBarVisibilityOptions } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const MINIMUM_WIDTH_FOR_GRID_CONTROLS = 479;
	export const EuiDataGridToolbar: ({ gridWidth, minSizeForControls, toolbarVisibility, isFullScreen, fullScreenSelector, keyboardShortcuts, displaySelector, columnSelector, columnSorting, renderCustomToolbar, }: EuiDataGridToolbarProps) => React.JSX.Element;
	export function checkOrDefaultToolBarDisplayOptions<OptionKey extends keyof EuiDataGridToolBarVisibilityOptions>(arg: EuiDataGridProps['toolbarVisibility'], option: OptionKey): Required<EuiDataGridToolBarVisibilityOptions>[OptionKey];
	export const renderAdditionalControls: (toolbarVisibility: EuiDataGridProps['toolbarVisibility'], position: 'left.prepend' | 'left.append' | 'right') => ReactNode;
	/**
	 * Utility helper for selectors/controls that allow nested options
	 * (e.g. column selector, display selector)
	 */
	export function getNestedObjectOptions<T>(controlOption: undefined | boolean | T, objectKey: keyof T): boolean;

}
declare module '@elastic/eui/src/components/datagrid/controls/data_grid_toolbar_control' {
	import { FunctionComponent } from 'react';
	import { EuiButtonEmptyProps } from '@elastic/eui/src/components/button';
	export type EuiDataGridToolbarControlProps = EuiButtonEmptyProps & {
	    badgeContent?: number | string;
	};
	export const EuiDataGridToolbarControl: FunctionComponent<EuiDataGridToolbarControlProps>;

}
declare module '@elastic/eui/src/components/datagrid/controls/column_selector.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridColumnSelectorStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDataGridColumnSelector: import("@emotion/utils").SerializedStyles;
	    euiDataGridColumnSelector__item: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/controls/column_selector' {
	import React, { ReactNode } from 'react';
	import { EuiDataGridColumn, EuiDataGridColumnVisibility, EuiDataGridToolBarVisibilityOptions } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const useDataGridColumnSelector: (availableColumns: EuiDataGridColumn[], columnVisibility: EuiDataGridColumnVisibility, showColumnSelector: EuiDataGridToolBarVisibilityOptions['showColumnSelector'], displayValues: {
	    [key: string]: string;
	}) => [React.ReactNode, EuiDataGridColumn[], (columns: string[]) => void, (colFrom: string, colTo: string) => void];

}
declare module '@elastic/eui/src/components/datagrid/controls/column_sorting' {
	import { ReactNode, FunctionComponent } from 'react';
	import { EuiDataGridColumn, EuiDataGridSchema, EuiDataGridSchemaDetector, EuiDataGridSorting } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export type ColumnSortingProps = {
	    sorting: EuiDataGridSorting;
	    columns: EuiDataGridColumn[];
	    displayValues: {
	        [key: string]: string;
	    };
	    schema: EuiDataGridSchema;
	    schemaDetectors: EuiDataGridSchemaDetector[];
	};
	export const useDataGridColumnSorting: ({ sorting, ...rest }: Omit<ColumnSortingProps, "sorting"> & {
	    sorting?: EuiDataGridSorting | undefined;
	}) => ReactNode;
	export const DataGridSortingControl: FunctionComponent<ColumnSortingProps>;

}
declare module '@elastic/eui/src/components/datagrid/controls/display_selector' {
	import { ReactNode } from 'react';
	import { EuiDataGridToolBarVisibilityOptions, EuiDataGridStyle, EuiDataGridRowHeightsOptions } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const startingStyles: EuiDataGridStyle;
	/**
	 * Display settings/selector popover
	 */
	export const useDataGridDisplaySelector: (showDisplaySelector: EuiDataGridToolBarVisibilityOptions['showDisplaySelector'], passedGridStyles: EuiDataGridStyle, passedRowHeightsOptions?: EuiDataGridRowHeightsOptions) => [ReactNode, EuiDataGridStyle, EuiDataGridRowHeightsOptions];

}
declare module '@elastic/eui/src/components/description_list/description_list_types' {
	import { HTMLAttributes, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export interface EuiDescriptionListProps {
	    listItems?: Array<{
	        title: NonNullable<ReactNode>;
	        description: NonNullable<ReactNode>;
	    }>;
	    /**
	     * Text alignment
	     */
	    align?: EuiDescriptionListAlignment;
	    /**
	     * Smaller text and condensed spacing
	     */
	    compressed?: boolean;
	    /**
	     * How should the content be styled, by default
	     * this will emphasize the title
	     */
	    textStyle?: 'normal' | 'reverse';
	    /**
	     * How each item should be laid out
	     */
	    type?: EuiDescriptionListType;
	    /**
	     * Props object to be passed to `EuiDescriptionListTitle`
	     */
	    titleProps?: HTMLAttributes<HTMLElement> & CommonProps;
	    /**
	     * Props object to be passed to `EuiDescriptionListDescription`
	     */
	    descriptionProps?: HTMLAttributes<HTMLElement> & CommonProps;
	    /**
	     * Allows customizing the vertical spacing between rows.
	     */
	    rowGutterSize?: EuiDescriptionListGutterSizes;
	    /**
	     * Allows customizing the horizontal spacing between columns.
	     *
	     * Only applies to `column` and `responsiveColumn` types.
	     */
	    columnGutterSize?: EuiDescriptionListColumnGapSizes;
	    /**
	     * Allows customizing specific column widths (e.g. `['100px', '200px']`). The first
	     * array value applies to the title column, and the second applies to the description column.
	     *
	     * Passing numbers instead of CSS width strings will use a ratio of widths.
	     * For example, [1, 3] will render a description column 3x the width of the title column.
	     * In other words, descriptions will have a width of `75%` and titles will have a width of `25%`.
	     *
	     * Only applies to `column` and `responsiveColumn` types.
	     *
	     * _Advanced usage note:_ column width strings also accept [CSS grid special units,
	     * sizing, keywords, and sizing functions](https://css-tricks.com/snippets/css/complete-guide-grid/#aa-special-units-functions).
	     */
	    columnWidths?: [number | string, number | string];
	}
	export const CHILD_TYPES: readonly ["row", "inline", "column"];
	export type EuiDescriptionListChildTypes = (typeof CHILD_TYPES)[number];
	export const TYPES: readonly ["row", "inline", "column", "responsiveColumn"];
	export type EuiDescriptionListType = (typeof TYPES)[number];
	export const ALIGNMENTS: readonly ["center", "left"];
	export type EuiDescriptionListAlignment = (typeof ALIGNMENTS)[number];
	export const TEXT_STYLES: readonly ["normal", "reverse"];
	export type EuiDescriptionListTextStyle = (typeof TEXT_STYLES)[number];
	export const ROW_GUTTER_SIZES: readonly ["s", "m"];
	export type EuiDescriptionListGutterSizes = (typeof ROW_GUTTER_SIZES)[number];
	export const COLUMN_GUTTER_SIZES: readonly ["s", "m"];
	export type EuiDescriptionListColumnGapSizes = (typeof COLUMN_GUTTER_SIZES)[number];

}
declare module '@elastic/eui/src/components/description_list/description_list_context' {
	import { EuiDescriptionListProps, EuiDescriptionListChildTypes } from '@elastic/eui/src/components/description_list/description_list_types'; type EuiDescriptionListContextValues = Required<Pick<EuiDescriptionListProps, 'textStyle' | 'align' | 'rowGutterSize'> & {
	    type: EuiDescriptionListChildTypes;
	}> & {
	    compressed?: EuiDescriptionListProps['compressed'];
	};
	export const contextDefaults: EuiDescriptionListContextValues;
	export const EuiDescriptionListContext: import("react").Context<EuiDescriptionListContextValues>;
	export {};

}
declare module '@elastic/eui/src/components/description_list/description_list_title.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDescriptionListTitleStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDescriptionList__title: import("@emotion/utils").SerializedStyles;
	    row: import("@emotion/utils").SerializedStyles;
	    column: import("@emotion/utils").SerializedStyles;
	    inline: import("@emotion/utils").SerializedStyles;
	    fontStyles: {
	        normal: import("@emotion/utils").SerializedStyles;
	        reverse: import("@emotion/utils").SerializedStyles;
	        compressed: import("@emotion/utils").SerializedStyles;
	    };
	    inlineStyles: {
	        normal: import("@emotion/utils").SerializedStyles;
	        compressed: import("@emotion/utils").SerializedStyles;
	    };
	    right: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/description_list/description_list_title' {
	import { HTMLAttributes, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export interface EuiDescriptionListTitleProps extends CommonProps, HTMLAttributes<HTMLElement> {
	}
	export const EuiDescriptionListTitle: FunctionComponent<EuiDescriptionListTitleProps>;

}
declare module '@elastic/eui/src/components/description_list/description_list_description.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDescriptionListDescriptionStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDescriptionList__description: import("@emotion/utils").SerializedStyles;
	    row: import("@emotion/utils").SerializedStyles;
	    column: import("@emotion/utils").SerializedStyles;
	    inline: import("@emotion/utils").SerializedStyles;
	    fontStyles: {
	        normal: import("@emotion/utils").SerializedStyles;
	        reverse: import("@emotion/utils").SerializedStyles;
	        compressed: import("@emotion/utils").SerializedStyles;
	    };
	    inlineStyles: {
	        compressed: import("@emotion/utils").SerializedStyles;
	        normal: import("@emotion/utils").SerializedStyles;
	    };
	    left: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/description_list/description_list_description' {
	import { HTMLAttributes, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export interface EuiDescriptionListDescriptionProps extends CommonProps, HTMLAttributes<HTMLElement> {
	}
	export const EuiDescriptionListDescription: FunctionComponent<EuiDescriptionListDescriptionProps>;

}
declare module '@elastic/eui/src/components/description_list/description_list.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDescriptionListStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDescriptionList: import("@emotion/utils").SerializedStyles;
	    row: import("@emotion/utils").SerializedStyles;
	    inline: import("@emotion/utils").SerializedStyles;
	    column: import("@emotion/utils").SerializedStyles;
	    columnGap: {
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	    };
	    rowGap: {
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	    };
	    center: import("@emotion/utils").SerializedStyles;
	    left: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/description_list/description_list' {
	import { HTMLAttributes, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiDescriptionListProps } from '@elastic/eui/src/components/description_list/description_list_types';
	export const EuiDescriptionList: FunctionComponent<CommonProps & HTMLAttributes<HTMLDListElement> & EuiDescriptionListProps>;

}
declare module '@elastic/eui/src/components/description_list' {
	export type { EuiDescriptionListProps } from '@elastic/eui/src/components/description_list/description_list_types';
	export { EuiDescriptionList } from '@elastic/eui/src/components/description_list/description_list';
	export { EuiDescriptionListTitle } from '@elastic/eui/src/components/description_list/description_list_title';
	export { EuiDescriptionListDescription } from '@elastic/eui/src/components/description_list/description_list_description';

}
declare module '@elastic/eui/src/components/datagrid/controls/keyboard_shortcuts.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridKeyboardShortcutsStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDataGrid__keyboardShortcuts: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/controls/keyboard_shortcuts' {
	import { ReactNode } from 'react';
	export const useDataGridKeyboardShortcuts: () => {
	    keyboardShortcuts: ReactNode;
	};

}
declare module '@elastic/eui/src/components/datagrid/controls/fullscreen_selector.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridFullScreenStyles: (euiThemeContext: UseEuiTheme) => {
	    'euiDataGrid--fullScreen': string;
	    euiDataGrid__restrictBody: string;
	};

}
declare module '@elastic/eui/src/components/datagrid/controls/fullscreen_selector' {
	import { ReactNode, KeyboardEventHandler } from 'react';
	export const useDataGridFullScreenSelector: () => {
	    isFullScreen: boolean;
	    setIsFullScreen: (isFullScreen: boolean) => void;
	    fullScreenSelector: ReactNode;
	    handleGridKeyDown: KeyboardEventHandler<HTMLDivElement>;
	    fullScreenStyles: string;
	};

}
declare module '@elastic/eui/src/components/datagrid/controls' {
	export { useDataGridColumnSelector } from '@elastic/eui/src/components/datagrid/controls/column_selector';
	export { useDataGridColumnSorting } from '@elastic/eui/src/components/datagrid/controls/column_sorting';
	export { useDataGridDisplaySelector, startingStyles } from '@elastic/eui/src/components/datagrid/controls/display_selector';
	export { useDataGridKeyboardShortcuts } from '@elastic/eui/src/components/datagrid/controls/keyboard_shortcuts';
	export { useDataGridFullScreenSelector } from '@elastic/eui/src/components/datagrid/controls/fullscreen_selector';
	export { checkOrDefaultToolBarDisplayOptions, EuiDataGridToolbar, } from '@elastic/eui/src/components/datagrid/controls/data_grid_toolbar';
	export { EuiDataGridToolbarControl, type EuiDataGridToolbarControlProps, } from '@elastic/eui/src/components/datagrid/controls/data_grid_toolbar_control';

}
declare module '@elastic/eui/src/components/datagrid/pagination/data_grid_pagination.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDataGridPaginationStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiDataGrid__pagination: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/datagrid/pagination/data_grid_pagination' {
	import React, { AriaAttributes } from 'react';
	import { EuiDataGridPaginationProps } from '@elastic/eui/src/components/datagrid/data_grid_types'; type _EuiDataGridPaginationProps = Required<EuiDataGridPaginationProps> & {
	    rowCount: number;
	    controls: string;
	    'aria-label'?: AriaAttributes['aria-label'];
	};
	/**
	 * Do not render the pagination when:
	 * 1. Rows count is less than min pagination option (rows per page)
	 * 2. Rows count is less than pageSize (the case when there are no pageSizeOptions provided)
	 */
	export const shouldRenderPagination: (rowCount: number, { pageSize, pageSizeOptions }: Required<EuiDataGridPaginationProps>) => boolean;
	export const EuiDataGridPagination: ({ pageIndex, pageSize, pageSizeOptions, onChangePage: _onChangePage, onChangeItemsPerPage, rowCount, controls, "aria-label": ariaLabel, }: _EuiDataGridPaginationProps) => React.JSX.Element;
	export {};

}
declare module '@elastic/eui/src/components/datagrid/pagination' {
	export { shouldRenderPagination, EuiDataGridPagination, } from '@elastic/eui/src/components/datagrid/pagination/data_grid_pagination';

}
declare module '@elastic/eui/src/components/datagrid/utils/in_memory' {
	import { FunctionComponent } from 'react';
	import { EuiDataGridInMemory, EuiDataGridInMemoryValues, EuiDataGridInMemoryRendererProps } from '@elastic/eui/src/components/datagrid/data_grid_types';
	/**
	 * inMemory values hook
	 */
	export const useInMemoryValues: (inMemory: EuiDataGridInMemory | undefined, rowCount: number) => [
	    EuiDataGridInMemoryValues,
	    EuiDataGridInMemoryRendererProps['onCellRender']
	];
	/**
	 * InMemory renderer
	 */
	export const EuiDataGridInMemoryRenderer: FunctionComponent<EuiDataGridInMemoryRendererProps>;

}
declare module '@elastic/eui/src/components/datagrid/utils/row_count' {
	import { EuiDataGridProps, EuiDataGridVisibleRows } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const computeVisibleRows: ({ pagination, rowCount, }: {
	    pagination: Required<EuiDataGridProps['pagination']>;
	    rowCount: EuiDataGridProps['rowCount'];
	}) => EuiDataGridVisibleRows;

}
declare module '@elastic/eui/src/components/datagrid/utils/ref' {
	import { Ref, RefObject } from 'react';
	import type { VariableSizeGrid } from 'react-window';
	import { EuiDataGridRefProps, EuiDataGridProps, DataGridFocusContextShape, DataGridCellPopoverContextShape, DataGridSortedContextShape } from '@elastic/eui/src/components/datagrid/data_grid_types';
	interface Dependencies {
	    ref: Ref<unknown>;
	    gridRef: RefObject<VariableSizeGrid>;
	    setIsFullScreen: EuiDataGridRefProps['setIsFullScreen'];
	    focusContext: DataGridFocusContextShape;
	    cellPopoverContext: DataGridCellPopoverContextShape;
	    sortedContext: DataGridSortedContextShape;
	    pagination: Required<EuiDataGridProps['pagination']>;
	    rowCount: number;
	    visibleColCount: number;
	}
	export const useImperativeGridRef: ({ ref, gridRef, setIsFullScreen, focusContext, cellPopoverContext, sortedContext: { sortedRowMap }, pagination, rowCount, visibleColCount, }: Dependencies) => void;
	/**
	 * Throw a digestible error if the consumer attempts to focus into an invalid
	 * cell range, which should also stop the APIs from continuing
	 */
	export const useCellLocationCheck: (rowCount: number, colCount: number) => {
	    checkCellExists: ({ rowIndex, colIndex }: {
	        rowIndex: number;
	        colIndex: number;
	    }) => void;
	};
	/**
	 * The rowIndex passed from the consumer is the unsorted and unpaginated
	 * index derived from their original data. We need to convert that rowIndex
	 * into a visibleRowIndex (which is what our internal cell APIs use) and, if
	 * the row is not on the current page, the grid should automatically handle
	 * paginating to that row.
	 */
	export const useSortPageCheck: (pagination: Required<EuiDataGridProps['pagination']>, sortedRowMap: DataGridSortedContextShape['sortedRowMap']) => {
	    findVisibleRowIndex: (rowIndex: number) => number;
	};
	export {};

}
declare module '@elastic/eui/src/components/datagrid/data_grid' {
	import React from 'react';
	import { EuiDataGridProps, EuiDataGridRefProps } from '@elastic/eui/src/components/datagrid/data_grid_types';
	export const EuiDataGrid: React.MemoExoticComponent<React.ForwardRefExoticComponent<EuiDataGridProps & React.RefAttributes<EuiDataGridRefProps>>>;

}
declare module '@elastic/eui/src/components/datagrid' {
	export { EuiDataGrid } from '@elastic/eui/src/components/datagrid/data_grid';
	export { useDataGridColumnSelector, useDataGridColumnSorting, useDataGridDisplaySelector, EuiDataGridToolbarControl, } from '@elastic/eui/src/components/datagrid/controls';
	export * from '@elastic/eui/src/components/datagrid/data_grid_types';

}
declare module '@elastic/eui/src/components/date_picker/react-datepicker/src' {
	/*
	 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
	 * or more contributor license agreements. Licensed under the Elastic License
	 * 2.0 and the Server Side Public License, v 1; you may not use this file except
	 * in compliance with, at your election, the Elastic License 2.0 or the Server
	 * Side Public License, v 1.
	 */

	// Type definitions for react-datepicker 1.8
	// Project: https://github.com/Hacker0x01/react-datepicker
	// Definitions by: Rajab Shakirov <https://github.com/radziksh>,
	//                 Andrey Balokha <https://github.com/andrewBalekha>,
	//                 Greg Smith <https://github.com/smrq>,
	//                 Platon Pronko <https://github.com/Rogach>
	//                 Roy Xue <https://github.com/royxue>
	//                 Koala Human <https://github.com/KoalaHuman>
	//                 Sean Kelley <https://github.com/seansfkelley>
	//                 Justin Grant <https://github.com/justingrant>
	// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped
	// TypeScript Version: 2.8

	import * as React from 'react';
	import * as moment from 'moment';

	import type { EuiPopoverProps, PopoverAnchorPosition } from '@elastic/eui/src/components/popover';
	import type { EuiFieldTextProps } from '@elastic/eui/src/components/form/field_text';

	export interface ReactDatePickerProps {
	  /**
	   * Whether changes to Year and Month (via dropdowns) should trigger `onChange`
	   */
	  adjustDateOnChange?: boolean;
	  accessibleMode?: boolean;
	  allowSameDay?: boolean;
	  autoComplete?: string;
	  autoFocus?: boolean;

	  /**
	   * Optional class added to the calendar portion of datepicker
	   */
	  calendarClassName?: string;
	  children?: React.ReactNode;

	  /**
	   * Added to the actual input of the calendar
	   */
	  className?: string;
	  defaultInputProps?: Partial<EuiFieldTextProps>;

	  /**
	   * Replaces the input with any node, like a button
	   */
	  customInput?: React.ReactNode;
	  customInputRef?: string;

	  /**
	   * Accepts any moment format string
	   */
	  dateFormat?: string | string[];
	  dateFormatCalendar?: string;
	  dayClassName?(date: moment.Moment): string | null;
	  disabled?: boolean;
	  disabledKeyboardNavigation?: boolean;
	  dropdownMode?: 'scroll' | 'select';
	  endDate?: moment.Moment | null;
	  excludeDates?: moment.Moment[];
	  excludeTimes?: moment.Moment[];
	  filterDate?(date: moment.Moment): boolean;
	  fixedHeight?: boolean;
	  forceShowMonthNavigation?: boolean;
	  formatWeekNumber?(date: moment.Moment): string | number;
	  highlightDates?: moment.Moment[];
	  id?: string;
	  includeDates?: moment.Moment[];
	  includeTimes?: moment.Moment[];
	  inline?: boolean;

	  /**
	   * Adds additional times to the time selector other then :30 increments
	   */
	  injectTimes?: moment.Moment[];
	  isClearable?: boolean;

	  /**
	   * Switches the locale / display. "en-us", "zn-ch"...etc
	   */
	  locale?: moment.LocaleSpecifier;

	  /**
	   * The max date accepted (in moment format) as a selection
	   */
	  maxDate?: moment.Moment;

	  /**
	   * The max time accepted (in moment format) as a selection
	   */
	  maxTime?: moment.Moment;

	  /**
	   * The min date accepted (in moment format) as a selection
	   */
	  minDate?: moment.Moment;

	  /**
	   * The min time accepted (in moment format) as a selection
	   */
	  minTime?: moment.Moment;
	  monthsShown?: number;
	  name?: string;
	  onBlur?(event: React.FocusEvent<HTMLInputElement>): void;

	  /**
	   * What to do when the input changes
	   */
	  onChange?(
	    date: moment.Moment | null,
	    event?: React.SyntheticEvent<any>
	  ): void;
	  onChangeRaw?(event: React.FocusEvent<HTMLInputElement>): void;
	  onClickOutside?(event: React.MouseEvent<HTMLDivElement>): void;
	  onFocus?(event: React.FocusEvent<HTMLInputElement>): void;
	  onKeyDown?(event: React.KeyboardEvent<HTMLDivElement>): void;
	  onMonthChange?(date: moment.Moment): void;
	  onSelect?(date: moment.Moment, event?: React.SyntheticEvent<any>): void;
	  onWeekSelect?(
	    firstDayOfWeek: moment.Moment,
	    weekNumber: string | number,
	    event?: React.SyntheticEvent<any>
	  ): void;
	  onYearChange?(date: moment.Moment): void;
	  openToDate?: moment.Moment;
	  peekNextMonth?: boolean;
	  placeholderText?: string;

	  /**
	   * Class applied to the popup, when inline is false
	   */
	  popperClassName?: string;
	  popperContainer?(props: { children: React.ReactNode[] }): React.ReactNode;
	  popperPlacement?: PopoverAnchorPosition;
	  popperProps?: Partial<EuiPopoverProps>;
	  preventOpenOnFocus?: boolean;
	  readOnly?: boolean;
	  required?: boolean;
	  scrollableMonthYearDropdown?: boolean;
	  scrollableYearDropdown?: boolean;

	  /**
	   * The selected datetime (in moment format)
	   */
	  selected?: moment.Moment | null;
	  selectsEnd?: boolean;
	  selectsStart?: boolean;

	  /**
	   * Will close the popup on selection
	   */
	  shouldCloseOnSelect?: boolean;
	  showDisabledMonthNavigation?: boolean;
	  showMonthDropdown?: boolean;
	  showMonthYearDropdown?: boolean;

	  /**
	   * Show the time selection alongside the calendar
	   */
	  showTimeSelect?: boolean;

	  /**
	   * Only show the time selector, not the calendar
	   */
	  showTimeSelectOnly?: boolean;
	  showWeekNumbers?: boolean;
	  showYearDropdown?: boolean;
	  startDate?: moment.Moment | null;
	  startOpen?: boolean;

	  /**
	   * Use Moment strict mode, allowing exact format matches only
	   */
	  strictParsing?: boolean;
	  tabIndex?: number;
	  timeCaption?: string;

	  /**
	   * The format of the time within the selector, in moment notation
	   */
	  timeFormat?: string;
	  timeIntervals?: number;
	  title?: string;
	  todayButton?: string;
	  useShortMonthInDropdown?: boolean;
	  useWeekdaysShort?: boolean;
	  utcOffset?: number;
	  value?: string;
	  weekLabel?: string;
	  withPortal?: boolean;
	  
	  /**
	   * The total number of years to show as options in years selection dropdown
	   */
	  yearDropdownItemNumber?: number;
	} const ReactDatePicker: React.ClassicComponentClass<ReactDatePickerProps>;
	export default ReactDatePicker;

}
declare module '@elastic/eui/src/components/date_picker/react-datepicker' {
	import ReactDatePicker from '@elastic/eui/src/components/date_picker/react-datepicker/src';
	export { ReactDatePicker };
	export type { ReactDatePickerProps } from '@elastic/eui/src/components/date_picker/react-datepicker/src';

}
declare module '@elastic/eui/src/components/date_picker/react_date_picker.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDatePickerVariables: ({ euiTheme }: UseEuiTheme) => {
	    gapSize: string;
	    readonly paddingSize: string;
	    headerButtonSize: string;
	    readonly headerOffset: string;
	};
	export const euiReactDatePickerStyles: (euiThemeContext: UseEuiTheme) => {
	    euiReactDatePicker: string;
	};
	export const _monthYearDropdowns: (euiThemeContext: UseEuiTheme) => string;
	export const _dayCalendarStyles: (euiThemeContext: UseEuiTheme) => string;
	export const _timeSelectStyles: (euiThemeContext: UseEuiTheme) => string;

}
declare module '@elastic/eui/src/components/date_picker/date_picker.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDatePickerStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDatePicker: import("@emotion/utils").SerializedStyles;
	    inline: {
	        inline: import("@emotion/utils").SerializedStyles;
	        noShadow: string;
	        shadow: import("@emotion/utils").SerializedStyles;
	        invalid: import("@emotion/utils").SerializedStyles;
	        disabled: import("@emotion/utils").SerializedStyles;
	        readOnly: import("@emotion/utils").SerializedStyles;
	    };
	    inGroup: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/date_picker/date_picker' {
	import { FunctionComponent, Component, MouseEventHandler, Ref } from 'react';
	import type { Moment } from 'moment';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { PopoverAnchorPosition } from '@elastic/eui/src/components/popover';
	import { EuiFormControlLayoutProps } from '@elastic/eui/src/components/form';
	import { EuiFormControlLayoutIconsProps } from '@elastic/eui/src/components/form/form_control_layout/form_control_layout_icons';
	import { ReactDatePickerProps } from '@elastic/eui/src/components/date_picker/react-datepicker';
	export const euiDatePickerDefaultDateFormat = "MM/DD/YYYY";
	export const euiDatePickerDefaultTimeFormat = "hh:mm A"; const unsupportedProps: readonly ["monthsShown", "showWeekNumbers", "fixedHeight", "dropdownMode", "useShortMonthInDropdown", "todayButton", "timeCaption", "disabledKeyboardNavigation", "isClearable", "withPortal", "showMonthYearDropdown", "popperPlacement", "defaultInputProps"]; type UnsupportedProps = (typeof unsupportedProps)[number];
	interface EuiExtendedDatePickerProps extends Omit<ReactDatePickerProps, UnsupportedProps> {
	    /**
	     * Applies classes to the numbered days provided. Check docs for example.
	     */
	    dayClassName?: (date: Moment) => string | null;
	    /**
	     * Renders the input as full width
	     */
	    fullWidth?: boolean;
	    /**
	     * Renders the input with compressed height and sizing
	     */
	    compressed?: boolean;
	    /**
	     * ref for the ReactDatePicker instance
	     */
	    inputRef?: Ref<Component<ReactDatePickerProps, any, any>>;
	    /**
	     * Provides styling to the input when invalid
	     */
	    isInvalid?: boolean;
	    /**
	     * Provides styling to the input when loading
	     */
	    isLoading?: boolean;
	    /**
	     * What to do when the input is cleared by the x icon
	     */
	    onClear?: MouseEventHandler<HTMLButtonElement>;
	    /**
	     * Opens to this date (in moment format) on first press, regardless of selection
	     */
	    openToDate?: Moment;
	    /**
	     * Shows only when no date is selected
	     */
	    placeholder?: string;
	    /**
	     * Displays the date picker calendar on directly on the page.
	     * Will not render `iconType` or `fullWidth`.
	     */
	    inline?: boolean;
	    /**
	     * Allows turning the shadow off if using the `inline` prop
	     */
	    shadow?: boolean;
	    /**
	     * Show the icon in input
	     */
	    showIcon?: boolean;
	    /**
	     * Pass an icon type to change the default `calendar` or `clock` icon
	     */
	    iconType?: EuiFormControlLayoutIconsProps['icon'];
	    /**
	     * Sets the placement of the popover.
	     *
	     * **Use [EuiPopover](/#/layout/popover) values**: 'upCenter', 'upLeft', 'upRight', downCenter', 'downLeft', 'downRight', 'leftCenter', 'leftUp', 'leftDown', 'rightCenter', 'rightUp', 'rightDown'.
	     */
	    popoverPlacement?: PopoverAnchorPosition;
	    /**
	     * Creates an input group with element(s) coming before the input.
	     * `string` | `ReactElement` or an array of these
	     *
	     * Ignored if `inline` or `controlOnly` are true.
	     */
	    append?: EuiFormControlLayoutProps['append'];
	    /**
	     * Creates an input group with element(s) coming before the input.
	     * `string` | `ReactElement` or an array of these
	     *
	     * Ignored if `inline` or `controlOnly` are true.
	     */
	    prepend?: EuiFormControlLayoutProps['prepend'];
	    /**
	     * Completely removes form control layout wrapper and ignores
	     * `iconType`, `prepend`, and `append`.
	     *
	     * Best used inside EuiFormControlLayoutDelimited.
	     */
	    controlOnly?: boolean;
	}
	export type EuiDatePickerProps = CommonProps & EuiExtendedDatePickerProps;
	export const EuiDatePicker: FunctionComponent<EuiDatePickerProps>;
	export {};

}
declare module '@elastic/eui/src/components/tabs/tab.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiTabStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiTab: import("@emotion/utils").SerializedStyles;
	    expanded: import("@emotion/utils").SerializedStyles;
	    selected: import("@emotion/utils").SerializedStyles;
	    disabled: {
	        disabled: import("@emotion/utils").SerializedStyles;
	        selected: import("@emotion/utils").SerializedStyles;
	    };
	};
	export const euiTabContentStyles: (euiThemeContext: UseEuiTheme) => {
	    euiTab__content: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    xl: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/tabs/tabs.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiTabsStyles: (euiThemeContext: UseEuiTheme) => {
	    euiTabs: import("@emotion/utils").SerializedStyles;
	    bottomBorder: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    xl: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/tabs/tabs' {
	import React, { HTMLAttributes, PropsWithChildren, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const SIZES: readonly ["s", "m", "l", "xl"];
	export type EuiTabsSizes = (typeof SIZES)[number];
	export type EuiTabsProps = HTMLAttributes<HTMLDivElement> & PropsWithChildren & CommonProps & {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children?: ReactNode;
	    /**
	     * Evenly stretches each tab to fill the
	     * horizontal space
	     */
	    expand?: boolean;
	    /**
	     * Adds a bottom border to separate it from the content after
	     */
	    bottomBorder?: boolean;
	    /**
	     * Sizes affect both font size and overall size.
	     * Only use the `xl` size when displayed as page titles.
	     */
	    size?: EuiTabsSizes;
	};
	export type EuiTabRef = HTMLDivElement;
	export const EuiTabs: React.ForwardRefExoticComponent<React.HTMLAttributes<HTMLDivElement> & {
	    children?: React.ReactNode;
	} & CommonProps & {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children?: ReactNode;
	    /**
	     * Evenly stretches each tab to fill the
	     * horizontal space
	     */
	    expand?: boolean | undefined;
	    /**
	     * Adds a bottom border to separate it from the content after
	     */
	    bottomBorder?: boolean | undefined;
	    /**
	     * Sizes affect both font size and overall size.
	     * Only use the `xl` size when displayed as page titles.
	     */
	    size?: "s" | "m" | "l" | "xl" | undefined;
	} & React.RefAttributes<HTMLDivElement>>;

}
declare module '@elastic/eui/src/components/tabs/tabs_context' {
	import { EuiTabsProps } from '@elastic/eui/src/components/tabs/tabs';
	export type EuiTabsContextValues = Required<Pick<EuiTabsProps, 'expand' | 'size'>>;
	export const contextDefaults: EuiTabsContextValues;
	export const EuiTabsContext: import("react").Context<Required<Pick<EuiTabsProps, "size" | "expand">>>;

}
declare module '@elastic/eui/src/components/tabs/tab' {
	import { MouseEventHandler, AnchorHTMLAttributes, ButtonHTMLAttributes, FunctionComponent, ReactNode } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	export interface EuiTabProps extends CommonProps {
	    isSelected?: boolean;
	    disabled?: boolean;
	    /**
	     * Places content before the tab content/children.
	     * Will be excluded from interactive effects.
	     */
	    prepend?: ReactNode;
	    /**
	     * Places content after the tab content/children.
	     * Will be excluded from interactive effects.
	     */
	    append?: ReactNode;
	} type EuiTabPropsForAnchor = EuiTabProps & Omit<AnchorHTMLAttributes<HTMLAnchorElement>, 'onClick' | 'href'> & {
	    href?: string;
	    onClick?: MouseEventHandler<HTMLAnchorElement>;
	}; type EuiTabPropsForButton = EuiTabProps & Omit<ButtonHTMLAttributes<HTMLButtonElement>, 'onClick'> & {
	    onClick?: MouseEventHandler<HTMLButtonElement>;
	};
	export type Props = ExclusiveUnion<EuiTabPropsForAnchor, EuiTabPropsForButton>;
	export const EuiTab: FunctionComponent<Props>;
	export {};

}
declare module '@elastic/eui/src/components/tabs/tabbed_content/tabbed_content' {
	import React, { Component, HTMLAttributes, ReactNode, FocusEvent } from 'react';
	import { EuiTabsSizes } from '@elastic/eui/src/components/tabs/tabs';
	import { EuiTabProps } from '@elastic/eui/src/components/tabs/tab';
	import { CommonProps } from '@elastic/eui/src/components/common';
	/**
	 * Marked as const so type is `['initial', 'selected']` instead of `string[]`
	 */
	export const AUTOFOCUS: readonly ["initial", "selected"];
	export interface EuiTabbedContentTab extends EuiTabProps {
	    id: string;
	    name: ReactNode;
	    content: ReactNode;
	}
	interface EuiTabbedContentState {
	    selectedTabId: string | undefined;
	    inFocus: boolean;
	}
	export type EuiTabbedContentProps = CommonProps & Omit<HTMLAttributes<HTMLDivElement>, 'autoFocus'> & {
	    /**
	     * When tabbing into the tabs, set the focus on `initial` for the first tab,
	     * or `selected` for the currently selected tab. Best use case is for inside of
	     * overlay content like popovers or flyouts.
	     */
	    autoFocus?: 'initial' | 'selected';
	    /**
	     * Evenly stretches each tab to fill the horizontal space
	     */
	    expand?: boolean;
	    /**
	     * Use this prop to set the initially selected tab while letting the tabbed content component
	     * control selection state internally
	     */
	    initialSelectedTab?: EuiTabbedContentTab;
	    onTabClick?: (selectedTab: EuiTabbedContentTab) => void;
	    /**
	     * Use this prop if you want to control selection state within the owner component
	     */
	    selectedTab?: EuiTabbedContentTab;
	    size?: EuiTabsSizes;
	    /**
	     * Each tab needs id and content properties, so we can associate it with its panel for accessibility.
	     * The name property (a node) is also required to display to the user.
	     */
	    tabs: EuiTabbedContentTab[];
	};
	export class EuiTabbedContent extends Component<EuiTabbedContentProps, EuiTabbedContentState> {
	    static defaultProps: {
	        autoFocus: EuiTabbedContentProps['autoFocus'];
	    };
	    private readonly rootId;
	    private readonly tabsRef;
	    constructor(props: EuiTabbedContentProps);
	    focusTab: () => void;
	    initializeFocus: () => void;
	    removeFocus: (blurEvent: FocusEvent<HTMLDivElement>) => void;
	    onTabClick: (selectedTab: EuiTabbedContentTab) => void;
	    render(): React.JSX.Element;
	}
	export {};

}
declare module '@elastic/eui/src/components/tabs/tabbed_content' {
	export type { EuiTabbedContentTab, EuiTabbedContentProps, } from '@elastic/eui/src/components/tabs/tabbed_content/tabbed_content';
	export { EuiTabbedContent } from '@elastic/eui/src/components/tabs/tabbed_content/tabbed_content';

}
declare module '@elastic/eui/src/components/tabs' {
	export type { EuiTabProps } from '@elastic/eui/src/components/tabs/tab';
	export { EuiTab } from '@elastic/eui/src/components/tabs/tab';
	export type { EuiTabsProps } from '@elastic/eui/src/components/tabs/tabs';
	export { EuiTabs } from '@elastic/eui/src/components/tabs/tabs';
	export type { EuiTabbedContentTab, EuiTabbedContentProps, } from '@elastic/eui/src/components/tabs/tabbed_content';
	export { EuiTabbedContent } from '@elastic/eui/src/components/tabs/tabbed_content';

}
declare module '@elastic/eui/src/components/date_picker/types' {
	import { ReactElement } from 'react';
	export interface DurationRange {
	    end: ShortDate;
	    label?: string;
	    start: ShortDate;
	}
	export type TimeUnitId = 's' | 'm' | 'h' | 'd' | 'w' | 'M' | 'y';
	export type TimeUnitFromNowId = 's+' | 'm+' | 'h+' | 'd+' | 'w+' | 'M+' | 'y+';
	export type TimeUnitAllId = TimeUnitId | TimeUnitFromNowId;
	export type TimeUnitLabel = 'second' | 'minute' | 'hour' | 'day' | 'week' | 'month' | 'year';
	export type TimeUnitLabelPlural = 'seconds' | 'minutes' | 'hours' | 'days' | 'weeks' | 'months' | 'years';
	export type AbsoluteDateMode = 'absolute';
	export type RelativeDateMode = 'relative';
	export type NowDateMode = 'now';
	export type DateMode = AbsoluteDateMode | RelativeDateMode | NowDateMode;
	/**
	 * String as either datemath (e.g.: now, now-15m, now-15m/m) or
	 * absolute date in the format 'YYYY-MM-DDTHH:mm:ss.SSSZ'
	 */
	export type ShortDate = NowDateMode | string;
	export type Milliseconds = number;
	export interface RelativeParts {
	    count: number;
	    round: boolean;
	    roundUnit?: TimeUnitId;
	    unit: string;
	}
	export interface RelativeOption {
	    text: string;
	    value: TimeUnitAllId;
	}
	export const REFRESH_UNIT_OPTIONS: readonly ["s", "m", "h"];
	export type RefreshUnitsOptions = (typeof REFRESH_UNIT_OPTIONS)[number];
	export type OnRefreshChangeProps = {
	    isPaused: boolean;
	    refreshInterval: number;
	    intervalUnits: RefreshUnitsOptions;
	};
	export type ApplyRefreshInterval = (args: OnRefreshChangeProps) => void;
	export interface QuickSelect {
	    timeTense: string;
	    timeValue: number;
	    timeUnits: TimeUnitId;
	}
	interface ApplyTimeArgs extends DurationRange {
	    keepPopoverOpen?: boolean;
	    quickSelect?: QuickSelect;
	}
	export type ApplyTime = (args: ApplyTimeArgs) => void;
	export interface QuickSelectPanel {
	    title: string;
	    content: ReactElement;
	}
	export {};

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/time_options' {
	import { EuiSelectOption } from '@elastic/eui/src/components/form';
	import { TimeUnitId, RelativeOption, DurationRange } from '@elastic/eui/src/components/date_picker/types';
	export const LAST = "last";
	export const NEXT = "next";
	export type TimeOptions = {
	    timeTenseOptions: EuiSelectOption[];
	    timeUnitsOptions: EuiSelectOption[];
	    relativeOptions: RelativeOption[];
	    relativeRoundingLabels: {
	        [id in TimeUnitId]: string;
	    };
	    refreshUnitsOptions: EuiSelectOption[];
	    commonDurationRanges: DurationRange[];
	};
	/**
	 * i18n'd time options, mostly used in EuiSelects (except for a few cases)
	 * used in EuiSuperDatePicker child sub-components
	 */
	export const useI18nTimeOptions: () => TimeOptions;
	export const RenderI18nTimeOptions: (props: {
	    children: (args: TimeOptions) => any;
	}) => any;

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/relative_utils' {
	import { TimeUnitId, RelativeParts } from '@elastic/eui/src/components/date_picker/types';
	export const relativeUnitsFromLargestToSmallest: TimeUnitId[];
	export function parseRelativeParts(value: string): RelativeParts;
	export const toRelativeStringFromParts: (relativeParts: RelativeParts) => string;

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/date_modes' {
	import { AbsoluteDateMode, RelativeDateMode, NowDateMode, ShortDate } from '@elastic/eui/src/components/date_picker/types';
	export const DATE_MODES: {
	    ABSOLUTE: AbsoluteDateMode;
	    RELATIVE: RelativeDateMode;
	    NOW: NowDateMode;
	};
	export const INVALID_DATE = "invalid_date";
	export function getDateMode(value: ShortDate): "absolute" | "relative" | "now";
	export function toAbsoluteString(value: string, roundUp?: boolean): string;
	export function toRelativeString(value: string): string;

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/relative_tab' {
	import { FunctionComponent } from 'react';
	import { LocaleSpecifier } from 'moment';
	import { TimeOptions } from '@elastic/eui/src/components/date_picker/super_date_picker/time_options';
	import { EuiDatePopoverContentProps } from '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content';
	export interface EuiRelativeTabProps {
	    dateFormat: string;
	    locale?: LocaleSpecifier;
	    value: string;
	    onChange: EuiDatePopoverContentProps['onChange'];
	    roundUp?: boolean;
	    labelPrefix: string;
	    timeOptions: TimeOptions;
	}
	export const EuiRelativeTab: FunctionComponent<EuiRelativeTabProps>;

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDatePopoverContentStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDatePopoverContent: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content' {
	import { FunctionComponent } from 'react';
	import { LocaleSpecifier, Moment } from 'moment';
	import { TimeOptions } from '@elastic/eui/src/components/date_picker/super_date_picker/time_options';
	export interface EuiDatePopoverContentProps {
	    value: string;
	    onChange: (date: string) => void;
	    canRoundRelativeUnits?: boolean;
	    roundUp?: boolean;
	    dateFormat: string;
	    timeFormat: string;
	    locale?: LocaleSpecifier;
	    position: 'start' | 'end';
	    utcOffset?: number;
	    minDate?: Moment;
	    maxDate?: Moment;
	    timeOptions: TimeOptions;
	}
	export const EuiDatePopoverContent: FunctionComponent<EuiDatePopoverContentProps>;

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/absolute_tab.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiAbsoluteTabDateFormStyles: (euiThemeContext: UseEuiTheme) => {
	    euiAbsoluteTabDateForm: import("@emotion/utils").SerializedStyles;
	    euiAbsoluteTabDateForm__submit: import("@emotion/utils").SerializedStyles;
	    euiAbsoluteTabDateForm__row: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/absolute_tab' {
	import { FunctionComponent } from 'react';
	import { Moment, LocaleSpecifier } from 'moment';
	import { EuiDatePopoverContentProps } from '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content';
	export interface EuiAbsoluteTabProps {
	    dateFormat: string;
	    timeFormat: string;
	    locale?: LocaleSpecifier;
	    value: string;
	    onChange: EuiDatePopoverContentProps['onChange'];
	    roundUp: boolean;
	    labelPrefix: string;
	    utcOffset?: number;
	    minDate?: Moment;
	    maxDate?: Moment;
	}
	export const EuiAbsoluteTab: FunctionComponent<EuiAbsoluteTabProps>;

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/pretty_duration' {
	import React from 'react';
	import moment from 'moment';
	import { DurationRange, ShortDate } from '@elastic/eui/src/components/date_picker/types';
	export const useFormatTimeString: (timeString: string, dateFormat: string, options?: {
	    locale?: moment.LocaleSpecifier | undefined;
	    roundUp?: boolean | undefined;
	    canRoundRelativeUnits?: boolean | undefined;
	} | undefined) => string;
	/**
	 * Pretty duration hook+component
	 */
	interface PrettyDurationProps {
	    timeFrom: ShortDate;
	    timeTo: ShortDate;
	    quickRanges?: DurationRange[];
	    dateFormat: string;
	}
	export const usePrettyDuration: ({ timeFrom, timeTo, quickRanges, dateFormat, }: PrettyDurationProps) => string;
	export const PrettyDuration: React.FC<PrettyDurationProps>;
	export const showPrettyDuration: (timeFrom: ShortDate, timeTo: ShortDate, quickRanges: DurationRange[]) => boolean;
	export {};

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/super_date_picker.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiSuperDatePickerStyles: (euiThemeContext: UseEuiTheme) => {
	    euiSuperDatePicker: import("@emotion/utils").SerializedStyles;
	    widths: {
	        restricted: import("@emotion/utils").SerializedStyles;
	        full: import("@emotion/utils").SerializedStyles;
	        auto: import("@emotion/utils").SerializedStyles;
	    };
	    noUpdateButton: {
	        restricted: string;
	        auto: string;
	        full: string;
	    };
	    isAutoRefreshOnly: {
	        restricted: string;
	        auto: string;
	        full: string;
	    };
	    isQuickSelectOnly: import("@emotion/utils").SerializedStyles;
	    euiSuperDatePicker__range: import("@emotion/utils").SerializedStyles;
	    euiSuperDatePicker__rangeInput: import("@emotion/utils").SerializedStyles;
	    euiSuperDatePicker__prettyFormat: import("@emotion/utils").SerializedStyles;
	    states: {
	        euiSuperDatePicker__formControlLayout: import("@emotion/utils").SerializedStyles;
	        default: import("@emotion/utils").SerializedStyles;
	        disabled: import("@emotion/utils").SerializedStyles;
	        invalid: import("@emotion/utils").SerializedStyles;
	        needsUpdating: import("@emotion/utils").SerializedStyles;
	    };
	};
	export const _buttonStyles: (euiThemeContext: UseEuiTheme) => import("@emotion/utils").SerializedStyles;

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDatePopoverButtonStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDatePopoverButton: import("@emotion/utils").SerializedStyles;
	    now: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button' {
	import { FunctionComponent, ButtonHTMLAttributes, MouseEventHandler } from 'react';
	import { LocaleSpecifier, Moment } from 'moment';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiPopoverProps } from '@elastic/eui/src/components/popover';
	import { TimeOptions } from '@elastic/eui/src/components/date_picker/super_date_picker/time_options';
	import { EuiDatePopoverContentProps } from '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content';
	export interface EuiDatePopoverButtonProps {
	    className?: string;
	    buttonProps?: CommonProps & ButtonHTMLAttributes<HTMLButtonElement>;
	    dateFormat: string;
	    isDisabled?: boolean;
	    isInvalid?: boolean;
	    isOpen: boolean;
	    needsUpdating?: boolean;
	    locale?: LocaleSpecifier;
	    onChange: EuiDatePopoverContentProps['onChange'];
	    onPopoverClose: EuiPopoverProps['closePopover'];
	    onPopoverToggle: MouseEventHandler<HTMLButtonElement>;
	    position: 'start' | 'end';
	    canRoundRelativeUnits?: boolean;
	    roundUp?: boolean;
	    timeFormat: string;
	    value: string;
	    utcOffset?: number;
	    minDate?: Moment;
	    maxDate?: Moment;
	    compressed?: boolean;
	    timeOptions: TimeOptions;
	}
	export const EuiDatePopoverButton: FunctionComponent<EuiDatePopoverButtonProps>;

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/date_popover' {
	export type { EuiAbsoluteTabProps } from '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/absolute_tab';
	export { EuiAbsoluteTab } from '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/absolute_tab';
	export type { EuiDatePopoverButtonProps } from '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button';
	export { EuiDatePopoverButton } from '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/date_popover_button';
	export type { EuiDatePopoverContentProps } from '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content';
	export { EuiDatePopoverContent } from '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content';
	export type { EuiRelativeTabProps } from '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/relative_tab';
	export { EuiRelativeTab } from '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/relative_tab';

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_panel.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiQuickSelectPanelStyles: (euiThemeContext: UseEuiTheme) => {
	    euiQuickSelectPanel: import("@emotion/utils").SerializedStyles;
	    euiQuickSelectPanel__title: import("@emotion/utils").SerializedStyles;
	    euiQuickSelectPanel__section: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_panel' {
	import { FunctionComponent, ReactNode } from 'react';
	import type { CommonProps } from '@elastic/eui/src/components/common'; type EuiQuickSelectPanelProps = CommonProps & {
	    component?: 'div' | 'fieldset';
	    title?: ReactNode;
	    titleId?: string;
	    children?: ReactNode;
	};
	export const EuiQuickSelectPanel: FunctionComponent<EuiQuickSelectPanelProps>;
	export {};

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/commonly_used_time_ranges' {
	import { FunctionComponent } from 'react';
	import { DurationRange, ApplyTime } from '@elastic/eui/src/components/date_picker/types';
	export interface EuiCommonlyUsedTimeRangesProps {
	    applyTime: ApplyTime;
	    commonlyUsedRanges: DurationRange[];
	}
	export const EuiCommonlyUsedTimeRanges: FunctionComponent<EuiCommonlyUsedTimeRangesProps>;

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiQuickSelectPopoverStyles: (euiThemeContext: UseEuiTheme) => {
	    euiQuickSelectPopover: import("@emotion/utils").SerializedStyles;
	    euiQuickSelectPopoverButton: import("@emotion/utils").SerializedStyles;
	    euiQuickSelectPopoverButton__content: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_utils' {
	import { QuickSelect } from '@elastic/eui/src/components/date_picker/types';
	/**
	 * This function returns time value, time unit and time tense for a given time string.
	 *
	 * For example: for `now-40m` it will parse output as time value to `40` time unit to `m` and time unit to `last`.
	 *
	 * If given a datetime string it will return a default value.
	 *
	 * If the given string is in the format such as `now/d` it will parse the string to moment object and find the time value, time unit and time tense using moment
	 *
	 * This function accepts two strings start and end time. I the start value is now then it uses the end value to parse.
	 */
	export const parseTimeParts: (start: string, end: string) => QuickSelect;

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select' {
	import React, { Component, ChangeEventHandler, KeyboardEventHandler } from 'react';
	import moment from 'moment';
	import { ApplyTime, QuickSelect } from '@elastic/eui/src/components/date_picker/types';
	import { TimeOptions } from '@elastic/eui/src/components/date_picker/super_date_picker/time_options'; type EuiQuickSelectState = QuickSelect;
	export interface EuiQuickSelectProps {
	    applyTime: ApplyTime;
	    start: string;
	    end: string;
	    prevQuickSelect?: EuiQuickSelectState;
	    timeOptions: TimeOptions;
	}
	export class EuiQuickSelect extends Component<EuiQuickSelectProps, EuiQuickSelectState> {
	    constructor(props: EuiQuickSelectProps);
	    generateId: (idSuffix?: string) => string;
	    timeSelectionId: string;
	    legendId: string;
	    onTimeTenseChange: ChangeEventHandler<HTMLSelectElement>;
	    onTimeValueChange: ChangeEventHandler<HTMLInputElement>;
	    onTimeUnitsChange: ChangeEventHandler<HTMLSelectElement>;
	    handleKeyDown: KeyboardEventHandler<HTMLElement>;
	    applyQuickSelect: () => void;
	    getBounds: () => {
	        min: moment.Moment;
	        max: moment.Moment;
	    };
	    stepForward: () => void;
	    stepBackward: () => void;
	    render(): React.JSX.Element;
	}
	export {};

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/recently_used' {
	import { FunctionComponent } from 'react';
	import { DurationRange, ApplyTime } from '@elastic/eui/src/components/date_picker/types';
	export interface EuiRecentlyUsedProps {
	    applyTime: ApplyTime;
	    commonlyUsedRanges: DurationRange[];
	    dateFormat: string;
	    recentlyUsedRanges?: DurationRange[];
	}
	export const EuiRecentlyUsed: FunctionComponent<EuiRecentlyUsedProps>;

}
declare module '@elastic/eui/src/components/date_picker/auto_refresh/refresh_interval' {
	import React, { Component, ChangeEventHandler, KeyboardEventHandler } from 'react';
	import { TimeOptions } from '@elastic/eui/src/components/date_picker/super_date_picker/time_options';
	import { Milliseconds, RefreshUnitsOptions, ApplyRefreshInterval } from '@elastic/eui/src/components/date_picker/types';
	export type EuiRefreshIntervalProps = {
	    /**
	     * Is refresh paused or running.
	     */
	    isPaused?: boolean;
	    /**
	     * Refresh interval in milliseconds.
	     */
	    refreshInterval?: Milliseconds;
	    /**
	     * Allows specifying a minimum interval in milliseconds
	     */
	    minInterval?: Milliseconds;
	    /**
	     * By default, refresh interval units will be rounded up to next largest unit of time
	     * (for example, 90 seconds will become 2m).
	     *
	     * If you do not want this behavior, you can manually control the rendered unit via this prop.
	     */
	    intervalUnits?: RefreshUnitsOptions;
	    /**
	     * Passes back the updated state of `isPaused`, `refreshInterval`, and `intervalUnits`.
	     */
	    onRefreshChange: ApplyRefreshInterval;
	};
	interface EuiRefreshIntervalState {
	    value: number | '';
	    units: RefreshUnitsOptions;
	    min?: Milliseconds;
	}
	export class EuiRefreshInterval extends Component<EuiRefreshIntervalProps, EuiRefreshIntervalState> {
	    static defaultProps: {
	        isPaused: boolean;
	        refreshInterval: number;
	        minInterval: number;
	    };
	    state: EuiRefreshIntervalState;
	    generateId: (idSuffix?: string) => string;
	    refreshSelectionId: string;
	    onValueChange: ChangeEventHandler<HTMLInputElement>;
	    onUnitsChange: ChangeEventHandler<HTMLSelectElement>;
	    startRefresh: () => void;
	    handleKeyDown: KeyboardEventHandler<HTMLElement>;
	    applyRefreshInterval: () => void;
	    toggleRefresh: () => void;
	    renderScreenReaderText: (refreshUnitsOptions: TimeOptions['refreshUnitsOptions']) => React.JSX.Element;
	    render(): React.JSX.Element;
	}
	export {};

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover' {
	import { FunctionComponent, ReactNode, ReactElement } from 'react';
	import { EuiQuickSelect } from '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select';
	import { EuiCommonlyUsedTimeRanges } from '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/commonly_used_time_ranges';
	import { EuiRecentlyUsed } from '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/recently_used';
	import { EuiRefreshInterval } from '@elastic/eui/src/components/date_picker/auto_refresh/refresh_interval';
	import { TimeOptions } from '@elastic/eui/src/components/date_picker/super_date_picker/time_options';
	import { DurationRange, ApplyRefreshInterval, RefreshUnitsOptions, ApplyTime, QuickSelect, QuickSelectPanel, Milliseconds } from '@elastic/eui/src/components/date_picker/types';
	export type CustomQuickSelectRenderOptions = {
	    quickSelect: ReactElement<typeof EuiQuickSelect>;
	    commonlyUsedRanges: ReactElement<typeof EuiCommonlyUsedTimeRanges>;
	    recentlyUsedRanges: ReactElement<typeof EuiRecentlyUsed>;
	    refreshInterval?: ReactElement<typeof EuiRefreshInterval>;
	    customQuickSelectPanels?: ReactNode;
	};
	export interface EuiQuickSelectPopoverProps {
	    applyRefreshInterval?: ApplyRefreshInterval;
	    applyTime: ApplyTime;
	    commonlyUsedRanges: DurationRange[];
	    customQuickSelectPanels?: QuickSelectPanel[];
	    customQuickSelectRender?: (options: CustomQuickSelectRenderOptions) => ReactNode;
	    dateFormat: string;
	    end: string;
	    isDisabled: boolean;
	    isPaused: boolean;
	    recentlyUsedRanges: DurationRange[];
	    refreshInterval: Milliseconds;
	    refreshMinInterval?: Milliseconds;
	    intervalUnits?: RefreshUnitsOptions;
	    start: string;
	    timeOptions: TimeOptions;
	}
	export const EuiQuickSelectPopover: FunctionComponent<EuiQuickSelectPopoverProps>;
	export const EuiQuickSelectPanels: FunctionComponent<Omit<EuiQuickSelectPopoverProps, 'isDisabled'> & {
	    prevQuickSelect?: QuickSelect;
	}>;

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover' {
	export type { EuiCommonlyUsedTimeRangesProps } from '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/commonly_used_time_ranges';
	export { EuiCommonlyUsedTimeRanges } from '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/commonly_used_time_ranges';
	export type { EuiQuickSelectPopoverProps } from '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover';
	export { EuiQuickSelectPopover } from '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover';
	export type { EuiQuickSelectProps } from '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select';
	export { EuiQuickSelect } from '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select';
	export type { EuiRecentlyUsedProps } from '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/recently_used';
	export { EuiRecentlyUsed } from '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/recently_used';

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/async_interval' {
	export class AsyncInterval {
	    timeoutId: number | null;
	    isStopped: boolean;
	    __pendingFn: Function;
	    constructor(fn: Function, refreshInterval: number);
	    setAsyncInterval: (fn: Function, milliseconds: number) => void;
	    stop: () => void;
	}

}
declare module '@elastic/eui/src/components/date_picker/date_picker_range.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiDatePickerRangeStyles: {
	    euiDatePickerRange: import("@emotion/utils").SerializedStyles;
	};
	export const euiDatePickerRangeInlineStyles: (euiThemeContext: UseEuiTheme) => {
	    euiDatePickerRangeInline: import("@emotion/utils").SerializedStyles;
	    responsive: import("@emotion/utils").SerializedStyles;
	    responsiveWithTimeSelect: import("@emotion/utils").SerializedStyles;
	    shadow: import("@emotion/utils").SerializedStyles;
	    formLayout: {
	        noShadow: import("@emotion/utils").SerializedStyles;
	        shadow: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/date_picker/date_picker_range' {
	import { FocusEventHandler, FunctionComponent, ReactNode, ReactElement } from 'react';
	import { EuiFormControlLayoutDelimitedProps } from '@elastic/eui/src/components/form';
	import { IconType } from '@elastic/eui/src/components/icon';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiDatePickerProps } from '@elastic/eui/src/components/date_picker/date_picker';
	export type EuiDatePickerRangeProps = CommonProps & Pick<EuiFormControlLayoutDelimitedProps, 'isLoading' | 'isInvalid' | 'readOnly' | 'fullWidth' | 'compressed' | 'prepend' | 'append'> & {
	    /**
	     * Including any children will replace all innards with the provided children
	     */
	    children?: ReactNode;
	    /**
	     * The end date `EuiDatePicker` element
	     */
	    endDateControl: ReactElement;
	    /**
	     * The start date `EuiDatePicker` element
	     */
	    startDateControl: ReactElement;
	    /**
	     * Pass either an icon type or set to `false` to remove icon entirely
	     */
	    iconType?: boolean | IconType;
	    /**
	     * Won't apply any additional props to start and end date components
	     */
	    isCustom?: boolean;
	    /**
	     * Passes through to each control
	     */
	    disabled?: boolean;
	    /**
	     * Displays both date picker calendars directly on the page.
	     * Will not render `iconType`, `fullWidth`, `prepend`, or `append`.
	     *
	     * Passes through to each control if `isCustom` is not set.
	     */
	    inline?: EuiDatePickerProps['inline'];
	    /**
	     * Allows turning the shadow off if using the `inline` prop
	     */
	    shadow?: EuiDatePickerProps['shadow'];
	    /**
	     * Triggered whenever the start or end controls are blurred
	     */
	    onBlur?: FocusEventHandler<HTMLInputElement>;
	    /**
	     * Triggered whenever the start or end controls are focused
	     */
	    onFocus?: FocusEventHandler<HTMLInputElement>;
	};
	export const EuiDatePickerRange: FunctionComponent<EuiDatePickerRangeProps>;

}
declare module '@elastic/eui/src/components/responsive/hide_for' {
	import { ReactNode, FunctionComponent } from 'react';
	import { EuiBreakpointSize } from '@elastic/eui/src/services';
	export type EuiHideForBreakpoints = EuiBreakpointSize;
	export interface EuiHideForProps {
	    /**
	     * Required otherwise nothing ever gets returned
	     */
	    children: ReactNode;
	    /**
	     * List of all the responsive sizes to hide the children for.
	     * Array of #EuiBreakpointSize
	     */
	    sizes: EuiHideForBreakpoints[] | 'all' | 'none';
	}
	export const EuiHideFor: FunctionComponent<EuiHideForProps>;

}
declare module '@elastic/eui/src/components/responsive/show_for' {
	import { ReactNode, FunctionComponent } from 'react';
	import { EuiBreakpointSize } from '@elastic/eui/src/services';
	export type EuiShowForBreakpoints = EuiBreakpointSize;
	export interface EuiShowForProps {
	    /**
	     * Required otherwise nothing ever gets returned
	     */
	    children: ReactNode;
	    /**
	     * List of all the responsive sizes to show the children for.
	     * Array of #EuiBreakpointSize
	     */
	    sizes: EuiShowForBreakpoints[] | 'all' | 'none';
	}
	export const EuiShowFor: FunctionComponent<EuiShowForProps>;

}
declare module '@elastic/eui/src/components/responsive' {
	export type { EuiHideForProps } from '@elastic/eui/src/components/responsive/hide_for';
	export { EuiHideFor } from '@elastic/eui/src/components/responsive/hide_for';
	export type { EuiShowForProps } from '@elastic/eui/src/components/responsive/show_for';
	export { EuiShowFor } from '@elastic/eui/src/components/responsive/show_for';

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/super_update_button' {
	import React, { Component, MouseEventHandler, ElementRef, ReactNode } from 'react';
	import { EuiButtonProps } from '@elastic/eui/src/components/button';
	import { EuiToolTip, EuiToolTipProps } from '@elastic/eui/src/components/tool_tip';
	import { EuiBreakpointSize } from '@elastic/eui/src/services/breakpoint'; type ToolTipRef = ElementRef<typeof EuiToolTip> | null; type EuiSuperUpdateButtonInternalProps = {
	    isDisabled?: boolean;
	    isLoading?: boolean;
	    needsUpdate?: boolean;
	    onClick: MouseEventHandler<HTMLButtonElement>;
	};
	export type EuiSuperUpdateButtonProps = {
	    /**
	     * Overrides the default button label with a custom React node.
	     *
	     * When defined, you're responsible for updating the custom label
	     * when the data needs updating (the `needsUpdate` prop)
	     * or is loading (the `isLoading` prop).
	     */
	    children?: ReactNode;
	    /**
	     * Show the "Click to apply" tooltip
	     */
	    showTooltip?: boolean;
	    /**
	     * Passes props to `EuiToolTip`
	     */
	    toolTipProps?: Partial<EuiToolTipProps>;
	    /**
	     * Returns an IconButton instead
	     */
	    iconOnly?: boolean;
	    /**
	     * Forces state to be `iconOnly` when within provided breakpoints.
	     * Remove completely with `false` or provide your own list of breakpoints.
	     */
	    responsive?: false | EuiBreakpointSize[];
	} & Partial<Omit<EuiButtonProps, 'isDisabled' | 'isLoading' | 'onClick' | 'children'>>;
	export class EuiSuperUpdateButton extends Component<EuiSuperUpdateButtonInternalProps & EuiSuperUpdateButtonProps> {
	    static defaultProps: {
	        needsUpdate: boolean;
	        isLoading: boolean;
	        isDisabled: boolean;
	        showTooltip: boolean;
	        responsive: string[];
	        fill: boolean;
	    };
	    _isMounted: boolean;
	    tooltipTimeout: number | undefined;
	    tooltip: ToolTipRef;
	    componentWillUnmount(): void;
	    componentDidMount(): void;
	    componentDidUpdate(): void;
	    setTootipRef: (node: ToolTipRef) => void;
	    showTooltip: () => void;
	    hideTooltip: () => void;
	    render(): React.JSX.Element;
	    private renderButtonContent;
	    private renderTooltipContent;
	}
	export {};

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/pretty_interval' {
	export const usePrettyInterval: (isPaused: boolean, intervalInMs: number, options?: {
	    shortHand?: boolean | undefined;
	    unit?: "s" | "m" | "h" | "d" | undefined;
	} | undefined) => string;

}
declare module '@elastic/eui/src/components/date_picker/auto_refresh/auto_refresh' {
	import { FunctionComponent } from 'react';
	import { EuiFieldTextProps } from '@elastic/eui/src/components/form';
	import { CommonEuiButtonEmptyProps } from '@elastic/eui/src/components/button/button_empty/button_empty';
	import { EuiRefreshIntervalProps } from '@elastic/eui/src/components/date_picker/auto_refresh/refresh_interval';
	export type EuiAutoRefreshSharedProps = EuiRefreshIntervalProps & {
	    isDisabled?: boolean;
	};
	export type EuiAutoRefreshProps = EuiAutoRefreshSharedProps & {
	    /**
	     * The input is `readOnly` by default because the input value is handled by the popover form.
	     */
	    readOnly?: EuiFieldTextProps['readOnly'];
	} & Omit<EuiFieldTextProps, 'icon' | 'prepend' | 'controlOnly' | 'readOnly'>;
	export const EuiAutoRefresh: FunctionComponent<EuiAutoRefreshProps>;
	export type EuiAutoRefreshButtonProps = EuiAutoRefreshSharedProps & {
	    /**
	     * Reduces the time unit to a single letter
	     */
	    shortHand?: boolean;
	} & Omit<CommonEuiButtonEmptyProps, 'isSelected' | 'iconType' | 'iconSide' | 'iconSize' | 'onClick' | 'type'>;
	export const EuiAutoRefreshButton: FunctionComponent<EuiAutoRefreshButtonProps>;

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker/super_date_picker' {
	import React, { Component, FocusEventHandler, FunctionComponent, ReactNode } from 'react';
	import moment, { LocaleSpecifier } from 'moment';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { ShortDate, Milliseconds, DurationRange, ApplyTime, ApplyRefreshInterval, RefreshUnitsOptions, QuickSelectPanel } from '@elastic/eui/src/components/date_picker/types';
	import { TimeOptions } from '@elastic/eui/src/components/date_picker/super_date_picker/time_options';
	import { AsyncInterval } from '@elastic/eui/src/components/date_picker/super_date_picker/async_interval';
	import { EuiSuperUpdateButtonProps } from '@elastic/eui/src/components/date_picker/super_date_picker/super_update_button';
	import { CustomQuickSelectRenderOptions } from '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover/quick_select_popover';
	import { EuiDatePopoverContentProps } from '@elastic/eui/src/components/date_picker/super_date_picker/date_popover/date_popover_content';
	import { euiSuperDatePickerStyles } from '@elastic/eui/src/components/date_picker/super_date_picker/super_date_picker.styles';
	export interface OnTimeChangeProps extends DurationRange {
	    isInvalid: boolean;
	    isQuickSelection: boolean;
	}
	export interface OnRefreshProps extends DurationRange {
	    refreshInterval: number;
	}
	export type EuiSuperDatePickerProps = CommonProps & {
	    commonlyUsedRanges?: DurationRange[];
	    customQuickSelectPanels?: QuickSelectPanel[];
	    /**
	     * An optional render prop function that allows customizing the display of the Quick Select menu.
	     * This function passes all default quick select panels within an object, allowing you to
	     * re-order panels, omit certain panels entirely, or pass in your own fully custom content.
	     */
	    customQuickSelectRender?: (options: CustomQuickSelectRenderOptions) => ReactNode;
	    /**
	     * Specifies the formatted used when displaying dates and/or datetimes
	     * @default 'MMM D, YYYY @ HH:mm:ss.SSS'
	     */
	    dateFormat?: string;
	    /**
	     * Set isAutoRefreshOnly to true to limit the component to only display auto refresh content.
	     */
	    isAutoRefreshOnly?: boolean;
	    /**
	     * Accepts either a true/false boolean or an object configuration.
	     *
	     * The configuration will render the component as disabled, and allow you to
	     * customize the displayed disabled text.
	     */
	    isDisabled?: boolean | {
	        display: ReactNode;
	    };
	    isLoading?: boolean;
	    /**
	     * @default true
	     */
	    isPaused?: boolean;
	    /**
	     * Sets the overall width by adding sensible min and max widths.
	     * - `auto`: fits width to internal content / time string.
	     * - `restricted`: static width that fits the longest possible time string.
	     * - `full`: expands to 100% of the container.
	     * @default 'restricted'
	     */
	    width?: 'restricted' | 'full' | 'auto';
	    /**
	     * Reduces overall height to compressed form size
	     */
	    compressed?: boolean;
	    /**
	     * Used to localize e.g. month names, passed to `moment`
	     */
	    locale?: LocaleSpecifier;
	    /**
	     * Triggered whenever the EuiSuperDatePicker's dates are focused
	     */
	    onFocus?: FocusEventHandler;
	    /**
	     * Callback for when the refresh interval is fired.
	     * EuiSuperDatePicker will only manage a refresh interval timer when onRefresh callback is supplied
	     * If a promise is returned, the next refresh interval will not start until the promise has resolved.
	     * If the promise rejects the refresh interval will stop and the error thrown
	     */
	    onRefresh?: (props: OnRefreshProps) => void;
	    /**
	     * Callback for when the refresh interval changes.
	     * Supply onRefreshChange to show refresh interval inputs in quick select popover
	     */
	    onRefreshChange?: ApplyRefreshInterval;
	    /**
	     * Callback for when the time changes.
	     */
	    onTimeChange: (props: OnTimeChangeProps) => void;
	    recentlyUsedRanges?: DurationRange[];
	    /**
	     * Refresh interval in milliseconds
	     * @default 1000
	     */
	    refreshInterval?: Milliseconds;
	    /**
	     * Minimum refresh interval in milliseconds
	     * @default 0
	     */
	    refreshMinInterval?: Milliseconds;
	    /**
	     * By default, refresh interval units will be rounded up to next largest unit of time
	     * (for example, 90 seconds will become 2m).
	     *
	     * If you do not want this behavior, you will need to store the user-set `intervalUnits`
	     * (passed by `onRefreshChange`) and manually control it via this prop.
	     */
	    refreshIntervalUnits?: RefreshUnitsOptions;
	    /**
	     * @default 'now-15m'
	     */
	    start?: ShortDate;
	    /**
	     * @default 'now'
	     */
	    end?: ShortDate;
	    /**
	     * Defines min. date accepted as a selection (in moment format)
	     */
	    minDate?: moment.Moment;
	    /**
	     * Defines max. date accepted as a selection (in moment format)
	     */
	    maxDate?: moment.Moment;
	    /**
	     * Specifies the formatted used when displaying times
	     * @default 'HH:mm'
	     */
	    timeFormat?: string;
	    utcOffset?: number;
	    /**
	     * Set showUpdateButton to false to immediately invoke onTimeChange for all start and end changes.
	     * @default true
	     */
	    showUpdateButton?: boolean | 'iconOnly';
	    /**
	     * Hides the actual input reducing to just the quick select button.
	     */
	    isQuickSelectOnly?: boolean;
	    /**
	     * Props passed to the update button #EuiSuperUpdateButtonProps
	     */
	    updateButtonProps?: EuiSuperUpdateButtonProps;
	    /**
	     * By default, relative units will be rounded up to next largest unit of time
	     * (for example, 90 minutes will become ~ 2 hours).
	     *
	     * If you do not want this behavior and instead wish to keep the exact units
	     * input by the user, set this flag to `false`.
	     */
	    canRoundRelativeUnits?: boolean;
	}; type EuiSuperDatePickerInternalProps = EuiSuperDatePickerProps & {
	    memoizedStyles: ReturnType<typeof euiSuperDatePickerStyles>;
	    timeOptions: TimeOptions;
	    commonlyUsedRanges: DurationRange[];
	    recentlyUsedRanges: DurationRange[];
	    start: ShortDate;
	    end: ShortDate;
	    refreshInterval: Milliseconds;
	    dateFormat: string;
	    timeFormat: string;
	    isPaused: boolean;
	};
	interface EuiSuperDatePickerState {
	    end: ShortDate;
	    hasChanged: boolean;
	    isEndDatePopoverOpen: boolean;
	    isInvalid: boolean;
	    isStartDatePopoverOpen: boolean;
	    prevProps: {
	        end: ShortDate;
	        start: ShortDate;
	    };
	    showPrettyDuration: boolean;
	    start: ShortDate;
	}
	export class EuiSuperDatePickerInternal extends Component<EuiSuperDatePickerInternalProps, EuiSuperDatePickerState> {
	    static defaultProps: {
	        dateFormat: string;
	        end: string;
	        isAutoRefreshOnly: boolean;
	        isDisabled: boolean;
	        isPaused: boolean;
	        recentlyUsedRanges: never[];
	        refreshInterval: number;
	        showUpdateButton: boolean;
	        canRoundRelativeUnits: boolean;
	        start: string;
	        timeFormat: string;
	        width: string;
	    };
	    asyncInterval?: AsyncInterval;
	    state: EuiSuperDatePickerState;
	    static getDerivedStateFromProps(nextProps: EuiSuperDatePickerInternalProps, prevState: EuiSuperDatePickerState): {
	        prevProps: {
	            start: string;
	            end: string;
	        };
	        start: string;
	        end: string;
	        isInvalid: boolean;
	        hasChanged: boolean;
	        showPrettyDuration: boolean;
	    } | null;
	    setTime: ({ end, start }: DurationRange) => void;
	    componentDidMount: () => void;
	    componentDidUpdate: () => void;
	    componentWillUnmount: () => void;
	    setStart: EuiDatePopoverContentProps['onChange'];
	    setEnd: EuiDatePopoverContentProps['onChange'];
	    applyTime: () => void;
	    applyQuickTime: ApplyTime;
	    hidePrettyDuration: () => void;
	    onStartDatePopoverToggle: () => void;
	    onStartDatePopoverClose: () => void;
	    onEndDatePopoverToggle: () => void;
	    onEndDatePopoverClose: () => void;
	    onRefreshChange: ApplyRefreshInterval;
	    stopInterval: () => void;
	    startInterval: (refreshInterval: number) => void;
	    renderQuickSelect: () => React.JSX.Element;
	    renderDatePickerRange: () => React.JSX.Element;
	    handleClickUpdateButton: () => void;
	    renderUpdateButton: () => React.JSX.Element | null;
	    render(): React.JSX.Element;
	}
	export const EuiSuperDatePicker: FunctionComponent<EuiSuperDatePickerProps>;
	export {};

}
declare module '@elastic/eui/src/components/date_picker/super_date_picker' {
	export * from '@elastic/eui/src/components/date_picker/super_date_picker/date_popover';
	export * from '@elastic/eui/src/components/date_picker/super_date_picker/quick_select_popover';
	export { AsyncInterval } from '@elastic/eui/src/components/date_picker/super_date_picker/async_interval';
	export type { EuiSuperDatePickerProps, OnTimeChangeProps, OnRefreshProps, } from '@elastic/eui/src/components/date_picker/super_date_picker/super_date_picker';
	export { EuiSuperDatePicker } from '@elastic/eui/src/components/date_picker/super_date_picker/super_date_picker';
	export type { EuiSuperUpdateButtonProps } from '@elastic/eui/src/components/date_picker/super_date_picker/super_update_button';
	export { EuiSuperUpdateButton } from '@elastic/eui/src/components/date_picker/super_date_picker/super_update_button';
	export { PrettyDuration, usePrettyDuration } from '@elastic/eui/src/components/date_picker/super_date_picker/pretty_duration';

}
declare module '@elastic/eui/src/components/date_picker/auto_refresh' {
	export type { EuiAutoRefreshProps, EuiAutoRefreshButtonProps, EuiAutoRefreshSharedProps, } from '@elastic/eui/src/components/date_picker/auto_refresh/auto_refresh';
	export { EuiAutoRefresh, EuiAutoRefreshButton } from '@elastic/eui/src/components/date_picker/auto_refresh/auto_refresh';
	export type { EuiRefreshIntervalProps } from '@elastic/eui/src/components/date_picker/auto_refresh/refresh_interval';
	export { EuiRefreshInterval } from '@elastic/eui/src/components/date_picker/auto_refresh/refresh_interval';

}
declare module '@elastic/eui/src/components/date_picker' {
	export * from '@elastic/eui/src/components/date_picker/super_date_picker';
	export * from '@elastic/eui/src/components/date_picker/auto_refresh';
	export type { EuiDatePickerProps } from '@elastic/eui/src/components/date_picker/date_picker';
	export { EuiDatePicker } from '@elastic/eui/src/components/date_picker/date_picker';
	export type { EuiDatePickerRangeProps } from '@elastic/eui/src/components/date_picker/date_picker_range';
	export { EuiDatePickerRange } from '@elastic/eui/src/components/date_picker/date_picker_range';
	export type { ApplyTime, DurationRange as EuiSuperDatePickerCommonRange, DurationRange as EuiSuperDatePickerDurationRange, DurationRange as EuiSuperDatePickerRecentRange, TimeUnitId, TimeUnitFromNowId, TimeUnitLabel, TimeUnitLabelPlural, AbsoluteDateMode, RelativeDateMode, NowDateMode, DateMode, OnRefreshChangeProps, RefreshUnitsOptions, ShortDate, RelativeParts, RelativeOption, QuickSelect, QuickSelectPanel as EuiSuperDatePickerQuickSelectPanel, } from '@elastic/eui/src/components/date_picker/types';

}
declare module '@elastic/eui/src/components/delay_hide/delay_hide' {
	import { Component, ReactNode } from 'react';
	export interface EuiDelayHideProps {
	    hide: boolean;
	    minimumDuration: number;
	    render: () => ReactNode;
	}
	interface EuiDelayHideState {
	    hide: boolean;
	    countdownExpired?: boolean;
	}
	export class EuiDelayHide extends Component<EuiDelayHideProps, EuiDelayHideState> {
	    static defaultProps: {
	        hide: boolean;
	        minimumDuration: number;
	    };
	    static getDerivedStateFromProps(nextProps: EuiDelayHideProps, prevState: EuiDelayHideState): {
	        hide: boolean;
	        countdownExpired: boolean | undefined;
	    };
	    state: {
	        hide: boolean;
	        countdownExpired: boolean;
	    };
	    private timeoutId?;
	    componentDidMount(): void;
	    componentDidUpdate(prevProps: EuiDelayHideProps): void;
	    componentWillUnmount(): void;
	    startCountdown: () => void;
	    finishCountdown: () => void;
	    render(): ReactNode;
	}
	export {};

}
declare module '@elastic/eui/src/components/delay_hide' {
	export type { EuiDelayHideProps } from '@elastic/eui/src/components/delay_hide/delay_hide';
	export { EuiDelayHide } from '@elastic/eui/src/components/delay_hide/delay_hide';

}
declare module '@elastic/eui/src/components/empty_prompt/empty_prompt.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiEmptyPromptStyles: (euiThemeContext: UseEuiTheme) => {
	    euiEmptyPrompt: import("@emotion/utils").SerializedStyles;
	    vertical: import("@emotion/utils").SerializedStyles;
	    horizontal: import("@emotion/utils").SerializedStyles;
	    main: {
	        horizontalPadding: {
	            none: null;
	            s: import("@emotion/utils").SerializedStyles;
	            m: import("@emotion/utils").SerializedStyles;
	            l: import("@emotion/utils").SerializedStyles;
	        };
	        none: null;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	        l: import("@emotion/utils").SerializedStyles;
	        euiEmptyPrompt__main: import("@emotion/utils").SerializedStyles;
	        vertical: import("@emotion/utils").SerializedStyles;
	        horizontal: import("@emotion/utils").SerializedStyles;
	    };
	    content: {
	        euiEmptyPrompt__content: import("@emotion/utils").SerializedStyles;
	        vertical: import("@emotion/utils").SerializedStyles;
	        horizontal: import("@emotion/utils").SerializedStyles;
	    };
	    icon: {
	        euiEmptyPrompt__icon: import("@emotion/utils").SerializedStyles;
	        vertical: import("@emotion/utils").SerializedStyles;
	        horizontal: import("@emotion/utils").SerializedStyles;
	    };
	    actions: {
	        euiEmptyPrompt__actions: import("@emotion/utils").SerializedStyles;
	        vertical: import("@emotion/utils").SerializedStyles;
	        horizontal: import("@emotion/utils").SerializedStyles;
	    };
	    footer: {
	        none: null;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	        l: import("@emotion/utils").SerializedStyles;
	        euiEmptyPrompt__footer: import("@emotion/utils").SerializedStyles;
	        roundedBorders: import("@emotion/utils").SerializedStyles;
	        transparent: import("@emotion/utils").SerializedStyles;
	        plain: import("@emotion/utils").SerializedStyles;
	        subdued: import("@emotion/utils").SerializedStyles;
	        primary: import("@emotion/utils").SerializedStyles;
	        accent: import("@emotion/utils").SerializedStyles;
	        danger: import("@emotion/utils").SerializedStyles;
	        warning: import("@emotion/utils").SerializedStyles;
	        success: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/empty_prompt/empty_prompt' {
	import { FunctionComponent, ReactElement, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiTitleSize } from '@elastic/eui/src/components/title';
	import { IconColor, IconType } from '@elastic/eui/src/components/icon';
	import { _EuiPanelDivlike } from '@elastic/eui/src/components/panel/panel';
	export const PADDING_SIZES: readonly ["none", "s", "m", "l"];
	export type PaddingSize = (typeof PADDING_SIZES)[number];
	export type EuiEmptyPromptProps = CommonProps & Omit<_EuiPanelDivlike, 'borderRadius' | 'grow' | 'panelRef' | 'paddingSize' | 'title' | 'element'> & {
	    iconType?: IconType;
	    /**
	     * Color for `iconType` when passed as an `IconType`
	     */
	    iconColor?: IconColor;
	    /**
	     * Custom icon replacing the one generated by `iconType`
	     */
	    icon?: ReactNode;
	    /**
	     * Requires passing a single element that gets wrapped in an EuiTitle.
	     * Recommendation is a heading, preferrably an `<h2>` if in its own section
	     */
	    title?: ReactElement<any>;
	    /**
	     * Choose from one of the `EuiTitle.size` options
	     */
	    titleSize?: EuiTitleSize;
	    /**
	     * Gets wrapped in a subdued EuiText block.
	     * Recommendation is to pass typical text elements like `<p>`
	     */
	    body?: ReactNode;
	    /**
	     * Pass a single or an array of actions (buttons) that get stacked at the bottom.
	     * Recommendation is to pass the primary action first and secondary actions as empty buttons
	     */
	    actions?: ReactNode;
	    /**
	     * Optionally provide a footer. Accepts any combination of elements.
	     */
	    footer?: ReactNode;
	    /**
	     * Sets the layout. When `horizontal` the icon goes to the right column.
	     */
	    layout?: 'vertical' | 'horizontal';
	    /**
	     * Padding applied around the content and footer.
	     */
	    paddingSize?: PaddingSize;
	};
	export const EuiEmptyPrompt: FunctionComponent<EuiEmptyPromptProps>;

}
declare module '@elastic/eui/src/components/empty_prompt' {
	export type { EuiEmptyPromptProps } from '@elastic/eui/src/components/empty_prompt/empty_prompt';
	export { EuiEmptyPrompt } from '@elastic/eui/src/components/empty_prompt/empty_prompt';

}
declare module '@elastic/eui/src/components/error_boundary/error_boundary.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiErrorBoundaryStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiErrorBoundary: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/error_boundary/error_boundary' {
	import React, { Component, FunctionComponent, HTMLAttributes, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	interface EuiErrorBoundaryState {
	    hasError: boolean;
	    errorMessage?: string;
	}
	export type EuiErrorBoundaryProps = CommonProps & Omit<HTMLAttributes<HTMLDivElement>, 'onError'> & {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: ReactNode;
	    /**
	     * Callback that fires when an error is caught. Passes back the full error
	     */
	    onError?: (error: Error) => void;
	};
	export class EuiErrorBoundary extends Component<EuiErrorBoundaryProps, EuiErrorBoundaryState> {
	    constructor(props: EuiErrorBoundaryProps);
	    componentDidCatch(error: Error): void;
	    render(): string | number | boolean | Iterable<React.ReactNode> | React.JSX.Element | null | undefined;
	}
	/**
	 * Split out into a separate styling-only component for easier use of hooks,
	 * and also for internal re-use by EUI's docs/playgrounds
	 */
	export const EuiErrorMessage: FunctionComponent<CommonProps & {
	    errorMessage?: string;
	}>;
	export {};

}
declare module '@elastic/eui/src/components/error_boundary' {
	export type { EuiErrorBoundaryProps } from '@elastic/eui/src/components/error_boundary/error_boundary';
	export { EuiErrorBoundary } from '@elastic/eui/src/components/error_boundary/error_boundary';

}
declare module '@elastic/eui/src/components/expression/expression.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiExpressionStyles: (euiThemeContext: UseEuiTheme) => {
	    euiExpression: import("@emotion/utils").SerializedStyles;
	    columns: import("@emotion/utils").SerializedStyles;
	    truncate: import("@emotion/utils").SerializedStyles;
	    isClickable: import("@emotion/utils").SerializedStyles;
	    isActive: {
	        base: import("@emotion/utils").SerializedStyles;
	        subdued: import("@emotion/utils").SerializedStyles;
	        primary: import("@emotion/utils").SerializedStyles;
	        success: import("@emotion/utils").SerializedStyles;
	        warning: import("@emotion/utils").SerializedStyles;
	        danger: import("@emotion/utils").SerializedStyles;
	        accent: import("@emotion/utils").SerializedStyles;
	    };
	    subdued: import("@emotion/utils").SerializedStyles;
	    primary: import("@emotion/utils").SerializedStyles;
	    success: import("@emotion/utils").SerializedStyles;
	    warning: import("@emotion/utils").SerializedStyles;
	    danger: import("@emotion/utils").SerializedStyles;
	    accent: import("@emotion/utils").SerializedStyles;
	};
	export const euiExpressionDescriptionStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiExpression__description: import("@emotion/utils").SerializedStyles;
	    truncate: import("@emotion/utils").SerializedStyles;
	    subdued: import("@emotion/utils").SerializedStyles;
	    primary: import("@emotion/utils").SerializedStyles;
	    success: import("@emotion/utils").SerializedStyles;
	    warning: import("@emotion/utils").SerializedStyles;
	    danger: import("@emotion/utils").SerializedStyles;
	    accent: import("@emotion/utils").SerializedStyles;
	    isUppercase: import("@emotion/utils").SerializedStyles;
	    columns: import("@emotion/utils").SerializedStyles;
	};
	export const euiExpressionValueStyles: ({}: UseEuiTheme) => {
	    euiExpression__value: import("@emotion/utils").SerializedStyles;
	    truncate: import("@emotion/utils").SerializedStyles;
	    columns: import("@emotion/utils").SerializedStyles;
	};
	export const euiExpressionIconStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiExpression__icon: import("@emotion/utils").SerializedStyles;
	    columns: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/expression/expression' {
	import { ButtonHTMLAttributes, HTMLAttributes, MouseEventHandler, ReactNode, FunctionComponent } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	export const COLORS: readonly ["subdued", "primary", "success", "accent", "warning", "danger"];
	export type ExpressionColor = (typeof COLORS)[number];
	export type EuiExpressionProps = CommonProps & {
	    /**
	     * First part of the expression
	     */
	    description: ReactNode;
	    descriptionProps?: CommonProps & HTMLAttributes<HTMLSpanElement>;
	    /**
	     * Second part of the expression
	     */
	    value?: ReactNode;
	    valueProps?: CommonProps & HTMLAttributes<HTMLSpanElement>;
	    /**
	     * Color of the `description`
	     */
	    color?: ExpressionColor;
	    /**
	     * Should the `description` auto-uppercase?
	     */
	    uppercase?: boolean;
	    /**
	     * Adds an solid border at the bottom
	     */
	    isActive?: boolean;
	    /**
	     * Turns the component into a button and adds an editable style border at the bottom
	     */
	    onClick?: MouseEventHandler<HTMLButtonElement>;
	    /**
	     * Sets the display style for the expression. Defaults to `inline`
	     */
	    display?: 'inline' | 'columns';
	    /**
	     * Forces color to display as `danger` and shows an `error` icon
	     */
	    isInvalid?: boolean;
	    /**
	     * Sets a custom width for the description when using the columns layout.
	     * Set to a number for a custom width in `px`.
	     * Set to a string for a custom width in custom measurement.
	     * Defaults to `20%`
	     */
	    descriptionWidth?: number | string;
	    /**
	     * Sets how to handle the wrapping of long text.
	     */
	    textWrap?: 'break-word' | 'truncate';
	}; type Buttonlike = EuiExpressionProps & Omit<ButtonHTMLAttributes<HTMLButtonElement>, 'value'> & {
	    onClick: MouseEventHandler<HTMLButtonElement>;
	}; type Spanlike = EuiExpressionProps & Omit<HTMLAttributes<HTMLSpanElement>, 'value'>;
	export const EuiExpression: FunctionComponent<ExclusiveUnion<Buttonlike, Spanlike>>;
	export {};

}
declare module '@elastic/eui/src/components/expression' {
	export type { EuiExpressionProps } from '@elastic/eui/src/components/expression/expression';
	export { EuiExpression } from '@elastic/eui/src/components/expression/expression';

}
declare module '@elastic/eui/src/components/filter_group/filter_button.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFilterButtonDisplay: ({ euiTheme }: UseEuiTheme) => {
	    flex: string;
	    minInlineSize: string;
	};
	export const euiFilterButtonStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFilterButton: import("@emotion/utils").SerializedStyles;
	    withNext: import("@emotion/utils").SerializedStyles;
	    noGrow: import("@emotion/utils").SerializedStyles;
	    hasNotification: import("@emotion/utils").SerializedStyles;
	    hasActiveFilters: import("@emotion/utils").SerializedStyles;
	};
	export const euiFilterButtonChildStyles: ({ euiTheme }: UseEuiTheme) => {
	    content: {
	        euiFilterButton__content: import("@emotion/utils").SerializedStyles;
	        hasIcon: import("@emotion/utils").SerializedStyles;
	    };
	    text: {
	        euiFilterButton__text: import("@emotion/utils").SerializedStyles;
	        hasNotification: import("@emotion/utils").SerializedStyles;
	    };
	    notification: {
	        euiFilterButton__notification: import("@emotion/utils").SerializedStyles;
	        disabled: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/filter_group/filter_group.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFilterGroupStyles: (euiThemeContext: UseEuiTheme) => {
	    euiFilterGroup: import("@emotion/utils").SerializedStyles;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    uncompressed: import("@emotion/utils").SerializedStyles;
	    compressed: import("@emotion/utils").SerializedStyles;
	    /**
	     * Not used in EuiFilterGroup directly, but used by EuiSearchBar and consumers
	     * A fixed width is required because of the shift in widths that can be caused
	     * by the loading animation that precedes the results.
	     */
	    euiFilterGroup__popoverPanel: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/filter_group/filter_group' {
	import { HTMLAttributes, ReactNode, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiFilterGroupProps = HTMLAttributes<HTMLDivElement> & CommonProps & {
	    children?: ReactNode;
	    /**
	     * Expand the whole bar to fill its parent's width
	     */
	    fullWidth?: boolean;
	    /**
	     *  When `true`, creates a shorter height filter group matching that of `compressed` form controls
	     */
	    compressed?: boolean;
	};
	export const EuiFilterGroup: FunctionComponent<EuiFilterGroupProps>;

}
declare module '@elastic/eui/src/components/filter_group/filter_button' {
	import { FunctionComponent } from 'react';
	import { DistributiveOmit } from '@elastic/eui/src/components/common';
	import { BadgeNotificationColor } from '@elastic/eui/src/components/badge/notification_badge/badge_notification';
	import { EuiButtonEmptyProps } from '@elastic/eui/src/components/button/button_empty';
	export type EuiFilterButtonProps = {
	    /**
	     * Bolds the button if true
	     */
	    hasActiveFilters?: boolean;
	    /**
	     * Pass the total number of filters available and it will
	     * add a subdued notification badge showing the number
	     */
	    numFilters?: number;
	    /**
	     * Pass the number of selected filters and it will
	     * add a bright notification badge showing the number
	     */
	    numActiveFilters?: number;
	    /**
	     * Applies a visual state to the button useful when using with a popover.
	     */
	    isSelected?: boolean;
	    /**
	     * Should the button grow to fill its container, best used for dropdown buttons
	     */
	    grow?: boolean;
	    /**
	     * Remove border after button, good for opposite filters
	     */
	    withNext?: boolean;
	    /**
	     * Change color of the counter badge
	     */
	    badgeColor?: BadgeNotificationColor;
	} & DistributiveOmit<EuiButtonEmptyProps, 'flush' | 'size'>;
	export const EuiFilterButton: FunctionComponent<EuiFilterButtonProps>;

}
declare module '@elastic/eui/src/components/filter_group' {
	export type { EuiFilterGroupProps } from '@elastic/eui/src/components/filter_group/filter_group';
	export { EuiFilterGroup } from '@elastic/eui/src/components/filter_group/filter_group';
	export type { EuiFilterButtonProps } from '@elastic/eui/src/components/filter_group/filter_button';
	export { EuiFilterButton } from '@elastic/eui/src/components/filter_group/filter_button';
	export type { EuiFilterSelectItemProps, FilterChecked, } from '@elastic/eui/src/components/filter_group/filter_select_item';
	export { EuiFilterSelectItem } from '@elastic/eui/src/components/filter_group/filter_select_item';

}
declare module '@elastic/eui/src/components/facet/facet_button.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiFacetButtonStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiFacetButton: import("@emotion/utils").SerializedStyles;
	};
	export const euiFacetButtonTextStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiFacetButton__text: import("@emotion/utils").SerializedStyles;
	    isSelected: import("@emotion/utils").SerializedStyles;
	    unSelected: import("@emotion/utils").SerializedStyles;
	};
	export const euiFacetButtonIconStyles: () => {
	    euiFacetButton__icon: import("@emotion/utils").SerializedStyles;
	    isDisabled: import("@emotion/utils").SerializedStyles;
	};
	export const euiFacetButtonLoadingSpinnerStyles: () => {
	    euiFacetButton__loadingSpinner: import("@emotion/utils").SerializedStyles;
	};
	export const euiFacetButtonQuantityStyles: () => {
	    euiFacetButton__quantity: import("@emotion/utils").SerializedStyles;
	    isDisabled: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/facet/facet_button' {
	import { FunctionComponent, HTMLAttributes, ReactNode, RefCallback } from 'react';
	import { EuiButtonDisplayCommonProps } from '@elastic/eui/src/components/button/button_display/_button_display';
	export interface EuiFacetButtonProps extends EuiButtonDisplayCommonProps, HTMLAttributes<HTMLButtonElement> {
	    buttonRef?: RefCallback<HTMLButtonElement>;
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: ReactNode;
	    /**
	     * Any node, but preferably a `EuiIcon` or `EuiAvatar`
	     */
	    icon?: ReactNode;
	    isDisabled?: boolean;
	    /**
	     * Adds/swaps for loading spinner & disables
	     */
	    isLoading?: boolean;
	    /**
	     * Changes visual of button to indicate it's currently selected
	     */
	    isSelected?: boolean;
	    /**
	     * Adds a notification indicator for displaying the quantity provided
	     */
	    quantity?: number;
	}
	export const EuiFacetButton: FunctionComponent<EuiFacetButtonProps>;

}
declare module '@elastic/eui/src/components/facet/facet_group.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	import { EuiFacetGroupLayout } from '@elastic/eui/src/components/facet/facet_group';
	export const euiFacetGroupStyles: ({ euiTheme }: UseEuiTheme, layout: EuiFacetGroupLayout) => {
	    euiFacetGroup: import("@emotion/utils").SerializedStyles;
	    none: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    horizontal: import("@emotion/utils").SerializedStyles;
	    vertical: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/facet/facet_group' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const LAYOUTS: readonly ["vertical", "horizontal"];
	export type EuiFacetGroupLayout = (typeof LAYOUTS)[number];
	export const GUTTER_SIZES: readonly ["none", "s", "m", "l"];
	export type EuiFacetGroupGutterSizes = (typeof GUTTER_SIZES)[number];
	export type EuiFacetGroupProps = CommonProps & HTMLAttributes<HTMLDivElement> & {
	    /**
	     * Vertically in a column, or horizontally in one wrapping line
	     */
	    layout?: EuiFacetGroupLayout;
	    /**
	     * Distance between facet buttons.
	     * Horizontal layout always adds more distance horizontally between buttons.
	     */
	    gutterSize?: EuiFacetGroupGutterSizes;
	};
	export const EuiFacetGroup: FunctionComponent<EuiFacetGroupProps>;

}
declare module '@elastic/eui/src/components/facet' {
	export type { EuiFacetButtonProps } from '@elastic/eui/src/components/facet/facet_button';
	export { EuiFacetButton } from '@elastic/eui/src/components/facet/facet_button';
	export type { EuiFacetGroupProps } from '@elastic/eui/src/components/facet/facet_group';
	export { EuiFacetGroup } from '@elastic/eui/src/components/facet/facet_group';

}
declare module '@elastic/eui/src/components/header/header_breadcrumbs/header_breadcrumbs.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiHeaderBreadcrumbsStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiHeaderBreadcrumbs: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/header/header_breadcrumbs/header_breadcrumbs' {
	import { FunctionComponent } from 'react';
	import { EuiBreadcrumbsProps } from '@elastic/eui/src/components/breadcrumbs';
	export const EuiHeaderBreadcrumbs: FunctionComponent<EuiBreadcrumbsProps>;

}
declare module '@elastic/eui/src/components/header/header_breadcrumbs' {
	export { EuiHeaderBreadcrumbs } from '@elastic/eui/src/components/header/header_breadcrumbs/header_breadcrumbs';

}
declare module '@elastic/eui/src/components/header/header_section/header_section.styles' {
	export const euiHeaderSectionStyles: () => {
	    euiHeaderSection: import("@emotion/utils").SerializedStyles;
	    grow: import("@emotion/utils").SerializedStyles;
	    left: import("@emotion/utils").SerializedStyles;
	    right: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/header/header_section/header_section' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiHeaderSectionProps = CommonProps & HTMLAttributes<HTMLDivElement> & {
	    side?: 'left' | 'right';
	    grow?: boolean;
	};
	export const EuiHeaderSection: FunctionComponent<EuiHeaderSectionProps>;

}
declare module '@elastic/eui/src/components/header/header_section/header_section_item.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiHeaderSectionItemStyles: (euiThemeContext: UseEuiTheme) => {
	    euiHeaderSectionItem: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/header/header_section/header_section_item' {
	import { FunctionComponent, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiHeaderSectionItemProps = CommonProps & {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children?: ReactNode;
	};
	/**
	 * Header items are small icon links that pop up menus
	 */
	export const EuiHeaderSectionItem: FunctionComponent<EuiHeaderSectionItemProps>;

}
declare module '@elastic/eui/src/components/header/header_section/header_section_item_button.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiHeaderSectionItemButtonStyles: (euiThemeContext: UseEuiTheme) => {
	    euiHeaderSectionItemButton: import("@emotion/utils").SerializedStyles;
	    euiHeaderSectionItemButton__content: import("@emotion/utils").SerializedStyles;
	    notification: {
	        euiHeaderSectionItemButton__notification: import("@emotion/utils").SerializedStyles;
	        dot: import("@emotion/utils").SerializedStyles;
	        badge: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/header/header_section/header_section_item_button' {
	import React, { PropsWithChildren } from 'react';
	import { EuiNotificationBadgeProps } from '@elastic/eui/src/components/badge/notification_badge/badge_notification';
	import { EuiButtonEmptyProps } from '@elastic/eui/src/components/button';
	export type EuiHeaderSectionItemButtonProps = PropsWithChildren & EuiButtonEmptyProps & {
	    /**
	     * Inserts the node into a EuiBadgeNotification and places it appropriately against the button.
	     * Or pass `true` to render a simple dot
	     */
	    notification?: EuiNotificationBadgeProps['children'] | boolean;
	    /**
	     * Changes the color of the notification background
	     */
	    notificationColor?: EuiNotificationBadgeProps['color'];
	};
	export type EuiHeaderSectionItemButtonRef = (HTMLButtonElement & {
	    euiAnimate: () => void;
	}) | null;
	export const EuiHeaderSectionItemButton: React.ForwardRefExoticComponent<EuiHeaderSectionItemButtonProps & React.RefAttributes<EuiHeaderSectionItemButtonRef>>;

}
declare module '@elastic/eui/src/components/header/header_section' {
	export type { EuiHeaderSectionProps } from '@elastic/eui/src/components/header/header_section/header_section';
	export { EuiHeaderSection } from '@elastic/eui/src/components/header/header_section/header_section';
	export type { EuiHeaderSectionItemProps } from '@elastic/eui/src/components/header/header_section/header_section_item';
	export { EuiHeaderSectionItem } from '@elastic/eui/src/components/header/header_section/header_section_item';
	export type { EuiHeaderSectionItemButtonProps } from '@elastic/eui/src/components/header/header_section/header_section_item_button';
	export { EuiHeaderSectionItemButton } from '@elastic/eui/src/components/header/header_section/header_section_item_button';

}
declare module '@elastic/eui/src/components/header/header' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiBreadcrumb, EuiBreadcrumbsProps } from '@elastic/eui/src/components/breadcrumbs';
	import { EuiHeaderSectionItemProps } from '@elastic/eui/src/components/header/header_section'; type EuiHeaderSectionItemType = EuiHeaderSectionItemProps['children'];
	export interface EuiHeaderSections {
	    /**
	     * An arry of items that will be wrapped in a #EuiHeaderSectionItem
	     */
	    items?: EuiHeaderSectionItemType[];
	    /**
	     * Breadcrumbs in the header cannot be wrapped in a #EuiHeaderSection in order for truncation to work.
	     * Simply pass the array of EuiBreadcrumb objects
	     */
	    breadcrumbs?: EuiBreadcrumb[];
	    /**
	     * Other props to pass to #EuiHeaderBreadcrumbs
	     */
	    breadcrumbProps?: Omit<EuiBreadcrumbsProps, 'breadcrumbs'>;
	}
	export type EuiHeaderProps = CommonProps & HTMLAttributes<HTMLDivElement> & {
	    /**
	     * An array of objects to wrap in a #EuiHeaderSection.
	     * Each section is spaced using `space-between`.
	     * See #EuiHeaderSectionsProp for object details.
	     * This prop disregards the prop `children` if both are passed.
	     */
	    sections?: EuiHeaderSections[];
	    /**
	     * Helper that positions the header against the window body and
	     * adds the correct amount of top padding to the window when in `fixed` mode
	     */
	    position?: 'static' | 'fixed';
	    /**
	     * The `default` will inherit its coloring from the light or dark theme.
	     * Or, force the header into pseudo `dark` theme for all themes.
	     */
	    theme?: 'default' | 'dark';
	};
	export const EuiHeader: FunctionComponent<EuiHeaderProps>;
	/**
	 * Fixed headers - logic around dynamically calculating the total
	 * page offset and setting the `top` position of subsequent headers
	 */
	export let euiFixedHeadersCount: number;
	export const EuiFixedHeader: FunctionComponent<EuiHeaderProps>;
	export {};

}
declare module '@elastic/eui/src/components/header/header_alert/header_alert.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiHeaderAlertStyles: (euiThemeContext: UseEuiTheme) => {
	    euiHeaderAlert: import("@emotion/utils").SerializedStyles;
	    euiHeaderAlert__title: import("@emotion/utils").SerializedStyles;
	    euiHeaderAlert__text: import("@emotion/utils").SerializedStyles;
	    euiHeaderAlert__action: import("@emotion/utils").SerializedStyles;
	    euiHeaderAlert__date: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/header/header_alert/header_alert' {
	import { FunctionComponent, HTMLAttributes, ReactNode } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiHeaderAlertProps = CommonProps & Omit<HTMLAttributes<HTMLDivElement>, 'title'> & {
	    /**
	     * Adds a link to the alert.
	     */
	    action?: ReactNode;
	    date: ReactNode;
	    text?: ReactNode;
	    title: ReactNode;
	    /**
	     * Accepts an `EuiBadge` that displays on the alert
	     */
	    badge?: ReactNode;
	};
	export const EuiHeaderAlert: FunctionComponent<EuiHeaderAlertProps>;

}
declare module '@elastic/eui/src/components/header/header_alert' {
	export type { EuiHeaderAlertProps } from '@elastic/eui/src/components/header/header_alert/header_alert';
	export { EuiHeaderAlert } from '@elastic/eui/src/components/header/header_alert/header_alert';

}
declare module '@elastic/eui/src/components/header/header_links/header_link' {
	import { FunctionComponent } from 'react';
	import { EuiButtonEmptyProps } from '@elastic/eui/src/components/button';
	export type EuiHeaderLinkProps = EuiButtonEmptyProps & {
	    /**
	     * Simple prop to update color based on active state.
	     * Can be overridden with `color`
	     */
	    isActive?: boolean;
	};
	export const EuiHeaderLink: FunctionComponent<EuiHeaderLinkProps>;

}
declare module '@elastic/eui/src/components/header/header_links/header_links.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiHeaderLinksStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiHeaderLinks: import("@emotion/utils").SerializedStyles;
	    euiHeaderLinks__list: import("@emotion/utils").SerializedStyles;
	    gutterSizes: {
	        xxs: import("@emotion/utils").SerializedStyles;
	        xs: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	        l: import("@emotion/utils").SerializedStyles;
	    };
	    euiHeaderLinks__mobileList: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/header/header_links/header_links' {
	import { ReactNode, HTMLAttributes, FunctionComponent } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { IconType } from '@elastic/eui/src/components/icon';
	import { EuiPopoverProps } from '@elastic/eui/src/components/popover';
	import { EuiHeaderSectionItemButtonProps } from '@elastic/eui/src/components/header/header_section';
	import { EuiBreakpointSize } from '@elastic/eui/src/services/breakpoint';
	export const GUTTER_SIZES: readonly ["xxs", "xs", "s", "m", "l"]; type EuiHeaderLinksGutterSize = (typeof GUTTER_SIZES)[number]; type EuiHeaderLinksPopoverButtonProps = Partial<EuiHeaderSectionItemButtonProps> & {
	    iconType?: IconType;
	};
	export type EuiHeaderLinksProps = CommonProps & Omit<HTMLAttributes<HTMLElement>, 'children'> & {
	    /**
	     * Takes any rendered node(s), typically of `EuiHeaderLink`s.
	     *
	     * Optionally takes a render function that will pass a callback allowing you
	     * to close the mobile popover from within your popover content.
	     */
	    children?: ReactNode | ((closeMobilePopover: () => void) => ReactNode);
	    /**
	     * Spacing between direct children
	     */
	    gutterSize?: EuiHeaderLinksGutterSize;
	    /**
	     * A list of named breakpoints at which to show the popover version
	     */
	    popoverBreakpoints?: EuiBreakpointSize[] | 'all' | 'none';
	    /**
	     * Extend the functionality of the EuiPopover.button which is a EuiHeaderSectionItemButton.
	     * With the addition of `iconType` to change the display icon which defaults to `apps`
	     */
	    popoverButtonProps?: EuiHeaderLinksPopoverButtonProps;
	    /**
	     * Extend the functionality of the EuiPopover
	     */
	    popoverProps?: Omit<EuiPopoverProps, 'button' | 'closePopover'>;
	};
	export const EuiHeaderLinks: FunctionComponent<EuiHeaderLinksProps>;
	export {};

}
declare module '@elastic/eui/src/components/header/header_links' {
	export type { EuiHeaderLinkProps } from '@elastic/eui/src/components/header/header_links/header_link';
	export { EuiHeaderLink } from '@elastic/eui/src/components/header/header_links/header_link';
	export type { EuiHeaderLinksProps } from '@elastic/eui/src/components/header/header_links/header_links';
	export { EuiHeaderLinks } from '@elastic/eui/src/components/header/header_links/header_links';

}
declare module '@elastic/eui/src/components/header/header_logo/header_logo.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiHeaderLogoStyles: (euiThemeContext: UseEuiTheme) => {
	    euiHeaderLogo: import("@emotion/utils").SerializedStyles;
	    euiHeaderLogo__text: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/header/header_logo/header_logo' {
	import { FunctionComponent, AnchorHTMLAttributes, ReactNode } from 'react';
	import { IconType } from '@elastic/eui/src/components/icon';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiHeaderLogoProps = CommonProps & AnchorHTMLAttributes<HTMLAnchorElement> & {
	    href?: string;
	    rel?: string;
	    target?: string;
	    iconType?: IconType;
	    iconTitle?: string;
	    /**
	     * ReactNode to render as this component's content
	     */
	    children?: ReactNode;
	};
	export const EuiHeaderLogo: FunctionComponent<EuiHeaderLogoProps>;

}
declare module '@elastic/eui/src/components/header/header_logo' {
	export type { EuiHeaderLogoProps } from '@elastic/eui/src/components/header/header_logo/header_logo';
	export { EuiHeaderLogo } from '@elastic/eui/src/components/header/header_logo/header_logo';

}
declare module '@elastic/eui/src/components/header' {
	export type { EuiHeaderProps, EuiHeaderSections } from '@elastic/eui/src/components/header/header';
	export { EuiHeader } from '@elastic/eui/src/components/header/header';
	export type { EuiHeaderAlertProps } from '@elastic/eui/src/components/header/header_alert';
	export { EuiHeaderAlert } from '@elastic/eui/src/components/header/header_alert';
	export { EuiHeaderBreadcrumbs } from '@elastic/eui/src/components/header/header_breadcrumbs';
	export type { EuiHeaderLinkProps, EuiHeaderLinksProps } from '@elastic/eui/src/components/header/header_links';
	export { EuiHeaderLink, EuiHeaderLinks } from '@elastic/eui/src/components/header/header_links';
	export type { EuiHeaderLogoProps } from '@elastic/eui/src/components/header/header_logo';
	export { EuiHeaderLogo } from '@elastic/eui/src/components/header/header_logo';
	export type { EuiHeaderSectionItemButtonProps } from '@elastic/eui/src/components/header/header_section';
	export { EuiHeaderSection, EuiHeaderSectionItem, EuiHeaderSectionItemButton, } from '@elastic/eui/src/components/header/header_section';

}
declare module '@elastic/eui/src/components/health/health.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiHealthStyles: (euiTheme: UseEuiTheme) => {
	    euiHealth: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    inherit: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/health/health' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { IconColor } from '@elastic/eui/src/components/icon';
	export const TEXT_SIZES: readonly ["xs", "s", "m", "inherit"];
	export type EuiHealthProps = CommonProps & Omit<HTMLAttributes<HTMLDivElement>, 'color'> & {
	    /**
	     * Sets the color of the dot icon.
	     * It accepts any `IconColor`: `default`, `primary`, `success`, `accent`, `warning`, `danger`, `text`,
	     * `subdued` or `ghost`; or any valid CSS color value as a `string`
	     */
	    color?: IconColor;
	    /**
	     * Matches the text scales of EuiText.
	     * The `inherit` style will get its font size from the parent element
	     */
	    textSize?: (typeof TEXT_SIZES)[number];
	};
	export const EuiHealth: FunctionComponent<EuiHealthProps>;

}
declare module '@elastic/eui/src/components/health' {
	export type { EuiHealthProps } from '@elastic/eui/src/components/health/health';
	export { EuiHealth } from '@elastic/eui/src/components/health/health';

}
declare module '@elastic/eui/src/components/image/image_types' {
	import { HTMLAttributes, ReactNode, ImgHTMLAttributes, PropsWithChildren } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	export const SIZES: readonly ["s", "m", "l", "xl", "fullWidth", "original"];
	export type EuiImageSize = (typeof SIZES)[number]; const FLOATS: readonly ["left", "right"];
	export type EuiImageWrapperFloat = (typeof FLOATS)[number]; const MARGINS: readonly ["s", "m", "l", "xl"];
	export type EuiImageWrapperMargin = (typeof MARGINS)[number];
	export type EuiImageButtonIconColor = 'light' | 'dark'; type _EuiImageSrcOrUrl = ExclusiveUnion<{
	    /**
	     * Requires either `src` or `url` but defaults to using `src` if both are provided
	     */
	    src: string;
	}, {
	    url: string;
	}>;
	export type EuiImageProps = CommonProps & Omit<ImgHTMLAttributes<HTMLImageElement>, 'src' | 'alt'> & _EuiImageSrcOrUrl & {
	    /**
	     * Alt text should describe the image to aid screen reader users. See
	     * https://webaim.org/techniques/alttext/ for a guide on writing
	     * effective alt text.
	     *
	     * If no meaningful description exists, or if the image is adequately
	     * described by the surrounding text, pass an empty string.
	     */
	    alt: string;
	    /**
	     * Provides a visible caption to the image
	     */
	    caption?: ReactNode;
	    /**
	     * Accepts `s` / `m` / `l` / `xl` / `original` / `fullWidth` / or a CSS size of `number` or `string`.
	     * `fullWidth` will set the figure to stretch to 100% of its container.
	     * `string` and `number` types will max both the width or height, whichever is greater.
	     */
	    size?: EuiImageSize | number | string;
	    /**
	     * Float the image to the left or right. Useful in large text blocks.
	     */
	    float?: EuiImageWrapperFloat;
	    /**
	     * Margin around the image.
	     */
	    margin?: EuiImageWrapperMargin;
	    /**
	     * When set to `true` (default) will apply a slight shadow to the image
	     */
	    hasShadow?: boolean;
	    /**
	     * When set to `true` will make the image clickable to a larger version
	     */
	    allowFullScreen?: boolean;
	    /**
	     * Callback when the image is clicked and `allowFullScreen` is `true`
	     */
	    onFullScreen?: (isFullScreen: boolean) => void;
	    /**
	     * Changes the color of the icon that floats above the image when it can be clicked to fullscreen.
	     * The default value of `light` is fine unless your image has a white background, in which case you should change it to `dark`.
	     */
	    fullScreenIconColor?: EuiImageButtonIconColor;
	    /**
	     * Props to add to the wrapping figure element
	     */
	    wrapperProps?: CommonProps & HTMLAttributes<HTMLDivElement>;
	};
	export type EuiImageWrapperProps = PropsWithChildren & Pick<EuiImageProps, 'alt' | 'caption' | 'float' | 'margin' | 'hasShadow' | 'wrapperProps' | 'fullScreenIconColor' | 'allowFullScreen' | 'onFullScreen'> & {
	    isFullWidth: boolean;
	    setIsFullScreen: (isFullScreen: boolean) => void;
	};
	export type EuiImageButtonProps = PropsWithChildren & Pick<EuiImageProps, 'hasShadow' | 'fullScreenIconColor'> & {
	    hasAlt: boolean;
	    onClick: () => void;
	    onKeyDown?: (e: React.KeyboardEvent) => void;
	    isFullWidth: boolean;
	    isFullScreen?: boolean;
	};
	export type EuiImageCaptionProps = Pick<EuiImageProps, 'caption'> & {
	    isOnOverlayMask?: boolean;
	};
	export {};

}
declare module '@elastic/eui/src/components/image/image_wrapper.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiImageWrapperStyles: (euiThemeContext: UseEuiTheme) => {
	    euiImageWrapper: import("@emotion/utils").SerializedStyles;
	    allowFullScreen: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    xl: import("@emotion/utils").SerializedStyles;
	    left: import("@emotion/utils").SerializedStyles;
	    right: import("@emotion/utils").SerializedStyles;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/image/image_button.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiImageButtonStyles: (euiThemeContext: UseEuiTheme) => {
	    euiImageButton: import("@emotion/utils").SerializedStyles;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    shadowHover: import("@emotion/utils").SerializedStyles;
	    hasShadowHover: import("@emotion/utils").SerializedStyles;
	};
	export const euiImageButtonIconStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiImageButton__icon: import("@emotion/utils").SerializedStyles;
	    openFullScreen: import("@emotion/utils").SerializedStyles;
	    closeFullScreen: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/image/image_button' {
	import { FunctionComponent } from 'react';
	import type { EuiImageButtonProps } from '@elastic/eui/src/components/image/image_types';
	export const EuiImageButton: FunctionComponent<EuiImageButtonProps>;

}
declare module '@elastic/eui/src/components/image/image_caption.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiImageCaptionStyles: (euiThemeContext: UseEuiTheme) => {
	    euiImageCaption: import("@emotion/utils").SerializedStyles;
	    isOnOverlayMask: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/image/image_caption' {
	import React from 'react';
	export const EuiImageCaption: React.ForwardRefExoticComponent<Pick<import ("@elastic/eui/src/components/image/image_types").EuiImageProps, "caption"> & {
	    isOnOverlayMask?: boolean | undefined;
	} & React.RefAttributes<HTMLDivElement>>;

}
declare module '@elastic/eui/src/components/image/image_wrapper' {
	import { FunctionComponent } from 'react';
	import type { EuiImageWrapperProps } from '@elastic/eui/src/components/image/image_types';
	export const EuiImageWrapper: FunctionComponent<EuiImageWrapperProps>;

}
declare module '@elastic/eui/src/components/image/image.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiImageStyles: (euiThemeContext: UseEuiTheme) => {
	    euiImage: import("@emotion/utils").SerializedStyles;
	    isFullScreen: import("@emotion/utils").SerializedStyles;
	    hasShadow: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    xl: import("@emotion/utils").SerializedStyles;
	    original: import("@emotion/utils").SerializedStyles;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	    customSize: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/image/image_fullscreen_wrapper.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiImageFullscreenWrapperStyles: (euiThemeContext: UseEuiTheme) => {
	    euiImageFullscreenWrapper: import("@emotion/utils").SerializedStyles;
	    fullWidth: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/image/image_fullscreen_wrapper' {
	import { FunctionComponent } from 'react';
	import type { EuiImageWrapperProps } from '@elastic/eui/src/components/image/image_types';
	export const EuiImageFullScreenWrapper: FunctionComponent<EuiImageWrapperProps>;

}
declare module '@elastic/eui/src/components/image/image' {
	import { FunctionComponent } from 'react';
	import type { EuiImageProps } from '@elastic/eui/src/components/image/image_types';
	export const EuiImage: FunctionComponent<EuiImageProps>;

}
declare module '@elastic/eui/src/components/image' {
	export type { EuiImageProps } from '@elastic/eui/src/components/image/image_types';
	export { EuiImage } from '@elastic/eui/src/components/image/image';

}
declare module '@elastic/eui/src/components/skeleton/skeleton_loading' {
	import { FunctionComponent, HTMLAttributes, ReactElement } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiScreenReaderLiveProps } from '@elastic/eui/src/components/accessibility/screen_reader_live';
	export type _EuiSkeletonAriaProps = {
	    /**
	     * When true, shows the loading skeleton component.
	     * When false, shows any `children` and announces to screen readers that your content has loaded.
	     */
	    isLoading?: boolean;
	    /**
	     * Label your loading sections to provide more helpful context to screen readers.
	     * For example, pass "API keys" to have screen readers read "Loading API keys" and "Loaded API keys".
	     */
	    contentAriaLabel?: string;
	    /**
	     * Makes a live screen reader announcement when `isLoading` is true
	     * @default false
	     */
	    announceLoadingStatus?: boolean;
	    /**
	     * Makes a live screen reader announcement when `isLoading` is false
	     * @default true
	     */
	    announceLoadedStatus?: boolean;
	    /**
	     * Optional props to pass to the `aria-live` region that announces the loading status to screen readers.
	     * Accepts any `EuiScreenReaderLive` props.
	     */
	    ariaLiveProps?: Partial<EuiScreenReaderLiveProps>;
	    /**
	     * Optional props to pass to the `aria-busy` wrapper around the skeleton content
	     */
	    ariaWrapperProps?: HTMLAttributes<HTMLDivElement>;
	};
	export type EuiSkeletonLoadingProps = CommonProps & _EuiSkeletonAriaProps['ariaWrapperProps'] & Omit<_EuiSkeletonAriaProps, 'ariaWrapperProps'> & {
	    /**
	     * Content to display when loading
	     */
	    loadingContent: ReactElement;
	    /**
	     * Content to display when loaded
	     */
	    loadedContent: any;
	};
	export const EuiSkeletonLoading: FunctionComponent<EuiSkeletonLoadingProps>;

}
declare module '@elastic/eui/src/components/skeleton/utils' {
	import { UseEuiTheme } from '@elastic/eui/src/services'; type AnimationOptions = {
	    slideSize?: string;
	    gradientSize?: string;
	};
	export const euiSkeletonGradientAnimation: ({ euiTheme, colorMode }: UseEuiTheme, { slideSize, gradientSize }?: AnimationOptions) => import("@emotion/utils").SerializedStyles;
	export {};

}
declare module '@elastic/eui/src/components/skeleton/skeleton_circle.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiSkeletonCircleStyles: (euiThemeContext: UseEuiTheme) => {
	    euiSkeletonCircle: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    xl: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/skeleton/skeleton_circle' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { _EuiSkeletonAriaProps } from '@elastic/eui/src/components/skeleton/skeleton_loading';
	export const SIZES: readonly ["s", "m", "l", "xl"];
	export type SkeletonCircleSize = (typeof SIZES)[number];
	export type EuiSkeletonCircleProps = HTMLAttributes<HTMLDivElement> & CommonProps & _EuiSkeletonAriaProps & {
	    size?: SkeletonCircleSize;
	};
	export const EuiSkeletonCircle: FunctionComponent<EuiSkeletonCircleProps>;

}
declare module '@elastic/eui/src/components/skeleton/skeleton_text.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiSkeletonTextStyles: (euiThemeContext: UseEuiTheme) => {
	    euiSkeletonText: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	    relative: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/skeleton/skeleton_text' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { TextSize } from '@elastic/eui/src/components/text/text';
	import { _EuiSkeletonAriaProps } from '@elastic/eui/src/components/skeleton/skeleton_loading';
	export const LINES: readonly [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
	export type LineRange = (typeof LINES)[number];
	export type EuiSkeletonTextProps = CommonProps & HTMLAttributes<HTMLDivElement> & _EuiSkeletonAriaProps & {
	    /**
	     * Number of lines to display (between 1 to 10)
	     */
	    lines?: LineRange;
	    /**
	     * EuiText size to render
	     */
	    size?: TextSize;
	};
	export const EuiSkeletonText: FunctionComponent<EuiSkeletonTextProps>;

}
declare module '@elastic/eui/src/components/skeleton/skeleton_rectangle.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiSkeletonRectangleStyles: (euiThemeContext: UseEuiTheme) => {
	    euiSkeletonRectangle: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    none: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/skeleton/skeleton_rectangle' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { _EuiSkeletonAriaProps } from '@elastic/eui/src/components/skeleton/skeleton_loading';
	export const RADIUS: readonly ["s", "m", "none"];
	export type SkeletonRectangleBorderRadius = (typeof RADIUS)[number];
	export type EuiSkeletonRectangleProps = HTMLAttributes<HTMLDivElement> & CommonProps & _EuiSkeletonAriaProps & {
	    width?: string | number;
	    height?: string | number;
	    borderRadius?: SkeletonRectangleBorderRadius;
	};
	export const EuiSkeletonRectangle: FunctionComponent<EuiSkeletonRectangleProps>;

}
declare module '@elastic/eui/src/components/skeleton/skeleton_title.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiSkeletonTitleStyles: (euiThemeContext: UseEuiTheme) => {
	    euiSkeletonTitle: import("@emotion/utils").SerializedStyles;
	    l: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	    xxs: import("@emotion/utils").SerializedStyles;
	    xxxs: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/skeleton/skeleton_title' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiTitleSize } from '@elastic/eui/src/components/title';
	import { _EuiSkeletonAriaProps } from '@elastic/eui/src/components/skeleton/skeleton_loading';
	export type EuiSkeletonTitleProps = HTMLAttributes<HTMLDivElement> & CommonProps & _EuiSkeletonAriaProps & {
	    /**
	     * EuiTitle size to render
	     */
	    size?: EuiTitleSize;
	};
	export const EuiSkeletonTitle: FunctionComponent<EuiSkeletonTitleProps>;

}
declare module '@elastic/eui/src/components/skeleton' {
	export type { EuiSkeletonLoadingProps } from '@elastic/eui/src/components/skeleton/skeleton_loading';
	export { EuiSkeletonLoading } from '@elastic/eui/src/components/skeleton/skeleton_loading';
	export type { EuiSkeletonCircleProps } from '@elastic/eui/src/components/skeleton/skeleton_circle';
	export { EuiSkeletonCircle } from '@elastic/eui/src/components/skeleton/skeleton_circle';
	export type { EuiSkeletonTextProps } from '@elastic/eui/src/components/skeleton/skeleton_text';
	export { EuiSkeletonText } from '@elastic/eui/src/components/skeleton/skeleton_text';
	export type { EuiSkeletonRectangleProps } from '@elastic/eui/src/components/skeleton/skeleton_rectangle';
	export { EuiSkeletonRectangle } from '@elastic/eui/src/components/skeleton/skeleton_rectangle';
	export type { EuiSkeletonTitleProps } from '@elastic/eui/src/components/skeleton/skeleton_title';
	export { EuiSkeletonTitle } from '@elastic/eui/src/components/skeleton/skeleton_title';

}
declare module '@elastic/eui/src/components/inline_edit/inline_edit_form.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiInlineEditReadModeStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiInlineEditReadMode: import("@emotion/utils").SerializedStyles;
	    isReadOnly: import("@emotion/utils").SerializedStyles;
	    hasPlaceholder: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/inline_edit/inline_edit_form' {
	import React, { ReactNode, FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	import { EuiFormRowProps, EuiFieldTextProps } from '@elastic/eui/src/components/form';
	import { EuiButtonIconPropsForButton } from '@elastic/eui/src/components/button/button_icon';
	import { EuiButtonEmptyPropsForButton } from '@elastic/eui/src/components/button/button_empty/button_empty';
	export type EuiInlineEditCommonProps = Omit<HTMLAttributes<HTMLDivElement>, 'children'> & CommonProps & {
	    placeholder?: string;
	    /**
	     * Callback that fires when a user clicks the save button.
	     * Passes the current edited text value as an argument.
	     *
	     * To validate the value of the edited text, pass back a boolean flag.
	     * If `false`, EuiInlineEdit will remain in edit mode, where loading or invalid states can be set.
	     * If `true`, EuiInlineEdit will return to read mode.
	     */
	    onSave?: (value: string) => void | boolean | Promise<boolean | void>;
	    /**
	     * Form label that appears above the form control.
	     * This is required for accessibility because there is no visual label on the input.
	     */
	    inputAriaLabel: string;
	    /**
	     * Starts the component in edit mode
	     */
	    startWithEditOpen?: boolean;
	    /**
	     * Props that will be applied directly to the `EuiEmptyButton` displayed in read mode
	     */
	    readModeProps?: Partial<EuiButtonEmptyPropsForButton>;
	    /**
	     * Multiple props objects that can be applied directly to various child components displayed in edit mode.
	     * - `formRowProps` will be passed to `EuiFormRow`
	     * - `inputProps` will be passed to `EuiFieldText`
	     * - `saveButtonProps` & `cancelButtonProps` will be passed to their respective `EuiIconButton`s
	     */
	    editModeProps?: {
	        formRowProps?: Partial<EuiFormRowProps>;
	        inputProps?: Partial<EuiFieldTextProps>;
	        saveButtonProps?: Partial<EuiButtonIconPropsForButton>;
	        cancelButtonProps?: Partial<EuiButtonIconPropsForButton>;
	    };
	    /**
	     * Loading state - only displayed in edit mode
	     */
	    isLoading?: boolean;
	    /**
	     * Invalid state - only displayed edit mode
	     */
	    isInvalid?: boolean;
	    /**
	     * Locks inline edit in read mode and displays the text value
	     */
	    isReadOnly?: boolean;
	} & ExclusiveUnion<{
	    /**
	     * Initial inline edit text value
	     */
	    defaultValue: string;
	}, {
	    /**
	     * To use inline edit as a controlled component, continuously pass the value via this prop
	     */
	    value: string;
	    /**
	     * Callback required to receive and update `value` based on user input
	     */
	    onChange: (event: React.ChangeEvent<HTMLInputElement>) => void;
	    /**
	     * Callback required to reset `value` to the previous read mode text value.
	     */
	    onCancel: (perviousValue: string) => void;
	}>;
	export type EuiInlineEditFormProps = EuiInlineEditCommonProps & {
	    /**
	     * Form sizes
	     */
	    sizes: {
	        compressed: boolean;
	        buttonSize: EuiButtonEmptyPropsForButton['size'];
	        iconSize: EuiButtonEmptyPropsForButton['iconSize'];
	    };
	    /**
	     * Render prop that returns the read mode value as an arg
	     */
	    children: (readModeValue: ReactNode) => ReactNode;
	};
	export const SMALL_SIZE_FORM: {
	    readonly iconSize: "s";
	    readonly compressed: true;
	    readonly buttonSize: "s";
	};
	export const MEDIUM_SIZE_FORM: {
	    readonly iconSize: "m";
	    readonly compressed: false;
	    readonly buttonSize: "m";
	};
	export const EuiInlineEditForm: FunctionComponent<EuiInlineEditFormProps>;

}
declare module '@elastic/eui/src/components/inline_edit/inline_edit_text.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiInlineEditTextStyles: (euiThemeContext: UseEuiTheme) => {
	    euiInlineEditText: import("@emotion/utils").SerializedStyles;
	    fontSize: {
	        xs: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/inline_edit/inline_edit_text' {
	import { FunctionComponent } from 'react';
	import { EuiTextProps } from '@elastic/eui/src/components/text';
	import { EuiInlineEditCommonProps } from '@elastic/eui/src/components/inline_edit/inline_edit_form';
	export type EuiInlineEditTextSizes = Exclude<EuiTextProps['size'], 'relative'>;
	export type EuiInlineEditTextProps = EuiInlineEditCommonProps & {
	    /**
	     * Text size level
	     */
	    size?: EuiInlineEditTextSizes;
	};
	export const EuiInlineEditText: FunctionComponent<EuiInlineEditTextProps>;

}
declare module '@elastic/eui/src/components/inline_edit/inline_edit_title.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiInlineEditTitleStyles: (euiThemeContext: UseEuiTheme) => {
	    euiInlineEditTitle: import("@emotion/utils").SerializedStyles;
	    fontSize: {
	        xxxs: import("@emotion/utils").SerializedStyles;
	        xxs: import("@emotion/utils").SerializedStyles;
	        xs: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	        m: import("@emotion/utils").SerializedStyles;
	        l: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/inline_edit/inline_edit_title' {
	import { FunctionComponent } from 'react';
	import { EuiTitleSize } from '@elastic/eui/src/components/title';
	import { EuiInlineEditCommonProps } from '@elastic/eui/src/components/inline_edit/inline_edit_form';
	export const HEADINGS: readonly ["h1", "h2", "h3", "h4", "h5", "h6", "span"]; type Heading = (typeof HEADINGS)[number];
	export type EuiInlineEditTitleProps = EuiInlineEditCommonProps & {
	    /**
	     * Title size level
	     */
	    size?: EuiTitleSize;
	    /**
	     * Level of heading to be used for the title.
	     * Use `span` for text that is not semantically a heading, but should still visually appear as a title.
	     */
	    heading: Heading;
	};
	export const EuiInlineEditTitle: FunctionComponent<EuiInlineEditTitleProps>;
	export {};

}
declare module '@elastic/eui/src/components/inline_edit' {
	export { EuiInlineEditText } from '@elastic/eui/src/components/inline_edit/inline_edit_text';
	export type { EuiInlineEditTextProps } from '@elastic/eui/src/components/inline_edit/inline_edit_text';
	export { EuiInlineEditTitle } from '@elastic/eui/src/components/inline_edit/inline_edit_title';
	export type { EuiInlineEditTitleProps } from '@elastic/eui/src/components/inline_edit/inline_edit_title';

}
declare module '@elastic/eui/src/components/key_pad_menu/key_pad_menu.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiKeyPadMenuVariables: ({ euiTheme }: UseEuiTheme) => {
	    euiKeyPadMenuSize: string;
	    euiKeyPadMenuMarginSize: string;
	};
	export const euiKeyPadMenuStyles: (euiThemeContext: UseEuiTheme) => {
	    euiKeyPadMenu: import("@emotion/utils").SerializedStyles;
	    euiKeyPadMenu__legend: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/key_pad_menu/key_pad_menu' {
	import { FunctionComponent, HTMLAttributes, ReactNode } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	import { _EuiFormLegendProps } from '@elastic/eui/src/components/form/form_label/form_label';
	export type _EuiKeyPadMenuCheckableProps = ExclusiveUnion<{
	    /**
	     * Rendered within a `legend` to label the `fieldset`.
	     * To create a visually hidden legend, use `ariaLegend`
	     */
	    legend: ReactNode;
	    /**
	     * Pass through props to a `EuiFormLabel` component, except for `type`
	     */
	    legendProps?: Omit<_EuiFormLegendProps, 'type'>;
	}, {
	    /**
	     * Custom aria-attribute for creating a *visually hidden* legend.
	     * To create a visible legend, use `legend`
	     */
	    ariaLegend: string;
	}>;
	export type EuiKeyPadMenuProps = CommonProps & HTMLAttributes<HTMLElement> & {
	    /**
	     * Renders the the group as a `fieldset`.
	     * Set to `true` to customize the labelling, or pass an #EuiKeyPadMenuCheckableProps object to add a `legend` or `ariaLegend`
	     */
	    checkable?: _EuiKeyPadMenuCheckableProps | true;
	};
	export const EuiKeyPadMenu: FunctionComponent<EuiKeyPadMenuProps>;

}
declare module '@elastic/eui/src/components/key_pad_menu/key_pad_menu_item.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiKeyPadMenuItemStyles: (euiThemeContext: UseEuiTheme) => {
	    euiKeyPadMenuItem: import("@emotion/utils").SerializedStyles;
	    enabled: import("@emotion/utils").SerializedStyles;
	    selected: import("@emotion/utils").SerializedStyles;
	    disabled: {
	        disabled: import("@emotion/utils").SerializedStyles;
	        selected: import("@emotion/utils").SerializedStyles;
	    };
	};
	export const euiKeyPadMenuItemChildStyles: (euiThemeContext: UseEuiTheme) => {
	    euiKeyPadMenuItem__inner: import("@emotion/utils").SerializedStyles;
	    euiKeyPadMenuItem__icon: import("@emotion/utils").SerializedStyles;
	    euiKeyPadMenuItem__label: import("@emotion/utils").SerializedStyles;
	    euiKeyPadMenuItem__betaBadge: import("@emotion/utils").SerializedStyles;
	    euiKeyPadMenuItem__checkableInput: import("@emotion/utils").SerializedStyles;
	    showCheckableInputOnInteraction: import("@emotion/utils").SerializedStyles;
	    hideCheckableInput: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/key_pad_menu/key_pad_menu_item' {
	import { FunctionComponent, ReactNode, Ref, LabelHTMLAttributes } from 'react';
	import { CommonProps, ExclusiveUnion, PropsForAnchor, PropsForButton } from '@elastic/eui/src/components/common';
	import { IconType } from '@elastic/eui/src/components/icon';
	import { EuiToolTipProps } from '@elastic/eui/src/components/tool_tip';
	export type EuiKeyPadMenuItemCheckableType = 'single' | 'multi';
	export type EuiKeyPadMenuItemCommonProps = {
	    /**
	     * One will be generated if not provided
	     */
	    id?: string;
	    /**
	     * Pass an EuiIcon, preferrably `size="l"`
	     */
	    children: ReactNode;
	    isDisabled?: boolean;
	    /**
	     * Indicate if an item is the current one.
	     * Be sure to use `true` AND `false` when acting as a toggle to ensure the attribute is added for both states
	     */
	    isSelected?: boolean;
	    /**
	     * The text to display beneath the icon
	     */
	    label: ReactNode;
	}; type EuiKeyPadMenuItemPropsForUncheckable = {
	    /**
	     * Beta badges are unavailable if the item is checkable
	     */
	    checkable?: undefined;
	    /**
	     * Add a badge to the card to label it as "Beta" or other non-GA state
	     */
	    betaBadgeLabel?: string;
	    /**
	     * Supply an icon type if the badge should just be an icon
	     */
	    betaBadgeIconType?: IconType;
	    /**
	     * Add a description to the beta badge (will appear in a tooltip)
	     */
	    betaBadgeTooltipContent?: ReactNode;
	    /**
	     * Extends the wrapping EuiToolTip props when `betaBadgeLabel` is provided
	     */
	    betaBadgeTooltipProps?: Partial<Omit<EuiToolTipProps, 'title' | 'content' | 'delay'>>;
	    /**
	     * Use `onClick` instead when the item is not `checkable`
	     */
	    onChange?: never;
	}; type EuiKeyPadMenuItemPropsForAnchor = PropsForAnchor<EuiKeyPadMenuItemCommonProps, {
	    buttonRef?: Ref<HTMLAnchorElement>;
	    rel?: string;
	} & EuiKeyPadMenuItemPropsForUncheckable>; type EuiKeyPadMenuItemPropsForButton = PropsForButton<EuiKeyPadMenuItemCommonProps, {
	    buttonRef?: Ref<HTMLButtonElement>;
	} & EuiKeyPadMenuItemPropsForUncheckable>; type EuiKeyPadMenuItemPropsForCheckable = Omit<LabelHTMLAttributes<HTMLLabelElement>, 'onChange'> & EuiKeyPadMenuItemCommonProps & {
	    /**
	     * Use `onChange` instead when the item is `checkable`
	     */
	    onClick?: never;
	} & ExclusiveUnion<{
	    /**
	     * Type `'single'` renders the item as a `<label>` and
	     * adds a radio element.
	     */
	    checkable: 'single';
	    /**
	     * The `name` attribute for radio inputs;
	     * Required in order to group properly
	     */
	    name: string;
	    /**
	     * The value of the radio input for 'single'
	     */
	    value?: string;
	    /**
	     * Single: Returns the `id` of the clicked option and the `value`
	     */
	    onChange: (id: string, value?: any) => void;
	}, {
	    /**
	     * Type `'multi'` renders the item as a `<label>` and
	     * adds a checkbox.
	     */
	    checkable: 'multi';
	    /**
	     * Multi: Returns the `id` of the clicked option
	     */
	    onChange: (id: string) => void;
	}>;
	export type EuiKeyPadMenuItemProps = CommonProps & ExclusiveUnion<EuiKeyPadMenuItemPropsForCheckable, ExclusiveUnion<EuiKeyPadMenuItemPropsForAnchor, EuiKeyPadMenuItemPropsForButton>>;
	export const EuiKeyPadMenuItem: FunctionComponent<EuiKeyPadMenuItemProps>;
	export {};

}
declare module '@elastic/eui/src/components/key_pad_menu' {
	export type { EuiKeyPadMenuProps } from '@elastic/eui/src/components/key_pad_menu/key_pad_menu';
	export { EuiKeyPadMenu } from '@elastic/eui/src/components/key_pad_menu/key_pad_menu';
	export type { EuiKeyPadMenuItemProps } from '@elastic/eui/src/components/key_pad_menu/key_pad_menu_item';
	export { EuiKeyPadMenuItem } from '@elastic/eui/src/components/key_pad_menu/key_pad_menu_item';

}
declare module '@elastic/eui/src/components/modal/modal.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiModalStyles: (euiThemeContext: UseEuiTheme) => {
	    euiModal: import("@emotion/utils").SerializedStyles;
	    defaultMaxWidth: import("@emotion/utils").SerializedStyles;
	    confirmation: import("@emotion/utils").SerializedStyles;
	    euiModal__closeIcon: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/modal/modal' {
	import React, { FunctionComponent, ReactNode, HTMLAttributes } from 'react';
	export interface EuiModalProps extends HTMLAttributes<HTMLDivElement> {
	    className?: string;
	    /**
	     * ReactNode to render as this component's content
	     */
	    children: ReactNode;
	    onClose: (event?: React.KeyboardEvent<HTMLDivElement> | React.MouseEvent<HTMLButtonElement>) => void;
	    /**
	     * Sets the max-width of the modal.
	     * Set to `true` to use the default (`euiBreakpoints 'm'`),
	     * set to `false` to not restrict the width,
	     * set to a number for a custom width in px,
	     * set to a string for a custom width in custom measurement.
	     */
	    maxWidth?: boolean | number | string;
	    /**
	     * Specifies what element should initially have focus.
	     * Can be a DOM node, or a selector string (which will be passed to document.querySelector() to find the DOM node), or a function that returns a DOM node.
	     */
	    initialFocus?: HTMLElement | (() => HTMLElement) | string;
	    /**
	     * Identifies a modal dialog to screen readers. Modal dialogs that confirm destructive actions
	     * or need a user's attention should use "alertdialog".
	     */
	    role?: 'dialog' | 'alertdialog';
	}
	export const EuiModal: FunctionComponent<EuiModalProps>;

}
declare module '@elastic/eui/src/components/modal/modal_footer.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiModalFooterStyles: (euiThemeContext: UseEuiTheme) => {
	    euiModalFooter: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/modal/modal_footer' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiModalFooterProps = FunctionComponent<HTMLAttributes<HTMLDivElement> & CommonProps>;
	export const EuiModalFooter: EuiModalFooterProps;

}
declare module '@elastic/eui/src/components/modal/modal_header.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiModalHeaderStyles: (euiThemeContext: UseEuiTheme) => {
	    euiModalHeader: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/modal/modal_header' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiModalHeaderProps = FunctionComponent<HTMLAttributes<HTMLDivElement> & CommonProps>;
	export const EuiModalHeader: EuiModalHeaderProps;

}
declare module '@elastic/eui/src/components/modal/modal_header_title' {
	import { FunctionComponent, HTMLAttributes, ElementType } from 'react';
	import { EuiTitleProps } from '@elastic/eui/src/components/title';
	export type EuiModalHeaderTitleProps = FunctionComponent<Omit<EuiTitleProps, 'children'> & HTMLAttributes<HTMLHeadingElement> & {
	    /**
	     * The tag to render. Can be changed to a lower heading
	     * level like `h2` or a container `div`.
	     * @default h1
	     */
	    component?: ElementType;
	}>;
	export const EuiModalHeaderTitle: EuiModalHeaderTitleProps;

}
declare module '@elastic/eui/src/components/modal/modal_body.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiModalBodyStyles: (euiThemeContext: UseEuiTheme) => {
	    euiModalBody: import("@emotion/utils").SerializedStyles;
	    euiModalBody__overflow: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/modal/modal_body' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiModalBodyProps = FunctionComponent<HTMLAttributes<HTMLDivElement> & CommonProps>;
	export const EuiModalBody: EuiModalBodyProps;

}
declare module '@elastic/eui/src/components/modal/confirm_modal' {
	import React, { FunctionComponent, ComponentProps, ReactNode } from 'react';
	import { EuiModalProps } from '@elastic/eui/src/components/modal/modal';
	import { EuiModalHeaderTitleProps } from '@elastic/eui/src/components/modal/modal_header_title';
	import { EuiButtonColor } from '@elastic/eui/src/components/button';
	export interface EuiConfirmModalProps extends Omit<EuiModalProps, 'children' | 'onClose' | 'title'> {
	    /**
	     * ReactNode to render as this component's content
	     */
	    children?: ReactNode;
	    title?: ReactNode;
	    titleProps?: ComponentProps<EuiModalHeaderTitleProps>;
	    cancelButtonText?: ReactNode;
	    confirmButtonText?: ReactNode;
	    onCancel: (event?: React.KeyboardEvent<HTMLDivElement> | React.MouseEvent<HTMLButtonElement>) => void;
	    onConfirm?: (event: React.MouseEvent<HTMLButtonElement, MouseEvent>) => void;
	    confirmButtonDisabled?: boolean;
	    className?: string;
	    /**
	     * Allows focusing either the confirm or cancel button on modal initialization.
	     * Will take precedence over `initialFocus`, if `initialFocus` is passed.
	     */
	    defaultFocusedButton?: typeof CONFIRM_BUTTON | typeof CANCEL_BUTTON;
	    buttonColor?: EuiButtonColor;
	    /**
	     * Sets the max-width of the modal.
	     * Set to `true` to use the default (`euiBreakpoints 'm'`),
	     * set to `false` to not restrict the width,
	     * set to a number for a custom width in px,
	     * set to a string for a custom width in custom measurement.
	     */
	    maxWidth?: boolean | number | string;
	    /**
	     * Passes `isLoading` prop to the confirm button
	     */
	    isLoading?: boolean;
	}
	export const CONFIRM_BUTTON = "confirm";
	export const CANCEL_BUTTON = "cancel";
	export const EuiConfirmModal: FunctionComponent<EuiConfirmModalProps>;

}
declare module '@elastic/eui/src/components/modal' {
	export type { EuiConfirmModalProps } from '@elastic/eui/src/components/modal/confirm_modal';
	export { EuiConfirmModal, CONFIRM_BUTTON as EUI_MODAL_CONFIRM_BUTTON, CANCEL_BUTTON as EUI_MODAL_CANCEL_BUTTON, } from '@elastic/eui/src/components/modal/confirm_modal';
	export type { EuiModalProps } from '@elastic/eui/src/components/modal/modal';
	export { EuiModal } from '@elastic/eui/src/components/modal/modal';
	export type { EuiModalFooterProps } from '@elastic/eui/src/components/modal/modal_footer';
	export { EuiModalFooter } from '@elastic/eui/src/components/modal/modal_footer';
	export type { EuiModalHeaderProps } from '@elastic/eui/src/components/modal/modal_header';
	export { EuiModalHeader } from '@elastic/eui/src/components/modal/modal_header';
	export type { EuiModalBodyProps } from '@elastic/eui/src/components/modal/modal_body';
	export { EuiModalBody } from '@elastic/eui/src/components/modal/modal_body';
	export type { EuiModalHeaderTitleProps } from '@elastic/eui/src/components/modal/modal_header_title';
	export { EuiModalHeaderTitle } from '@elastic/eui/src/components/modal/modal_header_title';

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_types' {
	import { ComponentType, ReactNode } from 'react';
	import { VFile } from 'vfile';
	import { Node as UnistNode, Position as UnistPosition } from 'unist';
	import { Parser } from 'remark-parse-no-trim';
	import { VFileMessage } from 'vfile-message';
	import { IconType } from '@elastic/eui/src/components/icon';
	export interface RemarkParser {
	    Parser: typeof Parser;
	    tokenizeInline: Function;
	    file: VFile;
	}
	export interface RemarkTokenizer {
	    (this: RemarkParser, eat: Function & {
	        now: Function;
	    }, value: string, silent: boolean): boolean | void;
	    locator?: (value: string, fromIndex: number) => number;
	    notInLink?: boolean;
	}
	interface RehypeNode {
	}
	interface RemarkRehypeHandlerCallback {
	    (node: UnistPosition, tagName: string, props: Object, children: RehypeNode[]): RehypeNode;
	}
	export interface RemarkRehypeHandler {
	    (h: RemarkRehypeHandlerCallback, node: UnistNode): RehypeNode;
	}
	export interface EuiMarkdownEditorUiPluginEditorProps<NodeShape> {
	    node: NodeShape | null;
	    onCancel: () => void;
	    onSave: (markdown: string, config: EuiMarkdownStringTagConfig) => void;
	}
	export const isPluginWithImmediateFormatting: (x: PluginWithImmediateFormatting | PluginWithDelayedFormatting<any>) => x is PluginWithImmediateFormatting;
	export interface PluginWithImmediateFormatting {
	    formatting: EuiMarkdownFormatting;
	    editor?: never;
	}
	export interface PluginWithDelayedFormatting<NodeShape> {
	    formatting?: never;
	    editor: ComponentType<EuiMarkdownEditorUiPluginEditorProps<NodeShape>>;
	}
	export type EuiMarkdownEditorUiPlugin<NodeShape = any> = {
	    name: string;
	    button: {
	        label: string;
	        iconType: IconType;
	        isDisabled?: boolean;
	    };
	    helpText?: ReactNode;
	} & (PluginWithImmediateFormatting | PluginWithDelayedFormatting<NodeShape>);
	export interface EuiMarkdownFormatting {
	    prefix?: string;
	    suffix?: string;
	    blockPrefix?: string;
	    blockSuffix?: string;
	    multiline?: boolean;
	    replaceNext?: string;
	    prefixSpace?: boolean;
	    scanFor?: string;
	    surroundWithNewlines?: boolean;
	    orderedList?: boolean;
	    trimFirst?: boolean;
	}
	export interface EuiMarkdownAstNode {
	    type: string;
	    children?: EuiMarkdownAstNode[];
	    position?: EuiMarkdownAstNodePosition;
	}
	export interface EuiMarkdownAstNodePosition {
	    start: {
	        line: number;
	        column: number;
	        offset: number;
	    };
	    end: {
	        line: number;
	        column: number;
	        offset: number;
	    };
	}
	export type EuiMarkdownParseError = string | VFileMessage | Error;
	export interface EuiMarkdownDropHandler {
	    supportedFiles: string[];
	    accepts: (itemType: string) => boolean;
	    getFormattingForItem: (file: File) => EuiMarkdownDragAndDropResult | Promise<EuiMarkdownDragAndDropResult>;
	}
	export interface EuiMarkdownStringTagConfig {
	    block: boolean;
	}
	export interface EuiMarkdownDragAndDropResult {
	    text: string;
	    config: EuiMarkdownStringTagConfig;
	}
	export {};

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_actions' {
	import { EuiMarkdownEditorUiPlugin, EuiMarkdownFormatting } from '@elastic/eui/src/components/markdown_editor/markdown_types'; class MarkdownActions {
	    editorID: string;
	    styles: Record<string, EuiMarkdownEditorUiPlugin>;
	    constructor(editorID: string, uiPlugins: EuiMarkdownEditorUiPlugin[]);
	    /**
	     * .do() accepts a string and retrieves the correlating style object (defined in the
	     * constructor). It passes this to applyStyle() that does the text manipulation.
	     *
	     * @param {string} pluginName
	     * @memberof MarkdownActions
	     */
	    do(pluginName: string): true | EuiMarkdownEditorUiPlugin;
	    /**
	     * Sets the default styling object and then superimposes the changes to make on top of
	     * it. Calls the `styleSelectedText` helper function that does the heavy lifting.
	     * Adapted from https://github.com/github/markdown-toolbar-element/blob/main/src/index.ts
	     *
	     * @param {object} incomingStyle
	     * @memberof MarkdownActions
	     */
	    applyStyle(incomingStyle: EuiMarkdownFormatting): void;
	}
	interface SelectionRange {
	    text: string;
	    selectionStart?: number;
	    selectionEnd?: number;
	}
	export function insertText(textarea: HTMLTextAreaElement, { text, selectionStart, selectionEnd }: SelectionRange): void;
	export default MarkdownActions;

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_modes' {
	export const MODE_EDITING: "editing";
	export const MODE_VIEWING: "viewing";
	export type MARKDOWN_MODE = typeof MODE_EDITING | typeof MODE_VIEWING;

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_context' {
	import { EuiMarkdownEditorUiPlugin } from '@elastic/eui/src/components/markdown_editor/markdown_types';
	interface MarkdownPosition {
	    start: {
	        line: number;
	        column: number;
	        offset: number;
	    };
	    end: {
	        line: number;
	        column: number;
	        offset: number;
	    };
	}
	export interface ContextShape {
	    openPluginEditor: (plugin: EuiMarkdownEditorUiPlugin) => void;
	    replaceNode(position: MarkdownPosition, next: string): void;
	    readOnly?: boolean;
	}
	export const EuiMarkdownContext: import("react").Context<ContextShape>;
	export {};

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_editor.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiMarkdownEditorVariables: ({ euiTheme }: UseEuiTheme) => {
	    minHeight: string;
	    borderRadius: import("csstype").Property.BorderRadius<string | number> | undefined;
	    barsBackgroundColor: string;
	};
	export const euiMarkdownEditorStyles: (euiThemeContext: UseEuiTheme) => {
	    euiMarkdownEditor: import("@emotion/utils").SerializedStyles;
	    fullHeight: import("@emotion/utils").SerializedStyles;
	    euiMarkdownEditorPreview: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_editor_toolbar.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiMarkdownEditorToolbarStyles: (euiThemeContext: UseEuiTheme) => {
	    euiMarkdownEditorToolbar: import("@emotion/utils").SerializedStyles;
	    euiMarkdownEditorToolbar__buttons: import("@emotion/utils").SerializedStyles;
	    euiMarkdownEditorToolbar__divider: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_editor_toolbar' {
	import React, { HTMLAttributes, MouseEventHandler } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { MARKDOWN_MODE } from '@elastic/eui/src/components/markdown_editor/markdown_modes';
	import { EuiMarkdownEditorUiPlugin } from '@elastic/eui/src/components/markdown_editor/markdown_types';
	import MarkdownActions from '@elastic/eui/src/components/markdown_editor/markdown_actions';
	export type EuiMarkdownEditorToolbarProps = HTMLAttributes<HTMLDivElement> & CommonProps & {
	    selectedNode?: null | any;
	    markdownActions: MarkdownActions;
	    viewMode: MARKDOWN_MODE;
	    onClickPreview: MouseEventHandler<HTMLButtonElement>;
	    uiPlugins: EuiMarkdownEditorUiPlugin[];
	};
	export const EuiMarkdownEditorToolbar: React.ForwardRefExoticComponent<React.HTMLAttributes<HTMLDivElement> & CommonProps & {
	    selectedNode?: null | any;
	    markdownActions: MarkdownActions;
	    viewMode: MARKDOWN_MODE;
	    onClickPreview: MouseEventHandler<HTMLButtonElement>;
	    uiPlugins: EuiMarkdownEditorUiPlugin[];
	} & React.RefAttributes<HTMLDivElement>>;

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_editor_text_area.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiMarkdownEditorTextAreaStyles: (euiThemeContext: UseEuiTheme) => {
	    euiMarkdownEditorTextArea: import("@emotion/utils").SerializedStyles;
	    readOnly: import("@emotion/utils").SerializedStyles;
	    editable: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_editor_text_area' {
	import React, { TextareaHTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiMarkdownEditorTextAreaProps = TextareaHTMLAttributes<HTMLTextAreaElement> & CommonProps & {
	    isInvalid?: boolean;
	    fullWidth?: boolean;
	    compressed?: boolean;
	    height: string;
	    maxHeight: string;
	};
	export const EuiMarkdownEditorTextArea: React.ForwardRefExoticComponent<React.TextareaHTMLAttributes<HTMLTextAreaElement> & CommonProps & {
	    isInvalid?: boolean | undefined;
	    fullWidth?: boolean | undefined;
	    compressed?: boolean | undefined;
	    height: string;
	    maxHeight: string;
	} & React.RefAttributes<HTMLTextAreaElement>>;

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_format.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	/**
	 * Styles
	 */
	export const euiMarkdownFormatStyles: (euiTheme: UseEuiTheme) => {
	    euiMarkdownFormat: import("@emotion/utils").SerializedStyles;
	    m: import("@emotion/utils").SerializedStyles;
	    s: import("@emotion/utils").SerializedStyles;
	    xs: import("@emotion/utils").SerializedStyles;
	    relative: import("@emotion/utils").SerializedStyles;
	    colors: {
	        default: import("@emotion/utils").SerializedStyles;
	        subdued: import("@emotion/utils").SerializedStyles;
	        success: import("@emotion/utils").SerializedStyles;
	        accent: import("@emotion/utils").SerializedStyles;
	        warning: import("@emotion/utils").SerializedStyles;
	        danger: import("@emotion/utils").SerializedStyles;
	        ghost: import("@emotion/utils").SerializedStyles;
	        inherit: import("@emotion/utils").SerializedStyles;
	        custom: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/markdown_tooltip/types' {
	export interface TooltipNodeDetails {
	    type: 'tooltipPlugin';
	    content: string;
	}

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/markdown_tooltip/parser' {
	import { Plugin } from 'unified';
	export const TooltipParser: Plugin;

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/markdown_tooltip/plugin' {
	import React from 'react';
	export const tooltipPlugin: {
	    name: string;
	    button: {
	        label: string;
	        iconType: string;
	    };
	    formatting: {
	        prefix: string;
	        suffix: string;
	        trimFirst: boolean;
	    };
	    helpText: React.JSX.Element;
	};

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/markdown_tooltip/renderer' {
	import { FunctionComponent, PropsWithChildren } from 'react';
	import { EuiMarkdownAstNodePosition } from '@elastic/eui/src/components/markdown_editor/markdown_types';
	import { TooltipNodeDetails } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_tooltip/types'; type TooltipMarkdownRendererProps = PropsWithChildren & TooltipNodeDetails & {
	    position: EuiMarkdownAstNodePosition;
	};
	export const tooltipMarkdownRenderer: FunctionComponent<TooltipMarkdownRendererProps>;
	export {};

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/markdown_tooltip' {
	export { TooltipParser as parser } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_tooltip/parser';
	export { tooltipPlugin as plugin } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_tooltip/plugin';
	export { tooltipMarkdownRenderer as renderer } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_tooltip/renderer';
	export * from '@elastic/eui/src/components/markdown_editor/plugins/markdown_tooltip/types';

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/remark/remark_prismjs' {
	import { Plugin } from 'unified';
	export const FENCED_CLASS = "remark-prismjs--fenced"; const attacher: Plugin;
	export default attacher;

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/markdown_checkbox/types' {
	export interface CheckboxNodeDetails {
	    type: 'checkboxPlugin';
	    lead: string;
	    label: string;
	    isChecked: boolean;
	}

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/markdown_checkbox/parser' {
	import { Plugin } from 'unified';
	export const CheckboxParser: Plugin;

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/markdown_checkbox/renderer' {
	import { FunctionComponent, PropsWithChildren } from 'react';
	import { EuiMarkdownAstNodePosition } from '@elastic/eui/src/components/markdown_editor/markdown_types';
	import { CheckboxNodeDetails } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_checkbox/types'; type CheckboxMarkdownRendererProps = PropsWithChildren & CheckboxNodeDetails & {
	    position: EuiMarkdownAstNodePosition;
	};
	export const CheckboxMarkdownRenderer: FunctionComponent<CheckboxMarkdownRendererProps>;
	export {};

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/markdown_checkbox' {
	export { CheckboxParser as parser } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_checkbox/parser';
	export { CheckboxMarkdownRenderer as renderer } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_checkbox/renderer';
	export * from '@elastic/eui/src/components/markdown_editor/plugins/markdown_checkbox/types';

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/markdown_link_validator' {
	interface LinkOrTextNode {
	    type: string;
	    url?: string;
	    title?: string | null;
	    value?: string;
	    children?: Array<{
	        value: string;
	    }>;
	}
	export type EuiMarkdownLinkValidatorOptions = {
	    /**
	     * Allow or disallow relative links (links that begin with a `/`)
	     * @default true
	     */
	    allowRelative?: boolean;
	    /**
	     * Allow or disallow specific [URL protocols or schemes](https://developer.mozilla.org/en-US/docs/Web/URI/Schemes)
	     * @default ['https:', 'http:', 'mailto:']
	     */
	    allowProtocols?: string[];
	};
	export const DEFAULT_OPTIONS: {
	    allowRelative: boolean;
	    allowProtocols: string[];
	};
	export function euiMarkdownLinkValidator(options: EuiMarkdownLinkValidatorOptions): (ast: any) => void;
	export function mutateLinkToText(node: LinkOrTextNode): LinkOrTextNode;
	export function validateUrl(url: string, { allowRelative, allowProtocols, }: EuiMarkdownLinkValidatorOptions): boolean;
	export {};

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins/parsing_plugins' {
	import { PluggableList } from 'unified';
	import { EuiMarkdownLinkValidatorOptions } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_link_validator';
	import type { DefaultPluginsConfig } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins/plugins';
	export type DefaultEuiMarkdownParsingPlugins = PluggableList;
	export type DefaultParsingPluginsConfig = {
	    /**
	     * Allows enabling emoji rendering for emoticons such as :) and :(
	     * @default { emoticon: false }
	     */
	    emoji?: {
	        emoticon?: boolean;
	    };
	    /**
	     * Allows configuring the `allowRelative` and `allowProtocols` of
	     * #EuiMarkdownLinkValidatorOptions
	     */
	    linkValidator?: EuiMarkdownLinkValidatorOptions;
	};
	export const getDefaultEuiMarkdownParsingPlugins: ({ exclude, ...parsingConfig }?: DefaultPluginsConfig & DefaultParsingPluginsConfig) => DefaultEuiMarkdownParsingPlugins;
	export const defaultParsingPlugins: DefaultEuiMarkdownParsingPlugins;

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins/processing_plugins' {
	import React from 'react';
	import { Plugin, PluggableList, Pluggable, Settings } from 'unified';
	import { Options as Remark2RehypeOptions } from 'mdast-util-to-hast';
	import rehype2react from 'rehype-react';
	import { EuiLinkProps } from '@elastic/eui/src/components/link';
	import type { DefaultPluginsConfig } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins/plugins';
	export interface Rehype2ReactOptions {
	    components: {
	        [key: string]: React.ComponentType<any>;
	    };
	    [key: string]: any;
	}
	export type DefaultEuiMarkdownProcessingPlugins = [
	    [
	        Plugin,
	        Remark2RehypeOptions
	    ],
	    [
	        typeof rehype2react,
	        Rehype2ReactOptions
	    ],
	    ...PluggableList
	];
	export type DefaultProcessingPluginsConfig = {
	    /**
	     * Allows customizing all formatted links.
	     * Accepts any prop that [EuiLink](/#/navigation/link) or any anchor link tag accepts.
	     * Useful for, e.g. setting `target="_blank"` on all links
	     */
	    linkProps?: Partial<EuiLinkProps>;
	};
	export const getDefaultEuiMarkdownProcessingPlugins: ({ exclude, linkProps, }?: DefaultPluginsConfig & DefaultProcessingPluginsConfig) => [[Plugin<[(Settings | undefined)?], Settings>, Remark2RehypeOptions], [typeof rehype2react, Rehype2ReactOptions], ...Pluggable<any[], Settings>[]];
	export const defaultProcessingPlugins: [[Plugin<[(Settings | undefined)?], Settings>, Remark2RehypeOptions], [typeof rehype2react, Rehype2ReactOptions], ...Pluggable<any[], Settings>[]];

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins/plugins' {
	import { DefaultEuiMarkdownUiPlugins } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins/ui_plugins';
	import { DefaultEuiMarkdownParsingPlugins, type DefaultParsingPluginsConfig } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins/parsing_plugins';
	import { DefaultEuiMarkdownProcessingPlugins, type DefaultProcessingPluginsConfig } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins/processing_plugins';
	export type ExcludableDefaultPlugins = 'emoji' | 'lineBreaks' | 'linkValidator' | 'checkbox' | 'tooltip';
	export type DefaultPluginsConfig = undefined | {
	    exclude?: ExcludableDefaultPlugins[];
	};
	export const getDefaultEuiMarkdownPlugins: (config?: DefaultPluginsConfig & {
	    processingConfig?: DefaultProcessingPluginsConfig;
	    parsingConfig?: DefaultParsingPluginsConfig;
	    uiConfig?: {};
	}) => {
	    parsingPlugins: DefaultEuiMarkdownParsingPlugins;
	    processingPlugins: DefaultEuiMarkdownProcessingPlugins;
	    uiPlugins: DefaultEuiMarkdownUiPlugins;
	};

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins/ui_plugins' {
	import { EuiMarkdownEditorUiPlugin } from '@elastic/eui/src/components/markdown_editor/markdown_types';
	import type { DefaultPluginsConfig } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins/plugins';
	export type DefaultEuiMarkdownUiPlugins = EuiMarkdownEditorUiPlugin[];
	export const getDefaultEuiMarkdownUiPlugins: ({ exclude, }?: DefaultPluginsConfig) => DefaultEuiMarkdownUiPlugins;
	export const defaultUiPlugins: DefaultEuiMarkdownUiPlugins;

}
declare module '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins' {
	export * from '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins/ui_plugins';
	export * from '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins/parsing_plugins';
	export * from '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins/processing_plugins';
	export * from '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins/plugins';

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_format' {
	import { FunctionComponent } from 'react';
	import { PluggableList } from 'unified';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiTextProps } from '@elastic/eui/src/components/text/text';
	export type EuiMarkdownFormatProps = CommonProps & Omit<EuiTextProps, 'size'> & {
	    children: string;
	    /** array of unified plugins to parse content into an AST */
	    parsingPluginList?: PluggableList;
	    /** array of unified plugins to convert the AST into a ReactNode */
	    processingPluginList?: PluggableList;
	    /**
	     * Determines the text size. Choose `relative` to control the `font-size` based on the value of a parent container.
	     */
	    textSize?: EuiTextProps['size'];
	};
	export const EuiMarkdownFormat: FunctionComponent<EuiMarkdownFormatProps>;

}
declare module '@elastic/eui/src/components/markdown_editor/icons/markdown_logo' {
	import React from 'react';
	interface SVGRProps {
	    title?: string;
	    titleId?: string;
	} const MarkdownLogo: ({ title, titleId, ...props }: React.SVGProps<SVGSVGElement> & SVGRProps) => React.JSX.Element;
	export default MarkdownLogo;

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_editor_footer.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiMarkdownEditorFooterStyles: (euiThemeContext: UseEuiTheme) => {
	    euiMarkdownEditorFooter: import("@emotion/utils").SerializedStyles;
	    euiMarkdownEditorFooter__actions: import("@emotion/utils").SerializedStyles;
	    euiMarkdownEditorFooter__uploadError: import("@emotion/utils").SerializedStyles;
	    euiMarkdownEditorFooter__helpButton: import("@emotion/utils").SerializedStyles;
	    euiMarkdownEditorFooter__popover: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_editor_footer' {
	import React from 'react';
	import { EuiMarkdownDropHandler, EuiMarkdownEditorUiPlugin, EuiMarkdownParseError } from '@elastic/eui/src/components/markdown_editor/markdown_types';
	interface EuiMarkdownEditorFooterProps {
	    uiPlugins: EuiMarkdownEditorUiPlugin[];
	    isUploadingFiles: boolean;
	    openFiles: () => void;
	    errors: EuiMarkdownParseError[];
	    hasUnacceptedItems: boolean;
	    dropHandlers: EuiMarkdownDropHandler[];
	}
	export const EuiMarkdownEditorFooter: React.ForwardRefExoticComponent<EuiMarkdownEditorFooterProps & React.RefAttributes<HTMLDivElement>>;
	export {};

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_editor_drop_zone.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiMarkdownEditorDropZoneStyles: (euiThemeContext: UseEuiTheme) => {
	    euiMarkdownEditorDropZone: import("@emotion/utils").SerializedStyles;
	    isDragging: import("@emotion/utils").SerializedStyles;
	    isDraggingError: import("@emotion/utils").SerializedStyles;
	    hasError: import("@emotion/utils").SerializedStyles;
	    euiMarkdownEditorDropZone__input: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_editor_drop_zone' {
	import { FunctionComponent, PropsWithChildren } from 'react';
	import { EuiMarkdownEditorUiPlugin, EuiMarkdownParseError, EuiMarkdownDropHandler, EuiMarkdownStringTagConfig } from '@elastic/eui/src/components/markdown_editor/markdown_types';
	interface EuiMarkdownEditorDropZoneProps extends PropsWithChildren {
	    uiPlugins: EuiMarkdownEditorUiPlugin[];
	    errors: EuiMarkdownParseError[];
	    dropHandlers: EuiMarkdownDropHandler[];
	    insertText: (text: string, config: EuiMarkdownStringTagConfig) => void;
	    hasUnacceptedItems: boolean;
	    setHasUnacceptedItems: (hasUnacceptedItems: boolean) => void;
	    setEditorFooterHeight: (height: number) => void;
	    isEditing: boolean;
	}
	export const EuiMarkdownEditorDropZone: FunctionComponent<EuiMarkdownEditorDropZoneProps>;
	export {};

}
declare module '@elastic/eui/src/components/markdown_editor/markdown_editor' {
	import React, { HTMLAttributes } from 'react';
	import { PluggableList } from 'unified';
	import { VFileMessage } from 'vfile-message';
	import { CommonProps, OneOf } from '@elastic/eui/src/components/common';
	import { EuiMarkdownEditorTextAreaProps } from '@elastic/eui/src/components/markdown_editor/markdown_editor_text_area';
	import { EuiMarkdownFormatProps } from '@elastic/eui/src/components/markdown_editor/markdown_format';
	import { MARKDOWN_MODE } from '@elastic/eui/src/components/markdown_editor/markdown_modes';
	import { EuiMarkdownAstNode, EuiMarkdownDropHandler, EuiMarkdownEditorUiPlugin, EuiMarkdownParseError } from '@elastic/eui/src/components/markdown_editor/markdown_types';
	import { ContextShape } from '@elastic/eui/src/components/markdown_editor/markdown_context'; type CommonMarkdownEditorProps = Omit<HTMLAttributes<HTMLDivElement>, 'onChange' | 'placeholder'> & CommonProps & {
	    /** aria-label OR aria-labelledby must be set */
	    'aria-label'?: string;
	    /** aria-label OR aria-labelledby must be set */
	    'aria-labelledby'?: string;
	    /** ID of an element describing the text editor, useful for associating error messages */
	    'aria-describedby'?: string;
	    /** a unique ID to attach to the textarea. If one isn't provided, a random one
	     * will be generated */
	    editorId?: string;
	    /** A markdown content */
	    value: string;
	    /** callback function when markdown content is modified */
	    onChange: (value: string) => void;
	    /**
	     * Sets the current display mode to a read-only state. All editing gets resctricted.
	     */
	    readOnly?: ContextShape['readOnly'];
	    /**
	     * Sets the `height` in pixels of the editor/preview area or pass `full` to allow
	     * the EuiMarkdownEditor to fill the height of its container.
	     * When in `full` mode the vertical resize is not allowed.
	     */
	    height?: number | 'full';
	    /**
	     * Sets the `max-height` in pixels of the editor/preview area.
	     * It has no effect when the `height` is set to `full`.
	     */
	    maxHeight?: number;
	    /**
	     * Automatically adjusts the preview height to fit all the content and avoid a scrollbar.
	     */
	    autoExpandPreview?: boolean;
	    /** plugins to identify new syntax and parse it into an AST node */
	    parsingPluginList?: PluggableList;
	    /** plugins to process the markdown AST nodes into a React nodes */
	    processingPluginList?: PluggableList;
	    /** defines UI for plugins' buttons in the toolbar as well as any modals or extra UI that provides content to the editor */
	    uiPlugins?: EuiMarkdownEditorUiPlugin[];
	    /** errors to bubble up */
	    errors?: EuiMarkdownParseError[];
	    /** callback triggered when parsing results are available */
	    onParse?: (error: EuiMarkdownParseError | null, data: {
	        messages: VFileMessage[];
	        ast: EuiMarkdownAstNode;
	    }) => void;
	    /** initial display mode for the editor */
	    initialViewMode?: MARKDOWN_MODE;
	    /** array defining any drag&drop handlers */
	    dropHandlers?: EuiMarkdownDropHandler[];
	    /**
	     * Sets the placeholder of the textarea
	     */
	    placeholder?: EuiMarkdownEditorTextAreaProps['placeholder'];
	    /**
	     * Further extend the props applied to EuiMarkdownFormat
	     */
	    markdownFormatProps?: Omit<EuiMarkdownFormatProps, 'parsingPluginList' | 'processingPluginList' | 'children'>;
	};
	export type EuiMarkdownEditorProps = OneOf<CommonMarkdownEditorProps, 'aria-label' | 'aria-labelledby'>;
	interface EuiMarkdownEditorRef {
	    textarea: HTMLTextAreaElement | null;
	    replaceNode: ContextShape['replaceNode'];
	}
	export const EuiMarkdownEditor: React.ForwardRefExoticComponent<EuiMarkdownEditorProps & React.RefAttributes<EuiMarkdownEditorRef>>;
	export {};

}
declare module '@elastic/eui/src/components/markdown_editor' {
	export type { EuiMarkdownEditorProps } from '@elastic/eui/src/components/markdown_editor/markdown_editor';
	export { EuiMarkdownEditor } from '@elastic/eui/src/components/markdown_editor/markdown_editor';
	export { getDefaultEuiMarkdownParsingPlugins, getDefaultEuiMarkdownProcessingPlugins, getDefaultEuiMarkdownUiPlugins, getDefaultEuiMarkdownPlugins, } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_default_plugins';
	export { EuiMarkdownContext } from '@elastic/eui/src/components/markdown_editor/markdown_context';
	export type { EuiMarkdownFormatProps } from '@elastic/eui/src/components/markdown_editor/markdown_format';
	export { EuiMarkdownFormat } from '@elastic/eui/src/components/markdown_editor/markdown_format';
	export type { EuiMarkdownParseError, EuiMarkdownAstNode, EuiMarkdownAstNodePosition, EuiMarkdownFormatting, EuiMarkdownEditorUiPlugin, RemarkRehypeHandler, RemarkTokenizer, } from '@elastic/eui/src/components/markdown_editor/markdown_types';
	export { euiMarkdownLinkValidator } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_link_validator';
	export type { EuiMarkdownLinkValidatorOptions } from '@elastic/eui/src/components/markdown_editor/plugins/markdown_link_validator';

}
declare module '@elastic/eui/src/components/page/_restrict_width' {
	/**
	 * The `restrictedWidth` property is the same for all EuiPage components.
	 * This is file contains the type specific to that prop and a helper
	 * function for creating the corresponding classNames and style tags
	 * based on the consumer's configuration
	 */
	import { CSSProperties } from 'react';
	export const PAGE_MAX_WIDTH: CSSProperties['maxWidth'];
	export type _EuiPageRestrictWidth = {
	    /**
	     * Sets the max-width of the page,
	     * set to `true` to use the default size of `1200px`,
	     * set to `false` to not restrict the width,
	     * set to a number for a custom width in px,
	     * set to a string for a custom width in custom measurement.
	     */
	    restrictWidth?: boolean | number | string;
	};
	/**
	 * **DEPRECATED**
	 * This function calculates the correct class name and combined styles
	 * based on the `restrictWidth` value passed in
	 *
	 * @param restrictWidth `boolean | number | string` The prop value
	 * @param style `CSSProperties` An object of style attributes if provided
	 * @returns An object with keys for the `widthClassName` to append to the component's class and the updated `newStyle` props
	 */
	export function setPropsForRestrictedPageWidth(restrictWidth: _EuiPageRestrictWidth['restrictWidth'], style?: CSSProperties): {
	    widthClassName?: string;
	    newStyle: CSSProperties;
	};
	/**
	 * This function calculates the correct just the combined styles
	 * based on the `restrictWidth` value passed in
	 *
	 * @param restrictWidth `boolean | number | string` The prop value
	 * @param style `CSSProperties` An object of style attributes if provided
	 * @returns An object of the updated `style` props
	 */
	export function setStyleForRestrictedPageWidth(restrictWidth: _EuiPageRestrictWidth['restrictWidth'], style?: CSSProperties): CSSProperties;

}
declare module '@elastic/eui/src/components/page/page.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiPageStyles: (euiThemeContext: UseEuiTheme) => {
	    euiPage: import("@emotion/utils").SerializedStyles;
	    grow: import("@emotion/utils").SerializedStyles;
	    column: import("@emotion/utils").SerializedStyles;
	    row: import("@emotion/utils").SerializedStyles;
	    restrictWidth: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/page/page' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { _EuiPageRestrictWidth } from '@elastic/eui/src/components/page/_restrict_width';
	import { EuiPaddingSize } from '@elastic/eui/src/global_styling';
	export interface EuiPageProps extends CommonProps, HTMLAttributes<HTMLDivElement>, _EuiPageRestrictWidth {
	    /**
	     * Adjust the padding.
	     * When using this setting it's best to be consistent throughout all similar usages
	     */
	    paddingSize?: EuiPaddingSize;
	    /**
	     * Adds `flex-grow: 1` to the whole page for stretching to fit vertically.
	     * Must be wrapped inside a flexbox, preferrably with `min-height: 100vh`
	     */
	    grow?: boolean;
	    /**
	     * Changes the `flex-direction` property.
	     * Flip to `column` when not including a sidebar.
	     */
	    direction?: 'row' | 'column';
	}
	export const EuiPage: FunctionComponent<EuiPageProps>;

}
declare module '@elastic/eui/src/components/page/page_body/page_body.styles' {
	export const euiPageBodyStyles: () => {
	    euiPageBody: import("@emotion/utils").SerializedStyles;
	    restrictWidth: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/page/page_body/page_body' {
	import React, { PropsWithChildren, ComponentType, ComponentProps } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { _EuiPageRestrictWidth } from '@elastic/eui/src/components/page/_restrict_width';
	import { EuiPanelProps } from '@elastic/eui/src/components/panel';
	import { EuiPaddingSize } from '@elastic/eui/src/global_styling'; type ComponentTypes = keyof JSX.IntrinsicElements | ComponentType<any>;
	export type EuiPageBodyProps<T extends ComponentTypes = 'main'> = PropsWithChildren & CommonProps & ComponentProps<T> & _EuiPageRestrictWidth & {
	    /**
	     * Sets the HTML element for `EuiPageBody`.
	     */
	    component?: T;
	    /**
	     * Uses an EuiPanel as the main component instead of a plain div
	     */
	    panelled?: boolean;
	    /**
	     * Extends any extra EuiPanel props if `panelled=true`
	     */
	    panelProps?: Omit<EuiPanelProps, 'paddingSize'>;
	    /**
	     * Adjusts the padding
	     */
	    paddingSize?: EuiPaddingSize;
	};
	export const EuiPageBody: <T extends ComponentTypes>({ children, restrictWidth, className, css, component: Component, panelled, panelProps, paddingSize, borderRadius, ...rest }: EuiPageBodyProps<T>) => React.JSX.Element;
	export {};

}
declare module '@elastic/eui/src/components/page/page_body' {
	export type { EuiPageBodyProps } from '@elastic/eui/src/components/page/page_body/page_body';
	export { EuiPageBody } from '@elastic/eui/src/components/page/page_body/page_body';

}
declare module '@elastic/eui/src/components/page/page_header/page_header.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiPageHeaderStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiPageHeader: import("@emotion/utils").SerializedStyles;
	    border: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/page/page_header/page_header_content.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiPageHeaderContentStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiPageHeaderContent: import("@emotion/utils").SerializedStyles;
	    top: import("@emotion/utils").SerializedStyles;
	    bottom: import("@emotion/utils").SerializedStyles;
	    center: import("@emotion/utils").SerializedStyles;
	    stretch: import("@emotion/utils").SerializedStyles;
	    childrenOnly: {
	        flex: import("@emotion/utils").SerializedStyles;
	        responsive: import("@emotion/utils").SerializedStyles;
	        responsiveReverse: import("@emotion/utils").SerializedStyles;
	    };
	    euiPageHeaderContent__top: import("@emotion/utils").SerializedStyles;
	    euiPageHeaderContent__leftSideItems: import("@emotion/utils").SerializedStyles;
	    euiPageHeaderContent__rightSideItems: import("@emotion/utils").SerializedStyles;
	    euiPageHeaderContent__rightSideItem: import("@emotion/utils").SerializedStyles;
	    euiPageHeaderContent__titleIcon: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/page/page_header/page_header_content' {
	import { FunctionComponent, ReactNode, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiIconProps, IconType } from '@elastic/eui/src/components/icon';
	import { EuiTabsProps } from '@elastic/eui/src/components/tabs';
	import { Props as EuiTabProps } from '@elastic/eui/src/components/tabs/tab';
	import { EuiFlexGroupProps } from '@elastic/eui/src/components/flex';
	import { EuiTitleProps } from '@elastic/eui/src/components/title';
	import { EuiBreadcrumbsProps } from '@elastic/eui/src/components/breadcrumbs';
	import { PADDING_SIZES } from '@elastic/eui/src/global_styling';
	import { _EuiPageRestrictWidth } from '@elastic/eui/src/components/page/_restrict_width';
	export const ALIGN_ITEMS: readonly ["top", "bottom", "center", "stretch"]; type Tab = EuiTabProps & {
	    /**
	     * Visible text of the tab
	     */
	    label: ReactNode;
	};
	export interface EuiPageHeaderContentTitle {
	    /**
	     * Wrapped in an `H1` so choose appropriately.
	     * A simple string is best
	     */
	    pageTitle?: ReactNode;
	    /**
	     * Additional props to pass to the EuiTitle
	     */
	    pageTitleProps?: Omit<EuiTitleProps, 'children' | 'size'>;
	    /**
	     * Optional icon to place to the left of the title
	     */
	    iconType?: IconType;
	    /**
	     * Additional EuiIcon props to apply to the optional icon
	     */
	    iconProps?: Partial<Omit<EuiIconProps, 'type'>>;
	    /**
	     * Optional array breadcrumbs that render before the `pageTitle`
	     */
	    breadcrumbs?: EuiBreadcrumbsProps['breadcrumbs'];
	    /**
	     * Adjust the props of [EuiBreadcrumbs](#/navigation/breadcrumbs)
	     */
	    breadcrumbProps?: Partial<Omit<EuiBreadcrumbsProps, 'breadcrumbs'>>;
	}
	export interface EuiPageHeaderContentTabs {
	    /**
	     * In-app navigation presented as large borderless tabs.
	     * Accepts an array of `EuiTab` objects;
	     */
	    tabs?: Tab[];
	    /**
	     * Any extras to apply to the outer tabs container.
	     * Extends `EuiTabs`
	     */
	    tabsProps?: Omit<EuiTabsProps, 'size' | 'expand'>;
	}
	/**
	 * The left side can either be a title with optional description and/or icon;
	 * Or a list of tabs,
	 * Or a custom node
	 */
	interface EuiPageHeaderContentLeft extends EuiPageHeaderContentTitle, EuiPageHeaderContentTabs {
	    /**
	     * Position is dependent on existing with a `pageTitle` or `tabs`
	     * Automatically get wrapped in a single paragraph tag inside an EuiText block
	     */
	    description?: string | ReactNode;
	}
	export interface _EuiPageHeaderContentProps extends EuiPageHeaderContentLeft, _EuiPageRestrictWidth {
	    /**
	     * If not set, defaults to true if `tabs` are passed and render at the bottom of the page.
	     * Otherwise, defaults to false.
	     */
	    bottomBorder?: boolean;
	    /**
	     * Adjust the padding.
	     * When using this setting it's best to be consistent throughout all similar usages
	     */
	    paddingSize?: (typeof PADDING_SIZES)[number];
	    /**
	     * Set to false if you don't want the children to stack at small screen sizes.
	     * Set to `reverse` to display the right side content first for the sake of hierarchy (like global time)
	     */
	    responsive?: boolean | 'reverse';
	    /**
	     * Vertical alignment of the left and right side content;
	     * Default is `center` for custom content, but `top` for when `pageTitle` or `tabs` are included
	     */
	    alignItems?: (typeof ALIGN_ITEMS)[number];
	    /**
	     * Pass custom an array of content to this side usually up to 3 buttons.
	     * The first button should be primary, usually with `fill`. At larger breakpoints, items will
	     * render from right to left, but will collapse vertically and render left to right on smaller mobile screens.
	     */
	    rightSideItems?: ReactNode[];
	    /**
	     * Additional EuiFlexGroup props to pass to the container of the `rightSideItems`
	     */
	    rightSideGroupProps?: Partial<EuiFlexGroupProps>;
	    /**
	     * Custom children will be rendered before the `tabs` unless no `pageTitle` is present, then it will be the last item
	     */
	    children?: ReactNode;
	}
	export interface EuiPageHeaderContentProps extends CommonProps, HTMLAttributes<HTMLDivElement>, _EuiPageHeaderContentProps {
	}
	export const EuiPageHeaderContent: FunctionComponent<EuiPageHeaderContentProps>;
	export {};

}
declare module '@elastic/eui/src/components/page/_bottom_border' {
	export type _EuiPageBottomBorder = {
	    /**
	     * Adds a bottom border to separate it from the content after;
	     * Passing `extended` will ensure the border touches the sides of the parent container.
	     */
	    bottomBorder?: boolean | 'extended';
	};

}
declare module '@elastic/eui/src/components/page/page_header/page_header' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiPaddingSize } from '@elastic/eui/src/global_styling';
	import { _EuiPageHeaderContentProps } from '@elastic/eui/src/components/page/page_header/page_header_content';
	import { _EuiPageRestrictWidth } from '@elastic/eui/src/components/page/_restrict_width';
	import { _EuiPageBottomBorder } from '@elastic/eui/src/components/page/_bottom_border';
	export interface EuiPageHeaderProps extends CommonProps, HTMLAttributes<HTMLElement>, Omit<_EuiPageHeaderContentProps, 'bottomBorder'>, _EuiPageRestrictWidth, _EuiPageBottomBorder {
	    /**
	     * Adjust the overall padding.
	     */
	    paddingSize?: EuiPaddingSize;
	}
	export const EuiPageHeader: FunctionComponent<EuiPageHeaderProps>;

}
declare module '@elastic/eui/src/components/page/page_header/page_header_section' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export interface EuiPageHeaderSectionProps extends CommonProps, HTMLAttributes<HTMLDivElement> {
	}
	export const EuiPageHeaderSection: FunctionComponent<EuiPageHeaderSectionProps>;

}
declare module '@elastic/eui/src/components/page/page_header' {
	export type { EuiPageHeaderProps } from '@elastic/eui/src/components/page/page_header/page_header';
	export { EuiPageHeader } from '@elastic/eui/src/components/page/page_header/page_header';
	export type { EuiPageHeaderContentProps } from '@elastic/eui/src/components/page/page_header/page_header_content';
	export { EuiPageHeaderContent } from '@elastic/eui/src/components/page/page_header/page_header_content';
	export type { EuiPageHeaderSectionProps } from '@elastic/eui/src/components/page/page_header/page_header_section';
	export { EuiPageHeaderSection } from '@elastic/eui/src/components/page/page_header/page_header_section';

}
declare module '@elastic/eui/src/components/page/page_section/page_section.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const ALIGNMENTS: readonly ["top", "center", "horizontalCenter"];
	export const euiPageSectionStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiPageSection: import("@emotion/utils").SerializedStyles;
	    grow: import("@emotion/utils").SerializedStyles;
	    border: import("@emotion/utils").SerializedStyles;
	    top: import("@emotion/utils").SerializedStyles;
	    center: import("@emotion/utils").SerializedStyles;
	    horizontalCenter: import("@emotion/utils").SerializedStyles;
	};
	export const euiPageSectionContentStyles: () => {
	    euiPageSection__content: import("@emotion/utils").SerializedStyles;
	    center: import("@emotion/utils").SerializedStyles;
	    restrictWidth: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/page/page_section/page_section' {
	import { FunctionComponent, ComponentType, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { _EuiPageRestrictWidth } from '@elastic/eui/src/components/page/_restrict_width';
	import { _EuiPageBottomBorder } from '@elastic/eui/src/components/page/_bottom_border';
	import { ALIGNMENTS } from '@elastic/eui/src/components/page/page_section/page_section.styles';
	import { EuiPaddingSize, _EuiBackgroundColor } from '@elastic/eui/src/global_styling';
	export type EuiPageSectionProps = CommonProps & _EuiPageRestrictWidth & _EuiPageBottomBorder & {
	    /**
	     * Background color of the section;
	     * Usually a lightened form of the brand colors
	     */
	    color?: _EuiBackgroundColor;
	    /**
	     * Padding for all four sides
	     */
	    paddingSize?: EuiPaddingSize;
	    /**
	     * Horizontal and/or vertical alignment of the section contents
	     */
	    alignment?: (typeof ALIGNMENTS)[number];
	    /**
	     * When true the panel will grow in height to fill container if parent is a flex group
	     */
	    grow?: boolean;
	    /**
	     * Passed down to the div wrapper of the section contents
	     */
	    contentProps?: CommonProps & HTMLAttributes<HTMLDivElement>;
	    /**
	     * Sets which HTML element to render.
	     */
	    component?: keyof JSX.IntrinsicElements | ComponentType;
	} & Omit<HTMLAttributes<Element>, 'color'>;
	export const EuiPageSection: FunctionComponent<EuiPageSectionProps>;

}
declare module '@elastic/eui/src/components/page/page_section' {
	export type { EuiPageSectionProps } from '@elastic/eui/src/components/page/page_section/page_section';
	export { EuiPageSection } from '@elastic/eui/src/components/page/page_section/page_section';

}
declare module '@elastic/eui/src/components/page/page_sidebar/page_sidebar.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiPageSidebarStyles: (euiThemeContext: UseEuiTheme) => {
	    euiPageSidebar: import("@emotion/utils").SerializedStyles;
	    sticky: import("@emotion/utils").SerializedStyles;
	    embellish: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/page/page_sidebar/page_sidebar' {
	import { CSSProperties, FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiPaddingSize, _EuiThemeBreakpoint } from '@elastic/eui/src/global_styling';
	export interface EuiPageSidebarProps extends CommonProps, HTMLAttributes<HTMLDivElement> {
	    /**
	     * Adjust the padding.
	     * When using this setting it's best to be consistent throughout all similar usages.
	     */
	    paddingSize?: EuiPaddingSize;
	    /**
	     * Renders a fancy little visual in the top left corner of the side bar
	     */
	    hasEmbellish?: boolean;
	    /**
	     * Adds `position: sticky` and affords for any fixed position headers.
	     */
	    sticky?: boolean | {
	        /**
	         * To account for any fixed elements like headers,
	         * pass in the value of the total height of those fixed elements.
	         */
	        offset?: number;
	    };
	    /**
	     * A minimum width is necessary to maintain size.
	     * Be sure to take `paddingSize` into account.
	     */
	    minWidth?: CSSProperties['width'];
	    /**
	     * Sets the `minWidth` to 100% when within these breakpoints.
	     */
	    responsive?: _EuiThemeBreakpoint[];
	}
	export const EuiPageSidebar: FunctionComponent<EuiPageSidebarProps>;

}
declare module '@elastic/eui/src/components/page/page_sidebar' {
	export type { EuiPageSidebarProps } from '@elastic/eui/src/components/page/page_sidebar/page_sidebar';
	export { EuiPageSidebar } from '@elastic/eui/src/components/page/page_sidebar/page_sidebar';

}
declare module '@elastic/eui/src/components/page' {
	export type { EuiPageProps } from '@elastic/eui/src/components/page/page';
	export { EuiPage } from '@elastic/eui/src/components/page/page';
	export type { EuiPageBodyProps } from '@elastic/eui/src/components/page/page_body';
	export { EuiPageBody } from '@elastic/eui/src/components/page/page_body';
	export type { EuiPageHeaderContentProps, EuiPageHeaderProps, EuiPageHeaderSectionProps, } from '@elastic/eui/src/components/page/page_header';
	export { EuiPageHeader, EuiPageHeaderContent, EuiPageHeaderSection, } from '@elastic/eui/src/components/page/page_header';
	export type { EuiPageSectionProps } from '@elastic/eui/src/components/page/page_section';
	export { EuiPageSection } from '@elastic/eui/src/components/page/page_section';
	export type { EuiPageSidebarProps } from '@elastic/eui/src/components/page/page_sidebar';
	export { EuiPageSidebar } from '@elastic/eui/src/components/page/page_sidebar';

}
declare module '@elastic/eui/src/components/page_template/outer/page_outer.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiPageOuterStyles: ({ euiTheme }: UseEuiTheme) => {
	    euiPageOuter: import("@emotion/utils").SerializedStyles;
	    grow: import("@emotion/utils").SerializedStyles;
	    column: import("@emotion/utils").SerializedStyles;
	    row: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/page_template/outer/page_outer' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { _EuiThemeBreakpoint } from '@elastic/eui/src/global_styling';
	export const PAGE_DIRECTIONS: readonly ["row", "column"]; type PageDirections = (typeof PAGE_DIRECTIONS)[number];
	export interface _EuiPageOuterProps extends CommonProps, HTMLAttributes<HTMLDivElement> {
	    /**
	     * Adds `flex-grow: 1` to the whole page for stretching to fit vertically.
	     * Must be wrapped inside a flexbox, preferrably with `min-height: 100vh`
	     */
	    grow?: boolean;
	    /**
	     * Changes the `flex-direction` property.
	     * Flip to `column` when not including a sidebar.
	     */
	    direction?: PageDirections;
	    /**
	     * When direction is `row`, it will flip to `column` when within these breakpoints.
	     */
	    responsive?: _EuiThemeBreakpoint[];
	}
	export const _EuiPageOuter: FunctionComponent<_EuiPageOuterProps>;
	export {};

}
declare module '@elastic/eui/src/components/page_template/outer' {
	export type { _EuiPageOuterProps } from '@elastic/eui/src/components/page_template/outer/page_outer';
	export { _EuiPageOuter } from '@elastic/eui/src/components/page_template/outer/page_outer';

}
declare module '@elastic/eui/src/components/page_template/inner/page_inner.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiPageInnerStyles: (euiThemeContext: UseEuiTheme) => {
	    euiPageInner: import("@emotion/utils").SerializedStyles;
	    panelled: import("@emotion/utils").SerializedStyles;
	    border: {
	        top: import("@emotion/utils").SerializedStyles;
	        left: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/page_template/inner/page_inner' {
	import React, { PropsWithChildren, ComponentType, ComponentProps } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiPaddingSize, _EuiThemeBreakpoint } from '@elastic/eui/src/global_styling';
	export type ComponentTypes = keyof JSX.IntrinsicElements | ComponentType;
	export type _EuiPageInnerProps<T extends ComponentTypes = 'main'> = PropsWithChildren & CommonProps & ComponentProps<T> & {
	    /**
	     * Sets which HTML element to render.
	     */
	    component?: T;
	    /**
	     * Adds a white background and shadow to define the area.
	     */
	    panelled?: boolean;
	    /**
	     * Adds a single side border, based on the `responsive` state.
	     * Typically added when a side bar exists.
	     */
	    border?: boolean;
	    /**
	     * Adjust the overall padding.
	     */
	    paddingSize?: EuiPaddingSize;
	    /**
	     * Decides at which point the main content wrapper will be 100vw.
	     */
	    responsive?: _EuiThemeBreakpoint[];
	};
	export const _EuiPageInner: <T extends ComponentTypes>({ children, component: Component, panelled, border, paddingSize, responsive, ...rest }: _EuiPageInnerProps<T>) => React.JSX.Element;

}
declare module '@elastic/eui/src/components/page_template/inner' {
	export type { _EuiPageInnerProps } from '@elastic/eui/src/components/page_template/inner/page_inner';
	export { _EuiPageInner } from '@elastic/eui/src/components/page_template/inner/page_inner';

}
declare module '@elastic/eui/src/components/page_template/bottom_bar/page_bottom_bar' {
	import { FunctionComponent } from 'react';
	import { EuiBottomBarProps } from '@elastic/eui/src/components/bottom_bar';
	import { EuiPageSectionProps } from '@elastic/eui/src/components/page/page_section';
	import { _EuiPageRestrictWidth } from '@elastic/eui/src/components/page/_restrict_width';
	export interface _EuiPageBottomBarProps extends Pick<EuiPageSectionProps, 'paddingSize'>, _EuiPageRestrictWidth, Omit<EuiBottomBarProps, 'paddingSize'> {
	    /**
	     * The reference id of the element to insert into
	     */
	    parent?: string;
	}
	export const _EuiPageBottomBar: FunctionComponent<_EuiPageBottomBarProps>;

}
declare module '@elastic/eui/src/components/page_template/empty_prompt/page_empty_prompt' {
	import { FunctionComponent } from 'react';
	import { EuiEmptyPromptProps } from '@elastic/eui/src/components/empty_prompt';
	import { EuiPageSectionProps } from '@elastic/eui/src/components/page/page_section';
	export type _EuiPageEmptyPromptProps = Omit<EuiPageSectionProps, 'title' | 'bottomBorder'> & Omit<EuiEmptyPromptProps, 'paddingSize'> & {
	    panelled?: boolean;
	};
	export const _EuiPageEmptyPrompt: FunctionComponent<_EuiPageEmptyPromptProps>;

}
declare module '@elastic/eui/src/components/page_template/page_template' {
	import React, { CSSProperties, FunctionComponent, HTMLAttributes } from 'react';
	import { _EuiPageOuterProps } from '@elastic/eui/src/components/page_template/outer';
	import { _EuiPageInnerProps } from '@elastic/eui/src/components/page_template/inner';
	import { ComponentTypes } from '@elastic/eui/src/components/page_template/inner/page_inner';
	import { _EuiPageBottomBarProps } from '@elastic/eui/src/components/page_template/bottom_bar/page_bottom_bar';
	import { _EuiPageEmptyPromptProps } from '@elastic/eui/src/components/page_template/empty_prompt/page_empty_prompt';
	import { EuiPageHeaderProps, EuiPageSectionProps, EuiPageSidebarProps } from '@elastic/eui/src/components/page';
	import { _EuiPageRestrictWidth } from '@elastic/eui/src/components/page/_restrict_width';
	import { _EuiPageBottomBorder } from '@elastic/eui/src/components/page/_bottom_border';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export const TemplateContext: React.Context<{
	    sidebar: {};
	    section: {};
	    header: {};
	    emptyPrompt: {};
	    bottomBar: {};
	}>;
	export type EuiPageTemplateProps = _EuiPageOuterProps & Omit<_EuiPageInnerProps, 'border' | 'component'> & _EuiPageRestrictWidth & _EuiPageBottomBorder & {
	    /**
	     * Applies a top or left border to the inner contents
	     * to add separation between content and sidebar when a sidebar exists.
	     */
	    contentBorder?: _EuiPageInnerProps['border'];
	    /**
	     * Minimum height in which to enforce scrolling
	     */
	    minHeight?: CSSProperties['minHeight'];
	    /**
	     * To account for any fixed elements like headers,
	     * pass in the value of the total height of those fixed elements.
	     * Otherwise they will be calculated based on the data attributes on the body element.
	     */
	    offset?: number;
	    /**
	     * Passes through some common HTML attributes to the `main` content wrapper
	     */
	    mainProps?: CommonProps & HTMLAttributes<HTMLElement>;
	    /**
	     * Sets which HTML element to render for the `main` content wrapper
	     * @default main
	     */
	    component?: ComponentTypes;
	};
	/**
	 * Consumed via `EuiPageTemplate`,
	 * it controls and propogates most of the shared props per direct child
	 */
	export const _EuiPageTemplate: FunctionComponent<EuiPageTemplateProps>;
	export const EuiPageTemplate: React.FunctionComponent<EuiPageTemplateProps> & {
	    Sidebar: React.FunctionComponent<EuiPageSidebarProps>;
	    Header: React.FunctionComponent<EuiPageHeaderProps>;
	    Section: React.FunctionComponent<EuiPageSectionProps>;
	    BottomBar: React.FunctionComponent<_EuiPageBottomBarProps>;
	    EmptyPrompt: React.FunctionComponent<_EuiPageEmptyPromptProps>;
	};

}
declare module '@elastic/eui/src/components/page_template' {
	export type { EuiPageTemplateProps } from '@elastic/eui/src/components/page_template/page_template';
	export { EuiPageTemplate } from '@elastic/eui/src/components/page_template/page_template';

}
declare module '@elastic/eui/src/global_styling/utility/utility' {
	import React from 'react';
	import { UseEuiTheme } from '@elastic/eui/src/services/theme/hooks';
	export const globalStyles: (euiThemeContext: UseEuiTheme) => import("@emotion/utils").SerializedStyles;
	export const EuiUtilityClasses: () => React.JSX.Element;

}
declare module '@elastic/eui/src/components/provider/cache/cache_provider' {
	import React, { PropsWithChildren } from 'react';
	import { EmotionCache } from '@emotion/css';
	export interface EuiCacheProviderProps extends PropsWithChildren {
	    cache?: false | EmotionCache;
	}
	export const EuiCacheProvider: ({ cache, children, }: EuiCacheProviderProps) => React.JSX.Element;

}
declare module '@elastic/eui/src/components/provider/cache' {
	export * from '@elastic/eui/src/components/provider/cache/cache_provider';

}
declare module '@elastic/eui/src/components/provider/system_color_mode/system_color_mode_provider' {
	import { FunctionComponent, ReactElement } from 'react';
	import { EuiThemeColorModeStandard } from '@elastic/eui/src/services';
	export const COLOR_MODE_MEDIA_QUERY = "(prefers-color-scheme: dark)";
	export const EuiSystemColorModeProvider: FunctionComponent<{
	    children: (systemColorMode: EuiThemeColorModeStandard) => ReactElement;
	}>;

}
declare module '@elastic/eui/src/components/provider/system_color_mode' {
	export { EuiSystemColorModeProvider } from '@elastic/eui/src/components/provider/system_color_mode/system_color_mode_provider';

}
declare module '@elastic/eui/src/components/provider/nested/nested_context' {
	import React, { PropsWithChildren } from 'react';
	/**
	 * This util creates a context for EuiProviders to use and determine if they're
	 * the only (top-most) EuiProvider in the app. If they aren't (i.e., they're
	 * nested within another EuiProvider) we should throw a warning and not
	 * render instantiate the nested EuiProvider.
	 */
	export const EuiNestedProviderContext: React.Context<boolean>;
	export const EuiProviderNestedCheck: ({ children }: PropsWithChildren<{}>) => React.JSX.Element;
	export const useIsNestedEuiProvider: () => boolean;

}
declare module '@elastic/eui/src/components/provider/nested' {
	export * from '@elastic/eui/src/components/provider/nested/nested_context';

}
declare module '@elastic/eui/src/components/provider/provider' {
	import React, { PropsWithChildren } from 'react';
	import type { EmotionCache } from '@emotion/css';
	import { EuiThemeProviderProps, EuiThemeSystem, EuiThemeColorMode } from '@elastic/eui/src/services';
	import { EuiGlobalStylesProps } from '@elastic/eui/src/global_styling/reset/global_styles';
	import { EuiComponentDefaults } from '@elastic/eui/src/components/provider/component_defaults';
	export interface EuiProviderProps<T> extends PropsWithChildren, EuiGlobalStylesProps, Pick<EuiThemeProviderProps<T>, 'modify'> {
	    /**
	     * Provide a specific EuiTheme; Defaults to EuiThemeAmsterdam;
	     * Pass `null` to remove all theming including global reset
	     */
	    theme?: EuiThemeSystem | null;
	    /**
	     * Allows setting `light` or `dark` mode.
	     * Defaults to the user's OS/system setting if undefined.
	     */
	    colorMode?: EuiThemeColorMode;
	    /**
	     * Provide global styles via `@emotion/react` `Global` for your custom theme.
	     * Pass `false` to remove the default EUI global styles.
	     */
	    globalStyles?: false | ((params: any) => JSX.Element | null);
	    /**
	     * Provide utility classes.
	     * Pass `false` to remove the default EUI utility classes.
	     */
	    utilityClasses?: false | ((params: any) => JSX.Element | null);
	    /**
	     * Provide a cache configuration(s) from `@emotion/cache`.
	     *
	     * - `default` will encompass all Emotion styles, including consumer defined appliction styles, not handled by nested cache instances.
	     * - `global` will scope all EUI global and reset styles.
	     * - `utility` will scope all EUI utility class styles.
	     *
	     * A cache instance provided as the sole value will function the same as the `default` cache.
	     */
	    cache?: EmotionCache | {
	        default?: EmotionCache;
	        global?: EmotionCache;
	        utility?: EmotionCache;
	    };
	    /**
	     * Allows configuring specified component defaults across all usages, overriding
	     * baseline EUI component defaults.
	     *
	     * Not all components will be supported, and configurable component defaults
	     * will be considered on a case-by-case basis.
	     *
	     * Individual component prop usages will always override these defaults.
	     */
	    componentDefaults?: EuiComponentDefaults;
	}
	export const EuiProvider: <T extends {} = {}>({ cache, theme, globalStyles: Globals, utilityClasses: Utilities, colorMode, modify, componentDefaults, children, }: React.PropsWithChildren<EuiProviderProps<T>>) => any;

}
declare module '@elastic/eui/src/components/provider' {
	export type { EuiProviderProps } from '@elastic/eui/src/components/provider/provider';
	export { EuiProvider } from '@elastic/eui/src/components/provider/provider';
	export type { EuiComponentDefaultsProviderProps } from '@elastic/eui/src/components/provider/component_defaults';
	export { EuiComponentDefaultsProvider, EuiComponentDefaultsContext, } from '@elastic/eui/src/components/provider/component_defaults';

}
declare module '@elastic/eui/src/components/tree_view/tree_view_item.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiTreeViewItemStyles: (euiThemeContext: UseEuiTheme) => {
	    li: {
	        euiTreeView__node: import("@emotion/utils").SerializedStyles;
	        default: import("@emotion/utils").SerializedStyles;
	        compressed: import("@emotion/utils").SerializedStyles;
	        expanded: import("@emotion/utils").SerializedStyles;
	    };
	    button: {
	        euiTreeView__nodeInner: import("@emotion/utils").SerializedStyles;
	        default: import("@emotion/utils").SerializedStyles;
	        compressed: import("@emotion/utils").SerializedStyles;
	    };
	    icon: {
	        euiTreeView__iconWrapper: import("@emotion/utils").SerializedStyles;
	        default: import("@emotion/utils").SerializedStyles;
	        compressed: import("@emotion/utils").SerializedStyles;
	    };
	};

}
declare module '@elastic/eui/src/components/tree_view/tree_view_item' {
	import { FunctionComponent, HTMLAttributes, ReactNode, Ref } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiTreeViewProps } from '@elastic/eui/src/components/tree_view/tree_view';
	export type EuiTreeViewItemProps = Omit<HTMLAttributes<HTMLButtonElement>, 'id' | 'children'> & CommonProps & {
	    /**
	     * Required for `aria-controls` accessibility
	     */
	    id: string;
	    /**
	     * The main button content
	     */
	    label: ReactNode;
	    /**
	     * Used to render nested `EuiTreeView`s
	     */
	    children?: ReactNode;
	    /**
	     * Optional icon to render. Pass, e.g., `<EuiIcon />` or `<EuiToken />`
	     */
	    icon?: ReactNode;
	    /**
	     * Renders an arrow if `children` exists. Otherwise renders a blank icon
	     */
	    hasArrow?: boolean;
	    /**
	     * Adds a targetable modifier class
	     */
	    isActive?: boolean;
	    /**
	     * Sets the `aria-expanded` attribute
	     */
	    isExpanded?: boolean;
	    /**
	     * Determines default or compressed display
	     */
	    display?: EuiTreeViewProps['display'];
	    buttonRef?: Ref<HTMLButtonElement>;
	    /**
	     * Optional extra props to pass to the wrapping `<li>`
	     */
	    wrapperProps?: HTMLAttributes<HTMLLIElement>;
	};
	export const EuiTreeViewItem: FunctionComponent<EuiTreeViewItemProps>;

}
declare module '@elastic/eui/src/components/tree_view/tree_view.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiTreeViewStyles: (euiThemeContext: UseEuiTheme) => {
	    euiTreeView: import("@emotion/utils").SerializedStyles;
	    default: import("@emotion/utils").SerializedStyles;
	    compressed: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/tree_view/tree_view' {
	import React, { Component, HTMLAttributes, ContextType } from 'react';
	import { WithEuiThemeProps } from '@elastic/eui/src/services';
	import { CommonProps } from '@elastic/eui/src/components/common'; const EuiTreeViewContext: React.Context<string>;
	export interface Node {
	    /** An array of EuiTreeViewNodes to render as children
	     */
	    children?: Node[];
	    /** The readable label for the item
	     */
	    label: React.ReactNode;
	    /** A unique ID
	     */
	    id: string;
	    /** An icon to use on the left of the label
	     */
	    icon?: React.ReactElement;
	    /** Display a different icon when the item is expanded.
	    For instance, an open folder or a down arrow
	    */
	    iconWhenExpanded?: React.ReactElement;
	    /** Use an empty icon to keep items without an icon
	    lined up with their siblings
	    */
	    useEmptyIcon?: boolean;
	    /** Whether or not the item is expanded.
	     */
	    isExpanded?: boolean;
	    /** Optional class to throw on the node
	     */
	    className?: string;
	    /** Function to call when the item is clicked.
	     The open state of the item will always be toggled.
	     */
	    callback?(): string;
	}
	export type EuiTreeViewDisplayOptions = 'default' | 'compressed';
	interface EuiTreeViewState {
	    openItems: string[];
	    activeItem: string;
	    treeID: string;
	    expandChildNodes: boolean;
	}
	export type CommonTreeProps = CommonProps & HTMLAttributes<HTMLUListElement> & {
	    /**
	     * Never accepts children directly, only through the `items` prop
	     */
	    children?: never;
	    /**
	     * An array of EuiTreeViewNodes
	     */
	    items: Node[];
	    /**
	     * Optionally use a variation with smaller text and icon sizes
	     * @default default
	     */
	    display?: EuiTreeViewDisplayOptions;
	    /**
	     * Set all items to open on initial load
	     */
	    expandByDefault?: boolean;
	    /**
	     * Display expansion arrows next to all items
	     * that contain children
	     */
	    showExpansionArrows?: boolean;
	};
	export type EuiTreeViewProps = Omit<CommonTreeProps, 'aria-label' | 'aria-labelledby'> & ({
	    'aria-label': string;
	} | {
	    'aria-labelledby': string;
	});
	export class EuiTreeViewClass extends Component<EuiTreeViewProps & WithEuiThemeProps, EuiTreeViewState> {
	    treeIdGenerator: (idSuffix?: string) => string;
	    static contextType: React.Context<string>;
	    context: ContextType<typeof EuiTreeViewContext>;
	    isNested: boolean;
	    constructor(props: EuiTreeViewProps & WithEuiThemeProps, context?: ContextType<typeof EuiTreeViewContext>);
	    componentDidUpdate(prevProps: EuiTreeViewProps): void;
	    buttonRef: Array<HTMLButtonElement | undefined>;
	    setButtonRef: (ref: HTMLButtonElement | HTMLAnchorElement | null, index: number) => void;
	    handleNodeClick: (node: Node, ignoreCallback?: boolean) => void;
	    isNodeOpen: (node: Node) => boolean;
	    onKeyDown: (event: React.KeyboardEvent, node: Node) => void;
	    onChildrenKeydown: (event: React.KeyboardEvent, index: number) => void;
	    render(): React.JSX.Element;
	}
	export const EuiTreeView: React.ForwardRefExoticComponent<Omit<EuiTreeViewProps, "theme"> & React.RefAttributes<Omit<EuiTreeViewProps, "theme">>> & {
	    Item: React.FunctionComponent<import ("@elastic/eui/src/components/tree_view/tree_view_item").EuiTreeViewItemProps>;
	};
	export {};

}
declare module '@elastic/eui/src/components/tree_view' {
	export type { EuiTreeViewProps } from '@elastic/eui/src/components/tree_view/tree_view';
	export { EuiTreeView } from '@elastic/eui/src/components/tree_view/tree_view';

}
declare module '@elastic/eui/src/components/search_bar/search_box' {
	import { FunctionComponent } from 'react';
	import { EuiFieldSearchProps } from '@elastic/eui/src/components/form';
	import { EuiSearchBarProps } from '@elastic/eui/src/components/search_bar/search_bar';
	export interface EuiSearchBoxProps extends EuiFieldSearchProps {
	    query: string;
	    onSearch: (queryText: string) => void;
	    /**
	     * @default Search...
	     */
	    placeholder?: string;
	    hint?: {
	        id: string;
	        isVisible: boolean;
	        setIsVisible: (isVisible: boolean) => void;
	    } & EuiSearchBarProps['hint'];
	}
	export const EuiSearchBox: FunctionComponent<EuiSearchBoxProps>;

}
declare module '@elastic/eui/src/components/search_bar/query/date_format' {
	import { Moment, MomentInput } from 'moment';
	export interface EuiMoment extends Moment {
	    __eui_granularity?: GranularityType;
	    __eui_format?: string;
	}
	export interface GranularityType {
	    es: 'd' | 'w' | 'M' | 'y';
	    js: 'day' | 'week' | 'month' | 'year';
	    isSame: (d1: Moment, d2: Moment) => boolean;
	    start: (date: Moment) => Moment;
	    startOfNext: (date: Moment) => Moment;
	    iso8601: (date: Moment) => string;
	}
	interface GranularitiesType {
	    DAY: GranularityType;
	    WEEK: GranularityType;
	    MONTH: GranularityType;
	    YEAR: GranularityType;
	}
	export const Granularity: Readonly<GranularitiesType>;
	export const printIso8601: (value: MomentInput) => string;
	export const dateGranularity: (parsedDate: EuiMoment) => GranularityType;
	export const dateFormat: Readonly<{
	    parse(value: string): EuiMoment;
	    print(date: EuiMoment | MomentInput, defaultGranularity?: undefined): string;
	}>;
	export {};

}
declare module '@elastic/eui/src/components/search_bar/query/date_value' {
	import { GranularityType } from '@elastic/eui/src/components/search_bar/query/date_format';
	import moment, { MomentInput } from 'moment';
	export const DATE_TYPE = "date";
	export interface DateValue {
	    type: 'date';
	    raw: MomentInput;
	    granularity: GranularityType | undefined;
	    text: string;
	    resolve: () => moment.Moment;
	}
	export const dateValuesEqual: (v1: DateValue, v2: DateValue) => boolean;
	export const isDateValue: (value: any) => value is DateValue;
	export const dateValue: (raw: MomentInput, granularity?: GranularityType, dateFormat?: any) => DateValue | undefined;
	export const dateValueParser: (format?: Readonly<{
	    parse(value: string): import ("@elastic/eui/src/components/search_bar/query/date_format").EuiMoment;
	    print(date: moment.MomentInput | import ("@elastic/eui/src/components/search_bar/query/date_format").EuiMoment, defaultGranularity?: undefined): string;
	}>) => (text: string) => DateValue | undefined;

}
declare module '@elastic/eui/src/components/search_bar/query/ast' {
	import { DateValue } from '@elastic/eui/src/components/search_bar/query/date_value';
	export type MatchType = 'must' | 'must_not';
	export type Value = string | number | boolean | DateValue;
	export interface IsClause {
	    type: 'is';
	    match?: MatchType;
	    flag: string;
	}
	export interface FieldClause {
	    type: 'field';
	    match?: MatchType;
	    operator: OperatorType;
	    field: string;
	    value: Value | Value[];
	}
	export interface TermClause {
	    type: 'term';
	    match?: MatchType;
	    value: Value;
	}
	export interface GroupClause {
	    type: 'group';
	    match: MatchType;
	    value: Clause[];
	}
	export type Clause = IsClause | FieldClause | TermClause | GroupClause;
	export const Match: Readonly<{
	    MUST: "must";
	    MUST_NOT: "must_not";
	    isMust(match: MatchType | undefined): boolean;
	    isMustClause(clause: Clause): boolean;
	}>;
	export type OperatorType = 'eq' | 'exact' | 'gt' | 'gte' | 'lt' | 'lte';
	export const Operator: Readonly<{
	    EQ: "eq";
	    EXACT: "exact";
	    GT: "gt";
	    GTE: "gte";
	    LT: "lt";
	    LTE: "lte";
	    isEQ(match: OperatorType | undefined): boolean;
	    isEQClause(clause: Clause): boolean;
	    isEXACT(match: OperatorType | undefined): boolean;
	    isEXACTClause(clause: Clause): boolean;
	    isRange(match: OperatorType | undefined): boolean;
	    isRangeClause(clause: Clause): boolean;
	    isGT(match: OperatorType | undefined): boolean;
	    isGTClause(clause: Clause): boolean;
	    isGTE(match: OperatorType | undefined): boolean;
	    isGTEClause(clause: Clause): boolean;
	    isLT(match: OperatorType | undefined): boolean;
	    isLTClause(clause: Clause): boolean;
	    isLTE(match: OperatorType | undefined): boolean;
	    isLTEClause(clause: Clause): boolean;
	}>;
	/**
	 * The AST structure is an array of clauses. There are 3 types of clauses that are supported:
	 *
	 * :term:
	 * Holds a VALUE and an OCCUR. The OCCUR indicates whether the value must match or must not match. Default
	 * clauses are not associated with any specific field - when executing the search, one can specify what are
	 * the default fields that the default clauses will be matched against.
	 *
	 * :field:
	 * Like the `term` clause, holds a VALUE and an MATCH, but this clause also specifies the field that the
	 * value will be matched against.
	 *
	 * :is:
	 * Holds a FLAG and indicates whether this flag must be applied or must not be applied. Typically this clause
	 * matches against boolean values of a record (e.g. "is:online", "is:internal", "is:on", etc..)
	 *
	 * This AST is immutable - every "mutating" operation returns a newly mutated AST.
	 */
	export class _AST {
	    private readonly _clauses;
	    private readonly _indexedClauses;
	    static create(clauses: Clause[]): _AST;
	    constructor(clauses?: Clause[]);
	    get clauses(): Clause[];
	    getTermClauses(): TermClause[];
	    getTermClause(value: Value): TermClause | undefined;
	    getFieldNames(): string[];
	    getFieldClauses(field?: string): FieldClause[];
	    getFieldClause(field: string, predicate: (c: FieldClause) => boolean): FieldClause | undefined;
	    hasOrFieldClause(field: string, value?: Value): boolean;
	    getOrFieldClause(field: string, value?: Value, must?: boolean, operator?: OperatorType): FieldClause | undefined;
	    addOrFieldValue(field: string, value: Value, must?: boolean, operator?: OperatorType): _AST;
	    removeOrFieldValue(field: string, value: Value): _AST;
	    removeOrFieldClauses(field: string): _AST;
	    hasSimpleFieldClause(field: string, value?: Value): boolean;
	    getSimpleFieldClause(field: string, value?: Value): FieldClause | undefined;
	    addSimpleFieldValue(field: string, value: Value, must?: boolean, operator?: OperatorType): _AST;
	    removeSimpleFieldValue(field: string, value: Value): _AST;
	    removeSimpleFieldClauses(field: string): _AST;
	    getIsClauses(): IsClause[];
	    getIsClause(flag: string): IsClause;
	    removeIsClause(flag: string): _AST;
	    removeIsClauses(): _AST;
	    removeAllClauses(): _AST;
	    getGroupClauses(): GroupClause[];
	    /**
	     * Creates and returns a new AST with the given clause added to the current clauses. If
	     * the current clauses already include a similar clause, it will be (in-place) replaced by
	     * the given clause. Whether a clause is similar to the given one depends on the type of the clause.
	     * Two clauses are similar if:
	     *
	     * - they are both of the same type
	     * - if they are `default` clauses, they must have the same value
	     * - if they are `term` clauses, they must have the same fields and values
	     * - if they are `is` clauses, they must have the same flags
	     *
	     * The reasoning behind not including the `match` attributes of the clauses in the rules above, stems
	     * in the fact that the AST clauses are ANDed, and having two similar clauses with two different
	     * match attributes creates a logically contradicted AST (e.g. what does it mean to
	     * "(must have x) AND (must not have x)"?)
	     *
	     * note:  in-place replacement means the given clause will be placed in the same position as the one it
	     *        replaced
	     */
	    addClause(newClause: Clause): _AST;
	}
	export const AST: Readonly<{
	    Match: Readonly<{
	        MUST: "must";
	        MUST_NOT: "must_not";
	        isMust(match: MatchType | undefined): boolean;
	        isMustClause(clause: Clause): boolean;
	    }>;
	    Operator: Readonly<{
	        EQ: "eq";
	        EXACT: "exact";
	        GT: "gt";
	        GTE: "gte";
	        LT: "lt";
	        LTE: "lte";
	        isEQ(match: OperatorType | undefined): boolean;
	        isEQClause(clause: Clause): boolean;
	        isEXACT(match: OperatorType | undefined): boolean;
	        isEXACTClause(clause: Clause): boolean;
	        isRange(match: OperatorType | undefined): boolean;
	        isRangeClause(clause: Clause): boolean;
	        isGT(match: OperatorType | undefined): boolean;
	        isGTClause(clause: Clause): boolean;
	        isGTE(match: OperatorType | undefined): boolean;
	        isGTEClause(clause: Clause): boolean;
	        isLT(match: OperatorType | undefined): boolean;
	        isLTClause(clause: Clause): boolean;
	        isLTE(match: OperatorType | undefined): boolean;
	        isLTEClause(clause: Clause): boolean;
	    }>;
	    Term: Readonly<{
	        TYPE: "term";
	        isInstance: (clause: Clause) => clause is TermClause;
	        must: (value: Value) => {
	            type: "term";
	            value: Value;
	            match: "must";
	        };
	        mustNot: (value: Value) => {
	            type: "term";
	            value: Value;
	            match: "must_not";
	        };
	    }>;
	    Group: Readonly<{
	        TYPE: "group";
	        isInstance: (clause: Clause) => clause is GroupClause;
	        must: (value: Clause[]) => {
	            type: "group";
	            value: Clause[];
	            match: "must";
	        };
	        mustNot: (value: Clause[]) => {
	            type: "group";
	            value: Clause[];
	            match: "must_not";
	        };
	    }>;
	    Field: Readonly<{
	        TYPE: "field";
	        isInstance: (clause: Clause) => clause is FieldClause;
	        must: {
	            eq: (field: string, value: Value | Value[]) => {
	                type: "field";
	                field: string;
	                value: Value | Value[];
	                match: "must";
	                operator: "eq";
	            };
	            exact: (field: string, value: Value | Value[]) => {
	                type: "field";
	                field: string;
	                value: Value | Value[];
	                match: "must";
	                operator: "exact";
	            };
	            gt: (field: string, value: Value | Value[]) => {
	                type: "field";
	                field: string;
	                value: Value | Value[];
	                match: "must";
	                operator: "gt";
	            };
	            gte: (field: string, value: Value | Value[]) => {
	                type: "field";
	                field: string;
	                value: Value | Value[];
	                match: "must";
	                operator: "gte";
	            };
	            lt: (field: string, value: Value | Value[]) => {
	                type: "field";
	                field: string;
	                value: Value | Value[];
	                match: "must";
	                operator: "lt";
	            };
	            lte: (field: string, value: Value | Value[]) => {
	                type: "field";
	                field: string;
	                value: Value | Value[];
	                match: "must";
	                operator: "lte";
	            };
	        };
	        mustNot: {
	            eq: (field: string, value: Value | Value[]) => {
	                type: "field";
	                field: string;
	                value: Value | Value[];
	                match: "must_not";
	                operator: "eq";
	            };
	            exact: (field: string, value: Value | Value[]) => {
	                type: "field";
	                field: string;
	                value: Value | Value[];
	                match: "must_not";
	                operator: "exact";
	            };
	            gt: (field: string, value: Value | Value[]) => {
	                type: "field";
	                field: string;
	                value: Value | Value[];
	                match: "must_not";
	                operator: "gt";
	            };
	            gte: (field: string, value: Value | Value[]) => {
	                type: "field";
	                field: string;
	                value: Value | Value[];
	                match: "must_not";
	                operator: "gte";
	            };
	            lt: (field: string, value: Value | Value[]) => {
	                type: "field";
	                field: string;
	                value: Value | Value[];
	                match: "must_not";
	                operator: "lt";
	            };
	            lte: (field: string, value: Value | Value[]) => {
	                type: "field";
	                field: string;
	                value: Value | Value[];
	                match: "must_not";
	                operator: "lte";
	            };
	        };
	    }>;
	    Is: Readonly<{
	        TYPE: "is";
	        isInstance: (clause: Clause) => clause is IsClause;
	        must: (flag: string) => {
	            type: "is";
	            flag: string;
	            match: "must";
	        };
	        mustNot: (flag: string) => {
	            type: "is";
	            flag: string;
	            match: "must_not";
	        };
	    }>;
	    create: (clauses: Clause[]) => _AST;
	}>;

}
declare module '@elastic/eui/src/components/search_bar/query/default_syntax' {
	import { _AST, Clause } from '@elastic/eui/src/components/search_bar/query/ast';
	export interface ParseOptions {
	    dateFormat?: any;
	    schema?: {
	        strict?: boolean;
	        fields?: string[] | Record<string, any>;
	        recognizedFields?: string[];
	    };
	    escapeValue?: (value: any) => string;
	}
	export type Syntax = Readonly<{
	    printClause: (clause: Clause, text: string, options: any) => string;
	    print: (ast: _AST, options?: {}) => string;
	    parse: (query: string, options?: ParseOptions) => _AST;
	}>;
	export const defaultSyntax: Syntax;

}
declare module '@elastic/eui/src/components/search_bar/query/operators' {
	import moment from 'moment';
	import { Value } from '@elastic/eui/src/components/search_bar/query/ast';
	export type FieldValue = string | number | boolean | any[] | Date | moment.Moment | null | undefined;
	export type ClauseValue = Value | Date | moment.Moment | null | undefined; type Options = Partial<{
	    exactMatch: boolean;
	    ignoreCase: boolean;
	}>;
	export const eq: (fieldValue: FieldValue, clauseValue: ClauseValue, options?: Options) => boolean;
	export const exact: (fieldValue: FieldValue, clauseValue: ClauseValue, options?: {}) => boolean;
	export const gt: (fieldValue: FieldValue, clauseValue: ClauseValue) => boolean;
	export const gte: (fieldValue: FieldValue, clauseValue: ClauseValue) => boolean;
	export const lt: (fieldValue: FieldValue, clauseValue: ClauseValue) => boolean;
	export const lte: (fieldValue: FieldValue, clauseValue: ClauseValue) => boolean;
	export {};

}
declare module '@elastic/eui/src/components/search_bar/query/execute_ast' {
	import { _AST, Clause, IsClause, MatchType, Value } from '@elastic/eui/src/components/search_bar/query/ast';
	interface Explain {
	    hit: boolean;
	    type: Clause['type'];
	    field?: string;
	    value?: Value | Value[];
	    flag?: string;
	    match?: MatchType;
	    operator?: any;
	} const defaultIsClauseMatcher: <T_1 extends object>(item: T_1, clause: IsClause, explain?: Explain[] | undefined) => boolean;
	export const createFilter: <T extends {}>(ast: _AST, defaultFields: string[] | undefined, isClauseMatcher?: <T_1 extends object>(item: T_1, clause: IsClause, explain?: Explain[] | undefined) => boolean, explain?: boolean) => (item: T) => boolean;
	interface Options {
	    isClauseMatcher?: typeof defaultIsClauseMatcher;
	    defaultFields?: string[];
	    explain?: boolean;
	}
	export function executeAst<T extends object>(ast: _AST, items: T[], options?: Options): T[];
	export {};

}
declare module '@elastic/eui/src/components/search_bar/query/ast_to_es_query_dsl' {
	import { OperatorType, Value, _AST } from '@elastic/eui/src/components/search_bar/query/ast';
	export interface QueryContainer {
	    bool?: BoolQuery;
	    match_all?: {};
	    match?: object;
	    match_phrase?: object;
	    range?: object;
	    term?: object;
	    simple_query_string?: object;
	}
	interface BoolQuery {
	    must?: QueryContainer[];
	    must_not?: QueryContainer[];
	    should?: QueryContainer[];
	} type Options = Partial<{
	    defaultFields: string[];
	    extraMustQueries: QueryContainer[];
	    extraMustNotQueries: QueryContainer[];
	    termValuesToQuery: (terms: Value[], options: {}) => QueryContainer;
	    fieldValuesToQuery: (terms: string, options: {}) => QueryContainer;
	    isFlagToQuery: (flag: string, on: boolean) => QueryContainer;
	}>;
	export const _termValuesToQuery: (values: Value[], options: Options) => {
	    simple_query_string: {
	        query: string;
	        fields?: string[] | undefined;
	    };
	} | undefined;
	export const _fieldValuesToQuery: (field: string, operations: {
	    exact: Value[];
	    eq: Value[];
	    gt: Value[];
	    gte: Value[];
	    lt: Value[];
	    lte: Value[];
	}, andOr: 'and' | 'or') => QueryContainer;
	export const _isFlagToQuery: (flag: string, on: boolean) => {
	    term: {
	        [x: string]: boolean;
	    };
	};
	export const astToEsQueryDsl: (ast: _AST, options?: {}) => QueryContainer;
	export {};

}
declare module '@elastic/eui/src/components/search_bar/query/ast_to_es_query_string' {
	import { _AST } from '@elastic/eui/src/components/search_bar/query/ast';
	export const astToEsQueryString: (ast: _AST) => string;

}
declare module '@elastic/eui/src/components/search_bar/query/query' {
	import { ParseOptions, Syntax } from '@elastic/eui/src/components/search_bar/query/default_syntax';
	import { _AST, Clause, OperatorType, Value } from '@elastic/eui/src/components/search_bar/query/ast';
	/**
	 * This is the consumer interface for the query - it's effectively a wrapper construct around
	 * the AST and some of its related utility functions (e.g. parsing, text representation, executing, etc...)
	 * It is immutable - all mutating operations return a new (mutated) query instance.
	 */
	export class Query {
	    static parse(text: string, options?: ParseOptions, syntax?: Syntax): Query;
	    static isMust(clause: Clause): boolean;
	    static MATCH_ALL: Query;
	    static isTerm(clause: Clause): boolean;
	    static isIs(clause: Clause): boolean;
	    static isField(clause: Clause): boolean;
	    ast: _AST;
	    text: string;
	    private syntax;
	    constructor(ast: _AST, syntax?: Syntax, text?: string);
	    hasClauses(): boolean;
	    hasSimpleFieldClause(field: string, value?: string): boolean;
	    getSimpleFieldClause(field: string, value?: Value): import ("@elastic/eui/src/components/search_bar/query/ast").FieldClause | undefined;
	    removeSimpleFieldClauses(field: string): Query;
	    addSimpleFieldValue(field: string, value: Value, must?: boolean, operator?: OperatorType): Query;
	    removeSimpleFieldValue(field: string, value: Value): Query;
	    hasOrFieldClause(field: string, value?: Value): boolean;
	    getOrFieldClause(field: string, value?: Value): import ("@elastic/eui/src/components/search_bar/query/ast").FieldClause | undefined;
	    addOrFieldValue(field: string, value: Value, must?: boolean, operator?: OperatorType): Query;
	    removeOrFieldValue(field: string, value: Value): Query;
	    removeOrFieldClauses(field: string): Query;
	    removeAllClauses(): Query;
	    hasIsClause(flag: string): boolean;
	    getIsClause(flag: string): import ("@elastic/eui/src/components/search_bar/query/ast").IsClause;
	    addMustIsClause(flag: string): Query;
	    addMustNotIsClause(flag: string): Query;
	    removeIsClause(flag: string): Query;
	    removeIsClauses(): Query;
	    /**
	     * Executes this query over the given iterable item and returns
	     * an new array of all items that matched this query. Options:
	     *
	     * defaultFields: string[]
	     *
	     *    An array of field names to match the default clauses against. When not specified, the query
	     *    will pick up all the string fields of each record and try to match against those.
	     *
	     * isClauseMatcher?: (record: any, flag: string, applied: boolean, explain?: []) => boolean
	     *
	     *    By default the 'is' clauses will try to match against boolean fields - where the flag of the clause
	     *    indicates the field name. You can change this behaviour by providing this matcher function for the
	     *    is clause. For example, if the object has a `tags` field, one can create a matcher that checks if
	     *    an object has a specific tag (e.g. "is:marketing", "is:kitchen", etc..)
	     *
	     * explain?: boolean
	     *
	     *    When set to `true`, each item in the returns array will have an `__explain` field that will hold
	     *    information about why the objects matched the query (default to `false`, mainly/only useful for
	     *    debugging)
	     */
	    static execute<T extends object>(query: string | Query, items: T[], options?: {}): T[];
	    /**
	     * Builds and returns an Elasticsearch query out this query. Options:
	     *
	     * defaultFields?: string[]
	     *
	     *    An array of field names to match the default clauses against. When not specified, the query
	     *    will pick up all the string fields of each record and try to match against those.
	     *
	     * isToQuery?: (flag: string, on: boolean) => Object (elasticsearch query object)
	     *
	     *    By default, "is" clauses will be translated to a term query where the flag is the field
	     *    and the "on" value will be the value of the field. This function lets you change this default
	     *    translation and provide your own custom one.
	     *
	     * termValuesToQuery?: (values: string[]) => Object (elasticsearch query object)
	     *
	     *    By default, "term" clauses will be translated to a "simple_query_string" query where all
	     *    the values serve as terms in the query string. This function lets you change this default
	     *    translation and provide your own custom one.
	     *
	     * fieldValuesToAndQuery?: (field: string, values: string[]) => Object (elasticsearch query object)
	     *
	     *    By default, "field" clauses will be translated to a match query where all the values serve as
	     *    terms in the query(the operator is AND). This function lets you change this default translation
	     *    and provide your own custom one.
	     */
	    static toESQuery(query: string | Query, options?: {}): import ("@elastic/eui/src/components/search_bar/query/ast_to_es_query_dsl").QueryContainer;
	    static toESQueryString(query: string | Query): string;
	}

}
declare module '@elastic/eui/src/components/search_bar/query' {
	export { Query } from '@elastic/eui/src/components/search_bar/query/query';
	export { AST } from '@elastic/eui/src/components/search_bar/query/ast';

}
declare module '@elastic/eui/src/components/search_bar/filters/is_filter' {
	import React, { Component } from 'react';
	import { Query } from '@elastic/eui/src/components/search_bar/query';
	import { Clause } from '@elastic/eui/src/components/search_bar/query/ast';
	export interface IsFilterConfigType {
	    type: 'is';
	    field: string;
	    name: string;
	    negatedName?: string;
	    available?: () => boolean;
	}
	export interface IsFilterProps {
	    index: number;
	    config: IsFilterConfigType;
	    query: Query;
	    onChange: (value: Query) => void;
	}
	export class IsFilter extends Component<IsFilterProps> {
	    resolveDisplay(clause: Clause): {
	        hasActiveFilters: boolean;
	        name: string;
	    };
	    valueChanged(field: string, checked: boolean): void;
	    render(): React.JSX.Element;
	}

}
declare module '@elastic/eui/src/components/selectable/selectable_option' {
	import React, { HTMLAttributes } from 'react';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	import type { EuiTextTruncateProps } from '@elastic/eui/src/components/text_truncate';
	import { EuiToolTipProps } from '@elastic/eui/src/components/tool_tip';
	export const OPTION_CHECKED_STATES: readonly ["on", "off", "mixed", undefined];
	export type EuiSelectableOptionCheckedType = (typeof OPTION_CHECKED_STATES)[number];
	export type EuiSelectableOptionBase = CommonProps & {
	    /**
	     * Visible label of option.
	     * Must be unique across items if `key` is not supplied
	     */
	    label: string;
	    /**
	     * Optionally change the searchable term by passing a different string other than the `label`.
	     * Best used when creating a custom `optionRender` to separate the label from metadata but allowing to search on both
	     */
	    searchableLabel?: string;
	    /**
	     * Must be unique across items.
	     * Will be used to match options instead of `label`
	     */
	    key?: string;
	    /**
	     * Leave `undefined` to indicate not selected. Pass a string of
	     * 'on' to indicate inclusion, 'off' to indicate exclusion,
	     * or 'mixed' to indicate inclusion for some.
	     */
	    checked?: EuiSelectableOptionCheckedType;
	    disabled?: boolean;
	    /**
	     * Optional `boolean`.
	     * Set to `true` to indicate object is just a grouping label, not a selectable item
	     */
	    isGroupLabel?: false;
	    /**
	     * Node to add between the selection icon and the label
	     */
	    prepend?: React.ReactNode;
	    /**
	     * Node to add to the far right of the item
	     */
	    append?: React.ReactNode;
	    ref?: (optionIndex: number) => void;
	    /**
	     * Disallow `id` from being set.
	     * Option item `id`s are coordinated at a higher level for a11y reasons.
	     */
	    id?: never;
	    /**
	     * Option data to pass through to the `renderOptions` element.
	     * Bypass `EuiSelectableItem` and avoid DOM attribute warnings.
	     */
	    data?: {
	        [key: string]: any;
	    };
	    /**
	     * How to handle long text within the item.
	     * Wrapping only works if `isVirtualization` is false.
	     * @default 'truncate'
	     */
	    textWrap?: 'truncate' | 'wrap';
	    /**
	     * If textWrap is set to `truncate`, you can pass a custom truncation configuration
	     * that accepts any [EuiTextTruncate](/#/utilities/text-truncation) prop except for
	     * `text` and `children`.
	     *
	     * Note: when searching, custom truncation props are ignored. The highlighted search
	     * text will always take precedence.
	     */
	    truncationProps?: Partial<Omit<EuiTextTruncateProps, 'text' | 'children'>>;
	    /**
	     * Optional custom tooltip content for the button
	     */
	    toolTipContent?: EuiToolTipProps['content'];
	    /**
	     * Optional props to pass to the underlying **[EuiToolTip](/#/display/tooltip)**
	     */
	    toolTipProps?: Partial<Omit<EuiToolTipProps, 'content' | 'children'>>;
	}; type _EuiSelectableGroupLabelOption = Omit<EuiSelectableOptionBase, 'isGroupLabel'> & Exclude<HTMLAttributes<HTMLDivElement>, 'id'> & {
	    isGroupLabel: true;
	};
	export type EuiSelectableGroupLabelOption<T> = _EuiSelectableGroupLabelOption & T; type _EuiSelectableLIOption = EuiSelectableOptionBase & Exclude<HTMLAttributes<HTMLLIElement>, 'id'>;
	export type EuiSelectableLIOption<T> = _EuiSelectableLIOption & T;
	export type EuiSelectableOption<T = {}> = ExclusiveUnion<EuiSelectableGroupLabelOption<T>, EuiSelectableLIOption<T>>;
	export {};

}
declare module '@elastic/eui/src/components/selectable/matching_options' {
	import { EuiSelectableOption } from '@elastic/eui/src/components/selectable/selectable_option';
	import { EuiSelectableOptionMatcher } from '@elastic/eui/src/components/selectable/selectable'; type SelectableOptions<T> = Array<EuiSelectableOption<T>>;
	interface GetMatchingOptionsArgs<TOption> {
	    /**
	     * All available options to match against
	     */
	    options: SelectableOptions<TOption>;
	    /**
	     * String to match option.label || option.searchableLabel against
	     */
	    searchValue: string;
	    /**
	     * Async?
	     */
	    isPreFiltered: boolean;
	    /**
	     * To exclude selected options from the search list,
	     * pass the array of selected options
	     */
	    selectedOptions?: SelectableOptions<TOption>;
	    /**
	     * Option matcher function passed to EuiSelectable or the default matcher
	     */
	    optionMatcher: EuiSelectableOptionMatcher<TOption>;
	}
	export const getMatchingOptions: <TOption>({ searchValue, options, isPreFiltered, selectedOptions, optionMatcher, }: GetMatchingOptionsArgs<TOption>) => SelectableOptions<TOption>;
	/**
	 * Partial string equality option matcher for EuiSelectable
	 * It matches all options with labels including the searched string.
	 */
	export const createPartialStringEqualityOptionMatcher: <TOption>() => EuiSelectableOptionMatcher<TOption>;
	export {};

}
declare module '@elastic/eui/src/components/selectable/selectable_search/selectable_search' {
	import React from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiFieldSearchProps } from '@elastic/eui/src/components/form';
	import { EuiSelectableOption } from '@elastic/eui/src/components/selectable/selectable_option';
	import type { EuiSelectableOptionMatcher } from '@elastic/eui/src/components/selectable/selectable';
	export type EuiSelectableSearchProps<T> = CommonProps & Omit<EuiFieldSearchProps, 'onChange' | 'onSearch' | 'incremental'> & {
	    /**
	     * Passes back (searchValue, matchingOptions)
	     */
	    onChange: (searchValue: string, matchingOptions: Array<EuiSelectableOption<T>>) => void;
	};
	export type _EuiSelectableSearchProps<T> = EuiSelectableSearchProps<T> & {
	    options: Array<EuiSelectableOption<T>>;
	    /**
	     * Search value state managed by parent EuiSelectable
	     */
	    value: string;
	    /**
	     * The id of the visible list to create the appropriate aria controls
	     */
	    listId?: string;
	    isPreFiltered: boolean;
	    /**
	     * Option matcher function
	     */
	    optionMatcher: EuiSelectableOptionMatcher<T>;
	};
	export const EuiSelectableSearch: <T>({ onChange: onChangeCallback, options, value, placeholder, isPreFiltered, listId, className, optionMatcher, ...rest }: _EuiSelectableSearchProps<T>) => React.JSX.Element;

}
declare module '@elastic/eui/src/components/selectable/selectable_search' {
	export type { EuiSelectableSearchProps } from '@elastic/eui/src/components/selectable/selectable_search/selectable_search';
	export { EuiSelectableSearch } from '@elastic/eui/src/components/selectable/selectable_search/selectable_search';

}
declare module '@elastic/eui/src/components/selectable/selectable_message/selectable_message.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiSelectableMessageStyles: (euiThemeContext: UseEuiTheme) => {
	    euiSelectableMessage: import("@emotion/utils").SerializedStyles;
	    bordered: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/selectable/selectable_message/selectable_message' {
	import { FunctionComponent, HTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	export type EuiSelectableMessageProps = Omit<HTMLAttributes<HTMLDivElement>, 'color'> & CommonProps & {
	    /**
	     * Match this to the `listProps.bordered` property of your `EuiSelectable` instance
	     */
	    bordered?: boolean;
	};
	export const EuiSelectableMessage: FunctionComponent<EuiSelectableMessageProps>;

}
declare module '@elastic/eui/src/components/selectable/selectable_message' {
	export type { EuiSelectableMessageProps } from '@elastic/eui/src/components/selectable/selectable_message/selectable_message';
	export { EuiSelectableMessage } from '@elastic/eui/src/components/selectable/selectable_message/selectable_message';

}
declare module '@elastic/eui/src/components/selectable/selectable_list/selectable_list_item.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiSelectableListItemVariables: ({ euiTheme }: UseEuiTheme) => {
	    border: string;
	    paddingHorizontal: string;
	    paddingVertical: string;
	};
	export const euiSelectableListItemStyles: (euiThemeContext: UseEuiTheme) => {
	    euiSelectableListItem: import("@emotion/utils").SerializedStyles;
	    padding: {
	        none: import("@emotion/utils").SerializedStyles;
	        s: import("@emotion/utils").SerializedStyles;
	    };
	    euiSelectableListItem__content: import("@emotion/utils").SerializedStyles;
	    euiSelectableListItem__text: import("@emotion/utils").SerializedStyles;
	    textWrap: {
	        truncate: import("@emotion/utils").SerializedStyles;
	        wrap: import("@emotion/utils").SerializedStyles;
	    };
	    euiSelectableListItem__prepend: import("@emotion/utils").SerializedStyles;
	    euiSelectableListItem__append: import("@emotion/utils").SerializedStyles;
	    readonly euiSelectableListItem__icon: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/selectable/selectable_list/selectable_list_item' {
	import React, { FunctionComponent, LiHTMLAttributes } from 'react';
	import { CommonProps } from '@elastic/eui/src/components/common';
	import { EuiBadgeProps } from '@elastic/eui/src/components/badge';
	import type { EuiSelectableOption, EuiSelectableOptionCheckedType } from '@elastic/eui/src/components/selectable/selectable_option';
	export const PADDING_SIZES: readonly ["none", "s"];
	export type EuiSelectablePaddingSize = (typeof PADDING_SIZES)[number];
	export type EuiSelectableListItemProps = LiHTMLAttributes<HTMLLIElement> & CommonProps & {
	    children?: React.ReactNode;
	    /**
	     * Applies an icon and visual styling to activated items
	     */
	    checked?: EuiSelectableOptionCheckedType;
	    /**
	     * Shows icons based on `checked` type
	     */
	    showIcons?: boolean;
	    /**
	     * Highlights the item for pseudo focus
	     */
	    isFocused?: boolean;
	    disabled?: boolean;
	    prepend?: React.ReactNode;
	    append?: React.ReactNode;
	    allowExclusions?: boolean;
	    /**
	     * When enabled by setting to either `true` or passing custom a custom badge,
	     * shows a hollow badge as an append (far right) when the item is focused.
	     * The default content when `true` is `↩ to select/deselect/include/exclude`
	     */
	    onFocusBadge?: boolean | EuiBadgeProps;
	    /**
	     * Padding for the list items.
	     */
	    paddingSize?: EuiSelectablePaddingSize;
	    /**
	     * Whether the `EuiSelectable` instance is searchable.
	     * When true, the Space key will not toggle selection, as it will type into the search box instead. Screen reader instructions will be added instructing users to use the Enter key to select items.
	     * When false, the Space key will toggle item selection. No extra screen reader instructions will be added, as Space to toggle is a generally standard for most select/checked elements.
	     */
	    searchable?: boolean;
	    /**
	     * Attribute applied the option `<li>`.
	     * If set to a role that allows [aria-checked](https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-checked),
	     * `aria-checked` will be automatically configured.
	     */
	    role?: LiHTMLAttributes<HTMLLIElement>['role'];
	    /**
	     * How to handle long text within the item.
	     * Wrapping only works if virtualization is off.
	     */
	    textWrap?: EuiSelectableOption['textWrap'];
	    /**
	     * Optional custom tooltip content for the button
	     */
	    toolTipContent?: EuiSelectableOption['toolTipContent'];
	    /**
	     * Optional props to pass to the underlying **[EuiToolTip](/#/display/tooltip)**
	     */
	    toolTipProps?: EuiSelectableOption['toolTipProps'];
	};
	export const EuiSelectableListItem: FunctionComponent<EuiSelectableListItemProps>;

}
declare module '@elastic/eui/src/components/selectable/selectable_list/selectable_list.styles' {
	import { UseEuiTheme } from '@elastic/eui/src/services';
	export const euiSelectableListStyles: (euiThemeContext: UseEuiTheme) => {
	    euiSelectableList: import("@emotion/utils").SerializedStyles;
	    fullHeight: import("@emotion/utils").SerializedStyles;
	    bordered: import("@emotion/utils").SerializedStyles;
	    euiSelectableList__list: string;
	    euiSelectableList__groupLabel: import("@emotion/utils").SerializedStyles;
	};

}
declare module '@elastic/eui/src/components/selectable/selectable_list/selectable_list' {
	import React, { Component, HTMLAttributes, ReactNode, CSSProperties } from 'react';
	import { FixedSizeList, ListProps, ListChildComponentProps as ReactWindowListChildComponentProps } from 'react-window';
	import { CommonProps, ExclusiveUnion } from '@elastic/eui/src/components/common';
	import { EuiAutoSizeHorizontal } from '@elastic/eui/src/components/auto_sizer';
	import type { EuiSelectableOption } from '@elastic/eui/src/components/selectable/selectable_option';
	import type { EuiSelectableOnChangeEvent, EuiSelectableProps } from '@elastic/eui/src/components/selectable/selectable';
	import { EuiSelectableListItemProps } from '@elastic/eui/src/components/selectable/selectable_list/selectable_list_item';
	interface ListChildComponentProps<T> extends Omit<ReactWindowListChildComponentProps, 'style'> {
	    data: Array<EuiSelectableOption<T>>;
	    style?: CSSProperties;
	}
	export type EuiSelectableOptionsListVirtualizedProps = ExclusiveUnion<{
	    /**
	     * Use virtualized rendering for list items with `react-window`.
	     * Sets each row's height to the value of `rowHeight`.
	     */
	    isVirtualized?: true;
	    /**
	     *  The height of each option in pixels. Defaults to `32`.
	     *  Has no effect if `isVirtualized=false`.
	     */
	    rowHeight: number;
	}, {
	    isVirtualized: false;
	}>;
	export type EuiSelectableOptionsListProps = CommonProps & HTMLAttributes<HTMLDivElement> & {
	    /**
	     * The index of the option to be highlighted as pseudo-focused;
	     * Good for use when only one selection is allowed and needing to open
	     * directly to that option
	     */
	    activeOptionIndex?: number;
	    /**
	     * Show the check/cross selection indicator icons
	     */
	    showIcons?: boolean;
	    singleSelection?: 'always' | boolean;
	    /**
	     * Any props to send specifically to the react-window `FixedSizeList`
	     */
	    windowProps?: Partial<ListProps>;
	    /**
	     * Adds a border around the list to indicate the bounds;
	     * Useful when the list scrolls, otherwise use your own container
	     */
	    bordered?: boolean;
	    /**
	     * When enabled by setting to either `true` or passing custom text,
	     * shows a hollow badge as an append (far right) when the item is focused.
	     * The default content when `true` is `↩ to select/deselect/include/exclude`
	     */
	    onFocusBadge?: EuiSelectableListItemProps['onFocusBadge'];
	    /**
	     * Padding for the list items.
	     */
	    paddingSize?: EuiSelectableListItemProps['paddingSize'];
	    /**
	     * How to handle long text within the item.
	     * Wrapping only works if virtualization is off.
	     */
	    textWrap?: EuiSelectableListItemProps['textWrap'];
	    /**
	     * If textWrap is set to `truncate`, you can pass a custom truncation configuration
	     * that accepts any [EuiTextTruncate](/#/utilities/text-truncation) prop except for
	     * `text` and `children`.
	     *
	     * Note: when searching, custom truncation props are ignored. The highlighted search
	     * text will always take precedence.
	     */
	    truncationProps?: EuiSelectableOption['truncationProps'];
	} & EuiSelectableOptionsListVirtualizedProps;
	export type EuiSelectableListProps<T> = EuiSelectableOptionsListProps & {
	    /**
	     * All possible options
	     */
	    op