"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGrid = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _table_pagination = require("../table/table_pagination");
var _focus_trap = require("../focus_trap");
var _i18n = require("../i18n");
var _mutation_observer = require("../observer/mutation_observer");
var _resize_observer = require("../observer/resize_observer");
var _body = require("./body");
var _controls = require("./controls");
var _pagination2 = require("./pagination");
var _sorting = require("./utils/sorting");
var _focus = require("./utils/focus");
var _in_memory = require("./utils/in_memory");
var _cell = require("./body/cell");
var _row_count = require("./utils/row_count");
var _data_grid_schema = require("./utils/data_grid_schema");
var _ref = require("./utils/ref");
var _data_grid_types = require("./data_grid_types");
var _data_grid = require("./data_grid.styles");
var _react2 = require("@emotion/react");
var _excluded = ["leadingControlColumns", "trailingControlColumns", "columns", "columnVisibility", "schemaDetectors", "rowCount", "renderCellValue", "cellContext", "renderCellPopover", "renderFooterCellValue", "className", "gridStyle", "toolbarVisibility", "pagination", "sorting", "inMemory", "onColumnResize", "minSizeForControls", "height", "width", "rowHeightsOptions", "virtualizationOptions", "renderCustomGridBody", "renderCustomToolbar"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Each gridStyle object above sets a specific CSS select to .euiGrid
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var fontSizesToClassMap = {
  s: 'euiDataGrid--fontSizeSmall',
  m: '',
  l: 'euiDataGrid--fontSizeLarge'
};
var headerToClassMap = {
  shade: 'euiDataGrid--headerShade',
  underline: 'euiDataGrid--headerUnderline'
};
var footerToClassMap = {
  shade: 'euiDataGrid--footerShade',
  overline: 'euiDataGrid--footerOverline',
  striped: ''
};
var rowHoverToClassMap = {
  highlight: 'euiDataGrid--rowHoverHighlight',
  none: ''
};
var bordersToClassMap = {
  all: 'euiDataGrid--bordersAll',
  horizontal: 'euiDataGrid--bordersHorizontal',
  none: 'euiDataGrid--bordersNone'
};
var cellPaddingsToClassMap = {
  s: 'euiDataGrid--paddingSmall',
  m: '',
  l: 'euiDataGrid--paddingLarge'
};
var emptyVirtualizationOptions = {};
var EuiDataGrid = exports.EuiDataGrid = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (props, ref) {
  var _props$leadingControl = props.leadingControlColumns,
    leadingControlColumns = _props$leadingControl === void 0 ? _data_grid_types.emptyControlColumns : _props$leadingControl,
    _props$trailingContro = props.trailingControlColumns,
    trailingControlColumns = _props$trailingContro === void 0 ? _data_grid_types.emptyControlColumns : _props$trailingContro,
    columns = props.columns,
    columnVisibility = props.columnVisibility,
    schemaDetectors = props.schemaDetectors,
    rowCount = props.rowCount,
    renderCellValue = props.renderCellValue,
    cellContext = props.cellContext,
    renderCellPopover = props.renderCellPopover,
    renderFooterCellValue = props.renderFooterCellValue,
    className = props.className,
    gridStyle = props.gridStyle,
    _props$toolbarVisibil = props.toolbarVisibility,
    toolbarVisibility = _props$toolbarVisibil === void 0 ? true : _props$toolbarVisibil,
    _pagination = props.pagination,
    sorting = props.sorting,
    inMemory = props.inMemory,
    onColumnResize = props.onColumnResize,
    minSizeForControls = props.minSizeForControls,
    height = props.height,
    width = props.width,
    _rowHeightsOptions = props.rowHeightsOptions,
    virtualizationOptions = props.virtualizationOptions,
    renderCustomGridBody = props.renderCustomGridBody,
    renderCustomToolbar = props.renderCustomToolbar,
    rest = _objectWithoutProperties(props, _excluded);

  /**
   * Merge consumer settings with defaults
   */
  var paginationDefaults = (0, _table_pagination.useEuiTablePaginationDefaults)();
  var pagination = (0, _react.useMemo)(function () {
    return _pagination ? _objectSpread({
      pageSize: paginationDefaults.itemsPerPage,
      pageSizeOptions: paginationDefaults.itemsPerPageOptions
    }, _pagination) : _pagination;
  }, [_pagination, paginationDefaults]);
  var showPagination = pagination && (0, _pagination2.shouldRenderPagination)(rowCount, pagination);
  var gridStyleWithDefaults = (0, _react.useMemo)(function () {
    return _objectSpread(_objectSpread({}, _controls.startingStyles), gridStyle);
  }, [gridStyle]);
  var _useInMemoryValues = (0, _in_memory.useInMemoryValues)(inMemory, rowCount),
    _useInMemoryValues2 = _slicedToArray(_useInMemoryValues, 2),
    inMemoryValues = _useInMemoryValues2[0],
    onCellRender = _useInMemoryValues2[1];
  var allSchemaDetectors = (0, _react.useMemo)(function () {
    return [].concat(_toConsumableArray(_data_grid_schema.schemaDetectors), _toConsumableArray(schemaDetectors || []));
  }, [schemaDetectors]);
  var mergedSchema = (0, _data_grid_schema.useMergedSchema)({
    columns: columns,
    inMemory: inMemory,
    inMemoryValues: inMemoryValues,
    schemaDetectors: allSchemaDetectors,
    autoDetectSchema: inMemory != null
  });

  /**
   * Grid refs & observers
   */
  // Outermost wrapper div
  // this ref needs to be managed by a state, to cause a re-render after mount
  // and passing the mounted element to the resize observer
  var _useState = (0, _react.useState)(null),
    _useState2 = _slicedToArray(_useState, 2),
    resizeRef = _useState2[0],
    setResizeRef = _useState2[1];
  var _useResizeObserver = (0, _resize_observer.useResizeObserver)(resizeRef, 'width'),
    gridWidth = _useResizeObserver.width;

  // Wrapper div around EuiDataGridBody
  var contentRef = (0, _react.useRef)(null);
  (0, _mutation_observer.useMutationObserver)(contentRef.current, _focus.preventTabbing, {
    subtree: true,
    childList: true
  });

  // Imperative handler passed back by react-window - we're setting this at
  // the top datagrid level to make passing it to other children & utils easier
  var gridRef = (0, _react.useRef)(null);
  var gridItemsRendered = (0, _react.useRef)(null);

  /**
   * Display
   */
  var displayValues = (0, _react.useMemo)(function () {
    return columns.reduce(function (acc, column) {
      return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, column.id, column.displayAsText || column.id));
    }, {});
  }, [columns]);
  var _useDataGridDisplaySe = (0, _controls.useDataGridDisplaySelector)((0, _controls.checkOrDefaultToolBarDisplayOptions)(toolbarVisibility, 'showDisplaySelector'), gridStyleWithDefaults, _rowHeightsOptions),
    _useDataGridDisplaySe2 = _slicedToArray(_useDataGridDisplaySe, 3),
    displaySelector = _useDataGridDisplaySe2[0],
    gridStyles = _useDataGridDisplaySe2[1],
    rowHeightsOptions = _useDataGridDisplaySe2[2];

  /**
   * Column order & visibility
   */
  var _useDataGridColumnSel = (0, _controls.useDataGridColumnSelector)(columns, columnVisibility, (0, _controls.checkOrDefaultToolBarDisplayOptions)(toolbarVisibility, 'showColumnSelector'), displayValues),
    _useDataGridColumnSel2 = _slicedToArray(_useDataGridColumnSel, 4),
    columnSelector = _useDataGridColumnSel2[0],
    orderedVisibleColumns = _useDataGridColumnSel2[1],
    setVisibleColumns = _useDataGridColumnSel2[2],
    switchColumnPos = _useDataGridColumnSel2[3];
  var visibleColCount = (0, _react.useMemo)(function () {
    return orderedVisibleColumns.length + leadingControlColumns.length + trailingControlColumns.length;
  }, [orderedVisibleColumns, leadingControlColumns, trailingControlColumns]);
  var visibleRows = (0, _react.useMemo)(function () {
    return (0, _row_count.computeVisibleRows)({
      pagination: pagination,
      rowCount: rowCount
    });
  }, [pagination, rowCount]);
  var visibleRowCount = visibleRows.visibleRowCount;

  /**
   * Sorting
   */
  var columnSorting = (0, _controls.useDataGridColumnSorting)({
    sorting: sorting,
    columns: orderedVisibleColumns,
    displayValues: displayValues,
    schema: mergedSchema,
    schemaDetectors: allSchemaDetectors
  });
  var sortedContext = (0, _sorting.useSorting)({
    sorting: sorting,
    inMemory: inMemory,
    inMemoryValues: inMemoryValues,
    schema: mergedSchema,
    schemaDetectors: allSchemaDetectors,
    startRow: visibleRows.startRow
  });

  /**
   * Focus
   */
  var _useFocus = (0, _focus.useFocus)(),
    wrappingDivFocusProps = _useFocus.focusProps,
    onFocusUpdate = _useFocus.onFocusUpdate,
    focusedCell = _useFocus.focusedCell,
    setFocusedCell = _useFocus.setFocusedCell,
    setIsFocusedCellInView = _useFocus.setIsFocusedCellInView,
    focusFirstVisibleInteractiveCell = _useFocus.focusFirstVisibleInteractiveCell;
  var focusContext = (0, _react.useMemo)(function () {
    return {
      onFocusUpdate: onFocusUpdate,
      focusedCell: focusedCell,
      setFocusedCell: setFocusedCell,
      setIsFocusedCellInView: setIsFocusedCellInView,
      focusFirstVisibleInteractiveCell: focusFirstVisibleInteractiveCell
    };
  }, [onFocusUpdate, focusedCell, setFocusedCell, setIsFocusedCellInView, focusFirstVisibleInteractiveCell]);

  /**
   * Cell popover
   */
  var _useCellPopover = (0, _cell.useCellPopover)(),
    cellPopoverContext = _useCellPopover.cellPopoverContext,
    cellPopover = _useCellPopover.cellPopover;

  /**
   * Toolbar, keyboard shortcuts, & fullscreen
   */
  var showToolbar = !!toolbarVisibility;
  var _useDataGridKeyboardS = (0, _controls.useDataGridKeyboardShortcuts)(),
    keyboardShortcuts = _useDataGridKeyboardS.keyboardShortcuts;
  var _useDataGridFullScree = (0, _controls.useDataGridFullScreenSelector)(),
    isFullScreen = _useDataGridFullScree.isFullScreen,
    setIsFullScreen = _useDataGridFullScree.setIsFullScreen,
    fullScreenSelector = _useDataGridFullScree.fullScreenSelector,
    handleGridKeyDown = _useDataGridFullScree.handleGridKeyDown,
    fullScreenStyles = _useDataGridFullScree.fullScreenStyles;

  /**
   * Expose certain internal APIs as ref to consumer
   */
  (0, _ref.useImperativeGridRef)({
    ref: ref,
    gridRef: gridRef,
    setIsFullScreen: setIsFullScreen,
    focusContext: focusContext,
    cellPopoverContext: cellPopoverContext,
    sortedContext: sortedContext,
    pagination: pagination,
    rowCount: rowCount,
    visibleColCount: visibleColCount
  });

  /**
   * Classes
   */
  var classes = (0, _classnames.default)('euiDataGrid', fontSizesToClassMap[gridStyles.fontSize], bordersToClassMap[gridStyles.border], headerToClassMap[gridStyles.header], footerToClassMap[gridStyles.footer], rowHoverToClassMap[gridStyles.rowHover], cellPaddingsToClassMap[gridStyles.cellPadding], {
    'euiDataGrid--stripes': gridStyles.stripes
  }, {
    'euiDataGrid--stickyFooter': gridStyles.footer && gridStyles.stickyFooter
  }, _defineProperty({
    'euiDataGrid--fullScreen': isFullScreen
  }, fullScreenStyles, isFullScreen), {
    'euiDataGrid--noControls': !toolbarVisibility
  }, className);

  /**
   * Accessibility
   */
  var gridId = (0, _services.useGeneratedHtmlId)();
  var interactiveCellId = (0, _services.useGeneratedHtmlId)();
  var ariaLabelledById = (0, _services.useGeneratedHtmlId)();
  var ariaPage = pagination ? pagination.pageIndex + 1 : 1;
  var ariaPageCount = pagination !== null && pagination !== void 0 && pagination.pageSize ? Math.ceil(rowCount / pagination.pageSize) : 1;
  var ariaLabel = (0, _i18n.useEuiI18n)('euiDataGrid.ariaLabel', '{label}; Page {page} of {pageCount}.', {
    label: rest['aria-label'],
    page: ariaPage,
    pageCount: ariaPageCount
  });
  var ariaLabelledBy = (0, _i18n.useEuiI18n)('euiDataGrid.ariaLabelledBy', 'Page {page} of {pageCount}.', {
    page: ariaPage,
    pageCount: ariaPageCount
  });

  // extract aria-label and/or aria-labelledby from `rest`
  var gridAriaProps = {};
  if ('aria-label' in rest) {
    gridAriaProps['aria-label'] = pagination ? ariaLabel : rest['aria-label'];
    delete rest['aria-label'];
  }
  if ('aria-labelledby' in rest) {
    gridAriaProps['aria-labelledby'] = "".concat(rest['aria-labelledby'], " ").concat(pagination ? ariaLabelledById : '');
    delete rest['aria-labelledby'];
  }
  var onKeyDown = (0, _react.useCallback)(function (event) {
    var _gridItemsRendered$cu;
    (0, _focus.createKeyDownHandler)({
      gridElement: contentRef.current,
      visibleColCount: visibleColCount,
      visibleRowCount: visibleRowCount,
      visibleRowStartIndex: ((_gridItemsRendered$cu = gridItemsRendered.current) === null || _gridItemsRendered$cu === void 0 ? void 0 : _gridItemsRendered$cu.visibleRowStartIndex) || 0,
      rowCount: rowCount,
      pagination: pagination,
      hasFooter: !!renderFooterCellValue,
      focusContext: focusContext
    })(event);
  }, [focusContext, visibleColCount, visibleRowCount, rowCount, pagination, renderFooterCellValue]);
  var styles = (0, _services.useEuiMemoizedStyles)(_data_grid.euiDataGridStyles);
  var cssStyles = [styles.euiDataGrid, styles.cellPadding[gridStyles.cellPadding], styles.fontSize[gridStyles.fontSize], styles.borders[gridStyles.border]];
  return (0, _react2.jsx)(_focus.DataGridFocusContext.Provider, {
    value: focusContext
  }, (0, _react2.jsx)(_cell.DataGridCellPopoverContext.Provider, {
    value: cellPopoverContext
  }, (0, _react2.jsx)(_sorting.DataGridSortedContext.Provider, {
    value: sortedContext
  }, (0, _react2.jsx)(_focus_trap.EuiFocusTrap, {
    disabled: !isFullScreen,
    className: "euiDataGrid__focusWrap",
    css: styles.euiDataGrid__focusWrap
  }, (0, _react2.jsx)("div", _extends({
    css: cssStyles,
    className: classes,
    onKeyDown: handleGridKeyDown,
    style: isFullScreen ? undefined : {
      width: width,
      height: height
    },
    ref: setResizeRef
  }, rest), showToolbar && (0, _react2.jsx)(_controls.EuiDataGridToolbar, {
    gridWidth: gridWidth,
    minSizeForControls: minSizeForControls,
    toolbarVisibility: toolbarVisibility,
    isFullScreen: isFullScreen,
    fullScreenSelector: fullScreenSelector,
    keyboardShortcuts: keyboardShortcuts,
    displaySelector: displaySelector,
    columnSelector: columnSelector,
    columnSorting: columnSorting,
    renderCustomToolbar: renderCustomToolbar
  }), inMemory ? (0, _react2.jsx)(_in_memory.EuiDataGridInMemoryRenderer, {
    inMemory: inMemory,
    renderCellValue: renderCellValue,
    columns: columns,
    rowCount: inMemory.level === 'enhancements' ?
    // if `inMemory.level === enhancements` then we can only be sure the pagination's pageSize is available in memory
    (pagination === null || pagination === void 0 ? void 0 : pagination.pageSize) || rowCount :
    // otherwise, all of the data is present and usable
    rowCount,
    onCellRender: onCellRender
  }) : null, (0, _react2.jsx)("div", _extends({
    // eslint-disable-line jsx-a11y/interactive-supports-focus
    ref: contentRef,
    onKeyDown: onKeyDown,
    "data-test-subj": "euiDataGridBody",
    css: styles.euiDataGrid__content,
    className: "euiDataGrid__content",
    role: "grid",
    "aria-rowcount": rowCount,
    id: gridId
  }, wrappingDivFocusProps, gridAriaProps), (0, _react2.jsx)(_services.OverrideCopiedTabularContent, null, (0, _react2.jsx)(_body.EuiDataGridBody, {
    columns: orderedVisibleColumns,
    visibleColCount: visibleColCount,
    leadingControlColumns: leadingControlColumns,
    schema: mergedSchema,
    trailingControlColumns: trailingControlColumns,
    setVisibleColumns: setVisibleColumns,
    switchColumnPos: switchColumnPos,
    onColumnResize: onColumnResize,
    schemaDetectors: allSchemaDetectors,
    sorting: sorting,
    pagination: pagination,
    renderCellValue: renderCellValue,
    cellContext: cellContext,
    renderCellPopover: renderCellPopover,
    renderFooterCellValue: renderFooterCellValue,
    rowCount: rowCount,
    visibleRows: visibleRows,
    interactiveCellId: interactiveCellId,
    rowHeightsOptions: rowHeightsOptions,
    virtualizationOptions: virtualizationOptions || emptyVirtualizationOptions,
    isFullScreen: isFullScreen,
    gridStyles: gridStyles,
    gridWidth: gridWidth,
    gridRef: gridRef,
    gridItemsRendered: gridItemsRendered,
    wrapperRef: contentRef,
    renderCustomGridBody: renderCustomGridBody,
    canDragAndDropColumns: columnVisibility.canDragAndDropColumns
  }))), showPagination && props['aria-labelledby'] && (0, _react2.jsx)("p", {
    id: ariaLabelledById,
    hidden: true
  }, ariaLabelledBy), showPagination && (0, _react2.jsx)(_pagination2.EuiDataGridPagination, _extends({}, pagination, {
    rowCount: rowCount,
    controls: gridId,
    "aria-label": props['aria-label']
  })), (0, _react2.jsx)("p", {
    id: interactiveCellId,
    hidden: true
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiDataGrid.screenReaderNotice",
    default: "Cell contains interactive content."
  }))))), cellPopover));
}));
EuiDataGrid.displayName = 'EuiDataGrid';