"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRadio = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _icon = require("../../icon");
var _radio = require("./radio.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "id", "name", "checked", "label", "value", "onChange", "disabled", "autoFocus", "labelProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiRadio = exports.EuiRadio = function EuiRadio(_ref) {
  var className = _ref.className,
    id = _ref.id,
    name = _ref.name,
    checked = _ref.checked,
    label = _ref.label,
    value = _ref.value,
    onChange = _ref.onChange,
    disabled = _ref.disabled,
    autoFocus = _ref.autoFocus,
    labelProps = _ref.labelProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiRadio', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_radio.euiRadioStyles);
  var inputStyles = [styles.input.euiRadio__circle, !!label && styles.input.hasLabel, disabled ? checked ? styles.input.disabled.selected : styles.input.disabled.unselected : checked ? styles.input.enabled.selected : styles.input.enabled.unselected];
  var labelClasses = (0, _classnames.default)('euiRadio__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
  var labelStyles = [styles.label.euiRadio__label, disabled ? styles.label.disabled : styles.label.enabled, labelProps === null || labelProps === void 0 ? void 0 : labelProps.css];
  return (0, _react2.jsx)("div", _extends({
    css: styles.euiRadio,
    className: classes
  }, rest), (0, _react2.jsx)("div", {
    css: inputStyles,
    className: "euiRadio__circle"
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    css: styles.input.euiRadio__icon,
    type: "dot"
  }), (0, _react2.jsx)("input", {
    css: styles.input.euiRadio__input,
    className: "euiRadio__input",
    type: "radio",
    id: id,
    name: name,
    value: value,
    checked: checked,
    onChange: onChange,
    disabled: disabled,
    autoFocus: autoFocus
  })), label && (0, _react2.jsx)("label", _extends({}, labelProps, {
    css: labelStyles,
    className: labelClasses,
    htmlFor: id
  }), label));
};
EuiRadio.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  autoFocus: _propTypes.default.bool,
  name: _propTypes.default.string,
  value: _propTypes.default.string,
  checked: _propTypes.default.bool,
  disabled: _propTypes.default.bool,
  onChange: _propTypes.default.any.isRequired,
  /**
     * Object of props passed to the <label/>
     */
  /**
     * Object of props passed to the <label/>
     */
  /**
     * Object of props passed to the <label/>
     */
  labelProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  label: _propTypes.default.node,
  id: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string.isRequired])
};