"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiKeyPadMenuItemStyles = exports.euiKeyPadMenuItemChildStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _mixins = require("../../themes/amsterdam/global_styling/mixins");
var _accessibility = require("../accessibility");
var _key_pad_menu = require("./key_pad_menu.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiKeyPadMenuItemStyles = exports.euiKeyPadMenuItemStyles = function euiKeyPadMenuItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiKeyPadMenuVariabl = (0, _key_pad_menu.euiKeyPadMenuVariables)(euiThemeContext),
    euiKeyPadMenuSize = _euiKeyPadMenuVariabl.euiKeyPadMenuSize;
  return {
    euiKeyPadMenuItem: /*#__PURE__*/(0, _react.css)("display:block;padding:", euiTheme.size.xs, ";", (0, _global_styling.logicalSizeCSS)(euiKeyPadMenuSize), " border-radius:", euiTheme.border.radius.medium, ";color:", euiTheme.colors.text, ";", _global_styling.euiCanAnimate, "{transition:background-color ", euiTheme.animation.fast, " ease-in,box-shadow ", euiTheme.animation.fast, " ease-in;};label:euiKeyPadMenuItem;"),
    enabled: /*#__PURE__*/(0, _react.css)("&:hover,&:focus,&:focus-within{cursor:pointer;text-decoration:underline;", (0, _mixins.euiShadow)(euiThemeContext, 's'), " ", _global_styling.euiCanAnimate, "{.euiKeyPadMenuItem__icon{transform:translateY(0);}}}&:focus{background-color:", euiTheme.focus.backgroundColor, ";box-shadow:none;};label:enabled;"),
    selected: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.title, ";background-color:", euiTheme.focus.backgroundColor, ";&,&:hover,&:focus,&:focus-within{color:", euiTheme.colors.primaryText, ";};label:selected;"),
    disabled: {
      disabled: /*#__PURE__*/(0, _react.css)("cursor:not-allowed;color:", euiTheme.colors.disabledText, ";.euiKeyPadMenuItem__icon{filter:grayscale(100%);svg *{fill:", euiTheme.colors.disabledText, ";}};label:disabled;"),
      selected: /*#__PURE__*/(0, _react.css)("background-color:", (0, _services.transparentize)(euiTheme.colors.disabled, euiTheme.focus.transparency), ";;label:selected;")
    }
  };
};
var euiKeyPadMenuItemChildStyles = exports.euiKeyPadMenuItemChildStyles = function euiKeyPadMenuItemChildStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var topRightChildren = "\n    z-index: 3;\n    position: absolute;\n    ".concat((0, _global_styling.logicalCSS)('top', euiTheme.size.xs), "\n    ").concat((0, _global_styling.logicalCSS)('right', euiTheme.size.xs), "\n  ");
  return {
    euiKeyPadMenuItem__inner: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)('100%'), " display:flex;flex-direction:column;align-items:center;justify-content:center;position:relative;;label:euiKeyPadMenuItem__inner;"),
    euiKeyPadMenuItem__icon: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.m), " transform:translateY(2px);", _global_styling.euiCanAnimate, "{transition:transform ", euiTheme.animation.normal, " ", euiTheme.animation.bounce, ";};label:euiKeyPadMenuItem__icon;"),
    euiKeyPadMenuItem__label: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'xs'), " font-weight:", euiTheme.font.weight.semiBold, ";text-align:center;;label:euiKeyPadMenuItem__label;"),
    euiKeyPadMenuItem__betaBadge: /*#__PURE__*/(0, _react.css)(topRightChildren, ";;label:euiKeyPadMenuItem__betaBadge;"),
    euiKeyPadMenuItem__checkableInput: /*#__PURE__*/(0, _react.css)(topRightChildren, " transform:scale(.75);transform-origin:top right;&&{position:absolute;};label:euiKeyPadMenuItem__checkableInput;"),
    showCheckableInputOnInteraction: /*#__PURE__*/(0, _react.css)(".euiKeyPadMenuItem:not(:hover, :focus, :focus-within) &{", (0, _accessibility.euiScreenReaderOnly)(), ";};label:showCheckableInputOnInteraction;"),
    hideCheckableInput: /*#__PURE__*/(0, _react.css)((0, _accessibility.euiScreenReaderOnly)(), ";;label:hideCheckableInput;")
  };
};