"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiModalStyles = void 0;
var _react = require("@emotion/react");
var _mixins = require("../../themes/amsterdam/global_styling/mixins");
var _global_styling = require("../../global_styling");
var _form = require("../form/form.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiModalStyles = exports.euiModalStyles = function euiModalStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiModal: /*#__PURE__*/(0, _react.css)((0, _mixins.euiShadowXLarge)(euiThemeContext), " display:flex;flex-direction:column;max-block-size:75vh;position:relative;background-color:", euiTheme.colors.emptyShade, ";border-radius:", euiTheme.border.radius.medium, ";z-index:", euiTheme.levels.modal, ";min-inline-size:", (0, _form.euiFormVariables)(euiThemeContext).maxWidth, ";max-inline-size:calc(100vw - ", euiTheme.size.base, ");overflow:hidden;", _global_styling.euiCanAnimate, "{animation:", (0, _global_styling.euiAnimSlideInUp)(euiTheme.size.xxl), " ", euiTheme.animation.slow, " ", euiTheme.animation.bounce, ";}", (0, _global_styling.euiMaxBreakpoint)(euiThemeContext, 'm'), "{position:fixed;inset:0;border-radius:0;inline-size:100vw!important;min-inline-size:0!important;max-inline-size:none!important;max-block-size:100vh!important;}&:focus{outline:none;};label:euiModal;"),
    // Variants
    defaultMaxWidth: /*#__PURE__*/(0, _react.css)("max-inline-size:min(\n        ", euiTheme.breakpoint.m, "px,\n        calc(100vw - ", euiTheme.size.base, ")\n      );;label:defaultMaxWidth;"),
    confirmation: /*#__PURE__*/(0, _react.css)("min-inline-size:", (0, _form.euiFormVariables)(euiThemeContext).maxWidth, ";", (0, _global_styling.euiMaxBreakpoint)(euiThemeContext, 'm'), "{", (0, _mixins.euiShadowXLarge)(euiThemeContext, {
      reverse: true
    }), " inset-block-start:auto;};label:confirmation;"),
    euiModal__closeIcon: /*#__PURE__*/(0, _react.css)("position:absolute;inset-inline-end:", euiTheme.size.xs, ";inset-block-start:", euiTheme.size.xs, ";z-index:3;;label:euiModal__closeIcon;")
  };
};