"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSideNavClass = exports.EuiSideNav = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _button = require("../button");
var _i18n = require("../i18n");
var _services = require("../../services");
var _responsive = require("../responsive");
var _side_nav_heading = require("./_side_nav_heading");
var _side_nav_item = require("./side_nav_item");
var _side_nav = require("./side_nav.styles");
var _react2 = require("@emotion/react");
var _excluded = ["id", "name", "isSelected", "items", "icon", "onClick", "href", "forceOpen"],
  _excluded2 = ["className", "items", "toggleOpenOnMobile", "isOpenOnMobile", "mobileTitle", "mobileBreakpoints", "renderItem", "truncate", "heading", "headingProps", "theme"];
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiSideNavClass = exports.EuiSideNavClass = /*#__PURE__*/function (_Component) {
  function EuiSideNavClass() {
    var _this;
    _classCallCheck(this, EuiSideNavClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiSideNavClass, [].concat(args));
    _defineProperty(_this, "generateId", (0, _services.htmlIdGenerator)('euiSideNav'));
    _defineProperty(_this, "isItemOpen", function (item) {
      // The developer can force the item to be open.
      if (item.forceOpen) {
        return true;
      }

      // Of course a selected item is open.
      if (item.isSelected) {
        return true;
      }

      // The item has to be open if it has a child that's open.
      if (item.items) {
        return item.items.some(_this.isItemOpen);
      }
      return false;
    });
    _defineProperty(_this, "renderTree", function (items) {
      var depth = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var _this$props = _this.props,
        renderItem = _this$props.renderItem,
        truncate = _this$props.truncate;
      return items.map(function (item) {
        var id = item.id,
          name = item.name,
          isSelected = item.isSelected,
          childItems = item.items,
          icon = item.icon,
          onClick = item.onClick,
          href = item.href,
          forceOpen = item.forceOpen,
          rest = _objectWithoutProperties(item, _excluded);

        // Root items are always open.
        var isOpen = depth === 0 ? true : _this.isItemOpen(item);
        var renderedItems;
        if (childItems) {
          renderedItems = _this.renderTree(childItems, depth + 1);
        }

        // Act as an accordion only if item is not linked but has children (and not the root)
        var childrenOnly = depth > 0 && !onClick && !href && !!childItems;
        return (0, _react2.jsx)(_side_nav_item.EuiSideNavItem, _extends({
          isOpen: isOpen,
          isSelected: !childrenOnly && isSelected,
          isParent: !!childItems,
          icon: icon,
          onClick: onClick,
          href: href,
          items: renderedItems,
          key: id,
          depth: depth,
          renderItem: renderItem,
          truncate: truncate,
          childrenOnly: childrenOnly
        }, rest), name);
      });
    });
    return _this;
  }
  _inherits(EuiSideNavClass, _Component);
  return _createClass(EuiSideNavClass, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        className = _this$props2.className,
        items = _this$props2.items,
        toggleOpenOnMobile = _this$props2.toggleOpenOnMobile,
        isOpenOnMobile = _this$props2.isOpenOnMobile,
        mobileTitle = _this$props2.mobileTitle,
        mobileBreakpoints = _this$props2.mobileBreakpoints,
        renderItem = _this$props2.renderItem,
        truncate = _this$props2.truncate,
        heading = _this$props2.heading,
        headingProps = _this$props2.headingProps,
        theme = _this$props2.theme,
        rest = _objectWithoutProperties(_this$props2, _excluded2);
      var classes = (0, _classnames.default)('euiSideNav', className, {
        'euiSideNav-isOpenMobile': isOpenOnMobile
      });
      var styles = (0, _side_nav.euiSideNavMobileStyles)(theme);
      var contentClasses = (0, _classnames.default)('euiSideNav__content');
      var sideNavContentId = this.generateId('content');
      var mobileContentStyles = [styles.content.euiSideNav__mobileContent, isOpenOnMobile ? styles.content.open : styles.content.hidden];
      var hasMobileVersion = mobileBreakpoints && mobileBreakpoints.length > 0;
      var mobileToggleText = mobileTitle || heading;
      var mobileHeadingUnset = {
        marginBlockEnd: 0,
        label: 'mobile'
      };
      var headingId = (headingProps === null || headingProps === void 0 ? void 0 : headingProps.id) || this.generateId('heading');
      var headingScreenReaderOnly = !!(headingProps !== null && headingProps !== void 0 && headingProps.screenReaderOnly);
      return (0, _react2.jsx)(_react.default.Fragment, null, hasMobileVersion && (0, _react2.jsx)(_responsive.EuiShowFor, {
        sizes: mobileBreakpoints || 'none'
      }, (0, _react2.jsx)("nav", _extends({
        "aria-labelledby": headingId,
        className: classes
      }, rest), (0, _react2.jsx)(_side_nav_heading.EuiSideNavHeading, _extends({
        id: headingId
      }, headingProps, {
        screenReaderOnly: false,
        css: mobileHeadingUnset
      }), (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiSideNav.mobileToggleAriaLabel",
        default: "Toggle navigation"
      }, function (mobileToggleAriaLabel) {
        return (0, _react2.jsx)(_button.EuiButtonEmpty, {
          className: "euiSideNav__mobileToggle",
          css: styles.euiSideNav__mobileToggle,
          contentProps: {
            className: 'euiSideNav__mobileToggleContent',
            css: styles.euiSideNav__mobileToggleContent
          },
          onClick: toggleOpenOnMobile,
          iconType: "apps",
          iconSide: "right",
          "aria-controls": sideNavContentId,
          "aria-expanded": isOpenOnMobile,
          "aria-label": !mobileToggleText || headingScreenReaderOnly ? mobileToggleAriaLabel : undefined
        }, !headingScreenReaderOnly && mobileToggleText);
      })), (0, _react2.jsx)("div", {
        id: sideNavContentId,
        className: contentClasses,
        css: mobileContentStyles
      }, this.renderTree(items)))), (0, _react2.jsx)(_responsive.EuiHideFor, {
        sizes: mobileBreakpoints || 'none'
      }, (0, _react2.jsx)("nav", _extends({
        "aria-labelledby": heading ? headingId : undefined,
        className: classes
      }, rest), heading && (0, _react2.jsx)(_side_nav_heading.EuiSideNavHeading, _extends({
        id: headingId
      }, headingProps), heading), (0, _react2.jsx)("div", {
        id: sideNavContentId,
        className: contentClasses
      }, this.renderTree(items)))));
    }
  }]);
}(_react.Component);
_defineProperty(EuiSideNavClass, "defaultProps", {
  items: [],
  mobileBreakpoints: ['xs', 's']
});
EuiSideNavClass.propTypes = {
  /**
       * Class names to be merged into the final `className` property.
       */
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Creates an associated heading element and uses the same node as default for `mobileTitle`
       */
  heading: _propTypes.default.node,
  /**
       * Adds a couple extra #EuiSideNavHeading props and extends the props of EuiTitle that wraps the `heading`
       */
  headingProps: _propTypes.default.any,
  /**
       * When called, toggles visibility of the navigation menu at mobile responsive widths. The callback should set the `isOpenOnMobile` prop to actually toggle navigation visibility.
       */
  toggleOpenOnMobile: _propTypes.default.func,
  /**
       * If `true`, the navigation menu will be open at mobile device widths. Use in conjunction with the `toggleOpenOnMobile` prop.
       */
  isOpenOnMobile: _propTypes.default.bool,
  /**
       * A React node to render at mobile responsive widths, representing the title of this navigation menu.
       */
  mobileTitle: _propTypes.default.node,
  /**
       * Array of breakpoint names for when to show the mobile version.
       * Set to `undefined` to remove responsive behavior
       */
  mobileBreakpoints: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
  /**
       *  An array of #EuiSideNavItem objects. Lists navigation menu items.
       */
  items: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * A value that is passed to React as the `key` for this item
       */
    id: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]).isRequired,
    /**
       * If set to true it will force the item to display in an "open" state at all times.
       */
    forceOpen: _propTypes.default.bool,
    /**
       * Array containing additional item objects, representing nested children of this navigation item.
       */
    items: _propTypes.default.arrayOf(_propTypes.default.shape({
      /**
         * A value that is passed to React as the `key` for this item
         */
      id: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]).isRequired,
      /**
         * If set to true it will force the item to display in an "open" state at all times.
         */
      forceOpen: _propTypes.default.bool,
      /**
         * Array containing additional item objects, representing nested children of this navigation item.
         */
      items: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
      /**
         * React node representing the text to render for this item (usually a string will suffice).
         */
      name: _propTypes.default.node.isRequired,
      /**
         * Function overriding default rendering for this navigation item — when called, it should return a React node representing a replacement navigation item.
         */
      renderItem: _propTypes.default.func
    }).isRequired),
    /**
       * React node representing the text to render for this item (usually a string will suffice).
       */
    name: _propTypes.default.node.isRequired,
    /**
       * Function overriding default rendering for this navigation item — when called, it should return a React node representing a replacement navigation item.
       */
    renderItem: _propTypes.default.func
  }).isRequired).isRequired,
  /**
       * Overrides default navigation menu item rendering. When called, it should return a React node representing a replacement navigation item.
       */
  renderItem: _propTypes.default.func,
  /**
       * Truncates the text of all items to stick to a single line
       */
  truncate: _propTypes.default.bool
};
var EuiSideNav = exports.EuiSideNav = (0, _services.withEuiTheme)(EuiSideNavClass);