"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiToken = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _icon = require("../icon");
var _token_map = require("./token_map");
var _token_types = require("./token_types");
var _token = require("./token.styles");
var _react2 = require("@emotion/react");
var _excluded = ["iconType", "color", "fill", "shape", "size", "style", "className", "title", "aria-label", "aria-labelledby", "aria-describedby"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var isTokenColor = function isTokenColor(color) {
  return _token_types.COLORS.includes(color);
};
var EuiToken = exports.EuiToken = function EuiToken(_ref) {
  var iconType = _ref.iconType,
    color = _ref.color,
    fill = _ref.fill,
    shape = _ref.shape,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 's' : _ref$size,
    _ref$style = _ref.style,
    style = _ref$style === void 0 ? {} : _ref$style,
    className = _ref.className,
    title = _ref.title,
    ariaLabel = _ref['aria-label'],
    ariaLabelledby = _ref['aria-labelledby'],
    ariaDescribedby = _ref['aria-describedby'],
    rest = _objectWithoutProperties(_ref, _excluded);
  // Set the icon size to the same as the passed size
  // unless they passed `xs` which IconSize doesn't support
  var finalSize = size === 'xs' ? 's' : size;

  // When displaying at the small size, the token specific icons
  // should actually be displayed at medium size
  if (typeof iconType === 'string' && iconType.indexOf('token') === 0 && size === 's') {
    finalSize = 'm';
  }

  // If the iconType passed is one of the prefab token types,
  // grab its properties
  var tokenDefaults = typeof iconType === 'string' && iconType in _token_map.TOKEN_MAP ? _token_map.TOKEN_MAP[iconType] : {};
  var finalColor = color || tokenDefaults.color || 'gray';
  var finalShape = shape || tokenDefaults.shape || 'circle';
  var finalFill = fill || 'light';
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _token.euiTokenStyles)(euiTheme, finalFill);
  var cssStyles = [styles.euiToken, styles[finalShape], styles[finalFill], styles[size]];
  var finalStyle = style;
  if (isTokenColor(finalColor)) {
    cssStyles = [].concat(_toConsumableArray(cssStyles), [styles[finalColor]]);
  } else if (finalFill === 'none') {
    // When a custom HEX color is passed and the token doesn't have any fill (no background),
    // the icon gets that passed color
    cssStyles = [].concat(_toConsumableArray(cssStyles), [styles.customColor]);
    finalStyle = _objectSpread({
      color: finalColor
    }, style);
  } else {
    // When a custom HEX color is passed and the token has a fill (light or dark),
    // the background gets the custom color and the icon gets white or black based on the passed color
    // The fill='light' (lightened background) will always be overridden by fill='dark' (opaque background)
    // to better handle custom colors
    var isFinalColorDark = _services.isColorDark.apply(void 0, _toConsumableArray((0, _services.hexToRgb)(finalColor)));
    var lightOrDarkColor = isFinalColorDark ? '#FFFFFF' : '#000000';
    cssStyles = [].concat(_toConsumableArray(cssStyles), [styles.customColor]);
    finalFill = 'dark';
    finalStyle = _objectSpread({
      color: lightOrDarkColor,
      backgroundColor: finalColor
    }, style);
  }
  var classes = (0, _classnames.default)('euiToken', className);
  return (0, _react2.jsx)("span", _extends({
    className: classes,
    css: cssStyles,
    style: finalStyle
  }, rest), (0, _react2.jsx)(_icon.EuiIcon, {
    type: iconType,
    size: finalSize,
    title: title,
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledby,
    "aria-describedby": ariaDescribedby
  }));
};