"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiBorderColorCSS = exports.useEuiBackgroundColorCSS = exports.useEuiBackgroundColor = exports.euiBorderColor = exports.euiBackgroundColor = exports.BACKGROUND_COLORS = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var BACKGROUND_COLORS = exports.BACKGROUND_COLORS = ['transparent', 'plain', 'subdued', 'accent', 'primary', 'success', 'warning', 'danger'];
/**
 * @returns A single background color with optional alpha transparency
 */
var euiBackgroundColor = exports.euiBackgroundColor = function euiBackgroundColor(_ref, color) {
  var euiTheme = _ref.euiTheme,
    colorMode = _ref.colorMode;
  var _ref2 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
    method = _ref2.method;
  if (color === 'transparent') return 'transparent';
  if (method === 'transparent') {
    if (color === 'plain') {
      return (0, _services.transparentize)(euiTheme.colors.ghost, 0.2);
    } else if (color === 'subdued') {
      return colorMode === 'DARK' ? (0, _services.transparentize)(euiTheme.colors.lightShade, 0.4) : (0, _services.transparentize)(euiTheme.colors.lightShade, 0.2);
    } else {
      return (0, _services.transparentize)(euiTheme.colors[color], 0.1);
    }
  } else {
    var _tintOrShade = function _tintOrShade(color) {
      return colorMode === 'DARK' ? (0, _services.shade)(color, 0.8) : (0, _services.tint)(color, 0.9);
    };
    switch (color) {
      case 'plain':
        return euiTheme.colors.emptyShade;
      case 'subdued':
        return euiTheme.colors.body;
      default:
        return _tintOrShade(euiTheme.colors[color]);
    }
  }
};

/**
 * @returns An object map of color keys to color values, categorized by
 * opaque (default) vs transparency (hover/focus states) methods.
 * e.g. {
 *  opaque: { danger: '#000', success: '#fff', ... },
 *  transparent: { danger: 'rgba(0,0,0,0.1)', success: 'rgba(255,255,255,0.1)', ... },
 * }
 */
var _euiBackgroundColorMap = function _euiBackgroundColorMap(euiThemeContext) {
  return {
    opaque: BACKGROUND_COLORS.reduce(function (acc, color) {
      return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, color, euiBackgroundColor(euiThemeContext, color)));
    }, {}),
    transparent: BACKGROUND_COLORS.reduce(function (acc, color) {
      return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, color, euiBackgroundColor(euiThemeContext, color, {
        method: 'transparent'
      })));
    }, {})
  };
};
var useEuiBackgroundColor = exports.useEuiBackgroundColor = function useEuiBackgroundColor(color) {
  var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    method = _ref3.method;
  var backgroundColorMap = (0, _services.useEuiMemoizedStyles)(_euiBackgroundColorMap);
  return backgroundColorMap[method || 'opaque'][color];
};

/**
 * @returns An object map of color keys to CSS,
 * e.g. { danger: css``, success: css``, ... }
 */
var _euiBackgroundColors = function _euiBackgroundColors(euiThemeContext) {
  return BACKGROUND_COLORS.reduce(function (acc, color) {
    return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, color, /*#__PURE__*/(0, _react.css)("background-color:", euiBackgroundColor(euiThemeContext, color), ";label:", color, ";")));
  }, {});
};
var useEuiBackgroundColorCSS = exports.useEuiBackgroundColorCSS = function useEuiBackgroundColorCSS() {
  return (0, _services.useEuiMemoizedStyles)(_euiBackgroundColors);
};

/**
 * Border colors
 */

var euiBorderColor = exports.euiBorderColor = function euiBorderColor(_ref4, color) {
  var euiTheme = _ref4.euiTheme,
    colorMode = _ref4.colorMode;
  switch (color) {
    case 'transparent':
    case 'plain':
    case 'subdued':
      return euiTheme.border.color;
    case 'warning':
      return (0, _services.tintOrShade)(euiTheme.colors.warning, 0.4, colorMode);
    default:
      return (0, _services.tintOrShade)(euiTheme.colors[color], 0.6, colorMode);
  }
};

/**
 * @returns An object map of color keys to CSS,
 * e.g. { danger: css``, success: css``, ... }
 */
var _euiBorderColors = function _euiBorderColors(euiThemeContext) {
  return BACKGROUND_COLORS.reduce(function (acc, color) {
    return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, color, /*#__PURE__*/(0, _react.css)("border-color:", euiBorderColor(euiThemeContext, color), ";label:", color, ";")));
  }, {});
};
var useEuiBorderColorCSS = exports.useEuiBorderColorCSS = function useEuiBorderColorCSS() {
  return (0, _services.useEuiMemoizedStyles)(_euiBorderColors);
};