import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["destinationId", "fallbackDestination", "overrideLinkBehavior", "tabIndex", "position", "children", "className", "onClick"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback } from 'react';
import classNames from 'classnames';
import { isTabbable } from 'tabbable';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiButton } from '../../button/button';
import { EuiScreenReaderOnly } from '../screen_reader_only';
import { euiSkipLinkStyles } from './skip_link.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var POSITIONS = ['static', 'fixed', 'absolute'];
export var EuiSkipLink = function EuiSkipLink(_ref) {
  var destinationId = _ref.destinationId,
    _ref$fallbackDestinat = _ref.fallbackDestination,
    fallbackDestination = _ref$fallbackDestinat === void 0 ? 'main' : _ref$fallbackDestinat,
    overrideLinkBehavior = _ref.overrideLinkBehavior,
    tabIndex = _ref.tabIndex,
    _ref$position = _ref.position,
    position = _ref$position === void 0 ? 'static' : _ref$position,
    children = _ref.children,
    className = _ref.className,
    _onClick = _ref.onClick,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiSkipLink', className);
  var styles = useEuiMemoizedStyles(euiSkipLinkStyles);
  var cssStyles = [styles.euiSkipLink, position !== 'static' ? styles[position] : undefined];
  var onClick = useCallback(function (e) {
    var destinationEl = null;
    // Check if the destination ID is valid
    destinationEl = document.getElementById(destinationId);
    var hasValidId = !!destinationEl;
    // Check the fallback destination if not
    if (!destinationEl && fallbackDestination) {
      if (Array.isArray(fallbackDestination)) {
        for (var i = 0; i < fallbackDestination.length; i++) {
          destinationEl = document.querySelector(fallbackDestination[i]);
          if (destinationEl) break; // Stop once the first fallback has been found
        }
      } else {
        destinationEl = document.querySelector(fallbackDestination);
      }
    }
    if ((overrideLinkBehavior || !hasValidId) && destinationEl) {
      e.preventDefault();

      // Scroll to the top of the destination content only if it's ~mostly out of view
      var destinationY = destinationEl.getBoundingClientRect().top;
      var halfOfViewportHeight = window.innerHeight / 2;
      if (destinationY >= halfOfViewportHeight || window.scrollY >= destinationY + halfOfViewportHeight) {
        destinationEl.scrollIntoView();
      }

      // Ensure the destination content is focusable
      if (!isTabbable(destinationEl)) {
        destinationEl.tabIndex = -1;
        destinationEl.addEventListener('blur', function () {
          var _destinationEl;
          return (_destinationEl = destinationEl) === null || _destinationEl === void 0 ? void 0 : _destinationEl.removeAttribute('tabindex');
        }, {
          once: true
        });
      }
      destinationEl.focus({
        preventScroll: true
      }); // Scrolling is already handled above, and focus autoscroll behaves oddly on Chrome around fixed headers
    }
    _onClick === null || _onClick === void 0 || _onClick(e);
  }, [overrideLinkBehavior, destinationId, fallbackDestination, _onClick]);
  return ___EmotionJSX(EuiScreenReaderOnly, {
    showOnFocus: true
  }, ___EmotionJSX(EuiButton, _extends({
    css: cssStyles,
    className: classes,
    tabIndex: position === 'fixed' ? 0 : tabIndex,
    size: "s",
    fill: true,
    href: "#".concat(destinationId),
    onClick: onClick
  }, rest), children));
};