/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React from 'react';
import { EuiAccordion } from './index';
import { EuiPanel } from '../../components/panel';
import { htmlIdGenerator } from '../../services';
import { jsx as ___EmotionJSX } from "@emotion/react";
var baseProps = {
  buttonContent: 'Click me to toggle',
  id: htmlIdGenerator()(),
  initialIsOpen: false
};
var noArrow = {
  arrowDisplay: 'none'
};
var noArrowProps = Object.assign(baseProps, noArrow);
describe('EuiAccordion', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations when expanded', function () {
      cy.mount(___EmotionJSX(EuiAccordion, noArrowProps, ___EmotionJSX(EuiPanel, {
        color: "subdued"
      }, "Any content inside of ", ___EmotionJSX("strong", null, "EuiAccordion"), " will appear here.")));
      cy.get('button.euiAccordion__button').click();
      cy.checkAxe();
    });
  });
});