import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["children", "className", "id", "role", "element", "buttonElement", "buttonProps", "buttonClassName", "buttonContentClassName", "buttonContent", "arrowDisplay", "arrowProps", "extraAction", "paddingSize", "borders", "initialIsOpen", "forceState", "isLoading", "isLoadingMessage", "isDisabled", "theme"];
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import classNames from 'classnames';
import { htmlIdGenerator, withEuiTheme } from '../../services';
import { EuiLoadingSpinner } from '../loading';
import { EuiAccordionTrigger } from './accordion_trigger';
import { EuiAccordionChildren } from './accordion_children';
import { euiAccordionStyles } from './accordion.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var PADDING_SIZES = ['none', 'xs', 's', 'm', 'l', 'xl'];
export var EuiAccordionClass = /*#__PURE__*/function (_Component) {
  function EuiAccordionClass() {
    var _this;
    _classCallCheck(this, EuiAccordionClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiAccordionClass, [].concat(args));
    _defineProperty(_this, "state", {
      isOpen: _this.props.forceState ? _this.props.forceState === 'open' : _this.props.initialIsOpen
    });
    _defineProperty(_this, "onToggle", function () {
      var forceState = _this.props.forceState;
      if (forceState) {
        var _this$props$onToggle, _this$props;
        var nextState = !_this.isOpen;
        (_this$props$onToggle = (_this$props = _this.props).onToggle) === null || _this$props$onToggle === void 0 || _this$props$onToggle.call(_this$props, nextState);
      } else {
        _this.setState(function (prevState) {
          return {
            isOpen: !prevState.isOpen
          };
        }, function () {
          var _this$props$onToggle2, _this$props2;
          (_this$props$onToggle2 = (_this$props2 = _this.props).onToggle) === null || _this$props$onToggle2 === void 0 || _this$props$onToggle2.call(_this$props2, _this.state.isOpen);
        });
      }
    });
    _defineProperty(_this, "generatedId", htmlIdGenerator()());
    return _this;
  }
  _inherits(EuiAccordionClass, _Component);
  return _createClass(EuiAccordionClass, [{
    key: "isOpen",
    get: function get() {
      return this.props.forceState ? this.props.forceState === 'open' : this.state.isOpen;
    }
  }, {
    key: "render",
    value: function render() {
      var _buttonProps$id;
      var _this$props3 = this.props,
        children = _this$props3.children,
        className = _this$props3.className,
        id = _this$props3.id,
        role = _this$props3.role,
        _this$props3$element = _this$props3.element,
        Element = _this$props3$element === void 0 ? 'div' : _this$props3$element,
        buttonElement = _this$props3.buttonElement,
        buttonProps = _this$props3.buttonProps,
        buttonClassName = _this$props3.buttonClassName,
        buttonContentClassName = _this$props3.buttonContentClassName,
        buttonContent = _this$props3.buttonContent,
        arrowDisplay = _this$props3.arrowDisplay,
        arrowProps = _this$props3.arrowProps,
        extraAction = _this$props3.extraAction,
        paddingSize = _this$props3.paddingSize,
        borders = _this$props3.borders,
        initialIsOpen = _this$props3.initialIsOpen,
        forceState = _this$props3.forceState,
        isLoading = _this$props3.isLoading,
        isLoadingMessage = _this$props3.isLoadingMessage,
        isDisabled = _this$props3.isDisabled,
        theme = _this$props3.theme,
        rest = _objectWithoutProperties(_this$props3, _excluded);
      var classes = classNames('euiAccordion', {
        'euiAccordion-isOpen': this.isOpen
      }, className);
      var styles = euiAccordionStyles(theme);
      var cssStyles = [styles.euiAccordion, borders !== 'none' && styles.borders.borders, borders !== 'none' && styles.borders[borders]];
      var buttonId = (_buttonProps$id = buttonProps === null || buttonProps === void 0 ? void 0 : buttonProps.id) !== null && _buttonProps$id !== void 0 ? _buttonProps$id : this.generatedId;
      return ___EmotionJSX(Element, _extends({
        className: classes,
        css: cssStyles
      }, rest), ___EmotionJSX(EuiAccordionTrigger, {
        ariaControlsId: id,
        buttonId: buttonId
        // Force button element to be a legend if the element is a fieldset
        ,
        buttonElement: Element === 'fieldset' ? 'legend' : buttonElement,
        buttonClassName: buttonClassName,
        buttonContent: buttonContent,
        buttonContentClassName: buttonContentClassName,
        buttonProps: buttonProps,
        arrowProps: arrowProps,
        arrowDisplay: arrowDisplay,
        isDisabled: isDisabled,
        isOpen: this.isOpen,
        onToggle: this.onToggle,
        extraAction: isLoading ? ___EmotionJSX(EuiLoadingSpinner, null) : extraAction
      }), ___EmotionJSX(EuiAccordionChildren, {
        role: role,
        id: id,
        "aria-labelledby": buttonId,
        paddingSize: paddingSize,
        isLoading: isLoading,
        isLoadingMessage: isLoadingMessage,
        isOpen: this.isOpen
      }, children));
    }
  }]);
}(Component);
_defineProperty(EuiAccordionClass, "defaultProps", {
  initialIsOpen: false,
  borders: 'none',
  paddingSize: 'none',
  arrowDisplay: 'left',
  isLoading: false,
  isDisabled: false,
  isLoadingMessage: false,
  element: 'div',
  buttonElement: 'button',
  role: 'group'
});
export var EuiAccordion = withEuiTheme(EuiAccordionClass);