/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../global_styling';
export var euiAccordionStyles = function euiAccordionStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiAccordion: /*#__PURE__*/css(";label:euiAccordion;"),
    // Borders
    borders: {
      // Prevent border repeats
      borders: /*#__PURE__*/css("&+[class*='euiAccordion-borders']{", logicalCSS('border-top', 'none'), ";};label:borders;"),
      horizontal: /*#__PURE__*/css("border-block:", euiTheme.border.thin, ";;label:horizontal;"),
      all: /*#__PURE__*/css("border:", euiTheme.border.thin, ";;label:all;")
    }
  };
};